---
title: "API6 Media Methods"
metaTitle: "API6 Media Methods"
description: "API documentation"
---

It can be confusing about what Ampache does and what you need to do as an API client.

This page will document a few things about how playback works and what a client can expect from Ampache.

There are 2 binary data methods used for basic playback function:

* stream [json](https://ampache.org/api/api-json-methods#stream) and [xml](https://ampache.org/api/api-xml-methods#stream)
* download [json](https://ampache.org/api/api-json-methods#download) and [xml](https://ampache.org/api/api-xml-methods#download)

And there are 3 helper functions which allow you to manage playback history and state but do not return media.

* scrobble [json](https://ampache.org/api/api-json-methods#scrobble) and [xml](https://ampache.org/api/api-xml-methods#scrobble)
* record_play [json](https://ampache.org/api/api-json-methods#record_play) and [xml](https://ampache.org/api/api-xml-methods#record_play)
* player (Ampache 6.4.0+) [json](https://ampache.org/api/api-json-methods#player) and [xml](https://ampache.org/api/api-xml-methods#player)

Finally, you can also call the function now_playing to get details about what your user is currently stremaing. ([json](https://ampache.org/api/api-json-methods#now_playing) and [xml](https://ampache.org/api/api-xml-methods#now_playing))

## Explaining stream

Stream is used to play a song in the same way as the Webplayer.

The URL generated by stream will match the URL property in all song object repsonses

```JSON
"url": "https:\/\/music.com.au\/play\/index.php?ssid=cfj3f237d563f479f5223k23189dbb34&type=song&oid=115&uid=4&transcode_to=mp3&player=api&name=Chi.Otic%20-%20Are%20we%20going%20Crazy.mp3",
```

```XML
<url><![CDATA[https://music.com.au/play/index.php?ssid=cfj3f237d563f479f5223k23189dbb34&type=song&oid=54&uid=4&player=api&name=Synthetic%20-%20Red-GreenSmoke.mp3]]></url>
```

When you play a song; `stream` will:

* Record a play in the database which is recorded as a `stream`
* If you stream a new song too quickly the last song will be marked as `skip`
* Play count is incremented **UP** for a stream and back **DOWN** for a skip

It is very important to note that play history is compared to the client string. You can play a song on a browser, start a subsonic stream and then an api client stream right after and all 3 plays will be recorded as streams because they are different clients.

## Explaining download

A download is not considered a stream and does not go through the same stat checks.

When you `download` a song:

* Record the action as a `download`
* A download does not perform skip checks and ignores any recent play history
* Play counts are **NOT** incremented.

Download is used for caching files without the server thinking you've played 40 songs in 3 minutes.

Use the helper functions when playing downloads so you can informa the server when you actually play the files you download.

## The Ampache media playback process

Stat checks happen every time you call a `stream` or `download` **URL** (including part stream content-range calls)

e.g. `https://music.com.au/play/index.php?ssid=cfj3f237d563f479f5223k23189dbb34&type=song&oid=54&uid=4&player=api&name=Synthetic%20-%20Red-GreenSmoke.mp3`

When you use the API `stream`/`download` calls you are redirected to the play_url for the object. (Ampache calls them play_url's because they redirect to the `/play/` directory of the Ampache site)

The checks are there to stop duplicate stats being recorded or spam from repeated calls to the same URL.

If you are only using the `stream` action, Ampache will perform these checks for you.

If you cache your files locally with `download` or are using a different client you can use the helper functions to notify the server.

The Ampache config file also allows you configure what you consider to be a skip.

The `skip_timer` setting is what the server uses to decide whether the new play is going to override the last play.

```TXT
; Skip Timer Threshold
; This allows custom times to decide when a track is skipped
; Allows an integer to denote seconds, or a float to denote percentage
; POSSIBLE VALUES:
; 20 = 20 seconds.
; 0.3 = 30%
; DEFAULT: 20
;skip_timer = 20
```

Example, when using the default settings:

* You stream TRACK1
* You start to stream TRACK2 within the 10 seconds after TRACK1 started
* TRACK1 will change to a skip
* TRACK2 will be marked as your current `now_playing` track.

## Explaining scrobble

The `scrobble` and `record_play` methods are used for recording plays from saved information/data.

They're generally not used during playback as the `stream` action manages that process.

Scrobble uses parameters similar to how the Last.fm API works. (Which is why it's called scrobble.)

The idea is that if you are using a different player where you aren't able to get the object id you can scrobble to your Ampache server.

Scrobble is useful for plugins in different music players as an alternative to Last.fm or Libre.fm clients.

Example streaming plugin for rhythmbox written a few years ago. [rhythmbox-ampache-fm](https://github.com/lachlan-00/rhythmbox-ampache-fm)

## Explaining record_play

`record_play` does the same thing as `scrobble` but only requires the object id of the song instead of searching by string data.

This is useful with playing cached/downloaded songs from an API client that has access to the id.

If you are playing a downloaded file or a cached version of the file there is no `stream` or `download` action happening.

To tell the server what you're doing and to record a stream you would call record_play when you start a track.

Example:

* I cache song with the id 1240 using a `download` action
* I play the mp3 that was saved in my file cache
* That mp3 play is **NOT** a `stream` so I use record_play to set the stream in the database

## Explaining player

There is a new method for Ampache 6.4.0+ called player. [json](https://ampache.org/api/api-json-methods#player) and [xml](https://ampache.org/api/api-xml-methods#player)

Player is all about giving the server an active status of what the client is doing.

Player does a bit more than scrobble and record_play allowing me to do a few more things

* Support for more media types. (`podcast_episode` and `video` objects instead of just songs)
* Update `now_playing` data (remove on stop add it back on play)
* Shift last item play time on resumption of playback. (e.g. i pause a song at 20 seconds for a day and restart the song. the item will shift to NOW - 20 seconds as i haven't played any other song.)

It's similar to `scrobble`/`record_play` but the play/stop parameter gives me a bit more information about what you're doing

## Final thoughts

Hopefully that helps you understand what happens when you are streaming or downloiading form Ampache servers.

The idea is that you shouldn't have to think about anything when you `stream`. The server will do all the checks and updates for you.

When you `download`, you need to tell the server that you're playing a cached file.

Use `scrobble`/`record_play`/`player` to tell the server what you're doing.

Once you tell the server that you're playing with `stream`/`scrobble`/`record_play`/`player` methods the server will update the play status/history depending on your your data and current playback status.
