# Basic Configuration

## Configuring Ampache

Ampache strives to have sane defaults while providing the ability to change the configuration to meet a majority of people's needs. Ampache has two main locations for its config. The Config file located at ```/config/ampache.cfg.php``` and the Database preferences which are per user and modified via the web interface.

## Enable Debug Logging

Ampache has a very in depth logging system that requires a few config options to be configured before you can log.

* **debug** - Must be enabled so Ampache will write debugging information to the log.
* **debug_level** - Debug Level tells Ampache how much information you want to log. Level 3 is a good place for an average user.
* **log_path** - Folder to store the log (Default: "/var/log/ampache") Make sure you create the folder!
* **log_filename** - The name of the log file.

## Web Interface Configuration Options

This chapter will cover those in the Database as all options in the config file are well documented. You can find a current copy of the config file at [Github](https://github.com/ampache/ampache/raw/master/config/ampache.cfg.php.dist). As an admin you can change the permission level required to change any of the below preferences by modifying the _Level_ under Server Config for the preference in question.

### Interface

This section contains all of the preferences directly relating to the interface and how Ampache look or displays information to the user.

* **Popular Threshold** - This setting determines how many Top artists, Top Albums, Statistics, Recently Played Tracks are listed throughout the interface. Larger numbers can increase load times as more data has to be displayed on any one page. The Default is 10.
* **Language** - Ampache is translated into many different languages using GETTEXT, this is a list of all current translations. At any one moment some of the strings may be missing from any one of the translations. If you would like to fix a missing string or contribute a new language please read [Translating](https://github.com/ampache/ampache/blob/master/locale/base/TRANSLATIONS).

* **Theme** - This sets the theme for the current user. Ampache reads the /themes directory for a listing of all current installed themes. For more information on creating a theme see the [Themes](https://github.com/ampache/ampache/wiki/Themes).

* **Album Ellipse Threshold**, **Artist Ellipse Threshold** & **Title Ellipse Threshold** - These define how many letters, numbers, etc are displayed before a ellipse (...) is appended to the name and it is truncated. The truncation prevents interface distortion due to very long names.

* **Min Album Size** - This defines the smallest album that will be viewable when Browsing by Album. This can effectively hide a large portion of your music so be careful. The default value is 0.

* **Statistics Day Threshold** - This defines how many days are used to build the statistical displays in Ampache. Because the counts can get meaningless over the long periods of time, as it becomes impossible for new albums to ever make it near the top of the list you can limit the number of previous days used. The default value is 7, or one week.

* **of_the_moment** - This defines the amount of items Album/Video of the Moment will display. The default value is 6.

### Streaming

This section defines how Ampache streams your Music. Some options in here require additional configuration in the _/config/ampache.cfg.php_

* **Transcode Bitrate** - This defines the bitrate you would like Ampache to attempt to transcode at. The default is 32kbps.

* **Type of Playback** - This is one of the most important options. It appears on the menu as well as a drop down. This defines what Ampache is to do with the music that is to be streamed. The default is Stream, other options include Localplay, Democratic, Downsampling, Flash Player.

* **Transcoding** - This defines the transcoding behavior of Ampache.

### Playlists

* **Playlist Type** - This defines what type of Playlist is generated by Ampache on play. Different applications work better with different playlist types. The default is M3u. This option has no effect in XSPF Flash, Democratic and Localplay Playback types.

* **Playlist Method** - This defines the behavior of the Play and Add actions in Ampache.
  * Send on Add: The playlist is sent to the music player client each time a song/album/artist is added (not recommended for MPD)
  * Send and Clear on Add: Same as "Send on Add", but the playlist is cleared after being sent to the client.
  * Clear on Send: The playlist is sent to the music player client only with the "Play" button (radio tower icon), and then cleared.

### Options

This sections contains preferences for different features that can be enabled, disabled within Ampache.

* **Allow Downloads** - If this is enabled then you can download individual songs by clicking on their download link. If you have allow zip downloads in the config file this Option will also enable the Full Album, Full Artist, Selected, Playlist downloads. Default is disabled.

* **Localplay Access Level** - This defines what type of access you have to Localplay. Global tells Ampache to use the settings defined in Admin --> Config for this user and to ignore any locally set settings. Local tells Ampache to first check the local settings. If they do not exist then fall back on the global settings. Disabled prevents all access to Localplay, this is the default value.

### System

This section is only visible to Administrators and pertains to non-user options that often affect Ampache's operation as a whole, but are not deemed to be a security risk and thus are allowed to be in the Interface.

* **Website Title** - This defines the Website Title for your Ampache site, the default is "Ampache :: Pour l'Amour de la Musique" (Ampache :: For the Love of Music).

* **Lock Songs** - When enabled this prevents any two users from listening to the exact same song at the exact same time. This is a quasi legalize feature meant to simulate a shared pile of CD's in an office. Default is off

* **Forces Http play regardless of port** - This tells Ampache to always send HTTP in its playlists regardless of what the client is providing. This is enabled by default because a vast majority of players can not play HTTPS streams.

* **Non-Standard Http Port** - If defined this tells ampache to overwrite the current port and always use this port when building the stream URLs. Default 80

* **Allow Streaming**, **Allow Democratic Play**, **Allow Localplay Play** - These options control which play types are currently allowed. Streaming is the only one enalbed by default as all other options require additional configuration on the part of the administrator.

* **memory_cache** - This turns the caching mechanisms on or off, due to a large number of problems with people with very large catalogs and low memory settings this is off by default as it does significantly increase the memory requirements on larger catalogs. If you have the memory this can create a 2-3x speed improvement.

### Modules

This is a list of the current Localplay Modules and Plugins that you can enable and disable. These Plugins and Modules may add additional preferences to Ampache which are not defined here. Catalog Updates will not be performed if there are any non-official Plugins currently installed.

## Ampache User Levels

There are 5 user levels on Ampache. They are as follows.

* **Guest** - Read only access, guest users can look at the interface but they can not stream
* **User** - Standard user can modify its own settings, stream music and use ampache. Most users should be set to this level
* **Content Manager** - Added ability to make some additional setting changes not open to normal users
* **Catalog Manager** - Everything except for user management
* **Admin** - Everything
