// Copyright (c) 2021 - 2025, Ludvig Lundgren and the autobrr contributors.
// SPDX-License-Identifier: GPL-2.0-or-later

package migrations

import (
	"database/sql"

	"github.com/autobrr/autobrr/pkg/migrator"

	"github.com/dcarbone/zadapters/zstdlog"
	"github.com/rs/zerolog"
)

//go:generate go run generate_migrations.go

func SQLiteMigrations(db *sql.DB, logger zerolog.Logger) *migrator.Migrator {
	migrate := migrator.NewMigrate(
		db,
		migrator.WithEngine(migrator.EngineSQLite),
		migrator.WithEmbedFS(SchemaMigrationsSQLite, "sqlite"),
		migrator.WithSchemaFile("current_schema_sqlite.sql"),
		migrator.WithLogger(zstdlog.NewStdLoggerWithLevel(logger.With().Str("module", "database-migrations").Logger(), zerolog.InfoLevel)),
	)

	// Code below generated by go generate generate_migrations.go
	migrate.AddFileMigration("0_base_schema.sql")
	migrate.AddFileMigration("1_create_release_table.sql")
	migrate.AddFileMigration("2_create_release_action_status_and_migrate_push_status.sql")
	migrate.AddFileMigration("3_add_hdr_filter_columns.sql")
	migrate.AddFileMigration("4_rename_bitrate_to_quality_and_add_music_filter_columns.sql")
	migrate.AddFileMigration("5_add_media_filter_column.sql")
	migrate.AddFileMigration("6_add_filter_priority.sql")
	migrate.AddFileMigration("7_add_client_tls_skip_verify_and_rename_ssl_to_tls.sql")
	migrate.AddFileMigration("8_add_action_webhook_columns.sql")
	migrate.AddFileMigration("9_rebuild_action_table_with_proper_constraints.sql")
	migrate.AddFileMigration("10_rebuild_filter_indexer_table_with_proper_constraints.sql")
	migrate.AddFileMigration("11_rebuild_release_action_status_with_cascade_delete.sql")
	migrate.AddFileMigration("12_create_notification_table.sql")
	migrate.AddFileMigration("13_create_feed_and_feed_cache_tables.sql")
	migrate.AddFileMigration("14_add_indexer_implementation_column.sql")
	migrate.AddFileMigration("15_clean_release_columns_and_add_origins_to_filter.sql")
	migrate.AddFileMigration("16_add_match_except_other_filter_columns.sql")
	migrate.AddFileMigration("17_rename_group_back_to_release_group.sql")
	migrate.AddFileMigration("18_add_action_reannounce_columns.sql")
	migrate.AddFileMigration("19_add_action_limit_ratio_and_seed_time.sql")
	migrate.AddFileMigration("20_add_filter_max_downloads_and_rebuild_release_with_filter_id.sql")
	migrate.AddFileMigration("21_create_database_indexes.sql")
	migrate.AddFileMigration("22_add_client_and_filter_columns_to_release_action_status.sql")
	migrate.AddFileMigration("23_add_external_script_and_webhook_filter_columns.sql")
	migrate.AddFileMigration("24_add_action_skip_hash_check_and_content_layout.sql")
	migrate.AddFileMigration("25_add_filter_except_origins.sql")
	migrate.AddFileMigration("26_create_api_key_table.sql")
	migrate.AddFileMigration("27_add_feed_timeout.sql")
	migrate.AddFileMigration("28_add_feed_max_age_last_run_and_cookie.sql")
	migrate.AddFileMigration("29_add_filter_release_tags_matching.sql")
	migrate.AddFileMigration("30_rebuild_irc_network_with_sasl_auth.sql")
	migrate.AddFileMigration("31_add_indexer_base_url.sql")
	migrate.AddFileMigration("32_add_filter_smart_episode.sql")
	migrate.AddFileMigration("33_add_filter_language_matching.sql")
	migrate.AddFileMigration("34_rebuild_release_action_status_with_filter_id_and_populate.sql")
	migrate.AddFileMigration("35_add_release_info_and_download_urls.sql")
	migrate.AddFileMigration("36_add_filter_tags_match_logic_and_set_defaults.sql")
	migrate.AddFileMigration("37_add_notification_priority.sql")
	migrate.AddFileMigration("38_add_notification_topic.sql")
	migrate.AddFileMigration("39_add_filter_description_matching.sql")
	migrate.AddFileMigration("40_rebuild_release_action_status_with_action_id.sql")
	migrate.AddFileMigration("41_add_irc_bouncer_support.sql")
	migrate.AddFileMigration("42_create_filter_external_and_migrate_from_filter.sql")
	migrate.AddFileMigration("43_rebuild_feed_cache_with_feed_id_foreign_key.sql")
	migrate.AddFileMigration("44_add_action_external_client_id.sql")
	migrate.AddFileMigration("45_add_filter_external_webhook_retry_columns.sql")
	migrate.AddFileMigration("46_rename_external_webhook_retry_columns.sql")
	migrate.AddFileMigration("47_remove_webhook_retry_max_jitter_seconds.sql")
	migrate.AddFileMigration("48_add_irc_network_bot_mode.sql")
	migrate.AddFileMigration("49_rebuild_feed_without_categories_column.sql")
	migrate.AddFileMigration("50_add_action_priority.sql")
	migrate.AddFileMigration("51_add_action_external_client.sql")
	migrate.AddFileMigration("52_add_filter_seeders_leechers_limits.sql")
	migrate.AddFileMigration("53_update_nebulance_irc_server.sql")
	migrate.AddFileMigration("54_update_animebytes_irc_server_and_name.sql")
	migrate.AddFileMigration("55_add_action_first_last_piece_priority.sql")
	migrate.AddFileMigration("56_add_indexer_identifier_external_and_populate.sql")
	migrate.AddFileMigration("57_add_release_and_filter_month_day_columns.sql")
	migrate.AddFileMigration("58_create_proxy_table_and_add_proxy_support.sql")
	migrate.AddFileMigration("59_update_fuzer_indexer_base_url.sql")
	migrate.AddFileMigration("60_create_filter_and_database_indexes.sql")
	migrate.AddFileMigration("61_update_fuzer_irc_server.sql")
	migrate.AddFileMigration("62_update_multiple_irc_servers.sql")
	migrate.AddFileMigration("63_update_redacted_indexer_base_url.sql")
	migrate.AddFileMigration("64_update_seedpool_irc_port_and_tls.sql")
	migrate.AddFileMigration("65_add_announce_type_support.sql")
	migrate.AddFileMigration("66_create_list_tables.sql")
	migrate.AddFileMigration("67_add_filter_record_label_matching.sql")
	migrate.AddFileMigration("68_create_release_profile_duplicate_and_add_release_fields.sql")
	migrate.AddFileMigration("69_update_ptp_announce_channel_name.sql")
	migrate.AddFileMigration("70_update_ptp_invite_command.sql")
	migrate.AddFileMigration("71_set_default_announce_types_for_filters.sql")
	migrate.AddFileMigration("72_add_list_skip_clean_sanitize.sql")
	migrate.AddFileMigration("73_update_rocket_hd_auth_and_channel_passwords.sql")
	migrate.AddFileMigration("74_create_sessions_table.sql")
	migrate.AddFileMigration("75_migrate_ulcx_network.sql")
	migrate.AddFileMigration("76_fix_macro_time.sql")
	migrate.AddFileMigration("77_action_add_download_path.sql")
	migrate.AddFileMigration("78_list_include_year.sql")
	migrate.AddFileMigration("79_filter_external_on_error.sql")
	migrate.AddFileMigration("80_filter_notifications.sql")
	migrate.AddFileMigration("81_indexers_update_revtt_domain.sql")
	migrate.AddFileMigration("82_duplicate_profiles_add_hybrid.sql")
	// Code above generated by go generate generate_migrations.go

	return migrate
}
