// Code generated by go generate; DO NOT EDIT.
// This file was generated by internal/codegen/generate_torrent_filter.go

package qbittorrent

import (
	"cmp"
	"slices"
)

// applyTorrentSorting applies sorting to torrents based on the sort field
func applyTorrentSorting(torrents []Torrent, sortField string, reverse bool) {
	if sortField == "" {
		return
	}

	slices.SortFunc(torrents, func(a, b Torrent) int {
		result := cmp.Or(
			func() int {
				switch sortField {
				case "added_on":
					return cmp.Compare(a.AddedOn, b.AddedOn)
				case "amount_left":
					return cmp.Compare(a.AmountLeft, b.AmountLeft)
				case "auto_tmm":
					if a.AutoManaged != b.AutoManaged {
						if a.AutoManaged {
							return 1
						}
						return -1
					}
					return 0
				case "availability":
					return cmp.Compare(a.Availability, b.Availability)
				case "category":
					return cmp.Compare(a.Category, b.Category)
				case "completed":
					return cmp.Compare(a.Completed, b.Completed)
				case "completion_on":
					return cmp.Compare(a.CompletionOn, b.CompletionOn)
				case "content_path":
					return cmp.Compare(a.ContentPath, b.ContentPath)
				case "dl_limit":
					return cmp.Compare(a.DlLimit, b.DlLimit)
				case "dlspeed":
					return cmp.Compare(a.DlSpeed, b.DlSpeed)
				case "download_path":
					return cmp.Compare(a.DownloadPath, b.DownloadPath)
				case "downloaded":
					return cmp.Compare(a.Downloaded, b.Downloaded)
				case "downloaded_session":
					return cmp.Compare(a.DownloadedSession, b.DownloadedSession)
				case "eta":
					return cmp.Compare(a.ETA, b.ETA)
				case "f_l_piece_prio":
					if a.FirstLastPiecePrio != b.FirstLastPiecePrio {
						if a.FirstLastPiecePrio {
							return 1
						}
						return -1
					}
					return 0
				case "force_start":
					if a.ForceStart != b.ForceStart {
						if a.ForceStart {
							return 1
						}
						return -1
					}
					return 0
				case "hash":
					return cmp.Compare(a.Hash, b.Hash)
				case "infohash_v1":
					return cmp.Compare(a.InfohashV1, b.InfohashV1)
				case "infohash_v2":
					return cmp.Compare(a.InfohashV2, b.InfohashV2)
				case "last_activity":
					return cmp.Compare(a.LastActivity, b.LastActivity)
				case "magnet_uri":
					return cmp.Compare(a.MagnetURI, b.MagnetURI)
				case "max_ratio":
					return cmp.Compare(a.MaxRatio, b.MaxRatio)
				case "max_seeding_time":
					return cmp.Compare(a.MaxSeedingTime, b.MaxSeedingTime)
				case "name":
					return cmp.Compare(a.Name, b.Name)
				case "num_complete":
					return cmp.Compare(a.NumComplete, b.NumComplete)
				case "num_incomplete":
					return cmp.Compare(a.NumIncomplete, b.NumIncomplete)
				case "num_leechs":
					return cmp.Compare(a.NumLeechs, b.NumLeechs)
				case "num_seeds":
					return cmp.Compare(a.NumSeeds, b.NumSeeds)
				case "priority":
					return cmp.Compare(a.Priority, b.Priority)
				case "progress":
					return cmp.Compare(a.Progress, b.Progress)
				case "ratio":
					return cmp.Compare(a.Ratio, b.Ratio)
				case "ratio_limit":
					return cmp.Compare(a.RatioLimit, b.RatioLimit)
				case "save_path":
					return cmp.Compare(a.SavePath, b.SavePath)
				case "seeding_time":
					return cmp.Compare(a.SeedingTime, b.SeedingTime)
				case "seeding_time_limit":
					return cmp.Compare(a.SeedingTimeLimit, b.SeedingTimeLimit)
				case "seen_complete":
					return cmp.Compare(a.SeenComplete, b.SeenComplete)
				case "seq_dl":
					if a.SequentialDownload != b.SequentialDownload {
						if a.SequentialDownload {
							return 1
						}
						return -1
					}
					return 0
				case "size":
					return cmp.Compare(a.Size, b.Size)
				case "state":
					return cmp.Compare(string(a.State), string(b.State))
				case "super_seeding":
					if a.SuperSeeding != b.SuperSeeding {
						if a.SuperSeeding {
							return 1
						}
						return -1
					}
					return 0
				case "tags":
					return cmp.Compare(a.Tags, b.Tags)
				case "time_active":
					return cmp.Compare(a.TimeActive, b.TimeActive)
				case "total_size":
					return cmp.Compare(a.TotalSize, b.TotalSize)
				case "tracker":
					return cmp.Compare(a.Tracker, b.Tracker)
				case "trackers_count":
					return cmp.Compare(a.TrackersCount, b.TrackersCount)
				case "up_limit":
					return cmp.Compare(a.UpLimit, b.UpLimit)
				case "uploaded":
					return cmp.Compare(a.Uploaded, b.Uploaded)
				case "uploaded_session":
					return cmp.Compare(a.UploadedSession, b.UploadedSession)
				case "upspeed":
					return cmp.Compare(a.UpSpeed, b.UpSpeed)
				default:
					return cmp.Compare(a.Name, b.Name) // default to name
				}
			}(),
			cmp.Compare(a.Hash, b.Hash), // secondary sort by hash for stability
		)

		if reverse {
			return -result
		}
		return result
	})
}
