/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.domain.model;

import com.github.f4b6a3.tsid.TsidCreator;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.NotBlank;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.model.AgeRestriction;
import org.gotson.komga.domain.model.AllowExclude;
import org.gotson.komga.domain.model.Auditable;
import org.gotson.komga.domain.model.ContentRestrictions;
import org.gotson.komga.domain.model.Library;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B\u0081\u0001\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u0006\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010)\u001a\u00020\u0006J\u000e\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u0003J\u000e\u0010*\u001a\u00020\u00062\u0006\u0010,\u001a\u00020-J\t\u0010.\u001a\u00020\u0003H\u00c6\u0003J\t\u0010/\u001a\u00020\u0003H\u00c6\u0003J\t\u00100\u001a\u00020\u0011H\u00c6\u0003J\t\u00101\u001a\u00020\u0011H\u00c6\u0003J\t\u00102\u001a\u00020\u0003H\u00c6\u0003J\t\u00103\u001a\u00020\u0006H\u00c6\u0003J\t\u00104\u001a\u00020\u0006H\u00c6\u0003J\t\u00105\u001a\u00020\u0006H\u00c6\u0003J\t\u00106\u001a\u00020\u0006H\u00c6\u0003J\u000f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u00c6\u0003J\t\u00108\u001a\u00020\u0006H\u00c6\u0003J\t\u00109\u001a\u00020\u000eH\u00c6\u0003J\u0087\u0001\u0010:\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u00062\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\b\b\u0002\u0010\f\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00032\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0011H\u00c6\u0001J\u0013\u0010;\u001a\u00020\u00062\b\u0010<\u001a\u0004\u0018\u00010=H\u00d6\u0003J\u001e\u0010>\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010?2\u000e\u0010@\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010?J\t\u0010A\u001a\u00020BH\u00d6\u0001J'\u0010C\u001a\u00020\u00062\n\b\u0002\u0010D\u001a\u0004\u0018\u00010B2\u000e\b\u0002\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u00a2\u0006\u0002\u0010FJ\b\u0010G\u001a\u00020\u0003H\u0016R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0014\u0010\u0012\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001eR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001eR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001eR!\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b#\u0010$R\u0011\u0010\f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001eR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010$\u00a8\u0006H"}, d2={"Lorg/gotson/komga/domain/model/KomgaUser;", "Lorg/gotson/komga/domain/model/Auditable;", "email", "", "password", "roleAdmin", "", "roleFileDownload", "rolePageStreaming", "roleKoboSync", "sharedLibrariesIds", "", "sharedAllLibraries", "restrictions", "Lorg/gotson/komga/domain/model/ContentRestrictions;", "id", "createdDate", "Ljava/time/LocalDateTime;", "lastModifiedDate", "(Ljava/lang/String;Ljava/lang/String;ZZZZLjava/util/Set;ZLorg/gotson/komga/domain/model/ContentRestrictions;Ljava/lang/String;Ljava/time/LocalDateTime;Ljava/time/LocalDateTime;)V", "getCreatedDate", "()Ljava/time/LocalDateTime;", "getEmail", "()Ljava/lang/String;", "getId", "getLastModifiedDate", "getPassword", "getRestrictions", "()Lorg/gotson/komga/domain/model/ContentRestrictions;", "getRoleAdmin", "()Z", "getRoleFileDownload", "getRoleKoboSync", "getRolePageStreaming", "roles", "getRoles", "()Ljava/util/Set;", "roles$delegate", "Lkotlin/Lazy;", "getSharedAllLibraries", "getSharedLibrariesIds", "canAccessAllLibraries", "canAccessLibrary", "libraryId", "library", "Lorg/gotson/komga/domain/model/Library;", "component1", "component10", "component11", "component12", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "", "getAuthorizedLibraryIds", "", "libraryIds", "hashCode", "", "isContentAllowed", "ageRating", "sharingLabels", "(Ljava/lang/Integer;Ljava/util/Set;)Z", "toString", "komga"})
@SourceDebugExtension(value={"SMAP\nKomgaUser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KomgaUser.kt\norg/gotson/komga/domain/model/KomgaUser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n1747#2,3:116\n1747#2,3:119\n*S KotlinDebug\n*F\n+ 1 KomgaUser.kt\norg/gotson/komga/domain/model/KomgaUser\n*L\n66#1:116,3\n69#1:119,3\n*E\n"})
public final class KomgaUser
implements Auditable {
    @NotNull
    private final String email;
    @NotNull
    private final String password;
    private final boolean roleAdmin;
    private final boolean roleFileDownload;
    private final boolean rolePageStreaming;
    private final boolean roleKoboSync;
    @NotNull
    private final Set<String> sharedLibrariesIds;
    private final boolean sharedAllLibraries;
    @NotNull
    private final ContentRestrictions restrictions;
    @NotNull
    private final String id;
    @NotNull
    private final LocalDateTime createdDate;
    @NotNull
    private final LocalDateTime lastModifiedDate;
    @NotNull
    private final transient Lazy roles$delegate;

    public KomgaUser(@Email(regexp=".+@.+\\..+") @NotBlank @NotNull String email, @NotBlank @NotNull String password, boolean roleAdmin, boolean roleFileDownload, boolean rolePageStreaming, boolean roleKoboSync, @NotNull Set<String> sharedLibrariesIds, boolean sharedAllLibraries, @NotNull ContentRestrictions restrictions, @NotNull String id, @NotNull LocalDateTime createdDate, @NotNull LocalDateTime lastModifiedDate) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter(sharedLibrariesIds, (String)"sharedLibrariesIds");
        Intrinsics.checkNotNullParameter((Object)restrictions, (String)"restrictions");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)createdDate, (String)"createdDate");
        Intrinsics.checkNotNullParameter((Object)lastModifiedDate, (String)"lastModifiedDate");
        this.email = email;
        this.password = password;
        this.roleAdmin = roleAdmin;
        this.roleFileDownload = roleFileDownload;
        this.rolePageStreaming = rolePageStreaming;
        this.roleKoboSync = roleKoboSync;
        this.sharedLibrariesIds = sharedLibrariesIds;
        this.sharedAllLibraries = sharedAllLibraries;
        this.restrictions = restrictions;
        this.id = id;
        this.createdDate = createdDate;
        this.lastModifiedDate = lastModifiedDate;
        this.roles$delegate = LazyKt.lazy((Function0)((Function0)new /* Unavailable Anonymous Inner Class!! */));
    }

    public /* synthetic */ KomgaUser(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, Set set, boolean bl5, ContentRestrictions contentRestrictions, String string3, LocalDateTime localDateTime, LocalDateTime localDateTime2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x10) != 0) {
            bl3 = true;
        }
        if ((n & 0x20) != 0) {
            bl4 = false;
        }
        if ((n & 0x40) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 0x80) != 0) {
            bl5 = true;
        }
        if ((n & 0x100) != 0) {
            contentRestrictions = new ContentRestrictions(null, null, null, 7, null);
        }
        if ((n & 0x200) != 0) {
            String string4 = TsidCreator.getTsid256().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
            string3 = string4;
        }
        if ((n & 0x400) != 0) {
            LocalDateTime localDateTime3 = LocalDateTime.now();
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime3, (String)"now(...)");
            localDateTime = localDateTime3;
        }
        if ((n & 0x800) != 0) {
            localDateTime2 = localDateTime;
        }
        this(string, string2, bl, bl2, bl3, bl4, set, bl5, contentRestrictions, string3, localDateTime, localDateTime2);
    }

    @NotNull
    public final String getEmail() {
        return this.email;
    }

    @NotNull
    public final String getPassword() {
        return this.password;
    }

    public final boolean getRoleAdmin() {
        return this.roleAdmin;
    }

    public final boolean getRoleFileDownload() {
        return this.roleFileDownload;
    }

    public final boolean getRolePageStreaming() {
        return this.rolePageStreaming;
    }

    public final boolean getRoleKoboSync() {
        return this.roleKoboSync;
    }

    @NotNull
    public final Set<String> getSharedLibrariesIds() {
        return this.sharedLibrariesIds;
    }

    public final boolean getSharedAllLibraries() {
        return this.sharedAllLibraries;
    }

    @NotNull
    public final ContentRestrictions getRestrictions() {
        return this.restrictions;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public LocalDateTime getCreatedDate() {
        return this.createdDate;
    }

    @NotNull
    public LocalDateTime getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    @NotNull
    public final Set<String> getRoles() {
        Lazy lazy = this.roles$delegate;
        return (Set)lazy.getValue();
    }

    @Nullable
    public final Collection<String> getAuthorizedLibraryIds(@Nullable Collection<String> libraryIds) {
        Collection collection;
        if (!this.canAccessAllLibraries() && libraryIds != null) {
            collection = CollectionsKt.intersect((Iterable)libraryIds, (Iterable)this.sharedLibrariesIds);
        } else if (!this.canAccessAllLibraries() && libraryIds == null) {
            collection = this.sharedLibrariesIds;
        } else {
            collection = libraryIds;
            if (collection == null) {
                collection = null;
            }
        }
        return collection;
    }

    public final boolean canAccessAllLibraries() {
        return this.sharedAllLibraries || this.roleAdmin;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canAccessLibrary(@NotNull String libraryId) {
        String it;
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        if (this.canAccessAllLibraries()) return true;
        Iterable $this$any$iv = this.sharedLibrariesIds;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!Intrinsics.areEqual((Object)it, (Object)libraryId));
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canAccessLibrary(@NotNull Library library) {
        String it;
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        if (this.canAccessAllLibraries()) return true;
        Iterable $this$any$iv = this.sharedLibrariesIds;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!Intrinsics.areEqual((Object)it, (Object)library.getId()));
        return true;
    }

    public final boolean isContentAllowed(@Nullable Integer ageRating, @NotNull Set<String> sharingLabels) {
        boolean ageDenied;
        boolean allowed;
        Intrinsics.checkNotNullParameter(sharingLabels, (String)"sharingLabels");
        Set labels = CollectionsKt.toSet((Iterable)LanguageUtilsKt.lowerNotBlank((Iterable)sharingLabels));
        AgeRestriction ageRestriction = this.restrictions.getAgeRestriction();
        Boolean ageAllowed = (ageRestriction != null ? ageRestriction.getRestriction() : null) == AllowExclude.ALLOW_ONLY ? Boolean.valueOf(ageRating != null && ageRating <= this.restrictions.getAgeRestriction().getAge()) : null;
        Boolean labelAllowed = !((Collection)this.restrictions.getLabelsAllow()).isEmpty() ? Boolean.valueOf(!((Collection)CollectionsKt.intersect((Iterable)this.restrictions.getLabelsAllow(), (Iterable)labels)).isEmpty()) : null;
        boolean bl = ageAllowed == null ? !Intrinsics.areEqual(labelAllowed, (Object)false) : (labelAllowed == null ? !Intrinsics.areEqual((Object)ageAllowed, (Object)false) : (allowed = !Intrinsics.areEqual((Object)ageAllowed, (Object)false) || !Intrinsics.areEqual((Object)labelAllowed, (Object)false)));
        if (!allowed) {
            return false;
        }
        AgeRestriction ageRestriction2 = this.restrictions.getAgeRestriction();
        boolean bl2 = (ageRestriction2 != null ? ageRestriction2.getRestriction() : null) == AllowExclude.EXCLUDE ? ageRating != null && ageRating >= this.restrictions.getAgeRestriction().getAge() : (ageDenied = false);
        boolean labelDenied = !((Collection)this.restrictions.getLabelsExclude()).isEmpty() ? !((Collection)CollectionsKt.intersect((Iterable)this.restrictions.getLabelsExclude(), (Iterable)labels)).isEmpty() : false;
        return !ageDenied && !labelDenied;
    }

    public static /* synthetic */ boolean isContentAllowed$default(KomgaUser komgaUser, Integer n, Set set, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        if ((n2 & 2) != 0) {
            set = SetsKt.emptySet();
        }
        return komgaUser.isContentAllowed(n, set);
    }

    @NotNull
    public String toString() {
        return "KomgaUser(email='" + this.email + "', roleAdmin=" + this.roleAdmin + ", roleFileDownload=" + this.roleFileDownload + ", rolePageStreaming=" + this.rolePageStreaming + ", roleKoboSync=" + this.roleKoboSync + ", sharedLibrariesIds=" + this.sharedLibrariesIds + ", sharedAllLibraries=" + this.sharedAllLibraries + ", restrictions=" + this.restrictions + ", id='" + this.id + "', createdDate=" + this.getCreatedDate() + ", lastModifiedDate=" + this.getLastModifiedDate() + ")";
    }

    @NotNull
    public final String component1() {
        return this.email;
    }

    @NotNull
    public final String component2() {
        return this.password;
    }

    public final boolean component3() {
        return this.roleAdmin;
    }

    public final boolean component4() {
        return this.roleFileDownload;
    }

    public final boolean component5() {
        return this.rolePageStreaming;
    }

    public final boolean component6() {
        return this.roleKoboSync;
    }

    @NotNull
    public final Set<String> component7() {
        return this.sharedLibrariesIds;
    }

    public final boolean component8() {
        return this.sharedAllLibraries;
    }

    @NotNull
    public final ContentRestrictions component9() {
        return this.restrictions;
    }

    @NotNull
    public final String component10() {
        return this.id;
    }

    @NotNull
    public final LocalDateTime component11() {
        return this.createdDate;
    }

    @NotNull
    public final LocalDateTime component12() {
        return this.lastModifiedDate;
    }

    @NotNull
    public final KomgaUser copy(@Email(regexp=".+@.+\\..+") @NotBlank @NotNull String email, @NotBlank @NotNull String password, boolean roleAdmin, boolean roleFileDownload, boolean rolePageStreaming, boolean roleKoboSync, @NotNull Set<String> sharedLibrariesIds, boolean sharedAllLibraries, @NotNull ContentRestrictions restrictions, @NotNull String id, @NotNull LocalDateTime createdDate, @NotNull LocalDateTime lastModifiedDate) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter(sharedLibrariesIds, (String)"sharedLibrariesIds");
        Intrinsics.checkNotNullParameter((Object)restrictions, (String)"restrictions");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)createdDate, (String)"createdDate");
        Intrinsics.checkNotNullParameter((Object)lastModifiedDate, (String)"lastModifiedDate");
        return new KomgaUser(email, password, roleAdmin, roleFileDownload, rolePageStreaming, roleKoboSync, sharedLibrariesIds, sharedAllLibraries, restrictions, id, createdDate, lastModifiedDate);
    }

    public static /* synthetic */ KomgaUser copy$default(KomgaUser komgaUser, String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, Set set, boolean bl5, ContentRestrictions contentRestrictions, String string3, LocalDateTime localDateTime, LocalDateTime localDateTime2, int n, Object object) {
        if ((n & 1) != 0) {
            string = komgaUser.email;
        }
        if ((n & 2) != 0) {
            string2 = komgaUser.password;
        }
        if ((n & 4) != 0) {
            bl = komgaUser.roleAdmin;
        }
        if ((n & 8) != 0) {
            bl2 = komgaUser.roleFileDownload;
        }
        if ((n & 0x10) != 0) {
            bl3 = komgaUser.rolePageStreaming;
        }
        if ((n & 0x20) != 0) {
            bl4 = komgaUser.roleKoboSync;
        }
        if ((n & 0x40) != 0) {
            set = komgaUser.sharedLibrariesIds;
        }
        if ((n & 0x80) != 0) {
            bl5 = komgaUser.sharedAllLibraries;
        }
        if ((n & 0x100) != 0) {
            contentRestrictions = komgaUser.restrictions;
        }
        if ((n & 0x200) != 0) {
            string3 = komgaUser.id;
        }
        if ((n & 0x400) != 0) {
            localDateTime = komgaUser.createdDate;
        }
        if ((n & 0x800) != 0) {
            localDateTime2 = komgaUser.lastModifiedDate;
        }
        return komgaUser.copy(string, string2, bl, bl2, bl3, bl4, set, bl5, contentRestrictions, string3, localDateTime, localDateTime2);
    }

    public int hashCode() {
        int result2 = this.email.hashCode();
        result2 = result2 * 31 + this.password.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.roleAdmin);
        result2 = result2 * 31 + Boolean.hashCode(this.roleFileDownload);
        result2 = result2 * 31 + Boolean.hashCode(this.rolePageStreaming);
        result2 = result2 * 31 + Boolean.hashCode(this.roleKoboSync);
        result2 = result2 * 31 + ((Object)this.sharedLibrariesIds).hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.sharedAllLibraries);
        result2 = result2 * 31 + this.restrictions.hashCode();
        result2 = result2 * 31 + this.id.hashCode();
        result2 = result2 * 31 + this.createdDate.hashCode();
        result2 = result2 * 31 + this.lastModifiedDate.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KomgaUser)) {
            return false;
        }
        KomgaUser komgaUser = (KomgaUser)other;
        if (!Intrinsics.areEqual((Object)this.email, (Object)komgaUser.email)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.password, (Object)komgaUser.password)) {
            return false;
        }
        if (this.roleAdmin != komgaUser.roleAdmin) {
            return false;
        }
        if (this.roleFileDownload != komgaUser.roleFileDownload) {
            return false;
        }
        if (this.rolePageStreaming != komgaUser.rolePageStreaming) {
            return false;
        }
        if (this.roleKoboSync != komgaUser.roleKoboSync) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sharedLibrariesIds, (Object)komgaUser.sharedLibrariesIds)) {
            return false;
        }
        if (this.sharedAllLibraries != komgaUser.sharedAllLibraries) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.restrictions, (Object)komgaUser.restrictions)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.id, (Object)komgaUser.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.createdDate, (Object)komgaUser.createdDate)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.lastModifiedDate, (Object)komgaUser.lastModifiedDate);
    }
}

