/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.domain.service;

import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.gotson.komga.application.tasks.TaskEmitter;
import org.gotson.komga.domain.model.Book;
import org.gotson.komga.domain.model.BookMetadata;
import org.gotson.komga.domain.model.CodedException;
import org.gotson.komga.domain.model.CopyMode;
import org.gotson.komga.domain.model.DomainEvent;
import org.gotson.komga.domain.model.ExceptionsKt;
import org.gotson.komga.domain.model.HistoricalEvent;
import org.gotson.komga.domain.model.Library;
import org.gotson.komga.domain.model.Media;
import org.gotson.komga.domain.model.PathContainedInPath;
import org.gotson.komga.domain.model.ReadList;
import org.gotson.komga.domain.model.ReadProgress;
import org.gotson.komga.domain.model.Series;
import org.gotson.komga.domain.model.Sidecar;
import org.gotson.komga.domain.persistence.BookMetadataRepository;
import org.gotson.komga.domain.persistence.BookRepository;
import org.gotson.komga.domain.persistence.HistoricalEventRepository;
import org.gotson.komga.domain.persistence.LibraryRepository;
import org.gotson.komga.domain.persistence.MediaRepository;
import org.gotson.komga.domain.persistence.ReadListRepository;
import org.gotson.komga.domain.persistence.ReadProgressRepository;
import org.gotson.komga.domain.persistence.SidecarRepository;
import org.gotson.komga.domain.service.BookImporter;
import org.gotson.komga.domain.service.BookImporterKt;
import org.gotson.komga.domain.service.BookLifecycle;
import org.gotson.komga.domain.service.FileSystemScanner;
import org.gotson.komga.domain.service.FileSystemScannerKt;
import org.gotson.komga.domain.service.SeriesLifecycle;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001Bm\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001cJ8\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010&H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/gotson/komga/domain/service/BookImporter;", "", "bookLifecycle", "Lorg/gotson/komga/domain/service/BookLifecycle;", "fileSystemScanner", "Lorg/gotson/komga/domain/service/FileSystemScanner;", "seriesLifecycle", "Lorg/gotson/komga/domain/service/SeriesLifecycle;", "bookRepository", "Lorg/gotson/komga/domain/persistence/BookRepository;", "mediaRepository", "Lorg/gotson/komga/domain/persistence/MediaRepository;", "metadataRepository", "Lorg/gotson/komga/domain/persistence/BookMetadataRepository;", "readProgressRepository", "Lorg/gotson/komga/domain/persistence/ReadProgressRepository;", "readListRepository", "Lorg/gotson/komga/domain/persistence/ReadListRepository;", "libraryRepository", "Lorg/gotson/komga/domain/persistence/LibraryRepository;", "sidecarRepository", "Lorg/gotson/komga/domain/persistence/SidecarRepository;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "taskEmitter", "Lorg/gotson/komga/application/tasks/TaskEmitter;", "historicalEventRepository", "Lorg/gotson/komga/domain/persistence/HistoricalEventRepository;", "(Lorg/gotson/komga/domain/service/BookLifecycle;Lorg/gotson/komga/domain/service/FileSystemScanner;Lorg/gotson/komga/domain/service/SeriesLifecycle;Lorg/gotson/komga/domain/persistence/BookRepository;Lorg/gotson/komga/domain/persistence/MediaRepository;Lorg/gotson/komga/domain/persistence/BookMetadataRepository;Lorg/gotson/komga/domain/persistence/ReadProgressRepository;Lorg/gotson/komga/domain/persistence/ReadListRepository;Lorg/gotson/komga/domain/persistence/LibraryRepository;Lorg/gotson/komga/domain/persistence/SidecarRepository;Lorg/springframework/context/ApplicationEventPublisher;Lorg/gotson/komga/application/tasks/TaskEmitter;Lorg/gotson/komga/domain/persistence/HistoricalEventRepository;)V", "importBook", "Lorg/gotson/komga/domain/model/Book;", "sourceFile", "Ljava/nio/file/Path;", "series", "Lorg/gotson/komga/domain/model/Series;", "copyMode", "Lorg/gotson/komga/domain/model/CopyMode;", "destinationName", "", "upgradeBookId", "komga"})
@SourceDebugExtension(value={"SMAP\nBookImporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookImporter.kt\norg/gotson/komga/domain/service/BookImporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,246:1\n1855#2,2:247\n1271#2,2:249\n1285#2,4:251\n1855#2,2:255\n1549#2:265\n1620#2,3:266\n1855#2,2:269\n1855#2:271\n1549#2:272\n1620#2,3:273\n1856#2:276\n215#3,2:257\n215#3,2:259\n215#3,2:261\n215#3,2:263\n215#3,2:277\n*S KotlinDebug\n*F\n+ 1 BookImporter.kt\norg/gotson/komga/domain/service/BookImporter\n*L\n74#1:247,2\n86#1:249,2\n86#1:251,4\n121#1:255,2\n196#1:265\n196#1:266,3\n197#1:269,2\n201#1:271\n204#1:272\n204#1:273,3\n201#1:276\n132#1:257,2\n143#1:259,2\n155#1:261,2\n165#1:263,2\n221#1:277,2\n*E\n"})
public class BookImporter {
    @NotNull
    private final BookLifecycle bookLifecycle;
    @NotNull
    private final FileSystemScanner fileSystemScanner;
    @NotNull
    private final SeriesLifecycle seriesLifecycle;
    @NotNull
    private final BookRepository bookRepository;
    @NotNull
    private final MediaRepository mediaRepository;
    @NotNull
    private final BookMetadataRepository metadataRepository;
    @NotNull
    private final ReadProgressRepository readProgressRepository;
    @NotNull
    private final ReadListRepository readListRepository;
    @NotNull
    private final LibraryRepository libraryRepository;
    @NotNull
    private final SidecarRepository sidecarRepository;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private final TaskEmitter taskEmitter;
    @NotNull
    private final HistoricalEventRepository historicalEventRepository;

    public BookImporter(@NotNull BookLifecycle bookLifecycle, @NotNull FileSystemScanner fileSystemScanner, @NotNull SeriesLifecycle seriesLifecycle, @NotNull BookRepository bookRepository, @NotNull MediaRepository mediaRepository, @NotNull BookMetadataRepository metadataRepository, @NotNull ReadProgressRepository readProgressRepository, @NotNull ReadListRepository readListRepository, @NotNull LibraryRepository libraryRepository, @NotNull SidecarRepository sidecarRepository, @NotNull ApplicationEventPublisher eventPublisher, @NotNull TaskEmitter taskEmitter, @NotNull HistoricalEventRepository historicalEventRepository) {
        Intrinsics.checkNotNullParameter((Object)bookLifecycle, (String)"bookLifecycle");
        Intrinsics.checkNotNullParameter((Object)fileSystemScanner, (String)"fileSystemScanner");
        Intrinsics.checkNotNullParameter((Object)seriesLifecycle, (String)"seriesLifecycle");
        Intrinsics.checkNotNullParameter((Object)bookRepository, (String)"bookRepository");
        Intrinsics.checkNotNullParameter((Object)mediaRepository, (String)"mediaRepository");
        Intrinsics.checkNotNullParameter((Object)metadataRepository, (String)"metadataRepository");
        Intrinsics.checkNotNullParameter((Object)readProgressRepository, (String)"readProgressRepository");
        Intrinsics.checkNotNullParameter((Object)readListRepository, (String)"readListRepository");
        Intrinsics.checkNotNullParameter((Object)libraryRepository, (String)"libraryRepository");
        Intrinsics.checkNotNullParameter((Object)sidecarRepository, (String)"sidecarRepository");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)taskEmitter, (String)"taskEmitter");
        Intrinsics.checkNotNullParameter((Object)historicalEventRepository, (String)"historicalEventRepository");
        this.bookLifecycle = bookLifecycle;
        this.fileSystemScanner = fileSystemScanner;
        this.seriesLifecycle = seriesLifecycle;
        this.bookRepository = bookRepository;
        this.mediaRepository = mediaRepository;
        this.metadataRepository = metadataRepository;
        this.readProgressRepository = readProgressRepository;
        this.readListRepository = readListRepository;
        this.libraryRepository = libraryRepository;
        this.sidecarRepository = sidecarRepository;
        this.eventPublisher = eventPublisher;
        this.taskEmitter = taskEmitter;
        this.historicalEventRepository = historicalEventRepository;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Book importBook(@NotNull Path sourceFile, @NotNull Series series, @NotNull CopyMode copyMode, @Nullable String destinationName, @Nullable String upgradeBookId) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)series, (String)"series");
        Intrinsics.checkNotNullParameter((Object)copyMode, (String)"copyMode");
        try {
            Object $this$forEach$iv;
            Book e32;
            CopyOption[] copyOptionArray;
            CopyOption[] copyOptionArray2;
            LinkOption[] linkOptionArray;
            Object sidecar;
            Book book;
            Object object;
            String string;
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.notExists(sourceFile, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                throw ExceptionsKt.withCode((Exception)new FileNotFoundException("File not found: " + sourceFile), (String)"ERR_1018");
            }
            if (series.getOneshot()) {
                throw new IllegalArgumentException("Destination series is oneshot");
            }
            Iterable $this$forEach$iv2 = this.libraryRepository.findAll();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv2) {
                Library library = (Library)element$iv;
                boolean bl = false;
                if (!sourceFile.startsWith(library.getPath())) continue;
                throw new PathContainedInPath("Cannot import file that is part of an existing library", "ERR_1019");
            }
            Path path2 = series.getPath();
            if (destinationName != null) {
                Path path3 = Paths.get(destinationName + "." + PathsKt.getExtension((Path)sourceFile), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
                string = PathsKt.getName((Path)path3);
            } else {
                string = PathsKt.getName((Path)sourceFile);
            }
            Path destFile = path2.resolve(string);
            Iterable $this$associateWith$iv = this.fileSystemScanner.scanBookSidecars(sourceFile);
            boolean $i$f$associateWith = false;
            Book result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                String string2;
                Sidecar sidecar2 = (Sidecar)element$iv$iv;
                Object t = element$iv$iv;
                object = (Map)result$iv;
                boolean bl = false;
                Path path4 = series.getPath();
                if (destinationName != null) {
                    URI uRI = sidecar2.getUrl().toURI();
                    Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
                    Path path5 = Paths.get(uRI);
                    Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"get(...)");
                    string2 = StringsKt.replace((String)PathsKt.getName((Path)path5), (String)PathsKt.getNameWithoutExtension((Path)sourceFile), (String)destinationName, (boolean)true);
                } else {
                    URI uRI = sidecar2.getUrl().toURI();
                    Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
                    Path path6 = Paths.get(uRI);
                    Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"get(...)");
                    string2 = PathsKt.getName((Path)path6);
                }
                Path path7 = path4.resolve(string2);
                object.put(t, path7);
            }
            Map sidecars = (Map)result$iv;
            if (upgradeBookId != null) {
                Book book2 = this.bookRepository.findByIdOrNull(upgradeBookId);
                if (book2 != null) {
                    Book it = result$iv = book2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getSeriesId(), (Object)series.getId())) {
                        throw ExceptionsKt.withCode((Exception)new IllegalArgumentException("Book to upgrade (" + upgradeBookId + ") does not belong to series: " + series), (String)"ERR_1020");
                    }
                    book = result$iv;
                } else {
                    book = null;
                }
            } else {
                book = null;
            }
            Book bookToUpgrade = book;
            boolean deletedUpgradedFile = false;
            Book book3 = bookToUpgrade;
            if ((book3 != null ? book3.getPath() : null) != null && Intrinsics.areEqual((Object)destFile, (Object)bookToUpgrade.getPath())) {
                BookImporterKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
                try {
                    Files.delete(bookToUpgrade.getPath());
                    this.historicalEventRepository.insert((HistoricalEvent)new HistoricalEvent.BookFileDeleted(bookToUpgrade, "File was deleted to import an upgrade"));
                    deletedUpgradedFile = true;
                }
                catch (NoSuchFileException e2) {
                    BookImporterKt.access$getLogger$p().warn((Function0)new /* Unavailable Anonymous Inner Class!! */);
                }
            } else {
                Intrinsics.checkNotNull((Object)destFile);
                LinkOption[] linkOptionArray3 = new LinkOption[]{};
                if (Files.exists(destFile, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
                    throw ExceptionsKt.withCode((Exception)new FileAlreadyExistsException("Destination file already exists: " + destFile), (String)"ERR_1021");
                }
            }
            Book book4 = bookToUpgrade;
            if ((book4 != null ? book4.getPath() : null) != null) {
                Iterable $this$forEach$iv3 = this.fileSystemScanner.scanBookSidecars(bookToUpgrade.getPath());
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv3) {
                    Path sidecarPath;
                    sidecar = (Sidecar)element$iv;
                    boolean bl = false;
                    URI uRI = sidecar.getUrl().toURI();
                    Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)Paths.get(uRI), (String)"get(...)");
                    BookImporterKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
                    Files.deleteIfExists(sidecarPath);
                }
            }
            switch (WhenMappings.$EnumSwitchMapping$0[copyMode.ordinal()]) {
                case 1: {
                    CopyOption[] copyOptionArray3;
                    Object element$iv;
                    BookImporterKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
                    Path bl = sourceFile;
                    Intrinsics.checkNotNull((Object)destFile);
                    element$iv = destFile;
                    CopyOption[] sidecarPath = new CopyOption[]{};
                    Intrinsics.checkNotNullExpressionValue((Object)Files.move(bl, element$iv, Arrays.copyOf(sidecarPath, sidecarPath.length)), (String)"move(...)");
                    Map $this$forEach$iv4 = sidecars;
                    boolean $i$f$forEach3 = false;
                    sidecar = $this$forEach$iv4.entrySet().iterator();
                    while (sidecar.hasNext()) {
                        Path sourcePath;
                        Map.Entry entry;
                        Map.Entry it = entry = (Map.Entry)sidecar.next();
                        boolean bl2 = false;
                        URI uRI = ((Sidecar)it.getKey()).getUrl().toURI();
                        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)Paths.get(uRI), (String)"get(...)");
                        boolean bl3 = false;
                        BookImporterKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
                        linkOptionArray = sourcePath;
                        Object v = it.getValue();
                        Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                        copyOptionArray2 = (Path)v;
                        copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                        copyOptionArray3 = copyOptionArray;
                        Intrinsics.checkNotNullExpressionValue((Object)Files.move((Path)linkOptionArray, (Path)copyOptionArray2, Arrays.copyOf(copyOptionArray3, copyOptionArray3.length)), (String)"move(...)");
                    }
                    break;
                }
                case 2: {
                    CopyOption[] copyOptionArray3;
                    BookImporterKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
                    Path $this$forEach$iv4 = sourceFile;
                    Intrinsics.checkNotNull((Object)destFile);
                    Path $i$f$forEach3 = destFile;
                    Object it = new CopyOption[]{};
                    Intrinsics.checkNotNullExpressionValue((Object)Files.copy($this$forEach$iv4, $i$f$forEach3, Arrays.copyOf(it, ((CopyOption[])it).length)), (String)"copy(...)");
                    Map $this$forEach$iv3 = sidecars;
                    boolean $i$f$forEach2 = false;
                    for (Map.Entry entry : $this$forEach$iv3.entrySet()) {
                        Path sourcePath;
                        it = entry;
                        boolean bl = false;
                        URI uRI = ((Sidecar)it.getKey()).getUrl().toURI();
                        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)Paths.get(uRI), (String)"get(...)");
                        boolean bl4 = false;
                        BookImporterKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
                        linkOptionArray = sourcePath;
                        Object v = it.getValue();
                        Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                        copyOptionArray2 = (Path)v;
                        copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                        copyOptionArray3 = copyOptionArray;
                        Intrinsics.checkNotNullExpressionValue((Object)Files.copy((Path)linkOptionArray, (Path)copyOptionArray2, Arrays.copyOf(copyOptionArray3, copyOptionArray3.length)), (String)"copy(...)");
                    }
                    break;
                }
                case 3: {
                    try {
                        BookImporterKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
                        Files.createLink(destFile, sourceFile);
                        Map $this$forEach$iv5 = sidecars;
                        boolean $i$f$forEach42 = false;
                        sidecar = $this$forEach$iv5.entrySet().iterator();
                        while (sidecar.hasNext()) {
                            Path sourcePath;
                            Map.Entry entry;
                            Map.Entry it = entry = (Map.Entry)sidecar.next();
                            boolean bl = false;
                            URI uRI = ((Sidecar)it.getKey()).getUrl().toURI();
                            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
                            Intrinsics.checkNotNullExpressionValue((Object)Paths.get(uRI), (String)"get(...)");
                            boolean bl5 = false;
                            BookImporterKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
                            Object v = it.getValue();
                            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                            Files.deleteIfExists((Path)v);
                            Files.createLink((Path)it.getValue(), sourcePath);
                        }
                        break;
                    }
                    catch (Exception e32) {
                        BookImporterKt.access$getLogger$p().warn((Throwable)e32, (Function0)importBook.11.INSTANCE);
                        Path $i$f$forEach42 = sourceFile;
                        Intrinsics.checkNotNull((Object)destFile);
                        sidecar = destFile;
                        CopyOption[] bl = new CopyOption[]{};
                        Intrinsics.checkNotNullExpressionValue((Object)Files.copy($i$f$forEach42, (Path)sidecar, Arrays.copyOf(bl, bl.length)), (String)"copy(...)");
                        Map $this$forEach$iv6 = sidecars;
                        boolean $i$f$forEach5 = false;
                        Iterator iterator = $this$forEach$iv6.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Path bl5;
                            Map.Entry element$iv3;
                            Map.Entry it = element$iv3 = iterator.next();
                            boolean bl6 = false;
                            URI uRI = ((Sidecar)it.getKey()).getUrl().toURI();
                            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
                            Intrinsics.checkNotNullExpressionValue((Object)Paths.get(uRI), (String)"get(...)");
                            Object v = it.getValue();
                            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                            linkOptionArray = (LinkOption[])v;
                            copyOptionArray2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                            copyOptionArray = copyOptionArray2;
                            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(bl5, (Path)linkOptionArray, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(...)");
                        }
                        break;
                    }
                }
            }
            Intrinsics.checkNotNull((Object)destFile);
            Object $i$f$forEach2 = this.fileSystemScanner.scanFile(destFile);
            if ($i$f$forEach2 == null || (e32 = Book.copy$default((Book)$i$f$forEach2, null, null, null, (long)0L, null, (int)0, null, null, (String)series.getLibraryId(), null, (boolean)false, null, null, (int)7935, null)) == null) {
                throw ExceptionsKt.withCode((Exception)new IllegalStateException("Newly imported book could not be scanned: " + destFile), (String)"ERR_1022");
            }
            Book importedBook = e32;
            this.seriesLifecycle.addBooks(series, (Collection)CollectionsKt.listOf((Object)importedBook));
            if (bookToUpgrade != null) {
                Object element$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Media it = this.mediaRepository.findById(bookToUpgrade.getId());
                boolean bl = false;
                String $i$f$forEach5 = importedBook.getId();
                Media.Status status = Media.Status.OUTDATED;
                this.mediaRepository.update(Media.copy$default((Media)it, (Media.Status)status, null, null, (int)0, null, null, null, (String)$i$f$forEach5, (boolean)false, (boolean)false, null, null, (int)3966, null));
                it = this.metadataRepository.findById(bookToUpgrade.getId());
                boolean $i$a$-let-BookImporter$importBook$1532 = false;
                this.metadataRepository.update(BookMetadata.copy$default((BookMetadata)it, null, null, null, (float)0.0f, null, null, null, null, null, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (String)importedBook.getId(), null, null, (int)0x1BFFFF, null));
                $i$f$forEach2 = this.readProgressRepository.findAllByBookId(bookToUpgrade.getId());
                boolean $i$f$map = false;
                void $i$a$-let-BookImporter$importBook$1532 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean bl2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    ReadProgress bl6 = (ReadProgress)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl7 = false;
                    object.add(ReadProgress.copy$default((ReadProgress)it2, (String)importedBook.getId(), null, (int)0, (boolean)false, null, null, null, null, null, null, (int)1022, null));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$forEach6 = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv = iterator.next();
                    ReadProgress readProgress = (ReadProgress)element$iv;
                    boolean bl8 = false;
                    this.readProgressRepository.save(readProgress);
                }
                $this$forEach$iv = ReadListRepository.DefaultImpls.findAllContainingBookId$default((ReadListRepository)this.readListRepository, (String)bookToUpgrade.getId(), null, null, (int)4, null);
                boolean $i$f$forEach3 = false;
                iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv2;
                    void $this$map$iv2;
                    element$iv = iterator.next();
                    CopyOption[] copyOptionArray3 = (CopyOption[])element$iv;
                    boolean bl9 = false;
                    Collection collection2 = copyOptionArray3.getBookIds().values();
                    Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
                    Iterable item$iv$iv = collection2;
                    boolean it2 = false;
                    String string3 = null;
                    linkOptionArray = null;
                    copyOptionArray2 = copyOptionArray3;
                    copyOptionArray = this.readListRepository;
                    boolean $i$f$map2 = false;
                    void var24_89 = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                        void it4;
                        String string4 = (String)item$iv$iv2;
                        collection = destination$iv$iv2;
                        boolean bl10 = false;
                        collection.add((String)(Intrinsics.areEqual((Object)it4, (Object)bookToUpgrade.getId()) ? importedBook.getId() : it4));
                    }
                    collection = (List)destination$iv$iv2;
                    copyOptionArray.update(ReadList.copy$default((ReadList)copyOptionArray2, (String)linkOptionArray, string3, (boolean)it2, (SortedMap)LanguageUtilsKt.toIndexedMap((List)collection), null, null, null, (boolean)false, (int)247, null));
                }
                if (!deletedUpgradedFile && Files.deleteIfExists(bookToUpgrade.getPath())) {
                    BookImporterKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
                    this.historicalEventRepository.insert((HistoricalEvent)new HistoricalEvent.BookFileDeleted(bookToUpgrade, "File was deleted to import an upgrade"));
                }
                this.bookLifecycle.deleteOne(bookToUpgrade);
            }
            this.seriesLifecycle.sortBooks(series);
            $this$forEach$iv = sidecars;
            boolean $i$f$forEach7 = false;
            Iterator<Object> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = (Map.Entry)iterator.next();
                boolean bl = false;
                Sidecar sourceSidecar = (Sidecar)entry.getKey();
                Path destPath = (Path)entry.getValue();
                switch (WhenMappings.$EnumSwitchMapping$1[sourceSidecar.getType().ordinal()]) {
                    case 1: {
                        TaskEmitter.refreshBookLocalArtwork$default((TaskEmitter)this.taskEmitter, (Book)importedBook, (int)0, (int)2, null);
                        break;
                    }
                    case 2: {
                        TaskEmitter.refreshBookMetadata$default((TaskEmitter)this.taskEmitter, (Book)importedBook, null, (int)0, (int)6, null);
                    }
                }
                URL uRL = destPath.toUri().toURL();
                Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
                URL uRL2 = destPath.getParent().toUri().toURL();
                Intrinsics.checkNotNullExpressionValue((Object)uRL2, (String)"toURL(...)");
                Intrinsics.checkNotNull((Object)destPath);
                Path path8 = destPath;
                linkOptionArray = new LinkOption[]{};
                BasicFileAttributes basicFileAttributes = Files.readAttributes(path8, BasicFileAttributes.class, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)basicFileAttributes, (String)"readAttributes(...)");
                Sidecar destSidecar = Sidecar.copy$default((Sidecar)sourceSidecar, (URL)uRL, (URL)uRL2, (LocalDateTime)FileSystemScannerKt.getUpdatedTime((BasicFileAttributes)basicFileAttributes), null, null, (int)24, null);
                this.sidecarRepository.save(importedBook.getLibraryId(), destSidecar);
            }
            this.historicalEventRepository.insert((HistoricalEvent)new HistoricalEvent.BookImported(importedBook, series, sourceFile, upgradeBookId != null));
            URL uRL = sourceFile.toUri().toURL();
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
            this.eventPublisher.publishEvent((Object)new DomainEvent.BookImported(importedBook, uRL, true, null, 8, null));
            return importedBook;
        }
        catch (Exception e) {
            String msg = e instanceof CodedException ? ((CodedException)e).getCode() : e.getMessage();
            URL uRL = sourceFile.toUri().toURL();
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
            this.eventPublisher.publishEvent((Object)new DomainEvent.BookImported(null, uRL, false, msg));
            throw e;
        }
    }

    public static /* synthetic */ Book importBook$default(BookImporter bookImporter, Path path2, Series series, CopyMode copyMode, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: importBook");
        }
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        return bookImporter.importBook(path2, series, copyMode, string, string2);
    }
}

