/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.domain.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gotson.komga.domain.model.Book;
import org.gotson.komga.domain.model.DomainEvent;
import org.gotson.komga.domain.model.DuplicateNameException;
import org.gotson.komga.domain.model.ReadList;
import org.gotson.komga.domain.model.ReadListRequest;
import org.gotson.komga.domain.model.ReadListRequestMatch;
import org.gotson.komga.domain.model.ThumbnailReadList;
import org.gotson.komga.domain.model.TypedBytes;
import org.gotson.komga.domain.persistence.ReadListRepository;
import org.gotson.komga.domain.persistence.ThumbnailReadListRepository;
import org.gotson.komga.domain.service.BookLifecycle;
import org.gotson.komga.domain.service.ReadListLifecycle;
import org.gotson.komga.domain.service.ReadListLifecycleKt;
import org.gotson.komga.domain.service.ReadListMatcher;
import org.gotson.komga.infrastructure.image.MosaicGenerator;
import org.gotson.komga.infrastructure.metadata.comicrack.ReadListProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J'\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0017\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0017J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0016J\b\u0010\"\u001a\u00020\u0014H\u0016J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010!\u001a\u00020 H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u0016H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010!\u001a\u00020 H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020&H\u0016J\u0010\u0010,\u001a\u00020\u00142\u0006\u0010-\u001a\u00020\u0016H\u0012J\u0010\u0010.\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\u001dH\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/gotson/komga/domain/service/ReadListLifecycle;", "", "readListRepository", "Lorg/gotson/komga/domain/persistence/ReadListRepository;", "thumbnailReadListRepository", "Lorg/gotson/komga/domain/persistence/ThumbnailReadListRepository;", "bookLifecycle", "Lorg/gotson/komga/domain/service/BookLifecycle;", "mosaicGenerator", "Lorg/gotson/komga/infrastructure/image/MosaicGenerator;", "readListMatcher", "Lorg/gotson/komga/domain/service/ReadListMatcher;", "readListProvider", "Lorg/gotson/komga/infrastructure/metadata/comicrack/ReadListProvider;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "transactionTemplate", "Lorg/springframework/transaction/support/TransactionTemplate;", "(Lorg/gotson/komga/domain/persistence/ReadListRepository;Lorg/gotson/komga/domain/persistence/ThumbnailReadListRepository;Lorg/gotson/komga/domain/service/BookLifecycle;Lorg/gotson/komga/infrastructure/image/MosaicGenerator;Lorg/gotson/komga/domain/service/ReadListMatcher;Lorg/gotson/komga/infrastructure/metadata/comicrack/ReadListProvider;Lorg/springframework/context/ApplicationEventPublisher;Lorg/springframework/transaction/support/TransactionTemplate;)V", "addBookToReadList", "", "readListName", "", "book", "Lorg/gotson/komga/domain/model/Book;", "numberInList", "", "(Ljava/lang/String;Lorg/gotson/komga/domain/model/Book;Ljava/lang/Integer;)V", "addReadList", "Lorg/gotson/komga/domain/model/ReadList;", "readList", "addThumbnail", "Lorg/gotson/komga/domain/model/ThumbnailReadList;", "thumbnail", "deleteEmptyReadLists", "deleteReadList", "deleteThumbnail", "getThumbnailBytes", "", "thumbnailId", "markSelectedThumbnail", "matchComicRackList", "Lorg/gotson/komga/domain/model/ReadListRequestMatch;", "fileContent", "thumbnailsHouseKeeping", "readListId", "updateReadList", "toUpdate", "komga"})
@SourceDebugExtension(value={"SMAP\nReadListLifecycle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReadListLifecycle.kt\norg/gotson/komga/domain/service/ReadListLifecycle\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,194:1\n1603#2,9:195\n1855#2:204\n1856#2:206\n1612#2:207\n766#2:208\n857#2,2:209\n1549#2:211\n1620#2,3:212\n1549#2:215\n1620#2,3:216\n1855#2,2:219\n1#3:205\n*S KotlinDebug\n*F\n+ 1 ReadListLifecycle.kt\norg/gotson/komga/domain/service/ReadListLifecycle\n*L\n166#1:195,9\n166#1:204\n166#1:206\n166#1:207\n180#1:208\n180#1:209,2\n118#1:211\n118#1:212,3\n119#1:215\n119#1:216,3\n121#1:219,2\n166#1:205\n*E\n"})
public class ReadListLifecycle {
    @NotNull
    private final ReadListRepository readListRepository;
    @NotNull
    private final ThumbnailReadListRepository thumbnailReadListRepository;
    @NotNull
    private final BookLifecycle bookLifecycle;
    @NotNull
    private final MosaicGenerator mosaicGenerator;
    @NotNull
    private final ReadListMatcher readListMatcher;
    @NotNull
    private final ReadListProvider readListProvider;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private final TransactionTemplate transactionTemplate;

    public ReadListLifecycle(@NotNull ReadListRepository readListRepository, @NotNull ThumbnailReadListRepository thumbnailReadListRepository, @NotNull BookLifecycle bookLifecycle, @NotNull MosaicGenerator mosaicGenerator, @NotNull ReadListMatcher readListMatcher, @NotNull ReadListProvider readListProvider, @NotNull ApplicationEventPublisher eventPublisher, @NotNull TransactionTemplate transactionTemplate) {
        Intrinsics.checkNotNullParameter((Object)readListRepository, (String)"readListRepository");
        Intrinsics.checkNotNullParameter((Object)thumbnailReadListRepository, (String)"thumbnailReadListRepository");
        Intrinsics.checkNotNullParameter((Object)bookLifecycle, (String)"bookLifecycle");
        Intrinsics.checkNotNullParameter((Object)mosaicGenerator, (String)"mosaicGenerator");
        Intrinsics.checkNotNullParameter((Object)readListMatcher, (String)"readListMatcher");
        Intrinsics.checkNotNullParameter((Object)readListProvider, (String)"readListProvider");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)transactionTemplate, (String)"transactionTemplate");
        this.readListRepository = readListRepository;
        this.thumbnailReadListRepository = thumbnailReadListRepository;
        this.bookLifecycle = bookLifecycle;
        this.mosaicGenerator = mosaicGenerator;
        this.readListMatcher = readListMatcher;
        this.readListProvider = readListProvider;
        this.eventPublisher = eventPublisher;
        this.transactionTemplate = transactionTemplate;
    }

    @Transactional
    @NotNull
    public ReadList addReadList(@NotNull ReadList readList) throws DuplicateNameException {
        Intrinsics.checkNotNullParameter((Object)readList, (String)"readList");
        ReadListLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        if (this.readListRepository.existsByName(readList.getName())) {
            throw new DuplicateNameException("Read list name already exists", null, 2, null);
        }
        this.readListRepository.insert(readList);
        this.eventPublisher.publishEvent((Object)new DomainEvent.ReadListAdded(readList));
        ReadList readList2 = ReadListRepository.DefaultImpls.findByIdOrNull$default((ReadListRepository)this.readListRepository, (String)readList.getId(), null, null, (int)6, null);
        Intrinsics.checkNotNull((Object)readList2);
        return readList2;
    }

    @Transactional
    public void updateReadList(@NotNull ReadList toUpdate) {
        Intrinsics.checkNotNullParameter((Object)toUpdate, (String)"toUpdate");
        ReadListLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        ReadList readList = ReadListRepository.DefaultImpls.findByIdOrNull$default((ReadListRepository)this.readListRepository, (String)toUpdate.getId(), null, null, (int)6, null);
        if (readList == null) {
            throw new IllegalArgumentException("Cannot update read list that does not exist");
        }
        ReadList existing = readList;
        if (!StringsKt.equals((String)existing.getName(), (String)toUpdate.getName(), (boolean)true) && this.readListRepository.existsByName(toUpdate.getName())) {
            throw new DuplicateNameException("Read list name already exists", null, 2, null);
        }
        this.readListRepository.update(toUpdate);
        this.eventPublisher.publishEvent((Object)new DomainEvent.ReadListUpdated(toUpdate));
    }

    public void deleteReadList(@NotNull ReadList readList) {
        Intrinsics.checkNotNullParameter((Object)readList, (String)"readList");
        this.transactionTemplate.executeWithoutResult(arg_0 -> ReadListLifecycle.deleteReadList$lambda$0(this, readList, arg_0));
        this.eventPublisher.publishEvent((Object)new DomainEvent.ReadListDeleted(readList));
    }

    @Transactional
    public void addBookToReadList(@NotNull String readListName, @NotNull Book book, @Nullable Integer numberInList) {
        Intrinsics.checkNotNullParameter((Object)readListName, (String)"readListName");
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        ReadList existing = this.readListRepository.findByNameOrNull(readListName);
        boolean bl = false;
        if (existing != null) {
            if (existing.getBookIds().containsValue(book.getId())) {
                ReadListLifecycleKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
            } else {
                int n;
                SortedMap map = MapsKt.toSortedMap((Map)existing.getBookIds());
                if (numberInList != null && existing.getBookIds().containsKey(numberInList)) {
                    ReadListLifecycleKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
                    n = ((Number)existing.getBookIds().lastKey()).intValue() + 1;
                } else {
                    ReadListLifecycleKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
                    Integer n2 = numberInList;
                    n = n2 != null ? n2 : ((Number)existing.getBookIds().lastKey()).intValue() + 1;
                }
                int key2 = n;
                Integer n3 = key2;
                ((Map)map).put(n3, book.getId());
                this.updateReadList(ReadList.copy$default((ReadList)existing, null, null, (boolean)false, (SortedMap)map, null, null, null, (boolean)false, (int)247, null));
            }
        } else {
            ReadListLifecycleKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
            Integer n = numberInList;
            this.addReadList(new ReadList(readListName, null, false, MapsKt.toSortedMap((Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)(n != null ? n : 0), (Object)book.getId()))), null, null, null, false, 246, null));
        }
    }

    public void deleteEmptyReadLists() {
        ReadListLifecycleKt.access$getLogger$p().info((Function0)deleteEmptyReadLists.1.INSTANCE);
        this.transactionTemplate.executeWithoutResult(arg_0 -> ReadListLifecycle.deleteEmptyReadLists$lambda$5(this, arg_0));
    }

    @NotNull
    public ThumbnailReadList addThumbnail(@NotNull ThumbnailReadList thumbnail) {
        Intrinsics.checkNotNullParameter((Object)thumbnail, (String)"thumbnail");
        if (WhenMappings.$EnumSwitchMapping$0[thumbnail.getType().ordinal()] == 1) {
            this.thumbnailReadListRepository.insert(thumbnail);
            if (thumbnail.getSelected()) {
                this.thumbnailReadListRepository.markSelected(thumbnail);
            }
        }
        this.eventPublisher.publishEvent((Object)new DomainEvent.ThumbnailReadListAdded(thumbnail));
        return thumbnail;
    }

    public void markSelectedThumbnail(@NotNull ThumbnailReadList thumbnail) {
        Intrinsics.checkNotNullParameter((Object)thumbnail, (String)"thumbnail");
        this.thumbnailReadListRepository.markSelected(thumbnail);
        this.eventPublisher.publishEvent((Object)new DomainEvent.ThumbnailReadListAdded(ThumbnailReadList.copy$default((ThumbnailReadList)thumbnail, null, (boolean)true, null, null, (long)0L, null, null, null, null, null, (int)1021, null)));
    }

    public void deleteThumbnail(@NotNull ThumbnailReadList thumbnail) {
        Intrinsics.checkNotNullParameter((Object)thumbnail, (String)"thumbnail");
        this.thumbnailReadListRepository.delete(thumbnail.getId());
        this.thumbnailsHouseKeeping(thumbnail.getReadListId());
        this.eventPublisher.publishEvent((Object)new DomainEvent.ThumbnailReadListDeleted(thumbnail));
    }

    @Nullable
    public byte[] getThumbnailBytes(@NotNull String thumbnailId) {
        Intrinsics.checkNotNullParameter((Object)thumbnailId, (String)"thumbnailId");
        ThumbnailReadList thumbnailReadList = this.thumbnailReadListRepository.findByIdOrNull(thumbnailId);
        return (byte[])(thumbnailReadList != null ? thumbnailReadList.getThumbnail() : null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public byte[] getThumbnailBytes(@NotNull ReadList readList) {
        void $this$mapNotNullTo$iv$iv;
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)readList, (String)"readList");
        ThumbnailReadList thumbnailReadList = this.thumbnailReadListRepository.findSelectedByReadListIdOrNull(readList.getId());
        if (thumbnailReadList != null) {
            ThumbnailReadList it = thumbnailReadList;
            boolean bl = false;
            return it.getThumbnail();
        }
        List $this$getThumbnailBytes_u24lambda_u247 = new ArrayList();
        boolean bl = false;
        while ($this$getThumbnailBytes_u24lambda_u247.size() < 4) {
            iterable = $this$getThumbnailBytes_u24lambda_u247;
            Collection collection = readList.getBookIds().values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            CollectionsKt.addAll((Collection)iterable, (Iterable)CollectionsKt.take((Iterable)collection, (int)4));
        }
        List ids = CollectionsKt.take((Iterable)$this$getThumbnailBytes_u24lambda_u247, (int)4);
        Iterable $this$mapNotNull$iv = ids;
        boolean $i$f$mapNotNull = false;
        iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            byte[] it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            TypedBytes typedBytes = BookLifecycle.getThumbnailBytes$default((BookLifecycle)this.bookLifecycle, (String)it, null, (int)2, null);
            if ((byte[])(typedBytes != null ? typedBytes.getBytes() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List images = (List)destination$iv$iv;
        return this.mosaicGenerator.createMosaic(images);
    }

    @NotNull
    public ReadListRequestMatch matchComicRackList(@NotNull byte[] fileContent) {
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        ReadListRequest request = this.readListProvider.importFromCbl(fileContent);
        return this.readListMatcher.matchReadListRequest(request);
    }

    /*
     * WARNING - void declaration
     */
    private void thumbnailsHouseKeeping(String readListId) {
        void $this$filterTo$iv$iv;
        ReadListLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        Collection all2 = this.thumbnailReadListRepository.findAllByReadListId(readListId);
        Iterable $this$filter$iv = all2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ThumbnailReadList it = (ThumbnailReadList)element$iv$iv;
            boolean bl = false;
            if (!it.getSelected()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List selected = (List)destination$iv$iv;
        if (selected.size() > 1) {
            ReadListLifecycleKt.access$getLogger$p().info((Function0)thumbnailsHouseKeeping.2.INSTANCE);
            this.thumbnailReadListRepository.markSelected((ThumbnailReadList)selected.get(0));
        } else if (selected.isEmpty() && !all2.isEmpty()) {
            ReadListLifecycleKt.access$getLogger$p().info((Function0)thumbnailsHouseKeeping.3.INSTANCE);
            this.thumbnailReadListRepository.markSelected((ThumbnailReadList)CollectionsKt.first((Iterable)all2));
        }
    }

    private static final void deleteReadList$lambda$0(ReadListLifecycle this$0, ReadList $readList, TransactionStatus it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$readList, (String)"$readList");
        this$0.thumbnailReadListRepository.deleteByReadListId($readList.getId());
        this$0.readListRepository.delete($readList.getId());
    }

    private static final void deleteEmptyReadLists$lambda$5(ReadListLifecycle this$0, TransactionStatus it) {
        ReadList it2;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Collection toDelete = this$0.readListRepository.findAllEmpty();
        Iterable iterable = toDelete;
        ThumbnailReadListRepository thumbnailReadListRepository = this$0.thumbnailReadListRepository;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ReadList readList = (ReadList)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getId());
        }
        thumbnailReadListRepository.deleteByReadListIds((Collection)((List)destination$iv$iv));
        $this$map$iv = toDelete;
        thumbnailReadListRepository = this$0.readListRepository;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it2 = (ReadList)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getId());
        }
        thumbnailReadListRepository.delete((Collection)((List)destination$iv$iv));
        Iterable $this$forEach$iv = toDelete;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ReadList it3 = (ReadList)element$iv;
            boolean bl = false;
            this$0.eventPublisher.publishEvent((Object)new DomainEvent.ReadListDeleted(it3));
        }
    }
}

