/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.domain.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gotson.komga.domain.model.DomainEvent;
import org.gotson.komga.domain.model.DuplicateNameException;
import org.gotson.komga.domain.model.Series;
import org.gotson.komga.domain.model.SeriesCollection;
import org.gotson.komga.domain.model.ThumbnailSeriesCollection;
import org.gotson.komga.domain.persistence.SeriesCollectionRepository;
import org.gotson.komga.domain.persistence.ThumbnailSeriesCollectionRepository;
import org.gotson.komga.domain.service.SeriesCollectionLifecycle;
import org.gotson.komga.domain.service.SeriesCollectionLifecycleKt;
import org.gotson.komga.domain.service.SeriesLifecycle;
import org.gotson.komga.infrastructure.image.MosaicGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\b\b\u0017\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0017J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u001c\u001a\u00020\u0013H\u0016J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u0015H\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u0015H\u0016J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0015H\u0012J\u0010\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u0010H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/gotson/komga/domain/service/SeriesCollectionLifecycle;", "", "collectionRepository", "Lorg/gotson/komga/domain/persistence/SeriesCollectionRepository;", "thumbnailSeriesCollectionRepository", "Lorg/gotson/komga/domain/persistence/ThumbnailSeriesCollectionRepository;", "seriesLifecycle", "Lorg/gotson/komga/domain/service/SeriesLifecycle;", "mosaicGenerator", "Lorg/gotson/komga/infrastructure/image/MosaicGenerator;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "transactionTemplate", "Lorg/springframework/transaction/support/TransactionTemplate;", "(Lorg/gotson/komga/domain/persistence/SeriesCollectionRepository;Lorg/gotson/komga/domain/persistence/ThumbnailSeriesCollectionRepository;Lorg/gotson/komga/domain/service/SeriesLifecycle;Lorg/gotson/komga/infrastructure/image/MosaicGenerator;Lorg/springframework/context/ApplicationEventPublisher;Lorg/springframework/transaction/support/TransactionTemplate;)V", "addCollection", "Lorg/gotson/komga/domain/model/SeriesCollection;", "collection", "addSeriesToCollection", "", "collectionName", "", "series", "Lorg/gotson/komga/domain/model/Series;", "addThumbnail", "Lorg/gotson/komga/domain/model/ThumbnailSeriesCollection;", "thumbnail", "deleteCollection", "deleteEmptyCollections", "deleteThumbnail", "getThumbnailBytes", "", "thumbnailId", "userId", "markSelectedThumbnail", "thumbnailsHouseKeeping", "collectionId", "updateCollection", "toUpdate", "komga"})
@SourceDebugExtension(value={"SMAP\nSeriesCollectionLifecycle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeriesCollectionLifecycle.kt\norg/gotson/komga/domain/service/SeriesCollectionLifecycle\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n1603#2,9:177\n1855#2:186\n1856#2:188\n1612#2:189\n766#2:190\n857#2,2:191\n1549#2:193\n1620#2,3:194\n1549#2:197\n1620#2,3:198\n1855#2,2:201\n1#3:187\n*S KotlinDebug\n*F\n+ 1 SeriesCollectionLifecycle.kt\norg/gotson/komga/domain/service/SeriesCollectionLifecycle\n*L\n155#1:177,9\n155#1:186\n155#1:188\n155#1:189\n163#1:190\n163#1:191,2\n104#1:193\n104#1:194,3\n105#1:197\n105#1:198,3\n107#1:201,2\n155#1:187\n*E\n"})
public class SeriesCollectionLifecycle {
    @NotNull
    private final SeriesCollectionRepository collectionRepository;
    @NotNull
    private final ThumbnailSeriesCollectionRepository thumbnailSeriesCollectionRepository;
    @NotNull
    private final SeriesLifecycle seriesLifecycle;
    @NotNull
    private final MosaicGenerator mosaicGenerator;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private final TransactionTemplate transactionTemplate;

    public SeriesCollectionLifecycle(@NotNull SeriesCollectionRepository collectionRepository, @NotNull ThumbnailSeriesCollectionRepository thumbnailSeriesCollectionRepository, @NotNull SeriesLifecycle seriesLifecycle, @NotNull MosaicGenerator mosaicGenerator, @NotNull ApplicationEventPublisher eventPublisher, @NotNull TransactionTemplate transactionTemplate) {
        Intrinsics.checkNotNullParameter((Object)collectionRepository, (String)"collectionRepository");
        Intrinsics.checkNotNullParameter((Object)thumbnailSeriesCollectionRepository, (String)"thumbnailSeriesCollectionRepository");
        Intrinsics.checkNotNullParameter((Object)seriesLifecycle, (String)"seriesLifecycle");
        Intrinsics.checkNotNullParameter((Object)mosaicGenerator, (String)"mosaicGenerator");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)transactionTemplate, (String)"transactionTemplate");
        this.collectionRepository = collectionRepository;
        this.thumbnailSeriesCollectionRepository = thumbnailSeriesCollectionRepository;
        this.seriesLifecycle = seriesLifecycle;
        this.mosaicGenerator = mosaicGenerator;
        this.eventPublisher = eventPublisher;
        this.transactionTemplate = transactionTemplate;
    }

    @Transactional
    @NotNull
    public SeriesCollection addCollection(@NotNull SeriesCollection collection) throws DuplicateNameException {
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        SeriesCollectionLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        if (this.collectionRepository.existsByName(collection.getName())) {
            throw new DuplicateNameException("Collection name already exists", null, 2, null);
        }
        this.collectionRepository.insert(collection);
        this.eventPublisher.publishEvent((Object)new DomainEvent.CollectionAdded(collection));
        SeriesCollection seriesCollection = SeriesCollectionRepository.DefaultImpls.findByIdOrNull$default((SeriesCollectionRepository)this.collectionRepository, (String)collection.getId(), null, null, (int)6, null);
        Intrinsics.checkNotNull((Object)seriesCollection);
        return seriesCollection;
    }

    @Transactional
    public void updateCollection(@NotNull SeriesCollection toUpdate) {
        Intrinsics.checkNotNullParameter((Object)toUpdate, (String)"toUpdate");
        SeriesCollectionLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        SeriesCollection seriesCollection = SeriesCollectionRepository.DefaultImpls.findByIdOrNull$default((SeriesCollectionRepository)this.collectionRepository, (String)toUpdate.getId(), null, null, (int)6, null);
        if (seriesCollection == null) {
            throw new IllegalArgumentException("Cannot update collection that does not exist");
        }
        SeriesCollection existing = seriesCollection;
        if (!StringsKt.equals((String)existing.getName(), (String)toUpdate.getName(), (boolean)true) && this.collectionRepository.existsByName(toUpdate.getName())) {
            throw new DuplicateNameException("Collection name already exists", null, 2, null);
        }
        this.collectionRepository.update(toUpdate);
        this.eventPublisher.publishEvent((Object)new DomainEvent.CollectionUpdated(toUpdate));
    }

    public void deleteCollection(@NotNull SeriesCollection collection) {
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        this.transactionTemplate.executeWithoutResult(arg_0 -> SeriesCollectionLifecycle.deleteCollection$lambda$0(this, collection, arg_0));
        this.eventPublisher.publishEvent((Object)new DomainEvent.CollectionDeleted(collection));
    }

    @Transactional
    public void addSeriesToCollection(@NotNull String collectionName, @NotNull Series series) {
        Intrinsics.checkNotNullParameter((Object)collectionName, (String)"collectionName");
        Intrinsics.checkNotNullParameter((Object)series, (String)"series");
        SeriesCollection existing = this.collectionRepository.findByNameOrNull(collectionName);
        boolean bl = false;
        if (existing != null) {
            if (existing.getSeriesIds().contains(series.getId())) {
                SeriesCollectionLifecycleKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
            } else {
                SeriesCollectionLifecycleKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
                this.updateCollection(SeriesCollection.copy$default((SeriesCollection)existing, null, (boolean)false, (List)CollectionsKt.plus((Collection)existing.getSeriesIds(), (Object)series.getId()), null, null, null, (boolean)false, (int)123, null));
            }
        } else {
            SeriesCollectionLifecycleKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
            this.addCollection(new SeriesCollection(collectionName, false, CollectionsKt.listOf((Object)series.getId()), null, null, null, false, 122, null));
        }
    }

    public void deleteEmptyCollections() {
        SeriesCollectionLifecycleKt.access$getLogger$p().info((Function0)deleteEmptyCollections.1.INSTANCE);
        this.transactionTemplate.executeWithoutResult(arg_0 -> SeriesCollectionLifecycle.deleteEmptyCollections$lambda$5(this, arg_0));
    }

    @NotNull
    public ThumbnailSeriesCollection addThumbnail(@NotNull ThumbnailSeriesCollection thumbnail) {
        Intrinsics.checkNotNullParameter((Object)thumbnail, (String)"thumbnail");
        if (WhenMappings.$EnumSwitchMapping$0[thumbnail.getType().ordinal()] == 1) {
            this.thumbnailSeriesCollectionRepository.insert(thumbnail);
            if (thumbnail.getSelected()) {
                this.thumbnailSeriesCollectionRepository.markSelected(thumbnail);
            }
        }
        this.eventPublisher.publishEvent((Object)new DomainEvent.ThumbnailSeriesCollectionAdded(thumbnail));
        return thumbnail;
    }

    public void markSelectedThumbnail(@NotNull ThumbnailSeriesCollection thumbnail) {
        Intrinsics.checkNotNullParameter((Object)thumbnail, (String)"thumbnail");
        this.thumbnailSeriesCollectionRepository.markSelected(thumbnail);
        this.eventPublisher.publishEvent((Object)new DomainEvent.ThumbnailSeriesCollectionAdded(ThumbnailSeriesCollection.copy$default((ThumbnailSeriesCollection)thumbnail, null, (boolean)true, null, null, (long)0L, null, null, null, null, null, (int)1021, null)));
    }

    public void deleteThumbnail(@NotNull ThumbnailSeriesCollection thumbnail) {
        Intrinsics.checkNotNullParameter((Object)thumbnail, (String)"thumbnail");
        this.thumbnailSeriesCollectionRepository.delete(thumbnail.getId());
        this.thumbnailsHouseKeeping(thumbnail.getCollectionId());
        this.eventPublisher.publishEvent((Object)new DomainEvent.ThumbnailSeriesCollectionDeleted(thumbnail));
    }

    @Nullable
    public byte[] getThumbnailBytes(@NotNull String thumbnailId) {
        Intrinsics.checkNotNullParameter((Object)thumbnailId, (String)"thumbnailId");
        ThumbnailSeriesCollection thumbnailSeriesCollection = this.thumbnailSeriesCollectionRepository.findByIdOrNull(thumbnailId);
        return (byte[])(thumbnailSeriesCollection != null ? thumbnailSeriesCollection.getThumbnail() : null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public byte[] getThumbnailBytes(@NotNull SeriesCollection collection, @NotNull String userId) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        ThumbnailSeriesCollection thumbnailSeriesCollection = this.thumbnailSeriesCollectionRepository.findSelectedByCollectionIdOrNull(collection.getId());
        if (thumbnailSeriesCollection != null) {
            ThumbnailSeriesCollection it = thumbnailSeriesCollection;
            boolean bl = false;
            return it.getThumbnail();
        }
        List $this$getThumbnailBytes_u24lambda_u247 = new ArrayList();
        boolean bl = false;
        while ($this$getThumbnailBytes_u24lambda_u247.size() < 4) {
            CollectionsKt.addAll((Collection)$this$getThumbnailBytes_u24lambda_u247, (Iterable)CollectionsKt.take((Iterable)collection.getSeriesIds(), (int)4));
        }
        List ids = CollectionsKt.take((Iterable)$this$getThumbnailBytes_u24lambda_u247, (int)4);
        Iterable $this$mapNotNull$iv = ids;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            byte[] it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            if (this.seriesLifecycle.getThumbnailBytes(it, userId) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List images = (List)destination$iv$iv;
        return this.mosaicGenerator.createMosaic(images);
    }

    /*
     * WARNING - void declaration
     */
    private void thumbnailsHouseKeeping(String collectionId) {
        void $this$filterTo$iv$iv;
        SeriesCollectionLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        Collection all2 = this.thumbnailSeriesCollectionRepository.findAllByCollectionId(collectionId);
        Iterable $this$filter$iv = all2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ThumbnailSeriesCollection it = (ThumbnailSeriesCollection)element$iv$iv;
            boolean bl = false;
            if (!it.getSelected()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List selected = (List)destination$iv$iv;
        if (selected.size() > 1) {
            SeriesCollectionLifecycleKt.access$getLogger$p().info((Function0)thumbnailsHouseKeeping.2.INSTANCE);
            this.thumbnailSeriesCollectionRepository.markSelected((ThumbnailSeriesCollection)selected.get(0));
        } else if (selected.isEmpty() && !all2.isEmpty()) {
            SeriesCollectionLifecycleKt.access$getLogger$p().info((Function0)thumbnailsHouseKeeping.3.INSTANCE);
            this.thumbnailSeriesCollectionRepository.markSelected((ThumbnailSeriesCollection)CollectionsKt.first((Iterable)all2));
        }
    }

    private static final void deleteCollection$lambda$0(SeriesCollectionLifecycle this$0, SeriesCollection $collection, TransactionStatus it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$collection, (String)"$collection");
        this$0.thumbnailSeriesCollectionRepository.deleteByCollectionId($collection.getId());
        this$0.collectionRepository.delete($collection.getId());
    }

    private static final void deleteEmptyCollections$lambda$5(SeriesCollectionLifecycle this$0, TransactionStatus it) {
        SeriesCollection it2;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Collection toDelete = this$0.collectionRepository.findAllEmpty();
        Iterable iterable = toDelete;
        ThumbnailSeriesCollectionRepository thumbnailSeriesCollectionRepository = this$0.thumbnailSeriesCollectionRepository;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            SeriesCollection seriesCollection = (SeriesCollection)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getId());
        }
        thumbnailSeriesCollectionRepository.deleteByCollectionIds((Collection)((List)destination$iv$iv));
        $this$map$iv = toDelete;
        thumbnailSeriesCollectionRepository = this$0.collectionRepository;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it2 = (SeriesCollection)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getId());
        }
        thumbnailSeriesCollectionRepository.delete((Collection)((List)destination$iv$iv));
        Iterable $this$forEach$iv = toDelete;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SeriesCollection it3 = (SeriesCollection)element$iv;
            boolean bl = false;
            this$0.eventPublisher.publishEvent((Object)new DomainEvent.CollectionDeleted(it3));
        }
    }
}

