/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.domain.service;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.gotson.komga.application.tasks.TaskEmitter;
import org.gotson.komga.domain.model.Book;
import org.gotson.komga.domain.model.BookMetadata;
import org.gotson.komga.domain.model.BookMetadataAggregation;
import org.gotson.komga.domain.model.BookMetadataPatchCapability;
import org.gotson.komga.domain.model.DomainEvent;
import org.gotson.komga.domain.model.HistoricalEvent;
import org.gotson.komga.domain.model.KomgaUser;
import org.gotson.komga.domain.model.MarkSelectedPreference;
import org.gotson.komga.domain.model.Media;
import org.gotson.komga.domain.model.ReadProgress;
import org.gotson.komga.domain.model.Series;
import org.gotson.komga.domain.model.SeriesMetadata;
import org.gotson.komga.domain.model.ThumbnailSeries;
import org.gotson.komga.domain.model.TypedBytes;
import org.gotson.komga.domain.persistence.BookMetadataAggregationRepository;
import org.gotson.komga.domain.persistence.BookMetadataRepository;
import org.gotson.komga.domain.persistence.BookRepository;
import org.gotson.komga.domain.persistence.HistoricalEventRepository;
import org.gotson.komga.domain.persistence.LibraryRepository;
import org.gotson.komga.domain.persistence.MediaRepository;
import org.gotson.komga.domain.persistence.ReadProgressRepository;
import org.gotson.komga.domain.persistence.SeriesCollectionRepository;
import org.gotson.komga.domain.persistence.SeriesMetadataRepository;
import org.gotson.komga.domain.persistence.SeriesRepository;
import org.gotson.komga.domain.persistence.ThumbnailSeriesRepository;
import org.gotson.komga.domain.service.BookLifecycle;
import org.gotson.komga.domain.service.SeriesLifecycle;
import org.gotson.komga.domain.service.SeriesLifecycleKt;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionTemplate;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\n\b\u0017\u0018\u00002\u00020\u0001B}\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\u0002\u0010 J\u001e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0016J\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020&2\u0006\u0010%\u001a\u00020&H\u0016J\u0016\u00100\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0(H\u0016J\u0018\u00101\u001a\u00020$2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u00107\u001a\u00020$2\u0006\u0010,\u001a\u00020+H\u0016J\u0012\u00108\u001a\u0004\u0018\u0001092\u0006\u0010,\u001a\u00020+H\u0012J\u0012\u0010:\u001a\u0004\u0018\u00010+2\u0006\u00102\u001a\u000203H\u0016J\u001a\u0010;\u001a\u0004\u0018\u0001092\u0006\u00102\u001a\u0002032\u0006\u0010<\u001a\u000203H\u0016J\u0012\u0010=\u001a\u0004\u0018\u0001092\u0006\u0010>\u001a\u000203H\u0016J\u0018\u0010?\u001a\u00020$2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J\u0016\u0010@\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0(H\u0016J\u0010\u0010A\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010B\u001a\u00020$2\u0006\u00102\u001a\u000203H\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/gotson/komga/domain/service/SeriesLifecycle;", "", "libraryRepository", "Lorg/gotson/komga/domain/persistence/LibraryRepository;", "bookRepository", "Lorg/gotson/komga/domain/persistence/BookRepository;", "bookLifecycle", "Lorg/gotson/komga/domain/service/BookLifecycle;", "mediaRepository", "Lorg/gotson/komga/domain/persistence/MediaRepository;", "bookMetadataRepository", "Lorg/gotson/komga/domain/persistence/BookMetadataRepository;", "seriesRepository", "Lorg/gotson/komga/domain/persistence/SeriesRepository;", "thumbnailsSeriesRepository", "Lorg/gotson/komga/domain/persistence/ThumbnailSeriesRepository;", "seriesMetadataRepository", "Lorg/gotson/komga/domain/persistence/SeriesMetadataRepository;", "bookMetadataAggregationRepository", "Lorg/gotson/komga/domain/persistence/BookMetadataAggregationRepository;", "collectionRepository", "Lorg/gotson/komga/domain/persistence/SeriesCollectionRepository;", "readProgressRepository", "Lorg/gotson/komga/domain/persistence/ReadProgressRepository;", "taskEmitter", "Lorg/gotson/komga/application/tasks/TaskEmitter;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "transactionTemplate", "Lorg/springframework/transaction/support/TransactionTemplate;", "historicalEventRepository", "Lorg/gotson/komga/domain/persistence/HistoricalEventRepository;", "(Lorg/gotson/komga/domain/persistence/LibraryRepository;Lorg/gotson/komga/domain/persistence/BookRepository;Lorg/gotson/komga/domain/service/BookLifecycle;Lorg/gotson/komga/domain/persistence/MediaRepository;Lorg/gotson/komga/domain/persistence/BookMetadataRepository;Lorg/gotson/komga/domain/persistence/SeriesRepository;Lorg/gotson/komga/domain/persistence/ThumbnailSeriesRepository;Lorg/gotson/komga/domain/persistence/SeriesMetadataRepository;Lorg/gotson/komga/domain/persistence/BookMetadataAggregationRepository;Lorg/gotson/komga/domain/persistence/SeriesCollectionRepository;Lorg/gotson/komga/domain/persistence/ReadProgressRepository;Lorg/gotson/komga/application/tasks/TaskEmitter;Lorg/springframework/context/ApplicationEventPublisher;Lorg/springframework/transaction/support/TransactionTemplate;Lorg/gotson/komga/domain/persistence/HistoricalEventRepository;)V", "whitespacePattern", "Lkotlin/text/Regex;", "addBooks", "", "series", "Lorg/gotson/komga/domain/model/Series;", "booksToAdd", "", "Lorg/gotson/komga/domain/model/Book;", "addThumbnailForSeries", "Lorg/gotson/komga/domain/model/ThumbnailSeries;", "thumbnail", "markSelected", "Lorg/gotson/komga/domain/model/MarkSelectedPreference;", "createSeries", "deleteMany", "deleteReadProgress", "seriesId", "", "user", "Lorg/gotson/komga/domain/model/KomgaUser;", "deleteSeriesFiles", "deleteThumbnailForSeries", "getBytesFromThumbnailSeries", "", "getSelectedThumbnail", "getThumbnailBytes", "userId", "getThumbnailBytesByThumbnailId", "thumbnailId", "markReadProgressCompleted", "softDeleteMany", "sortBooks", "thumbnailsHouseKeeping", "komga"})
@SourceDebugExtension(value={"SMAP\nSeriesLifecycle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeriesLifecycle.kt\norg/gotson/komga/domain/service/SeriesLifecycle\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,376:1\n1549#2:377\n1620#2,3:378\n1549#2:381\n1620#2,2:382\n223#2,2:384\n1622#2:386\n1559#2:387\n1590#2,4:388\n1569#2,11:392\n1864#2,2:403\n1866#2:406\n1580#2:407\n1549#2:408\n1620#2,3:409\n1855#2,2:412\n1855#2:414\n1856#2:416\n1549#2:417\n1620#2,3:418\n1855#2,2:421\n1855#2,2:423\n1549#2:425\n1620#2,3:426\n1855#2,2:429\n766#2:431\n857#2,2:432\n1549#2:434\n1620#2,3:435\n1855#2,2:438\n1855#2,2:440\n766#2:442\n857#2,2:443\n1855#2,2:445\n1603#2,9:447\n1855#2:456\n1856#2:458\n1612#2:459\n766#2:460\n857#2,2:461\n1855#2,2:463\n1855#2,2:465\n1603#2,9:467\n1855#2:476\n1856#2:478\n1612#2:479\n766#2:480\n857#2,2:481\n1549#2:483\n1620#2,3:484\n1549#2:487\n1620#2,3:488\n1549#2:492\n1620#2,3:493\n1855#2,2:496\n1#3:405\n1#3:415\n1#3:457\n1#3:477\n1#3:491\n*S KotlinDebug\n*F\n+ 1 SeriesLifecycle.kt\norg/gotson/komga/domain/service/SeriesLifecycle\n*L\n71#1:377\n71#1:378,3\n85#1:381\n85#1:382,2\n85#1:384,2\n85#1:386\n89#1:387\n89#1:388,4\n93#1:392,11\n93#1:403,2\n93#1:406\n93#1:407\n106#1:408\n106#1:409,3\n109#1:412,2\n126#1:414\n126#1:416\n129#1:417\n129#1:418,3\n148#1:421,2\n184#1:423,2\n188#1:425\n188#1:426,3\n203#1:429,2\n212#1:431\n212#1:432,2\n218#1:434\n218#1:435,3\n221#1:438,2\n233#1:440,2\n295#1:442\n295#1:443,2\n296#1:445,2\n331#1:447,9\n331#1:456\n331#1:458\n331#1:459\n332#1:460\n332#1:461,2\n335#1:463,2\n336#1:465,2\n353#1:467,9\n353#1:476\n353#1:478\n353#1:479\n363#1:480\n363#1:481,2\n135#1:483\n135#1:484,3\n138#1:487\n138#1:488,3\n178#1:492\n178#1:493,3\n179#1:496,2\n93#1:405\n331#1:457\n353#1:477\n*E\n"})
public class SeriesLifecycle {
    @NotNull
    private final LibraryRepository libraryRepository;
    @NotNull
    private final BookRepository bookRepository;
    @NotNull
    private final BookLifecycle bookLifecycle;
    @NotNull
    private final MediaRepository mediaRepository;
    @NotNull
    private final BookMetadataRepository bookMetadataRepository;
    @NotNull
    private final SeriesRepository seriesRepository;
    @NotNull
    private final ThumbnailSeriesRepository thumbnailsSeriesRepository;
    @NotNull
    private final SeriesMetadataRepository seriesMetadataRepository;
    @NotNull
    private final BookMetadataAggregationRepository bookMetadataAggregationRepository;
    @NotNull
    private final SeriesCollectionRepository collectionRepository;
    @NotNull
    private final ReadProgressRepository readProgressRepository;
    @NotNull
    private final TaskEmitter taskEmitter;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private final TransactionTemplate transactionTemplate;
    @NotNull
    private final HistoricalEventRepository historicalEventRepository;
    @NotNull
    private final Regex whitespacePattern;

    public SeriesLifecycle(@NotNull LibraryRepository libraryRepository, @NotNull BookRepository bookRepository, @NotNull BookLifecycle bookLifecycle, @NotNull MediaRepository mediaRepository, @NotNull BookMetadataRepository bookMetadataRepository, @NotNull SeriesRepository seriesRepository, @NotNull ThumbnailSeriesRepository thumbnailsSeriesRepository, @NotNull SeriesMetadataRepository seriesMetadataRepository, @NotNull BookMetadataAggregationRepository bookMetadataAggregationRepository, @NotNull SeriesCollectionRepository collectionRepository, @NotNull ReadProgressRepository readProgressRepository, @NotNull TaskEmitter taskEmitter, @NotNull ApplicationEventPublisher eventPublisher, @NotNull TransactionTemplate transactionTemplate, @NotNull HistoricalEventRepository historicalEventRepository) {
        Intrinsics.checkNotNullParameter((Object)libraryRepository, (String)"libraryRepository");
        Intrinsics.checkNotNullParameter((Object)bookRepository, (String)"bookRepository");
        Intrinsics.checkNotNullParameter((Object)bookLifecycle, (String)"bookLifecycle");
        Intrinsics.checkNotNullParameter((Object)mediaRepository, (String)"mediaRepository");
        Intrinsics.checkNotNullParameter((Object)bookMetadataRepository, (String)"bookMetadataRepository");
        Intrinsics.checkNotNullParameter((Object)seriesRepository, (String)"seriesRepository");
        Intrinsics.checkNotNullParameter((Object)thumbnailsSeriesRepository, (String)"thumbnailsSeriesRepository");
        Intrinsics.checkNotNullParameter((Object)seriesMetadataRepository, (String)"seriesMetadataRepository");
        Intrinsics.checkNotNullParameter((Object)bookMetadataAggregationRepository, (String)"bookMetadataAggregationRepository");
        Intrinsics.checkNotNullParameter((Object)collectionRepository, (String)"collectionRepository");
        Intrinsics.checkNotNullParameter((Object)readProgressRepository, (String)"readProgressRepository");
        Intrinsics.checkNotNullParameter((Object)taskEmitter, (String)"taskEmitter");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)transactionTemplate, (String)"transactionTemplate");
        Intrinsics.checkNotNullParameter((Object)historicalEventRepository, (String)"historicalEventRepository");
        this.libraryRepository = libraryRepository;
        this.bookRepository = bookRepository;
        this.bookLifecycle = bookLifecycle;
        this.mediaRepository = mediaRepository;
        this.bookMetadataRepository = bookMetadataRepository;
        this.seriesRepository = seriesRepository;
        this.thumbnailsSeriesRepository = thumbnailsSeriesRepository;
        this.seriesMetadataRepository = seriesMetadataRepository;
        this.bookMetadataAggregationRepository = bookMetadataAggregationRepository;
        this.collectionRepository = collectionRepository;
        this.readProgressRepository = readProgressRepository;
        this.taskEmitter = taskEmitter;
        this.eventPublisher = eventPublisher;
        this.transactionTemplate = transactionTemplate;
        this.historicalEventRepository = historicalEventRepository;
        this.whitespacePattern = new Regex("\\s+");
    }

    /*
     * WARNING - void declaration
     */
    public void sortBooks(@NotNull Series series) {
        block10: {
            Iterator $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$mapIndexedNotNullTo$iv$iv;
            Object book;
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            Object $this$first$iv;
            int n;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2;
            Collection collection;
            void $this$mapTo$iv$iv3;
            void $this$map$iv3;
            Intrinsics.checkNotNullParameter((Object)series, (String)"series");
            SeriesLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
            Collection books = this.bookRepository.findAllBySeriesId(series.getId());
            Iterable iterable = books;
            Object object = this.bookMetadataRepository;
            boolean $i$f$map22 = false;
            void var6_7 = $this$map$iv3;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it;
                Book book2 = (Book)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getId());
            }
            Collection metadatas = object.findAllByIds((Collection)((List)destination$iv$iv));
            SeriesLifecycleKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
            SeriesLifecycleKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
            Object $i$f$map22 = SeriesLifecycleKt.access$getNatSortComparator$p();
            $i$f$map22 = CollectionsKt.sortedWith((Iterable)books, (Comparator)((Comparator)new /* Unavailable Anonymous Inner Class!! */));
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv2;
            Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                Object element$iv;
                void var15_37;
                block9: {
                    void book3;
                    Book bl = (Book)item$iv$iv;
                    object = destination$iv$iv2;
                    n = 0;
                    Iterable iterable2 = metadatas;
                    var15_37 = book3;
                    boolean $i$f$first = false;
                    Iterator iterator = $this$first$iv.iterator();
                    while (iterator.hasNext()) {
                        element$iv = iterator.next();
                        BookMetadata it = (BookMetadata)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getBookId(), (Object)book3.getId())) continue;
                        break block9;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                object.add(TuplesKt.to((Object)var15_37, element$iv));
            }
            List sorted = (List)destination$iv$iv2;
            SeriesLifecycleKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
            $this$map$iv2 = sorted;
            object = this.bookRepository;
            boolean $i$f$mapIndexed = false;
            $this$mapTo$iv$iv2 = $this$mapIndexed$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                $this$first$iv = (Pair)item$iv$iv;
                int n2 = n;
                collection = destination$iv$iv2;
                boolean bl = false;
                book = (Book)$this$first$iv.component1();
                collection.add(Book.copy$default((Book)book, null, null, null, (long)0L, null, (int)(index + true), null, null, null, null, (boolean)false, null, null, (int)8159, null));
            }
            object.update((Collection)((List)destination$iv$iv2));
            Iterable $this$mapIndexedNotNull$iv = sorted;
            boolean $i$f$mapIndexedNotNull = false;
            destination$iv$iv2 = $this$mapIndexedNotNull$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapIndexedNotNullTo = false;
            Iterator $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv2 = 0;
            $this$first$iv = $this$forEachIndexed$iv$iv$iv.iterator();
            while ($this$first$iv.hasNext()) {
                Triple it$iv$iv;
                void element$iv$iv;
                int n3;
                Object item$iv$iv$iv = $this$first$iv.next();
                if ((n3 = index$iv$iv$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                book = item$iv$iv$iv;
                int index$iv$iv2 = n3;
                boolean bl = false;
                Pair pair = (Pair)element$iv$iv;
                int index = index$iv$iv2;
                boolean bl3 = false;
                Book book4 = (Book)pair.component1();
                BookMetadata metadata = (BookMetadata)pair.component2();
                if ((metadata.getNumberLock() && metadata.getNumberSortLock() ? null : new Triple((Object)book4, (Object)metadata, (Object)BookMetadata.copy$default((BookMetadata)metadata, null, null, (String)(!metadata.getNumberLock() ? String.valueOf(index + 1) : metadata.getNumber()), (float)(!metadata.getNumberSortLock() ? (float)(index + 1) : metadata.getNumberSort()), null, null, null, null, null, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, null, null, (int)0x1FFFF3, null))) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            List oldToNew = (List)destination$iv$iv3;
            $this$mapIndexedNotNull$iv = oldToNew;
            object = this.bookMetadataRepository;
            boolean $i$f$map3 = false;
            $this$mapIndexedNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo3 = false;
            $this$forEachIndexed$iv$iv$iv = $this$mapTo$iv$iv.iterator();
            while ($this$forEachIndexed$iv$iv$iv.hasNext()) {
                void it;
                Object item$iv$iv = $this$forEachIndexed$iv$iv$iv.next();
                Triple index$iv$iv$iv2 = (Triple)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl = false;
                collection.add((BookMetadata)it.getThird());
            }
            object.update((Collection)((List)destination$iv$iv3));
            Iterable $this$forEach$iv = oldToNew;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Triple triple = (Triple)element$iv;
                boolean bl = false;
                Book book5 = (Book)triple.component1();
                BookMetadata old = (BookMetadata)triple.component2();
                BookMetadata bookMetadata = (BookMetadata)triple.component3();
                if (Intrinsics.areEqual((Object)old.getNumber(), (Object)bookMetadata.getNumber()) && old.getNumberSort() == bookMetadata.getNumberSort()) continue;
                SeriesLifecycleKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
                Object[] objectArray = new BookMetadataPatchCapability[]{BookMetadataPatchCapability.NUMBER, BookMetadataPatchCapability.NUMBER_SORT};
                TaskEmitter.refreshBookMetadata$default((TaskEmitter)this.taskEmitter, (Book)book5, (Set)SetsKt.setOf((Object[])objectArray), (int)0, (int)4, null);
            }
            Series series2 = this.seriesRepository.findByIdOrNull(series.getId());
            if (series2 == null) break block10;
            Series it = series2;
            boolean bl = false;
            this.seriesRepository.update(Series.copy$default((Series)it, null, null, null, null, null, (int)books.size(), null, (boolean)false, null, null, (int)991, null), false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addBooks(@NotNull Series series, @NotNull Collection<Book> booksToAdd) {
        void $this$mapTo$iv$iv;
        Object element$iv2;
        Intrinsics.checkNotNullParameter((Object)series, (String)"series");
        Intrinsics.checkNotNullParameter(booksToAdd, (String)"booksToAdd");
        Iterable $this$forEach$iv = booksToAdd;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            Book it = (Book)element$iv2;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getLibraryId(), (Object)series.getLibraryId())) continue;
            boolean $i$a$-check-SeriesLifecycle$addBooks$1$22 = false;
            String $i$a$-check-SeriesLifecycle$addBooks$1$22 = "Cannot add book to series if they don't share the same libraryId";
            throw new IllegalStateException($i$a$-check-SeriesLifecycle$addBooks$1$22.toString());
        }
        Iterable $this$map$iv = booksToAdd;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Book book = (Book)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Book.copy$default((Book)it, null, null, null, (long)0L, null, (int)0, null, (String)series.getId(), null, null, (boolean)false, null, null, (int)8063, null));
        }
        List toAdd = (List)destination$iv$iv;
        this.transactionTemplate.executeWithoutResult(arg_0 -> SeriesLifecycle.addBooks$lambda$15(this, toAdd, arg_0));
        Iterable $this$forEach$iv2 = toAdd;
        boolean $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv2) {
            Book it = (Book)element$iv3;
            boolean bl = false;
            this.eventPublisher.publishEvent((Object)new DomainEvent.BookAdded(it));
        }
    }

    @NotNull
    public Series createSeries(@NotNull Series series) {
        Intrinsics.checkNotNullParameter((Object)series, (String)"series");
        this.transactionTemplate.executeWithoutResult(arg_0 -> SeriesLifecycle.createSeries$lambda$17(this, series, arg_0));
        this.eventPublisher.publishEvent((Object)new DomainEvent.SeriesAdded(series));
        Series series2 = this.seriesRepository.findByIdOrNull(series.getId());
        Intrinsics.checkNotNull((Object)series2);
        return series2;
    }

    public void softDeleteMany(@NotNull Collection<Series> series) {
        Intrinsics.checkNotNullParameter(series, (String)"series");
        SeriesLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        LocalDateTime deletedDate = LocalDateTime.now();
        this.transactionTemplate.executeWithoutResult(arg_0 -> SeriesLifecycle.softDeleteMany$lambda$20(this, series, deletedDate, arg_0));
        Iterable $this$forEach$iv = series;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Series it = (Series)element$iv;
            boolean bl = false;
            this.eventPublisher.publishEvent((Object)new DomainEvent.SeriesUpdated(it));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void deleteMany(@NotNull Collection<Series> series) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(series, (String)"series");
        Iterable $this$map$iv = series;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Series series2 = (Series)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        List seriesIds = (List)destination$iv$iv;
        SeriesLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        this.transactionTemplate.executeWithoutResult(arg_0 -> SeriesLifecycle.deleteMany$lambda$23(this, seriesIds, arg_0));
        Iterable $this$forEach$iv = series;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Series it = (Series)element$iv;
            boolean bl = false;
            this.eventPublisher.publishEvent((Object)new DomainEvent.SeriesDeleted(it));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void markReadProgressCompleted(@NotNull String seriesId, @NotNull KomgaUser user) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Iterable iterable = this.bookRepository.findAllIdsBySeriesId(seriesId);
        boolean $i$f$filter22 = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String bookId = (String)element$iv$iv;
            boolean bl = false;
            ReadProgress readProgress = this.readProgressRepository.findByBookIdAndUserIdOrNull(bookId, user.getId());
            if (!(readProgress == null || !readProgress.getCompleted())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List bookIds = (List)destination$iv$iv;
        Iterable $i$f$filter22 = this.mediaRepository.getPagesSizes((Collection)bookIds);
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            String bookId = (String)pair.component1();
            int pageSize = ((Number)pair.component2()).intValue();
            collection.add(new ReadProgress(bookId, user.getId(), pageSize, true, null, null, null, null, null, null, 1008, null));
        }
        List progresses = (List)destination$iv$iv2;
        this.readProgressRepository.save((Collection)progresses);
        Iterable $this$forEach$iv = progresses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ReadProgress it = (ReadProgress)element$iv;
            boolean bl = false;
            this.eventPublisher.publishEvent((Object)new DomainEvent.ReadProgressChanged(it));
        }
        this.eventPublisher.publishEvent((Object)new DomainEvent.ReadProgressSeriesChanged(seriesId, user.getId()));
    }

    public void deleteReadProgress(@NotNull String seriesId, @NotNull KomgaUser user) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Collection bookIds = this.bookRepository.findAllIdsBySeriesId(seriesId);
        Collection progresses = this.readProgressRepository.findAllByBookIdsAndUserId(bookIds, user.getId());
        this.readProgressRepository.deleteByBookIdsAndUserId(bookIds, user.getId());
        Iterable $this$forEach$iv = progresses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ReadProgress it = (ReadProgress)element$iv;
            boolean bl = false;
            this.eventPublisher.publishEvent((Object)new DomainEvent.ReadProgressDeleted(it));
        }
        this.eventPublisher.publishEvent((Object)new DomainEvent.ReadProgressSeriesDeleted(seriesId, user.getId()));
    }

    @Nullable
    public ThumbnailSeries getSelectedThumbnail(@NotNull String seriesId) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        ThumbnailSeries selected = this.thumbnailsSeriesRepository.findSelectedBySeriesIdOrNull(seriesId);
        if (selected == null || selected.getType() == ThumbnailSeries.Type.SIDECAR && !selected.exists()) {
            this.thumbnailsHouseKeeping(seriesId);
            return this.thumbnailsSeriesRepository.findSelectedBySeriesIdOrNull(seriesId);
        }
        return selected;
    }

    private byte[] getBytesFromThumbnailSeries(ThumbnailSeries thumbnail) {
        return thumbnail.getThumbnail() != null ? thumbnail.getThumbnail() : (byte[])(thumbnail.getUrl() != null ? FilesKt.readBytes((File)new File(thumbnail.getUrl().toURI())) : null);
    }

    @Nullable
    public byte[] getThumbnailBytesByThumbnailId(@NotNull String thumbnailId) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)thumbnailId, (String)"thumbnailId");
        ThumbnailSeries thumbnailSeries = this.thumbnailsSeriesRepository.findByIdOrNull(thumbnailId);
        if (thumbnailSeries != null) {
            ThumbnailSeries it = thumbnailSeries;
            boolean bl = false;
            byArray = this.getBytesFromThumbnailSeries(it);
        } else {
            byArray = null;
        }
        return byArray;
    }

    @Nullable
    public byte[] getThumbnailBytes(@NotNull String seriesId, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        ThumbnailSeries thumbnailSeries = this.getSelectedThumbnail(seriesId);
        if (thumbnailSeries != null) {
            ThumbnailSeries it = thumbnailSeries;
            boolean bl = false;
            return this.getBytesFromThumbnailSeries(it);
        }
        Series series = this.seriesRepository.findByIdOrNull(seriesId);
        if (series != null) {
            String string;
            Series series2 = series;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[this.libraryRepository.findById(series2.getLibraryId()).getSeriesCover().ordinal()]) {
                case 1: {
                    string = this.bookRepository.findFirstIdInSeriesOrNull(seriesId);
                    break;
                }
                case 2: {
                    string = this.bookRepository.findFirstUnreadIdInSeriesOrNull(seriesId, userId);
                    if (string != null) break;
                    string = this.bookRepository.findFirstIdInSeriesOrNull(seriesId);
                    break;
                }
                case 3: {
                    string = this.bookRepository.findFirstUnreadIdInSeriesOrNull(seriesId, userId);
                    if (string != null) break;
                    string = this.bookRepository.findLastIdInSeriesOrNull(seriesId);
                    break;
                }
                case 4: {
                    string = this.bookRepository.findLastIdInSeriesOrNull(seriesId);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            String bookId = string;
            if (bookId != null) {
                TypedBytes typedBytes = BookLifecycle.getThumbnailBytes$default((BookLifecycle)this.bookLifecycle, (String)bookId, null, (int)2, null);
                return (byte[])(typedBytes != null ? typedBytes.getBytes() : null);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ThumbnailSeries addThumbnailForSeries(@NotNull ThumbnailSeries thumbnail, @NotNull MarkSelectedPreference markSelected) {
        Intrinsics.checkNotNullParameter((Object)thumbnail, (String)"thumbnail");
        Intrinsics.checkNotNullParameter((Object)markSelected, (String)"markSelected");
        if (thumbnail.getUrl() != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.thumbnailsSeriesRepository.findAllBySeriesId(thumbnail.getSeriesId());
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ThumbnailSeries it = (ThumbnailSeries)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getUrl(), (Object)thumbnail.getUrl())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ThumbnailSeries it = (ThumbnailSeries)element$iv;
                boolean bl = false;
                this.thumbnailsSeriesRepository.delete(it.getId());
            }
        }
        this.thumbnailsSeriesRepository.insert(ThumbnailSeries.copy$default((ThumbnailSeries)thumbnail, null, null, (boolean)false, null, null, (long)0L, null, null, null, null, null, (int)2043, null));
        boolean selected = switch (WhenMappings.$EnumSwitchMapping$1[markSelected.ordinal()]) {
            case 1 -> true;
            case 2 -> {
                if (this.thumbnailsSeriesRepository.findSelectedBySeriesIdOrNull(thumbnail.getSeriesId()) == null) {
                    yield true;
                }
                yield false;
            }
            case 3 -> false;
            default -> throw new NoWhenBranchMatchedException();
        };
        if (selected) {
            this.thumbnailsSeriesRepository.markSelected(thumbnail);
        }
        ThumbnailSeries newThumbnail = ThumbnailSeries.copy$default((ThumbnailSeries)thumbnail, null, null, (boolean)selected, null, null, (long)0L, null, null, null, null, null, (int)2043, null);
        this.eventPublisher.publishEvent((Object)new DomainEvent.ThumbnailSeriesAdded(newThumbnail));
        return newThumbnail;
    }

    public void deleteThumbnailForSeries(@NotNull ThumbnailSeries thumbnail) {
        Intrinsics.checkNotNullParameter((Object)thumbnail, (String)"thumbnail");
        if (!(thumbnail.getType() == ThumbnailSeries.Type.USER_UPLOADED)) {
            boolean bl = false;
            String string = "Only uploaded thumbnails can be deleted";
            throw new IllegalArgumentException(string.toString());
        }
        this.thumbnailsSeriesRepository.delete(thumbnail.getId());
        this.eventPublisher.publishEvent((Object)new DomainEvent.ThumbnailSeriesDeleted(thumbnail));
    }

    /*
     * WARNING - void declaration
     */
    public void deleteSeriesFiles(@NotNull Series series) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)series, (String)"series");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(series.getPath(), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            SeriesLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
            return;
        }
        if (!Files.isWritable(series.getPath())) {
            SeriesLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
            return;
        }
        Iterable $this$mapNotNull$iv = this.thumbnailsSeriesRepository.findAllBySeriesIdIdAndType(series.getId(), ThumbnailSeries.Type.SIDECAR);
        boolean $i$f$mapNotNull = false;
        Iterator iterator = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Path path2;
            URI uRI;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ThumbnailSeries it = (ThumbnailSeries)element$iv$iv;
            boolean bl2 = false;
            Serializable serializable = it.getUrl();
            if (serializable != null && (serializable = (uRI = serializable.toURI())) != null) {
                Intrinsics.checkNotNull((Object)serializable);
                Path path3 = Paths.get(uRI);
                path2 = path3;
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
            } else {
                path2 = null;
            }
            if (path2 == null) continue;
            Path it$iv$iv = path2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path it = (Path)element$iv$iv;
            boolean bl = false;
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            boolean bl4 = Files.exists(it, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) && Files.isWritable(it);
            if (!bl4) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List thumbnails = (List)destination$iv$iv;
        Iterable $this$forEach$iv = this.bookRepository.findAllBySeriesId(series.getId());
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Book it = (Book)element$iv;
            boolean bl = false;
            this.bookLifecycle.deleteBookFiles(it);
        }
        $this$forEach$iv = thumbnails;
        $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Path it = (Path)element$iv;
            boolean bl = false;
            if (!Files.deleteIfExists(it)) continue;
            SeriesLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        }
        LinkOption[] linkOptionArray3 = new LinkOption[]{};
        if (Files.exists(series.getPath(), Arrays.copyOf(linkOptionArray3, linkOptionArray3.length)) && PathsKt.listDirectoryEntries$default((Path)series.getPath(), null, (int)1, null).isEmpty() && Files.deleteIfExists(series.getPath())) {
            SeriesLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
            this.historicalEventRepository.insert((HistoricalEvent)new HistoricalEvent.SeriesFolderDeleted(series, "Folder was deleted because it was empty"));
        }
        this.softDeleteMany((Collection)CollectionsKt.listOf((Object)series));
    }

    /*
     * WARNING - void declaration
     */
    private void thumbnailsHouseKeeping(String seriesId) {
        void $this$filterTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        SeriesLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        Iterable $this$mapNotNull$iv = this.thumbnailsSeriesRepository.findAllBySeriesId(seriesId);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<ThumbnailSeries> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ThumbnailSeries thumbnailSeries;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ThumbnailSeries it = (ThumbnailSeries)element$iv$iv;
            boolean bl2 = false;
            if (!it.exists()) {
                SeriesLifecycleKt.access$getLogger$p().warn((Function0)thumbnailsHouseKeeping.all.1.1.INSTANCE);
                this.thumbnailsSeriesRepository.delete(it.getId());
                thumbnailSeries = null;
            } else {
                thumbnailSeries = it;
            }
            if (thumbnailSeries == null) continue;
            ThumbnailSeries it$iv$iv = thumbnailSeries;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List all2 = (List)destination$iv$iv;
        Iterable $this$filter$iv = all2;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ThumbnailSeries it = (ThumbnailSeries)element$iv$iv;
            boolean bl = false;
            if (!it.getSelected()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List selected = (List)destination$iv$iv2;
        if (selected.size() > 1) {
            SeriesLifecycleKt.access$getLogger$p().info((Function0)thumbnailsHouseKeeping.2.INSTANCE);
            this.thumbnailsSeriesRepository.markSelected((ThumbnailSeries)selected.get(0));
        } else if (selected.isEmpty() && !((Collection)all2).isEmpty()) {
            SeriesLifecycleKt.access$getLogger$p().info((Function0)thumbnailsHouseKeeping.3.INSTANCE);
            this.thumbnailsSeriesRepository.markSelected((ThumbnailSeries)CollectionsKt.first((List)all2));
        }
    }

    private static final void addBooks$lambda$15(SeriesLifecycle this$0, List $toAdd, TransactionStatus it) {
        Book it2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$toAdd, (String)"$toAdd");
        this$0.bookRepository.insert((Collection)$toAdd);
        Iterable iterable = $toAdd;
        Object object = this$0.mediaRepository;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Book book = (Book)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Media(null, null, null, 0, null, null, null, it2.getId(), false, false, null, null, 3967, null));
        }
        object.insert((Collection)((List)destination$iv$iv));
        $this$map$iv = $toAdd;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it2 = (Book)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(new BookMetadata(it2.getName(), null, String.valueOf(it2.getNumber()), (float)it2.getNumber(), null, null, null, null, null, false, false, false, false, false, false, false, false, false, it2.getId(), null, null, 1834994, null));
        }
        List it3 = (List)destination$iv$iv;
        boolean bl = false;
        this$0.bookMetadataRepository.insert((Collection)it3);
    }

    private static final void createSeries$lambda$17(SeriesLifecycle this$0, Series $series, TransactionStatus it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$series, (String)"$series");
        this$0.seriesRepository.insert($series);
        this$0.seriesMetadataRepository.insert(new SeriesMetadata(null, $series.getName(), LanguageUtilsKt.stripAccents((String)$series.getName()), null, null, null, null, null, null, null, null, null, null, null, false, false, false, false, false, false, false, false, false, false, false, false, false, false, $series.getId(), null, null, 0x6FFFFFF9, null));
        this$0.bookMetadataAggregationRepository.insert(new BookMetadataAggregation(null, null, null, null, null, $series.getId(), null, null, 223, null));
    }

    /*
     * WARNING - void declaration
     */
    private static final void softDeleteMany$lambda$20(SeriesLifecycle this$0, Collection $series, LocalDateTime $deletedDate, TransactionStatus it) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$series, (String)"$series");
        Iterable iterable = $series;
        BookRepository bookRepository = this$0.bookRepository;
        BookLifecycle bookLifecycle = this$0.bookLifecycle;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Series series = (Series)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getId());
        }
        collection = (List)destination$iv$iv;
        bookLifecycle.softDeleteMany(bookRepository.findAllBySeriesIds((Collection)collection));
        Iterable $this$forEach$iv = $series;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Series it3 = (Series)element$iv;
            boolean bl = false;
            SeriesRepository.DefaultImpls.update$default((SeriesRepository)this$0.seriesRepository, (Series)Series.copy$default((Series)it3, null, null, null, null, null, (int)0, (LocalDateTime)$deletedDate, (boolean)false, null, null, (int)959, null), (boolean)false, (int)2, null);
        }
    }

    private static final void deleteMany$lambda$23(SeriesLifecycle this$0, List $seriesIds, TransactionStatus it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$seriesIds, (String)"$seriesIds");
        this$0.bookLifecycle.deleteMany(this$0.bookRepository.findAllBySeriesIds((Collection)$seriesIds));
        this$0.readProgressRepository.deleteBySeriesIds((Collection)$seriesIds);
        this$0.collectionRepository.removeSeriesFromAll((Collection)$seriesIds);
        this$0.thumbnailsSeriesRepository.deleteBySeriesIds((Collection)$seriesIds);
        this$0.seriesMetadataRepository.delete((Collection)$seriesIds);
        this$0.bookMetadataAggregationRepository.delete((Collection)$seriesIds);
        this$0.seriesRepository.delete((Collection)$seriesIds);
    }

    public static final /* synthetic */ Regex access$getWhitespacePattern$p(SeriesLifecycle $this) {
        return $this.whitespacePattern;
    }
}

