/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.domain.service;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.gotson.komga.domain.model.Dimension;
import org.gotson.komga.domain.model.ThumbnailBook;
import org.gotson.komga.domain.model.ThumbnailReadList;
import org.gotson.komga.domain.model.ThumbnailSeries;
import org.gotson.komga.domain.model.ThumbnailSeriesCollection;
import org.gotson.komga.domain.persistence.ThumbnailBookRepository;
import org.gotson.komga.domain.persistence.ThumbnailReadListRepository;
import org.gotson.komga.domain.persistence.ThumbnailSeriesCollectionRepository;
import org.gotson.komga.domain.persistence.ThumbnailSeriesRepository;
import org.gotson.komga.domain.service.ThumbnailLifecycle;
import org.gotson.komga.domain.service.ThumbnailLifecycleKt;
import org.gotson.komga.infrastructure.image.ImageAnalyzer;
import org.gotson.komga.infrastructure.mediacontainer.ContentDetector;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0002)*B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0084\u0001\u0010\u000f\u001a\u00020\u0010\"\b\b\u0000\u0010\u0011*\u00020\u00012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00132\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00110\u00170\u00152\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u0002H\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00152\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u0002H\u00110\u001b2\u0018\u0010\u001c\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00110\u001d\u0012\u0004\u0012\u00020\u001e0\u0015H\u0012J\b\u0010\u001f\u001a\u00020\u0010H\u0012J\b\u0010 \u001a\u00020\u0010H\u0012J\b\u0010!\u001a\u00020\u0010H\u0012J\b\u0010\"\u001a\u00020\u0010H\u0012J\b\u0010#\u001a\u00020\u0010H\u0016J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&H\u0012J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(H\u0012R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/gotson/komga/domain/service/ThumbnailLifecycle;", "", "thumbnailBookRepository", "Lorg/gotson/komga/domain/persistence/ThumbnailBookRepository;", "thumbnailCollection", "Lorg/gotson/komga/domain/persistence/ThumbnailSeriesCollectionRepository;", "thumbnailReadListRepository", "Lorg/gotson/komga/domain/persistence/ThumbnailReadListRepository;", "thumbnailSeriesRepository", "Lorg/gotson/komga/domain/persistence/ThumbnailSeriesRepository;", "contentDetector", "Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;", "imageAnalyzer", "Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;", "(Lorg/gotson/komga/domain/persistence/ThumbnailBookRepository;Lorg/gotson/komga/domain/persistence/ThumbnailSeriesCollectionRepository;Lorg/gotson/komga/domain/persistence/ThumbnailReadListRepository;Lorg/gotson/komga/domain/persistence/ThumbnailSeriesRepository;Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;)V", "fixThumbnailMetadata", "", "T", "clazz", "Lkotlin/reflect/KClass;", "fetcher", "Lkotlin/Function1;", "Lorg/springframework/data/domain/Pageable;", "Lorg/springframework/data/domain/Page;", "supplier", "Lorg/gotson/komga/domain/service/ThumbnailLifecycle$ThumbnailMetadata;", "copier", "Lkotlin/Function2;", "updater", "", "", "fixThumbnailMetadataBook", "fixThumbnailMetadataCollection", "fixThumbnailMetadataReadList", "fixThumbnailMetadataSeries", "fixThumbnailsMetadata", "getMetadata", "url", "Ljava/net/URL;", "byteArray", "", "Result", "ThumbnailMetadata", "komga"})
@SourceDebugExtension(value={"SMAP\nThumbnailLifecycle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThumbnailLifecycle.kt\norg/gotson/komga/domain/service/ThumbnailLifecycle\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n79#2,5:170\n113#2,6:175\n119#2:194\n1603#3,9:181\n1855#3:190\n1856#3:192\n1612#3:193\n1#4:191\n*S KotlinDebug\n*F\n+ 1 ThumbnailLifecycle.kt\norg/gotson/komga/domain/service/ThumbnailLifecycle\n*L\n126#1:170,5\n126#1:175,6\n126#1:194\n131#1:181,9\n131#1:190\n131#1:192\n131#1:193\n131#1:191\n*E\n"})
public class ThumbnailLifecycle {
    @NotNull
    private final ThumbnailBookRepository thumbnailBookRepository;
    @NotNull
    private final ThumbnailSeriesCollectionRepository thumbnailCollection;
    @NotNull
    private final ThumbnailReadListRepository thumbnailReadListRepository;
    @NotNull
    private final ThumbnailSeriesRepository thumbnailSeriesRepository;
    @NotNull
    private final ContentDetector contentDetector;
    @NotNull
    private final ImageAnalyzer imageAnalyzer;

    public ThumbnailLifecycle(@NotNull ThumbnailBookRepository thumbnailBookRepository, @NotNull ThumbnailSeriesCollectionRepository thumbnailCollection, @NotNull ThumbnailReadListRepository thumbnailReadListRepository, @NotNull ThumbnailSeriesRepository thumbnailSeriesRepository, @NotNull ContentDetector contentDetector, @NotNull ImageAnalyzer imageAnalyzer) {
        Intrinsics.checkNotNullParameter((Object)thumbnailBookRepository, (String)"thumbnailBookRepository");
        Intrinsics.checkNotNullParameter((Object)thumbnailCollection, (String)"thumbnailCollection");
        Intrinsics.checkNotNullParameter((Object)thumbnailReadListRepository, (String)"thumbnailReadListRepository");
        Intrinsics.checkNotNullParameter((Object)thumbnailSeriesRepository, (String)"thumbnailSeriesRepository");
        Intrinsics.checkNotNullParameter((Object)contentDetector, (String)"contentDetector");
        Intrinsics.checkNotNullParameter((Object)imageAnalyzer, (String)"imageAnalyzer");
        this.thumbnailBookRepository = thumbnailBookRepository;
        this.thumbnailCollection = thumbnailCollection;
        this.thumbnailReadListRepository = thumbnailReadListRepository;
        this.thumbnailSeriesRepository = thumbnailSeriesRepository;
        this.contentDetector = contentDetector;
        this.imageAnalyzer = imageAnalyzer;
    }

    public boolean fixThumbnailsMetadata() {
        return this.fixThumbnailMetadataBook() || this.fixThumbnailMetadataSeries() || this.fixThumbnailMetadataCollection() || this.fixThumbnailMetadataReadList();
    }

    private boolean fixThumbnailMetadataBook() {
        return this.fixThumbnailMetadata(Reflection.getOrCreateKotlinClass(ThumbnailBook.class), (Function1)new /* Unavailable Anonymous Inner Class!! */, (Function1)new /* Unavailable Anonymous Inner Class!! */, (Function2)fixThumbnailMetadataBook.3.INSTANCE, (Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean fixThumbnailMetadataSeries() {
        return this.fixThumbnailMetadata(Reflection.getOrCreateKotlinClass(ThumbnailSeries.class), (Function1)new /* Unavailable Anonymous Inner Class!! */, (Function1)new /* Unavailable Anonymous Inner Class!! */, (Function2)fixThumbnailMetadataSeries.3.INSTANCE, (Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean fixThumbnailMetadataCollection() {
        return this.fixThumbnailMetadata(Reflection.getOrCreateKotlinClass(ThumbnailSeriesCollection.class), (Function1)new /* Unavailable Anonymous Inner Class!! */, (Function1)new /* Unavailable Anonymous Inner Class!! */, (Function2)fixThumbnailMetadataCollection.3.INSTANCE, (Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean fixThumbnailMetadataReadList() {
        return this.fixThumbnailMetadata(Reflection.getOrCreateKotlinClass(ThumbnailReadList.class), (Function1)new /* Unavailable Anonymous Inner Class!! */, (Function1)new /* Unavailable Anonymous Inner Class!! */, (Function2)fixThumbnailMetadataReadList.3.INSTANCE, (Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - void declaration
     */
    private <T> boolean fixThumbnailMetadata(KClass<T> clazz, Function1<? super Pageable, ? extends Page<T>> fetcher, Function1<? super T, ThumbnailMetadata> supplier, Function2<? super T, ? super ThumbnailMetadata, ? extends T> copier, Function1<? super Collection<? extends T>, Unit> updater) {
        void $this$mapNotNullTo$iv$iv;
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        Pageable pageable = Pageable.ofSize((int)1000);
        Intrinsics.checkNotNullExpressionValue((Object)pageable, (String)"ofSize(...)");
        Page thumbs = (Page)fetcher.invoke((Object)pageable);
        ThumbnailLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        Iterable $this$mapNotNull$iv = (Iterable)thumbs;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object it$iv$iv;
            Object object;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            Object it = element$iv$iv;
            boolean bl3 = false;
            try {
                Intrinsics.checkNotNull(it);
                ThumbnailMetadata meta = (ThumbnailMetadata)supplier.invoke(it);
                object = meta != null ? copier.invoke(it, (Object)meta) : null;
            }
            catch (Exception e) {
                ThumbnailLifecycleKt.access$getLogger$p().error((Throwable)e, (Function0)new /* Unavailable Anonymous Inner Class!! */);
                object = null;
            }
            if (object == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List fixedThumbs2 = (List)destination$iv$iv;
        updater.invoke((Object)fixedThumbs2);
        Result result$iv$iv = new Result(fixedThumbs2.size(), (long)thumbs.getNumberOfElements() < thumbs.getTotalElements());
        TimedValue timedValue = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        Result result2 = (Result)timedValue.component1();
        long duration = timedValue.component2-UwyO8pc();
        ThumbnailLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return result2.getHasMore();
    }

    private ThumbnailMetadata getMetadata(byte[] byteArray) {
        String string = this.contentDetector.detectMediaType((InputStream)new ByteArrayInputStream(byteArray));
        long l = byteArray.length;
        Dimension dimension = this.imageAnalyzer.getDimension((InputStream)new ByteArrayInputStream(byteArray));
        if (dimension == null) {
            dimension = new Dimension(0, 0);
        }
        return new ThumbnailMetadata(string, l, dimension);
    }

    private ThumbnailMetadata getMetadata(URL url) {
        URI uRI = url.toURI();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
        Path path2 = Paths.get(uRI);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        String string = this.contentDetector.detectMediaType(path2);
        Path path3 = Path.of(url.toURI());
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"of(...)");
        long l = Files.size(path3);
        URI uRI2 = url.toURI();
        Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"toURI(...)");
        Path path4 = Paths.get(uRI2);
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(...)");
        Path path5 = path4;
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(path5, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Dimension dimension = this.imageAnalyzer.getDimension(inputStream);
        if (dimension == null) {
            dimension = new Dimension(0, 0);
        }
        return new ThumbnailMetadata(string, l, dimension);
    }

    public static final /* synthetic */ ThumbnailMetadata access$getMetadata(ThumbnailLifecycle $this, byte[] byteArray) {
        return $this.getMetadata(byteArray);
    }

    public static final /* synthetic */ ThumbnailMetadata access$getMetadata(ThumbnailLifecycle $this, URL url) {
        return $this.getMetadata(url);
    }
}

