/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.configuration;

import jakarta.annotation.PostConstruct;
import jakarta.validation.constraints.Positive;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gotson.komga.infrastructure.configuration.KomgaProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Component
@ConfigurationProperties(prefix="komga")
@Validated
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001:\u0005efghiB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010c\u001a\u00020dH\u0013R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R$\u0010\u0015\u001a\u00020\u00168\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0017\u0010\u0002\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR$\u0010\u001c\u001a\u00020\u00168\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001d\u0010\u0002\u001a\u0004\b\u001e\u0010\u0019\"\u0004\b\u001f\u0010\u001bR\u001e\u0010 \u001a\u00020!8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R$\u0010,\u001a\u00020\u00048\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b-\u0010\u0002\u001a\u0004\b.\u0010\u0006\"\u0004\b/\u0010\bR*\u00100\u001a\b\u0012\u0004\u0012\u00020\u0004018\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b2\u0010\u0002\u001a\u0004\b3\u00104\"\u0004\b5\u00106R$\u00107\u001a\u00020\u00168\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b8\u0010\u0002\u001a\u0004\b9\u0010\u0019\"\u0004\b:\u0010\u001bR\u001a\u0010;\u001a\u00020<X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u001a\u0010A\u001a\u00020\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010\u0019\"\u0004\bC\u0010\u001bR\u001a\u0010D\u001a\u00020\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010\u0019\"\u0004\bF\u0010\u001bR\u001e\u0010G\u001a\u00020!8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010#\"\u0004\bI\u0010%R$\u0010J\u001a\u00020K8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bL\u0010\u0002\u001a\u0004\bM\u0010N\"\u0004\bO\u0010PR$\u0010Q\u001a\u00020R8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bS\u0010\u0002\u001a\u0004\bT\u0010U\"\u0004\bV\u0010WR$\u0010X\u001a\u00020!8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bY\u0010\u0002\u001a\u0004\bZ\u0010#\"\u0004\b[\u0010%R$\u0010\\\u001a\u00020!8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b]\u0010\u0002\u001a\u0004\b^\u0010#\"\u0004\b_\u0010%R\u001a\u0010`\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\ba\u0010\u0012\"\u0004\bb\u0010\u0014\u00a8\u0006j"}, d2={"Lorg/gotson/komga/infrastructure/configuration/KomgaProperties;", "", "()V", "configDir", "", "getConfigDir", "()Ljava/lang/String;", "setConfigDir", "(Ljava/lang/String;)V", "cors", "Lorg/gotson/komga/infrastructure/configuration/KomgaProperties$Cors;", "getCors", "()Lorg/gotson/komga/infrastructure/configuration/KomgaProperties$Cors;", "setCors", "(Lorg/gotson/komga/infrastructure/configuration/KomgaProperties$Cors;)V", "database", "Lorg/gotson/komga/infrastructure/configuration/KomgaProperties$Database;", "getDatabase", "()Lorg/gotson/komga/infrastructure/configuration/KomgaProperties$Database;", "setDatabase", "(Lorg/gotson/komga/infrastructure/configuration/KomgaProperties$Database;)V", "deleteEmptyCollections", "", "getDeleteEmptyCollections$annotations", "getDeleteEmptyCollections", "()Z", "setDeleteEmptyCollections", "(Z)V", "deleteEmptyReadLists", "getDeleteEmptyReadLists$annotations", "getDeleteEmptyReadLists", "setDeleteEmptyReadLists", "epubDivinaLetterCountThreshold", "", "getEpubDivinaLetterCountThreshold", "()I", "setEpubDivinaLetterCountThreshold", "(I)V", "kobo", "Lorg/gotson/komga/infrastructure/configuration/KomgaProperties$Kobo;", "getKobo", "()Lorg/gotson/komga/infrastructure/configuration/KomgaProperties$Kobo;", "setKobo", "(Lorg/gotson/komga/infrastructure/configuration/KomgaProperties$Kobo;)V", "librariesScanCron", "getLibrariesScanCron$annotations", "getLibrariesScanCron", "setLibrariesScanCron", "librariesScanDirectoryExclusions", "", "getLibrariesScanDirectoryExclusions$annotations", "getLibrariesScanDirectoryExclusions", "()Ljava/util/List;", "setLibrariesScanDirectoryExclusions", "(Ljava/util/List;)V", "librariesScanStartup", "getLibrariesScanStartup$annotations", "getLibrariesScanStartup", "setLibrariesScanStartup", "lucene", "Lorg/gotson/komga/infrastructure/configuration/KomgaProperties$Lucene;", "getLucene", "()Lorg/gotson/komga/infrastructure/configuration/KomgaProperties$Lucene;", "setLucene", "(Lorg/gotson/komga/infrastructure/configuration/KomgaProperties$Lucene;)V", "oauth2AccountCreation", "getOauth2AccountCreation", "setOauth2AccountCreation", "oidcEmailVerification", "getOidcEmailVerification", "setOidcEmailVerification", "pageHashing", "getPageHashing", "setPageHashing", "rememberMe", "Lorg/gotson/komga/infrastructure/configuration/KomgaProperties$RememberMe;", "getRememberMe$annotations", "getRememberMe", "()Lorg/gotson/komga/infrastructure/configuration/KomgaProperties$RememberMe;", "setRememberMe", "(Lorg/gotson/komga/infrastructure/configuration/KomgaProperties$RememberMe;)V", "sessionTimeout", "Ljava/time/Duration;", "getSessionTimeout$annotations", "getSessionTimeout", "()Ljava/time/Duration;", "setSessionTimeout", "(Ljava/time/Duration;)V", "taskConsumers", "getTaskConsumers$annotations", "getTaskConsumers", "setTaskConsumers", "taskConsumersMax", "getTaskConsumersMax$annotations", "getTaskConsumersMax", "setTaskConsumersMax", "tasksDb", "getTasksDb", "setTasksDb", "makeDirs", "", "Cors", "Database", "Kobo", "Lucene", "RememberMe", "komga"})
public class KomgaProperties {
    @NotNull
    private String librariesScanCron = "";
    private boolean librariesScanStartup;
    @NotNull
    private List<String> librariesScanDirectoryExclusions = CollectionsKt.emptyList();
    private boolean deleteEmptyReadLists = true;
    private boolean deleteEmptyCollections = true;
    @Positive
    private int pageHashing = 3;
    @Positive
    private int epubDivinaLetterCountThreshold = 15;
    @NotNull
    private RememberMe rememberMe = new RememberMe();
    @DurationUnit(value=ChronoUnit.SECONDS)
    @NotNull
    private Duration sessionTimeout;
    private boolean oauth2AccountCreation;
    private boolean oidcEmailVerification;
    @NotNull
    private Database database;
    @NotNull
    private Database tasksDb;
    @NotNull
    private Cors cors;
    @NotNull
    private Lucene lucene;
    @Nullable
    private String configDir;
    @NotNull
    private Kobo kobo;
    @Positive
    private int taskConsumers;
    @Positive
    private int taskConsumersMax;

    public KomgaProperties() {
        Duration duration = Duration.ofMinutes(30L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
        this.sessionTimeout = duration;
        this.oidcEmailVerification = true;
        this.database = new Database();
        this.tasksDb = new Database();
        this.cors = new Cors();
        this.lucene = new Lucene();
        this.kobo = new Kobo();
        this.taskConsumers = 1;
        this.taskConsumersMax = 1;
    }

    @PostConstruct
    private void makeDirs() {
        try {
            Path path2 = Paths.get(this.getDatabase().getFile(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            Path path3 = path2.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"getParent(...)");
            Path path4 = path3;
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path4, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    public String getLibrariesScanCron() {
        return this.librariesScanCron;
    }

    public void setLibrariesScanCron(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.librariesScanCron = string;
    }

    @Deprecated(message="Moved to library options since 1.5.0")
    public static /* synthetic */ void getLibrariesScanCron$annotations() {
    }

    public boolean getLibrariesScanStartup() {
        return this.librariesScanStartup;
    }

    public void setLibrariesScanStartup(boolean bl) {
        this.librariesScanStartup = bl;
    }

    @Deprecated(message="Moved to library options since 1.5.0")
    public static /* synthetic */ void getLibrariesScanStartup$annotations() {
    }

    @NotNull
    public List<String> getLibrariesScanDirectoryExclusions() {
        return this.librariesScanDirectoryExclusions;
    }

    public void setLibrariesScanDirectoryExclusions(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.librariesScanDirectoryExclusions = list;
    }

    @Deprecated(message="Moved to library options since 1.5.0")
    public static /* synthetic */ void getLibrariesScanDirectoryExclusions$annotations() {
    }

    public boolean getDeleteEmptyReadLists() {
        return this.deleteEmptyReadLists;
    }

    public void setDeleteEmptyReadLists(boolean bl) {
        this.deleteEmptyReadLists = bl;
    }

    @Deprecated(message="Moved to server settings since 1.5.0")
    public static /* synthetic */ void getDeleteEmptyReadLists$annotations() {
    }

    public boolean getDeleteEmptyCollections() {
        return this.deleteEmptyCollections;
    }

    public void setDeleteEmptyCollections(boolean bl) {
        this.deleteEmptyCollections = bl;
    }

    @Deprecated(message="Moved to server settings since 1.5.0")
    public static /* synthetic */ void getDeleteEmptyCollections$annotations() {
    }

    public int getPageHashing() {
        return this.pageHashing;
    }

    public void setPageHashing(int n) {
        this.pageHashing = n;
    }

    public int getEpubDivinaLetterCountThreshold() {
        return this.epubDivinaLetterCountThreshold;
    }

    public void setEpubDivinaLetterCountThreshold(int n) {
        this.epubDivinaLetterCountThreshold = n;
    }

    @NotNull
    public RememberMe getRememberMe() {
        return this.rememberMe;
    }

    public void setRememberMe(@NotNull RememberMe rememberMe) {
        Intrinsics.checkNotNullParameter((Object)rememberMe, (String)"<set-?>");
        this.rememberMe = rememberMe;
    }

    @Deprecated(message="Moved to server settings since 1.5.0")
    public static /* synthetic */ void getRememberMe$annotations() {
    }

    @NotNull
    public Duration getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
        this.sessionTimeout = duration;
    }

    @Deprecated(message="Removed since 1.5.0", replaceWith=@ReplaceWith(expression="server.servlet.session.timeout", imports={}))
    public static /* synthetic */ void getSessionTimeout$annotations() {
    }

    public boolean getOauth2AccountCreation() {
        return this.oauth2AccountCreation;
    }

    public void setOauth2AccountCreation(boolean bl) {
        this.oauth2AccountCreation = bl;
    }

    public boolean getOidcEmailVerification() {
        return this.oidcEmailVerification;
    }

    public void setOidcEmailVerification(boolean bl) {
        this.oidcEmailVerification = bl;
    }

    @NotNull
    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(@NotNull Database database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"<set-?>");
        this.database = database;
    }

    @NotNull
    public Database getTasksDb() {
        return this.tasksDb;
    }

    public void setTasksDb(@NotNull Database database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"<set-?>");
        this.tasksDb = database;
    }

    @NotNull
    public Cors getCors() {
        return this.cors;
    }

    public void setCors(@NotNull Cors cors) {
        Intrinsics.checkNotNullParameter((Object)cors, (String)"<set-?>");
        this.cors = cors;
    }

    @NotNull
    public Lucene getLucene() {
        return this.lucene;
    }

    public void setLucene(@NotNull Lucene lucene) {
        Intrinsics.checkNotNullParameter((Object)lucene, (String)"<set-?>");
        this.lucene = lucene;
    }

    @Nullable
    public String getConfigDir() {
        return this.configDir;
    }

    public void setConfigDir(@Nullable String string) {
        this.configDir = string;
    }

    @NotNull
    public Kobo getKobo() {
        return this.kobo;
    }

    public void setKobo(@NotNull Kobo kobo) {
        Intrinsics.checkNotNullParameter((Object)kobo, (String)"<set-?>");
        this.kobo = kobo;
    }

    public int getTaskConsumers() {
        return this.taskConsumers;
    }

    public void setTaskConsumers(int n) {
        this.taskConsumers = n;
    }

    @Deprecated(message="Artemis has been replaced")
    public static /* synthetic */ void getTaskConsumers$annotations() {
    }

    public int getTaskConsumersMax() {
        return this.taskConsumersMax;
    }

    public void setTaskConsumersMax(int n) {
        this.taskConsumersMax = n;
    }

    @Deprecated(message="Artemis has been replaced")
    public static /* synthetic */ void getTaskConsumersMax$annotations() {
    }
}

