/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.datasource;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.gotson.komga.infrastructure.configuration.KomgaProperties;
import org.gotson.komga.infrastructure.datasource.SqliteUdfDataSource;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.sqlite.SQLiteConfig;
import org.sqlite.SQLiteDataSource;

@Configuration
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0012J\b\u0010\u000e\u001a\u00020\u000fH\u0017J\b\u0010\u0010\u001a\u00020\u000fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/gotson/komga/infrastructure/datasource/DataSourcesConfiguration;", "", "komgaProperties", "Lorg/gotson/komga/infrastructure/configuration/KomgaProperties;", "(Lorg/gotson/komga/infrastructure/configuration/KomgaProperties;)V", "buildDataSource", "Lcom/zaxxer/hikari/HikariDataSource;", "poolName", "", "dataSourceClass", "Ljava/lang/Class;", "Lorg/sqlite/SQLiteDataSource;", "databaseProps", "Lorg/gotson/komga/infrastructure/configuration/KomgaProperties$Database;", "sqliteDataSource", "Ljavax/sql/DataSource;", "tasksDataSource", "komga"})
@SourceDebugExtension(value={"SMAP\nDataSourcesConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourcesConfiguration.kt\norg/gotson/komga/infrastructure/datasource/DataSourcesConfiguration\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n125#2:77\n152#2,3:78\n1#3:81\n*S KotlinDebug\n*F\n+ 1 DataSourcesConfiguration.kt\norg/gotson/komga/infrastructure/datasource/DataSourcesConfiguration\n*L\n40#1:77\n40#1:78,3\n*E\n"})
public class DataSourcesConfiguration {
    @NotNull
    private final KomgaProperties komgaProperties;

    public DataSourcesConfiguration(@NotNull KomgaProperties komgaProperties) {
        Intrinsics.checkNotNullParameter((Object)komgaProperties, (String)"komgaProperties");
        this.komgaProperties = komgaProperties;
    }

    @Bean(value={"sqliteDataSource"})
    @Primary
    @NotNull
    public DataSource sqliteDataSource() {
        return (DataSource)this.buildDataSource("SqliteMainPool", SqliteUdfDataSource.class, this.komgaProperties.getDatabase());
    }

    @Bean(value={"tasksDataSource"})
    @NotNull
    public DataSource tasksDataSource() {
        HikariDataSource hikariDataSource;
        HikariDataSource $this$tasksDataSource_u24lambda_u240 = hikariDataSource = this.buildDataSource("SqliteTasksPool", SQLiteDataSource.class, this.komgaProperties.getTasksDb());
        boolean bl = false;
        $this$tasksDataSource_u24lambda_u240.setMaximumPoolSize(1);
        return (DataSource)hikariDataSource;
    }

    /*
     * WARNING - void declaration
     */
    private HikariDataSource buildDataSource(String poolName, Class<? extends SQLiteDataSource> dataSourceClass, KomgaProperties.Database databaseProps) {
        HikariConfig hikariConfig;
        int n;
        Object it;
        SQLiteDataSource dataSource;
        Object object;
        Map it2 = databaseProps.getPragmas();
        boolean bl = false;
        if (it2.isEmpty()) {
            object = "";
        } else {
            void $this$mapTo$iv$iv;
            Map $this$map$iv = it2;
            boolean $i$f$map = false;
            Map map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String key2 = (String)entry.getKey();
                String value = (String)entry.getValue();
                collection.add(key2 + "=" + value);
            }
            object = "?" + CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
        }
        String extraPragmas = object;
        SQLiteDataSource $this$buildDataSource_u24lambda_u243 = dataSource = (SQLiteDataSource)DataSourceBuilder.create().driverClassName("org.sqlite.JDBC").url("jdbc:sqlite:" + databaseProps.getFile() + extraPragmas).type(dataSourceClass).build();
        boolean bl3 = false;
        $this$buildDataSource_u24lambda_u243.setEnforceForeignKeys(true);
        $this$buildDataSource_u24lambda_u243.setGetGeneratedKeys(false);
        KomgaProperties.Database $this$buildDataSource_u24lambda_u246 = databaseProps;
        boolean bl4 = false;
        SQLiteConfig.JournalMode journalMode = $this$buildDataSource_u24lambda_u246.getJournalMode();
        if (journalMode != null) {
            it = journalMode;
            boolean bl5 = false;
            dataSource.setJournalMode(it.name());
        }
        Duration duration = $this$buildDataSource_u24lambda_u246.getBusyTimeout();
        if (duration != null) {
            it = duration;
            boolean bl6 = false;
            dataSource.getConfig().setBusyTimeout((int)((Duration)it).toMillis());
        }
        if (StringsKt.contains$default((CharSequence)databaseProps.getFile(), (CharSequence)":memory:", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)databaseProps.getFile(), (CharSequence)"mode=memory", (boolean)false, (int)2, null)) {
            n = 1;
        } else if (databaseProps.getPoolSize() != null) {
            Integer n2 = databaseProps.getPoolSize();
            Intrinsics.checkNotNull((Object)n2);
            n = n2;
        } else {
            n = RangesKt.coerceAtMost((int)Runtime.getRuntime().availableProcessors(), (int)databaseProps.getMaxPoolSize());
        }
        int poolSize = n;
        HikariConfig $this$buildDataSource_u24lambda_u247 = hikariConfig = new HikariConfig();
        boolean bl7 = false;
        $this$buildDataSource_u24lambda_u247.setDataSource((DataSource)dataSource);
        $this$buildDataSource_u24lambda_u247.setPoolName(poolName);
        $this$buildDataSource_u24lambda_u247.setMaximumPoolSize(poolSize);
        HikariConfig hikariConfig2 = hikariConfig;
        return new HikariDataSource(hikariConfig2);
    }
}

