/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.coobird.thumbnailator.Thumbnails;
import org.gotson.komga.domain.model.Dimension;
import org.gotson.komga.infrastructure.image.ImageAnalyzer;
import org.gotson.komga.infrastructure.image.ImageConverter;
import org.gotson.komga.infrastructure.image.ImageConverterKt;
import org.gotson.komga.infrastructure.image.ImageType;
import org.gotson.komga.infrastructure.mediacontainer.ContentDetector;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\tH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0012J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!H\u0012J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!H\u0012J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\tH\u0016J*\u0010'\u001a\f\u0012\u0006\b\u0001\u0012\u00020)\u0018\u00010(2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0012J \u0010-\u001a\u00020!2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J \u0010.\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0007\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR)\u0010\u000f\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000e\u001a\u0004\b\u0010\u0010\fR)\u0010\u0012\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000e\u001a\u0004\b\u0013\u0010\fR)\u0010\u0015\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u000e\u001a\u0004\b\u0016\u0010\fR\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/gotson/komga/infrastructure/image/ImageConverter;", "", "imageAnalyzer", "Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;", "contentDetector", "Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;", "(Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;)V", "supportedReadFormats", "", "", "kotlin.jvm.PlatformType", "getSupportedReadFormats", "()Ljava/util/List;", "supportedReadFormats$delegate", "Lkotlin/Lazy;", "supportedReadMediaTypes", "getSupportedReadMediaTypes", "supportedReadMediaTypes$delegate", "supportedWriteFormats", "getSupportedWriteFormats", "supportedWriteFormats$delegate", "supportedWriteMediaTypes", "getSupportedWriteMediaTypes", "supportedWriteMediaTypes$delegate", "supportsTransparency", "canConvertMediaType", "", "from", "to", "chooseWebpReader", "", "containsAlphaChannel", "image", "Ljava/awt/image/BufferedImage;", "containsTransparency", "convertImage", "", "imageBytes", "format", "resizeImageBuilder", "Lnet/coobird/thumbnailator/Thumbnails$Builder;", "Ljava/io/InputStream;", "Lorg/gotson/komga/infrastructure/image/ImageType;", "size", "", "resizeImageToBufferedImage", "resizeImageToByteArray", "komga"})
@SourceDebugExtension(value={"SMAP\nImageConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageConverter.kt\norg/gotson/komga/infrastructure/image/ImageConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n288#2,2:151\n1855#2,2:153\n*S KotlinDebug\n*F\n+ 1 ImageConverter.kt\norg/gotson/komga/infrastructure/image/ImageConverter\n*L\n49#1:151,2\n50#1:153,2\n*E\n"})
public class ImageConverter {
    @NotNull
    private final ImageAnalyzer imageAnalyzer;
    @NotNull
    private final ContentDetector contentDetector;
    @NotNull
    private final Lazy supportedReadFormats$delegate;
    @NotNull
    private final Lazy supportedReadMediaTypes$delegate;
    @NotNull
    private final Lazy supportedWriteFormats$delegate;
    @NotNull
    private final Lazy supportedWriteMediaTypes$delegate;
    @NotNull
    private final List<String> supportsTransparency;

    public ImageConverter(@NotNull ImageAnalyzer imageAnalyzer, @NotNull ContentDetector contentDetector) {
        Intrinsics.checkNotNullParameter((Object)imageAnalyzer, (String)"imageAnalyzer");
        Intrinsics.checkNotNullParameter((Object)contentDetector, (String)"contentDetector");
        this.imageAnalyzer = imageAnalyzer;
        this.contentDetector = contentDetector;
        this.supportedReadFormats$delegate = LazyKt.lazy((Function0)((Function0)supportedReadFormats.2.INSTANCE));
        this.supportedReadMediaTypes$delegate = LazyKt.lazy((Function0)((Function0)supportedReadMediaTypes.2.INSTANCE));
        this.supportedWriteFormats$delegate = LazyKt.lazy((Function0)((Function0)supportedWriteFormats.2.INSTANCE));
        this.supportedWriteMediaTypes$delegate = LazyKt.lazy((Function0)((Function0)supportedWriteMediaTypes.2.INSTANCE));
        this.chooseWebpReader();
        ImageConverterKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        ImageConverterKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        ImageConverterKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        ImageConverterKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        this.supportsTransparency = CollectionsKt.listOf((Object)"png");
    }

    @NotNull
    public List<String> getSupportedReadFormats() {
        Lazy lazy = this.supportedReadFormats$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public List<String> getSupportedReadMediaTypes() {
        Lazy lazy = this.supportedReadMediaTypes$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public List<String> getSupportedWriteFormats() {
        Lazy lazy = this.supportedWriteFormats$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public List<String> getSupportedWriteMediaTypes() {
        Lazy lazy = this.supportedWriteMediaTypes$delegate;
        return (List)lazy.getValue();
    }

    private void chooseWebpReader() {
        block4: {
            Object v1;
            List providers;
            block3: {
                Iterator<ImageReaderSpi> iterator = IIORegistry.getDefaultInstance().getServiceProviders(ImageReaderSpi.class, ImageConverter::chooseWebpReader$lambda$0, false);
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"getServiceProviders(...)");
                providers = SequencesKt.toList((Sequence)SequencesKt.asSequence(iterator));
                if (providers.size() <= 1) break block4;
                ImageConverterKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
                Iterable $this$firstOrNull$iv = providers;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ImageReaderSpi it = (ImageReaderSpi)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getClass().getCanonicalName(), (Object)"com.github.gotson.nightmonkeys.webp.imageio.plugins.WebpImageReaderSpi")) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            ImageReaderSpi imageReaderSpi = v1;
            if (imageReaderSpi != null) {
                ImageReaderSpi nightMonkeys = imageReaderSpi;
                boolean bl = false;
                Iterable $this$forEach$iv = CollectionsKt.minus((Iterable)providers, (Object)nightMonkeys);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ImageReaderSpi it = (ImageReaderSpi)element$iv;
                    boolean bl2 = false;
                    ImageConverterKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
                    IIORegistry.getDefaultInstance().deregisterServiceProvider(it);
                }
            }
        }
    }

    public boolean canConvertMediaType(@NotNull String from, @NotNull String to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        return this.getSupportedReadMediaTypes().contains(from) && this.getSupportedWriteMediaTypes().contains(to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @NotNull
    public byte[] convertImage(@NotNull byte[] imageBytes, @NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)imageBytes, (String)"imageBytes");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        var3_3 = new ByteArrayOutputStream();
        var4_4 = null;
        try {
            baos = (ByteArrayOutputStream)var3_3;
            $i$a$-use-ImageConverter$convertImage$1 = false;
            image = ImageIO.read(new ByteArrayInputStream(imageBytes));
            if (this.supportsTransparency.contains(format)) ** GOTO lbl-1000
            Intrinsics.checkNotNull((Object)image);
            if (this.containsAlphaChannel(image)) {
                if (this.containsTransparency(image)) {
                    ImageConverterKt.access$getLogger$p().info((Function0)convertImage.1.result.1.INSTANCE);
                } else {
                    ImageConverterKt.access$getLogger$p().info((Function0)convertImage.1.result.2.INSTANCE);
                }
                it = var8_10 = new BufferedImage(image.getWidth(), image.getHeight(), 1);
                $i$a$-also-ImageConverter$convertImage$1$result$3 = false;
                it.createGraphics().drawImage(image, 0, 0, Color.WHITE, null);
                v0 = var8_10;
            } else lbl-1000:
            // 2 sources

            {
                v0 = image;
            }
            result = v0;
            ImageIO.write((RenderedImage)result, format, baos);
            var5_5 = baos.toByteArray();
        }
        catch (Throwable var5_6) {
            var4_4 = var5_6;
            throw var5_6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var3_3, (Throwable)var4_4);
        }
        Intrinsics.checkNotNullExpressionValue((Object)var5_5, (String)"use(...)");
        return var5_5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public byte[] resizeImageToByteArray(@NotNull byte[] imageBytes, @NotNull ImageType format, int size) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)imageBytes, (String)"imageBytes");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Thumbnails.Builder builder = this.resizeImageBuilder(imageBytes, format, size);
        if (builder == null) {
            return imageBytes;
        }
        Thumbnails.Builder builder2 = builder;
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream it = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            builder2.toOutputStream((OutputStream)it);
            byArray = it.toByteArray();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"use(...)");
        return byArray;
    }

    @NotNull
    public BufferedImage resizeImageToBufferedImage(@NotNull byte[] imageBytes, @NotNull ImageType format, int size) {
        Intrinsics.checkNotNullParameter((Object)imageBytes, (String)"imageBytes");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Thumbnails.Builder builder = this.resizeImageBuilder(imageBytes, format, size);
        if (builder == null) {
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(imageBytes));
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"read(...)");
            return bufferedImage;
        }
        Thumbnails.Builder builder2 = builder;
        BufferedImage bufferedImage = builder2.asBufferedImage();
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"asBufferedImage(...)");
        return bufferedImage;
    }

    private Thumbnails.Builder<? extends InputStream> resizeImageBuilder(byte[] imageBytes, ImageType format, int size) {
        Integer longestEdge;
        Integer n;
        Dimension dimension = this.imageAnalyzer.getDimension((InputStream)new ByteArrayInputStream(imageBytes));
        if (dimension != null) {
            Dimension it = dimension;
            boolean bl = false;
            String mediaType2 = this.contentDetector.detectMediaType((InputStream)new ByteArrayInputStream(imageBytes));
            int longestEdge2 = Math.max(it.getHeight(), it.getWidth());
            if (Intrinsics.areEqual((Object)mediaType2, (Object)format.getMediaType()) && longestEdge2 <= size) {
                return null;
            }
            n = longestEdge2;
        } else {
            n = null;
        }
        Integer n2 = longestEdge = n;
        int resizeTo = n2 != null ? Math.min(n2, size) : size;
        InputStream[] inputStreamArray = new InputStream[]{new ByteArrayInputStream(imageBytes)};
        return Thumbnails.of((InputStream[])inputStreamArray).size(resizeTo, resizeTo).imageType(2).outputFormat(format.getImageIOFormat());
    }

    private boolean containsAlphaChannel(BufferedImage image) {
        return image.getColorModel().hasAlpha();
    }

    private boolean containsTransparency(BufferedImage image) {
        int n = image.getWidth();
        for (int x = 0; x < n; ++x) {
            int n2 = image.getHeight();
            for (int y = 0; y < n2; ++y) {
                int pixel = image.getRGB(x, y);
                if (pixel >> 24 != 0) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean chooseWebpReader$lambda$0(Object it) {
        if (!(it instanceof ImageReaderSpi)) return false;
        String[] stringArray = ((ImageReaderSpi)it).getMIMETypes();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getMIMETypes(...)");
        if (!ArraysKt.contains((Object[])stringArray, (Object)"image/webp")) return false;
        return true;
    }
}

