/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.jooq;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.model.AgeRestriction;
import org.gotson.komga.domain.model.AllowExclude;
import org.gotson.komga.domain.model.BookSearch;
import org.gotson.komga.domain.model.ContentRestrictions;
import org.gotson.komga.domain.model.MediaExtension;
import org.gotson.komga.domain.model.MediaProfile;
import org.gotson.komga.domain.model.MediaType;
import org.gotson.komga.jooq.main.Tables;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.BatchBindStep;
import org.jooq.CaseWhenStep;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.False;
import org.jooq.Field;
import org.jooq.Query;
import org.jooq.Record1;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectJoinStep;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.data.domain.Sort;

/*
 * Exception performing whole class analysis ignored.
 */
@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u008c\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0000\u001a\u0004\u0018\u0001H\u0001\"\u0006\b\u0000\u0010\u0001\u0018\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0086\b\u00a2\u0006\u0002\u0010\u0005\u001a \u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0004\u001a \u0010\u000b\u001a\u00020\f*\b\u0012\u0004\u0012\u00020\t0\r2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000f\u001a \u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u000f\u001a#\u0010\u0016\u001a\u0015\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\t0\t0\r\u00a2\u0006\u0002\b\u0018*\b\u0012\u0004\u0012\u00020\t0\r\u001a9\u0010\u0019\u001a1\u0012(\u0012&\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\t0\t \u0017*\u0012\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\t0\t\u0018\u00010\u001b0\u001b0\u001a\u00a2\u0006\u0002\b\u0018*\u00020\u0012\u001a\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u0004*\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001e\u001a.\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140\r*\b\u0012\u0004\u0012\u00020\t0\r2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0!2\b\b\u0002\u0010\"\u001a\u00020#\u001a\n\u0010$\u001a\u00020\f*\u00020%\u001a\u0012\u0010$\u001a\u00020\f*\u00020&2\u0006\u0010'\u001a\u00020\u0012\u001a4\u0010(\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001e0)0!*\u00020*2\u001a\u0010+\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\r0,\u001a0\u0010-\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u001e\u0018\u00010)*\u00020.2\u001a\u0010+\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\r0,\u001a#\u0010/\u001a\u0015\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\t0\t0\r\u00a2\u0006\u0002\b\u0018*\b\u0012\u0004\u0012\u00020\t0\r\u00a8\u00060"}, d2={"deserializeJsonGz", "T", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "gzJson", "", "(Lcom/fasterxml/jackson/databind/ObjectMapper;[B)Ljava/lang/Object;", "deserializeMediaExtension", "Lorg/gotson/komga/domain/model/MediaExtension;", "extensionClass", "", "extensionBlob", "inOrNoCondition", "Lorg/jooq/Condition;", "Lorg/jooq/Field;", "list", "", "insertTempStrings", "", "Lorg/jooq/DSLContext;", "batchSize", "", "collection", "noCase", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "selectTempStrings", "Lorg/jooq/SelectJoinStep;", "Lorg/jooq/Record1;", "serializeJsonGz", "obj", "", "sortByValues", "values", "", "asc", "", "toCondition", "Lorg/gotson/komga/domain/model/BookSearch;", "Lorg/gotson/komga/domain/model/ContentRestrictions;", "dsl", "toOrderBy", "Lorg/jooq/SortField;", "Lorg/springframework/data/domain/Sort;", "sorts", "", "toSortField", "Lorg/springframework/data/domain/Sort$Order;", "udfStripAccents", "komga"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\norg/gotson/komga/infrastructure/jooq/UtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n1603#2,9:163\n1855#2:172\n1856#2:174\n1612#2:175\n1864#2,3:176\n1855#2:179\n1855#2,2:180\n1856#2:182\n1360#2:184\n1446#2,2:185\n1549#2:187\n1620#2,3:188\n1448#2,3:191\n1#3:173\n1#3:183\n*S KotlinDebug\n*F\n+ 1 Utils.kt\norg/gotson/komga/infrastructure/jooq/UtilsKt\n*L\n24#1:163,9\n24#1:172\n24#1:174\n24#1:175\n39#1:176,3\n59#1:179\n63#1:180,2\n59#1:182\n80#1:184\n80#1:185,2\n80#1:187\n80#1:188,3\n80#1:191,3\n24#1:173\n*E\n"})
public final class UtilsKt {
    @NotNull
    public static final Field<String> noCase(@NotNull Field<String> $this$noCase) {
        Intrinsics.checkNotNullParameter($this$noCase, (String)"<this>");
        Field field = $this$noCase.collate("NOCASE");
        Intrinsics.checkNotNullExpressionValue((Object)field, (String)"collate(...)");
        return field;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<SortField<? extends Object>> toOrderBy(@NotNull Sort $this$toOrderBy, @NotNull Map<String, ? extends Field<? extends Object>> sorts) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toOrderBy, (String)"<this>");
        Intrinsics.checkNotNullParameter(sorts, (String)"sorts");
        Iterable $this$mapNotNull$iv = (Iterable)$this$toOrderBy;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            SortField it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Sort.Order it = (Sort.Order)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if (UtilsKt.toSortField((Sort.Order)it, sorts) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final SortField<? extends Object> toSortField(@NotNull Sort.Order $this$toSortField, @NotNull Map<String, ? extends Field<? extends Object>> sorts) {
        Intrinsics.checkNotNullParameter((Object)$this$toSortField, (String)"<this>");
        Intrinsics.checkNotNullParameter(sorts, (String)"sorts");
        Field<? extends Object> field = sorts.get($this$toSortField.getProperty());
        if (field == null) {
            return null;
        }
        Field<? extends Object> f = field;
        return $this$toSortField.isAscending() ? f.asc() : f.desc();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Field<Integer> sortByValues(@NotNull Field<String> $this$sortByValues, @NotNull List<String> values, boolean asc) {
        Intrinsics.checkNotNullParameter($this$sortByValues, (String)"<this>");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        CaseWhenStep c = null;
        CaseWhenStep caseWhenStep = DSL.choose($this$sortByValues).when((Object)"dummy dsl", (Object)Integer.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)caseWhenStep, (String)"when(...)");
        c = caseWhenStep;
        int multiplier = asc ? 1 : -1;
        Iterable $this$forEachIndexed$iv = values;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void value;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)c.when((Object)value, (Object)(index * multiplier)), (String)"when(...)");
        }
        Field field = c.otherwise((Object)Integer.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)field, (String)"otherwise(...)");
        return field;
    }

    public static /* synthetic */ Field sortByValues$default(Field field, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return UtilsKt.sortByValues((Field)field, (List)list, (boolean)bl);
    }

    @NotNull
    public static final Condition inOrNoCondition(@NotNull Field<String> $this$inOrNoCondition, @Nullable Collection<String> list) {
        Condition condition;
        Intrinsics.checkNotNullParameter($this$inOrNoCondition, (String)"<this>");
        if (list == null) {
            Condition condition2 = DSL.noCondition();
            condition = condition2;
            Intrinsics.checkNotNullExpressionValue((Object)condition2, (String)"noCondition(...)");
        } else if (list.isEmpty()) {
            False false_ = DSL.falseCondition();
            Intrinsics.checkNotNullExpressionValue((Object)false_, (String)"falseCondition(...)");
            condition = (Condition)false_;
        } else {
            Condition condition3 = $this$inOrNoCondition.in(list);
            condition = condition3;
            Intrinsics.checkNotNullExpressionValue((Object)condition3, (String)"in(...)");
        }
        return condition;
    }

    @NotNull
    public static final Field<String> udfStripAccents(@NotNull Field<String> $this$udfStripAccents) {
        Intrinsics.checkNotNullParameter($this$udfStripAccents, (String)"<this>");
        Field[] fieldArray = new Field[]{$this$udfStripAccents};
        Field field = DSL.function((String)"UDF_STRIP_ACCENTS", String.class, (Field[])fieldArray);
        Intrinsics.checkNotNullExpressionValue((Object)field, (String)"function(...)");
        return field;
    }

    public static final void insertTempStrings(@NotNull DSLContext $this$insertTempStrings, int batchSize, @NotNull Collection<String> collection) {
        Intrinsics.checkNotNullParameter((Object)$this$insertTempStrings, (String)"<this>");
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        $this$insertTempStrings.deleteFrom((Table)Tables.TEMP_STRING_LIST).execute();
        if (!collection.isEmpty()) {
            Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)collection, (int)batchSize);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BatchBindStep batchBindStep;
                List chunk = (List)element$iv;
                boolean bl = false;
                BatchBindStep step = batchBindStep = $this$insertTempStrings.batch((Query)$this$insertTempStrings.insertInto((Table)Tables.TEMP_STRING_LIST, (Field)Tables.TEMP_STRING_LIST.STRING).values(null));
                boolean bl2 = false;
                Iterable $this$forEach$iv2 = chunk;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String it = (String)element$iv2;
                    boolean bl3 = false;
                    Object[] objectArray = new Object[]{it};
                    step.bind(objectArray);
                }
                batchBindStep.execute();
            }
        }
    }

    @NotNull
    public static final SelectJoinStep<Record1<String>> selectTempStrings(@NotNull DSLContext $this$selectTempStrings) {
        Intrinsics.checkNotNullParameter((Object)$this$selectTempStrings, (String)"<this>");
        SelectJoinStep selectJoinStep = $this$selectTempStrings.select((SelectField)Tables.TEMP_STRING_LIST.STRING).from((TableLike)Tables.TEMP_STRING_LIST);
        Intrinsics.checkNotNullExpressionValue((Object)selectJoinStep, (String)"from(...)");
        return selectJoinStep;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Condition toCondition(@NotNull BookSearch $this$toCondition) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)$this$toCondition, (String)"<this>");
        Condition c = null;
        Condition condition = DSL.noCondition();
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"noCondition(...)");
        c = condition;
        if ($this$toCondition.getLibraryIds() != null) {
            Condition condition2 = c.and(Tables.BOOK.LIBRARY_ID.in($this$toCondition.getLibraryIds()));
            Intrinsics.checkNotNullExpressionValue((Object)condition2, (String)"and(...)");
            c = condition2;
        }
        if (!((collection = $this$toCondition.getSeriesIds()) == null || collection.isEmpty())) {
            Condition condition3 = c.and(Tables.BOOK.SERIES_ID.in($this$toCondition.getSeriesIds()));
            Intrinsics.checkNotNullExpressionValue((Object)condition3, (String)"and(...)");
            c = condition3;
        }
        String string = $this$toCondition.getSearchTerm();
        if (string != null) {
            String it = string;
            boolean bl = false;
            Condition condition4 = c.and(Tables.BOOK_METADATA.TITLE.containsIgnoreCase((Object)it));
            Intrinsics.checkNotNullExpressionValue((Object)condition4, (String)"and(...)");
            c = condition4;
        }
        collection = $this$toCondition.getMediaStatus();
        if (!(collection == null || collection.isEmpty())) {
            Condition condition5 = c.and(Tables.MEDIA.STATUS.in($this$toCondition.getMediaStatus()));
            Intrinsics.checkNotNullExpressionValue((Object)condition5, (String)"and(...)");
            c = condition5;
        }
        if (!((collection = $this$toCondition.getMediaProfile()) == null || collection.isEmpty())) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Iterable iterable = $this$toCondition.getMediaProfile();
            TableField tableField = Tables.MEDIA.MEDIA_TYPE;
            Condition condition6 = c;
            boolean $i$f$flatMap = false;
            void bl = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                MediaProfile profile2 = (MediaProfile)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$map$iv = MediaType.Companion.matchingMediaProfile(profile2);
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    MediaType mediaType2 = (MediaType)item$iv$iv;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl3 = false;
                    collection2.add(it.getType());
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List list = (List)destination$iv$iv;
            Condition condition7 = condition6.and(tableField.in((Collection)CollectionsKt.toSet((Iterable)list)));
            Intrinsics.checkNotNullExpressionValue((Object)condition7, (String)"and(...)");
            c = condition7;
        }
        if (Intrinsics.areEqual((Object)$this$toCondition.getDeleted(), (Object)true)) {
            Condition condition8 = c.and(Tables.BOOK.DELETED_DATE.isNotNull());
            Intrinsics.checkNotNullExpressionValue((Object)condition8, (String)"and(...)");
            c = condition8;
        }
        if (Intrinsics.areEqual((Object)$this$toCondition.getDeleted(), (Object)false)) {
            Condition condition9 = c.and(Tables.BOOK.DELETED_DATE.isNull());
            Intrinsics.checkNotNullExpressionValue((Object)condition9, (String)"and(...)");
            c = condition9;
        }
        if ($this$toCondition.getReleasedAfter() != null) {
            Condition condition10 = c.and(Tables.BOOK_METADATA.RELEASE_DATE.gt((Object)$this$toCondition.getReleasedAfter()));
            Intrinsics.checkNotNullExpressionValue((Object)condition10, (String)"and(...)");
            c = condition10;
        }
        return c;
    }

    @NotNull
    public static final Condition toCondition(@NotNull ContentRestrictions $this$toCondition, @NotNull DSLContext dsl) {
        Intrinsics.checkNotNullParameter((Object)$this$toCondition, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dsl, (String)"dsl");
        AgeRestriction ageRestriction = $this$toCondition.getAgeRestriction();
        Condition condition = (ageRestriction != null ? ageRestriction.getRestriction() : null) == AllowExclude.ALLOW_ONLY ? Tables.SERIES_METADATA.AGE_RATING.isNotNull().and(Tables.SERIES_METADATA.AGE_RATING.lessOrEqual((Object)$this$toCondition.getAgeRestriction().getAge())) : DSL.noCondition();
        Intrinsics.checkNotNull((Object)condition);
        Condition ageAllowed = condition;
        Condition condition2 = !((Collection)$this$toCondition.getLabelsAllow()).isEmpty() ? Tables.SERIES_METADATA.SERIES_ID.in((Select)dsl.select((SelectField)Tables.SERIES_METADATA_SHARING.SERIES_ID).from((TableLike)Tables.SERIES_METADATA_SHARING).where(Tables.SERIES_METADATA_SHARING.LABEL.in((Collection)$this$toCondition.getLabelsAllow()))) : DSL.noCondition();
        Intrinsics.checkNotNull((Object)condition2);
        Condition labelAllowed = condition2;
        AgeRestriction ageRestriction2 = $this$toCondition.getAgeRestriction();
        Condition condition3 = (ageRestriction2 != null ? ageRestriction2.getRestriction() : null) == AllowExclude.EXCLUDE ? Tables.SERIES_METADATA.AGE_RATING.isNull().or(Tables.SERIES_METADATA.AGE_RATING.lessThan((Object)$this$toCondition.getAgeRestriction().getAge())) : DSL.noCondition();
        Intrinsics.checkNotNull((Object)condition3);
        Condition ageDenied = condition3;
        Condition condition4 = !((Collection)$this$toCondition.getLabelsExclude()).isEmpty() ? Tables.SERIES_METADATA.SERIES_ID.notIn((Select)dsl.select((SelectField)Tables.SERIES_METADATA_SHARING.SERIES_ID).from((TableLike)Tables.SERIES_METADATA_SHARING).where(Tables.SERIES_METADATA_SHARING.LABEL.in((Collection)$this$toCondition.getLabelsExclude()))) : DSL.noCondition();
        Intrinsics.checkNotNull((Object)condition4);
        Condition labelDenied = condition4;
        Condition condition5 = ageAllowed.or(labelAllowed).and(ageDenied.and(labelDenied));
        Intrinsics.checkNotNullExpressionValue((Object)condition5, (String)"and(...)");
        return condition5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final byte[] serializeJsonGz(@NotNull ObjectMapper $this$serializeJsonGz, @NotNull Object obj) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$serializeJsonGz, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        try {
            byte[] byArray;
            object = new ByteArrayOutputStream();
            Throwable throwable = null;
            try {
                byte[] byArray2;
                ByteArrayOutputStream baos = (ByteArrayOutputStream)object;
                boolean bl = false;
                Closeable closeable = new GZIPOutputStream(baos);
                Throwable throwable2 = null;
                try {
                    GZIPOutputStream gz = (GZIPOutputStream)closeable;
                    boolean bl2 = false;
                    $this$serializeJsonGz.writeValue((OutputStream)gz, obj);
                    byArray2 = baos.toByteArray();
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                }
                byArray = byArray2;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = byArray;
        }
        catch (Exception e) {
            object = null;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final /* synthetic */ <T> T deserializeJsonGz(ObjectMapper $this$deserializeJsonGz, byte[] gzJson) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$deserializeJsonGz, (String)"<this>");
        boolean $i$f$deserializeJsonGz = false;
        if (gzJson == null) {
            return null;
        }
        try {
            Object object2;
            object = new GZIPInputStream(new ByteArrayInputStream(gzJson));
            Throwable throwable = null;
            try {
                GZIPInputStream gz = (GZIPInputStream)object;
                boolean bl = false;
                InputStream inputStream = gz;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                Object object3 = $this$deserializeJsonGz.readValue(inputStream, Object.class);
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                object2 = object3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
            }
            object = object2;
        }
        catch (Exception e) {
            object = null;
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final MediaExtension deserializeMediaExtension(@NotNull ObjectMapper $this$deserializeMediaExtension, @Nullable String extensionClass, @Nullable byte[] extensionBlob) {
        Closeable closeable;
        Intrinsics.checkNotNullParameter((Object)$this$deserializeMediaExtension, (String)"<this>");
        if (extensionClass == null || extensionBlob == null) {
            return null;
        }
        try {
            MediaExtension mediaExtension;
            closeable = new GZIPInputStream(new ByteArrayInputStream(extensionBlob));
            Throwable throwable = null;
            try {
                GZIPInputStream gz = (GZIPInputStream)closeable;
                boolean bl = false;
                Object object = $this$deserializeMediaExtension.readValue((InputStream)gz, Class.forName(extensionClass));
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gotson.komga.domain.model.MediaExtension");
                mediaExtension = (MediaExtension)object;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            closeable = mediaExtension;
        }
        catch (Exception e) {
            closeable = null;
        }
        return closeable;
    }
}

