/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.jooq.main;

import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.model.Book;
import org.gotson.komga.domain.model.BookSearch;
import org.gotson.komga.domain.persistence.BookRepository;
import org.gotson.komga.infrastructure.jooq.UtilsKt;
import org.gotson.komga.jooq.main.Tables;
import org.gotson.komga.jooq.main.tables.BookMetadata;
import org.gotson.komga.jooq.main.tables.Media;
import org.gotson.komga.jooq.main.tables.ReadProgress;
import org.gotson.komga.jooq.main.tables.records.BookRecord;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.BatchBindStep;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Query;
import org.jooq.RecordMapper;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectSeekStepN;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0014\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00050\u0011H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\u0016\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u001dH\u0017J\b\u0010\u001e\u001a\u00020\u001aH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001dH\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001d2\u0006\u0010#\u001a\u00020$H\u0016J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0%2\u0006\u0010#\u001a\u00020$2\u0006\u0010&\u001a\u00020'H\u0016J$\u0010(\u001a\b\u0012\u0004\u0012\u00020\"0\u001d2\u0006\u0010)\u001a\u00020\u00122\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00120\u001dH\u0016J&\u0010+\u001a\b\u0012\u0004\u0012\u00020\"0\u001d2\u0006\u0010)\u001a\u00020\u00122\u0006\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u0012H\u0016J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\"0\u001d2\u0006\u0010)\u001a\u00020\u0012H\u0016J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\"0\u001d2\u0006\u00100\u001a\u00020\u0012H\u0016J\u001c\u00101\u001a\b\u0012\u0004\u0012\u00020\"0\u001d2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00120\u001dH\u0016J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\"0\u001d2\u0006\u00104\u001a\u00020\u0017H\u0016J\u001e\u00105\u001a\b\u0012\u0004\u0012\u00020\u00120\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u00106\u001a\u000207H\u0016J\u0016\u00108\u001a\b\u0012\u0004\u0012\u00020\u00120\u001d2\u0006\u0010)\u001a\u00020\u0012H\u0016J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020\u00120\u001d2\u0006\u00100\u001a\u00020\u0012H\u0016J\u001c\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00120\u001d2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00120\u001dH\u0016J$\u0010;\u001a\b\u0012\u0004\u0012\u00020\"0\u001d2\u0006\u0010)\u001a\u00020\u00122\f\u0010<\u001a\b\u0012\u0004\u0012\u00020=0\u001dH\u0017J\u0012\u0010>\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\u001a\u0010>\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0012H\u0012J\u0012\u0010?\u001a\u0004\u0018\u00010\u00122\u0006\u00100\u001a\u00020\u0012H\u0016J\u001a\u0010@\u001a\u0004\u0018\u00010\u00122\u0006\u00100\u001a\u00020\u00122\u0006\u0010A\u001a\u00020\u0012H\u0016J\u0012\u0010B\u001a\u0004\u0018\u00010\u00122\u0006\u00100\u001a\u00020\u0012H\u0016J\u001a\u0010C\u001a\u0004\u0018\u00010\"2\u0006\u0010)\u001a\u00020\u00122\u0006\u0010D\u001a\u00020=H\u0016J\u0014\u0010E\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020F0\u0011H\u0016J\u0012\u0010G\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\u0012\u0010H\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\u0016\u0010I\u001a\u00020\u001a2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\"0\u001dH\u0017J\u0010\u0010I\u001a\u00020\u001a2\u0006\u0010K\u001a\u00020\"H\u0017J\u0016\u0010L\u001a\u00020\u001a2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\"0\u001dH\u0017J\u0010\u0010L\u001a\u00020\u001a2\u0006\u0010K\u001a\u00020\"H\u0017J\u0010\u0010M\u001a\u00020\u001a2\u0006\u0010K\u001a\u00020\"H\u0012J\f\u0010N\u001a\u00020\"*\u00020\u0014H\u0012R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \t*\u0004\u0018\u00010\u000b0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \t*\u0004\u0018\u00010\r0\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \t*\u0004\u0018\u00010\u000f0\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R^\u0010\u0010\u001aR\u0012\u0004\u0012\u00020\u0012\u0012H\u0012F\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00140\u0014\u0012\u000e\b\u0001\u0012\n \t*\u0004\u0018\u00010\u00150\u0015 \t*\"\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00140\u0014\u0012\u000e\b\u0001\u0012\n \t*\u0004\u0018\u00010\u00150\u0015\u0018\u00010\u00130\u00130\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lorg/gotson/komga/infrastructure/jooq/main/BookDao;", "Lorg/gotson/komga/domain/persistence/BookRepository;", "dsl", "Lorg/jooq/DSLContext;", "batchSize", "", "(Lorg/jooq/DSLContext;I)V", "b", "Lorg/gotson/komga/jooq/main/tables/Book;", "kotlin.jvm.PlatformType", "d", "Lorg/gotson/komga/jooq/main/tables/BookMetadata;", "m", "Lorg/gotson/komga/jooq/main/tables/Media;", "r", "Lorg/gotson/komga/jooq/main/tables/ReadProgress;", "sorts", "", "", "Lorg/jooq/TableField;", "Lorg/gotson/komga/jooq/main/tables/records/BookRecord;", "", "count", "", "countGroupedByLibraryId", "delete", "", "bookId", "bookIds", "", "deleteAll", "existsById", "", "findAll", "Lorg/gotson/komga/domain/model/Book;", "bookSearch", "Lorg/gotson/komga/domain/model/BookSearch;", "Lorg/springframework/data/domain/Page;", "pageable", "Lorg/springframework/data/domain/Pageable;", "findAllByLibraryIdAndMediaTypes", "libraryId", "mediaTypes", "findAllByLibraryIdAndMismatchedExtension", "mediaType", "extension", "findAllByLibraryIdAndWithEmptyHash", "findAllBySeriesId", "seriesId", "findAllBySeriesIds", "seriesIds", "findAllDeletedByFileSize", "fileSize", "findAllIds", "sort", "Lorg/springframework/data/domain/Sort;", "findAllIdsByLibraryId", "findAllIdsBySeriesId", "findAllIdsBySeriesIds", "findAllNotDeletedByLibraryIdAndUrlNotIn", "urls", "Ljava/net/URL;", "findByIdOrNull", "findFirstIdInSeriesOrNull", "findFirstUnreadIdInSeriesOrNull", "userId", "findLastIdInSeriesOrNull", "findNotDeletedByLibraryIdAndUrlOrNull", "url", "getFilesizeGroupedByLibraryId", "Ljava/math/BigDecimal;", "getLibraryIdOrNull", "getSeriesIdOrNull", "insert", "books", "book", "update", "updateBook", "toDomain", "komga"})
@SourceDebugExtension(value={"SMAP\nBookDao.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookDao.kt\norg/gotson/komga/infrastructure/jooq/main/BookDao\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,387:1\n1549#2:388\n1620#2,3:389\n1855#2:393\n1855#2,2:394\n1856#2:396\n1549#2:397\n1620#2,3:398\n1#3:392\n*S KotlinDebug\n*F\n+ 1 BookDao.kt\norg/gotson/komga/infrastructure/jooq/main/BookDao\n*L\n86#1:388\n86#1:389,3\n277#1:393\n294#1:394,2\n277#1:396\n321#1:397\n321#1:398,3\n*E\n"})
public class BookDao
implements BookRepository {
    @NotNull
    private final DSLContext dsl;
    private final int batchSize;
    private final org.gotson.komga.jooq.main.tables.Book b;
    private final Media m;
    private final BookMetadata d;
    private final ReadProgress r;
    @NotNull
    private final Map<String, TableField<BookRecord, ? extends Object>> sorts;

    public BookDao(@NotNull DSLContext dsl, @Value(value="#{@komgaProperties.database.batchChunkSize}") int batchSize) {
        Intrinsics.checkNotNullParameter((Object)dsl, (String)"dsl");
        this.dsl = dsl;
        this.batchSize = batchSize;
        this.b = Tables.BOOK;
        this.m = Tables.MEDIA;
        this.d = Tables.BOOK_METADATA;
        this.r = Tables.READ_PROGRESS;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"createdDate", (Object)this.b.CREATED_DATE), TuplesKt.to((Object)"seriesId", (Object)this.b.SERIES_ID), TuplesKt.to((Object)"number", (Object)this.b.NUMBER)};
        this.sorts = MapsKt.mapOf((Pair[])pairArray);
    }

    @Nullable
    public Book findByIdOrNull(@NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        return this.findByIdOrNull(this.dsl, bookId);
    }

    @Nullable
    public Book findNotDeletedByLibraryIdAndUrlOrNull(@NotNull String libraryId, @NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Result result2 = this.dsl.selectFrom((TableLike)this.b).where(this.b.LIBRARY_ID.eq((Object)libraryId).and(this.b.URL.eq((Object)url.toString()))).and(this.b.DELETED_DATE.isNull()).orderBy((OrderField)this.b.LAST_MODIFIED_DATE.desc()).fetchInto((Table)this.b);
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"fetchInto(...)");
        BookRecord bookRecord = (BookRecord)CollectionsKt.firstOrNull((List)((List)result2));
        return bookRecord != null ? this.toDomain(bookRecord) : null;
    }

    private Book findByIdOrNull(DSLContext dsl, String bookId) {
        BookRecord bookRecord = (BookRecord)dsl.selectFrom((TableLike)this.b).where(this.b.ID.eq((Object)bookId)).fetchOneInto((Table)this.b);
        return bookRecord != null ? this.toDomain(bookRecord) : null;
    }

    @NotNull
    public Collection<Book> findAllBySeriesId(@NotNull String seriesId) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        List list = this.dsl.selectFrom((TableLike)this.b).where(this.b.SERIES_ID.eq((Object)seriesId)).fetchInto((Table)this.b).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    @NotNull
    public Collection<Book> findAllBySeriesIds(@NotNull Collection<String> seriesIds) {
        Intrinsics.checkNotNullParameter(seriesIds, (String)"seriesIds");
        List list = this.dsl.selectFrom((TableLike)this.b).where(this.b.SERIES_ID.in(seriesIds)).fetchInto((Table)this.b).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public Collection<Book> findAllNotDeletedByLibraryIdAndUrlNotIn(@NotNull String libraryId, @NotNull Collection<URL> urls) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        Iterable iterable = urls;
        int n = this.batchSize;
        DSLContext dSLContext = this.dsl;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            URL uRL = (URL)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        UtilsKt.insertTempStrings((DSLContext)dSLContext, (int)n, (Collection)collection);
        List list = this.dsl.selectFrom((TableLike)this.b).where(this.b.LIBRARY_ID.eq((Object)libraryId)).and(this.b.DELETED_DATE.isNull()).and(this.b.URL.notIn((Select)UtilsKt.selectTempStrings((DSLContext)this.dsl))).fetchInto((Table)this.b).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    @NotNull
    public Collection<Book> findAllDeletedByFileSize(long fileSize) {
        List list = this.dsl.selectFrom((TableLike)this.b).where(this.b.DELETED_DATE.isNotNull().and(this.b.FILE_SIZE.eq((Object)fileSize))).fetchInto((Table)this.b).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    @NotNull
    public Collection<Book> findAll() {
        List list = this.dsl.selectFrom((TableLike)this.b).fetchInto((Table)this.b).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    @NotNull
    public Collection<Book> findAll(@NotNull BookSearch bookSearch) {
        Intrinsics.checkNotNullParameter((Object)bookSearch, (String)"bookSearch");
        Field[] fieldArray = this.b.fields();
        List list = this.dsl.select((SelectFieldOrAsterisk[])Arrays.copyOf(fieldArray, fieldArray.length)).from((TableLike)this.b).leftJoin((TableLike)this.d).on(this.b.ID.eq((Field)this.d.BOOK_ID)).leftJoin((TableLike)this.m).on(this.b.ID.eq((Field)this.m.BOOK_ID)).where(UtilsKt.toCondition((BookSearch)bookSearch)).fetchInto((Table)this.b).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    @NotNull
    public Page<Book> findAll(@NotNull BookSearch bookSearch, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)bookSearch, (String)"bookSearch");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Condition conditions = UtilsKt.toCondition((BookSearch)bookSearch);
        Long l = (Long)this.dsl.selectCount().from((TableLike)this.b).leftJoin((TableLike)this.d).on(this.b.ID.eq((Field)this.d.BOOK_ID)).leftJoin((TableLike)this.m).on(this.b.ID.eq((Field)this.m.BOOK_ID)).where(conditions).fetchOne(0, Long.TYPE);
        if (l == null) {
            l = 0L;
        }
        long count = ((Number)l).longValue();
        Sort sort = pageable.getSort();
        Intrinsics.checkNotNullExpressionValue((Object)sort, (String)"getSort(...)");
        List orderBy = UtilsKt.toOrderBy((Sort)sort, (Map)this.sorts);
        SelectSeekStepN selectSeekStepN = this.b.fields();
        SelectSeekStepN $this$findAll_u24lambda_u241 = selectSeekStepN = this.dsl.select((SelectFieldOrAsterisk[])Arrays.copyOf(selectSeekStepN, ((Field[])selectSeekStepN).length)).from((TableLike)this.b).leftJoin((TableLike)this.d).on(this.b.ID.eq((Field)this.d.BOOK_ID)).leftJoin((TableLike)this.m).on(this.b.ID.eq((Field)this.m.BOOK_ID)).where(conditions).orderBy((Collection)orderBy);
        boolean bl = false;
        if (pageable.isPaged()) {
            $this$findAll_u24lambda_u241.limit((Number)pageable.getPageSize()).offset((Number)pageable.getOffset());
        }
        List list = selectSeekStepN.fetchInto((Table)this.b).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        List items2 = list;
        selectSeekStepN = !((Collection)orderBy).isEmpty() ? pageable.getSort() : Sort.unsorted();
        Intrinsics.checkNotNull((Object)selectSeekStepN);
        SelectSeekStepN pageSort = selectSeekStepN;
        return (Page)new PageImpl(items2, (Pageable)(pageable.isPaged() ? PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)pageSort) : PageRequest.of((int)0, (int)Math.max((int)count, 20), (Sort)pageSort)), count);
    }

    @Nullable
    public String getLibraryIdOrNull(@NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        return (String)this.dsl.select((SelectField)this.b.LIBRARY_ID).from((TableLike)this.b).where(this.b.ID.eq((Object)bookId)).fetchOne((Field)this.b.LIBRARY_ID);
    }

    @Nullable
    public String getSeriesIdOrNull(@NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        return (String)this.dsl.select((SelectField)this.b.SERIES_ID).from((TableLike)this.b).where(this.b.ID.eq((Object)bookId)).fetchOne((Field)this.b.SERIES_ID);
    }

    @Nullable
    public String findFirstIdInSeriesOrNull(@NotNull String seriesId) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        return (String)this.dsl.select((SelectField)this.b.ID).from((TableLike)this.b).leftJoin((TableLike)this.d).on(this.b.ID.eq((Field)this.d.BOOK_ID)).where(this.b.SERIES_ID.eq((Object)seriesId)).orderBy((OrderField)this.d.NUMBER_SORT).limit((Number)1).fetchOne((Field)this.b.ID);
    }

    @Nullable
    public String findLastIdInSeriesOrNull(@NotNull String seriesId) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        return (String)this.dsl.select((SelectField)this.b.ID).from((TableLike)this.b).leftJoin((TableLike)this.d).on(this.b.ID.eq((Field)this.d.BOOK_ID)).where(this.b.SERIES_ID.eq((Object)seriesId)).orderBy((OrderField)this.d.NUMBER_SORT.desc()).limit((Number)1).fetchOne((Field)this.b.ID);
    }

    @Nullable
    public String findFirstUnreadIdInSeriesOrNull(@NotNull String seriesId, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return (String)this.dsl.select((SelectField)this.b.ID).from((TableLike)this.b).leftJoin((TableLike)this.d).on(this.b.ID.eq((Field)this.d.BOOK_ID)).leftJoin((TableLike)this.r).on(this.b.ID.eq((Field)this.r.BOOK_ID)).and(this.r.USER_ID.eq((Object)userId).or(this.r.USER_ID.isNull())).where(this.b.SERIES_ID.eq((Object)seriesId)).and(this.r.COMPLETED.isNull().or(this.r.COMPLETED.isFalse())).orderBy((OrderField)this.d.NUMBER_SORT).limit((Number)1).fetchOne((Field)this.b.ID);
    }

    @NotNull
    public Collection<String> findAllIdsBySeriesId(@NotNull String seriesId) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        List list = this.dsl.select((SelectField)this.b.ID).from((TableLike)this.b).where(this.b.SERIES_ID.eq((Object)seriesId)).fetch((Field)this.b.ID);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        return list;
    }

    @NotNull
    public Collection<String> findAllIdsBySeriesIds(@NotNull Collection<String> seriesIds) {
        Intrinsics.checkNotNullParameter(seriesIds, (String)"seriesIds");
        List list = this.dsl.select((SelectField)this.b.ID).from((TableLike)this.b).where(this.b.SERIES_ID.in(seriesIds)).fetch(0, String.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        return list;
    }

    @NotNull
    public Collection<String> findAllIdsByLibraryId(@NotNull String libraryId) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        List list = this.dsl.select((SelectField)this.b.ID).from((TableLike)this.b).where(this.b.LIBRARY_ID.eq((Object)libraryId)).fetch((Field)this.b.ID);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        return list;
    }

    @NotNull
    public Collection<String> findAllIds(@NotNull BookSearch bookSearch, @NotNull Sort sort) {
        Intrinsics.checkNotNullParameter((Object)bookSearch, (String)"bookSearch");
        Intrinsics.checkNotNullParameter((Object)sort, (String)"sort");
        Condition conditions = UtilsKt.toCondition((BookSearch)bookSearch);
        List orderBy = UtilsKt.toOrderBy((Sort)sort, (Map)this.sorts);
        List list = this.dsl.select((SelectField)this.b.ID).from((TableLike)this.b).leftJoin((TableLike)this.m).on(this.b.ID.eq((Field)this.m.BOOK_ID)).leftJoin((TableLike)this.d).on(this.b.ID.eq((Field)this.d.BOOK_ID)).where(conditions).orderBy((Collection)orderBy).fetch((Field)this.b.ID);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        return list;
    }

    public boolean existsById(@NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        return this.dsl.fetchExists((Table)this.b, this.b.ID.eq((Object)bookId));
    }

    @NotNull
    public Collection<Book> findAllByLibraryIdAndMediaTypes(@NotNull String libraryId, @NotNull Collection<String> mediaTypes) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        Intrinsics.checkNotNullParameter(mediaTypes, (String)"mediaTypes");
        Field[] fieldArray = this.b.fields();
        List list = this.dsl.select((SelectFieldOrAsterisk[])Arrays.copyOf(fieldArray, fieldArray.length)).from((TableLike)this.b).leftJoin((TableLike)this.m).on(this.b.ID.eq((Field)this.m.BOOK_ID)).where(this.b.LIBRARY_ID.eq((Object)libraryId)).and(this.m.MEDIA_TYPE.in(mediaTypes)).fetchInto((Table)this.b).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    @NotNull
    public Collection<Book> findAllByLibraryIdAndMismatchedExtension(@NotNull String libraryId, @NotNull String mediaType2, @NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        Intrinsics.checkNotNullParameter((Object)mediaType2, (String)"mediaType");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Field[] fieldArray = this.b.fields();
        List list = this.dsl.select((SelectFieldOrAsterisk[])Arrays.copyOf(fieldArray, fieldArray.length)).from((TableLike)this.b).leftJoin((TableLike)this.m).on(this.b.ID.eq((Field)this.m.BOOK_ID)).where(this.b.LIBRARY_ID.eq((Object)libraryId)).and(this.m.MEDIA_TYPE.eq((Object)mediaType2)).and((Condition)this.b.URL.notLike("%." + extension)).fetchInto((Table)this.b).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    @NotNull
    public Collection<Book> findAllByLibraryIdAndWithEmptyHash(@NotNull String libraryId) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        List list = this.dsl.selectFrom((TableLike)this.b).where(this.b.LIBRARY_ID.eq((Object)libraryId)).and(this.b.FILE_HASH.eq((Object)"")).fetchInto((Table)this.b).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    @Transactional
    public void insert(@NotNull Book book) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        this.insert((Collection)CollectionsKt.listOf((Object)book));
    }

    @Transactional
    public void insert(@NotNull Collection<Book> books) {
        Intrinsics.checkNotNullParameter(books, (String)"books");
        if (!books.isEmpty()) {
            Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)books, (int)this.batchSize);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BatchBindStep batchBindStep;
                List chunk = (List)element$iv;
                boolean bl = false;
                BatchBindStep step = batchBindStep = this.dsl.batch((Query)this.dsl.insertInto((Table)this.b, (Field)this.b.ID, (Field)this.b.NAME, (Field)this.b.URL, (Field)this.b.NUMBER, (Field)this.b.FILE_LAST_MODIFIED, (Field)this.b.FILE_SIZE, (Field)this.b.FILE_HASH, (Field)this.b.LIBRARY_ID, (Field)this.b.SERIES_ID, (Field)this.b.DELETED_DATE, (Field)this.b.ONESHOT).values(null, null, null, null, null, null, null, null, null, null, null));
                boolean bl2 = false;
                Iterable $this$forEach$iv2 = chunk;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Book it = (Book)element$iv2;
                    boolean bl3 = false;
                    Object[] objectArray = new Object[]{it.getId(), it.getName(), it.getUrl(), it.getNumber(), it.getFileLastModified(), it.getFileSize(), it.getFileHash(), it.getLibraryId(), it.getSeriesId(), it.getDeletedDate(), it.getOneshot()};
                    step.bind(objectArray);
                }
                batchBindStep.execute();
            }
        }
    }

    @Transactional
    public void update(@NotNull Book book) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        this.updateBook(book);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void update(@NotNull Collection<Book> books) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(books, (String)"books");
        Iterable $this$map$iv = books;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Book book = (Book)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            this.updateBook((Book)it);
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    private void updateBook(Book book) {
        this.dsl.update((Table)this.b).set((Field)this.b.NAME, (Object)book.getName()).set((Field)this.b.URL, (Object)book.getUrl().toString()).set((Field)this.b.NUMBER, (Object)book.getNumber()).set((Field)this.b.FILE_LAST_MODIFIED, (Object)book.getFileLastModified()).set((Field)this.b.FILE_SIZE, (Object)book.getFileSize()).set((Field)this.b.FILE_HASH, (Object)book.getFileHash()).set((Field)this.b.LIBRARY_ID, (Object)book.getLibraryId()).set((Field)this.b.SERIES_ID, (Object)book.getSeriesId()).set((Field)this.b.DELETED_DATE, (Object)book.getDeletedDate()).set((Field)this.b.LAST_MODIFIED_DATE, (Object)LocalDateTime.now(ZoneId.of("Z"))).set((Field)this.b.ONESHOT, (Object)book.getOneshot()).where(this.b.ID.eq((Object)book.getId())).execute();
    }

    public void delete(@NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        this.dsl.deleteFrom((Table)this.b).where(this.b.ID.eq((Object)bookId)).execute();
    }

    @Transactional
    public void delete(@NotNull Collection<String> bookIds) {
        Intrinsics.checkNotNullParameter(bookIds, (String)"bookIds");
        UtilsKt.insertTempStrings((DSLContext)this.dsl, (int)this.batchSize, bookIds);
        this.dsl.deleteFrom((Table)this.b).where(this.b.ID.in((Select)UtilsKt.selectTempStrings((DSLContext)this.dsl))).execute();
    }

    public void deleteAll() {
        this.dsl.deleteFrom((Table)this.b).execute();
    }

    public long count() {
        return this.dsl.fetchCount((Table)this.b);
    }

    @NotNull
    public Map<String, Integer> countGroupedByLibraryId() {
        GroupField[] groupFieldArray = new GroupField[]{this.b.LIBRARY_ID};
        Map map = this.dsl.select((SelectField)this.b.LIBRARY_ID, (SelectField)DSL.count((Field)((Field)this.b.ID))).from((TableLike)this.b).groupBy(groupFieldArray).fetchMap((Field)this.b.LIBRARY_ID, (Field)DSL.count((Field)((Field)this.b.ID)));
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"fetchMap(...)");
        return map;
    }

    @NotNull
    public Map<String, BigDecimal> getFilesizeGroupedByLibraryId() {
        GroupField[] groupFieldArray = new GroupField[]{this.b.LIBRARY_ID};
        Map map = this.dsl.select((SelectField)this.b.LIBRARY_ID, (SelectField)DSL.sum((Field)((Field)this.b.FILE_SIZE))).from((TableLike)this.b).groupBy(groupFieldArray).fetchMap((Field)this.b.LIBRARY_ID, (Field)DSL.sum((Field)((Field)this.b.FILE_SIZE)));
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"fetchMap(...)");
        return map;
    }

    private Book toDomain(BookRecord $this$toDomain) {
        String string = $this$toDomain.getName();
        URL uRL = new URL($this$toDomain.getUrl());
        LocalDateTime localDateTime = $this$toDomain.getFileLastModified();
        Long l = $this$toDomain.getFileSize();
        String string2 = $this$toDomain.getFileHash();
        String string3 = $this$toDomain.getId();
        String string4 = $this$toDomain.getLibraryId();
        String string5 = $this$toDomain.getSeriesId();
        LocalDateTime localDateTime2 = $this$toDomain.getDeletedDate();
        Boolean bl = $this$toDomain.getOneshot();
        LocalDateTime localDateTime3 = $this$toDomain.getCreatedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime3, (String)"getCreatedDate(...)");
        LocalDateTime localDateTime4 = LanguageUtilsKt.toCurrentTimeZone((LocalDateTime)localDateTime3);
        LocalDateTime localDateTime5 = $this$toDomain.getLastModifiedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime5, (String)"getLastModifiedDate(...)");
        LocalDateTime localDateTime6 = LanguageUtilsKt.toCurrentTimeZone((LocalDateTime)localDateTime5);
        Integer n = $this$toDomain.getNumber();
        Intrinsics.checkNotNull((Object)string);
        Intrinsics.checkNotNull((Object)localDateTime);
        Intrinsics.checkNotNull((Object)l);
        long l2 = l;
        Intrinsics.checkNotNull((Object)string2);
        Intrinsics.checkNotNull((Object)n);
        int n2 = n;
        Intrinsics.checkNotNull((Object)string3);
        Intrinsics.checkNotNull((Object)string5);
        Intrinsics.checkNotNull((Object)string4);
        Intrinsics.checkNotNull((Object)bl);
        return new Book(string, uRL, localDateTime, l2, string2, n2, string3, string5, string4, localDateTime2, bl.booleanValue(), localDateTime4, localDateTime6);
    }

    public static final /* synthetic */ Book access$toDomain(BookDao $this, BookRecord $receiver) {
        return $this.toDomain($receiver);
    }
}

