/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.jooq.main;

import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.RangesKt;
import org.gotson.komga.domain.model.Author;
import org.gotson.komga.domain.model.BookSearchWithReadProgress;
import org.gotson.komga.domain.model.ContentRestrictions;
import org.gotson.komga.domain.model.MediaProfile;
import org.gotson.komga.domain.model.MediaType;
import org.gotson.komga.domain.model.ReadList;
import org.gotson.komga.domain.model.ReadStatus;
import org.gotson.komga.infrastructure.jooq.UtilsKt;
import org.gotson.komga.infrastructure.jooq.main.BookCommonDao;
import org.gotson.komga.infrastructure.jooq.main.BookDtoDao;
import org.gotson.komga.infrastructure.search.LuceneEntity;
import org.gotson.komga.infrastructure.search.LuceneHelper;
import org.gotson.komga.interfaces.api.persistence.BookDtoRepository;
import org.gotson.komga.interfaces.api.rest.dto.AuthorDto;
import org.gotson.komga.interfaces.api.rest.dto.BookDto;
import org.gotson.komga.interfaces.api.rest.dto.BookMetadataDto;
import org.gotson.komga.interfaces.api.rest.dto.MediaDto;
import org.gotson.komga.interfaces.api.rest.dto.ReadProgressDto;
import org.gotson.komga.interfaces.api.rest.dto.WebLinkDto;
import org.gotson.komga.jooq.main.Tables;
import org.gotson.komga.jooq.main.tables.Book;
import org.gotson.komga.jooq.main.tables.BookMetadata;
import org.gotson.komga.jooq.main.tables.BookMetadataAuthor;
import org.gotson.komga.jooq.main.tables.BookMetadataLink;
import org.gotson.komga.jooq.main.tables.BookMetadataTag;
import org.gotson.komga.jooq.main.tables.Media;
import org.gotson.komga.jooq.main.tables.ReadProgress;
import org.gotson.komga.jooq.main.tables.ReadProgressSeries;
import org.gotson.komga.jooq.main.tables.ReadlistBook;
import org.gotson.komga.jooq.main.tables.Series;
import org.gotson.komga.jooq.main.tables.SeriesMetadata;
import org.gotson.komga.jooq.main.tables.records.BookMetadataAuthorRecord;
import org.gotson.komga.jooq.main.tables.records.BookMetadataLinkRecord;
import org.gotson.komga.jooq.main.tables.records.BookMetadataRecord;
import org.gotson.komga.jooq.main.tables.records.BookMetadataTagRecord;
import org.gotson.komga.jooq.main.tables.records.BookRecord;
import org.gotson.komga.jooq.main.tables.records.MediaRecord;
import org.gotson.komga.jooq.main.tables.records.ReadProgressRecord;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record2;
import org.jooq.RecordMapper;
import org.jooq.Result;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectForUpdateStep;
import org.jooq.SelectLimitPercentStep;
import org.jooq.SelectOnConditionStep;
import org.jooq.SelectSeekStep1;
import org.jooq.SelectSeekStepN;
import org.jooq.SortField;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0098\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ.\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020*2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016JJ\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u00106\u001a\u0002072\u0006\u00101\u001a\u00020*2\u0006\u00102\u001a\u0002032\b\b\u0002\u00108\u001a\u0002092\u000e\u0010:\u001a\n\u0012\u0004\u0012\u00020*\u0018\u00010;2\b\u0010<\u001a\u0004\u0018\u00010*H\u0012JF\u0010=\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010>\u001a\u00020*2\u0006\u00101\u001a\u00020*2\u000e\u0010:\u001a\n\u0012\u0004\u0012\u00020*\u0018\u00010;2\u0006\u0010/\u001a\u0002002\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J\u001e\u0010?\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u00101\u001a\u00020*2\u0006\u00102\u001a\u000203H\u0016J6\u0010@\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u00101\u001a\u00020*2\u000e\u0010:\u001a\n\u0012\u0004\u0012\u00020*\u0018\u00010;2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J\u001a\u0010A\u001a\u0004\u0018\u00010.2\u0006\u0010B\u001a\u00020*2\u0006\u00101\u001a\u00020*H\u0016J:\u0010C\u001a\u0004\u0018\u00010.2\u0006\u0010D\u001a\u00020E2\u0006\u0010B\u001a\u00020*2\u0006\u00101\u001a\u00020*2\u000e\u0010:\u001a\n\u0012\u0004\u0012\u00020*\u0018\u00010;2\u0006\u00104\u001a\u000205H\u0016J\u001a\u0010F\u001a\u0004\u0018\u00010.2\u0006\u0010B\u001a\u00020*2\u0006\u00101\u001a\u00020*H\u0016J:\u0010G\u001a\u0004\u0018\u00010.2\u0006\u0010D\u001a\u00020E2\u0006\u0010B\u001a\u00020*2\u0006\u00101\u001a\u00020*2\u000e\u0010:\u001a\n\u0012\u0004\u0012\u00020*\u0018\u00010;2\u0006\u00104\u001a\u000205H\u0016J\u001a\u0010H\u001a\u0004\u0018\u00010.2\u0006\u0010B\u001a\u00020*2\u0006\u00101\u001a\u00020*H\u0016JB\u0010I\u001a\u0004\u0018\u00010.2\u0006\u0010D\u001a\u00020E2\u0006\u0010B\u001a\u00020*2\u0006\u00101\u001a\u00020*2\u000e\u0010:\u001a\n\u0012\u0004\u0012\u00020*\u0018\u00010;2\u0006\u00104\u001a\u0002052\u0006\u0010J\u001a\u000209H\u0012J\"\u0010K\u001a\u0004\u0018\u00010.2\u0006\u0010B\u001a\u00020*2\u0006\u00101\u001a\u00020*2\u0006\u0010J\u001a\u000209H\u0012J\u0010\u0010L\u001a\u0002072\u0006\u00101\u001a\u00020*H\u0012J-\u0010M\u001a\u0015\u0012\f\u0012\n \u000f*\u0004\u0018\u00010O0O0N\u00a2\u0006\u0002\bP2\u0006\u00101\u001a\u00020*2\b\b\u0002\u00108\u001a\u000209H\u0012J\u0018\u0010Q\u001a\b\u0012\u0004\u0012\u00020.0R*\b\u0012\u0004\u0012\u00020O0SH\u0012J\f\u0010T\u001a\u000207*\u000200H\u0012J6\u0010U\u001a\u00020V*\u00020W2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020Z0Y2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020*0\\2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020^0YH\u0012J.\u0010U\u001a\u00020.*\u00020_2\u0006\u0010`\u001a\u00020a2\u0006\u0010b\u001a\u00020V2\b\u0010c\u001a\u0004\u0018\u00010d2\u0006\u0010e\u001a\u00020*H\u0012J\f\u0010U\u001a\u00020a*\u00020fH\u0012J\f\u0010U\u001a\u00020d*\u00020gH\u0012R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u000f*\u0004\u0018\u00010\u00110\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u000f*\u0004\u0018\u00010\u00130\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u000f*\u0004\u0018\u00010\u00150\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \u000f*\u0004\u0018\u00010\u00170\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n \u000f*\u0004\u0018\u00010\u00190\u0019X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001bX\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0016\u0010\u001e\u001a\n \u000f*\u0004\u0018\u00010\u001f0\u001fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\n \u000f*\u0004\u0018\u00010!0!X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\n \u000f*\u0004\u0018\u00010#0#X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010$\u001a\n \u000f*\u0004\u0018\u00010%0%X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010&\u001a\n \u000f*\u0004\u0018\u00010'0'X\u0092\u0004\u00a2\u0006\u0002\n\u0000RB\u0010(\u001a6\u0012\u0004\u0012\u00020*\u0012,\u0012*\u0012\u000e\b\u0001\u0012\n \u000f*\u0004\u0018\u00010+0+ \u000f*\u0014\u0012\u000e\b\u0001\u0012\n \u000f*\u0004\u0018\u00010+0+\u0018\u00010\u001c0\u001c0)X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006h"}, d2={"Lorg/gotson/komga/infrastructure/jooq/main/BookDtoDao;", "Lorg/gotson/komga/interfaces/api/persistence/BookDtoRepository;", "dsl", "Lorg/jooq/DSLContext;", "luceneHelper", "Lorg/gotson/komga/infrastructure/search/LuceneHelper;", "batchSize", "", "transactionTemplate", "Lorg/springframework/transaction/support/TransactionTemplate;", "bookCommonDao", "Lorg/gotson/komga/infrastructure/jooq/main/BookCommonDao;", "(Lorg/jooq/DSLContext;Lorg/gotson/komga/infrastructure/search/LuceneHelper;ILorg/springframework/transaction/support/TransactionTemplate;Lorg/gotson/komga/infrastructure/jooq/main/BookCommonDao;)V", "a", "Lorg/gotson/komga/jooq/main/tables/BookMetadataAuthor;", "kotlin.jvm.PlatformType", "b", "Lorg/gotson/komga/jooq/main/tables/Book;", "bl", "Lorg/gotson/komga/jooq/main/tables/BookMetadataLink;", "bt", "Lorg/gotson/komga/jooq/main/tables/BookMetadataTag;", "d", "Lorg/gotson/komga/jooq/main/tables/BookMetadata;", "m", "Lorg/gotson/komga/jooq/main/tables/Media;", "onDeckFields", "", "Lorg/jooq/Field;", "[Lorg/jooq/Field;", "r", "Lorg/gotson/komga/jooq/main/tables/ReadProgress;", "rlb", "Lorg/gotson/komga/jooq/main/tables/ReadlistBook;", "rs", "Lorg/gotson/komga/jooq/main/tables/ReadProgressSeries;", "s", "Lorg/gotson/komga/jooq/main/tables/Series;", "sd", "Lorg/gotson/komga/jooq/main/tables/SeriesMetadata;", "sorts", "", "", "", "findAll", "Lorg/springframework/data/domain/Page;", "Lorg/gotson/komga/interfaces/api/rest/dto/BookDto;", "search", "Lorg/gotson/komga/domain/model/BookSearchWithReadProgress;", "userId", "pageable", "Lorg/springframework/data/domain/Pageable;", "restrictions", "Lorg/gotson/komga/domain/model/ContentRestrictions;", "conditions", "Lorg/jooq/Condition;", "selectReadListNumber", "", "filterOnLibraryIds", "", "searchTerm", "findAllByReadListId", "readListId", "findAllDuplicates", "findAllOnDeck", "findByIdOrNull", "bookId", "findNextInReadListOrNull", "readList", "Lorg/gotson/komga/domain/model/ReadList;", "findNextInSeriesOrNull", "findPreviousInReadListOrNull", "findPreviousInSeriesOrNull", "findSiblingReadList", "next", "findSiblingSeries", "readProgressCondition", "selectBase", "Lorg/jooq/SelectOnConditionStep;", "Lorg/jooq/Record;", "Lorg/jetbrains/annotations/NotNull;", "fetchAndMap", "", "Lorg/jooq/ResultQuery;", "toCondition", "toDto", "Lorg/gotson/komga/interfaces/api/rest/dto/BookMetadataDto;", "Lorg/gotson/komga/jooq/main/tables/records/BookMetadataRecord;", "authors", "", "Lorg/gotson/komga/interfaces/api/rest/dto/AuthorDto;", "tags", "", "links", "Lorg/gotson/komga/interfaces/api/rest/dto/WebLinkDto;", "Lorg/gotson/komga/jooq/main/tables/records/BookRecord;", "media", "Lorg/gotson/komga/interfaces/api/rest/dto/MediaDto;", "metadata", "readProgress", "Lorg/gotson/komga/interfaces/api/rest/dto/ReadProgressDto;", "seriesTitle", "Lorg/gotson/komga/jooq/main/tables/records/MediaRecord;", "Lorg/gotson/komga/jooq/main/tables/records/ReadProgressRecord;", "komga"})
@SourceDebugExtension(value={"SMAP\nBookDtoDao.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookDtoDao.kt\norg/gotson/komga/infrastructure/jooq/main/BookDtoDao\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,531:1\n1603#2,9:532\n1855#2:541\n1856#2:543\n1612#2:544\n1179#2,2:546\n1253#2,4:548\n350#2,7:552\n1360#2:559\n1446#2,2:560\n1549#2:562\n1620#2,3:563\n1448#2,3:566\n1549#2:569\n1620#2,3:570\n2661#2,7:573\n1855#2,2:580\n766#2:582\n857#2,2:583\n1490#2:585\n1520#2,3:586\n1523#2,3:596\n1490#2:599\n1520#2,3:600\n1523#2,3:610\n1490#2:613\n1520#2,3:614\n1523#2,3:624\n1#3:542\n1#3:545\n372#4,7:589\n372#4,7:603\n372#4,7:617\n*S KotlinDebug\n*F\n+ 1 BookDtoDao.kt\norg/gotson/komga/infrastructure/jooq/main/BookDtoDao\n*L\n136#1:532,9\n136#1:541\n136#1:543\n136#1:544\n261#1:546,2\n261#1:548,4\n351#1:552,7\n426#1:559\n426#1:560,2\n426#1:562\n426#1:563,3\n426#1:566,3\n434#1:569\n434#1:570,3\n440#1:573,7\n447#1:580,2\n394#1:582\n394#1:583,2\n395#1:585\n395#1:586,3\n395#1:596,3\n400#1:599\n400#1:600,3\n400#1:610,3\n405#1:613\n405#1:614,3\n405#1:624,3\n136#1:542\n395#1:589,7\n400#1:603,7\n405#1:617,7\n*E\n"})
public class BookDtoDao
implements BookDtoRepository {
    @NotNull
    private final DSLContext dsl;
    @NotNull
    private final LuceneHelper luceneHelper;
    private final int batchSize;
    @NotNull
    private final TransactionTemplate transactionTemplate;
    @NotNull
    private final BookCommonDao bookCommonDao;
    private final Book b;
    private final Media m;
    private final BookMetadata d;
    private final ReadProgress r;
    private final ReadProgressSeries rs;
    private final BookMetadataAuthor a;
    private final Series s;
    private final SeriesMetadata sd;
    private final ReadlistBook rlb;
    private final BookMetadataTag bt;
    private final BookMetadataLink bl;
    @NotNull
    private final Field<?>[] onDeckFields;
    @NotNull
    private final Map<String, Field<? extends Object>> sorts;

    public BookDtoDao(@NotNull DSLContext dsl, @NotNull LuceneHelper luceneHelper, @Value(value="#{@komgaProperties.database.batchChunkSize}") int batchSize, @NotNull TransactionTemplate transactionTemplate, @NotNull BookCommonDao bookCommonDao) {
        Intrinsics.checkNotNullParameter((Object)dsl, (String)"dsl");
        Intrinsics.checkNotNullParameter((Object)luceneHelper, (String)"luceneHelper");
        Intrinsics.checkNotNullParameter((Object)transactionTemplate, (String)"transactionTemplate");
        Intrinsics.checkNotNullParameter((Object)bookCommonDao, (String)"bookCommonDao");
        this.dsl = dsl;
        this.luceneHelper = luceneHelper;
        this.batchSize = batchSize;
        this.transactionTemplate = transactionTemplate;
        this.bookCommonDao = bookCommonDao;
        this.b = Tables.BOOK;
        this.m = Tables.MEDIA;
        this.d = Tables.BOOK_METADATA;
        this.r = Tables.READ_PROGRESS;
        this.rs = Tables.READ_PROGRESS_SERIES;
        this.a = Tables.BOOK_METADATA_AUTHOR;
        this.s = Tables.SERIES;
        this.sd = Tables.SERIES_METADATA;
        this.rlb = Tables.READLIST_BOOK;
        this.bt = Tables.BOOK_METADATA_TAG;
        this.bl = Tables.BOOK_METADATA_LINK;
        Field[] fieldArray = this.b.fields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"fields(...)");
        Object[] objectArray = fieldArray;
        Field[] fieldArray2 = this.m.fields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray2, (String)"fields(...)");
        Object[] objectArray2 = ArraysKt.plus((Object[])objectArray, (Object[])fieldArray2);
        Field[] fieldArray3 = this.d.fields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray3, (String)"fields(...)");
        Object[] objectArray3 = ArraysKt.plus((Object[])objectArray2, (Object[])fieldArray3);
        Field[] fieldArray4 = this.r.fields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray4, (String)"fields(...)");
        this.onDeckFields = (Field[])ArraysKt.plus((Object[])ArraysKt.plus((Object[])objectArray3, (Object[])fieldArray4), (Object)this.sd.TITLE);
        Pair[] pairArray = new Pair[18];
        pairArray[0] = TuplesKt.to((Object)"name", (Object)this.b.NAME.collate("COLLATION_UNICODE_3"));
        pairArray[1] = TuplesKt.to((Object)"created", (Object)this.b.CREATED_DATE);
        pairArray[2] = TuplesKt.to((Object)"createdDate", (Object)this.b.CREATED_DATE);
        pairArray[3] = TuplesKt.to((Object)"lastModified", (Object)this.b.LAST_MODIFIED_DATE);
        pairArray[4] = TuplesKt.to((Object)"lastModifiedDate", (Object)this.b.LAST_MODIFIED_DATE);
        pairArray[5] = TuplesKt.to((Object)"fileSize", (Object)this.b.FILE_SIZE);
        pairArray[6] = TuplesKt.to((Object)"size", (Object)this.b.FILE_SIZE);
        pairArray[7] = TuplesKt.to((Object)"fileHash", (Object)this.b.FILE_HASH);
        TableField tableField = this.b.URL;
        Intrinsics.checkNotNullExpressionValue((Object)tableField, (String)"URL");
        pairArray[8] = TuplesKt.to((Object)"url", (Object)UtilsKt.noCase((Field)((Field)tableField)));
        TableField tableField2 = this.m.STATUS;
        Intrinsics.checkNotNullExpressionValue((Object)tableField2, (String)"STATUS");
        pairArray[9] = TuplesKt.to((Object)"media.status", (Object)UtilsKt.noCase((Field)((Field)tableField2)));
        TableField tableField3 = this.m.COMMENT;
        Intrinsics.checkNotNullExpressionValue((Object)tableField3, (String)"COMMENT");
        pairArray[10] = TuplesKt.to((Object)"media.comment", (Object)UtilsKt.noCase((Field)((Field)tableField3)));
        TableField tableField4 = this.m.MEDIA_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)tableField4, (String)"MEDIA_TYPE");
        pairArray[11] = TuplesKt.to((Object)"media.mediaType", (Object)UtilsKt.noCase((Field)((Field)tableField4)));
        pairArray[12] = TuplesKt.to((Object)"metadata.title", (Object)this.d.TITLE.collate("COLLATION_UNICODE_3"));
        pairArray[13] = TuplesKt.to((Object)"metadata.numberSort", (Object)this.d.NUMBER_SORT);
        pairArray[14] = TuplesKt.to((Object)"metadata.releaseDate", (Object)this.d.RELEASE_DATE);
        pairArray[15] = TuplesKt.to((Object)"readProgress.lastModified", (Object)this.r.LAST_MODIFIED_DATE);
        pairArray[16] = TuplesKt.to((Object)"readProgress.readDate", (Object)this.r.READ_DATE);
        pairArray[17] = TuplesKt.to((Object)"readList.number", (Object)this.rlb.NUMBER);
        this.sorts = MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public Page<BookDto> findAll(@NotNull BookSearchWithReadProgress search, @NotNull String userId, @NotNull Pageable pageable, @NotNull ContentRestrictions restrictions) {
        Intrinsics.checkNotNullParameter((Object)search, (String)"search");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)restrictions, (String)"restrictions");
        Condition condition = this.toCondition(search).and(UtilsKt.toCondition((ContentRestrictions)restrictions, (DSLContext)this.dsl));
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"and(...)");
        Condition conditions = condition;
        return this.findAll(conditions, userId, pageable, false, null, search.getSearchTerm());
    }

    @NotNull
    public Page<BookDto> findAllByReadListId(@NotNull String readListId, @NotNull String userId, @Nullable Collection<String> filterOnLibraryIds, @NotNull BookSearchWithReadProgress search, @NotNull Pageable pageable, @NotNull ContentRestrictions restrictions) {
        Intrinsics.checkNotNullParameter((Object)readListId, (String)"readListId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)search, (String)"search");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)restrictions, (String)"restrictions");
        Condition condition = this.rlb.READLIST_ID.eq((Object)readListId).and(this.toCondition(search)).and(UtilsKt.toCondition((ContentRestrictions)restrictions, (DSLContext)this.dsl));
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"and(...)");
        Condition conditions = condition;
        return this.findAll(conditions, userId, pageable, true, filterOnLibraryIds, search.getSearchTerm());
    }

    /*
     * WARNING - void declaration
     */
    private Page<BookDto> findAll(Condition conditions, String userId, Pageable pageable, boolean selectReadListNumber, Collection<String> filterOnLibraryIds, String searchTerm) {
        void $this$mapNotNullTo$iv$iv;
        List bookIds = this.luceneHelper.searchEntitiesIds(searchTerm, LuceneEntity.Book);
        Condition condition = bookIds == null ? DSL.noCondition() : (bookIds.isEmpty() ? (Condition)DSL.falseCondition() : this.b.ID.in((Select)UtilsKt.selectTempStrings((DSLContext)this.dsl)));
        Intrinsics.checkNotNull((Object)condition);
        Condition searchCondition = condition;
        Sort sort = pageable.getSort();
        Intrinsics.checkNotNullExpressionValue((Object)sort, (String)"getSort(...)");
        Iterable $this$mapNotNull$iv = (Iterable)sort;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            OrderField orderField;
            Collection collection;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Sort.Order it = (Sort.Order)element$iv$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)it.getProperty(), (Object)"relevance") && !((collection = (Collection)bookIds) == null || collection.isEmpty())) {
                TableField tableField = this.b.ID;
                Intrinsics.checkNotNullExpressionValue((Object)tableField, (String)"ID");
                orderField = (OrderField)UtilsKt.sortByValues((Field)((Field)tableField), (List)bookIds, (boolean)it.isAscending());
            } else {
                Intrinsics.checkNotNull((Object)it);
                orderField = (OrderField)UtilsKt.toSortField((Sort.Order)it, (Map)this.sorts);
            }
            if (orderField == null) continue;
            OrderField it$iv$iv = orderField;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List orderBy = (List)destination$iv$iv;
        Object object = this.transactionTemplate.execute(arg_0 -> BookDtoDao.findAll$lambda$7(bookIds, this, userId, conditions, searchCondition, selectReadListNumber, orderBy, filterOnLibraryIds, pageable, arg_0));
        Intrinsics.checkNotNull((Object)object);
        Pair pair = (Pair)object;
        int count = ((Number)pair.component1()).intValue();
        List dtos = (List)pair.component2();
        Sort sort2 = !((Collection)orderBy).isEmpty() ? pageable.getSort() : Sort.unsorted();
        Intrinsics.checkNotNull((Object)sort2);
        Sort pageSort = sort2;
        return (Page)new PageImpl(dtos, (Pageable)(pageable.isPaged() ? PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)pageSort) : PageRequest.of((int)0, (int)Math.max(count, 20), (Sort)pageSort)), (long)count);
    }

    static /* synthetic */ Page findAll$default(BookDtoDao bookDtoDao, Condition condition, String string, Pageable pageable, boolean bl, Collection collection, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findAll");
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return bookDtoDao.findAll(condition, string, pageable, bl, collection, string2);
    }

    @Nullable
    public BookDto findByIdOrNull(@NotNull String bookId, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        SelectConditionStep selectConditionStep = BookDtoDao.selectBase$default((BookDtoDao)this, (String)userId, (boolean)false, (int)2, null).where(this.b.ID.eq((Object)bookId));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"where(...)");
        return (BookDto)CollectionsKt.firstOrNull((List)this.fetchAndMap((ResultQuery)selectConditionStep));
    }

    @Nullable
    public BookDto findPreviousInSeriesOrNull(@NotNull String bookId, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return this.findSiblingSeries(bookId, userId, false);
    }

    @Nullable
    public BookDto findNextInSeriesOrNull(@NotNull String bookId, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return this.findSiblingSeries(bookId, userId, true);
    }

    @Nullable
    public BookDto findPreviousInReadListOrNull(@NotNull ReadList readList, @NotNull String bookId, @NotNull String userId, @Nullable Collection<String> filterOnLibraryIds, @NotNull ContentRestrictions restrictions) {
        Intrinsics.checkNotNullParameter((Object)readList, (String)"readList");
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)restrictions, (String)"restrictions");
        return this.findSiblingReadList(readList, bookId, userId, filterOnLibraryIds, restrictions, false);
    }

    @Nullable
    public BookDto findNextInReadListOrNull(@NotNull ReadList readList, @NotNull String bookId, @NotNull String userId, @Nullable Collection<String> filterOnLibraryIds, @NotNull ContentRestrictions restrictions) {
        Intrinsics.checkNotNullParameter((Object)readList, (String)"readList");
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)restrictions, (String)"restrictions");
        return this.findSiblingReadList(readList, bookId, userId, filterOnLibraryIds, restrictions, true);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Page<BookDto> findAllOnDeck(@NotNull String userId, @Nullable Collection<String> filterOnLibraryIds, @NotNull Pageable pageable, @NotNull ContentRestrictions restrictions) {
        SelectSeekStep1 selectSeekStep1;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)restrictions, (String)"restrictions");
        Triple triple = this.bookCommonDao.getBooksOnDeckQuery(userId, restrictions, filterOnLibraryIds, this.onDeckFields);
        SelectConditionStep query = (SelectConditionStep)triple.component1();
        Field sortField = (Field)triple.component2();
        int count = this.dsl.fetchCount((Select)query);
        SelectSeekStep1 selectSeekStep12 = selectSeekStep1 = query.orderBy((OrderField)sortField.desc());
        BookDtoDao bookDtoDao = this;
        boolean bl = false;
        if (pageable.isPaged()) {
            void $this$findAllOnDeck_u24lambda_u248;
            $this$findAllOnDeck_u24lambda_u248.limit((Number)pageable.getPageSize()).offset((Number)pageable.getOffset());
        }
        SelectSeekStep1 selectSeekStep13 = selectSeekStep1;
        Intrinsics.checkNotNullExpressionValue((Object)selectSeekStep13, (String)"apply(...)");
        List dtos = bookDtoDao.fetchAndMap((ResultQuery)selectSeekStep13);
        return (Page)new PageImpl(dtos, (Pageable)(pageable.isPaged() ? PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)Sort.unsorted()) : PageRequest.of((int)0, (int)Math.max(count, 20), (Sort)Sort.unsorted())), (long)count);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Page<BookDto> findAllDuplicates(@NotNull String userId, @NotNull Pageable pageable) {
        SelectSeekStepN selectSeekStepN;
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        GroupField[] groupFieldArray = new GroupField[]{this.b.FILE_HASH, this.b.FILE_SIZE};
        Result result2 = this.dsl.select((SelectField)this.b.FILE_HASH, (SelectField)DSL.count((Field)((Field)this.b.ID))).from((TableLike)this.b).where(this.b.FILE_HASH.ne((Object)"")).groupBy(groupFieldArray).having(DSL.count((Field)((Field)this.b.ID)).gt((Object)1)).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"fetch(...)");
        Iterable iterable = (Iterable)result2;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var7_10 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo22 = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Record2 it = (Record2)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.value1(), (Object)it.value2());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map hashes = destination$iv$iv;
        int count = CollectionsKt.sumOfInt((Iterable)hashes.values());
        Sort sort = pageable.getSort();
        Intrinsics.checkNotNullExpressionValue((Object)sort, (String)"getSort(...)");
        List orderBy = UtilsKt.toOrderBy((Sort)sort, (Map)this.sorts);
        SelectSeekStepN $i$f$associateTo22 = selectSeekStepN = BookDtoDao.selectBase$default((BookDtoDao)this, (String)userId, (boolean)false, (int)2, null).where(this.b.FILE_HASH.in((Collection)hashes.keySet())).orderBy((Collection)orderBy);
        BookDtoDao bookDtoDao = this;
        boolean bl = false;
        if (pageable.isPaged()) {
            void $this$findAllDuplicates_u24lambda_u2410;
            $this$findAllDuplicates_u24lambda_u2410.limit((Number)pageable.getPageSize()).offset((Number)pageable.getOffset());
        }
        SelectSeekStepN selectSeekStepN2 = selectSeekStepN;
        Intrinsics.checkNotNullExpressionValue((Object)selectSeekStepN2, (String)"apply(...)");
        List dtos = bookDtoDao.fetchAndMap((ResultQuery)selectSeekStepN2);
        selectSeekStepN = !((Collection)orderBy).isEmpty() ? pageable.getSort() : Sort.unsorted();
        Intrinsics.checkNotNull((Object)selectSeekStepN);
        SelectSeekStepN pageSort = selectSeekStepN;
        return (Page)new PageImpl(dtos, (Pageable)(pageable.isPaged() ? PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)pageSort) : PageRequest.of((int)0, (int)Math.max(count, 20), (Sort)pageSort)), (long)count);
    }

    private Condition readProgressCondition(String userId) {
        Condition condition = this.r.USER_ID.eq((Object)userId);
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"eq(...)");
        return condition;
    }

    /*
     * WARNING - void declaration
     */
    private BookDto findSiblingSeries(String bookId, String userId, boolean next) {
        void it;
        Record record = this.dsl.select((SelectField)this.b.SERIES_ID, (SelectField)this.d.NUMBER_SORT).from((TableLike)this.b).leftJoin((TableLike)this.d).on(this.b.ID.eq((Field)this.d.BOOK_ID)).where(this.b.ID.eq((Object)bookId)).fetchOne();
        Intrinsics.checkNotNull((Object)record);
        Record2 record2 = (Record2)record;
        String seriesId = (String)record2.get(0, String.class);
        Float numberSort = (Float)record2.get(1, Float.TYPE);
        TableField tableField = this.d.NUMBER_SORT;
        SelectConditionStep selectConditionStep = BookDtoDao.selectBase$default((BookDtoDao)this, (String)userId, (boolean)false, (int)2, null).where(this.b.SERIES_ID.eq((Object)seriesId));
        BookDtoDao bookDtoDao = this;
        boolean bl = false;
        SortField sortField = next ? it.asc() : it.desc();
        SelectForUpdateStep selectForUpdateStep = selectConditionStep.orderBy((OrderField)sortField).seek((Object)numberSort).limit((Number)1);
        Intrinsics.checkNotNullExpressionValue((Object)selectForUpdateStep, (String)"limit(...)");
        return (BookDto)CollectionsKt.firstOrNull((List)bookDtoDao.fetchAndMap((ResultQuery)selectForUpdateStep));
    }

    /*
     * WARNING - void declaration
     */
    private BookDto findSiblingReadList(ReadList readList, String bookId, String userId, Collection<String> filterOnLibraryIds, ContentRestrictions restrictions, boolean next) {
        int bookIndex;
        Object it;
        List bookIds;
        Object it2;
        block12: {
            int n;
            SelectOnConditionStep $this$findSiblingReadList_u24lambda_u24132;
            if (readList.getOrdered()) {
                void it3;
                TableField $this$findSiblingReadList_u24lambda_u2416;
                SelectConditionStep $this$findSiblingReadList_u24lambda_u2414;
                SelectConditionStep selectConditionStep;
                SelectConditionStep $this$findSiblingReadList_u24lambda_u24132 = selectConditionStep = this.dsl.select((SelectField)this.rlb.NUMBER).from((TableLike)this.b).leftJoin((TableLike)this.rlb).on(this.b.ID.eq((Field)this.rlb.BOOK_ID)).where(this.b.ID.eq((Object)bookId)).and(this.rlb.READLIST_ID.eq((Object)readList.getId()));
                boolean $i$a$-apply-BookDtoDao$findSiblingReadList$numberSort$22 = false;
                Collection<String> collection = filterOnLibraryIds;
                if (collection != null) {
                    Collection<String> it4 = collection;
                    boolean bl = false;
                    $this$findSiblingReadList_u24lambda_u24132.and(this.b.LIBRARY_ID.in(it4));
                }
                Integer numberSort = (Integer)selectConditionStep.fetchOne((Field)this.rlb.NUMBER);
                SelectConditionStep $i$a$-apply-BookDtoDao$findSiblingReadList$numberSort$22 = $this$findSiblingReadList_u24lambda_u24132 = this.selectBase(userId, true).where(this.rlb.READLIST_ID.eq((Object)readList.getId()));
                BookDtoDao bookDtoDao = this;
                boolean bl = false;
                if (restrictions.isRestricted()) {
                    $this$findSiblingReadList_u24lambda_u2414.and(UtilsKt.toCondition((ContentRestrictions)restrictions, (DSLContext)this.dsl));
                }
                $this$findSiblingReadList_u24lambda_u2414 = $this$findSiblingReadList_u24lambda_u24132;
                boolean bl2 = false;
                Collection<String> collection2 = filterOnLibraryIds;
                if (collection2 != null) {
                    Collection<String> it5 = collection2;
                    boolean bl3 = false;
                    $this$findSiblingReadList_u24lambda_u2416.and(this.b.LIBRARY_ID.in(it5));
                }
                $this$findSiblingReadList_u24lambda_u2416 = this.rlb.NUMBER;
                SelectConditionStep selectConditionStep2 = $this$findSiblingReadList_u24lambda_u24132;
                boolean bl4 = false;
                SortField sortField = next ? it3.asc() : it3.desc();
                SelectForUpdateStep selectForUpdateStep = selectConditionStep2.orderBy((OrderField)sortField).seek((Object)numberSort).limit((Number)1);
                Intrinsics.checkNotNullExpressionValue((Object)selectForUpdateStep, (String)"limit(...)");
                return (BookDto)CollectionsKt.firstOrNull((List)bookDtoDao.fetchAndMap((ResultQuery)selectForUpdateStep));
            }
            SelectOnConditionStep $this$findSiblingReadList_u24lambda_u2418 = $this$findSiblingReadList_u24lambda_u24132 = this.dsl.select((SelectField)this.b.ID).from((TableLike)this.b).leftJoin((TableLike)this.rlb).on(this.b.ID.eq((Field)this.rlb.BOOK_ID)).leftJoin((TableLike)this.d).on(this.b.ID.eq((Field)this.d.BOOK_ID));
            boolean bl = false;
            if (restrictions.isRestricted()) {
                $this$findSiblingReadList_u24lambda_u2418.leftJoin((TableLike)this.sd).on(this.sd.SERIES_ID.eq((Field)this.b.SERIES_ID));
            }
            SelectOnConditionStep $this$findSiblingReadList_u24lambda_u2419 = $this$findSiblingReadList_u24lambda_u24132 = $this$findSiblingReadList_u24lambda_u24132.where(this.rlb.READLIST_ID.eq((Object)readList.getId()));
            boolean bl5 = false;
            if (restrictions.isRestricted()) {
                $this$findSiblingReadList_u24lambda_u2419.and(UtilsKt.toCondition((ContentRestrictions)restrictions, (DSLContext)this.dsl));
            }
            SelectOnConditionStep $this$findSiblingReadList_u24lambda_u2421 = $this$findSiblingReadList_u24lambda_u24132;
            boolean bl6 = false;
            Collection<String> collection = filterOnLibraryIds;
            if (collection != null) {
                it2 = collection;
                boolean bl7 = false;
                $this$findSiblingReadList_u24lambda_u2421.and(this.b.LIBRARY_ID.in(it2));
            }
            List list = $this$findSiblingReadList_u24lambda_u24132.orderBy((OrderField)this.d.RELEASE_DATE).fetch((Field)this.b.ID);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
            List $this$indexOfFirst$iv = bookIds = list;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                it = (String)item$iv;
                boolean bl8 = false;
                if (Intrinsics.areEqual((Object)it, (Object)bookId)) {
                    n = index$iv;
                    break block12;
                }
                ++index$iv;
            }
            n = bookIndex = -1;
        }
        if (bookIndex == -1) {
            return null;
        }
        String string = (String)CollectionsKt.getOrNull((List)bookIds, (int)(bookIndex + (next ? 1 : -1)));
        if (string == null) {
            return null;
        }
        String siblingId = string;
        SelectConditionStep selectConditionStep = BookDtoDao.selectBase$default((BookDtoDao)this, (String)userId, (boolean)false, (int)2, null).where(this.b.ID.eq((Object)siblingId));
        it2 = selectConditionStep;
        BookDtoDao bookDtoDao = this;
        boolean bl = false;
        Collection<String> collection = filterOnLibraryIds;
        if (collection != null) {
            void $this$findSiblingReadList_u24lambda_u2424;
            it = collection;
            boolean bl9 = false;
            $this$findSiblingReadList_u24lambda_u2424.and(this.b.LIBRARY_ID.in((Collection)it));
        }
        SelectLimitPercentStep selectLimitPercentStep = selectConditionStep.limit((Number)1);
        Intrinsics.checkNotNullExpressionValue((Object)selectLimitPercentStep, (String)"limit(...)");
        return (BookDto)CollectionsKt.firstOrNull((List)bookDtoDao.fetchAndMap((ResultQuery)selectLimitPercentStep));
    }

    private SelectOnConditionStep<Record> selectBase(String userId, boolean selectReadListNumber) {
        SpreadBuilder spreadBuilder = new SpreadBuilder(5);
        spreadBuilder.addSpread((Object)this.b.fields());
        spreadBuilder.addSpread((Object)this.m.fields());
        spreadBuilder.addSpread((Object)this.d.fields());
        spreadBuilder.addSpread((Object)this.r.fields());
        spreadBuilder.add((Object)this.sd.TITLE);
        SpreadBuilder $this$selectBase_u24lambda_u2425 = spreadBuilder = this.dsl.select((SelectFieldOrAsterisk[])spreadBuilder.toArray((Object[])new SelectFieldOrAsterisk[spreadBuilder.size()]));
        boolean bl = false;
        if (selectReadListNumber) {
            SelectFieldOrAsterisk[] selectFieldOrAsteriskArray = new SelectFieldOrAsterisk[]{this.rlb.NUMBER};
            $this$selectBase_u24lambda_u2425.select(selectFieldOrAsteriskArray);
        }
        SpreadBuilder $this$selectBase_u24lambda_u2426 = spreadBuilder = spreadBuilder.from((TableLike)this.b).leftJoin((TableLike)this.m).on(this.b.ID.eq((Field)this.m.BOOK_ID)).leftJoin((TableLike)this.d).on(this.b.ID.eq((Field)this.d.BOOK_ID)).leftJoin((TableLike)this.r).on(this.b.ID.eq((Field)this.r.BOOK_ID)).and(this.readProgressCondition(userId)).leftJoin((TableLike)this.sd).on(this.b.SERIES_ID.eq((Field)this.sd.SERIES_ID));
        boolean bl2 = false;
        if (selectReadListNumber) {
            $this$selectBase_u24lambda_u2426.leftJoin((TableLike)this.rlb).on(this.b.ID.eq((Field)this.rlb.BOOK_ID));
        }
        SpreadBuilder spreadBuilder2 = spreadBuilder;
        Intrinsics.checkNotNullExpressionValue((Object)spreadBuilder2, (String)"apply(...)");
        return spreadBuilder2;
    }

    static /* synthetic */ SelectOnConditionStep selectBase$default(BookDtoDao bookDtoDao, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: selectBase");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return bookDtoDao.selectBase(string, bl);
    }

    private List<BookDto> fetchAndMap(ResultQuery<Record> $this$fetchAndMap) {
        Result result2 = $this$fetchAndMap.fetch();
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"fetch(...)");
        Result records = result2;
        List list = records.getValues((Field)this.b.ID);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValues(...)");
        List bookIds = list;
        Ref.ObjectRef authors = new Ref.ObjectRef();
        Ref.ObjectRef tags = new Ref.ObjectRef();
        Ref.ObjectRef links2 = new Ref.ObjectRef();
        this.transactionTemplate.executeWithoutResult(arg_0 -> BookDtoDao.fetchAndMap$lambda$34(this, bookIds, authors, tags, links2, arg_0));
        List list2 = records.map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"map(...)");
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private Condition toCondition(BookSearchWithReadProgress $this$toCondition) {
        Collection cr;
        Iterable destination$iv$iv;
        Object object;
        Collection collection;
        Condition condition = DSL.noCondition();
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"noCondition(...)");
        Condition c = condition;
        if ($this$toCondition.getLibraryIds() != null) {
            Condition condition2 = c.and(this.b.LIBRARY_ID.in($this$toCondition.getLibraryIds()));
            Intrinsics.checkNotNullExpressionValue((Object)condition2, (String)"and(...)");
            c = condition2;
        }
        if (!((collection = $this$toCondition.getSeriesIds()) == null || collection.isEmpty())) {
            Condition condition3 = c.and(this.b.SERIES_ID.in($this$toCondition.getSeriesIds()));
            Intrinsics.checkNotNullExpressionValue((Object)condition3, (String)"and(...)");
            c = condition3;
        }
        if (!((collection = $this$toCondition.getMediaStatus()) == null || collection.isEmpty())) {
            Condition condition4 = c.and(this.m.STATUS.in($this$toCondition.getMediaStatus()));
            Intrinsics.checkNotNullExpressionValue((Object)condition4, (String)"and(...)");
            c = condition4;
        }
        if (!((collection = $this$toCondition.getMediaProfile()) == null || collection.isEmpty())) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Iterable iterable = $this$toCondition.getMediaProfile();
            TableField tableField = this.m.MEDIA_TYPE;
            object = c;
            boolean $i$f$flatMap = false;
            Iterator iterator = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                MediaProfile profile2 = (MediaProfile)element$iv$iv;
                boolean bl = false;
                Iterable $this$map$iv = MediaType.Companion.matchingMediaProfile(profile2);
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    MediaType mediaType2 = (MediaType)item$iv$iv;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    collection2.add(it.getType());
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List list = (List)destination$iv$iv;
            Condition condition5 = object.and(tableField.in((Collection)CollectionsKt.toSet((Iterable)list)));
            Intrinsics.checkNotNullExpressionValue((Object)condition5, (String)"and(...)");
            c = condition5;
        }
        if (Intrinsics.areEqual((Object)$this$toCondition.getDeleted(), (Object)true)) {
            Condition condition6 = c.and(this.b.DELETED_DATE.isNotNull());
            Intrinsics.checkNotNullExpressionValue((Object)condition6, (String)"and(...)");
            c = condition6;
        }
        if (Intrinsics.areEqual((Object)$this$toCondition.getDeleted(), (Object)false)) {
            Condition condition7 = c.and(this.b.DELETED_DATE.isNull());
            Intrinsics.checkNotNullExpressionValue((Object)condition7, (String)"and(...)");
            c = condition7;
        }
        if ($this$toCondition.getReleasedAfter() != null) {
            Condition condition8 = c.and(this.d.RELEASE_DATE.gt((Object)$this$toCondition.getReleasedAfter()));
            Intrinsics.checkNotNullExpressionValue((Object)condition8, (String)"and(...)");
            c = condition8;
        }
        if (!((collection = $this$toCondition.getTags()) == null || collection.isEmpty())) {
            Condition condition9 = c.and(this.b.ID.in((Select)this.dsl.select((SelectField)this.bt.BOOK_ID).from((TableLike)this.bt).where(this.bt.TAG.collate("COLLATION_UNICODE_3").in($this$toCondition.getTags()))));
            Intrinsics.checkNotNullExpressionValue((Object)condition9, (String)"and(...)");
            c = condition9;
        }
        if ($this$toCondition.getReadStatus() != null) {
            void $this$reduce$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this$toCondition.getReadStatus();
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ReadStatus bl = (ReadStatus)item$iv$iv;
                object = destination$iv$iv3;
                boolean bl3 = false;
                object.add(switch (WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
                    case 1 -> this.r.COMPLETED.isNull();
                    case 2 -> this.r.COMPLETED.isTrue();
                    case 3 -> this.r.COMPLETED.isFalse();
                    default -> throw new NoWhenBranchMatchedException();
                });
            }
            $this$map$iv = (List)destination$iv$iv3;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void condition10;
                Condition $i$f$mapTo2 = (Condition)iterator$iv.next();
                Condition acc = (Condition)accumulator$iv;
                boolean bl = false;
                accumulator$iv = acc.or((Condition)condition10);
            }
            Object t = accumulator$iv;
            Intrinsics.checkNotNullExpressionValue(t, (String)"reduce(...)");
            cr = (Condition)t;
            Condition condition11 = c.and((Condition)cr);
            Intrinsics.checkNotNullExpressionValue((Object)condition11, (String)"and(...)");
            c = condition11;
        }
        if (!((cr = $this$toCondition.getAuthors()) == null || cr.isEmpty())) {
            Condition ca = null;
            Condition condition12 = DSL.noCondition();
            Intrinsics.checkNotNullExpressionValue((Object)condition12, (String)"noCondition(...)");
            ca = condition12;
            Iterable $this$forEach$iv = $this$toCondition.getAuthors();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Author it = (Author)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)ca.or(this.b.ID.in((Select)this.dsl.select((SelectField)this.a.BOOK_ID).from((TableLike)this.a).where(this.a.NAME.equalIgnoreCase(it.getName()).and(this.a.ROLE.equalIgnoreCase(it.getRole()))))), (String)"or(...)");
            }
            Condition condition13 = c.and(ca);
            Intrinsics.checkNotNullExpressionValue((Object)condition13, (String)"and(...)");
            c = condition13;
        }
        return c;
    }

    private BookDto toDto(BookRecord $this$toDto, MediaDto media, BookMetadataDto metadata, ReadProgressDto readProgress, String seriesTitle) {
        String string = $this$toDto.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        String string2 = $this$toDto.getSeriesId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSeriesId(...)");
        String string3 = $this$toDto.getLibraryId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getLibraryId(...)");
        String string4 = $this$toDto.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
        String string5 = org.gotson.komga.infrastructure.web.UtilsKt.toFilePath((URL)new URL($this$toDto.getUrl()));
        Integer n = $this$toDto.getNumber();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getNumber(...)");
        int n2 = ((Number)n).intValue();
        LocalDateTime localDateTime = $this$toDto.getCreatedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"getCreatedDate(...)");
        LocalDateTime localDateTime2 = $this$toDto.getLastModifiedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"getLastModifiedDate(...)");
        LocalDateTime localDateTime3 = $this$toDto.getFileLastModified();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime3, (String)"getFileLastModified(...)");
        LocalDateTime localDateTime4 = LanguageUtilsKt.toUTC((LocalDateTime)localDateTime3);
        Long l = $this$toDto.getFileSize();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getFileSize(...)");
        long l2 = ((Number)l).longValue();
        boolean bl = $this$toDto.getDeletedDate() != null;
        String string6 = $this$toDto.getFileHash();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getFileHash(...)");
        Boolean bl2 = $this$toDto.getOneshot();
        Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"getOneshot(...)");
        return new BookDto(string, string2, seriesTitle, string3, string4, string5, n2, localDateTime, localDateTime2, localDateTime4, l2, null, media, metadata, readProgress, bl, string6, bl2.booleanValue(), 2048, null);
    }

    private MediaDto toDto(MediaRecord $this$toDto) {
        String string = $this$toDto.getStatus();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatus(...)");
        String string2 = $this$toDto.getMediaType();
        if (string2 == null) {
            string2 = "";
        }
        int n = $this$toDto.getPageCount();
        String string3 = $this$toDto.getComment();
        if (string3 == null) {
            string3 = "";
        }
        Boolean bl = $this$toDto.getEpubDivinaCompatible();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getEpubDivinaCompatible(...)");
        boolean bl2 = bl;
        Boolean bl3 = $this$toDto.getEpubIsKepub();
        Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"getEpubIsKepub(...)");
        return new MediaDto(string, string2, n, string3, bl2, bl3.booleanValue());
    }

    private BookMetadataDto toDto(BookMetadataRecord $this$toDto, List<AuthorDto> authors, Set<String> tags, List<WebLinkDto> links2) {
        String string = $this$toDto.getTitle();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTitle(...)");
        Boolean bl = $this$toDto.getTitleLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getTitleLock(...)");
        boolean bl2 = bl;
        String string2 = $this$toDto.getSummary();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSummary(...)");
        Boolean bl3 = $this$toDto.getSummaryLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"getSummaryLock(...)");
        boolean bl4 = bl3;
        String string3 = $this$toDto.getNumber();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getNumber(...)");
        Boolean bl5 = $this$toDto.getNumberLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl5, (String)"getNumberLock(...)");
        boolean bl6 = bl5;
        Float f = $this$toDto.getNumberSort();
        Intrinsics.checkNotNullExpressionValue((Object)f, (String)"getNumberSort(...)");
        float f2 = ((Number)f).floatValue();
        Boolean bl7 = $this$toDto.getNumberSortLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl7, (String)"getNumberSortLock(...)");
        boolean bl8 = bl7;
        LocalDate localDate = $this$toDto.getReleaseDate();
        Boolean bl9 = $this$toDto.getReleaseDateLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl9, (String)"getReleaseDateLock(...)");
        boolean bl10 = bl9;
        Boolean bl11 = $this$toDto.getAuthorsLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl11, (String)"getAuthorsLock(...)");
        boolean bl12 = bl11;
        Boolean bl13 = $this$toDto.getTagsLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl13, (String)"getTagsLock(...)");
        boolean bl14 = bl13;
        String string4 = $this$toDto.getIsbn();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getIsbn(...)");
        Boolean bl15 = $this$toDto.getIsbnLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl15, (String)"getIsbnLock(...)");
        boolean bl16 = bl15;
        Boolean bl17 = $this$toDto.getLinksLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl17, (String)"getLinksLock(...)");
        boolean bl18 = bl17;
        LocalDateTime localDateTime = $this$toDto.getCreatedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"getCreatedDate(...)");
        LocalDateTime localDateTime2 = $this$toDto.getLastModifiedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"getLastModifiedDate(...)");
        return new BookMetadataDto(string, bl2, string2, bl4, string3, bl6, f2, bl8, localDate, bl10, authors, bl12, tags, bl14, string4, bl16, links2, bl18, localDateTime, localDateTime2);
    }

    private ReadProgressDto toDto(ReadProgressRecord $this$toDto) {
        Integer n = $this$toDto.getPage();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getPage(...)");
        int n2 = ((Number)n).intValue();
        Boolean bl = $this$toDto.getCompleted();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getCompleted(...)");
        boolean bl2 = bl;
        LocalDateTime localDateTime = $this$toDto.getReadDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"getReadDate(...)");
        LocalDateTime localDateTime2 = $this$toDto.getCreatedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"getCreatedDate(...)");
        LocalDateTime localDateTime3 = $this$toDto.getLastModifiedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime3, (String)"getLastModifiedDate(...)");
        String string = $this$toDto.getDeviceId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDeviceId(...)");
        String string2 = $this$toDto.getDeviceName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDeviceName(...)");
        return new ReadProgressDto(n2, bl2, localDateTime, localDateTime2, localDateTime3, string, string2);
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair findAll$lambda$7(List $bookIds, BookDtoDao this$0, String $userId, Condition $conditions, Condition $searchCondition, boolean $selectReadListNumber, List $orderBy, Collection $filterOnLibraryIds, Pageable $pageable, TransactionStatus it) {
        SelectConditionStep $this$findAll_u24lambda_u247_u24lambda_u245;
        GroupField[] $this$findAll_u24lambda_u247_u24lambda_u242;
        Collection it2;
        GroupField[] groupFieldArray;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$userId, (String)"$userId");
        Intrinsics.checkNotNullParameter((Object)$conditions, (String)"$conditions");
        Intrinsics.checkNotNullParameter((Object)$searchCondition, (String)"$searchCondition");
        Intrinsics.checkNotNullParameter((Object)$orderBy, (String)"$orderBy");
        Intrinsics.checkNotNullParameter((Object)$pageable, (String)"$pageable");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Collection collection = $bookIds;
        if (!(collection == null || collection.isEmpty())) {
            UtilsKt.insertTempStrings((DSLContext)this$0.dsl, (int)this$0.batchSize, (Collection)$bookIds);
        }
        GroupField[] groupFieldArray2 = groupFieldArray = this$0.dsl.select((SelectField)this$0.b.ID).from((TableLike)this$0.b).leftJoin((TableLike)this$0.m).on(this$0.b.ID.eq((Field)this$0.m.BOOK_ID)).leftJoin((TableLike)this$0.d).on(this$0.b.ID.eq((Field)this$0.d.BOOK_ID)).leftJoin((TableLike)this$0.r).on(this$0.b.ID.eq((Field)this$0.r.BOOK_ID)).and(this$0.readProgressCondition($userId)).leftJoin((TableLike)this$0.sd).on(this$0.b.SERIES_ID.eq((Field)this$0.sd.SERIES_ID));
        DSLContext dSLContext = this$0.dsl;
        boolean bl = false;
        Collection collection2 = $filterOnLibraryIds;
        if (collection2 != null) {
            it2 = collection2;
            boolean bl2 = false;
            $this$findAll_u24lambda_u247_u24lambda_u242.and(this$0.b.LIBRARY_ID.in(it2));
        }
        $this$findAll_u24lambda_u247_u24lambda_u242 = groupFieldArray;
        boolean bl3 = false;
        if ($selectReadListNumber) {
            void $this$findAll_u24lambda_u247_u24lambda_u243;
            $this$findAll_u24lambda_u247_u24lambda_u243.leftJoin((TableLike)this$0.rlb).on(this$0.b.ID.eq((Field)this$0.rlb.BOOK_ID));
        }
        SelectConditionStep selectConditionStep = groupFieldArray.where($conditions).and($searchCondition);
        groupFieldArray = new GroupField[]{this$0.b.ID};
        int count = dSLContext.fetchCount((Select)selectConditionStep.groupBy(groupFieldArray));
        SelectConditionStep selectConditionStep2 = this$0.selectBase($userId, $selectReadListNumber).where($conditions).and($searchCondition);
        it2 = selectConditionStep2;
        dSLContext = this$0;
        boolean bl4 = false;
        Collection collection3 = $filterOnLibraryIds;
        if (collection3 != null) {
            Collection it3 = collection3;
            boolean bl5 = false;
            $this$findAll_u24lambda_u247_u24lambda_u245.and(this$0.b.LIBRARY_ID.in(it3));
        }
        $this$findAll_u24lambda_u247_u24lambda_u245 = selectConditionStep2 = selectConditionStep2.orderBy((Collection)$orderBy);
        boolean bl6 = false;
        if ($pageable.isPaged()) {
            void $this$findAll_u24lambda_u247_u24lambda_u246;
            $this$findAll_u24lambda_u247_u24lambda_u246.limit((Number)$pageable.getPageSize()).offset((Number)$pageable.getOffset());
        }
        SelectConditionStep selectConditionStep3 = selectConditionStep2;
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep3, (String)"apply(...)");
        List dtos = super.fetchAndMap((ResultQuery)selectConditionStep3);
        return TuplesKt.to((Object)count, (Object)dtos);
    }

    /*
     * WARNING - void declaration
     */
    private static final void fetchAndMap$lambda$34(BookDtoDao this$0, List $bookIds, Ref.ObjectRef $authors, Ref.ObjectRef $tags, Ref.ObjectRef $links, TransactionStatus it) {
        List list;
        List list$iv$iv;
        List answer$iv$iv$iv;
        Object value$iv$iv$iv;
        String key$iv$iv;
        boolean $i$f$getOrPut;
        Object $this$getOrPut$iv$iv$iv;
        Iterable $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv;
        BookMetadataAuthorRecord it2;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$bookIds, (String)"$bookIds");
        Intrinsics.checkNotNullParameter((Object)$authors, (String)"$authors");
        Intrinsics.checkNotNullParameter((Object)$tags, (String)"$tags");
        Intrinsics.checkNotNullParameter((Object)$links, (String)"$links");
        UtilsKt.insertTempStrings((DSLContext)this$0.dsl, (int)this$0.batchSize, (Collection)$bookIds);
        SelectConditionStep selectConditionStep = this$0.dsl.selectFrom((TableLike)this$0.a).where(this$0.a.BOOK_ID.in((Select)UtilsKt.selectTempStrings((DSLContext)this$0.dsl)));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"where(...)");
        Iterable iterable = (Iterable)selectConditionStep;
        Ref.ObjectRef objectRef = $authors;
        boolean $i$f$filter = false;
        void var8_9 = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it2 = (BookMetadataAuthorRecord)element$iv$iv;
            boolean bl = false;
            if (!(it2.getName() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it3;
            Object object;
            it2 = (BookMetadataAuthorRecord)element$iv$iv;
            boolean $i$a$-groupBy-BookDtoDao$fetchAndMap$1$82 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it2.getBookId(), (String)"getBookId(...)");
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            BookMetadataAuthorRecord $i$a$-groupBy-BookDtoDao$fetchAndMap$1$82 = (BookMetadataAuthorRecord)element$iv$iv;
            list = list$iv$iv;
            boolean bl = false;
            String string = it3.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string2 = it3.getRole();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRole(...)");
            list.add(new AuthorDto(string, string2));
        }
        objectRef.element = destination$iv$iv;
        SelectConditionStep selectConditionStep2 = this$0.dsl.selectFrom((TableLike)this$0.bt).where(this$0.bt.BOOK_ID.in((Select)UtilsKt.selectTempStrings((DSLContext)this$0.dsl)));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep2, (String)"where(...)");
        $this$groupBy$iv = (Iterable)selectConditionStep2;
        objectRef = $tags;
        $i$f$groupBy = false;
        $this$groupByTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it4;
            Object object;
            it2 = (BookMetadataTagRecord)element$iv$iv;
            boolean $i$a$-groupBy-BookDtoDao$fetchAndMap$1$92 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it2.getBookId(), (String)"getBookId(...)");
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            BookMetadataTagRecord $i$a$-groupBy-BookDtoDao$fetchAndMap$1$92 = (BookMetadataTagRecord)element$iv$iv;
            list = list$iv$iv;
            boolean bl = false;
            list.add(it4.getTag());
        }
        objectRef.element = destination$iv$iv;
        SelectConditionStep selectConditionStep3 = this$0.dsl.selectFrom((TableLike)this$0.bl).where(this$0.bl.BOOK_ID.in((Select)UtilsKt.selectTempStrings((DSLContext)this$0.dsl)));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep3, (String)"where(...)");
        $this$groupBy$iv = (Iterable)selectConditionStep3;
        objectRef = $links;
        $i$f$groupBy = false;
        $this$groupByTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it5;
            Object object;
            it2 = (BookMetadataLinkRecord)element$iv$iv;
            boolean $i$a$-groupBy-BookDtoDao$fetchAndMap$1$102 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it2.getBookId(), (String)"getBookId(...)");
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            BookMetadataLinkRecord $i$a$-groupBy-BookDtoDao$fetchAndMap$1$102 = (BookMetadataLinkRecord)element$iv$iv;
            list = list$iv$iv;
            boolean bl = false;
            String string = it5.getLabel();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLabel(...)");
            String string3 = it5.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getUrl(...)");
            list.add(new WebLinkDto(string, string3));
        }
        objectRef.element = destination$iv$iv;
    }

    public static final /* synthetic */ Book access$getB$p(BookDtoDao $this) {
        return $this.b;
    }

    public static final /* synthetic */ Media access$getM$p(BookDtoDao $this) {
        return $this.m;
    }

    public static final /* synthetic */ BookMetadata access$getD$p(BookDtoDao $this) {
        return $this.d;
    }

    public static final /* synthetic */ ReadProgress access$getR$p(BookDtoDao $this) {
        return $this.r;
    }

    public static final /* synthetic */ SeriesMetadata access$getSd$p(BookDtoDao $this) {
        return $this.sd;
    }

    public static final /* synthetic */ BookDto access$toDto(BookDtoDao $this, BookRecord $receiver, MediaDto media, BookMetadataDto metadata, ReadProgressDto readProgress, String seriesTitle) {
        return $this.toDto($receiver, media, metadata, readProgress, seriesTitle);
    }

    public static final /* synthetic */ MediaDto access$toDto(BookDtoDao $this, MediaRecord $receiver) {
        return $this.toDto($receiver);
    }

    public static final /* synthetic */ BookMetadataDto access$toDto(BookDtoDao $this, BookMetadataRecord $receiver, List authors, Set tags, List links2) {
        return $this.toDto($receiver, authors, tags, links2);
    }

    public static final /* synthetic */ ReadProgressDto access$toDto(BookDtoDao $this, ReadProgressRecord $receiver) {
        return $this.toDto($receiver);
    }
}

