/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.jooq.main;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.model.AgeRestriction;
import org.gotson.komga.domain.model.AllowExclude;
import org.gotson.komga.domain.model.ApiKey;
import org.gotson.komga.domain.model.ContentRestrictions;
import org.gotson.komga.domain.model.KomgaUser;
import org.gotson.komga.domain.persistence.KomgaUserRepository;
import org.gotson.komga.infrastructure.jooq.main.KomgaUserDao;
import org.gotson.komga.jooq.main.Tables;
import org.gotson.komga.jooq.main.tables.AnnouncementsRead;
import org.gotson.komga.jooq.main.tables.User;
import org.gotson.komga.jooq.main.tables.UserApiKey;
import org.gotson.komga.jooq.main.tables.UserLibrarySharing;
import org.gotson.komga.jooq.main.tables.UserSharing;
import org.gotson.komga.jooq.main.tables.records.AnnouncementsReadRecord;
import org.gotson.komga.jooq.main.tables.records.UserApiKeyRecord;
import org.gotson.komga.jooq.main.tables.records.UserLibrarySharingRecord;
import org.gotson.komga.jooq.main.tables.records.UserRecord;
import org.gotson.komga.jooq.main.tables.records.UserSharingRecord;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.InsertSetMoreStep;
import org.jooq.Record;
import org.jooq.RecordMapper;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectOnConditionStep;
import org.jooq.SelectSelectStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.UpdateSetMoreStep;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J\b\u0010\u0016\u001a\u00020\u0013H\u0017J\u0018\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0015H\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00150$2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020&0!2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001e\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020&\u0018\u00010(2\u0006\u0010)\u001a\u00020\u0015H\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001f\u001a\u00020\u0015H\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010\"2\u0006\u0010,\u001a\u00020\u0015H\u0016J\u0010\u0010-\u001a\u00020\u00132\u0006\u0010)\u001a\u00020&H\u0016J\u0010\u0010-\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\"H\u0017J\u0010\u0010/\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\"H\u0012J\u0010\u00100\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\"H\u0012J\u001e\u00101\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\"2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00150$H\u0016J\u001b\u00103\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u0001050504\u00a2\u0006\u0002\b6H\u0012J\u0010\u00107\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\"H\u0017J\u0018\u00108\u001a\b\u0012\u0004\u0012\u00020\"09*\b\u0012\u0004\u0012\u0002050:H\u0012J\f\u0010;\u001a\u00020&*\u00020<H\u0012R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\t0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0007*\u0004\u0018\u00010\u000b0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u0007*\u0004\u0018\u00010\r0\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0007*\u0004\u0018\u00010\u000f0\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/gotson/komga/infrastructure/jooq/main/KomgaUserDao;", "Lorg/gotson/komga/domain/persistence/KomgaUserRepository;", "dsl", "Lorg/jooq/DSLContext;", "(Lorg/jooq/DSLContext;)V", "ar", "Lorg/gotson/komga/jooq/main/tables/AnnouncementsRead;", "kotlin.jvm.PlatformType", "u", "Lorg/gotson/komga/jooq/main/tables/User;", "uak", "Lorg/gotson/komga/jooq/main/tables/UserApiKey;", "ul", "Lorg/gotson/komga/jooq/main/tables/UserLibrarySharing;", "us", "Lorg/gotson/komga/jooq/main/tables/UserSharing;", "count", "", "delete", "", "userId", "", "deleteAll", "deleteApiKeyByIdAndUserId", "apiKeyId", "deleteApiKeyByUserId", "existsApiKeyByCommentAndUserId", "", "comment", "existsApiKeyByIdAndUserId", "existsByEmailIgnoreCase", "email", "findAll", "", "Lorg/gotson/komga/domain/model/KomgaUser;", "findAnnouncementIdsReadByUserId", "", "findApiKeyByUserId", "Lorg/gotson/komga/domain/model/ApiKey;", "findByApiKeyOrNull", "Lkotlin/Pair;", "apiKey", "findByEmailIgnoreCaseOrNull", "findByIdOrNull", "id", "insert", "user", "insertSharedLibraries", "insertSharingRestrictions", "saveAnnouncementIdsRead", "announcementIds", "selectBase", "Lorg/jooq/SelectOnConditionStep;", "Lorg/jooq/Record;", "Lorg/jetbrains/annotations/NotNull;", "update", "fetchAndMap", "", "Lorg/jooq/ResultQuery;", "toDomain", "Lorg/gotson/komga/jooq/main/tables/records/UserApiKeyRecord;", "komga"})
@SourceDebugExtension(value={"SMAP\nKomgaUserDao.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KomgaUserDao.kt\norg/gotson/komga/infrastructure/jooq/main/KomgaUserDao\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,282:1\n125#2:283\n152#2,2:284\n154#2:313\n1603#3,9:286\n1855#3:295\n1856#3:297\n1612#3:298\n766#3:299\n857#3,2:300\n1549#3:302\n1620#3,3:303\n819#3:306\n847#3,2:307\n1549#3:309\n1620#3,3:310\n1549#3:314\n1620#3,3:315\n1855#3,2:318\n1855#3,2:320\n1855#3,2:322\n1#4:296\n*S KotlinDebug\n*F\n+ 1 KomgaUserDao.kt\norg/gotson/komga/infrastructure/jooq/main/KomgaUserDao\n*L\n60#1:283\n60#1:284,2\n60#1:313\n72#1:286,9\n72#1:295\n72#1:297\n72#1:298\n81#1:299\n81#1:300,2\n81#1:302\n81#1:303,3\n82#1:306\n82#1:307,2\n82#1:309\n82#1:310,3\n164#1:314\n164#1:315,3\n168#1:318,2\n177#1:320,2\n184#1:322,2\n72#1:296\n*E\n"})
public class KomgaUserDao
implements KomgaUserRepository {
    @NotNull
    private final DSLContext dsl;
    private final User u;
    private final UserLibrarySharing ul;
    private final UserSharing us;
    private final AnnouncementsRead ar;
    private final UserApiKey uak;

    public KomgaUserDao(@NotNull DSLContext dsl) {
        Intrinsics.checkNotNullParameter((Object)dsl, (String)"dsl");
        this.dsl = dsl;
        this.u = Tables.USER;
        this.ul = Tables.USER_LIBRARY_SHARING;
        this.us = Tables.USER_SHARING;
        this.ar = Tables.ANNOUNCEMENTS_READ;
        this.uak = Tables.USER_API_KEY;
    }

    public long count() {
        return this.dsl.fetchCount((Table)this.u);
    }

    @NotNull
    public Collection<KomgaUser> findAll() {
        return this.fetchAndMap((ResultQuery)this.selectBase());
    }

    @NotNull
    public Collection<ApiKey> findApiKeyByUserId(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        List list = this.dsl.selectFrom((TableLike)this.uak).where(this.uak.USER_ID.eq((Object)userId)).fetchInto((Table)this.uak).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    @Nullable
    public KomgaUser findByIdOrNull(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        SelectConditionStep selectConditionStep = this.selectBase().where(this.u.ID.equal((Object)id));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"where(...)");
        return (KomgaUser)CollectionsKt.firstOrNull((List)this.fetchAndMap((ResultQuery)selectConditionStep));
    }

    private SelectOnConditionStep<Record> selectBase() {
        Field[] fieldArray = this.u.fields();
        SelectSelectStep selectSelectStep = this.dsl.select((SelectFieldOrAsterisk[])Arrays.copyOf(fieldArray, fieldArray.length));
        fieldArray = new SelectFieldOrAsterisk[]{this.ul.LIBRARY_ID};
        SelectOnConditionStep selectOnConditionStep = selectSelectStep.select((SelectFieldOrAsterisk[])fieldArray).from((TableLike)this.u).leftJoin((TableLike)this.ul).onKey();
        Intrinsics.checkNotNullExpressionValue((Object)selectOnConditionStep, (String)"onKey(...)");
        return selectOnConditionStep;
    }

    /*
     * WARNING - void declaration
     */
    private List<KomgaUser> fetchAndMap(ResultQuery<Record> $this$fetchAndMap) {
        void $this$mapTo$iv$iv;
        Map map = $this$fetchAndMap.fetchGroups((RecordMapper)new /* Unavailable Anonymous Inner Class!! */, (RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"fetchGroups(...)");
        Map $this$map$iv = map;
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            String string;
            Iterable $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2;
            UserSharingRecord it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            AgeRestriction ageRestriction;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            UserRecord ur = (UserRecord)entry.getKey();
            List ulr = (List)entry.getValue();
            SelectConditionStep selectConditionStep = this.dsl.selectFrom((TableLike)this.us).where(this.us.USER_ID.eq((Object)ur.getId()));
            Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"where(...)");
            List usr = CollectionsKt.toList((Iterable)((Iterable)selectConditionStep));
            String string2 = ur.getEmail();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getEmail(...)");
            String string3 = ur.getPassword();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPassword(...)");
            Boolean bl2 = ur.getRoleAdmin();
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"getRoleAdmin(...)");
            boolean bl3 = bl2;
            Boolean bl4 = ur.getRoleFileDownload();
            Intrinsics.checkNotNullExpressionValue((Object)bl4, (String)"getRoleFileDownload(...)");
            boolean bl5 = bl4;
            Boolean bl6 = ur.getRolePageStreaming();
            Intrinsics.checkNotNullExpressionValue((Object)bl6, (String)"getRolePageStreaming(...)");
            boolean bl7 = bl6;
            Boolean bl8 = ur.getRoleKoboSync();
            Intrinsics.checkNotNullExpressionValue((Object)bl8, (String)"getRoleKoboSync(...)");
            boolean bl9 = bl8;
            Intrinsics.checkNotNull((Object)ulr);
            Iterable iterable = ulr;
            boolean bl10 = bl9;
            boolean bl11 = bl7;
            boolean bl12 = bl5;
            boolean bl13 = bl3;
            String string4 = string3;
            String string5 = string2;
            boolean $i$f$mapNotNull = false;
            void var22_22 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl14 = false;
                UserLibrarySharingRecord it2 = (UserLibrarySharingRecord)element$iv$iv;
                boolean bl15 = false;
                if (it2.getLibraryId() == null) continue;
                boolean bl16 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Collection collection2 = (List)destination$iv$iv2;
            Set set = CollectionsKt.toSet((Iterable)collection2);
            Boolean bl17 = ur.getSharedAllLibraries();
            Intrinsics.checkNotNullExpressionValue((Object)bl17, (String)"getSharedAllLibraries(...)");
            boolean bl18 = bl17;
            if (ur.getAgeRestriction() != null && ur.getAgeRestrictionAllowOnly() != null) {
                Integer n = ur.getAgeRestriction();
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getAgeRestriction(...)");
                int n2 = ((Number)n).intValue();
                Boolean bl19 = ur.getAgeRestrictionAllowOnly();
                Intrinsics.checkNotNullExpressionValue((Object)bl19, (String)"getAgeRestrictionAllowOnly(...)");
                ageRestriction = new AgeRestriction(n2, bl19 != false ? AllowExclude.ALLOW_ONLY : AllowExclude.EXCLUDE);
            } else {
                ageRestriction = null;
            }
            $this$mapNotNull$iv = usr;
            AgeRestriction ageRestriction2 = ageRestriction;
            boolean bl20 = bl18;
            collection2 = set;
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (UserSharingRecord)element$iv$iv;
                boolean bl21 = false;
                Boolean bl22 = it.getAllow();
                Intrinsics.checkNotNullExpressionValue((Object)bl22, (String)"getAllow(...)");
                if (!bl22.booleanValue()) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Collection<String> collection3 = (List)destination$iv$iv2;
            $this$filter$iv = collection3;
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                it = (UserSharingRecord)item$iv$iv2;
                collection3 = destination$iv$iv2;
                boolean bl23 = false;
                collection3.add(it.getLabel());
            }
            collection3 = (List)destination$iv$iv2;
            $this$map$iv2 = usr;
            collection3 = CollectionsKt.toSet((Iterable)collection3);
            boolean $i$f$filterNot = false;
            $this$mapTo$iv$iv2 = $this$filterNot$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                it = (UserSharingRecord)element$iv$iv;
                boolean bl24 = false;
                Boolean bl25 = it.getAllow();
                Intrinsics.checkNotNullExpressionValue((Object)bl25, (String)"getAllow(...)");
                if (bl25.booleanValue()) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Collection<String> collection4 = (List)destination$iv$iv2;
            $this$filterNot$iv = collection4;
            $i$f$map2 = false;
            $this$filterNotTo$iv$iv = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            $i$f$mapTo2 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
                it = (UserSharingRecord)item$iv$iv3;
                collection4 = destination$iv$iv2;
                boolean bl26 = false;
                collection4.add(it.getLabel());
            }
            collection4 = (List)destination$iv$iv2;
            Set set2 = CollectionsKt.toSet((Iterable)collection4);
            Collection<String> collection5 = collection3;
            AgeRestriction ageRestriction3 = ageRestriction2;
            ContentRestrictions contentRestrictions = new ContentRestrictions(ageRestriction3, collection5, set2);
            Intrinsics.checkNotNullExpressionValue((Object)ur.getId(), (String)"getId(...)");
            LocalDateTime localDateTime = ur.getCreatedDate();
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"getCreatedDate(...)");
            LocalDateTime localDateTime2 = LanguageUtilsKt.toCurrentTimeZone((LocalDateTime)localDateTime);
            LocalDateTime localDateTime3 = ur.getLastModifiedDate();
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime3, (String)"getLastModifiedDate(...)");
            LocalDateTime localDateTime4 = LanguageUtilsKt.toCurrentTimeZone((LocalDateTime)localDateTime3);
            LocalDateTime localDateTime5 = localDateTime2;
            ContentRestrictions contentRestrictions2 = contentRestrictions;
            boolean bl27 = bl20;
            Collection collection6 = collection2;
            boolean bl28 = bl10;
            boolean bl29 = bl11;
            boolean bl30 = bl12;
            boolean bl31 = bl13;
            String string6 = string4;
            String string7 = string5;
            collection.add(new KomgaUser(string7, string6, bl31, bl30, bl29, bl28, (Set)collection6, bl27, contentRestrictions2, string, localDateTime5, localDateTime4));
        }
        return (List)destination$iv$iv;
    }

    @Transactional
    public void insert(@NotNull KomgaUser user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        AgeRestriction ageRestriction = user.getRestrictions().getAgeRestriction();
        InsertSetMoreStep insertSetMoreStep = this.dsl.insertInto((Table)this.u).set((Field)this.u.ID, (Object)user.getId()).set((Field)this.u.EMAIL, (Object)user.getEmail()).set((Field)this.u.PASSWORD, (Object)user.getPassword()).set((Field)this.u.ROLE_ADMIN, (Object)user.getRoleAdmin()).set((Field)this.u.ROLE_FILE_DOWNLOAD, (Object)user.getRoleFileDownload()).set((Field)this.u.ROLE_PAGE_STREAMING, (Object)user.getRolePageStreaming()).set((Field)this.u.ROLE_KOBO_SYNC, (Object)user.getRoleKoboSync()).set((Field)this.u.SHARED_ALL_LIBRARIES, (Object)user.getSharedAllLibraries()).set((Field)this.u.AGE_RESTRICTION, (Object)(ageRestriction != null ? Integer.valueOf(ageRestriction.getAge()) : null));
        Field field = (Field)this.u.AGE_RESTRICTION_ALLOW_ONLY;
        AgeRestriction ageRestriction2 = user.getRestrictions().getAgeRestriction();
        Object object = ageRestriction2 != null ? ageRestriction2.getRestriction() : null;
        insertSetMoreStep.set(field, (Object)(switch (object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) {
            case 1 -> true;
            case 2 -> false;
            case -1 -> null;
            default -> throw new NoWhenBranchMatchedException();
        })).execute();
        this.insertSharedLibraries(user);
        this.insertSharingRestrictions(user);
    }

    public void insert(@NotNull ApiKey apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        this.dsl.insertInto((Table)this.uak).set((Field)this.uak.ID, (Object)apiKey.getId()).set((Field)this.uak.USER_ID, (Object)apiKey.getUserId()).set((Field)this.uak.API_KEY, (Object)apiKey.getKey()).set((Field)this.uak.COMMENT, (Object)apiKey.getComment()).execute();
    }

    @Transactional
    public void update(@NotNull KomgaUser user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        AgeRestriction ageRestriction = user.getRestrictions().getAgeRestriction();
        UpdateSetMoreStep updateSetMoreStep = this.dsl.update((Table)this.u).set((Field)this.u.EMAIL, (Object)user.getEmail()).set((Field)this.u.PASSWORD, (Object)user.getPassword()).set((Field)this.u.ROLE_ADMIN, (Object)user.getRoleAdmin()).set((Field)this.u.ROLE_FILE_DOWNLOAD, (Object)user.getRoleFileDownload()).set((Field)this.u.ROLE_PAGE_STREAMING, (Object)user.getRolePageStreaming()).set((Field)this.u.ROLE_KOBO_SYNC, (Object)user.getRoleKoboSync()).set((Field)this.u.SHARED_ALL_LIBRARIES, (Object)user.getSharedAllLibraries()).set((Field)this.u.AGE_RESTRICTION, (Object)(ageRestriction != null ? Integer.valueOf(ageRestriction.getAge()) : null));
        Field field = (Field)this.u.AGE_RESTRICTION_ALLOW_ONLY;
        AgeRestriction ageRestriction2 = user.getRestrictions().getAgeRestriction();
        Object object = ageRestriction2 != null ? ageRestriction2.getRestriction() : null;
        updateSetMoreStep.set(field, (Object)(switch (object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) {
            case 1 -> true;
            case 2 -> false;
            case -1 -> null;
            default -> throw new NoWhenBranchMatchedException();
        })).set((Field)this.u.LAST_MODIFIED_DATE, (Object)LocalDateTime.now(ZoneId.of("Z"))).where(this.u.ID.eq((Object)user.getId())).execute();
        this.dsl.deleteFrom((Table)this.ul).where(this.ul.USER_ID.eq((Object)user.getId())).execute();
        this.dsl.deleteFrom((Table)this.us).where(this.us.USER_ID.eq((Object)user.getId())).execute();
        this.insertSharedLibraries(user);
        this.insertSharingRestrictions(user);
    }

    /*
     * WARNING - void declaration
     */
    public void saveAnnouncementIdsRead(@NotNull KomgaUser user, @NotNull Set<String> announcementIds) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter(announcementIds, (String)"announcementIds");
        Iterable iterable = announcementIds;
        DSLContext dSLContext = this.dsl;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new AnnouncementsReadRecord(user.getId(), (String)it));
        }
        dSLContext.batchStore((Collection)((List)destination$iv$iv)).execute();
    }

    private void insertSharedLibraries(KomgaUser user) {
        Iterable $this$forEach$iv = user.getSharedLibrariesIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.dsl.insertInto((Table)this.ul).columns((Field)this.ul.USER_ID, (Field)this.ul.LIBRARY_ID).values((Object)user.getId(), (Object)it).execute();
        }
    }

    private void insertSharingRestrictions(KomgaUser user) {
        String label;
        Iterable $this$forEach$iv = user.getRestrictions().getLabelsAllow();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            label = (String)element$iv;
            boolean bl = false;
            this.dsl.insertInto((Table)this.us).columns((Field)this.us.USER_ID, (Field)this.us.ALLOW, (Field)this.us.LABEL).values((Object)user.getId(), (Object)true, (Object)label).execute();
        }
        $this$forEach$iv = user.getRestrictions().getLabelsExclude();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            label = (String)element$iv;
            boolean bl = false;
            this.dsl.insertInto((Table)this.us).columns((Field)this.us.USER_ID, (Field)this.us.ALLOW, (Field)this.us.LABEL).values((Object)user.getId(), (Object)false, (Object)label).execute();
        }
    }

    @Transactional
    public void delete(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        this.dsl.deleteFrom((Table)this.uak).where(this.uak.USER_ID.equal((Object)userId)).execute();
        this.dsl.deleteFrom((Table)this.ar).where(this.ar.USER_ID.equal((Object)userId)).execute();
        this.dsl.deleteFrom((Table)this.us).where(this.us.USER_ID.equal((Object)userId)).execute();
        this.dsl.deleteFrom((Table)this.ul).where(this.ul.USER_ID.equal((Object)userId)).execute();
        this.dsl.deleteFrom((Table)this.u).where(this.u.ID.equal((Object)userId)).execute();
    }

    @Transactional
    public void deleteAll() {
        this.dsl.deleteFrom((Table)this.uak).execute();
        this.dsl.deleteFrom((Table)this.ar).execute();
        this.dsl.deleteFrom((Table)this.us).execute();
        this.dsl.deleteFrom((Table)this.ul).execute();
        this.dsl.deleteFrom((Table)this.u).execute();
    }

    public void deleteApiKeyByIdAndUserId(@NotNull String apiKeyId, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)apiKeyId, (String)"apiKeyId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        this.dsl.deleteFrom((Table)this.uak).where(this.uak.ID.eq((Object)apiKeyId)).and(this.uak.USER_ID.eq((Object)userId)).execute();
    }

    public void deleteApiKeyByUserId(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        this.dsl.deleteFrom((Table)this.uak).where(this.uak.USER_ID.eq((Object)userId)).execute();
    }

    @NotNull
    public Set<String> findAnnouncementIdsReadByUserId(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Set set = this.dsl.select((SelectField)this.ar.ANNOUNCEMENT_ID).from((TableLike)this.ar).where(this.ar.USER_ID.eq((Object)userId)).fetchSet((Field)this.ar.ANNOUNCEMENT_ID);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"fetchSet(...)");
        return set;
    }

    public boolean existsByEmailIgnoreCase(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        return this.dsl.fetchExists((Select)this.dsl.selectFrom((TableLike)this.u).where(this.u.EMAIL.equalIgnoreCase(email)));
    }

    public boolean existsApiKeyByIdAndUserId(@NotNull String apiKeyId, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)apiKeyId, (String)"apiKeyId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return this.dsl.fetchExists((Table)this.uak, this.uak.ID.eq((Object)apiKeyId).and(this.uak.USER_ID.eq((Object)userId)));
    }

    public boolean existsApiKeyByCommentAndUserId(@NotNull String comment, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return this.dsl.fetchExists((Table)this.uak, this.uak.COMMENT.equalIgnoreCase(comment).and(this.uak.USER_ID.eq((Object)userId)));
    }

    @Nullable
    public KomgaUser findByEmailIgnoreCaseOrNull(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        SelectConditionStep selectConditionStep = this.selectBase().where(this.u.EMAIL.equalIgnoreCase(email));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"where(...)");
        return (KomgaUser)CollectionsKt.firstOrNull((List)this.fetchAndMap((ResultQuery)selectConditionStep));
    }

    @Nullable
    public Pair<KomgaUser, ApiKey> findByApiKeyOrNull(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        SelectConditionStep selectConditionStep = this.selectBase().leftJoin((TableLike)this.uak).on(this.u.ID.eq((Field)this.uak.USER_ID)).where(this.uak.API_KEY.eq((Object)apiKey));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"where(...)");
        KomgaUser komgaUser = (KomgaUser)CollectionsKt.firstOrNull((List)this.fetchAndMap((ResultQuery)selectConditionStep));
        if (komgaUser == null) {
            return null;
        }
        KomgaUser user = komgaUser;
        List list = this.dsl.selectFrom((TableLike)this.uak).where(this.uak.API_KEY.eq((Object)apiKey)).fetchInto((Table)this.uak).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        ApiKey apiKey2 = (ApiKey)CollectionsKt.firstOrNull((List)list);
        if (apiKey2 == null) {
            return null;
        }
        ApiKey key2 = apiKey2;
        return new Pair((Object)user, (Object)key2);
    }

    private ApiKey toDomain(UserApiKeyRecord $this$toDomain) {
        String string = $this$toDomain.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        String string2 = $this$toDomain.getUserId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUserId(...)");
        String string3 = $this$toDomain.getApiKey();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getApiKey(...)");
        String string4 = $this$toDomain.getComment();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getComment(...)");
        LocalDateTime localDateTime = $this$toDomain.getCreatedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"getCreatedDate(...)");
        LocalDateTime localDateTime2 = LanguageUtilsKt.toCurrentTimeZone((LocalDateTime)localDateTime);
        LocalDateTime localDateTime3 = $this$toDomain.getLastModifiedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime3, (String)"getLastModifiedDate(...)");
        return new ApiKey(string, string2, string3, string4, localDateTime2, LanguageUtilsKt.toCurrentTimeZone((LocalDateTime)localDateTime3));
    }

    public static final /* synthetic */ ApiKey access$toDomain(KomgaUserDao $this, UserApiKeyRecord $receiver) {
        return $this.toDomain($receiver);
    }

    public static final /* synthetic */ User access$getU$p(KomgaUserDao $this) {
        return $this.u;
    }

    public static final /* synthetic */ UserLibrarySharing access$getUl$p(KomgaUserDao $this) {
        return $this.ul;
    }
}

