/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.jooq.main;

import java.net.URL;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.model.SidecarStored;
import org.gotson.komga.domain.persistence.SidecarRepository;
import org.gotson.komga.infrastructure.jooq.UtilsKt;
import org.gotson.komga.jooq.main.Tables;
import org.gotson.komga.jooq.main.tables.Library;
import org.gotson.komga.jooq.main.tables.Sidecar;
import org.gotson.komga.jooq.main.tables.records.SidecarRecord;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.RecordMapper;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00050\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u001e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0017J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014H\u0016J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\f\u0010\u001b\u001a\u00020\u0017*\u00020\u001cH\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \t*\u0004\u0018\u00010\u000b0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/gotson/komga/infrastructure/jooq/main/SidecarDao;", "Lorg/gotson/komga/domain/persistence/SidecarRepository;", "dsl", "Lorg/jooq/DSLContext;", "batchSize", "", "(Lorg/jooq/DSLContext;I)V", "l", "Lorg/gotson/komga/jooq/main/tables/Library;", "kotlin.jvm.PlatformType", "sc", "Lorg/gotson/komga/jooq/main/tables/Sidecar;", "countGroupedByLibraryId", "", "", "deleteByLibraryId", "", "libraryId", "deleteByLibraryIdAndUrls", "urls", "", "Ljava/net/URL;", "findAll", "Lorg/gotson/komga/domain/model/SidecarStored;", "save", "sidecar", "Lorg/gotson/komga/domain/model/Sidecar;", "toDomain", "Lorg/gotson/komga/jooq/main/tables/records/SidecarRecord;", "komga"})
@SourceDebugExtension(value={"SMAP\nSidecarDao.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SidecarDao.kt\norg/gotson/komga/infrastructure/jooq/main/SidecarDao\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1549#2:80\n1620#2,3:81\n*S KotlinDebug\n*F\n+ 1 SidecarDao.kt\norg/gotson/komga/infrastructure/jooq/main/SidecarDao\n*L\n51#1:80\n51#1:81,3\n*E\n"})
public class SidecarDao
implements SidecarRepository {
    @NotNull
    private final DSLContext dsl;
    private final int batchSize;
    private final Sidecar sc;
    private final Library l;

    public SidecarDao(@NotNull DSLContext dsl, @Value(value="#{@komgaProperties.database.batchChunkSize}") int batchSize) {
        Intrinsics.checkNotNullParameter((Object)dsl, (String)"dsl");
        this.dsl = dsl;
        this.batchSize = batchSize;
        this.sc = Tables.SIDECAR;
        this.l = Tables.LIBRARY;
    }

    @NotNull
    public Collection<SidecarStored> findAll() {
        List list = this.dsl.selectFrom((TableLike)this.sc).fetch().map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    public void save(@NotNull String libraryId, @NotNull org.gotson.komga.domain.model.Sidecar sidecar) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        Intrinsics.checkNotNullParameter((Object)sidecar, (String)"sidecar");
        Object[] objectArray = new Object[]{sidecar.getUrl().toString(), sidecar.getParentUrl().toString(), sidecar.getLastModifiedTime(), libraryId};
        this.dsl.insertInto((Table)this.sc).values(objectArray).onDuplicateKeyUpdate().set((Field)this.sc.LAST_MODIFIED_TIME, (Object)sidecar.getLastModifiedTime()).set((Field)this.sc.PARENT_URL, (Object)sidecar.getParentUrl().toString()).set((Field)this.sc.LIBRARY_ID, (Object)libraryId).execute();
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void deleteByLibraryIdAndUrls(@NotNull String libraryId, @NotNull Collection<URL> urls) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        Iterable iterable = urls;
        int n = this.batchSize;
        DSLContext dSLContext = this.dsl;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            URL uRL = (URL)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        UtilsKt.insertTempStrings((DSLContext)dSLContext, (int)n, (Collection)collection);
        this.dsl.deleteFrom((Table)this.sc).where(this.sc.LIBRARY_ID.eq((Object)libraryId)).and(this.sc.URL.in((Select)UtilsKt.selectTempStrings((DSLContext)this.dsl))).execute();
    }

    public void deleteByLibraryId(@NotNull String libraryId) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        this.dsl.deleteFrom((Table)this.sc).where(this.sc.LIBRARY_ID.eq((Object)libraryId)).execute();
    }

    @NotNull
    public Map<String, Integer> countGroupedByLibraryId() {
        GroupField[] groupFieldArray = new GroupField[]{this.sc.LIBRARY_ID};
        Map map = this.dsl.select((SelectField)this.sc.LIBRARY_ID, (SelectField)DSL.count((Field)((Field)this.sc.URL))).from((TableLike)this.sc).groupBy(groupFieldArray).fetchMap((Field)this.sc.LIBRARY_ID, (Field)DSL.count((Field)((Field)this.sc.URL)));
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"fetchMap(...)");
        return map;
    }

    private SidecarStored toDomain(SidecarRecord $this$toDomain) {
        URL uRL = new URL($this$toDomain.getUrl());
        URL uRL2 = new URL($this$toDomain.getParentUrl());
        LocalDateTime localDateTime = $this$toDomain.getLastModifiedTime();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"getLastModifiedTime(...)");
        String string = $this$toDomain.getLibraryId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLibraryId(...)");
        return new SidecarStored(uRL, uRL2, localDateTime, string);
    }

    public static final /* synthetic */ SidecarStored access$toDomain(SidecarDao $this, SidecarRecord $receiver) {
        return $this.toDomain($receiver);
    }
}

