/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.jooq.main;

import java.net.URL;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.model.Dimension;
import org.gotson.komga.domain.model.ThumbnailBook;
import org.gotson.komga.domain.persistence.ThumbnailBookRepository;
import org.gotson.komga.infrastructure.jooq.UtilsKt;
import org.gotson.komga.jooq.main.Tables;
import org.gotson.komga.jooq.main.tables.records.ThumbnailBookRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.RecordMapper;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\rH\u0016J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u0015H\u0017J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rH\u0016J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00152\u0006\u0010\u000f\u001a\u00020\rH\u0016J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00152\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0018\u001a\u00020\rH\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u000f\u001a\u00020\rH\u0016J\u0010\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u001cH\u0016J\u0010\u0010&\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u001cH\u0017J\u0010\u0010'\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u001cH\u0016J\u0016\u0010(\u001a\u00020\u000b2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0015H\u0016J\f\u0010*\u001a\u00020\u001c*\u00020+H\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/gotson/komga/infrastructure/jooq/main/ThumbnailBookDao;", "Lorg/gotson/komga/domain/persistence/ThumbnailBookRepository;", "dsl", "Lorg/jooq/DSLContext;", "batchSize", "", "(Lorg/jooq/DSLContext;I)V", "tb", "Lorg/gotson/komga/jooq/main/tables/ThumbnailBook;", "kotlin.jvm.PlatformType", "delete", "", "thumbnailBookId", "", "deleteByBookId", "bookId", "deleteByBookIdAndType", "type", "Lorg/gotson/komga/domain/model/ThumbnailBook$Type;", "deleteByBookIds", "bookIds", "", "existsById", "", "thumbnailId", "findAllBookIdsByThumbnailTypeAndDimensionSmallerThan", "size", "findAllByBookId", "Lorg/gotson/komga/domain/model/ThumbnailBook;", "findAllByBookIdAndType", "findAllWithoutMetadata", "Lorg/springframework/data/domain/Page;", "pageable", "Lorg/springframework/data/domain/Pageable;", "findByIdOrNull", "findSelectedByBookIdOrNull", "insert", "thumbnail", "markSelected", "update", "updateMetadata", "thumbnails", "toDomain", "Lorg/gotson/komga/jooq/main/tables/records/ThumbnailBookRecord;", "komga"})
@SourceDebugExtension(value={"SMAP\nThumbnailBookDao.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThumbnailBookDao.kt\norg/gotson/komga/infrastructure/jooq/main/ThumbnailBookDao\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,187:1\n1#2:188\n1855#3,2:189\n*S KotlinDebug\n*F\n+ 1 ThumbnailBookDao.kt\norg/gotson/komga/infrastructure/jooq/main/ThumbnailBookDao\n*L\n120#1:189,2\n*E\n"})
public class ThumbnailBookDao
implements ThumbnailBookRepository {
    @NotNull
    private final DSLContext dsl;
    private final int batchSize;
    private final org.gotson.komga.jooq.main.tables.ThumbnailBook tb;

    public ThumbnailBookDao(@NotNull DSLContext dsl, @Value(value="#{@komgaProperties.database.batchChunkSize}") int batchSize) {
        Intrinsics.checkNotNullParameter((Object)dsl, (String)"dsl");
        this.dsl = dsl;
        this.batchSize = batchSize;
        this.tb = Tables.THUMBNAIL_BOOK;
    }

    @NotNull
    public Collection<ThumbnailBook> findAllByBookId(@NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        List list = this.dsl.selectFrom((TableLike)this.tb).where(this.tb.BOOK_ID.eq((Object)bookId)).fetchInto((Table)this.tb).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    @NotNull
    public Collection<ThumbnailBook> findAllByBookIdAndType(@NotNull String bookId, @NotNull ThumbnailBook.Type type) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        List list = this.dsl.selectFrom((TableLike)this.tb).where(this.tb.BOOK_ID.eq((Object)bookId)).and(this.tb.TYPE.eq((Object)type.toString())).fetchInto((Table)this.tb).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    @Nullable
    public ThumbnailBook findByIdOrNull(@NotNull String thumbnailId) {
        Intrinsics.checkNotNullParameter((Object)thumbnailId, (String)"thumbnailId");
        ThumbnailBookRecord thumbnailBookRecord = (ThumbnailBookRecord)this.dsl.selectFrom((TableLike)this.tb).where(this.tb.ID.eq((Object)thumbnailId)).fetchOneInto((Table)this.tb);
        return thumbnailBookRecord != null ? this.toDomain(thumbnailBookRecord) : null;
    }

    @Nullable
    public ThumbnailBook findSelectedByBookIdOrNull(@NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        List list = this.dsl.selectFrom((TableLike)this.tb).where(this.tb.BOOK_ID.eq((Object)bookId)).and(this.tb.SELECTED.isTrue()).limit((Number)1).fetchInto((Table)this.tb).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return (ThumbnailBook)CollectionsKt.firstOrNull((List)list);
    }

    @NotNull
    public Page<ThumbnailBook> findAllWithoutMetadata(@NotNull Pageable pageable) {
        SelectConditionStep selectConditionStep;
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        SelectConditionStep selectConditionStep2 = this.dsl.selectFrom((TableLike)this.tb).where(this.tb.FILE_SIZE.eq((Object)0L)).or(this.tb.MEDIA_TYPE.eq((Object)"")).or(this.tb.WIDTH.eq((Object)0)).or(this.tb.HEIGHT.eq((Object)0));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep2, (String)"or(...)");
        SelectConditionStep query = selectConditionStep2;
        int count = this.dsl.fetchCount((Select)query);
        SelectConditionStep $this$findAllWithoutMetadata_u24lambda_u240 = selectConditionStep = query;
        boolean bl = false;
        if (pageable.isPaged()) {
            $this$findAllWithoutMetadata_u24lambda_u240.limit((Number)pageable.getPageSize()).offset((Number)pageable.getOffset());
        }
        List list = selectConditionStep.fetchInto((Table)this.tb).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        List items2 = list;
        return (Page)new PageImpl(items2, pageable, (long)count);
    }

    @NotNull
    public Collection<String> findAllBookIdsByThumbnailTypeAndDimensionSmallerThan(@NotNull ThumbnailBook.Type type, int size) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        List list = this.dsl.select((SelectField)this.tb.BOOK_ID).from((TableLike)this.tb).where(this.tb.TYPE.eq((Object)type.toString())).and(this.tb.WIDTH.lt((Object)size)).and(this.tb.HEIGHT.lt((Object)size)).fetch((Field)this.tb.BOOK_ID);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        return list;
    }

    public boolean existsById(@NotNull String thumbnailId) {
        Intrinsics.checkNotNullParameter((Object)thumbnailId, (String)"thumbnailId");
        return this.dsl.fetchExists((Table)this.tb, this.tb.ID.eq((Object)thumbnailId));
    }

    public void insert(@NotNull ThumbnailBook thumbnail) {
        Intrinsics.checkNotNullParameter((Object)thumbnail, (String)"thumbnail");
        URL uRL = thumbnail.getUrl();
        this.dsl.insertInto((Table)this.tb).set((Field)this.tb.ID, (Object)thumbnail.getId()).set((Field)this.tb.BOOK_ID, (Object)thumbnail.getBookId()).set((Field)this.tb.THUMBNAIL, (Object)thumbnail.getThumbnail()).set((Field)this.tb.URL, (Object)(uRL != null ? uRL.toString() : null)).set((Field)this.tb.SELECTED, (Object)thumbnail.getSelected()).set((Field)this.tb.TYPE, (Object)thumbnail.getType().toString()).set((Field)this.tb.MEDIA_TYPE, (Object)thumbnail.getMediaType()).set((Field)this.tb.WIDTH, (Object)thumbnail.getDimension().getWidth()).set((Field)this.tb.HEIGHT, (Object)thumbnail.getDimension().getHeight()).set((Field)this.tb.FILE_SIZE, (Object)thumbnail.getFileSize()).execute();
    }

    public void update(@NotNull ThumbnailBook thumbnail) {
        Intrinsics.checkNotNullParameter((Object)thumbnail, (String)"thumbnail");
        URL uRL = thumbnail.getUrl();
        this.dsl.update((Table)this.tb).set((Field)this.tb.BOOK_ID, (Object)thumbnail.getBookId()).set((Field)this.tb.THUMBNAIL, (Object)thumbnail.getThumbnail()).set((Field)this.tb.URL, (Object)(uRL != null ? uRL.toString() : null)).set((Field)this.tb.SELECTED, (Object)thumbnail.getSelected()).set((Field)this.tb.TYPE, (Object)thumbnail.getType().toString()).set((Field)this.tb.MEDIA_TYPE, (Object)thumbnail.getMediaType()).set((Field)this.tb.WIDTH, (Object)thumbnail.getDimension().getWidth()).set((Field)this.tb.HEIGHT, (Object)thumbnail.getDimension().getHeight()).set((Field)this.tb.FILE_SIZE, (Object)thumbnail.getFileSize()).where(this.tb.ID.eq((Object)thumbnail.getId())).execute();
    }

    public void updateMetadata(@NotNull Collection<ThumbnailBook> thumbnails) {
        Intrinsics.checkNotNullParameter(thumbnails, (String)"thumbnails");
        this.dsl.batched(arg_0 -> ThumbnailBookDao.updateMetadata$lambda$2(thumbnails, this, arg_0));
    }

    @Transactional
    public void markSelected(@NotNull ThumbnailBook thumbnail) {
        Intrinsics.checkNotNullParameter((Object)thumbnail, (String)"thumbnail");
        this.dsl.update((Table)this.tb).set((Field)this.tb.SELECTED, (Object)false).where(this.tb.BOOK_ID.eq((Object)thumbnail.getBookId())).and(this.tb.ID.ne((Object)thumbnail.getId())).execute();
        this.dsl.update((Table)this.tb).set((Field)this.tb.SELECTED, (Object)true).where(this.tb.BOOK_ID.eq((Object)thumbnail.getBookId())).and(this.tb.ID.eq((Object)thumbnail.getId())).execute();
    }

    public void delete(@NotNull String thumbnailBookId) {
        Intrinsics.checkNotNullParameter((Object)thumbnailBookId, (String)"thumbnailBookId");
        this.dsl.deleteFrom((Table)this.tb).where(this.tb.ID.eq((Object)thumbnailBookId)).execute();
    }

    public void deleteByBookId(@NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        this.dsl.deleteFrom((Table)this.tb).where(this.tb.BOOK_ID.eq((Object)bookId)).execute();
    }

    @Transactional
    public void deleteByBookIds(@NotNull Collection<String> bookIds) {
        Intrinsics.checkNotNullParameter(bookIds, (String)"bookIds");
        UtilsKt.insertTempStrings((DSLContext)this.dsl, (int)this.batchSize, bookIds);
        this.dsl.deleteFrom((Table)this.tb).where(this.tb.BOOK_ID.in((Select)UtilsKt.selectTempStrings((DSLContext)this.dsl))).execute();
    }

    public void deleteByBookIdAndType(@NotNull String bookId, @NotNull ThumbnailBook.Type type) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.dsl.deleteFrom((Table)this.tb).where(this.tb.BOOK_ID.eq((Object)bookId)).and(this.tb.TYPE.eq((Object)type.toString())).execute();
    }

    /*
     * WARNING - void declaration
     */
    private ThumbnailBook toDomain(ThumbnailBookRecord $this$toDomain) {
        URL uRL;
        byte[] byArray = $this$toDomain.getThumbnail();
        String string = $this$toDomain.getUrl();
        if (string != null) {
            void it;
            String string2 = string;
            byte[] byArray2 = byArray;
            boolean bl = false;
            uRL = new URL((String)it);
            byArray = byArray2;
        } else {
            uRL = null;
        }
        Boolean bl = $this$toDomain.getSelected();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getSelected(...)");
        boolean bl2 = bl;
        String string3 = $this$toDomain.getType();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getType(...)");
        ThumbnailBook.Type type = ThumbnailBook.Type.valueOf((String)string3);
        String string4 = $this$toDomain.getMediaType();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getMediaType(...)");
        Long l = $this$toDomain.getFileSize();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getFileSize(...)");
        long l2 = ((Number)l).longValue();
        Integer n = $this$toDomain.getWidth();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getWidth(...)");
        int n2 = ((Number)n).intValue();
        Integer n3 = $this$toDomain.getHeight();
        Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"getHeight(...)");
        Dimension dimension = new Dimension(n2, ((Number)n3).intValue());
        String string5 = $this$toDomain.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getId(...)");
        String string6 = $this$toDomain.getBookId();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getBookId(...)");
        LocalDateTime localDateTime = $this$toDomain.getCreatedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"getCreatedDate(...)");
        LocalDateTime localDateTime2 = $this$toDomain.getLastModifiedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"getLastModifiedDate(...)");
        LocalDateTime localDateTime3 = localDateTime2;
        LocalDateTime localDateTime4 = localDateTime;
        String string7 = string6;
        String string8 = string5;
        Dimension dimension2 = dimension;
        long l3 = l2;
        String string9 = string4;
        ThumbnailBook.Type type2 = type;
        boolean bl3 = bl2;
        URL uRL2 = uRL;
        byte[] byArray3 = byArray;
        return new ThumbnailBook(byArray3, uRL2, bl3, type2, string9, l3, dimension2, string8, string7, localDateTime4, localDateTime3);
    }

    private static final void updateMetadata$lambda$2(Collection $thumbnails, ThumbnailBookDao this$0, Configuration c) {
        Intrinsics.checkNotNullParameter((Object)$thumbnails, (String)"$thumbnails");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = $thumbnails;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ThumbnailBook it = (ThumbnailBook)element$iv;
            boolean bl = false;
            c.dsl().update((Table)this$0.tb).set((Field)this$0.tb.MEDIA_TYPE, (Object)it.getMediaType()).set((Field)this$0.tb.WIDTH, (Object)it.getDimension().getWidth()).set((Field)this$0.tb.HEIGHT, (Object)it.getDimension().getHeight()).set((Field)this$0.tb.FILE_SIZE, (Object)it.getFileSize()).where(this$0.tb.ID.eq((Object)it.getId())).execute();
        }
    }

    public static final /* synthetic */ ThumbnailBook access$toDomain(ThumbnailBookDao $this, ThumbnailBookRecord $receiver) {
        return $this.toDomain($receiver);
    }
}

