/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.jooq.main;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.model.Dimension;
import org.gotson.komga.domain.model.ThumbnailReadList;
import org.gotson.komga.domain.persistence.ThumbnailReadListRepository;
import org.gotson.komga.jooq.main.Tables;
import org.gotson.komga.jooq.main.tables.ThumbnailReadlist;
import org.gotson.komga.jooq.main.tables.records.ThumbnailReadlistRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.RecordMapper;
import org.jooq.SelectConditionStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bH\u0016J\u0016\u0010\u000e\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\r\u001a\u00020\u000bH\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\u000bH\u0016J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u0012H\u0017J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\u0016\u0010\u001e\u001a\u00020\t2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120\u0010H\u0016J\f\u0010 \u001a\u00020\u0012*\u00020!H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/gotson/komga/infrastructure/jooq/main/ThumbnailReadListDao;", "Lorg/gotson/komga/domain/persistence/ThumbnailReadListRepository;", "dsl", "Lorg/jooq/DSLContext;", "(Lorg/jooq/DSLContext;)V", "tr", "Lorg/gotson/komga/jooq/main/tables/ThumbnailReadlist;", "kotlin.jvm.PlatformType", "delete", "", "thumbnailReadListId", "", "deleteByReadListId", "readListId", "deleteByReadListIds", "readListIds", "", "findAllByReadListId", "Lorg/gotson/komga/domain/model/ThumbnailReadList;", "findAllWithoutMetadata", "Lorg/springframework/data/domain/Page;", "pageable", "Lorg/springframework/data/domain/Pageable;", "findByIdOrNull", "thumbnailId", "findSelectedByReadListIdOrNull", "insert", "thumbnail", "markSelected", "update", "updateMetadata", "thumbnails", "toDomain", "Lorg/gotson/komga/jooq/main/tables/records/ThumbnailReadlistRecord;", "komga"})
@SourceDebugExtension(value={"SMAP\nThumbnailReadListDao.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThumbnailReadListDao.kt\norg/gotson/komga/infrastructure/jooq/main/ThumbnailReadListDao\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n1#2:144\n1855#3,2:145\n*S KotlinDebug\n*F\n+ 1 ThumbnailReadListDao.kt\norg/gotson/komga/infrastructure/jooq/main/ThumbnailReadListDao\n*L\n90#1:145,2\n*E\n"})
public class ThumbnailReadListDao
implements ThumbnailReadListRepository {
    @NotNull
    private final DSLContext dsl;
    private final ThumbnailReadlist tr;

    public ThumbnailReadListDao(@NotNull DSLContext dsl) {
        Intrinsics.checkNotNullParameter((Object)dsl, (String)"dsl");
        this.dsl = dsl;
        this.tr = Tables.THUMBNAIL_READLIST;
    }

    @NotNull
    public Collection<ThumbnailReadList> findAllByReadListId(@NotNull String readListId) {
        Intrinsics.checkNotNullParameter((Object)readListId, (String)"readListId");
        List list = this.dsl.selectFrom((TableLike)this.tr).where(this.tr.READLIST_ID.eq((Object)readListId)).fetchInto((Table)this.tr).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    @Nullable
    public ThumbnailReadList findByIdOrNull(@NotNull String thumbnailId) {
        Intrinsics.checkNotNullParameter((Object)thumbnailId, (String)"thumbnailId");
        ThumbnailReadlistRecord thumbnailReadlistRecord = (ThumbnailReadlistRecord)this.dsl.selectFrom((TableLike)this.tr).where(this.tr.ID.eq((Object)thumbnailId)).fetchOneInto((Table)this.tr);
        return thumbnailReadlistRecord != null ? this.toDomain(thumbnailReadlistRecord) : null;
    }

    @Nullable
    public ThumbnailReadList findSelectedByReadListIdOrNull(@NotNull String readListId) {
        Intrinsics.checkNotNullParameter((Object)readListId, (String)"readListId");
        List list = this.dsl.selectFrom((TableLike)this.tr).where(this.tr.READLIST_ID.eq((Object)readListId)).and(this.tr.SELECTED.isTrue()).limit((Number)1).fetchInto((Table)this.tr).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return (ThumbnailReadList)CollectionsKt.firstOrNull((List)list);
    }

    @NotNull
    public Page<ThumbnailReadList> findAllWithoutMetadata(@NotNull Pageable pageable) {
        SelectConditionStep selectConditionStep;
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        SelectConditionStep selectConditionStep2 = this.dsl.selectFrom((TableLike)this.tr).where(this.tr.FILE_SIZE.eq((Object)0L)).or(this.tr.MEDIA_TYPE.eq((Object)"")).or(this.tr.WIDTH.eq((Object)0)).or(this.tr.HEIGHT.eq((Object)0));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep2, (String)"or(...)");
        SelectConditionStep query = selectConditionStep2;
        int count = CollectionsKt.count((Iterable)((Iterable)query));
        SelectConditionStep $this$findAllWithoutMetadata_u24lambda_u240 = selectConditionStep = query;
        boolean bl = false;
        if (pageable.isPaged()) {
            $this$findAllWithoutMetadata_u24lambda_u240.limit((Number)pageable.getPageSize()).offset((Number)pageable.getOffset());
        }
        List list = selectConditionStep.fetchInto((Table)this.tr).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        List items2 = list;
        return (Page)new PageImpl(items2, pageable, (long)count);
    }

    public void insert(@NotNull ThumbnailReadList thumbnail) {
        Intrinsics.checkNotNullParameter((Object)thumbnail, (String)"thumbnail");
        this.dsl.insertInto((Table)this.tr).set((Field)this.tr.ID, (Object)thumbnail.getId()).set((Field)this.tr.READLIST_ID, (Object)thumbnail.getReadListId()).set((Field)this.tr.THUMBNAIL, (Object)thumbnail.getThumbnail()).set((Field)this.tr.SELECTED, (Object)thumbnail.getSelected()).set((Field)this.tr.TYPE, (Object)thumbnail.getType().toString()).set((Field)this.tr.MEDIA_TYPE, (Object)thumbnail.getMediaType()).set((Field)this.tr.WIDTH, (Object)thumbnail.getDimension().getWidth()).set((Field)this.tr.HEIGHT, (Object)thumbnail.getDimension().getHeight()).set((Field)this.tr.FILE_SIZE, (Object)thumbnail.getFileSize()).execute();
    }

    public void update(@NotNull ThumbnailReadList thumbnail) {
        Intrinsics.checkNotNullParameter((Object)thumbnail, (String)"thumbnail");
        this.dsl.update((Table)this.tr).set((Field)this.tr.READLIST_ID, (Object)thumbnail.getReadListId()).set((Field)this.tr.THUMBNAIL, (Object)thumbnail.getThumbnail()).set((Field)this.tr.SELECTED, (Object)thumbnail.getSelected()).set((Field)this.tr.TYPE, (Object)thumbnail.getType().toString()).set((Field)this.tr.MEDIA_TYPE, (Object)thumbnail.getMediaType()).set((Field)this.tr.WIDTH, (Object)thumbnail.getDimension().getWidth()).set((Field)this.tr.HEIGHT, (Object)thumbnail.getDimension().getHeight()).set((Field)this.tr.FILE_SIZE, (Object)thumbnail.getFileSize()).where(this.tr.ID.eq((Object)thumbnail.getId())).execute();
    }

    public void updateMetadata(@NotNull Collection<ThumbnailReadList> thumbnails) {
        Intrinsics.checkNotNullParameter(thumbnails, (String)"thumbnails");
        this.dsl.batched(arg_0 -> ThumbnailReadListDao.updateMetadata$lambda$2(thumbnails, this, arg_0));
    }

    @Transactional
    public void markSelected(@NotNull ThumbnailReadList thumbnail) {
        Intrinsics.checkNotNullParameter((Object)thumbnail, (String)"thumbnail");
        this.dsl.update((Table)this.tr).set((Field)this.tr.SELECTED, (Object)false).where(this.tr.READLIST_ID.eq((Object)thumbnail.getReadListId())).and(this.tr.ID.ne((Object)thumbnail.getId())).execute();
        this.dsl.update((Table)this.tr).set((Field)this.tr.SELECTED, (Object)true).where(this.tr.READLIST_ID.eq((Object)thumbnail.getReadListId())).and(this.tr.ID.eq((Object)thumbnail.getId())).execute();
    }

    public void delete(@NotNull String thumbnailReadListId) {
        Intrinsics.checkNotNullParameter((Object)thumbnailReadListId, (String)"thumbnailReadListId");
        this.dsl.deleteFrom((Table)this.tr).where(this.tr.ID.eq((Object)thumbnailReadListId)).execute();
    }

    public void deleteByReadListId(@NotNull String readListId) {
        Intrinsics.checkNotNullParameter((Object)readListId, (String)"readListId");
        this.dsl.deleteFrom((Table)this.tr).where(this.tr.READLIST_ID.eq((Object)readListId)).execute();
    }

    public void deleteByReadListIds(@NotNull Collection<String> readListIds) {
        Intrinsics.checkNotNullParameter(readListIds, (String)"readListIds");
        this.dsl.deleteFrom((Table)this.tr).where(this.tr.READLIST_ID.in(readListIds)).execute();
    }

    private ThumbnailReadList toDomain(ThumbnailReadlistRecord $this$toDomain) {
        byte[] byArray = $this$toDomain.getThumbnail();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getThumbnail(...)");
        Boolean bl = $this$toDomain.getSelected();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getSelected(...)");
        boolean bl2 = bl;
        String string = $this$toDomain.getType();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getType(...)");
        ThumbnailReadList.Type type = ThumbnailReadList.Type.valueOf((String)string);
        String string2 = $this$toDomain.getMediaType();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMediaType(...)");
        Long l = $this$toDomain.getFileSize();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getFileSize(...)");
        long l2 = ((Number)l).longValue();
        Integer n = $this$toDomain.getWidth();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getWidth(...)");
        int n2 = ((Number)n).intValue();
        Integer n3 = $this$toDomain.getHeight();
        Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"getHeight(...)");
        Dimension dimension = new Dimension(n2, ((Number)n3).intValue());
        String string3 = $this$toDomain.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getId(...)");
        String string4 = $this$toDomain.getReadlistId();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getReadlistId(...)");
        LocalDateTime localDateTime = $this$toDomain.getCreatedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"getCreatedDate(...)");
        LocalDateTime localDateTime2 = $this$toDomain.getLastModifiedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"getLastModifiedDate(...)");
        return new ThumbnailReadList(byArray, bl2, type, string2, l2, dimension, string3, string4, localDateTime, localDateTime2);
    }

    private static final void updateMetadata$lambda$2(Collection $thumbnails, ThumbnailReadListDao this$0, Configuration c) {
        Intrinsics.checkNotNullParameter((Object)$thumbnails, (String)"$thumbnails");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = $thumbnails;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ThumbnailReadList it = (ThumbnailReadList)element$iv;
            boolean bl = false;
            c.dsl().update((Table)this$0.tr).set((Field)this$0.tr.MEDIA_TYPE, (Object)it.getMediaType()).set((Field)this$0.tr.WIDTH, (Object)it.getDimension().getWidth()).set((Field)this$0.tr.HEIGHT, (Object)it.getDimension().getHeight()).set((Field)this$0.tr.FILE_SIZE, (Object)it.getFileSize()).where(this$0.tr.ID.eq((Object)it.getId())).execute();
        }
    }

    public static final /* synthetic */ ThumbnailReadList access$toDomain(ThumbnailReadListDao $this, ThumbnailReadlistRecord $receiver) {
        return $this.toDomain($receiver);
    }
}

