/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.jooq.tasks;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.gotson.komga.application.tasks.Task;
import org.gotson.komga.application.tasks.TasksRepository;
import org.gotson.komga.infrastructure.jooq.tasks.TasksDaoKt;
import org.gotson.komga.jooq.tasks.Tables;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.InsertOnDuplicateSetMoreStep;
import org.jooq.OrderField;
import org.jooq.Query;
import org.jooq.Record2;
import org.jooq.Record3;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectJoinStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@DependsOn(value={"flywaySecondaryMigrationInitializer"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B!\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0005H\u0016J\u0014\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00050\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0014H\u0016J\b\u0010\u0017\u001a\u00020\u0005H\u0016J\b\u0010\u0018\u001a\u00020\u0005H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J\u001c\u0010\u001c\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u0011H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010\u001f\u001a\u00020\u00142\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001b0!H\u0016J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u001bH\u0016JS\u0010#\u001aM\u0012D\u0012B\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00120\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00120\u0012 \u000b* \u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00120\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00120\u0012\u0018\u00010%0%0$\u00a2\u0006\u0002\b\u000eH\u0012J\u0012\u0010&\u001a\u0004\u0018\u00010\u001b2\u0006\u0010'\u001a\u00020\u0012H\u0017J\u001a\u0010(\u001a\u0004\u0018\u00010\u001b*\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120%H\u0012J\f\u0010)\u001a\u00020**\u00020\u001bH\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/gotson/komga/infrastructure/jooq/tasks/TasksDao;", "Lorg/gotson/komga/application/tasks/TasksRepository;", "dsl", "Lorg/jooq/DSLContext;", "batchSize", "", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lorg/jooq/DSLContext;ILcom/fasterxml/jackson/databind/ObjectMapper;)V", "t", "Lorg/gotson/komga/jooq/tasks/tables/Task;", "kotlin.jvm.PlatformType", "tasksAvailableCondition", "Lorg/jooq/Condition;", "Lorg/jetbrains/annotations/NotNull;", "count", "countBySimpleType", "", "", "delete", "", "taskId", "deleteAll", "deleteAllWithoutOwner", "disown", "findAll", "", "Lorg/gotson/komga/application/tasks/Task;", "findAllGroupedByOwner", "hasAvailable", "", "save", "tasks", "", "task", "selectBase", "Lorg/jooq/SelectJoinStep;", "Lorg/jooq/Record2;", "takeFirst", "owner", "toDomain", "toQuery", "Lorg/jooq/Query;", "komga"})
@SourceDebugExtension(value={"SMAP\nTasksDao.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TasksDao.kt\norg/gotson/komga/infrastructure/jooq/tasks/TasksDao\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,164:1\n1603#2,9:165\n1855#2:174\n1856#2:176\n1612#2:177\n1603#2,9:178\n1855#2:187\n1856#2:190\n1612#2:191\n1490#2:192\n1520#2,3:193\n1523#2,3:203\n1179#2,2:206\n1253#2,4:208\n1549#2:212\n1620#2,3:213\n1855#2,2:216\n1#3:175\n1#3:188\n1#3:189\n372#4,7:196\n*S KotlinDebug\n*F\n+ 1 TasksDao.kt\norg/gotson/komga/infrastructure/jooq/tasks/TasksDao\n*L\n76#1:165,9\n76#1:174\n76#1:176\n76#1:177\n82#1:178,9\n82#1:187\n82#1:190\n82#1:191\n84#1:192\n84#1:193,3\n84#1:203,3\n107#1:206,2\n107#1:208,4\n116#1:212\n116#1:213,3\n118#1:216,2\n76#1:175\n82#1:189\n84#1:196,7\n*E\n"})
public class TasksDao
implements TasksRepository {
    @NotNull
    private final DSLContext dsl;
    private final int batchSize;
    @NotNull
    private final ObjectMapper objectMapper;
    private final org.gotson.komga.jooq.tasks.tables.Task t;
    @NotNull
    private final Condition tasksAvailableCondition;

    public TasksDao(@Qualifier(value="tasksDslContext") @NotNull DSLContext dsl, @Value(value="#{@komgaProperties.tasksDb.batchChunkSize}") int batchSize, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)dsl, (String)"dsl");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.dsl = dsl;
        this.batchSize = batchSize;
        this.objectMapper = objectMapper;
        this.t = Tables.TASK;
        Condition condition = this.t.OWNER.isNull().and(this.t.GROUP_ID.notIn((Select)this.dsl.select((SelectField)this.t.GROUP_ID).from((TableLike)this.t).where(this.t.OWNER.isNotNull()).and(this.t.GROUP_ID.isNotNull())).or(this.t.GROUP_ID.isNull()));
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"and(...)");
        this.tasksAvailableCondition = condition;
    }

    public boolean hasAvailable() {
        return this.dsl.fetchExists((Table)this.t, this.tasksAvailableCondition);
    }

    @Transactional
    @Nullable
    public Task takeFirst(@NotNull String owner) {
        Task task2;
        block5: {
            block4: {
                Task task3;
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Record2 record2 = (Record2)this.selectBase().where(this.tasksAvailableCondition).orderBy((OrderField)this.t.PRIORITY.desc(), (OrderField)this.t.LAST_MODIFIED_DATE).limit((Number)1).fetchOne();
                if (record2 == null) break block4;
                Record2 it = record2;
                boolean bl = false;
                try {
                    Object object = this.objectMapper.readValue((String)it.value2(), Class.forName((String)it.value1()));
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gotson.komga.application.tasks.Task");
                    task3 = (Task)object;
                }
                catch (Exception e) {
                    TasksDaoKt.access$getLogger$p().error((Throwable)e, (Function0)new /* Unavailable Anonymous Inner Class!! */);
                    task3 = null;
                }
                task2 = task3;
                if (task2 != null) break block5;
            }
            return null;
        }
        Task task4 = task2;
        this.dsl.update((Table)this.t).set((Field)this.t.OWNER, (Object)owner).where(this.t.ID.eq((Object)task4.getUniqueId())).execute();
        return task4;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Task> findAll() {
        void $this$mapNotNullTo$iv$iv;
        Result result2 = this.selectBase().fetch();
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"fetch(...)");
        Iterable $this$mapNotNull$iv = (Iterable)result2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Task it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Record2 it = (Record2)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if (this.toDomain(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, List<Task>> findAllGroupedByOwner() {
        void $this$groupByTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Result result2 = this.dsl.select((SelectField)this.t.OWNER, (SelectField)this.t.CLASS, (SelectField)this.t.PAYLOAD).from((TableLike)this.t).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"fetch(...)");
        Iterable $this$mapNotNull$iv = (Iterable)result2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Record3 it = (Record3)element$iv$iv;
            boolean bl2 = false;
            Record2 record2 = it.into((Field)this.t.CLASS, (Field)this.t.PAYLOAD);
            Intrinsics.checkNotNullExpressionValue((Object)record2, (String)"into(...)");
            if (this.toDomain(record2) != null) {
                Task task2;
                boolean bl3 = false;
                pair = TuplesKt.to((Object)it.value1(), (Object)task2);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$mapNotNullTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            Pair it2 = (Pair)element$iv$iv;
            boolean $i$a$-groupBy-TasksDao$findAllGroupedByOwner$42 = false;
            String key$iv$iv = (String)it2.getFirst();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            Pair $i$a$-groupBy-TasksDao$findAllGroupedByOwner$42 = (Pair)element$iv$iv;
            List list = list$iv$iv;
            boolean bl = false;
            list.add((Task)it.getSecond());
        }
        return destination$iv$iv;
    }

    private SelectJoinStep<Record2<String, String>> selectBase() {
        SelectJoinStep selectJoinStep = this.dsl.select((SelectField)this.t.CLASS, (SelectField)this.t.PAYLOAD).from((TableLike)this.t);
        Intrinsics.checkNotNullExpressionValue((Object)selectJoinStep, (String)"from(...)");
        return selectJoinStep;
    }

    private Task toDomain(Record2<String, String> $this$toDomain) {
        Task task2;
        try {
            Object object = this.objectMapper.readValue((String)$this$toDomain.value2(), Class.forName((String)$this$toDomain.value1()));
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gotson.komga.application.tasks.Task");
            task2 = (Task)object;
        }
        catch (Exception e) {
            TasksDaoKt.access$getLogger$p().error((Throwable)e, (Function0)new /* Unavailable Anonymous Inner Class!! */);
            task2 = null;
        }
        return task2;
    }

    public int count() {
        return this.dsl.fetchCount((Table)this.t);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, Integer> countBySimpleType() {
        void $this$associateTo$iv$iv;
        GroupField[] groupFieldArray = new GroupField[]{this.t.SIMPLE_TYPE};
        Result result2 = this.dsl.select((SelectField)this.t.SIMPLE_TYPE, (SelectField)DSL.count((Field)((Field)this.t.SIMPLE_TYPE))).from((TableLike)this.t).groupBy(groupFieldArray).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"fetch(...)");
        Iterable $this$associate$iv = (Iterable)result2;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Record2 it = (Record2)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.value1(), (Object)it.value2());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    public void save(@NotNull Task task2) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        this.toQuery(task2).execute();
    }

    /*
     * WARNING - void declaration
     */
    public void save(@NotNull Collection<? extends Task> tasks) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(tasks, (String)"tasks");
        Iterable $this$map$iv = tasks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Task task2 = (Task)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toQuery((Task)it));
        }
        Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)this.batchSize);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List chunk = (List)element$iv;
            boolean bl = false;
            this.dsl.batch((Collection)chunk).execute();
        }
    }

    public int disown() {
        return this.dsl.update((Table)this.t).set((Field)this.t.OWNER, null).where(this.t.OWNER.isNotNull()).execute();
    }

    public void delete(@NotNull String taskId) {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        this.dsl.deleteFrom((Table)this.t).where(this.t.ID.eq((Object)taskId)).execute();
    }

    public void deleteAll() {
        this.dsl.deleteFrom((Table)this.t).execute();
    }

    public int deleteAllWithoutOwner() {
        return this.dsl.deleteFrom((Table)this.t).where(this.t.OWNER.isNull()).execute();
    }

    private Query toQuery(Task $this$toQuery) {
        InsertOnDuplicateSetMoreStep insertOnDuplicateSetMoreStep = this.dsl.insertInto((Table)this.t, (Field)this.t.ID, (Field)this.t.PRIORITY, (Field)this.t.GROUP_ID, (Field)this.t.CLASS, (Field)this.t.SIMPLE_TYPE, (Field)this.t.PAYLOAD).values((Object)$this$toQuery.getUniqueId(), (Object)$this$toQuery.getPriority(), (Object)$this$toQuery.getGroupId(), (Object)$this$toQuery.getClass().getTypeName(), (Object)$this$toQuery.getClass().getSimpleName(), (Object)this.objectMapper.writeValueAsString((Object)$this$toQuery)).onDuplicateKeyUpdate().set((Field)this.t.GROUP_ID, (Object)$this$toQuery.getGroupId()).set((Field)this.t.PRIORITY, (Object)$this$toQuery.getPriority()).set((Field)this.t.CLASS, (Object)$this$toQuery.getClass().getTypeName()).set((Field)this.t.SIMPLE_TYPE, (Object)$this$toQuery.getClass().getSimpleName()).set((Field)this.t.PAYLOAD, (Object)this.objectMapper.writeValueAsString((Object)$this$toQuery)).set((Field)this.t.LAST_MODIFIED_DATE, (Object)LocalDateTime.now(ZoneId.of("Z")));
        Intrinsics.checkNotNullExpressionValue((Object)insertOnDuplicateSetMoreStep, (String)"set(...)");
        return (Query)insertOnDuplicateSetMoreStep;
    }
}

