/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.kobo;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Base64;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gotson.komga.domain.model.KomgaSyncToken;
import org.gotson.komga.infrastructure.kobo.KomgaSyncTokenGenerator;
import org.gotson.komga.infrastructure.kobo.KomgaSyncTokenGenerator$fromBase64$;
import org.gotson.komga.infrastructure.kobo.KomgaSyncTokenGeneratorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0012H\u0016R#\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068RX\u0092\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR#\u0010\f\u001a\n \u0007*\u0004\u0018\u00010\r0\r8RX\u0092\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/gotson/komga/infrastructure/kobo/KomgaSyncTokenGenerator;", "", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "base64Decoder", "Ljava/util/Base64$Decoder;", "kotlin.jvm.PlatformType", "getBase64Decoder", "()Ljava/util/Base64$Decoder;", "base64Decoder$delegate", "Lkotlin/Lazy;", "base64Encoder", "Ljava/util/Base64$Encoder;", "getBase64Encoder", "()Ljava/util/Base64$Encoder;", "base64Encoder$delegate", "fromBase64", "Lorg/gotson/komga/domain/model/KomgaSyncToken;", "base64Token", "", "fromRequestHeaders", "request", "Ljakarta/servlet/http/HttpServletRequest;", "toBase64", "token", "komga"})
@SourceDebugExtension(value={"SMAP\nKomgaSyncTokenGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KomgaSyncTokenGenerator.kt\norg/gotson/komga/infrastructure/kobo/KomgaSyncTokenGenerator\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,67:1\n53#2:68\n43#2:69\n*S KotlinDebug\n*F\n+ 1 KomgaSyncTokenGenerator.kt\norg/gotson/komga/infrastructure/kobo/KomgaSyncTokenGenerator\n*L\n34#1:68\n34#1:69\n*E\n"})
public class KomgaSyncTokenGenerator {
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final Lazy base64Encoder$delegate;
    @NotNull
    private final Lazy base64Decoder$delegate;

    public KomgaSyncTokenGenerator(@NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.objectMapper = objectMapper;
        this.base64Encoder$delegate = LazyKt.lazy((Function0)((Function0)base64Encoder.2.INSTANCE));
        this.base64Decoder$delegate = LazyKt.lazy((Function0)((Function0)base64Decoder.2.INSTANCE));
    }

    private Base64.Encoder getBase64Encoder() {
        Lazy lazy = this.base64Encoder$delegate;
        return (Base64.Encoder)lazy.getValue();
    }

    private Base64.Decoder getBase64Decoder() {
        Lazy lazy = this.base64Decoder$delegate;
        return (Base64.Decoder)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public KomgaSyncToken fromBase64(@NotNull String base64Token) {
        Intrinsics.checkNotNullParameter((Object)base64Token, (String)"base64Token");
        try {
            if (StringsKt.startsWith$default((String)base64Token, (String)"KOMGA.", (boolean)false, (int)2, null)) {
                void $this$readValue$iv;
                ObjectMapper objectMapper = this.objectMapper;
                byte[] byArray = this.getBase64Decoder().decode(StringsKt.removePrefix((String)base64Token, (CharSequence)"KOMGA."));
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
                byte[] src$iv = byArray;
                boolean $i$f$readValue = false;
                boolean $i$f$jacksonTypeRef = false;
                return (KomgaSyncToken)$this$readValue$iv.readValue(src$iv, (TypeReference)new fromBase64$$inlined$readValue$1());
            }
            if (!StringsKt.contains$default((CharSequence)base64Token, (char)'.', (boolean)false, (int)2, null)) {
                try {
                    JsonNode json = this.objectMapper.readTree(this.getBase64Decoder().decode(base64Token));
                    String koboToken = json.get("data").get("raw_kobo_store_token").asText();
                    Intrinsics.checkNotNull((Object)koboToken);
                    return new KomgaSyncToken(0, koboToken, null, null, 13, null);
                }
                catch (Exception e) {
                    KomgaSyncTokenGeneratorKt.access$getLogger$p().warn((Function0)fromBase64.1.INSTANCE);
                }
            }
            if (StringsKt.contains$default((CharSequence)base64Token, (char)'.', (boolean)false, (int)2, null)) {
                return new KomgaSyncToken(0, base64Token, null, null, 13, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new KomgaSyncToken(0, null, null, null, 15, null);
    }

    @NotNull
    public String toBase64(@NotNull KomgaSyncToken token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Base64.Encoder encoder = this.getBase64Encoder();
        String string = this.objectMapper.writeValueAsString((Object)token);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return "KOMGA." + encoder.encodeToString(byArray);
    }

    @Nullable
    public KomgaSyncToken fromRequestHeaders(@NotNull HttpServletRequest request) {
        String syncTokenB64;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string = syncTokenB64 = request.getHeader("x-kobo-synctoken");
        return string != null ? this.fromBase64(string) : null;
    }
}

