/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.mediacontainer.divina;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.greypanther.natsort.CaseInsensitiveSimpleNaturalComparator;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.build.AbstractOriginSupplier;
import org.gotson.komga.domain.model.Dimension;
import org.gotson.komga.domain.model.MediaContainerEntry;
import org.gotson.komga.domain.model.MediaType;
import org.gotson.komga.infrastructure.image.ImageAnalyzer;
import org.gotson.komga.infrastructure.mediacontainer.ContentDetector;
import org.gotson.komga.infrastructure.mediacontainer.divina.DivinaExtractor;
import org.gotson.komga.infrastructure.mediacontainer.divina.ZipExtractorKt;
import org.gotson.komga.infrastructure.util.ZipFileUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\tH\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/gotson/komga/infrastructure/mediacontainer/divina/ZipExtractor;", "Lorg/gotson/komga/infrastructure/mediacontainer/divina/DivinaExtractor;", "contentDetector", "Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;", "imageAnalyzer", "Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;", "(Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;)V", "natSortComparator", "Ljava/util/Comparator;", "", "Lkotlin/Comparator;", "getEntries", "", "Lorg/gotson/komga/domain/model/MediaContainerEntry;", "path", "Ljava/nio/file/Path;", "analyzeDimensions", "", "getEntryStream", "", "entryName", "mediaTypes", "komga"})
@SourceDebugExtension(value={"SMAP\nZipExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipExtractor.kt\norg/gotson/komga/infrastructure/mediacontainer/divina/ZipExtractor\n+ 2 ZipFileUtils.kt\norg/gotson/komga/infrastructure/util/ZipFileUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n8#2:60\n766#3:61\n857#3,2:62\n1549#3:64\n1620#3,3:65\n*S KotlinDebug\n*F\n+ 1 ZipExtractor.kt\norg/gotson/komga/infrastructure/mediacontainer/divina/ZipExtractor\n*L\n31#1:60\n33#1:61\n33#1:62,2\n34#1:64\n34#1:65,3\n*E\n"})
public class ZipExtractor
implements DivinaExtractor {
    @NotNull
    private final ContentDetector contentDetector;
    @NotNull
    private final ImageAnalyzer imageAnalyzer;
    @NotNull
    private final Comparator<String> natSortComparator;

    public ZipExtractor(@NotNull ContentDetector contentDetector, @NotNull ImageAnalyzer imageAnalyzer) {
        Intrinsics.checkNotNullParameter((Object)contentDetector, (String)"contentDetector");
        Intrinsics.checkNotNullParameter((Object)imageAnalyzer, (String)"imageAnalyzer");
        this.contentDetector = contentDetector;
        this.imageAnalyzer = imageAnalyzer;
        Comparator comparator = CaseInsensitiveSimpleNaturalComparator.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"getInstance(...)");
        this.natSortComparator = comparator;
    }

    @NotNull
    public List<String> mediaTypes() {
        return CollectionsKt.listOf((Object)MediaType.ZIP.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public List<MediaContainerEntry> getEntries(@NotNull Path path2, boolean analyzeDimensions) {
        List list;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        AbstractOriginSupplier abstractOriginSupplier = ZipFile.builder().setPath(path2);
        Intrinsics.checkNotNullExpressionValue((Object)abstractOriginSupplier, (String)"setPath(...)");
        ZipFile.Builder $this$use$iv = (ZipFile.Builder)abstractOriginSupplier;
        boolean $i$f$use = false;
        Closeable closeable = (Closeable)$this$use$iv.get();
        Throwable throwable = null;
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            ZipArchiveEntry it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            ZipFile zip = (ZipFile)closeable;
            boolean bl = false;
            Enumeration enumeration = zip.getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"getEntries(...)");
            ArrayList arrayList = Collections.list(enumeration);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
            Object object = arrayList;
            boolean $i$f$filter = false;
            void var11_13 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ZipArchiveEntry)element$iv$iv;
                boolean bl2 = false;
                if (!(!it.isDirectory())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Closeable closeable2;
                void entry;
                it = (ZipArchiveEntry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                try {
                    MediaContainerEntry mediaContainerEntry;
                    InputStream inputStream = zip.getInputStream((ZipArchiveEntry)entry);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                    closeable2 = inputStream;
                    int n = 8192;
                    closeable2 = closeable2 instanceof BufferedInputStream ? (BufferedInputStream)closeable2 : new BufferedInputStream((InputStream)closeable2, n);
                    Throwable throwable2 = null;
                    try {
                        BufferedInputStream stream = (BufferedInputStream)closeable2;
                        boolean bl4 = false;
                        String mediaType2 = this.contentDetector.detectMediaType((InputStream)stream);
                        Dimension dimension = analyzeDimensions && this.contentDetector.isImage(mediaType2) ? this.imageAnalyzer.getDimension((InputStream)stream) : null;
                        Long fileSize = entry.getSize() == -1L ? null : Long.valueOf(entry.getSize());
                        String string = entry.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        mediaContainerEntry = new MediaContainerEntry(string, mediaType2, null, dimension, fileSize, 4, null);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    closeable2 = mediaContainerEntry;
                }
                catch (Exception e) {
                    ZipExtractorKt.access$getLogger$p().warn((Throwable)e, (Function0)new /* Unavailable Anonymous Inner Class!! */);
                    String string = entry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    closeable2 = new MediaContainerEntry(string, null, e.getMessage(), null, null, 26, null);
                }
                collection.add(closeable2);
            }
            object = this.natSortComparator;
            list = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)((Comparator)new /* Unavailable Anonymous Inner Class!! */));
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list;
    }

    @NotNull
    public byte[] getEntryStream(@NotNull Path path2, @NotNull String entryName) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)entryName, (String)"entryName");
        return ZipFileUtilsKt.getZipEntryBytes((Path)path2, (String)entryName);
    }
}

