/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.mediacontainer.epub;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.build.AbstractOriginSupplier;
import org.gotson.komga.domain.model.BookPage;
import org.gotson.komga.domain.model.EpubTocEntry;
import org.gotson.komga.domain.model.MediaFile;
import org.gotson.komga.domain.model.R2Locator;
import org.gotson.komga.domain.model.TypedBytes;
import org.gotson.komga.infrastructure.image.ImageAnalyzer;
import org.gotson.komga.infrastructure.kobo.KepubConverter;
import org.gotson.komga.infrastructure.mediacontainer.ContentDetector;
import org.gotson.komga.infrastructure.mediacontainer.epub.Epub2Nav;
import org.gotson.komga.infrastructure.mediacontainer.epub.Epub3Nav;
import org.gotson.komga.infrastructure.mediacontainer.epub.EpubExtractor;
import org.gotson.komga.infrastructure.mediacontainer.epub.EpubExtractorKt;
import org.gotson.komga.infrastructure.mediacontainer.epub.EpubKt;
import org.gotson.komga.infrastructure.mediacontainer.epub.EpubManifest;
import org.gotson.komga.infrastructure.mediacontainer.epub.EpubPackage;
import org.gotson.komga.infrastructure.mediacontainer.epub.ManifestItem;
import org.gotson.komga.infrastructure.mediacontainer.epub.NavKt;
import org.gotson.komga.infrastructure.mediacontainer.epub.NcxKt;
import org.gotson.komga.infrastructure.mediacontainer.epub.OpfKt;
import org.gotson.komga.infrastructure.mediacontainer.epub.ResourceContent;
import org.gotson.komga.infrastructure.util.ZipFileUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriUtils;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0012J<\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0012JH\u0010\u0018\u001a \u0012\u0004\u0012\u00020\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001c0\u001b0\u000f0\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u001fH\u0012J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J.\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u0016H\u0012J\u0018\u0010&\u001a\u00020'2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u001aH\u0016J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u000f2\u0006\u0010\f\u001a\u00020\rH\u0012J\u0018\u0010+\u001a\u00020,2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0016H\u0016J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020*0\u000f2\u0006\u0010\f\u001a\u00020\rH\u0012J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f2\u0006\u0010\f\u001a\u00020\rH\u0012J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020*0\u000f2\u0006\u0010\f\u001a\u00020\rH\u0012J\u0010\u00100\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0012J\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000fH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/gotson/komga/infrastructure/mediacontainer/epub/EpubExtractor;", "", "contentDetector", "Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;", "imageAnalyzer", "Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;", "kepubConverter", "Lorg/gotson/komga/infrastructure/kobo/KepubConverter;", "letterCountThreshold", "", "(Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;Lorg/gotson/komga/infrastructure/kobo/KepubConverter;I)V", "computePageCount", "epub", "Lorg/gotson/komga/infrastructure/mediacontainer/epub/EpubPackage;", "computePositions", "", "Lorg/gotson/komga/domain/model/R2Locator;", "path", "Ljava/nio/file/Path;", "resources", "Lorg/gotson/komga/domain/model/MediaFile;", "isFixedLayout", "", "isKepub", "computePositionsFromKoboSpan", "", "", "Lkotlin/Pair;", "", "readingOrder", "resourceSupplier", "Lkotlin/Function1;", "getCover", "Lorg/gotson/komga/domain/model/TypedBytes;", "getDivinaPages", "Lorg/gotson/komga/domain/model/BookPage;", "pageCount", "analyzeDimensions", "getEntryStream", "", "entryName", "getLandmarks", "Lorg/gotson/komga/domain/model/EpubTocEntry;", "getManifest", "Lorg/gotson/komga/infrastructure/mediacontainer/epub/EpubManifest;", "getPageList", "getResources", "getToc", "isEpub", "komga"})
@SourceDebugExtension(value={"SMAP\nEpubExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EpubExtractor.kt\norg/gotson/komga/infrastructure/mediacontainer/epub/EpubExtractor\n+ 2 Epub.kt\norg/gotson/komga/infrastructure/mediacontainer/epub/EpubKt\n+ 3 ZipFileUtils.kt\norg/gotson/komga/infrastructure/util/ZipFileUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,338:1\n21#2:339\n22#2,2:341\n24#2,2:344\n26#2:349\n21#2:350\n22#2,2:352\n24#2,2:355\n26#2:367\n8#3:340\n8#3:351\n1#4:343\n1#4:348\n1#4:354\n1#4:382\n1#4:401\n1#4:417\n1#4:448\n1#4:455\n1#4:471\n1#4:480\n1#4:527\n1#4:531\n288#5,2:346\n3190#5,10:357\n1549#5:368\n1620#5,3:369\n1603#5,9:372\n1855#5:381\n1856#5:383\n1612#5:384\n1549#5:385\n1620#5,3:386\n819#5:389\n847#5,2:390\n1549#5:392\n1620#5,3:393\n1549#5:396\n1620#5,2:397\n288#5,2:399\n1622#5:402\n1549#5:403\n1620#5,3:404\n1603#5,9:407\n1855#5:416\n1856#5:418\n1612#5:419\n1549#5:420\n1620#5,2:421\n1549#5:423\n1620#5,3:424\n1549#5:427\n1620#5,3:428\n1549#5:431\n1620#5,3:432\n1622#5:435\n1603#5,9:436\n1855#5:445\n288#5,2:446\n1856#5:449\n1612#5:450\n766#5:451\n857#5,2:452\n1855#5:454\n1856#5:456\n1549#5:457\n1620#5,3:458\n1603#5,9:461\n1855#5:470\n1856#5:472\n1612#5:473\n766#5:474\n857#5,2:475\n766#5:477\n857#5,2:478\n1549#5:481\n1620#5,3:482\n1360#5:485\n1446#5,2:486\n1549#5:488\n1620#5,2:489\n2333#5,14:491\n1622#5:505\n1448#5,3:506\n1549#5:509\n1620#5,3:510\n1179#5,2:513\n1253#5,2:515\n1603#5,9:517\n1855#5:526\n1856#5:528\n1612#5:529\n1256#5:530\n*S KotlinDebug\n*F\n+ 1 EpubExtractor.kt\norg/gotson/komga/infrastructure/mediacontainer/epub/EpubExtractor\n*L\n57#1:339\n57#1:341,2\n57#1:344,2\n57#1:349\n81#1:350\n81#1:352,2\n81#1:355,2\n81#1:367\n57#1:340\n81#1:351\n57#1:343\n81#1:354\n101#1:382\n139#1:417\n162#1:448\n205#1:471\n302#1:527\n60#1:346,2\n82#1:357,10\n101#1:368\n101#1:369,3\n101#1:372,9\n101#1:381\n101#1:383\n101#1:384\n104#1:385\n104#1:386,3\n113#1:389\n113#1:390,2\n113#1:392\n113#1:393,3\n122#1:396\n122#1:397,2\n123#1:399,2\n122#1:402\n138#1:403\n138#1:404,3\n139#1:407,9\n139#1:416\n139#1:418\n139#1:419\n140#1:420\n140#1:421,2\n148#1:423\n148#1:424,3\n152#1:427\n152#1:428,3\n154#1:431\n154#1:432,3\n140#1:435\n162#1:436,9\n162#1:445\n163#1:446,2\n162#1:449\n162#1:450\n189#1:451\n189#1:452,2\n191#1:454\n191#1:456\n204#1:457\n204#1:458,3\n205#1:461,9\n205#1:470\n205#1:472\n205#1:473\n207#1:474\n207#1:475,2\n221#1:477\n221#1:478,2\n251#1:481\n251#1:482,3\n262#1:485\n262#1:486,2\n264#1:488\n264#1:489,2\n271#1:491,14\n264#1:505\n262#1:506,3\n285#1:509\n285#1:510,3\n299#1:513,2\n299#1:515,2\n302#1:517,9\n302#1:526\n302#1:528\n302#1:529\n299#1:530\n*E\n"})
public class EpubExtractor {
    @NotNull
    private final ContentDetector contentDetector;
    @NotNull
    private final ImageAnalyzer imageAnalyzer;
    @NotNull
    private final KepubConverter kepubConverter;
    private final int letterCountThreshold;

    public EpubExtractor(@NotNull ContentDetector contentDetector, @NotNull ImageAnalyzer imageAnalyzer, @NotNull KepubConverter kepubConverter, @Value(value="#{@komgaProperties.epubDivinaLetterCountThreshold}") int letterCountThreshold) {
        Intrinsics.checkNotNullParameter((Object)contentDetector, (String)"contentDetector");
        Intrinsics.checkNotNullParameter((Object)imageAnalyzer, (String)"imageAnalyzer");
        Intrinsics.checkNotNullParameter((Object)kepubConverter, (String)"kepubConverter");
        this.contentDetector = contentDetector;
        this.imageAnalyzer = imageAnalyzer;
        this.kepubConverter = kepubConverter;
        this.letterCountThreshold = letterCountThreshold;
    }

    @NotNull
    public byte[] getEntryStream(@NotNull Path path2, @NotNull String entryName) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)entryName, (String)"entryName");
        return ZipFileUtilsKt.getZipEntryBytes((Path)path2, (String)entryName);
    }

    public boolean isEpub(@NotNull Path path2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        try {
            bl = Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)StringsKt.decodeToString((byte[])this.getEntryStream(path2, "mimetype")))).toString(), (Object)"application/epub+zip");
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public TypedBytes getCover(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        $this$epub$iv = path;
        $i$f$epub = false;
        v0 = ZipFile.builder().setPath($this$epub$iv);
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"setPath(...)");
        $this$use$iv$iv = (ZipFile.Builder)v0;
        $i$f$use = false;
        var6_6 = (Closeable)$this$use$iv$iv.get();
        var7_7 = null;
        try {
            block20: {
                block18: {
                    zip$iv = (ZipFile)var6_6;
                    $i$a$-use-EpubKt$epub$1$iv = false;
                    opfFile$iv = EpubKt.getPackagePath((ZipFile)zip$iv);
                    var11_13 = ZipFileUtilsKt.getEntryInputStream((ZipFile)zip$iv, (String)opfFile$iv);
                    var12_14 = null;
                    try {
                        it$iv = (InputStream)var11_13;
                        $i$a$-use-EpubKt$epub$1$opfDoc$1$iv = false;
                        var13_15 = Jsoup.parse((InputStream)it$iv, null, (String)"", (Parser)Parser.xmlParser());
                    }
                    catch (Throwable var13_16) {
                        var12_14 = var13_16;
                        throw var13_16;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)var11_13, (Throwable)var12_14);
                    }
                    opfDoc$iv = var13_15;
                    opfDir$iv = Paths.get(opfFile$iv, new String[0]).getParent();
                    Intrinsics.checkNotNull((Object)opfDoc$iv);
                    var16_20 = new EpubPackage(zip$iv, opfDoc$iv, opfDir$iv, OpfKt.getManifest((Document)opfDoc$iv));
                    $i$a$-epub-EpubExtractor$getCover$1 = false;
                    zip = var16_20.component1();
                    opfDoc = var16_20.component2();
                    opfDir = var16_20.component3();
                    manifest = var16_20.component4();
                    $this$firstOrNull$iv = manifest.values();
                    $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        it = (ManifestItem)element$iv;
                        $i$a$-firstOrNull-EpubExtractor$getCover$1$coverManifestItem$1 = false;
                        if (!it.getProperties().contains("cover-image")) continue;
                        v1 = element$iv;
                        break block18;
                    }
                    v1 = null;
                }
                if ((v2 = (ManifestItem)v1) != null) break block20;
                v3 /* !! */  = opfDoc.selectFirst("metadata > meta[name=cover]");
                if (v3 /* !! */  == null || (v3 /* !! */  = ($i$f$firstOrNull = v3 /* !! */ .attr("content"))) == null) ** GOTO lbl-1000
                Intrinsics.checkNotNull((Object)v3 /* !! */ );
                var25_31 = $i$f$firstOrNull;
                if (StringsKt.isBlank((CharSequence)var25_31)) {
                    $i$a$-ifBlank-EpubExtractor$getCover$1$coverManifestItem$2 = false;
                    v4 = null;
                } else {
                    v4 = var25_31;
                }
                if ((v3 /* !! */  = (String)v4) != null) {
                    it = v3 /* !! */ ;
                    $i$a$-let-EpubExtractor$getCover$1$coverManifestItem$3 = false;
                    v2 = (ManifestItem)manifest.get(it);
                } else lbl-1000:
                // 2 sources

                {
                    v2 = null;
                }
            }
            if ((coverManifestItem = v2) != null) {
                href = coverManifestItem.getHref();
                mediaType = coverManifestItem.getMediaType();
                coverPath = OpfKt.normalizeHref((Path)opfDir, (String)href);
                v5 = new TypedBytes(ZipFileUtilsKt.getEntryBytes((ZipFile)zip, (String)coverPath), mediaType);
            } else {
                v5 = null;
            }
            var8_8 = v5;
        }
        catch (Throwable var8_9) {
            var7_7 = var8_9;
            throw var8_9;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var6_6, (Throwable)var7_7);
        }
        return var8_8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public EpubManifest getManifest(@NotNull Path path2, boolean analyzeDimensions) {
        EpubManifest epubManifest;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Path $this$epub$iv = path2;
        boolean $i$f$epub = false;
        AbstractOriginSupplier abstractOriginSupplier = ZipFile.builder().setPath($this$epub$iv);
        Intrinsics.checkNotNullExpressionValue((Object)abstractOriginSupplier, (String)"setPath(...)");
        ZipFile.Builder $this$use$iv$iv = (ZipFile.Builder)abstractOriginSupplier;
        boolean $i$f$use = false;
        Closeable closeable = (Closeable)$this$use$iv$iv.get();
        Throwable throwable = null;
        try {
            Document document;
            ZipFile zip$iv = (ZipFile)closeable;
            boolean bl = false;
            String opfFile$iv = EpubKt.getPackagePath((ZipFile)zip$iv);
            Closeable closeable2 = ZipFileUtilsKt.getEntryInputStream((ZipFile)zip$iv, (String)opfFile$iv);
            Throwable throwable2 = null;
            try {
                InputStream it$iv = (InputStream)closeable2;
                boolean bl2 = false;
                document = Jsoup.parse((InputStream)it$iv, null, (String)"", (Parser)Parser.xmlParser());
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Document opfDoc$iv = document;
            Path opfDir$iv = Paths.get(opfFile$iv, new String[0]).getParent();
            Intrinsics.checkNotNull((Object)opfDoc$iv);
            EpubPackage epub = new EpubPackage(zip$iv, opfDoc$iv, opfDir$iv, OpfKt.getManifest((Document)opfDoc$iv));
            boolean bl3 = false;
            Iterable $this$partition$iv = this.getResources(epub);
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                MediaFile it = (MediaFile)element$iv;
                boolean bl4 = false;
                if (it.getFileSize() != null) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List resources2 = (List)pair.component1();
            List missingResources = (List)pair.component2();
            boolean isFixedLayout = this.isFixedLayout(epub);
            int pageCount = this.computePageCount(epub);
            boolean isKepub2 = this.isKepub(epub, resources2);
            epubManifest = new EpubManifest(resources2, missingResources, this.getToc(epub), this.getLandmarks(epub), this.getPageList(epub), pageCount, isFixedLayout, this.computePositions(epub, path2, resources2, isFixedLayout, isKepub2), this.getDivinaPages(epub, isFixedLayout, pageCount, analyzeDimensions), isKepub2);
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return epubManifest;
    }

    /*
     * WARNING - void declaration
     */
    private List<MediaFile> getResources(EpubPackage epub) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        void $this$filterNotTo$iv$iv;
        void $this$mapTo$iv$iv3;
        void $this$mapNotNullTo$iv$iv;
        Iterator it;
        Collection collection;
        Iterable $this$mapTo$iv$iv4;
        Elements elements = epub.getOpfDoc().select("spine > itemref");
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
        Iterable $this$map$iv2 = (Iterable)elements;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Iterable<ManifestItem> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv4) {
            Element element = (Element)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.attr("idref"));
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv4 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            ManifestItem it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            String it2 = (String)element$iv$iv;
            boolean bl2 = false;
            if ((ManifestItem)epub.getManifest().get(it2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List spine = (List)destination$iv$iv;
        Iterable $this$map$iv3 = spine;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv3;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void page;
            ManifestItem element$iv$iv$iv = (ManifestItem)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            Path path2 = epub.getOpfDir();
            String string = UriUtils.decode((String)page.getHref(), (Charset)Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(...)");
            collection.add(new MediaFile(OpfKt.normalizeHref((Path)path2, (String)string), page.getMediaType(), MediaFile.SubType.EPUB_PAGE, null, 8, null));
        }
        List pages = (List)destination$iv$iv2;
        Iterable $this$filterNot$iv = epub.getManifest().values();
        boolean $i$f$filterNot = false;
        destination$iv$iv2 = $this$filterNot$iv;
        Iterable destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            ManifestItem it3 = (ManifestItem)element$iv$iv;
            boolean bl = false;
            if (spine.contains(it3)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv3;
        boolean $i$f$map3 = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            ManifestItem it3 = (ManifestItem)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            Path path3 = epub.getOpfDir();
            String string = UriUtils.decode((String)it3.getHref(), (Charset)Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(...)");
            collection.add(new MediaFile(OpfKt.normalizeHref((Path)path3, (String)string), it3.getMediaType(), MediaFile.SubType.EPUB_ASSET, null, 8, null));
        }
        List assets = (List)destination$iv$iv3;
        Enumeration enumeration = epub.getZip().getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"getEntries(...)");
        ArrayList arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        List zipEntries = arrayList;
        Iterable $this$map$iv4 = CollectionsKt.plus((Collection)pages, (Iterable)assets);
        boolean $i$f$map4 = false;
        destination$iv$iv3 = $this$map$iv4;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Long l;
            Long l2;
            void var19_47;
            String string;
            String string2;
            MediaFile.SubType subType;
            block9: {
                void $this$firstOrNull$iv;
                void resource;
                MediaFile bl = (MediaFile)item$iv$iv;
                collection = destination$iv$iv4;
                boolean bl4 = false;
                Iterable bl2 = zipEntries;
                subType = null;
                string2 = null;
                string = null;
                var19_47 = resource;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ZipArchiveEntry it4 = (ZipArchiveEntry)element$iv;
                    boolean bl5 = false;
                    if (!Intrinsics.areEqual((Object)it4.getName(), (Object)resource.getFileName())) continue;
                    l2 = (Long)element$iv;
                    break block9;
                }
                l2 = null;
            }
            Long l3 = l2;
            void v8 = var19_47;
            String string3 = string;
            String string4 = string2;
            MediaFile.SubType subType2 = subType;
            if ((ZipArchiveEntry)l3 != null) {
                void it5;
                subType = subType2;
                string2 = string4;
                string = string3;
                var19_47 = v8;
                boolean bl = false;
                l3 = it5.getSize() == -1L ? null : Long.valueOf(it5.getSize());
                v8 = var19_47;
                string3 = string;
                string4 = string2;
                subType2 = subType;
                l = l3;
            } else {
                l = null;
            }
            collection.add(MediaFile.copy$default((MediaFile)v8, string3, string4, subType2, l, (int)7, null));
        }
        return (List)destination$iv$iv4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private List<BookPage> getDivinaPages(EpubPackage epub, boolean isFixedLayout, int pageCount, boolean analyzeDimensions) {
        if (!isFixedLayout) {
            return CollectionsKt.emptyList();
        }
        try {
            void $this$mapNotNullTo$iv$iv;
            InputStream it;
            Element element;
            Object element$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv2;
            Iterable $this$mapNotNull$iv;
            Object it2;
            Collection collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Elements elements = epub.getOpfDoc().select("spine > itemref");
            Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
            Iterable iterable = (Iterable)elements;
            boolean $i$f$map = false;
            void var8_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Element element2 = (Element)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it2.attr("idref"));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$mapTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            it2 = $this$forEach$iv$iv$iv.iterator();
            while (it2.hasNext()) {
                String string;
                Object element$iv$iv$iv;
                element$iv$iv = element$iv$iv$iv = it2.next();
                boolean bl5 = false;
                String idref = (String)element$iv$iv;
                boolean bl2 = false;
                Object object = (ManifestItem)epub.getManifest().get(idref);
                if (object != null && (object = object.getHref()) != null) {
                    Object it3 = object;
                    boolean bl3 = false;
                    string = OpfKt.normalizeHref((Path)epub.getOpfDir(), (String)it3);
                } else {
                    string = null;
                }
                if (string == null) continue;
                String it$iv$iv = string;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapNotNullTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Iterable $this$mapTo$iv$iv2;
                Iterable $this$map$iv2;
                Collection collection2;
                void $this$mapTo$iv$iv3;
                void $this$map$iv3;
                void pagePath;
                it2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                element$iv$iv = ZipFileUtilsKt.getEntryInputStream((ZipFile)epub.getZip(), (String)pagePath);
                Object bl5 = null;
                try {
                    InputStream it4 = (InputStream)element$iv$iv;
                    boolean bl6 = false;
                    it4 = Jsoup.parse((InputStream)it4, null, (String)"");
                }
                catch (Throwable it4) {
                    bl5 = it4;
                    throw it4;
                }
                finally {
                    CloseableKt.closeFinally(element$iv$iv, (Throwable)bl5);
                }
                InputStream doc = it4;
                if (doc.body().text().length() > this.letterCountThreshold) {
                    return CollectionsKt.emptyList();
                }
                Elements elements2 = doc.getElementsByTag("img");
                Intrinsics.checkNotNullExpressionValue((Object)elements2, (String)"getElementsByTag(...)");
                bl5 = (Iterable)elements2;
                boolean $i$f$map22 = false;
                void bl6 = $this$map$iv3;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                    element = (Element)item$iv$iv2;
                    collection2 = destination$iv$iv2;
                    boolean bl7 = false;
                    collection2.add(it.attr("src"));
                }
                List img = (List)destination$iv$iv2;
                Elements elements3 = doc.select("svg > image[xlink:href]");
                Intrinsics.checkNotNullExpressionValue((Object)elements3, (String)"select(...)");
                Iterable $i$f$map22 = (Iterable)elements3;
                boolean $i$f$map3 = false;
                destination$iv$iv2 = $this$map$iv2;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
                    void it5;
                    Element bl7 = (Element)item$iv$iv3;
                    collection2 = destination$iv$iv3;
                    boolean bl8 = false;
                    collection2.add(it5.attr("xlink:href"));
                }
                List svg = (List)destination$iv$iv3;
                $this$map$iv2 = CollectionsKt.plus((Collection)img, (Iterable)svg);
                $i$f$map3 = false;
                $this$mapTo$iv$iv2 = $this$map$iv2;
                destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                $i$f$mapTo3 = false;
                for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
                    String it5 = (String)item$iv$iv3;
                    collection2 = destination$iv$iv3;
                    boolean bl9 = false;
                    Path path2 = Paths.get((String)pagePath, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                    Path path3 = path2.getParent();
                    if (path3 == null) {
                        Path path4 = Paths.get("", new String[0]);
                        path3 = path4;
                        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(...)");
                    }
                    Path path5 = path3.resolve(it5).normalize();
                    Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"normalize(...)");
                    collection2.add(PathsKt.getInvariantSeparatorsPathString((Path)path5));
                }
                collection.add((List)destination$iv$iv3);
            }
            List pagesWithImages = (List)destination$iv$iv;
            if (pagesWithImages.size() != pageCount) {
                return CollectionsKt.emptyList();
            }
            List imagesPath = CollectionsKt.flatten((Iterable)pagesWithImages);
            if (imagesPath.size() != pageCount) {
                return CollectionsKt.emptyList();
            }
            Iterable $this$mapNotNull$iv2 = imagesPath;
            boolean $i$f$mapNotNull2 = false;
            Iterable $i$f$mapTo2 = $this$mapNotNull$iv2;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv$iv$iv2.iterator();
            while (iterator.hasNext()) {
                BookPage bookPage;
                Object object;
                Object v9;
                String imagePath;
                block35: {
                    Object element$iv$iv$iv;
                    Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    imagePath = (String)element$iv$iv2;
                    boolean bl10 = false;
                    Iterable $this$firstOrNull$iv = epub.getManifest().values();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        ManifestItem it6 = (ManifestItem)element$iv;
                        boolean bl11 = false;
                        if (!Intrinsics.areEqual((Object)OpfKt.normalizeHref((Path)epub.getOpfDir(), (String)it6.getHref()), (Object)imagePath)) continue;
                        v9 = element$iv;
                        break block35;
                    }
                    v9 = null;
                }
                if ((object = (ManifestItem)v9) == null || (object = object.getMediaType()) == null) {
                    bookPage = null;
                } else {
                    Object mediaType2 = object;
                    ZipArchiveEntry zipEntry = epub.getZip().getEntry(imagePath);
                    if (!this.contentDetector.isImage((String)mediaType2)) {
                        bookPage = null;
                    } else {
                        Element element3;
                        if (analyzeDimensions) {
                            Closeable $i$f$firstOrNull = epub.getZip().getInputStream(zipEntry);
                            Iterator iterator2 = null;
                            try {
                                it = (InputStream)$i$f$firstOrNull;
                                boolean bl = false;
                                Intrinsics.checkNotNull((Object)it);
                                element = this.imageAnalyzer.getDimension(it);
                                element3 = element;
                            }
                            catch (Throwable throwable) {
                                iterator2 = throwable;
                                throw throwable;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)$i$f$firstOrNull, iterator2);
                            }
                        } else {
                            element3 = null;
                        }
                        Element dimension = element3;
                        Long fileSize = zipEntry.getSize() == -1L ? null : Long.valueOf(zipEntry.getSize());
                        bookPage = new BookPage(imagePath, (String)mediaType2, dimension, null, fileSize, 8, null);
                    }
                }
                if (bookPage == null) continue;
                BookPage it$iv$iv = bookPage;
                boolean bl = false;
                destination$iv$iv4.add(it$iv$iv);
            }
            List divinaPages = (List)destination$iv$iv4;
            if (divinaPages.size() != pageCount) {
                return CollectionsKt.emptyList();
            }
            return divinaPages;
        }
        catch (Exception e) {
            EpubExtractorKt.access$getLogger$p().warn((Throwable)e, (Function0)getDivinaPages.1.INSTANCE);
            return CollectionsKt.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private boolean isKepub(EpubPackage epub, List<MediaFile> resources2) {
        try {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = resources2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MediaFile it = (MediaFile)element$iv$iv;
                boolean bl = false;
                if (!(it.getSubType() == MediaFile.SubType.EPUB_PAGE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List readingOrder = (List)destination$iv$iv;
            Iterable $this$forEach$iv = readingOrder;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Document document;
                MediaFile mediaFile = (MediaFile)element$iv;
                boolean bl = false;
                Object object = ZipFileUtilsKt.getEntryInputStream((ZipFile)epub.getZip(), (String)mediaFile.getFileName());
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)object;
                    boolean bl2 = false;
                    document = Jsoup.parse((InputStream)it, null, (String)"");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                Document doc = document;
                object = (Collection)doc.getElementsByClass("koboSpan");
                if (object == null || object.isEmpty()) continue;
                return true;
            }
        }
        catch (Exception e) {
            EpubExtractorKt.access$getLogger$p().warn((Throwable)e, (Function0)isKepub.2.INSTANCE);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private int computePageCount(EpubPackage epub) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        ZipArchiveEntry it;
        Iterable $this$mapTo$iv$iv;
        Elements elements = epub.getOpfDoc().select("spine > itemref");
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
        Iterable $this$map$iv = (Iterable)elements;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Element element = (Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.attr("idref"));
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            String idref = (String)element$iv$iv;
            boolean bl2 = false;
            Object object = (ManifestItem)epub.getManifest().get(idref);
            if (object != null && (object = object.getHref()) != null) {
                Object it2 = object;
                boolean bl3 = false;
                string = OpfKt.normalizeHref((Path)epub.getOpfDir(), (String)it2);
            } else {
                string = null;
            }
            if (string == null) continue;
            String it$iv$iv = string;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List spine = (List)destination$iv$iv;
        Enumeration enumeration = epub.getZip().getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"getEntries(...)");
        ArrayList arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        Iterable $this$filter$iv = arrayList;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ZipArchiveEntry)element$iv$iv;
            boolean bl = false;
            if (!spine.contains(it.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        int n = 0;
        for (Object e : iterable2) {
            void it3;
            ZipArchiveEntry $i$f$filterTo2 = (ZipArchiveEntry)e;
            int n2 = n;
            boolean bl = false;
            int n3 = (int)Math.ceil((double)it3.getCompressedSize() / 1024.0);
            n = n2 + n3;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isFixedLayout(EpubPackage epub) {
        Element element = epub.getOpfDoc().selectFirst("metadata > *|meta[property=rendition:layout]");
        if (Intrinsics.areEqual((Object)(element != null ? element.text() : null), (Object)"pre-paginated")) return true;
        Element element2 = epub.getOpfDoc().selectFirst("metadata > *|meta[name=fixed-layout]");
        if (!Intrinsics.areEqual((Object)(element2 != null ? element2.attr("content") : null), (Object)"true")) return false;
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private List<R2Locator> computePositions(EpubPackage epub, Path path, List<MediaFile> resources, boolean isFixedLayout, boolean isKepub) {
        block26: {
            block25: {
                $this$filter$iv = resources;
                $i$f$filter = false;
                var9_10 = $this$filter$iv;
                destination$iv$iv /* !! */  = new ArrayList<E>();
                $i$f$filterTo = false;
                var12_14 = $this$filterTo$iv$iv.iterator();
                while (var12_14.hasNext()) {
                    element$iv$iv = var12_14.next();
                    it = (MediaFile)element$iv$iv;
                    $i$a$-filter-EpubExtractor$computePositions$readingOrder$1 = false;
                    if (!(it.getSubType() == MediaFile.SubType.EPUB_PAGE)) continue;
                    destination$iv$iv /* !! */ .add(element$iv$iv);
                }
                readingOrder = (List)destination$iv$iv /* !! */ ;
                startPosition = 0;
                startPosition = 1;
                if (isFixedLayout) {
                    v0 = MapsKt.emptyMap();
                } else if (isKepub) {
                    v0 = this.computePositionsFromKoboSpan(readingOrder, (Function1)new /* Unavailable Anonymous Inner Class!! */);
                } else if (this.kepubConverter.isAvailable()) {
                    try {
                        destination$iv$iv /* !! */  = KepubConverter.convertEpubToKepubWithoutChecks$default((KepubConverter)this.kepubConverter, (Path)path, null, (int)2, null);
                        if (destination$iv$iv /* !! */  == null) {
                            throw new IllegalStateException();
                        }
                        it = var12_14 = destination$iv$iv /* !! */ ;
                        $i$a$-also-EpubExtractor$computePositions$koboPositions$kepub$1 = false;
                        it.toFile().deleteOnExit();
                        kepub = var12_14;
                        positions = this.computePositionsFromKoboSpan(readingOrder, (Function1)new /* Unavailable Anonymous Inner Class!! */);
                        Files.deleteIfExists((Path)kepub);
                        kepub = positions;
                    }
                    catch (Exception e) {
                        EpubExtractorKt.access$getLogger$p().warn((Function0)new /* Unavailable Anonymous Inner Class!! */);
                        kepub = MapsKt.emptyMap();
                    }
                    v0 = kepub;
                } else {
                    v0 = koboPositions = MapsKt.emptyMap();
                }
                if (!isFixedLayout) break block25;
                $this$map$iv = readingOrder;
                $i$f$map = false;
                var12_14 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var17_24 = (MediaFile)item$iv$iv;
                    var42_22 = destination$iv$iv;
                    $i$a$-map-EpubExtractor$computePositions$positions$1 = false;
                    var19_26 = it.getFileName();
                    v1 = it.getMediaType();
                    if (v1 == null) {
                        v1 = "application/octet-stream";
                    }
                    var20_29 = v1;
                    var21_32 = startPosition;
                    startPosition = var21_32 + 1;
                    var22_34 = new R2Locator.Location(null, Float.valueOf(0.0f), Integer.valueOf(var21_32), null, 9, null);
                    var42_22.add(new R2Locator(var19_26, var20_29, null, (R2Locator.Location)var22_34, null, "kobo.1.1", 20, null));
                }
                v2 = (List)destination$iv$iv;
                break block26;
            }
            $this$flatMap$iv = readingOrder;
            $i$f$flatMap = false;
            $this$mapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$flatMapTo = false;
            for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                file = (MediaFile)element$iv$iv;
                $i$a$-flatMap-EpubExtractor$computePositions$positions$2 = false;
                var19_27 = 1;
                v3 = file.getFileSize();
                var20_30 = MathKt.roundToInt((double)Math.ceil((double)(v3 != null ? v3 : 0L) / 1024.0));
                positionCount = Math.max(var19_27, var20_30);
                $this$map$iv = (Iterable)RangesKt.until((int)0, (int)positionCount);
                $i$f$map = false;
                var22_34 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                var25_37 = $this$mapTo$iv$iv.iterator();
                while (var25_37.hasNext()) {
                    block28: {
                        block27: {
                            var27_39 = item$iv$iv = ((IntIterator)var25_37).nextInt();
                            var28_40 = destination$iv$iv;
                            $i$a$-map-EpubExtractor$computePositions$positions$2$1 = false;
                            progression = (float)p / (float)positionCount;
                            if (positionCount != 1 && p != false) break block27;
                            v4 = "kobo.1.1";
                            break block28;
                        }
                        var31_44 = (List)koboPositions.get(file.getFileName());
                        if (var31_44 == null) ** GOTO lbl-1000
                        var32_45 = var31_44;
                        $i$f$minByOrNull = false;
                        iterator$iv = $this$minByOrNull$iv.iterator();
                        if (!iterator$iv.hasNext()) {
                            v5 = null;
                        } else {
                            minElem$iv = iterator$iv.next();
                            if (!iterator$iv.hasNext()) {
                                v5 = minElem$iv;
                            } else {
                                it = (Pair)minElem$iv;
                                $i$a$-minByOrNull-EpubExtractor$computePositions$positions$2$1$koboSpan$1 = false;
                                minValue$iv = Math.abs(progression - ((Number)it.getSecond()).floatValue());
                                do {
                                    e$iv = iterator$iv.next();
                                    it = (Pair)e$iv;
                                    $i$a$-minByOrNull-EpubExtractor$computePositions$positions$2$1$koboSpan$1 = false;
                                    v$iv = Math.abs(progression - ((Number)it.getSecond()).floatValue());
                                    if (Float.compare(minValue$iv, v$iv) <= 0) continue;
                                    minElem$iv = e$iv;
                                    minValue$iv = v$iv;
                                } while (iterator$iv.hasNext());
                                v5 = minElem$iv;
                            }
                        }
                        var40_56 = v5;
                        if (var40_56 != null) {
                            v4 = (String)var40_56.getFirst();
                        } else lbl-1000:
                        // 2 sources

                        {
                            v4 = null;
                        }
                    }
                    koboSpan = v4;
                    v6 = file.getFileName();
                    v7 = file.getMediaType();
                    if (v7 == null) {
                        v7 = "application/octet-stream";
                    }
                    var31_43 = startPosition;
                    startPosition = var31_43 + 1;
                    var28_40.add(new R2Locator(v6, v7, null, new R2Locator.Location(null, Float.valueOf(progression), Integer.valueOf(var31_43), null, 9, null), null, koboSpan, 20, null));
                }
                list$iv$iv /* !! */  = (List)destination$iv$iv;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv /* !! */ );
            }
            v2 = (List)destination$iv$iv;
        }
        positions = v2;
        $this$map$iv = positions;
        $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv /* !! */  = (R2Locator)item$iv$iv;
            var42_22 = destination$iv$iv;
            $i$a$-map-EpubExtractor$computePositions$1 = false;
            v8 /* !! */  = locator.getLocations();
            if (v8 /* !! */  != null && (v8 /* !! */  = v8 /* !! */ .getPosition()) != null) {
                it = ((Number)v8 /* !! */ ).intValue();
                $i$a$-let-EpubExtractor$computePositions$1$totalProgression$1 = false;
                v9 = Float.valueOf((float)it / (float)positions.size());
            } else {
                v9 = null;
            }
            totalProgression = v9;
            v10 = locator.getLocations();
            var42_22.add(R2Locator.copy$default((R2Locator)locator, null, null, null, (R2Locator.Location)(v10 != null ? R2Locator.Location.copy$default((R2Locator.Location)v10, null, null, null, (Float)totalProgression, (int)7, null) : null), null, null, (int)55, null));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, List<Pair<String, Float>>> computePositionsFromKoboSpan(List<MediaFile> readingOrder, Function1<? super String, String> resourceSupplier) {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = readingOrder;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Map map = destination$iv$iv;
            MediaFile file = (MediaFile)element$iv$iv;
            boolean bl = false;
            Document doc = Jsoup.parse((String)((String)resourceSupplier.invoke((Object)file.getFileName())), (Parser)Parser.htmlParser().setTrackPosition(true));
            String string = file.getFileName();
            Elements elements = doc.select("span.koboSpan");
            Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
            Iterable iterable2 = (Iterable)elements;
            String string2 = string;
            boolean $i$f$mapNotNull = false;
            void var18_18 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Pair pair;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                Element koboSpan = (Element)element$iv$iv2;
                boolean bl3 = false;
                String id = koboSpan.id();
                CharSequence charSequence = id;
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                    float f = koboSpan.sourceRange().endPos();
                    Long l = file.getFileSize();
                    Intrinsics.checkNotNull((Object)l);
                    float progression = f / (float)l.longValue();
                    Intrinsics.checkNotNull((Object)id);
                    pair = new Pair((Object)id, (Object)Float.valueOf(progression));
                } else {
                    pair = null;
                }
                if (pair == null) continue;
                Pair it$iv$iv = pair;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Pair pair = TuplesKt.to((Object)string2, (Object)((List)destination$iv$iv2));
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    private List<EpubTocEntry> getToc(EpubPackage epub) {
        ResourceContent resourceContent = NavKt.getNavResource((EpubPackage)epub);
        if (resourceContent != null) {
            ResourceContent it = resourceContent;
            boolean bl = false;
            return NavKt.processNav((ResourceContent)it, (Epub3Nav)Epub3Nav.TOC);
        }
        ResourceContent resourceContent2 = NcxKt.getNcxResource((EpubPackage)epub);
        if (resourceContent2 != null) {
            ResourceContent it = resourceContent2;
            boolean bl = false;
            return NcxKt.processNcx((ResourceContent)it, (Epub2Nav)Epub2Nav.TOC);
        }
        return CollectionsKt.emptyList();
    }

    private List<EpubTocEntry> getPageList(EpubPackage epub) {
        ResourceContent resourceContent = NavKt.getNavResource((EpubPackage)epub);
        if (resourceContent != null) {
            ResourceContent it = resourceContent;
            boolean bl = false;
            return NavKt.processNav((ResourceContent)it, (Epub3Nav)Epub3Nav.PAGELIST);
        }
        ResourceContent resourceContent2 = NcxKt.getNcxResource((EpubPackage)epub);
        if (resourceContent2 != null) {
            ResourceContent it = resourceContent2;
            boolean bl = false;
            return NcxKt.processNcx((ResourceContent)it, (Epub2Nav)Epub2Nav.PAGELIST);
        }
        return CollectionsKt.emptyList();
    }

    private List<EpubTocEntry> getLandmarks(EpubPackage epub) {
        ResourceContent resourceContent = NavKt.getNavResource((EpubPackage)epub);
        if (resourceContent != null) {
            ResourceContent it = resourceContent;
            boolean bl = false;
            return NavKt.processNav((ResourceContent)it, (Epub3Nav)Epub3Nav.LANDMARKS);
        }
        return OpfKt.processOpfGuide((Document)epub.getOpfDoc(), (Path)epub.getOpfDir());
    }
}

