/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.mediacontainer.pdf;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.multipdf.PageExtractor;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.gotson.komga.domain.model.Dimension;
import org.gotson.komga.domain.model.MediaContainerEntry;
import org.gotson.komga.domain.model.MediaType;
import org.gotson.komga.domain.model.TypedBytes;
import org.gotson.komga.infrastructure.image.ImageType;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0012J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\f\u0010\u0013\u001a\u00020\u0005*\u00020\u0019H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/gotson/komga/infrastructure/mediacontainer/pdf/PdfExtractor;", "", "imageType", "Lorg/gotson/komga/infrastructure/image/ImageType;", "resolution", "", "(Lorg/gotson/komga/infrastructure/image/ImageType;F)V", "getPageContentAsImage", "Lorg/gotson/komga/domain/model/TypedBytes;", "path", "Ljava/nio/file/Path;", "pageNumber", "", "getPageContentAsPdf", "getPages", "", "Lorg/gotson/komga/domain/model/MediaContainerEntry;", "analyzeDimensions", "", "getScale", "width", "height", "scaleDimension", "Lorg/gotson/komga/domain/model/Dimension;", "dimension", "Lorg/apache/pdfbox/pdmodel/PDPage;", "komga"})
@SourceDebugExtension(value={"SMAP\nPdfExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PdfExtractor.kt\norg/gotson/komga/infrastructure/mediacontainer/pdf/PdfExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n1549#2:85\n1620#2,3:86\n*S KotlinDebug\n*F\n+ 1 PdfExtractor.kt\norg/gotson/komga/infrastructure/mediacontainer/pdf/PdfExtractor\n*L\n35#1:85\n35#1:86,3\n*E\n"})
public class PdfExtractor {
    @NotNull
    private final ImageType imageType;
    private final float resolution;

    public PdfExtractor(@Qualifier(value="pdfImageType") @NotNull ImageType imageType, @Qualifier(value="pdfResolution") float resolution) {
        Intrinsics.checkNotNullParameter((Object)imageType, (String)"imageType");
        this.imageType = imageType;
        this.resolution = resolution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public List<MediaContainerEntry> getPages(@NotNull Path path2, boolean analyzeDimensions) {
        List list;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Closeable closeable = (Closeable)Loader.loadPDF((File)path2.toFile());
        Throwable throwable = null;
        try {
            void $this$mapTo$iv$iv;
            PDDocument pdf = (PDDocument)closeable;
            boolean bl = false;
            Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)pdf.getNumberOfPages());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void index;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                PDPage page = pdf.getPage((int)index);
                Dimension dimension = analyzeDimensions ? new Dimension(MathKt.roundToInt((float)page.getCropBox().getWidth()), MathKt.roundToInt((float)page.getCropBox().getHeight())) : null;
                collection.add(new MediaContainerEntry(String.valueOf((int)(index + true)), null, null, dimension, null, 22, null));
            }
            list = (List)destination$iv$iv;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TypedBytes getPageContentAsImage(@NotNull Path path2, int pageNumber) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Closeable closeable = (Closeable)Loader.loadPDF((File)path2.toFile());
        Throwable throwable = null;
        try {
            byte[] byArray;
            PDDocument pdf = (PDDocument)closeable;
            boolean bl = false;
            PDPage page = pdf.getPage(pageNumber - 1);
            PDFRenderer pDFRenderer = new PDFRenderer(pdf);
            Intrinsics.checkNotNull((Object)page);
            BufferedImage image = pDFRenderer.renderImage(pageNumber - 1, this.getScale(page), org.apache.pdfbox.rendering.ImageType.RGB);
            Closeable closeable2 = new ByteArrayOutputStream();
            Throwable throwable2 = null;
            try {
                ByteArrayOutputStream out = (ByteArrayOutputStream)closeable2;
                boolean bl2 = false;
                ImageIO.write((RenderedImage)image, this.imageType.getImageIOFormat(), out);
                byArray = out.toByteArray();
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            byte[] bytes = byArray;
            Intrinsics.checkNotNull((Object)bytes);
            TypedBytes typedBytes = new TypedBytes(bytes, this.imageType.getMediaType());
            return typedBytes;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TypedBytes getPageContentAsPdf(@NotNull Path path2, int pageNumber) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Closeable closeable = (Closeable)Loader.loadPDF((File)path2.toFile());
        Throwable throwable = null;
        try {
            byte[] byArray;
            PDDocument pdf = (PDDocument)closeable;
            boolean bl = false;
            Closeable closeable2 = new ByteArrayOutputStream();
            Throwable throwable2 = null;
            try {
                ByteArrayOutputStream out = (ByteArrayOutputStream)closeable2;
                boolean bl2 = false;
                new PageExtractor(pdf, pageNumber, pageNumber).extract().save((OutputStream)out);
                byArray = out.toByteArray();
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            byte[] bytes = byArray;
            Intrinsics.checkNotNull((Object)bytes);
            TypedBytes typedBytes = new TypedBytes(bytes, MediaType.PDF.getType());
            return typedBytes;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private float getScale(PDPage $this$getScale) {
        return this.getScale($this$getScale.getCropBox().getWidth(), $this$getScale.getCropBox().getHeight());
    }

    private float getScale(float width, float height) {
        return this.resolution / Math.min(width, height);
    }

    @NotNull
    public Dimension scaleDimension(@NotNull Dimension dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        float scale = this.getScale((float)dimension.getWidth(), (float)dimension.getHeight());
        return new Dimension(MathKt.roundToInt((float)((float)dimension.getWidth() * scale)), MathKt.roundToInt((float)((float)dimension.getHeight() * scale)));
    }
}

