/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.metadata.mylar;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gotson.komga.domain.model.Library;
import org.gotson.komga.domain.model.MetadataPatchTarget;
import org.gotson.komga.domain.model.SeriesMetadata;
import org.gotson.komga.domain.model.SeriesMetadataPatch;
import org.gotson.komga.domain.model.Sidecar;
import org.gotson.komga.infrastructure.metadata.SeriesMetadataProvider;
import org.gotson.komga.infrastructure.metadata.mylar.MylarSeriesProvider;
import org.gotson.komga.infrastructure.metadata.mylar.MylarSeriesProviderKt;
import org.gotson.komga.infrastructure.metadata.mylar.dto.Series;
import org.gotson.komga.infrastructure.sidecar.SidecarSeriesConsumer;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/gotson/komga/infrastructure/metadata/mylar/MylarSeriesProvider;", "Lorg/gotson/komga/infrastructure/metadata/SeriesMetadataProvider;", "Lorg/gotson/komga/infrastructure/sidecar/SidecarSeriesConsumer;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "getSeriesMetadata", "Lorg/gotson/komga/domain/model/SeriesMetadataPatch;", "series", "Lorg/gotson/komga/domain/model/Series;", "getSidecarSeriesFilenames", "", "", "getSidecarSeriesType", "Lorg/gotson/komga/domain/model/Sidecar$Type;", "shouldLibraryHandlePatch", "", "library", "Lorg/gotson/komga/domain/model/Library;", "target", "Lorg/gotson/komga/domain/model/MetadataPatchTarget;", "komga"})
public class MylarSeriesProvider
implements SeriesMetadataProvider,
SidecarSeriesConsumer {
    @NotNull
    private final ObjectMapper mapper;

    public MylarSeriesProvider(@NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.mapper = mapper;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public SeriesMetadataPatch getSeriesMetadata(@NotNull org.gotson.komga.domain.model.Series series) {
        Intrinsics.checkNotNullParameter((Object)series, (String)"series");
        if (series.getOneshot()) {
            MylarSeriesProviderKt.access$getLogger$p().debug((Function0)getSeriesMetadata.1.INSTANCE);
            return null;
        }
        try {
            seriesJsonPath = series.getPath().resolve("series.json");
            Intrinsics.checkNotNull((Object)seriesJsonPath);
            v0 = new LinkOption[]{};
            if (Files.notExists(seriesJsonPath, Arrays.copyOf(v0, v0.length))) {
                MylarSeriesProviderKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
                return null;
            }
            metadata = ((Series)this.mapper.readValue(seriesJsonPath.toFile(), Series.class)).getMetadata();
            if (metadata.getVolume() == null) ** GOTO lbl-1000
            v1 = metadata.getVolume();
            var5_5 = 1;
            if (v1 != null && v1 == var5_5) lbl-1000:
            // 2 sources

            {
                v2 = metadata.getName();
            } else {
                v2 = metadata.getName() + " (" + metadata.getYear() + ")";
            }
            title = v2;
            v3 = LanguageUtilsKt.stripAccents((String)title);
            switch (WhenMappings.$EnumSwitchMapping$0[metadata.getStatus().ordinal()]) {
                case 1: {
                    v4 = SeriesMetadata.Status.ENDED;
                    break;
                }
                case 2: {
                    v4 = SeriesMetadata.Status.ONGOING;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if ((v5 = metadata.getDescriptionFormatted()) == null) {
                v5 = metadata.getDescriptionText();
            }
            v6 = metadata.getAgeRating();
            return new SeriesMetadataPatch(title, v3, v4, v5, null, metadata.getPublisher(), v6 != null ? v6.getAgeRating() : null, null, null, Integer.valueOf(metadata.getTotalIssues()), SetsKt.emptySet());
        }
        catch (Exception e) {
            MylarSeriesProviderKt.access$getLogger$p().error((Throwable)e, (Function0)getSeriesMetadata.3.INSTANCE);
            return null;
        }
    }

    public boolean shouldLibraryHandlePatch(@NotNull Library library, @NotNull MetadataPatchTarget target) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return WhenMappings.$EnumSwitchMapping$1[target.ordinal()] == 1 ? library.getImportMylarSeries() : false;
    }

    @NotNull
    public Sidecar.Type getSidecarSeriesType() {
        return Sidecar.Type.METADATA;
    }

    @NotNull
    public List<String> getSidecarSeriesFilenames() {
        return CollectionsKt.listOf((Object)"series.json");
    }
}

