/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.search;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexUpgrader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.gotson.komga.infrastructure.search.LuceneEntity;
import org.gotson.komga.infrastructure.search.LuceneHelper;
import org.gotson.komga.infrastructure.search.LuceneHelperKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\b\b\u0001\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\u00020\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0015H\u0012J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\"\u0010#\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010$2\b\u0010&\u001a\u0004\u0018\u00010%2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020 H\u0016J\u0018\u0010+\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010,\u001a\u00020\u0015H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\rX\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/gotson/komga/infrastructure/search/LuceneHelper;", "", "directory", "Lorg/apache/lucene/store/Directory;", "searchAnalyzer", "Lorg/apache/lucene/analysis/Analyzer;", "taskScheduler", "Lorg/springframework/scheduling/TaskScheduler;", "indexAnalyzer", "commitDelay", "Ljava/time/Duration;", "(Lorg/apache/lucene/store/Directory;Lorg/apache/lucene/analysis/Analyzer;Lorg/springframework/scheduling/TaskScheduler;Lorg/apache/lucene/analysis/Analyzer;Ljava/time/Duration;)V", "commitFuture", "Ljava/util/concurrent/ScheduledFuture;", "commitRunnable", "Ljava/lang/Runnable;", "indexWriter", "Lorg/apache/lucene/index/IndexWriter;", "searcherManager", "Lorg/apache/lucene/search/SearcherManager;", "addDocument", "", "doc", "Lorg/apache/lucene/document/Document;", "addDocuments", "docs", "", "commitAndMaybeRefresh", "deleteDocuments", "term", "Lorg/apache/lucene/index/Term;", "getIndexVersion", "", "indexExists", "", "searchEntitiesIds", "", "", "searchTerm", "entity", "Lorg/gotson/komga/infrastructure/search/LuceneEntity;", "setIndexVersion", "version", "updateDocument", "upgradeIndex", "komga"})
@SourceDebugExtension(value={"SMAP\nLuceneHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuceneHelper.kt\norg/gotson/komga/infrastructure/search/LuceneHelper\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,138:1\n11065#2:139\n11400#2,3:140\n11065#2:143\n11400#2,3:144\n*S KotlinDebug\n*F\n+ 1 LuceneHelper.kt\norg/gotson/komga/infrastructure/search/LuceneHelper\n*L\n60#1:139\n60#1:140,3\n84#1:143\n84#1:144,3\n*E\n"})
public class LuceneHelper {
    @NotNull
    private final Directory directory;
    @NotNull
    private final Analyzer searchAnalyzer;
    @NotNull
    private final TaskScheduler taskScheduler;
    @NotNull
    private final Analyzer indexAnalyzer;
    @NotNull
    private final Duration commitDelay;
    @NotNull
    private final IndexWriter indexWriter;
    @NotNull
    private final SearcherManager searcherManager;
    @Nullable
    private volatile ScheduledFuture<?> commitFuture;
    @NotNull
    private final Runnable commitRunnable;

    public LuceneHelper(@NotNull Directory directory, @NotNull Analyzer searchAnalyzer, @NotNull TaskScheduler taskScheduler, @NotNull Analyzer indexAnalyzer, @Value(value="#{@komgaProperties.lucene.commitDelay}") @NotNull Duration commitDelay) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)searchAnalyzer, (String)"searchAnalyzer");
        Intrinsics.checkNotNullParameter((Object)taskScheduler, (String)"taskScheduler");
        Intrinsics.checkNotNullParameter((Object)indexAnalyzer, (String)"indexAnalyzer");
        Intrinsics.checkNotNullParameter((Object)commitDelay, (String)"commitDelay");
        this.directory = directory;
        this.searchAnalyzer = searchAnalyzer;
        this.taskScheduler = taskScheduler;
        this.indexAnalyzer = indexAnalyzer;
        this.commitDelay = commitDelay;
        this.indexWriter = new IndexWriter(this.directory, new IndexWriterConfig(this.indexAnalyzer));
        this.searcherManager = new SearcherManager(this.indexWriter, new SearcherFactory());
        this.commitRunnable = () -> LuceneHelper.commitRunnable$lambda$4(this);
    }

    public boolean indexExists() {
        return DirectoryReader.indexExists((Directory)this.directory);
    }

    public void setIndexVersion(int version) {
        Document document;
        Document $this$setIndexVersion_u24lambda_u240 = document = new Document();
        boolean bl = false;
        $this$setIndexVersion_u24lambda_u240.add((IndexableField)new StringField("index_version", String.valueOf(version), Field.Store.YES));
        $this$setIndexVersion_u24lambda_u240.add((IndexableField)new StringField("type", "index_version", Field.Store.NO));
        Document doc = document;
        this.updateDocument(new Term("type", "index_version"), doc);
        LuceneHelperKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - void declaration
     */
    public int getIndexVersion() {
        void $this$mapTo$iv$iv;
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        TopDocs topDocs = searcher.search((Query)new TermQuery(new Term("type", "index_version")), 1);
        Intrinsics.checkNotNullExpressionValue((Object)topDocs.scoreDocs, (String)"scoreDocs");
        Object[] $this$map$iv = topDocs.scoreDocs;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ScoreDoc scoreDoc = (ScoreDoc)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(searcher.storedFields().document(it.doc).get("index_version"));
        }
        Object object = (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        return object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 1;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public List<String> searchEntitiesIds(@Nullable String searchTerm, @NotNull LuceneEntity entity) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object object2 = searchTerm;
        if (!(object2 == null || StringsKt.isBlank((CharSequence)object2))) {
            try {
                void $this$mapTo$iv$iv;
                MultiFieldQueryParser multiFieldQueryParser;
                MultiFieldQueryParser $this$searchEntitiesIds_u24lambda_u242 = multiFieldQueryParser = new MultiFieldQueryParser(entity.getDefaultFields(), this.searchAnalyzer);
                boolean bl = false;
                $this$searchEntitiesIds_u24lambda_u242.setDefaultOperator(QueryParser.Operator.AND);
                Query fieldsQuery = multiFieldQueryParser.parse(searchTerm + " *:*");
                TermQuery typeQuery = new TermQuery(new Term("type", entity.getType()));
                BooleanQuery booleanQuery = new BooleanQuery.Builder().add(fieldsQuery, BooleanClause.Occur.MUST).add((Query)typeQuery, BooleanClause.Occur.MUST).build();
                IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
                TopDocs topDocs = searcher.search((Query)booleanQuery, 1000);
                Intrinsics.checkNotNullExpressionValue((Object)topDocs.scoreDocs, (String)"scoreDocs");
                Object[] $this$map$iv = topDocs.scoreDocs;
                boolean $i$f$map = false;
                Object[] objectArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ScoreDoc scoreDoc = (ScoreDoc)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(searcher.storedFields().document(it.doc).get(entity.getId()));
                }
                object2 = (List)destination$iv$iv;
            }
            catch (ParseException e) {
                object2 = CollectionsKt.emptyList();
            }
            catch (Exception e) {
                LuceneHelperKt.access$getLogger$p().error((Throwable)e, (Function0)searchEntitiesIds.2.INSTANCE);
                object2 = CollectionsKt.emptyList();
            }
            object = object2;
        } else {
            object = null;
        }
        return object;
    }

    public void upgradeIndex() {
        new IndexUpgrader(this.directory, new IndexWriterConfig(this.indexAnalyzer), true).upgrade();
        LuceneHelperKt.access$getLogger$p().info((Function0)upgradeIndex.1.INSTANCE);
    }

    public void addDocument(@NotNull Document doc) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        this.indexWriter.addDocument((Iterable)doc);
        this.commitAndMaybeRefresh();
    }

    public void addDocuments(@NotNull Iterable<Document> docs) {
        Intrinsics.checkNotNullParameter(docs, (String)"docs");
        this.indexWriter.addDocuments(docs);
        this.commitAndMaybeRefresh();
    }

    public void updateDocument(@NotNull Term term, @NotNull Document doc) {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        this.indexWriter.updateDocument(term, (Iterable)doc);
        this.commitAndMaybeRefresh();
    }

    public void deleteDocuments(@NotNull Term term) {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        Term[] termArray = new Term[]{term};
        this.indexWriter.deleteDocuments(termArray);
        this.commitAndMaybeRefresh();
    }

    private void commitAndMaybeRefresh() {
        block3: {
            block2: {
                if (this.commitFuture == null) break block2;
                ScheduledFuture scheduledFuture = this.commitFuture;
                Intrinsics.checkNotNull((Object)scheduledFuture);
                if (!scheduledFuture.isDone()) break block3;
            }
            this.commitFuture = this.taskScheduler.schedule(this.commitRunnable, ZonedDateTime.now().plus(this.commitDelay).toInstant());
        }
    }

    private static final void commitRunnable$lambda$4(LuceneHelper this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.indexWriter.commit();
        this$0.searcherManager.maybeRefresh();
    }
}

