/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.persistence.MediaRepository;
import org.gotson.komga.domain.service.BookAnalyzer;
import org.gotson.komga.infrastructure.image.ImageConverter;
import org.gotson.komga.infrastructure.image.ImageType;
import org.gotson.komga.interfaces.api.WebPubGenerator;
import org.gotson.komga.interfaces.api.dto.ConstantsKt;
import org.gotson.komga.interfaces.api.dto.WPLinkDto;
import org.gotson.komga.interfaces.api.dto.WPPublicationDto;
import org.gotson.komga.interfaces.api.opds.v2.dto.AuthenticationDocumentDto;
import org.gotson.komga.interfaces.api.opds.v2.dto.AuthenticationFlowDto;
import org.gotson.komga.interfaces.api.opds.v2.dto.AuthenticationType;
import org.gotson.komga.interfaces.api.opds.v2.dto.LabelsDto;
import org.gotson.komga.interfaces.api.rest.dto.BookDto;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B'\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0014J \u0010\u0018\u001a\u001a\u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u001a0\u00190\u0019H\u0014J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\f2\u0006\u0010\u001c\u001a\u00020\rH\u0014J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lorg/gotson/komga/interfaces/api/OpdsGenerator;", "Lorg/gotson/komga/interfaces/api/WebPubGenerator;", "thumbnailType", "Lorg/gotson/komga/infrastructure/image/ImageType;", "imageConverter", "Lorg/gotson/komga/infrastructure/image/ImageConverter;", "bookAnalyzer", "Lorg/gotson/komga/domain/service/BookAnalyzer;", "mediaRepository", "Lorg/gotson/komga/domain/persistence/MediaRepository;", "(Lorg/gotson/komga/infrastructure/image/ImageType;Lorg/gotson/komga/infrastructure/image/ImageConverter;Lorg/gotson/komga/domain/service/BookAnalyzer;Lorg/gotson/komga/domain/persistence/MediaRepository;)V", "pathSegments", "", "", "getPathSegments", "()Ljava/util/List;", "generateOpdsAuthDocument", "Lorg/gotson/komga/interfaces/api/opds/v2/dto/AuthenticationDocumentDto;", "getBookSeriesLink", "Lorg/gotson/komga/interfaces/api/dto/WPLinkDto;", "bookDto", "Lorg/gotson/komga/interfaces/api/rest/dto/BookDto;", "getDefaultMediaType", "Lorg/springframework/http/MediaType;", "getExtraLinkProperties", "", "", "getExtraLinks", "bookId", "toOpdsPublicationDto", "Lorg/gotson/komga/interfaces/api/dto/WPPublicationDto;", "komga"})
@SourceDebugExtension(value={"SMAP\nOpdsGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpdsGenerator.kt\norg/gotson/komga/interfaces/api/OpdsGenerator\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,88:1\n37#2,2:89\n37#2,2:91\n37#2,2:93\n37#2,2:95\n*S KotlinDebug\n*F\n+ 1 OpdsGenerator.kt\norg/gotson/komga/interfaces/api/OpdsGenerator\n*L\n42#1:89,2\n51#1:91,2\n62#1:93,2\n71#1:95,2\n*E\n"})
public class OpdsGenerator
extends WebPubGenerator {
    @NotNull
    private final List<String> pathSegments;

    public OpdsGenerator(@Qualifier(value="thumbnailType") @NotNull ImageType thumbnailType, @NotNull ImageConverter imageConverter, @NotNull BookAnalyzer bookAnalyzer, @NotNull MediaRepository mediaRepository) {
        Intrinsics.checkNotNullParameter((Object)thumbnailType, (String)"thumbnailType");
        Intrinsics.checkNotNullParameter((Object)imageConverter, (String)"imageConverter");
        Intrinsics.checkNotNullParameter((Object)bookAnalyzer, (String)"bookAnalyzer");
        Intrinsics.checkNotNullParameter((Object)mediaRepository, (String)"mediaRepository");
        super(thumbnailType, imageConverter, bookAnalyzer, mediaRepository);
        Object[] objectArray = new String[]{"opds", "v2"};
        this.pathSegments = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected List<String> getPathSegments() {
        return this.pathSegments;
    }

    @NotNull
    public WPPublicationDto toOpdsPublicationDto(@NotNull BookDto bookDto) {
        Intrinsics.checkNotNullParameter((Object)bookDto, (String)"bookDto");
        return WPPublicationDto.copy$default((WPPublicationDto)this.toBasePublicationDto(bookDto), null, null, null, null, (List)this.buildThumbnailLinkDtos(bookDto.getId()), null, null, null, null, null, (int)1007, null);
    }

    @NotNull
    protected MediaType getDefaultMediaType() {
        return ConstantsKt.getMEDIATYPE_OPDS_PUBLICATION_JSON();
    }

    @NotNull
    protected List<WPLinkDto> getBookSeriesLink(@NotNull BookDto bookDto) {
        Intrinsics.checkNotNullParameter((Object)bookDto, (String)"bookDto");
        Collection $this$toTypedArray$iv = this.getPathSegments();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        return CollectionsKt.listOf((Object)new WPLinkDto(null, null, ServletUriComponentsBuilder.fromCurrentContextPath().pathSegment(Arrays.copyOf(stringArray, stringArray.length)).path("series/" + bookDto.getSeriesId()).toUriString(), "application/opds+json", null, null, null, null, null, null, 1011, null));
    }

    @NotNull
    protected Map<String, Map<String, Object>> getExtraLinkProperties() {
        Pair[] pairArray = new Pair[2];
        Collection $this$toTypedArray$iv = this.getPathSegments();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        pairArray[0] = TuplesKt.to((Object)"href", (Object)ServletUriComponentsBuilder.fromCurrentContextPath().pathSegment(Arrays.copyOf(stringArray, stringArray.length)).path("auth").toUriString());
        pairArray[1] = TuplesKt.to((Object)"type", (Object)"application/opds-authentication+json");
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"authenticate", (Object)MapsKt.mapOf((Pair[])pairArray)));
    }

    @NotNull
    protected List<WPLinkDto> getExtraLinks(@NotNull String bookId) {
        List list;
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        List $this$getExtraLinks_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Collection $this$toTypedArray$iv = this.getPathSegments();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object object = thisCollection$iv.toArray(new String[0]);
        String string = ServletUriComponentsBuilder.fromCurrentContextPath().pathSegment(Arrays.copyOf(object, ((String[])object).length)).path("books/" + bookId + "/progression").toUriString();
        object = this.getExtraLinkProperties();
        $this$getExtraLinks_u24lambda_u240.add(new WPLinkDto(null, "http://www.cantook.com/api/progression", string, "application/vnd.readium.progression+json", null, null, null, null, null, (Map)object, 497, null));
        return CollectionsKt.build((List)list);
    }

    @NotNull
    public AuthenticationDocumentDto generateOpdsAuthDocument() {
        Collection $this$toTypedArray$iv = this.getPathSegments();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object object = thisCollection$iv.toArray(new String[0]);
        String string = ServletUriComponentsBuilder.fromCurrentContextPath().pathSegment(Arrays.copyOf(object, ((String[])object).length)).path("auth").toUriString();
        Object object2 = new WPLinkDto[]{new WPLinkDto(null, "help", "https://komga.org", null, null, null, null, null, null, null, 1017, null), new WPLinkDto(null, "logo", ServletUriComponentsBuilder.fromCurrentContextPath().path("android-chrome-512x512.png").toUriString(), null, null, null, null, null, null, null, 1017, null)};
        object = CollectionsKt.listOf((Object[])object2);
        object2 = CollectionsKt.listOf((Object)new AuthenticationFlowDto(AuthenticationType.BASIC, new LabelsDto("Email", "Password"), null, 4, null));
        Intrinsics.checkNotNull((Object)string);
        return new AuthenticationDocumentDto((List)object2, "Komga", string, "Enter your email and password to authenticate.", (List)object);
    }
}

