/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gotson.komga.domain.model.BookPage;
import org.gotson.komga.domain.model.Dimension;
import org.gotson.komga.domain.model.EpubTocEntry;
import org.gotson.komga.domain.model.Media;
import org.gotson.komga.domain.model.MediaExtensionEpub;
import org.gotson.komga.domain.model.MediaFile;
import org.gotson.komga.domain.model.MediaProfile;
import org.gotson.komga.domain.model.MediaType;
import org.gotson.komga.domain.model.ProxyExtension;
import org.gotson.komga.domain.model.SeriesMetadata;
import org.gotson.komga.domain.persistence.MediaRepository;
import org.gotson.komga.domain.service.BookAnalyzer;
import org.gotson.komga.infrastructure.image.ImageConverter;
import org.gotson.komga.infrastructure.image.ImageType;
import org.gotson.komga.interfaces.api.WebPubGenerator;
import org.gotson.komga.interfaces.api.dto.ConstantsKt;
import org.gotson.komga.interfaces.api.dto.WPBelongsToDto;
import org.gotson.komga.interfaces.api.dto.WPContributorDto;
import org.gotson.komga.interfaces.api.dto.WPLinkDto;
import org.gotson.komga.interfaces.api.dto.WPMetadataDto;
import org.gotson.komga.interfaces.api.dto.WPPublicationDto;
import org.gotson.komga.interfaces.api.dto.WPReadingProgressionDto;
import org.gotson.komga.interfaces.api.rest.dto.AuthorDto;
import org.gotson.komga.interfaces.api.rest.dto.BookDto;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 22\u00020\u0001:\u00012B'\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\f2\u0006\u0010\u0012\u001a\u00020\rH\u0014J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0014J \u0010\u0018\u001a\u001a\u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\u00190\u0019H\u0014J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\f2\u0006\u0010\u0012\u001a\u00020\rH\u0014J\u0012\u0010\u001b\u001a\u00020\r2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0012J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J \u0010 \u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J \u0010%\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J \u0010&\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0014\u0010)\u001a\u00020\u0011*\u00020*2\u0006\u0010+\u001a\u00020,H\u0012J\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00110\f*\u00020\u00152\u0006\u0010+\u001a\u00020,H\u0012J\u001a\u0010.\u001a\u00020(*\u00020(2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002000\fH\u0012J\u0014\u00101\u001a\u00020(*\u00020(2\u0006\u0010#\u001a\u00020$H\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/gotson/komga/interfaces/api/WebPubGenerator;", "", "thumbnailType", "Lorg/gotson/komga/infrastructure/image/ImageType;", "imageConverter", "Lorg/gotson/komga/infrastructure/image/ImageConverter;", "bookAnalyzer", "Lorg/gotson/komga/domain/service/BookAnalyzer;", "mediaRepository", "Lorg/gotson/komga/domain/persistence/MediaRepository;", "(Lorg/gotson/komga/infrastructure/image/ImageType;Lorg/gotson/komga/infrastructure/image/ImageConverter;Lorg/gotson/komga/domain/service/BookAnalyzer;Lorg/gotson/komga/domain/persistence/MediaRepository;)V", "pathSegments", "", "", "getPathSegments", "()Ljava/util/List;", "buildThumbnailLinkDtos", "Lorg/gotson/komga/interfaces/api/dto/WPLinkDto;", "bookId", "getBookSeriesLink", "bookDto", "Lorg/gotson/komga/interfaces/api/rest/dto/BookDto;", "getDefaultMediaType", "Lorg/springframework/http/MediaType;", "getExtraLinkProperties", "", "getExtraLinks", "mediaProfileToWebPub", "profile", "Lorg/gotson/komga/domain/model/MediaProfile;", "toBasePublicationDto", "Lorg/gotson/komga/interfaces/api/dto/WPPublicationDto;", "toManifestDivina", "media", "Lorg/gotson/komga/domain/model/Media;", "seriesMetadata", "Lorg/gotson/komga/domain/model/SeriesMetadata;", "toManifestEpub", "toManifestPdf", "toWPMetadataDto", "Lorg/gotson/komga/interfaces/api/dto/WPMetadataDto;", "toWPLinkDto", "Lorg/gotson/komga/domain/model/EpubTocEntry;", "uriBuilder", "Lorg/springframework/web/util/UriComponentsBuilder;", "toWPLinkDtos", "withAuthors", "authors", "Lorg/gotson/komga/interfaces/api/rest/dto/AuthorDto;", "withSeriesMetadata", "Companion", "komga"})
@SourceDebugExtension(value={"SMAP\nWebPubGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebPubGenerator.kt\norg/gotson/komga/interfaces/api/WebPubGenerator\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 MediaExtension.kt\norg/gotson/komga/domain/model/ProxyExtension\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,285:1\n37#2,2:286\n37#2,2:288\n37#2,2:290\n37#2,2:297\n37#2,2:299\n1559#3:292\n1590#3,4:293\n766#3:302\n857#3,2:303\n1549#3:305\n1620#3,3:306\n766#3:309\n857#3,2:310\n1549#3:312\n1620#3,3:313\n1549#3:316\n1620#3,3:317\n1549#3:320\n1620#3,3:321\n1549#3:324\n1620#3,3:325\n1549#3:328\n1620#3,3:329\n1490#3:332\n1520#3,3:333\n1523#3,3:343\n819#3:346\n847#3,2:347\n1549#3:349\n1620#3,3:350\n22#4:301\n372#5,7:336\n*S KotlinDebug\n*F\n+ 1 WebPubGenerator.kt\norg/gotson/komga/interfaces/api/WebPubGenerator\n*L\n49#1:286,2\n63#1:288,2\n74#1:290,2\n111#1:297,2\n133#1:299,2\n81#1:292\n81#1:293,4\n154#1:302\n154#1:303,2\n154#1:305\n154#1:306,3\n162#1:309\n162#1:310,2\n162#1:312\n162#1:313,3\n168#1:316\n168#1:317,3\n169#1:320\n169#1:321,3\n170#1:324\n170#1:325,3\n184#1:328\n184#1:329,3\n225#1:332\n225#1:333,3\n225#1:343,3\n237#1:346\n237#1:347,2\n237#1:349\n237#1:350,3\n136#1:301\n225#1:336,7\n*E\n"})
public class WebPubGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImageType thumbnailType;
    @NotNull
    private final ImageConverter imageConverter;
    @NotNull
    private final BookAnalyzer bookAnalyzer;
    @NotNull
    private final MediaRepository mediaRepository;
    @NotNull
    private final List<String> pathSegments;
    @NotNull
    private static final List<String> wpKnownRoles;
    @NotNull
    private static final List<String> recommendedImageMediaTypes;

    public WebPubGenerator(@Qualifier(value="thumbnailType") @NotNull ImageType thumbnailType, @NotNull ImageConverter imageConverter, @NotNull BookAnalyzer bookAnalyzer, @NotNull MediaRepository mediaRepository) {
        Intrinsics.checkNotNullParameter((Object)thumbnailType, (String)"thumbnailType");
        Intrinsics.checkNotNullParameter((Object)imageConverter, (String)"imageConverter");
        Intrinsics.checkNotNullParameter((Object)bookAnalyzer, (String)"bookAnalyzer");
        Intrinsics.checkNotNullParameter((Object)mediaRepository, (String)"mediaRepository");
        this.thumbnailType = thumbnailType;
        this.imageConverter = imageConverter;
        this.bookAnalyzer = bookAnalyzer;
        this.mediaRepository = mediaRepository;
        Object[] objectArray = new String[]{"api", "v1"};
        this.pathSegments = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected List<String> getPathSegments() {
        return this.pathSegments;
    }

    @NotNull
    protected WPPublicationDto toBasePublicationDto(@NotNull BookDto bookDto) {
        Intrinsics.checkNotNullParameter((Object)bookDto, (String)"bookDto");
        Collection $this$toTypedArray$iv = this.getPathSegments();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        UriComponentsBuilder uriComponentsBuilder = ServletUriComponentsBuilder.fromCurrentContextPath().pathSegment(Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)uriComponentsBuilder, (String)"pathSegment(...)");
        UriComponentsBuilder uriBuilder = uriComponentsBuilder;
        return new WPPublicationDto(this.getDefaultMediaType(), "https://readium.org/webpub-manifest/context.jsonld", this.withAuthors(this.toWPMetadataDto(bookDto), bookDto.getMetadata().getAuthors()), this.toWPLinkDtos(bookDto, uriBuilder), null, null, null, null, null, null, 1008, null);
    }

    @NotNull
    protected org.springframework.http.MediaType getDefaultMediaType() {
        return ConstantsKt.getMEDIATYPE_WEBPUB_JSON();
    }

    @NotNull
    protected List<WPLinkDto> buildThumbnailLinkDtos(@NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        Collection $this$toTypedArray$iv = this.getPathSegments();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        return CollectionsKt.listOf((Object)new WPLinkDto(null, null, ServletUriComponentsBuilder.fromCurrentContextPath().pathSegment(Arrays.copyOf(stringArray, stringArray.length)).path("books/" + bookId + "/thumbnail").toUriString(), this.thumbnailType.getMediaType(), null, null, null, null, null, this.getExtraLinkProperties(), 499, null));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public WPPublicationDto toManifestDivina(@NotNull BookDto bookDto, @NotNull Media media, @NotNull SeriesMetadata seriesMetadata) {
        Collection<WPLinkDto> collection;
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)bookDto, (String)"bookDto");
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        Intrinsics.checkNotNullParameter((Object)seriesMetadata, (String)"seriesMetadata");
        Collection $this$toTypedArray$iv = this.getPathSegments();
        boolean $i$f$toTypedArray = false;
        Iterable thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        UriComponentsBuilder uriComponentsBuilder = ServletUriComponentsBuilder.fromCurrentContextPath().pathSegment(Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)uriComponentsBuilder, (String)"pathSegment(...)");
        UriComponentsBuilder uriBuilder = uriComponentsBuilder;
        WPPublicationDto it = this.toBasePublicationDto(bookDto);
        boolean bl = false;
        List pages = media.getProfile() == MediaProfile.PDF ? this.bookAnalyzer.getPdfPagesDynamic(media) : media.getPages();
        thisCollection$iv = pages;
        List list = null;
        List list2 = null;
        WPMetadataDto wPMetadataDto = WPMetadataDto.copy$default((WPMetadataDto)this.withSeriesMetadata(it.getMetadata(), seriesMetadata), null, null, null, (String)"https://readium.org/webpub-manifest/profiles/divina", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, (int)0x3FFFFF7, null);
        String string = null;
        org.springframework.http.MediaType mediaType2 = ConstantsKt.getMEDIATYPE_DIVINA_JSON();
        WPPublicationDto wPPublicationDto = it;
        boolean $i$f$mapIndexed = false;
        void var16_18 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            List list3;
            void page;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            BookPage bookPage = (BookPage)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl2 = false;
            Object[] objectArray = new Object[]{"false"};
            String string2 = uriBuilder.cloneBuilder().path("books/" + bookDto.getId() + "/pages/" + (int)(index + true)).queryParam("contentNegotiation", objectArray).toUriString();
            String string3 = page.getMediaType();
            Dimension dimension = page.getDimension();
            Integer n3 = dimension != null ? Integer.valueOf(dimension.getWidth()) : null;
            Dimension dimension2 = page.getDimension();
            Integer n4 = dimension2 != null ? Integer.valueOf(dimension2.getHeight()) : null;
            if (!recommendedImageMediaTypes.contains(page.getMediaType()) && this.imageConverter.canConvertMediaType(page.getMediaType(), "image/jpeg")) {
                objectArray = new Object[]{"false"};
                UriComponentsBuilder uriComponentsBuilder2 = uriBuilder.cloneBuilder().path("books/" + bookDto.getId() + "/pages/" + (int)(index + true)).queryParam("contentNegotiation", objectArray);
                objectArray = new Object[]{"jpeg"};
                Dimension dimension3 = page.getDimension();
                Dimension dimension4 = page.getDimension();
                list3 = CollectionsKt.listOf((Object)new WPLinkDto(null, null, uriComponentsBuilder2.queryParam("convert", objectArray).toUriString(), "image/jpeg", null, dimension3 != null ? Integer.valueOf(dimension3.getWidth()) : null, dimension4 != null ? Integer.valueOf(dimension4.getHeight()) : null, null, null, null, 915, null));
            } else {
                list3 = CollectionsKt.emptyList();
            }
            collection.add(new WPLinkDto(null, null, string2, string3, null, n3, n4, list3, null, null, 787, null));
        }
        collection = (List)destination$iv$iv;
        return WPPublicationDto.copy$default((WPPublicationDto)wPPublicationDto, (org.springframework.http.MediaType)mediaType2, string, (WPMetadataDto)wPMetadataDto, list2, list, (List)collection, (List)this.buildThumbnailLinkDtos(bookDto.getId()), null, null, null, (int)922, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public WPPublicationDto toManifestPdf(@NotNull BookDto bookDto, @NotNull Media media, @NotNull SeriesMetadata seriesMetadata) {
        ArrayList<WPLinkDto> arrayList;
        Intrinsics.checkNotNullParameter((Object)bookDto, (String)"bookDto");
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        Intrinsics.checkNotNullParameter((Object)seriesMetadata, (String)"seriesMetadata");
        Collection $this$toTypedArray$iv = this.getPathSegments();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        UriComponentsBuilder uriComponentsBuilder = ServletUriComponentsBuilder.fromCurrentContextPath().pathSegment(Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)uriComponentsBuilder, (String)"pathSegment(...)");
        UriComponentsBuilder uriBuilder = uriComponentsBuilder;
        WPPublicationDto it = this.toBasePublicationDto(bookDto);
        boolean bl = false;
        int n = media.getPageCount();
        List list = null;
        List list2 = null;
        WPMetadataDto wPMetadataDto = WPMetadataDto.copy$default((WPMetadataDto)this.withSeriesMetadata(it.getMetadata(), seriesMetadata), null, null, null, (String)"https://readium.org/webpub-manifest/profiles/pdf", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, (int)0x3FFFFF7, null);
        String string = null;
        org.springframework.http.MediaType mediaType2 = ConstantsKt.getMEDIATYPE_WEBPUB_JSON();
        WPPublicationDto wPPublicationDto = it;
        ArrayList<WPLinkDto> arrayList2 = new ArrayList<WPLinkDto>(n);
        int n2 = 0;
        while (n2 < n) {
            void index;
            int n3;
            int n4 = n3 = n2++;
            arrayList = arrayList2;
            boolean bl2 = false;
            arrayList.add(new WPLinkDto(null, null, uriBuilder.cloneBuilder().path("books/" + bookDto.getId() + "/pages/" + (int)(index + true) + "/raw").toUriString(), MediaType.PDF.getType(), null, null, null, null, null, null, 1011, null));
        }
        arrayList = arrayList2;
        return WPPublicationDto.copy$default((WPPublicationDto)wPPublicationDto, (org.springframework.http.MediaType)mediaType2, string, (WPMetadataDto)wPMetadataDto, list2, list, arrayList, (List)this.buildThumbnailLinkDtos(bookDto.getId()), null, null, null, (int)922, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public WPPublicationDto toManifestEpub(@NotNull BookDto bookDto, @NotNull Media media, @NotNull SeriesMetadata seriesMetadata) {
        Intrinsics.checkNotNullParameter((Object)bookDto, (String)"bookDto");
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        Intrinsics.checkNotNullParameter((Object)seriesMetadata, (String)"seriesMetadata");
        $this$toTypedArray$iv = this.getPathSegments();
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        var6_9 = thisCollection$iv.toArray(new String[0]);
        v0 = ServletUriComponentsBuilder.fromCurrentContextPath().pathSegment(Arrays.copyOf(var6_9, ((String[])var6_9).length));
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"pathSegment(...)");
        uriBuilder = v0;
        if (!(media.getExtension() instanceof ProxyExtension)) ** GOTO lbl-1000
        this_$iv = (ProxyExtension)media.getExtension();
        $i$f$proxyForType = false;
        if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(MediaExtensionEpub.class).getQualifiedName(), (Object)this_$iv.getExtensionClassName())) {
            var6_9 = this.mediaRepository.findExtensionByIdOrNull(media.getBookId());
            v1 /* !! */  = var6_9 instanceof MediaExtensionEpub ? (MediaExtensionEpub)var6_9 : null;
        } else lbl-1000:
        // 2 sources

        {
            v1 /* !! */  = media.getExtension() instanceof MediaExtensionEpub != false ? (MediaExtensionEpub)media.getExtension() : null;
        }
        extension = v1 /* !! */ ;
        publication = this.toBasePublicationDto(bookDto);
        $i$a$-let-WebPubGenerator$toManifestEpub$1 = false;
        v2 = extension;
        v3 = thisCollection$iv = v2 != null ? Boolean.valueOf(v2.isFixedLayout()) : null;
        v4 = Intrinsics.areEqual((Object)thisCollection$iv, (Object)true) != false ? MapsKt.mapOf((Pair)TuplesKt.to((Object)"layout", (Object)"fixed")) : (Intrinsics.areEqual((Object)thisCollection$iv, (Object)false) != false ? MapsKt.mapOf((Pair)TuplesKt.to((Object)"layout", (Object)"reflowable")) : MapsKt.emptyMap());
        thisCollection$iv = media.getFiles();
        var10_12 = null;
        var11_13 = null;
        var12_14 = WPMetadataDto.copy$default((WPMetadataDto)this.withSeriesMetadata(publication.getMetadata(), seriesMetadata), null, null, null, (String)"https://readium.org/webpub-manifest/profiles/epub", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, (Map)v4, (int)0x1FFFFF7, null);
        var13_15 = null;
        var14_16 = ConstantsKt.getMEDIATYPE_WEBPUB_JSON();
        var15_17 = publication;
        $i$f$filter = false;
        var17_19 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (MediaFile)element$iv$iv;
            $i$a$-filter-WebPubGenerator$toManifestEpub$1$1 = false;
            if (!(it.getSubType() == MediaFile.SubType.EPUB_PAGE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        var24_38 = (List)destination$iv$iv;
        $this$filter$iv = var24_38;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            it = (MediaFile)item$iv$iv;
            var24_38 = destination$iv$iv;
            $i$a$-map-WebPubGenerator$toManifestEpub$1$2 = false;
            var24_38.add(new WPLinkDto(null, null, uriBuilder.cloneBuilder().path("books/" + bookDto.getId() + "/resource/").path(it.getFileName()).toUriString(), it.getMediaType(), null, null, null, null, null, null, 1011, null));
        }
        var24_38 = (List)destination$iv$iv;
        $this$map$iv = media.getFiles();
        var25_39 = this.buildThumbnailLinkDtos(bookDto.getId());
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (MediaFile)element$iv$iv;
            $i$a$-filter-WebPubGenerator$toManifestEpub$1$3 = false;
            if (!(it.getSubType() == MediaFile.SubType.EPUB_ASSET)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        var26_40 = (List)destination$iv$iv;
        $this$filter$iv = var26_40;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            it = (MediaFile)item$iv$iv;
            var26_40 = destination$iv$iv;
            $i$a$-map-WebPubGenerator$toManifestEpub$1$4 = false;
            var26_40.add(new WPLinkDto(null, null, uriBuilder.cloneBuilder().path("books/" + bookDto.getId() + "/resource/").path(it.getFileName()).toUriString(), it.getMediaType(), null, null, null, null, null, null, 1011, null));
        }
        var26_40 = (List)destination$iv$iv;
        v5 = var15_17;
        v6 = var14_16;
        v7 = var13_15;
        v8 = var12_14;
        v9 = var11_13;
        v10 = var10_12;
        v11 = var24_38;
        v12 /* !! */  = CollectionsKt.plus((Collection)var25_39, (Iterable)var26_40);
        v13 /* !! */  = extension;
        if (v13 /* !! */  != null && (v13 /* !! */  = v13 /* !! */ .getToc()) != null) {
            $this$mapTo$iv$iv = (Iterable)v13 /* !! */ ;
            var25_39 = v12 /* !! */ ;
            var24_38 = v11;
            var10_12 = v10;
            var11_13 = v9;
            var12_14 = v8;
            var13_15 = v7;
            var14_16 = v6;
            var15_17 = v5;
            $i$f$map = false;
            $i$f$mapTo = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var27_41 = (EpubTocEntry)item$iv$iv;
                var26_40 = destination$iv$iv;
                $i$a$-map-WebPubGenerator$toManifestEpub$1$5 = false;
                v14 = uriBuilder.cloneBuilder().path("books/" + bookDto.getId() + "/resource/");
                Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"path(...)");
                var26_40.add(this.toWPLinkDto(it, v14));
            }
            var26_40 = (List)destination$iv$iv;
            v5 = var15_17;
            v6 = var14_16;
            v7 = var13_15;
            v8 = var12_14;
            v9 = var11_13;
            v10 = var10_12;
            v11 = var24_38;
            v12 /* !! */  = var25_39;
            v15 /* !! */  = var26_40;
        } else {
            v15 /* !! */  = CollectionsKt.emptyList();
        }
        if ((v16 /* !! */  = extension) != null && (v16 /* !! */  = v16 /* !! */ .getLandmarks()) != null) {
            $this$map$iv = (Iterable)v16 /* !! */ ;
            var26_40 = v15 /* !! */ ;
            var25_39 = v12 /* !! */ ;
            var24_38 = v11;
            var10_12 = v10;
            var11_13 = v9;
            var12_14 = v8;
            var13_15 = v7;
            var14_16 = v6;
            var15_17 = v5;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                it = (EpubTocEntry)item$iv$iv;
                var29_43 = destination$iv$iv;
                $i$a$-map-WebPubGenerator$toManifestEpub$1$6 = false;
                v17 = uriBuilder.cloneBuilder().path("books/" + bookDto.getId() + "/resource/");
                Intrinsics.checkNotNullExpressionValue((Object)v17, (String)"path(...)");
                var29_43.add(this.toWPLinkDto(it, v17));
            }
            var29_43 = (List)destination$iv$iv;
            v5 = var15_17;
            v6 = var14_16;
            v7 = var13_15;
            v8 = var12_14;
            v9 = var11_13;
            v10 = var10_12;
            v11 = var24_38;
            v12 /* !! */  = var25_39;
            v15 /* !! */  = var26_40;
            v18 = var29_43;
        } else {
            v18 = CollectionsKt.emptyList();
        }
        if ((v19 /* !! */  = extension) != null && (v19 /* !! */  = v19 /* !! */ .getPageList()) != null) {
            $this$map$iv = (Iterable)v19 /* !! */ ;
            var29_43 = v18;
            var26_40 = v15 /* !! */ ;
            var25_39 = v12 /* !! */ ;
            var24_38 = v11;
            var10_12 = v10;
            var11_13 = v9;
            var12_14 = v8;
            var13_15 = v7;
            var14_16 = v6;
            var15_17 = v5;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                it = (EpubTocEntry)item$iv$iv;
                var30_44 = destination$iv$iv;
                $i$a$-map-WebPubGenerator$toManifestEpub$1$7 = false;
                v20 = uriBuilder.cloneBuilder().path("books/" + bookDto.getId() + "/resource/");
                Intrinsics.checkNotNullExpressionValue((Object)v20, (String)"path(...)");
                var30_44.add(this.toWPLinkDto(it, v20));
            }
            var30_44 = (List)destination$iv$iv;
            v5 = var15_17;
            v6 = var14_16;
            v7 = var13_15;
            v8 = var12_14;
            v9 = var11_13;
            v10 = var10_12;
            v11 = var24_38;
            v12 /* !! */  = var25_39;
            v15 /* !! */  = var26_40;
            v18 = var29_43;
            v21 = var30_44;
        } else {
            v21 = CollectionsKt.emptyList();
        }
        return WPPublicationDto.copy$default((WPPublicationDto)v5, (org.springframework.http.MediaType)v6, v7, (WPMetadataDto)v8, v9, v10, v11, (List)v12 /* !! */ , (List)v15 /* !! */ , (List)v18, (List)v21, (int)26, null);
    }

    /*
     * WARNING - void declaration
     */
    private WPLinkDto toWPLinkDto(EpubTocEntry $this$toWPLinkDto, UriComponentsBuilder uriBuilder) {
        Collection<WPLinkDto> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string;
        String string2;
        void it;
        String string3;
        String string4;
        String string5 = $this$toWPLinkDto.getTitle();
        String string6 = null;
        String string7 = $this$toWPLinkDto.getHref();
        if (string7 != null) {
            String string8 = string7;
            string4 = string6;
            string3 = string5;
            boolean bl = false;
            String fragment = StringsKt.substringAfterLast((String)it, (String)"#", (String)"");
            String h = StringsKt.removeSuffix((String)it, (CharSequence)("#" + fragment));
            string2 = uriBuilder.cloneBuilder().path(h).toUriString() + (String)(((CharSequence)fragment).length() > 0 ? "#" + fragment : "");
            string5 = string3;
            string6 = string4;
            string = string2;
        } else {
            string = null;
        }
        Iterable iterable = $this$toWPLinkDto.getChildren();
        List list = null;
        Integer n = null;
        Integer n2 = null;
        Boolean bl = null;
        String string9 = null;
        string2 = string;
        string4 = string6;
        string3 = string5;
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            EpubTocEntry epubTocEntry = (EpubTocEntry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(this.toWPLinkDto((EpubTocEntry)it2, uriBuilder));
        }
        collection = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n3 = 762;
        Map map = null;
        Collection<WPLinkDto> collection2 = collection;
        List list2 = list;
        Integer n4 = n;
        Integer n5 = n2;
        Boolean bl3 = bl;
        String string10 = string9;
        String string11 = string2;
        String string12 = string4;
        String string13 = string3;
        return new WPLinkDto(string13, string12, string11, string10, bl3, n5, n4, list2, collection2, map, n3, defaultConstructorMarker);
    }

    @NotNull
    protected WPMetadataDto toWPMetadataDto(@NotNull BookDto bookDto) {
        Intrinsics.checkNotNullParameter((Object)bookDto, (String)"bookDto");
        String string = bookDto.getMetadata().getTitle();
        String string2 = bookDto.getMetadata().getSummary();
        int n = bookDto.getMedia().getPagesCount();
        ZonedDateTime zonedDateTime = LanguageUtilsKt.toZonedDateTime((LocalDateTime)bookDto.getLastModified());
        LocalDate localDate = bookDto.getMetadata().getReleaseDate();
        List list = CollectionsKt.toList((Iterable)bookDto.getMetadata().getTags());
        String string3 = !StringsKt.isBlank((CharSequence)bookDto.getMetadata().getIsbn()) ? "urn:isbn:" + bookDto.getMetadata().getIsbn() : null;
        WPBelongsToDto wPBelongsToDto = new WPBelongsToDto(CollectionsKt.listOf((Object)new WPContributorDto(bookDto.getSeriesTitle(), Float.valueOf(bookDto.getMetadata().getNumberSort()), this.getBookSeriesLink(bookDto))), null, 2, null);
        return new WPMetadataDto(string, string3, null, null, null, null, zonedDateTime, localDate, null, null, null, null, null, null, null, null, null, null, null, null, list, null, string2, Integer.valueOf(n), wPBelongsToDto, null, 36699964, null);
    }

    @NotNull
    protected List<WPLinkDto> getBookSeriesLink(@NotNull BookDto bookDto) {
        Intrinsics.checkNotNullParameter((Object)bookDto, (String)"bookDto");
        return CollectionsKt.emptyList();
    }

    private WPMetadataDto withSeriesMetadata(WPMetadataDto $this$withSeriesMetadata, SeriesMetadata seriesMetadata) {
        String string = seriesMetadata.getLanguage();
        SeriesMetadata.ReadingDirection readingDirection = seriesMetadata.getReadingDirection();
        return WPMetadataDto.copy$default((WPMetadataDto)$this$withSeriesMetadata, null, null, null, null, null, null, null, null, (String)string, null, null, null, null, null, null, null, null, null, null, null, null, (WPReadingProgressionDto)(switch (readingDirection == null ? -1 : WhenMappings.$EnumSwitchMapping$0[readingDirection.ordinal()]) {
            case 1 -> WPReadingProgressionDto.LTR;
            case 2 -> WPReadingProgressionDto.RTL;
            case 3 -> WPReadingProgressionDto.TTB;
            case 4 -> WPReadingProgressionDto.TTB;
            case -1 -> null;
            default -> throw new NoWhenBranchMatchedException();
        }), null, null, null, null, (int)65011455, null);
    }

    /*
     * WARNING - void declaration
     */
    private WPMetadataDto withAuthors(WPMetadataDto $this$withAuthors, List<AuthorDto> authors) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        List list;
        List list2;
        List list3;
        List list4;
        List list5;
        List list6;
        List list7;
        List list8;
        AuthorDto it;
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = authors;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it2;
            Object object;
            it = (AuthorDto)element$iv$iv;
            boolean $i$a$-groupBy-WebPubGenerator$withAuthors$groups$32 = false;
            String key$iv$iv = it.getRole();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            AuthorDto $i$a$-groupBy-WebPubGenerator$withAuthors$groups$32 = (AuthorDto)element$iv$iv;
            list8 = list$iv$iv;
            boolean bl = false;
            list8.add(it2.getName());
        }
        Object groups = destination$iv$iv;
        List list9 = (List)groups.get("author");
        if (list9 == null) {
            list9 = CollectionsKt.emptyList();
        }
        if ((list7 = (List)groups.get("translator")) == null) {
            list7 = CollectionsKt.emptyList();
        }
        if ((list6 = (List)groups.get("editor")) == null) {
            list6 = CollectionsKt.emptyList();
        }
        if ((list5 = (List)groups.get("artist")) == null) {
            list5 = CollectionsKt.emptyList();
        }
        if ((list4 = (List)groups.get("illustrator")) == null) {
            list4 = CollectionsKt.emptyList();
        }
        if ((list3 = (List)groups.get("letterer")) == null) {
            list3 = CollectionsKt.emptyList();
        }
        if ((list2 = (List)groups.get("penciler")) == null) {
            list2 = CollectionsKt.emptyList();
        }
        Collection collection = list2;
        List list10 = (List)groups.get("penciller");
        if (list10 == null) {
            list10 = CollectionsKt.emptyList();
        }
        List list11 = CollectionsKt.plus((Collection)collection, (Iterable)list10);
        List list12 = (List)groups.get("colorist");
        if (list12 == null) {
            list12 = CollectionsKt.emptyList();
        }
        if ((list = (List)groups.get("inker")) == null) {
            list = CollectionsKt.emptyList();
        }
        $this$groupBy$iv = authors;
        List list13 = list;
        List list14 = list12;
        List list15 = list11;
        List list16 = list3;
        List list17 = list4;
        List list18 = list5;
        List list19 = list6;
        List list20 = list7;
        List list21 = list9;
        String string = null;
        LocalDate localDate = null;
        ZonedDateTime zonedDateTime = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        list8 = $this$withAuthors;
        boolean $i$f$filterNot = false;
        $this$groupByTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (AuthorDto)element$iv$iv;
            boolean bl = false;
            if (wpKnownRoles.contains(it.getRole())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Object object = (List)destination$iv$iv;
        $this$filterNot$iv = (Iterable)object;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (AuthorDto)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.getName());
        }
        object = (List)destination$iv$iv;
        return WPMetadataDto.copy$default((WPMetadataDto)list8, string7, string6, string5, string4, string3, string2, zonedDateTime, localDate, string, (List)list21, (List)list20, (List)list19, (List)list18, (List)list17, (List)list16, (List)list15, (List)list14, (List)list13, (List)object, null, null, null, null, null, null, null, (int)66585087, null);
    }

    @NotNull
    protected Map<String, Map<String, Object>> getExtraLinkProperties() {
        return MapsKt.emptyMap();
    }

    @NotNull
    protected List<WPLinkDto> getExtraLinks(@NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        return CollectionsKt.emptyList();
    }

    private List<WPLinkDto> toWPLinkDtos(BookDto $this$toWPLinkDtos, UriComponentsBuilder uriBuilder) {
        Object object;
        List $this$toWPLinkDtos_u24lambda_u2418;
        List list;
        MediaType komgaMediaType;
        block5: {
            block4: {
                komgaMediaType = MediaType.Companion.fromMediaType($this$toWPLinkDtos.getMedia().getMediaType());
                $this$toWPLinkDtos_u24lambda_u2418 = list = CollectionsKt.createListBuilder();
                boolean bl = false;
                MediaType mediaType2 = komgaMediaType;
                $this$toWPLinkDtos_u24lambda_u2418.add(new WPLinkDto(null, "self", uriBuilder.cloneBuilder().path("books/" + $this$toWPLinkDtos.getId() + "/manifest").toUriString(), this.mediaProfileToWebPub((MediaProfile)(mediaType2 != null ? mediaType2.getProfile() : null)), null, null, null, null, null, this.getExtraLinkProperties(), 497, null));
                MediaType mediaType3 = komgaMediaType;
                if ((mediaType3 != null ? mediaType3.getProfile() : null) == MediaProfile.PDF) break block4;
                MediaType mediaType4 = komgaMediaType;
                if ((mediaType4 != null ? mediaType4.getProfile() : null) != MediaProfile.EPUB || !$this$toWPLinkDtos.getMedia().getEpubDivinaCompatible()) break block5;
            }
            $this$toWPLinkDtos_u24lambda_u2418.add(new WPLinkDto(null, null, uriBuilder.cloneBuilder().path("books/" + $this$toWPLinkDtos.getId() + "/manifest/divina").toUriString(), "application/divina+json", null, null, null, null, null, this.getExtraLinkProperties(), 499, null));
        }
        if ((object = komgaMediaType) == null || (object = object.getExportType()) == null) {
            object = $this$toWPLinkDtos.getMedia().getMediaType();
        }
        Object object2 = object;
        String string = uriBuilder.cloneBuilder().path("books/" + $this$toWPLinkDtos.getId() + "/file").toUriString();
        Map map = this.getExtraLinkProperties();
        $this$toWPLinkDtos_u24lambda_u2418.add(new WPLinkDto(null, "http://opds-spec.org/acquisition", string, (String)object2, null, null, null, null, null, map, 497, null));
        $this$toWPLinkDtos_u24lambda_u2418.addAll(this.getExtraLinks($this$toWPLinkDtos.getId()));
        return CollectionsKt.build((List)list);
    }

    private String mediaProfileToWebPub(MediaProfile profile2) {
        MediaProfile mediaProfile2 = profile2;
        return switch (mediaProfile2 == null ? -1 : WhenMappings.$EnumSwitchMapping$1[mediaProfile2.ordinal()]) {
            case 1 -> "application/divina+json";
            case 2 -> "application/webpub+json";
            case 3 -> "application/webpub+json";
            case -1 -> "application/webpub+json";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    static {
        Object[] objectArray = new String[]{"author", "translator", "editor", "artist", "illustrator", "letterer", "penciler", "penciller", "colorist", "inker"};
        wpKnownRoles = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"image/jpeg", "image/png", "image/gif"};
        recommendedImageMediaTypes = CollectionsKt.listOf((Object[])objectArray);
    }
}

