/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.kobo;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.gotson.komga.domain.model.ApiKey;
import org.gotson.komga.domain.model.Book;
import org.gotson.komga.domain.model.BookWithMedia;
import org.gotson.komga.domain.model.KomgaSyncToken;
import org.gotson.komga.domain.model.MediaExtensionEpub;
import org.gotson.komga.domain.model.MediaType;
import org.gotson.komga.domain.model.R2Device;
import org.gotson.komga.domain.model.R2Locator;
import org.gotson.komga.domain.model.R2Progression;
import org.gotson.komga.domain.model.ReadProgress;
import org.gotson.komga.domain.model.SyncPoint;
import org.gotson.komga.domain.model.TypedBytes;
import org.gotson.komga.domain.persistence.BookRepository;
import org.gotson.komga.domain.persistence.MediaRepository;
import org.gotson.komga.domain.persistence.ReadProgressRepository;
import org.gotson.komga.domain.persistence.SyncPointRepository;
import org.gotson.komga.domain.persistence.ThumbnailBookRepository;
import org.gotson.komga.domain.service.BookLifecycle;
import org.gotson.komga.domain.service.SyncPointLifecycle;
import org.gotson.komga.infrastructure.configuration.KomgaProperties;
import org.gotson.komga.infrastructure.image.ImageConverter;
import org.gotson.komga.infrastructure.image.ImageType;
import org.gotson.komga.infrastructure.kobo.KepubConverter;
import org.gotson.komga.infrastructure.kobo.KoboProxy;
import org.gotson.komga.infrastructure.kobo.KomgaSyncTokenGenerator;
import org.gotson.komga.infrastructure.security.KomgaPrincipal;
import org.gotson.komga.infrastructure.web.UtilsKt;
import org.gotson.komga.interfaces.api.CommonBookController;
import org.gotson.komga.interfaces.api.ContentRestrictionChecker;
import org.gotson.komga.interfaces.api.kobo.KoboController;
import org.gotson.komga.interfaces.api.kobo.KoboControllerKt;
import org.gotson.komga.interfaces.api.kobo.dto.AmountDto;
import org.gotson.komga.interfaces.api.kobo.dto.AuthDto;
import org.gotson.komga.interfaces.api.kobo.dto.BookEntitlementContainerDto;
import org.gotson.komga.interfaces.api.kobo.dto.BookEntitlementDto;
import org.gotson.komga.interfaces.api.kobo.dto.BookEntitlementDtoKt;
import org.gotson.komga.interfaces.api.kobo.dto.BookmarkDto;
import org.gotson.komga.interfaces.api.kobo.dto.ChangedEntitlementDto;
import org.gotson.komga.interfaces.api.kobo.dto.ChangedProductMetadataDto;
import org.gotson.komga.interfaces.api.kobo.dto.ChangedReadingStateDto;
import org.gotson.komga.interfaces.api.kobo.dto.ChangedTagDto;
import org.gotson.komga.interfaces.api.kobo.dto.DeletedTagDto;
import org.gotson.komga.interfaces.api.kobo.dto.DownloadUrlDto;
import org.gotson.komga.interfaces.api.kobo.dto.FormatDto;
import org.gotson.komga.interfaces.api.kobo.dto.KoboBookMetadataDto;
import org.gotson.komga.interfaces.api.kobo.dto.NewEntitlementDto;
import org.gotson.komga.interfaces.api.kobo.dto.NewTagDto;
import org.gotson.komga.interfaces.api.kobo.dto.ReadingStateDto;
import org.gotson.komga.interfaces.api.kobo.dto.ReadingStateDtoKt;
import org.gotson.komga.interfaces.api.kobo.dto.ReadingStateStateUpdateDto;
import org.gotson.komga.interfaces.api.kobo.dto.ReadingStateUpdateResultDto;
import org.gotson.komga.interfaces.api.kobo.dto.RequestResultDto;
import org.gotson.komga.interfaces.api.kobo.dto.ResourcesDto;
import org.gotson.komga.interfaces.api.kobo.dto.ResultDto;
import org.gotson.komga.interfaces.api.kobo.dto.StatisticsDto;
import org.gotson.komga.interfaces.api.kobo.dto.StatusDto;
import org.gotson.komga.interfaces.api.kobo.dto.StatusInfoDto;
import org.gotson.komga.interfaces.api.kobo.dto.TagDtoKt;
import org.gotson.komga.interfaces.api.kobo.dto.TagItemDto;
import org.gotson.komga.interfaces.api.kobo.dto.TestsDto;
import org.gotson.komga.interfaces.api.kobo.dto.WrappedReadingStateDto;
import org.gotson.komga.interfaces.api.kobo.dto.WrappedTagDto;
import org.gotson.komga.interfaces.api.kobo.persistence.KoboDtoRepository;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.io.FileSystemResource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/kobo/{authToken}/"}, produces={"application/json; charset=utf-8"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ea\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B\u0085\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\u0006\u0010 \u001a\u00020!\u00a2\u0006\u0002\u0010\"J\u0014\u0010(\u001a\u00020)2\n\b\u0001\u0010*\u001a\u0004\u0018\u00010%H\u0016J\u0012\u0010+\u001a\u00020\u00012\b\b\u0001\u0010,\u001a\u00020-H\u0017J\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020-0/2\n\b\u0001\u0010,\u001a\u0004\u0018\u00010\u0001H\u0017JR\u00100\u001a\b\u0012\u0004\u0012\u00020\u00010/2\b\b\u0001\u00101\u001a\u0002022\b\b\u0001\u00103\u001a\u00020%2\n\b\u0001\u00104\u001a\u0004\u0018\u00010%2\n\b\u0001\u00105\u001a\u0004\u0018\u00010%2\n\b\u0001\u00106\u001a\u0004\u0018\u00010%2\n\b\u0001\u00107\u001a\u0004\u0018\u00010%H\u0017J,\u00108\u001a\b\u0012\u0004\u0012\u0002090/2\b\b\u0001\u00101\u001a\u0002022\b\b\u0001\u0010:\u001a\u00020%2\b\b\u0003\u0010;\u001a\u00020<H\u0017J \u0010=\u001a\u0006\u0012\u0002\b\u00030/2\b\b\u0001\u0010>\u001a\u00020%2\b\b\u0001\u0010:\u001a\u00020%H\u0017J\u0010\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020%H\u0012J\u0018\u0010B\u001a\u00020C2\u0006\u0010:\u001a\u00020%2\u0006\u0010D\u001a\u00020EH\u0012J\u0010\u0010B\u001a\u00020C2\u0006\u0010F\u001a\u00020GH\u0012J\u0010\u0010H\u001a\u00020I2\u0006\u0010:\u001a\u00020%H\u0012J \u0010J\u001a\u0006\u0012\u0002\b\u00030/2\b\b\u0001\u00101\u001a\u0002022\b\b\u0001\u0010:\u001a\u00020%H\u0017J\u001c\u0010K\u001a\u0004\u0018\u00010L2\b\u0010M\u001a\u0004\u0018\u00010%2\u0006\u0010N\u001a\u00020%H\u0012J\u0018\u0010O\u001a\b\u0012\u0004\u0012\u00020P0/2\b\b\u0001\u0010>\u001a\u00020%H\u0017J\b\u0010Q\u001a\u00020%H\u0017J(\u0010R\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010S0/2\b\b\u0001\u00101\u001a\u0002022\b\b\u0001\u0010>\u001a\u00020%H\u0017J4\u0010T\u001a\u0006\u0012\u0002\b\u00030/2\b\b\u0001\u00101\u001a\u0002022\b\b\u0001\u0010:\u001a\u00020%2\b\b\u0001\u0010,\u001a\u00020U2\b\b\u0003\u0010V\u001a\u00020%H\u0017J\f\u0010W\u001a\u00020%*\u00020GH\u0012J\u0014\u0010X\u001a\u00020I*\u00020I2\u0006\u0010Y\u001a\u00020@H\u0012R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000RN\u0010#\u001aB\u0012\f\u0012\n &*\u0004\u0018\u00010%0%\u0012\f\u0012\n &*\u0004\u0018\u00010'0' &* \u0012\f\u0012\n &*\u0004\u0018\u00010%0%\u0012\f\u0012\n &*\u0004\u0018\u00010'0'\u0018\u00010$0$X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lorg/gotson/komga/interfaces/api/kobo/KoboController;", "", "koboProxy", "Lorg/gotson/komga/infrastructure/kobo/KoboProxy;", "kepubConverter", "Lorg/gotson/komga/infrastructure/kobo/KepubConverter;", "syncPointLifecycle", "Lorg/gotson/komga/domain/service/SyncPointLifecycle;", "syncPointRepository", "Lorg/gotson/komga/domain/persistence/SyncPointRepository;", "komgaSyncTokenGenerator", "Lorg/gotson/komga/infrastructure/kobo/KomgaSyncTokenGenerator;", "komgaProperties", "Lorg/gotson/komga/infrastructure/configuration/KomgaProperties;", "koboDtoRepository", "Lorg/gotson/komga/interfaces/api/kobo/persistence/KoboDtoRepository;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "commonBookController", "Lorg/gotson/komga/interfaces/api/CommonBookController;", "bookLifecycle", "Lorg/gotson/komga/domain/service/BookLifecycle;", "bookRepository", "Lorg/gotson/komga/domain/persistence/BookRepository;", "thumbnailBookRepository", "Lorg/gotson/komga/domain/persistence/ThumbnailBookRepository;", "readProgressRepository", "Lorg/gotson/komga/domain/persistence/ReadProgressRepository;", "imageConverter", "Lorg/gotson/komga/infrastructure/image/ImageConverter;", "mediaRepository", "Lorg/gotson/komga/domain/persistence/MediaRepository;", "contentRestrictionChecker", "Lorg/gotson/komga/interfaces/api/ContentRestrictionChecker;", "(Lorg/gotson/komga/infrastructure/kobo/KoboProxy;Lorg/gotson/komga/infrastructure/kobo/KepubConverter;Lorg/gotson/komga/domain/service/SyncPointLifecycle;Lorg/gotson/komga/domain/persistence/SyncPointRepository;Lorg/gotson/komga/infrastructure/kobo/KomgaSyncTokenGenerator;Lorg/gotson/komga/infrastructure/configuration/KomgaProperties;Lorg/gotson/komga/interfaces/api/kobo/persistence/KoboDtoRepository;Lcom/fasterxml/jackson/databind/ObjectMapper;Lorg/gotson/komga/interfaces/api/CommonBookController;Lorg/gotson/komga/domain/service/BookLifecycle;Lorg/gotson/komga/domain/persistence/BookRepository;Lorg/gotson/komga/domain/persistence/ThumbnailBookRepository;Lorg/gotson/komga/domain/persistence/ReadProgressRepository;Lorg/gotson/komga/infrastructure/image/ImageConverter;Lorg/gotson/komga/domain/persistence/MediaRepository;Lorg/gotson/komga/interfaces/api/ContentRestrictionChecker;)V", "cachedKepub", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "kotlin.jvm.PlatformType", "Ljava/nio/file/Path;", "analyticsGetTests", "Lorg/gotson/komga/interfaces/api/kobo/dto/TestsDto;", "userKey", "authDevice", "body", "Lcom/fasterxml/jackson/databind/JsonNode;", "catchAll", "Lorg/springframework/http/ResponseEntity;", "getBookCover", "principal", "Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;", "thumbnailId", "width", "height", "quality", "isGreyScale", "getBookFile", "Lorg/springframework/web/servlet/mvc/method/annotation/StreamingResponseBody;", "bookId", "convertToKepub", "", "getBookMetadata", "authToken", "getDownloadUrlBuilder", "Lorg/springframework/web/util/UriBuilder;", "token", "getEmptyReadProgressForBook", "Lorg/gotson/komga/interfaces/api/kobo/dto/ReadingStateDto;", "createdDate", "Ljava/time/ZonedDateTime;", "book", "Lorg/gotson/komga/domain/model/Book;", "getMetadataForRemovedBook", "Lorg/gotson/komga/interfaces/api/kobo/dto/KoboBookMetadataDto;", "getState", "getSyncPointVerified", "Lorg/gotson/komga/domain/model/SyncPoint;", "syncPointId", "userId", "initialization", "Lorg/gotson/komga/interfaces/api/kobo/dto/ResourcesDto;", "ping", "syncLibrary", "", "updateState", "Lorg/gotson/komga/interfaces/api/kobo/dto/ReadingStateStateUpdateDto;", "koboDeviceId", "computeCacheKey", "withDownloadUrls", "downloadUriBuilder", "komga"})
@SourceDebugExtension(value={"SMAP\nKoboController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KoboController.kt\norg/gotson/komga/interfaces/api/kobo/KoboController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,811:1\n1549#2:812\n1620#2,3:813\n1194#2,2:816\n1222#2,4:818\n1238#2,4:824\n1549#2:828\n1620#2,3:829\n1194#2,2:832\n1222#2,4:834\n1549#2:838\n1620#2,3:839\n1477#2:842\n1502#2,3:843\n1505#2,3:853\n1549#2:856\n1620#2,3:857\n1549#2:860\n1620#2,3:861\n1549#2:864\n1620#2,3:865\n1549#2:868\n1620#2,3:869\n1603#2,9:872\n1855#2:881\n1856#2:883\n1612#2:884\n1549#2:885\n1620#2,2:886\n1549#2:888\n1620#2,3:889\n1622#2:892\n1549#2:893\n1620#2,2:894\n1549#2:896\n1620#2,3:897\n1622#2:900\n1549#2:901\n1620#2,3:902\n1549#2:905\n1620#2,3:906\n1194#2,2:909\n1222#2,4:911\n1238#2,4:917\n1549#2:921\n1620#2,3:922\n1194#2,2:925\n1222#2,4:927\n1549#2:931\n1620#2,3:932\n1477#2:935\n1502#2,3:936\n1505#2,3:946\n1549#2:949\n1620#2,3:950\n1549#2:953\n1620#2,2:954\n1549#2:956\n1620#2,3:957\n1622#2:960\n1549#2:964\n1620#2,3:965\n453#3:822\n403#3:823\n372#3,7:846\n453#3:915\n403#3:916\n372#3,7:939\n1#4:882\n1#4:961\n55#5:962\n43#5:963\n*S KotlinDebug\n*F\n+ 1 KoboController.kt\norg/gotson/komga/interfaces/api/kobo/KoboController\n*L\n336#1:812\n336#1:813,3\n336#1:816,2\n336#1:818,4\n337#1:824,4\n338#1:828\n338#1:829,3\n338#1:832,2\n338#1:834,4\n339#1:838\n339#1:839,3\n339#1:842\n339#1:843,3\n339#1:853,3\n343#1:856\n343#1:857,3\n354#1:860\n354#1:861,3\n365#1:864\n365#1:865,3\n370#1:868\n370#1:869,3\n381#1:872,9\n381#1:881\n381#1:883\n381#1:884\n392#1:885\n392#1:886,2\n393#1:888\n393#1:889,3\n392#1:892\n397#1:893\n397#1:894,2\n398#1:896\n398#1:897,3\n397#1:900\n402#1:901\n402#1:902,3\n429#1:905\n429#1:906,3\n429#1:909,2\n429#1:911,4\n430#1:917,4\n431#1:921\n431#1:922,3\n431#1:925,2\n431#1:927,4\n432#1:931\n432#1:932,3\n432#1:935\n432#1:936,3\n432#1:946,3\n436#1:949\n436#1:950,3\n447#1:953\n447#1:954,2\n448#1:956\n448#1:957,3\n447#1:960\n503#1:964\n503#1:965,3\n337#1:822\n337#1:823\n339#1:846,7\n430#1:915\n430#1:916\n432#1:939,7\n381#1:882\n459#1:962\n459#1:963\n*E\n"})
public class KoboController {
    @NotNull
    private final KoboProxy koboProxy;
    @NotNull
    private final KepubConverter kepubConverter;
    @NotNull
    private final SyncPointLifecycle syncPointLifecycle;
    @NotNull
    private final SyncPointRepository syncPointRepository;
    @NotNull
    private final KomgaSyncTokenGenerator komgaSyncTokenGenerator;
    @NotNull
    private final KomgaProperties komgaProperties;
    @NotNull
    private final KoboDtoRepository koboDtoRepository;
    @NotNull
    private final ObjectMapper mapper;
    @NotNull
    private final CommonBookController commonBookController;
    @NotNull
    private final BookLifecycle bookLifecycle;
    @NotNull
    private final BookRepository bookRepository;
    @NotNull
    private final ThumbnailBookRepository thumbnailBookRepository;
    @NotNull
    private final ReadProgressRepository readProgressRepository;
    @NotNull
    private final ImageConverter imageConverter;
    @NotNull
    private final MediaRepository mediaRepository;
    @NotNull
    private final ContentRestrictionChecker contentRestrictionChecker;
    private final Cache<String, Path> cachedKepub;

    public KoboController(@NotNull KoboProxy koboProxy, @NotNull KepubConverter kepubConverter, @NotNull SyncPointLifecycle syncPointLifecycle, @NotNull SyncPointRepository syncPointRepository, @NotNull KomgaSyncTokenGenerator komgaSyncTokenGenerator, @NotNull KomgaProperties komgaProperties, @NotNull KoboDtoRepository koboDtoRepository, @NotNull ObjectMapper mapper, @NotNull CommonBookController commonBookController, @NotNull BookLifecycle bookLifecycle, @NotNull BookRepository bookRepository, @NotNull ThumbnailBookRepository thumbnailBookRepository, @NotNull ReadProgressRepository readProgressRepository, @NotNull ImageConverter imageConverter, @NotNull MediaRepository mediaRepository, @NotNull ContentRestrictionChecker contentRestrictionChecker) {
        Intrinsics.checkNotNullParameter((Object)koboProxy, (String)"koboProxy");
        Intrinsics.checkNotNullParameter((Object)kepubConverter, (String)"kepubConverter");
        Intrinsics.checkNotNullParameter((Object)syncPointLifecycle, (String)"syncPointLifecycle");
        Intrinsics.checkNotNullParameter((Object)syncPointRepository, (String)"syncPointRepository");
        Intrinsics.checkNotNullParameter((Object)komgaSyncTokenGenerator, (String)"komgaSyncTokenGenerator");
        Intrinsics.checkNotNullParameter((Object)komgaProperties, (String)"komgaProperties");
        Intrinsics.checkNotNullParameter((Object)koboDtoRepository, (String)"koboDtoRepository");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)commonBookController, (String)"commonBookController");
        Intrinsics.checkNotNullParameter((Object)bookLifecycle, (String)"bookLifecycle");
        Intrinsics.checkNotNullParameter((Object)bookRepository, (String)"bookRepository");
        Intrinsics.checkNotNullParameter((Object)thumbnailBookRepository, (String)"thumbnailBookRepository");
        Intrinsics.checkNotNullParameter((Object)readProgressRepository, (String)"readProgressRepository");
        Intrinsics.checkNotNullParameter((Object)imageConverter, (String)"imageConverter");
        Intrinsics.checkNotNullParameter((Object)mediaRepository, (String)"mediaRepository");
        Intrinsics.checkNotNullParameter((Object)contentRestrictionChecker, (String)"contentRestrictionChecker");
        this.koboProxy = koboProxy;
        this.kepubConverter = kepubConverter;
        this.syncPointLifecycle = syncPointLifecycle;
        this.syncPointRepository = syncPointRepository;
        this.komgaSyncTokenGenerator = komgaSyncTokenGenerator;
        this.komgaProperties = komgaProperties;
        this.koboDtoRepository = koboDtoRepository;
        this.mapper = mapper;
        this.commonBookController = commonBookController;
        this.bookLifecycle = bookLifecycle;
        this.bookRepository = bookRepository;
        this.thumbnailBookRepository = thumbnailBookRepository;
        this.readProgressRepository = readProgressRepository;
        this.imageConverter = imageConverter;
        this.mediaRepository = mediaRepository;
        this.contentRestrictionChecker = contentRestrictionChecker;
        this.cachedKepub = Caffeine.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).removalListener((arg_0, arg_1, arg_2) -> KoboController.cachedKepub$lambda$0((Function3)cachedKepub.1.INSTANCE, arg_0, arg_1, arg_2)).build();
    }

    @GetMapping(value={"ping"})
    @NotNull
    public String ping() {
        return "pong";
    }

    @GetMapping(value={"v1/initialization"})
    @NotNull
    public ResponseEntity<ResourcesDto> initialization(@PathVariable @NotNull String authToken) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        try {
            JsonNode jsonNode = (JsonNode)KoboProxy.proxyCurrentRequest$default((KoboProxy)this.koboProxy, null, (boolean)false, (int)3, null).getBody();
            stringArray = jsonNode != null ? jsonNode.get("Resources") : null;
        }
        catch (Exception e) {
            KoboControllerKt.access$getLogger$p().warn((Function0)initialization.resources.1.INSTANCE);
            stringArray = null;
        }
        String[] stringArray2 = stringArray;
        if (stringArray == null) {
            stringArray2 = this.koboProxy.getNativeKoboResources();
        }
        String[] resources2 = stringArray2;
        Intrinsics.checkNotNull((Object)resources2, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
        ObjectNode $this$initialization_u24lambda_u241 = (ObjectNode)resources2;
        boolean bl = false;
        $this$initialization_u24lambda_u241.put("image_host", ServletUriComponentsBuilder.fromCurrentContextPath().toUriString());
        String[] stringArray3 = new String[]{"kobo", authToken, "v1", "books", "{ImageId}", "thumbnail", "{Width}", "{Height}", "false", "image.jpg"};
        $this$initialization_u24lambda_u241.put("image_url_template", ServletUriComponentsBuilder.fromCurrentContextPath().pathSegment(stringArray3).build().toUriString());
        stringArray3 = new String[]{"kobo", authToken, "v1", "books", "{ImageId}", "thumbnail", "{Width}", "{Height}", "{Quality}", "{IsGreyscale}", "image.jpg"};
        $this$initialization_u24lambda_u241.put("image_url_quality_template", ServletUriComponentsBuilder.fromCurrentContextPath().pathSegment(stringArray3).build().toUriString());
        stringArray = new String[]{"e30="};
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("x-kobo-apitoken", stringArray)).body((Object)new ResourcesDto((JsonNode)resources2));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        return responseEntity;
    }

    @PostMapping(value={"v1/auth/device"})
    @NotNull
    public Object authDevice(@RequestBody @NotNull JsonNode body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        try {
            return KoboProxy.proxyCurrentRequest$default((KoboProxy)this.koboProxy, (Object)body, (boolean)false, (int)2, null);
        }
        catch (Exception e) {
            KoboControllerKt.access$getLogger$p().warn((Function0)authDevice.1.INSTANCE);
            String string = RandomStringUtils.randomAlphanumeric((int)24);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomAlphanumeric(...)");
            String string2 = RandomStringUtils.randomAlphanumeric((int)24);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"randomAlphanumeric(...)");
            String string3 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            JsonNode jsonNode = body.get("UserKey");
            String string4 = jsonNode != null ? jsonNode.asText() : null;
            if (string4 == null) {
                string4 = "";
            }
            return new AuthDto(string, string2, null, string3, string4, 4, null);
        }
    }

    @NotNull
    public TestsDto analyticsGetTests(@RequestHeader(name="X-Kobo-userkey", required=false) @Nullable String userKey) {
        String string = userKey;
        if (string == null) {
            string = "";
        }
        return new TestsDto("Success", string, null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"v1/library/sync"})
    @NotNull
    public ResponseEntity<Collection<Object>> syncLibrary(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String authToken) {
        KomgaSyncToken komgaSyncToken;
        Triple triple;
        Object object;
        Object it4;
        SyncPoint fromSyncPoint;
        SyncPoint toSyncPoint;
        block78: {
            Collection syncResultKomga2;
            boolean shouldContinueSync;
            KomgaSyncToken syncTokenReceived;
            block75: {
                ResponseEntity koboStoreResponse;
                Object readProgress;
                Object metadata;
                SyncPoint syncPoint;
                SyncPoint syncPoint2;
                Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
                Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
                KomgaSyncToken komgaSyncToken2 = this.komgaSyncTokenGenerator.fromRequestHeaders(UtilsKt.getCurrentRequest());
                KomgaSyncToken komgaSyncToken3 = komgaSyncToken2;
                if (komgaSyncToken3 == null) {
                    komgaSyncToken3 = new KomgaSyncToken(0, null, null, null, 15, null);
                }
                if ((syncPoint2 = (syncPoint = this.getSyncPointVerified((syncTokenReceived = komgaSyncToken3).getOngoingSyncPointId(), principal.getUser().getId()))) == null) {
                    ApiKey apiKey;
                    ApiKey apiKey2 = apiKey = principal.getApiKey();
                    syncPoint2 = this.syncPointLifecycle.createSyncPoint(principal.getUser(), apiKey2 != null ? apiKey2.getId() : null, null);
                }
                toSyncPoint = syncPoint2;
                fromSyncPoint = this.getSyncPointVerified(syncTokenReceived.getLastSuccessfulSyncPointId(), principal.getUser().getId());
                KoboControllerKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
                shouldContinueSync = false;
                UriBuilder downloadUriBuilder = this.getDownloadUrlBuilder(authToken);
                if (fromSyncPoint != null) {
                    SyncPoint.ReadList.Book b;
                    Collection<TagItemDto> collection;
                    boolean $i$f$mapTo;
                    Collection destination$iv$iv;
                    Object element$iv$iv;
                    Iterable $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv;
                    Collection collection2;
                    Iterable $this$mapTo$iv$iv;
                    Iterable $this$map$iv;
                    void $this$groupByTo$iv$iv;
                    Iterable $this$mapTo$iv$iv2;
                    void $this$map$iv2;
                    void $this$associateByTo$iv$iv;
                    void $this$mapTo$iv$iv3;
                    void $this$map$iv3;
                    void $this$mapValuesTo$iv$iv;
                    void $this$mapValues$iv;
                    void $this$associateByTo$iv$iv2;
                    void $this$mapTo$iv$iv4;
                    Page page;
                    Page readListsChanged;
                    Page readListsAdded;
                    Page changedReadingState;
                    Page booksRemoved;
                    maxRemainingCount = 0;
                    maxRemainingCount = this.komgaProperties.getKobo().getSyncItemLimit();
                    String string = fromSyncPoint.getId();
                    String string2 = toSyncPoint.getId();
                    Pageable pageable = Pageable.ofSize((int)maxRemainingCount);
                    Intrinsics.checkNotNullExpressionValue((Object)pageable, (String)"ofSize(...)");
                    it = pageable = this.syncPointLifecycle.takeBooksAdded(string, string2, pageable);
                    boolean bl = false;
                    shouldContinueSync = it.hasNext();
                    Pageable booksAdded = pageable;
                    if (booksAdded.isLast() && (maxRemainingCount -= it.getNumberOfElements()) > 0) {
                        String string3 = fromSyncPoint.getId();
                        String string4 = toSyncPoint.getId();
                        it = Pageable.ofSize((int)maxRemainingCount);
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"ofSize(...)");
                        Pageable it2 = it = this.syncPointLifecycle.takeBooksChanged(string3, string4, it);
                        boolean bl2 = false;
                        maxRemainingCount -= it2.getNumberOfElements();
                        shouldContinueSync = shouldContinueSync || it2.hasNext();
                        v7 = it;
                    } else {
                        it = Page.empty();
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"empty(...)");
                        v7 = booksChanged = it;
                    }
                    if (booksChanged.isLast() && maxRemainingCount > 0) {
                        String string5 = fromSyncPoint.getId();
                        String string6 = toSyncPoint.getId();
                        it2 = Pageable.ofSize((int)maxRemainingCount);
                        Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"ofSize(...)");
                        Object it3 = it2 = this.syncPointLifecycle.takeBooksRemoved(string5, string6, (Pageable)it2);
                        boolean bl3 = false;
                        maxRemainingCount -= it3.getNumberOfElements();
                        shouldContinueSync = shouldContinueSync || it3.hasNext();
                        v10 = it2;
                    } else {
                        it2 = Page.empty();
                        Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"empty(...)");
                        v10 = booksRemoved = it2;
                    }
                    if (booksRemoved.isLast() && maxRemainingCount > 0) {
                        String string7 = fromSyncPoint.getId();
                        String string8 = toSyncPoint.getId();
                        it3 = Pageable.ofSize((int)maxRemainingCount);
                        Intrinsics.checkNotNullExpressionValue((Object)it3, (String)"ofSize(...)");
                        Page it4 = it3 = this.syncPointLifecycle.takeBooksReadProgressChanged(string7, string8, (Pageable)it3);
                        boolean bl4 = false;
                        maxRemainingCount -= it4.getNumberOfElements();
                        shouldContinueSync = shouldContinueSync || it4.hasNext();
                        v13 = it3;
                    } else {
                        it3 = Page.empty();
                        Intrinsics.checkNotNullExpressionValue((Object)it3, (String)"empty(...)");
                        v13 = changedReadingState = it3;
                    }
                    if (changedReadingState.isLast() && maxRemainingCount > 0) {
                        String string9 = fromSyncPoint.getId();
                        String string10 = toSyncPoint.getId();
                        it4 = Pageable.ofSize((int)maxRemainingCount);
                        Intrinsics.checkNotNullExpressionValue((Object)it4, (String)"ofSize(...)");
                        Page it5 = it4 = this.syncPointLifecycle.takeReadListsAdded(string9, string10, (Pageable)it4);
                        boolean bl5 = false;
                        maxRemainingCount -= it5.getNumberOfElements();
                        shouldContinueSync = shouldContinueSync || it5.hasNext();
                        v16 = it4;
                    } else {
                        it4 = Page.empty();
                        Intrinsics.checkNotNullExpressionValue((Object)it4, (String)"empty(...)");
                        v16 = readListsAdded = it4;
                    }
                    if (readListsAdded.isLast() && maxRemainingCount > 0) {
                        String string11 = fromSyncPoint.getId();
                        String string12 = toSyncPoint.getId();
                        it5 = Pageable.ofSize((int)maxRemainingCount);
                        Intrinsics.checkNotNullExpressionValue((Object)it5, (String)"ofSize(...)");
                        Page it6 = it5 = this.syncPointLifecycle.takeReadListsChanged(string11, string12, (Pageable)it5);
                        boolean bl6 = false;
                        maxRemainingCount -= it6.getNumberOfElements();
                        shouldContinueSync = shouldContinueSync || it6.hasNext();
                        v19 = it5;
                    } else {
                        it5 = Page.empty();
                        Intrinsics.checkNotNullExpressionValue((Object)it5, (String)"empty(...)");
                        v19 = readListsChanged = it5;
                    }
                    if (readListsChanged.isLast() && maxRemainingCount > 0) {
                        String string13 = fromSyncPoint.getId();
                        String string14 = toSyncPoint.getId();
                        it6 = Pageable.ofSize((int)maxRemainingCount);
                        Intrinsics.checkNotNullExpressionValue((Object)it6, (String)"ofSize(...)");
                        Page it7 = it6 = this.syncPointLifecycle.takeReadListsRemoved(string13, string14, (Pageable)it6);
                        boolean bl7 = false;
                        maxRemainingCount -= it7.getNumberOfElements();
                        shouldContinueSync = shouldContinueSync || it7.hasNext();
                        page = it6;
                    } else {
                        it6 = Page.empty();
                        Intrinsics.checkNotNullExpressionValue((Object)it6, (String)"empty(...)");
                        page = it6;
                    }
                    Page readListsRemoved = page;
                    KoboControllerKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
                    Iterable it7 = booksAdded.getContent();
                    Intrinsics.checkNotNullExpressionValue((Object)it7, (String)"getContent(...)");
                    Collection collection3 = it7;
                    it7 = booksChanged.getContent();
                    Intrinsics.checkNotNullExpressionValue((Object)it7, (String)"getContent(...)");
                    it7 = CollectionsKt.plus((Collection)collection3, (Iterable)it7);
                    var47_66 = this.koboDtoRepository;
                    boolean $i$f$map = false;
                    void var20_67 = $this$map$iv;
                    Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv4) {
                        void it8;
                        SyncPoint.Book book = (SyncPoint.Book)item$iv$iv;
                        var48_128 = destination$iv$iv2;
                        boolean bl8 = false;
                        var49_129 = it8.getBookId();
                        var48_128.add(var49_129);
                    }
                    var48_128 = (List)destination$iv$iv2;
                    Object $this$associateBy$iv = var47_66.findBookMetadataByIds((Collection)var48_128);
                    boolean $i$f$associateBy = false;
                    int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                    destination$iv$iv2 = $this$associateBy$iv;
                    Map destination$iv$iv3 = new LinkedHashMap(capacity$iv22);
                    boolean $i$f$associateByTo = false;
                    for (Object element$iv$iv2 : $this$associateByTo$iv$iv2) {
                        void it9;
                        KoboBookMetadataDto bl8 = (KoboBookMetadataDto)element$iv$iv2;
                        var47_66 = destination$iv$iv3;
                        boolean bl9 = false;
                        var48_128 = it9.getEntitlementId();
                        var47_66.put(var48_128, element$iv$iv2);
                    }
                    $this$associateBy$iv = destination$iv$iv3;
                    boolean $i$f$mapValues22 = false;
                    void capacity$iv22 = $this$mapValues$iv;
                    destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                    boolean $i$f$mapValuesTo = false;
                    Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                    boolean $i$f$associateByTo2 = false;
                    for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                        void it10;
                        void it$iv$iv;
                        Map.Entry bl9 = (Map.Entry)element$iv$iv$iv;
                        Object object2 = destination$iv$iv2;
                        boolean bl10 = false;
                        Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                        var48_128 = it$iv$iv.getKey();
                        var47_66 = object2;
                        boolean bl11 = false;
                        var49_129 = this.withDownloadUrls((KoboBookMetadataDto)it10.getValue(), downloadUriBuilder);
                        var47_66.put(var48_128, var49_129);
                    }
                    Object metadata2 = destination$iv$iv2;
                    Iterable $i$f$mapValues22 = booksAdded.getContent();
                    Intrinsics.checkNotNullExpressionValue((Object)$i$f$mapValues22, (String)"getContent(...)");
                    Collection collection4 = $i$f$mapValues22;
                    $i$f$mapValues22 = booksChanged.getContent();
                    Intrinsics.checkNotNullExpressionValue((Object)$i$f$mapValues22, (String)"getContent(...)");
                    Collection collection5 = CollectionsKt.plus((Collection)collection4, (Iterable)$i$f$mapValues22);
                    $i$f$mapValues22 = changedReadingState.getContent();
                    Intrinsics.checkNotNullExpressionValue((Object)$i$f$mapValues22, (String)"getContent(...)");
                    $i$f$mapValues22 = CollectionsKt.plus((Collection)collection5, (Iterable)$i$f$mapValues22);
                    var47_66 = this.readProgressRepository;
                    boolean $i$f$map2 = false;
                    destination$iv$iv2 = $this$map$iv3;
                    Iterable destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                    boolean $i$f$mapTo3 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                        void it11;
                        SyncPoint.Book element$iv$iv$iv = (SyncPoint.Book)item$iv$iv;
                        var48_128 = destination$iv$iv22;
                        boolean bl12 = false;
                        var49_129 = it11.getBookId();
                        var48_128.add(var49_129);
                    }
                    var48_128 = (List)destination$iv$iv22;
                    Iterable $this$associateBy$iv2 = var47_66.findAllByBookIdsAndUserId((Collection)var48_128, principal.getUser().getId());
                    boolean $i$f$associateBy22 = false;
                    int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv2, (int)10)), (int)16);
                    destination$iv$iv22 = $this$associateBy$iv2;
                    Object destination$iv$iv4 = new LinkedHashMap(capacity$iv);
                    $i$f$associateByTo = false;
                    for (Object element$iv$iv3 : $this$associateByTo$iv$iv) {
                        void it12;
                        ReadProgress bl12 = (ReadProgress)element$iv$iv3;
                        var47_66 = destination$iv$iv4;
                        boolean bl13 = false;
                        var48_128 = it12.getBookId();
                        var47_66.put(var48_128, element$iv$iv3);
                    }
                    Map readProgress2 = destination$iv$iv4;
                    String string15 = toSyncPoint.getId();
                    Iterable $i$f$associateBy22 = readListsAdded.getContent();
                    Intrinsics.checkNotNullExpressionValue((Object)$i$f$associateBy22, (String)"getContent(...)");
                    Collection collection6 = $i$f$associateBy22;
                    $i$f$associateBy22 = readListsChanged.getContent();
                    Intrinsics.checkNotNullExpressionValue((Object)$i$f$associateBy22, (String)"getContent(...)");
                    $i$f$associateBy22 = CollectionsKt.plus((Collection)collection6, (Iterable)$i$f$associateBy22);
                    var48_128 = string15;
                    var47_66 = this.syncPointRepository;
                    boolean $i$f$map3 = false;
                    $this$associateByTo$iv$iv = $this$map$iv2;
                    destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo4 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        SyncPoint.ReadList it12 = (SyncPoint.ReadList)item$iv$iv;
                        var49_129 = destination$iv$iv4;
                        boolean bl14 = false;
                        var50_161 = it12.getReadListId();
                        var49_129.add(var50_161);
                    }
                    var49_129 = (List)destination$iv$iv4;
                    Iterable $this$groupBy$iv = var47_66.findBookIdsByReadListIds((String)var48_128, (Collection)var49_129);
                    boolean $i$f$groupBy = false;
                    $this$mapTo$iv$iv2 = $this$groupBy$iv;
                    destination$iv$iv4 = new LinkedHashMap();
                    boolean $i$f$groupByTo22 = false;
                    for (Object element$iv$iv4 : $this$groupByTo$iv$iv) {
                        Object object3;
                        SyncPoint.ReadList.Book it13 = (SyncPoint.ReadList.Book)element$iv$iv4;
                        boolean bl15 = false;
                        String key$iv$iv = it13.getReadListId();
                        Object $this$getOrPut$iv$iv$iv = destination$iv$iv4;
                        boolean $i$f$getOrPut = false;
                        Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl16 = false;
                            List answer$iv$iv$iv = new ArrayList();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object3 = answer$iv$iv$iv;
                        } else {
                            object3 = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object3;
                        list$iv$iv.add(element$iv$iv4);
                    }
                    Object readListsBooks = destination$iv$iv4;
                    Iterable $this$syncLibrary_u24lambda_u2427 = $this$groupBy$iv = CollectionsKt.createListBuilder();
                    boolean bl17 = false;
                    List list = booksAdded.getContent();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
                    destination$iv$iv4 = list;
                    Iterable $i$f$groupByTo22 = $this$syncLibrary_u24lambda_u2427;
                    boolean $i$f$map4 = false;
                    void element$iv$iv4 = $this$map$iv;
                    Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo5 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it14;
                        SyncPoint.Book $i$f$getOrPut = (SyncPoint.Book)item$iv$iv;
                        collection2 = destination$iv$iv5;
                        boolean bl18 = false;
                        Intrinsics.checkNotNull((Object)it14);
                        BookEntitlementDto bookEntitlementDto = BookEntitlementDtoKt.toBookEntitlementDto((SyncPoint.Book)it14, (boolean)false);
                        Object v = metadata2.get(it14.getBookId());
                        Intrinsics.checkNotNull(v);
                        KoboBookMetadataDto koboBookMetadataDto = (KoboBookMetadataDto)v;
                        ReadProgress readProgress3 = (ReadProgress)readProgress2.get(it14.getBookId());
                        if (readProgress3 == null || (readProgress3 = ReadingStateDtoKt.toDto((ReadProgress)readProgress3)) == null) {
                            readProgress3 = this.getEmptyReadProgressForBook(it14.getBookId(), it14.getCreatedDate());
                        }
                        collection2.add(new NewEntitlementDto(new BookEntitlementContainerDto(bookEntitlementDto, koboBookMetadataDto, (ReadingStateDto)readProgress3)));
                    }
                    $i$f$groupByTo22.addAll((List)destination$iv$iv5);
                    List list2 = booksChanged.getContent();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContent(...)");
                    $this$map$iv = list2;
                    $i$f$groupByTo22 = $this$syncLibrary_u24lambda_u2427;
                    $i$f$map4 = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo5 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        SyncPoint.Book it14 = (SyncPoint.Book)item$iv$iv;
                        collection2 = destination$iv$iv5;
                        boolean bl19 = false;
                        Intrinsics.checkNotNull((Object)it14);
                        BookEntitlementDto bookEntitlementDto = BookEntitlementDtoKt.toBookEntitlementDto((SyncPoint.Book)it14, (boolean)false);
                        Object v = metadata2.get(it14.getBookId());
                        Intrinsics.checkNotNull(v);
                        KoboBookMetadataDto koboBookMetadataDto = (KoboBookMetadataDto)v;
                        ReadProgress readProgress4 = (ReadProgress)readProgress2.get(it14.getBookId());
                        if (readProgress4 == null || (readProgress4 = ReadingStateDtoKt.toDto((ReadProgress)readProgress4)) == null) {
                            readProgress4 = this.getEmptyReadProgressForBook(it14.getBookId(), it14.getCreatedDate());
                        }
                        collection2.add(new NewEntitlementDto(new BookEntitlementContainerDto(bookEntitlementDto, koboBookMetadataDto, (ReadingStateDto)readProgress4)));
                    }
                    $i$f$groupByTo22.addAll((List)destination$iv$iv5);
                    List list3 = booksChanged.getContent();
                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getContent(...)");
                    $this$map$iv = list3;
                    $i$f$groupByTo22 = $this$syncLibrary_u24lambda_u2427;
                    $i$f$map4 = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo5 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        SyncPoint.Book it15 = (SyncPoint.Book)item$iv$iv;
                        collection2 = destination$iv$iv5;
                        boolean bl20 = false;
                        Object v = metadata2.get(it15.getBookId());
                        Intrinsics.checkNotNull(v);
                        collection2.add(new ChangedProductMetadataDto((KoboBookMetadataDto)v));
                    }
                    $i$f$groupByTo22.addAll((List)destination$iv$iv5);
                    List list4 = booksRemoved.getContent();
                    Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getContent(...)");
                    $this$map$iv = list4;
                    $i$f$groupByTo22 = $this$syncLibrary_u24lambda_u2427;
                    $i$f$map4 = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo5 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        SyncPoint.Book it16 = (SyncPoint.Book)item$iv$iv;
                        collection2 = destination$iv$iv5;
                        boolean bl21 = false;
                        Intrinsics.checkNotNull((Object)it16);
                        collection2.add(new ChangedEntitlementDto(new BookEntitlementContainerDto(BookEntitlementDtoKt.toBookEntitlementDto((SyncPoint.Book)it16, (boolean)true), this.getMetadataForRemovedBook(it16.getBookId()), null, 4, null)));
                    }
                    $i$f$groupByTo22.addAll((List)destination$iv$iv5);
                    List list5 = booksChanged.getContent();
                    Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"getContent(...)");
                    Collection collection7 = list5;
                    List list6 = changedReadingState.getContent();
                    Intrinsics.checkNotNullExpressionValue((Object)list6, (String)"getContent(...)");
                    $this$map$iv = CollectionsKt.plus((Collection)collection7, (Iterable)list6);
                    $i$f$groupByTo22 = $this$syncLibrary_u24lambda_u2427;
                    boolean $i$f$mapNotNull = false;
                    $this$mapTo$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv5 = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    SyncPoint.ReadList it17 = $this$forEach$iv$iv$iv.iterator();
                    while (it17.hasNext()) {
                        ChangedReadingStateDto changedReadingStateDto;
                        Object element$iv$iv$iv;
                        element$iv$iv = element$iv$iv$iv = it17.next();
                        boolean bl22 = false;
                        SyncPoint.Book book = (SyncPoint.Book)element$iv$iv;
                        boolean bl23 = false;
                        if ((ReadProgress)readProgress2.get(book.getBookId()) != null) {
                            ReadProgress it18;
                            boolean bl24 = false;
                            changedReadingStateDto = new ChangedReadingStateDto(new WrappedReadingStateDto(ReadingStateDtoKt.toDto((ReadProgress)it18)));
                        } else {
                            changedReadingStateDto = null;
                        }
                        if (changedReadingStateDto == null) continue;
                        ChangedReadingStateDto it$iv$iv = changedReadingStateDto;
                        boolean bl25 = false;
                        destination$iv$iv5.add(it$iv$iv);
                    }
                    $i$f$groupByTo22.addAll((List)destination$iv$iv5);
                    List list7 = readListsAdded.getContent();
                    Intrinsics.checkNotNullExpressionValue((Object)list7, (String)"getContent(...)");
                    $this$mapNotNull$iv = list7;
                    $i$f$groupByTo22 = $this$syncLibrary_u24lambda_u2427;
                    $i$f$map4 = false;
                    $this$mapNotNullTo$iv$iv = $this$map$iv;
                    destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo5 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        List list8;
                        it17 = (SyncPoint.ReadList)item$iv$iv;
                        collection2 = destination$iv$iv5;
                        boolean bl26 = false;
                        Intrinsics.checkNotNull((Object)it17);
                        SyncPoint.ReadList readList = it17;
                        List list9 = (List)readListsBooks.get(it17.getReadListId());
                        if (list9 != null) {
                            void $this$mapTo$iv$iv5;
                            element$iv$iv = list9;
                            SyncPoint.ReadList bl22 = readList;
                            boolean $i$f$map5 = false;
                            void bl24 = $this$map$iv;
                            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            $i$f$mapTo = false;
                            for (Object item$iv$iv2 : $this$mapTo$iv$iv5) {
                                SyncPoint.ReadList.Book book = (SyncPoint.ReadList.Book)item$iv$iv2;
                                collection = destination$iv$iv;
                                boolean bl27 = false;
                                collection.add(new TagItemDto(b.getBookId(), null, 2, null));
                            }
                            collection = (List)destination$iv$iv;
                            readList = bl22;
                            list8 = collection;
                        } else {
                            list8 = null;
                        }
                        WrappedTagDto wrappedTagDto = TagDtoKt.toWrappedTagDto((SyncPoint.ReadList)readList, list8);
                        collection2.add(new NewTagDto(wrappedTagDto));
                    }
                    $i$f$groupByTo22.addAll((List)destination$iv$iv5);
                    List list10 = readListsChanged.getContent();
                    Intrinsics.checkNotNullExpressionValue((Object)list10, (String)"getContent(...)");
                    $this$map$iv = list10;
                    $i$f$groupByTo22 = $this$syncLibrary_u24lambda_u2427;
                    $i$f$map4 = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo5 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        Collection<TagItemDto> collection8;
                        it17 = (SyncPoint.ReadList)item$iv$iv;
                        collection2 = destination$iv$iv5;
                        boolean bl28 = false;
                        Intrinsics.checkNotNull((Object)it17);
                        SyncPoint.ReadList readList = it17;
                        List list11 = (List)readListsBooks.get(it17.getReadListId());
                        if (list11 != null) {
                            $this$map$iv = list11;
                            SyncPoint.ReadList bl22 = readList;
                            boolean $i$f$map6 = false;
                            Iterable $this$mapTo$iv$iv5 = $this$map$iv;
                            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            $i$f$mapTo = false;
                            for (Object item$iv$iv2 : $this$mapTo$iv$iv5) {
                                b = (SyncPoint.ReadList.Book)item$iv$iv2;
                                collection = destination$iv$iv;
                                boolean bl29 = false;
                                collection.add(new TagItemDto(b.getBookId(), null, 2, null));
                            }
                            collection = (List)destination$iv$iv;
                            readList = bl22;
                            collection8 = collection;
                        } else {
                            collection8 = null;
                        }
                        WrappedTagDto wrappedTagDto = TagDtoKt.toWrappedTagDto((SyncPoint.ReadList)readList, collection8);
                        collection2.add(new ChangedTagDto(wrappedTagDto));
                    }
                    $i$f$groupByTo22.addAll((List)destination$iv$iv5);
                    List list12 = readListsRemoved.getContent();
                    Intrinsics.checkNotNullExpressionValue((Object)list12, (String)"getContent(...)");
                    $this$map$iv = list12;
                    $i$f$groupByTo22 = $this$syncLibrary_u24lambda_u2427;
                    $i$f$map4 = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo5 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        it17 = (SyncPoint.ReadList)item$iv$iv;
                        collection2 = destination$iv$iv5;
                        boolean bl30 = false;
                        Intrinsics.checkNotNull((Object)it17);
                        collection2.add(new DeletedTagDto(TagDtoKt.toWrappedTagDto$default((SyncPoint.ReadList)it17, null, (int)1, null)));
                    }
                    $i$f$groupByTo22.addAll((List)destination$iv$iv5);
                    v55 = CollectionsKt.build((List)$this$groupBy$iv);
                } else {
                    Collection collection;
                    Iterable $this$mapTo$iv$iv;
                    void $this$groupByTo$iv$iv;
                    Iterable $this$mapTo$iv$iv6;
                    void $this$map$iv;
                    void $this$associateByTo$iv$iv;
                    void $this$mapTo$iv$iv7;
                    void $this$map$iv4;
                    void $this$mapValuesTo$iv$iv;
                    void $this$mapValues$iv;
                    void $this$associateByTo$iv$iv3;
                    void $this$mapTo$iv$iv8;
                    void $this$map$iv5;
                    Pageable pageable;
                    maxRemainingCount = 0;
                    maxRemainingCount = this.komgaProperties.getKobo().getSyncItemLimit();
                    String string = toSyncPoint.getId();
                    booksChanged = Pageable.ofSize((int)maxRemainingCount);
                    Intrinsics.checkNotNullExpressionValue((Object)booksChanged, (String)"ofSize(...)");
                    it = booksChanged = this.syncPointLifecycle.takeBooks(string, booksChanged);
                    boolean bl = false;
                    shouldContinueSync = it.hasNext();
                    Pageable books = booksChanged;
                    if (books.isLast() && (maxRemainingCount -= it.getNumberOfElements()) > 0) {
                        String string16 = toSyncPoint.getId();
                        it = Pageable.ofSize((int)maxRemainingCount);
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"ofSize(...)");
                        Pageable it19 = it = this.syncPointLifecycle.takeReadLists(string16, it);
                        boolean bl31 = false;
                        maxRemainingCount -= it19.getNumberOfElements();
                        shouldContinueSync = shouldContinueSync || it19.hasNext();
                        pageable = it;
                    } else {
                        it = Page.empty();
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"empty(...)");
                        pageable = it;
                    }
                    Pageable readLists = pageable;
                    KoboControllerKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
                    it2 = books.getContent();
                    Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"getContent(...)");
                    it2 = (Iterable)it2;
                    var47_66 = this.koboDtoRepository;
                    boolean $i$f$map = false;
                    void readListsChanged = $this$map$iv5;
                    Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv5, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv8) {
                        void it20;
                        SyncPoint.Book $this$groupBy$iv = (SyncPoint.Book)item$iv$iv;
                        var48_128 = destination$iv$iv;
                        boolean bl32 = false;
                        var49_129 = it20.getBookId();
                        var48_128.add(var49_129);
                    }
                    var48_128 = (List)destination$iv$iv;
                    Object $this$associateBy$iv = var47_66.findBookMetadataByIds((Collection)var48_128);
                    boolean $i$f$associateBy = false;
                    int capacity$iv32 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                    destination$iv$iv = $this$associateBy$iv;
                    Map destination$iv$iv6 = new LinkedHashMap(capacity$iv32);
                    boolean $i$f$associateByTo = false;
                    for (Object element$iv$iv : $this$associateByTo$iv$iv3) {
                        void it21;
                        KoboBookMetadataDto bl32 = (KoboBookMetadataDto)element$iv$iv;
                        var47_66 = destination$iv$iv6;
                        boolean bl33 = false;
                        var48_128 = it21.getEntitlementId();
                        var47_66.put(var48_128, element$iv$iv);
                    }
                    $this$associateBy$iv = destination$iv$iv6;
                    boolean $i$f$mapValues32 = false;
                    void capacity$iv32 = $this$mapValues$iv;
                    destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                    boolean $i$f$mapValuesTo = false;
                    Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                    boolean $i$f$associateByTo3 = false;
                    for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                        void it22;
                        void it$iv$iv;
                        Map.Entry bl33 = (Map.Entry)element$iv$iv$iv;
                        Object $this$map$iv6 = destination$iv$iv;
                        boolean bl34 = false;
                        Map.Entry $i$f$map7 = (Map.Entry)element$iv$iv$iv;
                        var48_128 = it$iv$iv.getKey();
                        var47_66 = $this$map$iv6;
                        boolean bl35 = false;
                        var49_129 = this.withDownloadUrls((KoboBookMetadataDto)it22.getValue(), downloadUriBuilder);
                        var47_66.put(var48_128, var49_129);
                    }
                    metadata = destination$iv$iv;
                    Iterable $i$f$mapValues32 = books.getContent();
                    Intrinsics.checkNotNullExpressionValue((Object)$i$f$mapValues32, (String)"getContent(...)");
                    $i$f$mapValues32 = $i$f$mapValues32;
                    var47_66 = this.readProgressRepository;
                    boolean $i$f$map8 = false;
                    destination$iv$iv = $this$map$iv4;
                    Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
                    boolean $i$f$mapTo6 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv7) {
                        void it23;
                        SyncPoint.Book element$iv$iv$iv = (SyncPoint.Book)item$iv$iv;
                        var48_128 = destination$iv$iv3;
                        boolean bl36 = false;
                        var49_129 = it23.getBookId();
                        var48_128.add(var49_129);
                    }
                    var48_128 = (List)destination$iv$iv3;
                    Iterable $this$associateBy$iv3 = var47_66.findAllByBookIdsAndUserId((Collection)var48_128, principal.getUser().getId());
                    boolean $i$f$associateBy32 = false;
                    int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv3, (int)10)), (int)16);
                    destination$iv$iv3 = $this$associateBy$iv3;
                    Object destination$iv$iv7 = new LinkedHashMap(capacity$iv);
                    $i$f$associateByTo = false;
                    for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                        void it24;
                        ReadProgress bl36 = (ReadProgress)element$iv$iv;
                        var47_66 = destination$iv$iv7;
                        boolean bl37 = false;
                        var48_128 = it24.getBookId();
                        var47_66.put(var48_128, element$iv$iv);
                    }
                    readProgress = destination$iv$iv7;
                    String string17 = toSyncPoint.getId();
                    Iterable $i$f$associateBy32 = readLists.getContent();
                    Intrinsics.checkNotNullExpressionValue((Object)$i$f$associateBy32, (String)"getContent(...)");
                    $i$f$associateBy32 = $i$f$associateBy32;
                    var48_128 = string17;
                    var47_66 = this.syncPointRepository;
                    boolean $i$f$map9 = false;
                    $this$associateByTo$iv$iv = $this$map$iv;
                    destination$iv$iv7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo7 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv6) {
                        SyncPoint.ReadList it24 = (SyncPoint.ReadList)item$iv$iv;
                        var49_129 = destination$iv$iv7;
                        boolean bl38 = false;
                        var50_161 = it24.getReadListId();
                        var49_129.add(var50_161);
                    }
                    var49_129 = (List)destination$iv$iv7;
                    Iterable $this$groupBy$iv = var47_66.findBookIdsByReadListIds((String)var48_128, (Collection)var49_129);
                    boolean $i$f$groupBy = false;
                    $this$mapTo$iv$iv6 = $this$groupBy$iv;
                    destination$iv$iv7 = new LinkedHashMap();
                    boolean $i$f$groupByTo32 = false;
                    for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                        Object object4;
                        SyncPoint.ReadList.Book it25 = (SyncPoint.ReadList.Book)element$iv$iv;
                        boolean bl39 = false;
                        String key$iv$iv = it25.getReadListId();
                        Object $this$getOrPut$iv$iv$iv = destination$iv$iv7;
                        boolean $i$f$getOrPut = false;
                        Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl40 = false;
                            List answer$iv$iv$iv = new ArrayList();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object4 = answer$iv$iv$iv;
                        } else {
                            object4 = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object4;
                        list$iv$iv.add(element$iv$iv);
                    }
                    Object readListsBooks = destination$iv$iv7;
                    Iterable $this$syncLibrary_u24lambda_u2440 = $this$groupBy$iv = CollectionsKt.createListBuilder();
                    boolean bl41 = false;
                    List list = books.getContent();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
                    destination$iv$iv7 = list;
                    Iterable $i$f$groupByTo32 = $this$syncLibrary_u24lambda_u2440;
                    boolean $i$f$map10 = false;
                    void element$iv$iv = $this$map$iv;
                    Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo8 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it26;
                        SyncPoint.Book $i$f$getOrPut = (SyncPoint.Book)item$iv$iv;
                        collection = destination$iv$iv4;
                        boolean bl42 = false;
                        Intrinsics.checkNotNull((Object)it26);
                        BookEntitlementDto bookEntitlementDto = BookEntitlementDtoKt.toBookEntitlementDto((SyncPoint.Book)it26, (boolean)false);
                        Object v = metadata.get(it26.getBookId());
                        Intrinsics.checkNotNull(v);
                        KoboBookMetadataDto koboBookMetadataDto = (KoboBookMetadataDto)v;
                        ReadProgress readProgress5 = (ReadProgress)readProgress.get(it26.getBookId());
                        if (readProgress5 == null || (readProgress5 = ReadingStateDtoKt.toDto((ReadProgress)readProgress5)) == null) {
                            readProgress5 = this.getEmptyReadProgressForBook(it26.getBookId(), it26.getCreatedDate());
                        }
                        collection.add(new NewEntitlementDto(new BookEntitlementContainerDto(bookEntitlementDto, koboBookMetadataDto, (ReadingStateDto)readProgress5)));
                    }
                    $i$f$groupByTo32.addAll((List)destination$iv$iv4);
                    List list13 = readLists.getContent();
                    Intrinsics.checkNotNullExpressionValue((Object)list13, (String)"getContent(...)");
                    $this$map$iv = list13;
                    $i$f$groupByTo32 = $this$syncLibrary_u24lambda_u2440;
                    $i$f$map10 = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo8 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        List list14;
                        SyncPoint.ReadList it26 = (SyncPoint.ReadList)item$iv$iv;
                        collection = destination$iv$iv4;
                        boolean bl43 = false;
                        Intrinsics.checkNotNull((Object)it26);
                        SyncPoint.ReadList readList = it26;
                        List list15 = (List)readListsBooks.get(it26.getReadListId());
                        if (list15 != null) {
                            Collection<TagItemDto> collection9;
                            void $this$mapTo$iv$iv9;
                            void $this$map$iv7;
                            $this$forEach$iv$iv$iv = list15;
                            SyncPoint.ReadList readList2 = readList;
                            boolean $i$f$map11 = false;
                            $this$map$iv = $this$map$iv7;
                            Collection destination$iv$iv8 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv7, (int)10));
                            boolean $i$f$mapTo9 = false;
                            for (Object item$iv$iv3 : $this$mapTo$iv$iv9) {
                                void b;
                                SyncPoint.ReadList.Book $this$mapTo$iv$iv10 = (SyncPoint.ReadList.Book)item$iv$iv3;
                                collection9 = destination$iv$iv8;
                                boolean bl44 = false;
                                collection9.add(new TagItemDto(b.getBookId(), null, 2, null));
                            }
                            collection9 = (List)destination$iv$iv8;
                            readList = readList2;
                            list14 = collection9;
                        } else {
                            list14 = null;
                        }
                        WrappedTagDto wrappedTagDto = TagDtoKt.toWrappedTagDto((SyncPoint.ReadList)readList, list14);
                        collection.add(new NewTagDto(wrappedTagDto));
                    }
                    $i$f$groupByTo32.addAll((List)destination$iv$iv4);
                    v55 = syncResultKomga2 = (Collection)CollectionsKt.build((List)$this$groupBy$iv);
                }
                if (shouldContinueSync || !this.koboProxy.isEnabled()) break block75;
                try {
                    String string;
                    Object object5;
                    KomgaSyncToken syncTokenKobo;
                    Object object6;
                    Object syncResultsKobo;
                    block77: {
                        Object object7;
                        block76: {
                            void $this$treeToValue$iv;
                            koboStoreResponse = KoboProxy.proxyCurrentRequest$default((KoboProxy)this.koboProxy, null, (boolean)true, (int)1, null);
                            metadata = (JsonNode)koboStoreResponse.getBody();
                            object7 = metadata;
                            if (object7 == null) break block76;
                            object = object7;
                            it4 = object;
                            boolean bl = false;
                            ObjectMapper bl41 = this.mapper;
                            TreeNode n$iv = (TreeNode)it4;
                            boolean $i$f$treeToValue = false;
                            boolean $i$f$jacksonTypeRef = false;
                            readProgress = (Collection)$this$treeToValue$iv.readValue($this$treeToValue$iv.treeAsTokens(n$iv), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                            object7 = readProgress;
                            if (object7 != null) break block77;
                        }
                        object7 = syncResultsKobo = (Collection)CollectionsKt.emptyList();
                    }
                    if ((object6 = (readProgress = (List)koboStoreResponse.getHeaders().get((Object)"x-kobo-synctoken"))) != null && (object6 = (object = (String)CollectionsKt.firstOrNull((List)object6))) != null) {
                        Object it27 = it4 = object6;
                        boolean bl = false;
                        v72 = this.komgaSyncTokenGenerator.fromBase64((String)it27);
                    } else {
                        v72 = syncTokenKobo = null;
                    }
                    if ((object5 = (object = (List)koboStoreResponse.getHeaders().get((Object)"X-Kobo-sync"))) != null && (object5 = (it4 = (String)CollectionsKt.firstOrNull((List)object5))) != null) {
                        String string18 = ((String)object5).toLowerCase(Locale.ROOT);
                        string = string18;
                        Intrinsics.checkNotNullExpressionValue((Object)string18, (String)"toLowerCase(...)");
                    } else {
                        string = null;
                    }
                    boolean shouldContinueSyncKobo = Intrinsics.areEqual(string, (Object)"continue");
                    List list = CollectionsKt.plus((Collection)syncResultKomga2, (Iterable)((Iterable)syncResultsKobo));
                    KomgaSyncToken komgaSyncToken4 = syncTokenKobo;
                    if (komgaSyncToken4 == null) {
                        komgaSyncToken4 = syncTokenReceived;
                    }
                    koboStoreResponse = new Triple((Object)list, (Object)komgaSyncToken4, (Object)shouldContinueSyncKobo);
                }
                catch (Exception e) {
                    KoboControllerKt.access$getLogger$p().error((Throwable)e, (Function0)syncLibrary.2.INSTANCE);
                    koboStoreResponse = new Triple((Object)syncResultKomga2, (Object)syncTokenReceived, (Object)false);
                }
                triple = koboStoreResponse;
                break block78;
            }
            triple = new Triple((Object)syncResultKomga2, (Object)syncTokenReceived, (Object)shouldContinueSync);
        }
        Triple triple2 = triple;
        Collection syncResultMerged = (Collection)triple2.component1();
        KomgaSyncToken syncTokenMerged = (KomgaSyncToken)triple2.component2();
        boolean shouldContinueSyncMerged = (Boolean)triple2.component3();
        if (shouldContinueSyncMerged) {
            komgaSyncToken = KomgaSyncToken.copy$default((KomgaSyncToken)syncTokenMerged, (int)0, null, (String)toSyncPoint.getId(), null, (int)11, null);
        } else {
            SyncPoint syncPoint = fromSyncPoint;
            if (syncPoint != null) {
                object = syncPoint;
                it4 = object;
                boolean bl = false;
                this.syncPointRepository.deleteOne(it4.getId());
                v81 = Unit.INSTANCE;
            } else {
                v81 = null;
            }
            komgaSyncToken = KomgaSyncToken.copy$default((KomgaSyncToken)syncTokenMerged, (int)0, null, null, (String)toSyncPoint.getId(), (int)3, null);
        }
        KomgaSyncToken syncTokenUpdated = komgaSyncToken;
        object = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(arg_0 -> KoboController.syncLibrary$lambda$44(shouldContinueSyncMerged, this, syncTokenUpdated, arg_0))).body((Object)syncResultMerged);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"body(...)");
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/v1/library/{bookId}/metadata"})
    @NotNull
    public ResponseEntity<?> getBookMetadata(@PathVariable @NotNull String authToken, @PathVariable @NotNull String bookId) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        if (!this.bookRepository.existsById(bookId) && this.koboProxy.isEnabled()) {
            responseEntity = KoboProxy.proxyCurrentRequest$default((KoboProxy)this.koboProxy, null, (boolean)false, (int)3, null);
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.koboDtoRepository.findBookMetadataByIds((Collection)CollectionsKt.listOf((Object)bookId));
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KoboBookMetadataDto koboBookMetadataDto = (KoboBookMetadataDto)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.withDownloadUrls((KoboBookMetadataDto)it, this.getDownloadUrlBuilder(authToken)));
            }
            ResponseEntity responseEntity2 = ResponseEntity.ok((Object)((List)destination$iv$iv));
            responseEntity = responseEntity2;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity2, (String)"ok(...)");
        }
        return responseEntity;
    }

    @GetMapping(value={"/v1/library/{bookId}/state"})
    @NotNull
    public ResponseEntity<?> getState(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        Book book = this.bookRepository.findByIdOrNull(bookId);
        if (book == null) {
            if (this.koboProxy.isEnabled()) {
                return KoboProxy.proxyCurrentRequest$default((KoboProxy)this.koboProxy, null, (boolean)false, (int)3, null);
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        Book book2 = book;
        ReadProgress readProgress = this.readProgressRepository.findByBookIdAndUserIdOrNull(bookId, principal.getUser().getId());
        if (readProgress == null || (readProgress = ReadingStateDtoKt.toDto((ReadProgress)readProgress)) == null) {
            readProgress = this.getEmptyReadProgressForBook(book2);
        }
        ReadProgress response2 = readProgress;
        ResponseEntity responseEntity = ResponseEntity.ok((Object)CollectionsKt.listOf((Object)response2));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @PutMapping(value={"/v1/library/{bookId}/state"})
    @NotNull
    public ResponseEntity<?> updateState(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String bookId, @RequestBody @NotNull ReadingStateStateUpdateDto body, @RequestHeader(name="X-Kobo-deviceid", required=false) @NotNull String koboDeviceId) {
        String string;
        R2Locator r2Locator;
        Object object;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)koboDeviceId, (String)"koboDeviceId");
        Book book = this.bookRepository.findByIdOrNull(bookId);
        if (book == null) {
            if (this.koboProxy.isEnabled()) {
                return KoboProxy.proxyCurrentRequest$default((KoboProxy)this.koboProxy, (Object)body, (boolean)false, (int)2, null);
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        Book book2 = book;
        ReadingStateDto readingStateDto = (ReadingStateDto)CollectionsKt.firstOrNull((Iterable)body.getReadingStates());
        if (readingStateDto == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        ReadingStateDto koboUpdate = readingStateDto;
        if (koboUpdate.getCurrentBookmark().getLocation() == null || koboUpdate.getCurrentBookmark().getContentSourceProgressPercent() == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        ZonedDateTime zonedDateTime = koboUpdate.getLastModified();
        Object object2 = principal.getApiKey();
        if (object2 == null || (object2 = object2.getId()) == null) {
            object2 = "unknown";
        }
        if ((object = principal.getApiKey()) == null || (object = object.getComment()) == null) {
            object = "unknown";
        }
        R2Device r2Device = new R2Device((String)object2, (String)object);
        if (koboUpdate.getStatusInfo().getStatus() == StatusDto.FINISHED) {
            var10_7 = this.mediaRepository.findExtensionByIdOrNull(book2.getId());
            MediaExtensionEpub mediaExtensionEpub = var10_7 instanceof MediaExtensionEpub ? (MediaExtensionEpub)var10_7 : null;
            if (mediaExtensionEpub == null) {
                throw new IllegalArgumentException("Epub extension not found");
            }
            epubExtension = mediaExtensionEpub;
            r2Locator = (R2Locator)CollectionsKt.last((List)epubExtension.getPositions());
        } else {
            epubExtension = koboUpdate.getCurrentBookmark().getLocation().getSource();
            string = StringsKt.contentEquals((CharSequence)koboUpdate.getCurrentBookmark().getLocation().getType(), (CharSequence)"kobospan", (boolean)true) ? koboUpdate.getCurrentBookmark().getLocation().getValue() : null;
            Float f = koboUpdate.getCurrentBookmark().getProgressPercent();
            var10_7 = new R2Locator.Location(null, Float.valueOf(koboUpdate.getCurrentBookmark().getContentSourceProgressPercent().floatValue() / (float)100), null, f != null ? Float.valueOf(f.floatValue() / (float)100) : null, 5, null);
            r2Locator = new R2Locator(epubExtension, "application/xhtml+xml", null, (R2Locator.Location)var10_7, null, string, 20, null);
        }
        R2Progression r2Progression = new R2Progression(zonedDateTime, r2Device, r2Locator);
        try {
            this.bookLifecycle.markProgression(book2, principal.getUser(), r2Progression);
            string = new RequestResultDto(ResultDto.SUCCESS, (Collection)CollectionsKt.listOf((Object)new ReadingStateUpdateResultDto(bookId, ResultDto.SUCCESS.wrapped(), ResultDto.IGNORED.wrapped(), ResultDto.SUCCESS.wrapped())));
        }
        catch (Exception e) {
            KoboControllerKt.access$getLogger$p().error((Throwable)e, (Function0)updateState.response.1.INSTANCE);
            string = new RequestResultDto(ResultDto.FAILURE, (Collection)CollectionsKt.listOf((Object)new ReadingStateUpdateResultDto(bookId, ResultDto.FAILURE.wrapped(), ResultDto.FAILURE.wrapped(), ResultDto.FAILURE.wrapped())));
        }
        String response2 = string;
        ResponseEntity responseEntity = ResponseEntity.ok((Object)response2);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    public static /* synthetic */ ResponseEntity updateState$default(KoboController koboController, KomgaPrincipal komgaPrincipal, String string, ReadingStateStateUpdateDto readingStateStateUpdateDto, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateState");
        }
        if ((n & 8) != 0) {
            string2 = "unknown";
        }
        return koboController.updateState(komgaPrincipal, string, readingStateStateUpdateDto, string2);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"v1/books/{bookId}/file/epub"}, produces={"application/octet-stream"})
    @PreAuthorize(value="hasRole('FILE_DOWNLOAD')")
    @NotNull
    public ResponseEntity<StreamingResponseBody> getBookFile(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String bookId, @RequestParam(name="convert_kepub", required=false) boolean convertToKepub) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        if (convertToKepub) {
            Book book = this.bookRepository.findByIdOrNull(bookId);
            if (book != null) {
                Ref.ObjectRef kepubPath;
                Book book2 = book;
                boolean bl = false;
                this.contentRestrictionChecker.checkContentRestriction(principal.getUser(), book2);
                String cacheKey = this.computeCacheKey(book2);
                Ref.ObjectRef objectRef = kepubPath = new Ref.ObjectRef();
                Path path2 = (Path)this.cachedKepub.getIfPresent((Object)cacheKey);
                if (path2 != null) {
                    void it;
                    Path path3 = path2;
                    Ref.ObjectRef objectRef2 = objectRef;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    v3 = Files.exists((Path)it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? it : null;
                    objectRef = objectRef2;
                } else {
                    v3 = objectRef.element = null;
                }
                if (kepubPath.element == null) {
                    Path path4 = KepubConverter.convertEpubToKepub$default((KepubConverter)this.kepubConverter, (BookWithMedia)new BookWithMedia(book2, this.mediaRepository.findById(bookId)), null, (int)2, null);
                    if (path4 == null) {
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE, "Kepub conversion failed");
                    }
                    Path converted = path4;
                    converted.toFile().deleteOnExit();
                    this.cachedKepub.put((Object)cacheKey, (Object)converted);
                    kepubPath.element = converted;
                } else {
                    KoboControllerKt.access$getLogger$p().debug((Function0)getBookFile.1.1.INSTANCE);
                }
                try {
                    void $this$getBookFile_u24lambda_u2451_u24lambda_u2450_u24lambda_u2449;
                    HttpHeaders httpHeaders;
                    FileSystemResource $this$getBookFile_u24lambda_u2451_u24lambda_u2450 = new FileSystemResource((Path)kepubPath.element);
                    boolean bl3 = false;
                    if (!$this$getBookFile_u24lambda_u2451_u24lambda_u2450.exists()) {
                        throw new FileNotFoundException($this$getBookFile_u24lambda_u2451_u24lambda_u2450.getPath());
                    }
                    StreamingResponseBody stream = arg_0 -> KoboController.getBookFile$lambda$51$lambda$50$lambda$48($this$getBookFile_u24lambda_u2451_u24lambda_u2450, arg_0);
                    HttpHeaders httpHeaders2 = httpHeaders = new HttpHeaders();
                    ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.ok();
                    boolean bl4 = false;
                    $this$getBookFile_u24lambda_u2451_u24lambda_u2450_u24lambda_u2449.setContentDisposition(ContentDisposition.builder((String)"attachment").filename(PathsKt.getNameWithoutExtension((Path)book2.getPath()) + ".kepub.epub", StandardCharsets.UTF_8).build());
                    ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)bodyBuilder.headers(httpHeaders)).contentType(UtilsKt.getMediaTypeOrDefault((String)MediaType.EPUB.getType())).contentLength($this$getBookFile_u24lambda_u2451_u24lambda_u2450.contentLength()).body((Object)stream);
                    Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
                    return responseEntity;
                }
                catch (FileNotFoundException ex) {
                    KoboControllerKt.access$getLogger$p().warn((Throwable)ex, (Function0)new /* Unavailable Anonymous Inner Class!! */);
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "File not found, it may have moved");
                }
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return this.commonBookController.getBookFileInternal(principal, bookId);
    }

    public static /* synthetic */ ResponseEntity getBookFile$default(KoboController koboController, KomgaPrincipal komgaPrincipal, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getBookFile");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return koboController.getBookFile(komgaPrincipal, string, bl);
    }

    private String computeCacheKey(Book $this$computeCacheKey) {
        return $this$computeCacheKey.getId() + "-" + $this$computeCacheKey.getFileLastModified();
    }

    @GetMapping(value={"v1/books/{thumbnailId}/thumbnail/{width}/{height}/{isGreyScale}/image.jpg", "v1/books/{thumbnailId}/thumbnail/{width}/{height}/{quality}/{isGreyScale}/image.jpg"}, produces={"image/jpeg"})
    @NotNull
    public ResponseEntity<Object> getBookCover(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String thumbnailId, @PathVariable @Nullable String width, @PathVariable @Nullable String height, @PathVariable @Nullable String quality, @PathVariable @Nullable String isGreyScale) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)thumbnailId, (String)"thumbnailId");
        if (!this.thumbnailBookRepository.existsById(thumbnailId) && this.koboProxy.isEnabled()) {
            Object[] objectArray = new Object[]{thumbnailId, width, height};
            ResponseEntity responseEntity2 = ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.TEMPORARY_REDIRECT)).location(UriComponentsBuilder.fromHttpUrl((String)this.koboProxy.getImageHostUrl()).buildAndExpand(objectArray).toUri())).build();
            Intrinsics.checkNotNull((Object)responseEntity2);
            responseEntity = responseEntity2;
        } else {
            TypedBytes typedBytes = this.bookLifecycle.getThumbnailBytesByThumbnailId(thumbnailId);
            if (typedBytes == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            TypedBytes poster = typedBytes;
            byte[] posterBytes = !Intrinsics.areEqual((Object)poster.getMediaType(), (Object)ImageType.JPEG.getMediaType()) ? this.imageConverter.convertImage(poster.getBytes(), ImageType.JPEG.getImageIOFormat()) : poster.getBytes();
            ResponseEntity responseEntity3 = ResponseEntity.ok((Object)posterBytes);
            Intrinsics.checkNotNull((Object)responseEntity3);
            responseEntity = responseEntity3;
        }
        return responseEntity;
    }

    @RequestMapping(value={"{*path}"}, method={RequestMethod.GET, RequestMethod.PUT, RequestMethod.POST, RequestMethod.DELETE, RequestMethod.PATCH})
    @NotNull
    public ResponseEntity<JsonNode> catchAll(@RequestBody @Nullable Object body) {
        ResponseEntity responseEntity;
        if (this.koboProxy.isEnabled()) {
            responseEntity = KoboProxy.proxyCurrentRequest$default((KoboProxy)this.koboProxy, (Object)body, (boolean)false, (int)2, null);
        } else {
            ResponseEntity responseEntity2 = ResponseEntity.ok().body((Object)this.mapper.createObjectNode());
            responseEntity = responseEntity2;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity2, (String)"body(...)");
        }
        return responseEntity;
    }

    private UriBuilder getDownloadUrlBuilder(String token) {
        String[] stringArray = new String[]{"kobo", token, "v1", "books", "{bookId}", "file", "epub"};
        UriComponentsBuilder uriComponentsBuilder = ServletUriComponentsBuilder.fromCurrentContextPath().pathSegment(stringArray).query("convert_kepub={convert}");
        Intrinsics.checkNotNullExpressionValue((Object)uriComponentsBuilder, (String)"query(...)");
        return (UriBuilder)uriComponentsBuilder;
    }

    /*
     * WARNING - void declaration
     */
    private KoboBookMetadataDto withDownloadUrls(KoboBookMetadataDto $this$withDownloadUrls, UriBuilder downloadUriBuilder) {
        void $this$withDownloadUrls_u24lambda_u2452;
        List list;
        List list2 = list = CollectionsKt.createListBuilder();
        String string = null;
        AmountDto amountDto = null;
        AmountDto amountDto2 = null;
        String string2 = null;
        String string3 = null;
        List list3 = null;
        List list4 = null;
        List list5 = null;
        KoboBookMetadataDto koboBookMetadataDto = $this$withDownloadUrls;
        boolean bl = false;
        Pair pair = $this$withDownloadUrls.isPrePaginated() ? TuplesKt.to((Object)FormatDto.EPUB3FL, (Object)false) : ($this$withDownloadUrls.isKepub() || this.kepubConverter.isAvailable() ? TuplesKt.to((Object)FormatDto.KEPUB, (Object)(!$this$withDownloadUrls.isKepub() ? 1 : 0)) : TuplesKt.to((Object)FormatDto.EPUB3, (Object)false));
        FormatDto format = (FormatDto)pair.component1();
        boolean convert = (Boolean)pair.component2();
        long l = $this$withDownloadUrls.getFileSize();
        Object[] objectArray = new Object[]{$this$withDownloadUrls.getEntitlementId(), convert};
        String string4 = downloadUriBuilder.build(objectArray).toURL().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        $this$withDownloadUrls_u24lambda_u2452.add(new DownloadUrlDto(null, format, l, null, string4, 9, null));
        Unit unit = Unit.INSTANCE;
        return KoboBookMetadataDto.copy$default((KoboBookMetadataDto)koboBookMetadataDto, list5, list4, list3, string3, string2, amountDto2, amountDto, string, (List)CollectionsKt.build((List)list), null, null, null, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, null, null, null, null, null, null, null, null, null, null, (boolean)false, (boolean)false, (long)0L, (int)0x3FFFFEFF, null);
    }

    private SyncPoint getSyncPointVerified(String syncPointId, String userId) {
        if (syncPointId != null) {
            SyncPoint syncPoint;
            SyncPoint syncPoint2 = syncPoint = this.syncPointRepository.findByIdOrNull(syncPointId);
            if (Intrinsics.areEqual((Object)(syncPoint2 != null ? syncPoint2.getUserId() : null), (Object)userId)) {
                return syncPoint;
            }
        }
        return null;
    }

    private KoboBookMetadataDto getMetadataForRemovedBook(String bookId) {
        return new KoboBookMetadataDto(null, null, null, bookId, bookId, null, null, null, null, bookId, null, null, false, false, false, false, null, null, null, null, null, bookId, null, null, null, bookId, bookId, false, false, 0L, 31456743, null);
    }

    private ReadingStateDto getEmptyReadProgressForBook(Book book) {
        ZonedDateTime createdDateUTC = LanguageUtilsKt.toUTCZoned((LocalDateTime)book.getCreatedDate());
        String string = book.getId();
        BookmarkDto bookmarkDto = new BookmarkDto(createdDateUTC, null, null, null, 14, null);
        StatisticsDto statisticsDto = new StatisticsDto(createdDateUTC, null, null, 6, null);
        StatusInfoDto statusInfoDto = new StatusInfoDto(createdDateUTC, StatusDto.READY_TO_READ, Integer.valueOf(0), null, null, 24, null);
        return new ReadingStateDto(createdDateUTC, bookmarkDto, string, createdDateUTC, createdDateUTC, statisticsDto, statusInfoDto);
    }

    private ReadingStateDto getEmptyReadProgressForBook(String bookId, ZonedDateTime createdDate) {
        BookmarkDto bookmarkDto = new BookmarkDto(createdDate, null, null, null, 14, null);
        StatisticsDto statisticsDto = new StatisticsDto(createdDate, null, null, 6, null);
        StatusInfoDto statusInfoDto = new StatusInfoDto(createdDate, StatusDto.READY_TO_READ, Integer.valueOf(0), null, null, 24, null);
        return new ReadingStateDto(createdDate, bookmarkDto, bookId, createdDate, createdDate, statisticsDto, statusInfoDto);
    }

    private static final void cachedKepub$lambda$0(Function3 $tmp0, Object p0, Object p1, RemovalCause p2) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1, (Object)p2);
    }

    private static final void syncLibrary$lambda$44(boolean $shouldContinueSyncMerged, KoboController this$0, KomgaSyncToken $syncTokenUpdated, HttpHeaders it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$syncTokenUpdated, (String)"$syncTokenUpdated");
        if ($shouldContinueSyncMerged) {
            it.set("X-Kobo-sync", "continue");
        }
        it.set("x-kobo-synctoken", this$0.komgaSyncTokenGenerator.toBase64($syncTokenUpdated));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void getBookFile$lambda$51$lambda$50$lambda$48(FileSystemResource $this_with, OutputStream os) {
        Intrinsics.checkNotNullParameter((Object)$this_with, (String)"$this_with");
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Closeable closeable = $this_with.getInputStream();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            IOUtils.copyLarge((InputStream)it, (OutputStream)os, (byte[])new byte[8192]);
            os.close();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

