/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.opds.v1;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.apache.commons.io.FilenameUtils;
import org.gotson.komga.domain.model.BookPage;
import org.gotson.komga.domain.model.BookSearchWithReadProgress;
import org.gotson.komga.domain.model.Library;
import org.gotson.komga.domain.model.Media;
import org.gotson.komga.domain.model.MediaProfile;
import org.gotson.komga.domain.model.ReadList;
import org.gotson.komga.domain.model.ReadStatus;
import org.gotson.komga.domain.model.SeriesCollection;
import org.gotson.komga.domain.model.SeriesSearchWithReadProgress;
import org.gotson.komga.domain.model.ThumbnailBook;
import org.gotson.komga.domain.persistence.LibraryRepository;
import org.gotson.komga.domain.persistence.MediaRepository;
import org.gotson.komga.domain.persistence.ReadListRepository;
import org.gotson.komga.domain.persistence.ReferentialRepository;
import org.gotson.komga.domain.persistence.SeriesCollectionRepository;
import org.gotson.komga.domain.service.BookLifecycle;
import org.gotson.komga.infrastructure.configuration.KomgaSettingsProvider;
import org.gotson.komga.infrastructure.image.ImageType;
import org.gotson.komga.infrastructure.security.KomgaPrincipal;
import org.gotson.komga.infrastructure.swagger.PageAsQueryParam;
import org.gotson.komga.interfaces.api.CommonBookController;
import org.gotson.komga.interfaces.api.ContentRestrictionChecker;
import org.gotson.komga.interfaces.api.opds.v1.OpdsController;
import org.gotson.komga.interfaces.api.opds.v1.dto.OpdsAuthor;
import org.gotson.komga.interfaces.api.opds.v1.dto.OpdsEntryAcquisition;
import org.gotson.komga.interfaces.api.opds.v1.dto.OpdsEntryNavigation;
import org.gotson.komga.interfaces.api.opds.v1.dto.OpdsFeed;
import org.gotson.komga.interfaces.api.opds.v1.dto.OpdsFeedAcquisition;
import org.gotson.komga.interfaces.api.opds.v1.dto.OpdsFeedNavigation;
import org.gotson.komga.interfaces.api.opds.v1.dto.OpdsLink;
import org.gotson.komga.interfaces.api.opds.v1.dto.OpdsLinkFeedNavigation;
import org.gotson.komga.interfaces.api.opds.v1.dto.OpdsLinkFileAcquisition;
import org.gotson.komga.interfaces.api.opds.v1.dto.OpdsLinkImage;
import org.gotson.komga.interfaces.api.opds.v1.dto.OpdsLinkImageThumbnail;
import org.gotson.komga.interfaces.api.opds.v1.dto.OpdsLinkPageStreaming;
import org.gotson.komga.interfaces.api.opds.v1.dto.OpdsLinkSearch;
import org.gotson.komga.interfaces.api.opds.v1.dto.OpenSearchDescription;
import org.gotson.komga.interfaces.api.persistence.BookDtoRepository;
import org.gotson.komga.interfaces.api.persistence.SeriesDtoRepository;
import org.gotson.komga.interfaces.api.rest.dto.AuthorDto;
import org.gotson.komga.interfaces.api.rest.dto.BookDto;
import org.gotson.komga.interfaces.api.rest.dto.ReadProgressDto;
import org.gotson.komga.interfaces.api.rest.dto.SeriesDto;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/opds/v1.2/"}, produces={"application/atom+xml", "application/xml", "text/xml"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00e6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001Bg\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\b\b\u0001\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ:\u0010\"\u001a\u00020#2\b\b\u0001\u0010$\u001a\u00020%2\n\b\u0001\u0010&\u001a\u0004\u0018\u00010!2\u0010\b\u0001\u0010'\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010 2\b\b\u0001\u0010(\u001a\u00020)H\u0017J@\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\b\b\u0001\u0010$\u001a\u00020%2\u0006\u0010-\u001a\u00020.2\b\b\u0001\u0010/\u001a\u00020!2\b\b\u0001\u00100\u001a\u0002012\n\b\u0001\u00102\u001a\u0004\u0018\u00010!H\u0017J\u001c\u00103\u001a\u00020,2\b\b\u0001\u0010$\u001a\u00020%2\b\b\u0001\u0010/\u001a\u00020!H\u0017J\b\u00104\u001a\u00020#H\u0017J\u001c\u00105\u001a\u00020#2\b\b\u0001\u0010$\u001a\u00020%2\b\b\u0001\u0010(\u001a\u00020)H\u0017J\u001c\u00106\u001a\u00020#2\b\b\u0001\u0010$\u001a\u00020%2\b\b\u0001\u0010(\u001a\u00020)H\u0017J\u001c\u00107\u001a\u00020#2\b\b\u0001\u0010$\u001a\u00020%2\b\b\u0001\u0010(\u001a\u00020)H\u0017J\u001c\u00108\u001a\u00020#2\b\b\u0001\u0010$\u001a\u00020%2\b\b\u0001\u0010(\u001a\u00020)H\u0017J\u0012\u00109\u001a\u00020#2\b\b\u0001\u0010$\u001a\u00020%H\u0017J\u001c\u0010:\u001a\u00020#2\b\b\u0001\u0010$\u001a\u00020%2\b\b\u0001\u0010(\u001a\u00020)H\u0017J&\u0010;\u001a\u00020#2\b\b\u0001\u0010$\u001a\u00020%2\b\b\u0001\u0010<\u001a\u00020!2\b\b\u0001\u0010(\u001a\u00020)H\u0017J&\u0010=\u001a\u00020#2\b\b\u0001\u0010$\u001a\u00020%2\b\b\u0001\u0010<\u001a\u00020!2\b\b\u0001\u0010(\u001a\u00020)H\u0017J&\u0010>\u001a\u00020#2\b\b\u0001\u0010$\u001a\u00020%2\b\b\u0001\u0010<\u001a\u00020!2\b\b\u0001\u0010(\u001a\u00020)H\u0017J&\u0010?\u001a\u00020#2\b\b\u0001\u0010$\u001a\u00020%2\b\b\u0001\u0010<\u001a\u00020!2\b\b\u0001\u0010(\u001a\u00020)H\u0017J\u001c\u0010@\u001a\u00020#2\b\b\u0001\u0010$\u001a\u00020%2\b\b\u0001\u0010(\u001a\u00020)H\u0017J\u001c\u0010A\u001a\u00020#2\b\b\u0001\u0010$\u001a\u00020%2\b\b\u0001\u0010(\u001a\u00020)H\u0017J\b\u0010B\u001a\u00020CH\u0017J*\u0010D\u001a\b\u0012\u0004\u0012\u00020E0 \"\u0004\b\u0000\u0010F2\u0006\u0010G\u001a\u00020H2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002HF0IH\u0012J\b\u0010J\u001a\u00020KH\u0012J\u0010\u0010L\u001a\u00020!2\u0006\u0010M\u001a\u00020!H\u0012J\u0010\u0010G\u001a\u00020H2\u0006\u0010N\u001a\u00020!H\u0012J\u0018\u0010O\u001a\b\u0012\u0004\u0012\u00020P0 *\b\u0012\u0004\u0012\u00020Q0 H\u0012J\f\u0010R\u001a\u00020S*\u00020TH\u0012J\f\u0010R\u001a\u00020S*\u00020UH\u0012J\f\u0010R\u001a\u00020S*\u00020VH\u0012J*\u0010R\u001a\u00020P*\u00020Q2\u0006\u0010W\u001a\u00020X2\u0014\b\u0002\u0010Y\u001a\u000e\u0012\u0004\u0012\u00020Q\u0012\u0004\u0012\u00020!0ZH\u0012J\u001d\u0010R\u001a\u00020S*\u00020[2\n\b\u0002\u0010Y\u001a\u0004\u0018\u000101H\u0012\u00a2\u0006\u0002\u0010\\R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006]"}, d2={"Lorg/gotson/komga/interfaces/api/opds/v1/OpdsController;", "", "libraryRepository", "Lorg/gotson/komga/domain/persistence/LibraryRepository;", "collectionRepository", "Lorg/gotson/komga/domain/persistence/SeriesCollectionRepository;", "readListRepository", "Lorg/gotson/komga/domain/persistence/ReadListRepository;", "seriesDtoRepository", "Lorg/gotson/komga/interfaces/api/persistence/SeriesDtoRepository;", "bookDtoRepository", "Lorg/gotson/komga/interfaces/api/persistence/BookDtoRepository;", "mediaRepository", "Lorg/gotson/komga/domain/persistence/MediaRepository;", "referentialRepository", "Lorg/gotson/komga/domain/persistence/ReferentialRepository;", "bookLifecycle", "Lorg/gotson/komga/domain/service/BookLifecycle;", "commonBookController", "Lorg/gotson/komga/interfaces/api/CommonBookController;", "komgaSettingsProvider", "Lorg/gotson/komga/infrastructure/configuration/KomgaSettingsProvider;", "contentRestrictionChecker", "Lorg/gotson/komga/interfaces/api/ContentRestrictionChecker;", "pdfImageType", "Lorg/gotson/komga/infrastructure/image/ImageType;", "(Lorg/gotson/komga/domain/persistence/LibraryRepository;Lorg/gotson/komga/domain/persistence/SeriesCollectionRepository;Lorg/gotson/komga/domain/persistence/ReadListRepository;Lorg/gotson/komga/interfaces/api/persistence/SeriesDtoRepository;Lorg/gotson/komga/interfaces/api/persistence/BookDtoRepository;Lorg/gotson/komga/domain/persistence/MediaRepository;Lorg/gotson/komga/domain/persistence/ReferentialRepository;Lorg/gotson/komga/domain/service/BookLifecycle;Lorg/gotson/komga/interfaces/api/CommonBookController;Lorg/gotson/komga/infrastructure/configuration/KomgaSettingsProvider;Lorg/gotson/komga/interfaces/api/ContentRestrictionChecker;Lorg/gotson/komga/infrastructure/image/ImageType;)V", "decimalFormat", "Ljava/text/DecimalFormat;", "komgaAuthor", "Lorg/gotson/komga/interfaces/api/opds/v1/dto/OpdsAuthor;", "opdsPseSupportedFormats", "", "", "getAllSeries", "Lorg/gotson/komga/interfaces/api/opds/v1/dto/OpdsFeed;", "principal", "Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;", "searchTerm", "publishers", "page", "Lorg/springframework/data/domain/Pageable;", "getBookPageOpds", "Lorg/springframework/http/ResponseEntity;", "", "request", "Lorg/springframework/web/context/request/ServletWebRequest;", "bookId", "pageNumber", "", "convertTo", "getBookThumbnailSmall", "getCatalog", "getCollections", "getKeepReading", "getLatestBooks", "getLatestSeries", "getLibraries", "getOnDeck", "getOneCollection", "id", "getOneLibrary", "getOneReadList", "getOneSeries", "getPublishers", "getReadLists", "getSearch", "Lorg/gotson/komga/interfaces/api/opds/v1/dto/OpenSearchDescription;", "linkPage", "Lorg/gotson/komga/interfaces/api/opds/v1/dto/OpdsLink;", "T", "uriBuilder", "Lorg/springframework/web/util/UriComponentsBuilder;", "Lorg/springframework/data/domain/Page;", "linkStart", "Lorg/gotson/komga/interfaces/api/opds/v1/dto/OpdsLinkFeedNavigation;", "sanitize", "fileName", "path", "getEntriesWithSeriesTitle", "Lorg/gotson/komga/interfaces/api/opds/v1/dto/OpdsEntryAcquisition;", "Lorg/gotson/komga/interfaces/api/rest/dto/BookDto;", "toOpdsEntry", "Lorg/gotson/komga/interfaces/api/opds/v1/dto/OpdsEntryNavigation;", "Lorg/gotson/komga/domain/model/Library;", "Lorg/gotson/komga/domain/model/ReadList;", "Lorg/gotson/komga/domain/model/SeriesCollection;", "media", "Lorg/gotson/komga/domain/model/Media;", "prepend", "Lkotlin/Function1;", "Lorg/gotson/komga/interfaces/api/rest/dto/SeriesDto;", "(Lorg/gotson/komga/interfaces/api/rest/dto/SeriesDto;Ljava/lang/Integer;)Lorg/gotson/komga/interfaces/api/opds/v1/dto/OpdsEntryNavigation;", "komga"})
@SourceDebugExtension(value={"SMAP\nOpdsController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpdsController.kt\norg/gotson/komga/interfaces/api/opds/v1/OpdsController\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,836:1\n37#2,2:837\n37#2,2:839\n37#2,2:841\n37#2,2:847\n37#2,2:853\n37#2,2:859\n37#2,2:865\n37#2,2:871\n37#2,2:877\n37#2,2:879\n37#2,2:881\n37#2,2:883\n1549#3:843\n1620#3,3:844\n1549#3:849\n1620#3,3:850\n1549#3:855\n1620#3,3:856\n1549#3:861\n1620#3,3:862\n1549#3:867\n1620#3,3:868\n1549#3:873\n1620#3,3:874\n1549#3:886\n1620#3,3:887\n1549#3:890\n1620#3,3:891\n1549#3:894\n1620#3,3:895\n1549#3:898\n1620#3,3:899\n1#4:885\n*S KotlinDebug\n*F\n+ 1 OpdsController.kt\norg/gotson/komga/interfaces/api/opds/v1/OpdsController\n*L\n269#1:837,2\n310#1:839,2\n355#1:841,2\n388#1:847,2\n421#1:853,2\n471#1:859,2\n497#1:865,2\n522#1:871,2\n570#1:877,2\n609#1:879,2\n651#1:881,2\n704#1:883,2\n357#1:843\n357#1:844,3\n390#1:849\n390#1:850,3\n447#1:855\n447#1:856,3\n473#1:861\n473#1:862,3\n499#1:867\n499#1:868,3\n525#1:873\n525#1:874,3\n760#1:886\n760#1:887,3\n762#1:890\n762#1:891,3\n790#1:894\n790#1:895,3\n829#1:898\n829#1:899,3\n*E\n"})
public class OpdsController {
    @NotNull
    private final LibraryRepository libraryRepository;
    @NotNull
    private final SeriesCollectionRepository collectionRepository;
    @NotNull
    private final ReadListRepository readListRepository;
    @NotNull
    private final SeriesDtoRepository seriesDtoRepository;
    @NotNull
    private final BookDtoRepository bookDtoRepository;
    @NotNull
    private final MediaRepository mediaRepository;
    @NotNull
    private final ReferentialRepository referentialRepository;
    @NotNull
    private final BookLifecycle bookLifecycle;
    @NotNull
    private final CommonBookController commonBookController;
    @NotNull
    private final KomgaSettingsProvider komgaSettingsProvider;
    @NotNull
    private final ContentRestrictionChecker contentRestrictionChecker;
    @NotNull
    private final ImageType pdfImageType;
    @NotNull
    private final OpdsAuthor komgaAuthor;
    @NotNull
    private final DecimalFormat decimalFormat;
    @NotNull
    private final List<String> opdsPseSupportedFormats;

    public OpdsController(@NotNull LibraryRepository libraryRepository, @NotNull SeriesCollectionRepository collectionRepository, @NotNull ReadListRepository readListRepository, @NotNull SeriesDtoRepository seriesDtoRepository, @NotNull BookDtoRepository bookDtoRepository, @NotNull MediaRepository mediaRepository, @NotNull ReferentialRepository referentialRepository, @NotNull BookLifecycle bookLifecycle, @NotNull CommonBookController commonBookController, @NotNull KomgaSettingsProvider komgaSettingsProvider, @NotNull ContentRestrictionChecker contentRestrictionChecker, @Qualifier(value="pdfImageType") @NotNull ImageType pdfImageType) {
        Intrinsics.checkNotNullParameter((Object)libraryRepository, (String)"libraryRepository");
        Intrinsics.checkNotNullParameter((Object)collectionRepository, (String)"collectionRepository");
        Intrinsics.checkNotNullParameter((Object)readListRepository, (String)"readListRepository");
        Intrinsics.checkNotNullParameter((Object)seriesDtoRepository, (String)"seriesDtoRepository");
        Intrinsics.checkNotNullParameter((Object)bookDtoRepository, (String)"bookDtoRepository");
        Intrinsics.checkNotNullParameter((Object)mediaRepository, (String)"mediaRepository");
        Intrinsics.checkNotNullParameter((Object)referentialRepository, (String)"referentialRepository");
        Intrinsics.checkNotNullParameter((Object)bookLifecycle, (String)"bookLifecycle");
        Intrinsics.checkNotNullParameter((Object)commonBookController, (String)"commonBookController");
        Intrinsics.checkNotNullParameter((Object)komgaSettingsProvider, (String)"komgaSettingsProvider");
        Intrinsics.checkNotNullParameter((Object)contentRestrictionChecker, (String)"contentRestrictionChecker");
        Intrinsics.checkNotNullParameter((Object)pdfImageType, (String)"pdfImageType");
        this.libraryRepository = libraryRepository;
        this.collectionRepository = collectionRepository;
        this.readListRepository = readListRepository;
        this.seriesDtoRepository = seriesDtoRepository;
        this.bookDtoRepository = bookDtoRepository;
        this.mediaRepository = mediaRepository;
        this.referentialRepository = referentialRepository;
        this.bookLifecycle = bookLifecycle;
        this.commonBookController = commonBookController;
        this.komgaSettingsProvider = komgaSettingsProvider;
        this.contentRestrictionChecker = contentRestrictionChecker;
        this.pdfImageType = pdfImageType;
        this.komgaAuthor = new OpdsAuthor("Komga", new URI("https://github.com/gotson/komga"));
        this.decimalFormat = new DecimalFormat("0.#");
        Object[] objectArray = new String[]{"image/jpeg", "image/png", "image/gif"};
        this.opdsPseSupportedFormats = CollectionsKt.listOf((Object[])objectArray);
    }

    private OpdsLinkFeedNavigation linkStart() {
        String string = this.uriBuilder("catalog").toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUriString(...)");
        return new OpdsLinkFeedNavigation("start", string);
    }

    private UriComponentsBuilder uriBuilder(String path2) {
        String[] stringArray = new String[]{"opds", "v1.2"};
        UriComponentsBuilder uriComponentsBuilder = ServletUriComponentsBuilder.fromCurrentContextPath().pathSegment(stringArray).path(path2);
        Intrinsics.checkNotNullExpressionValue((Object)uriComponentsBuilder, (String)"path(...)");
        return uriComponentsBuilder;
    }

    private <T> List<OpdsLink> linkPage(UriComponentsBuilder uriBuilder, Page<T> page) {
        OpdsLinkFeedNavigation opdsLinkFeedNavigation;
        Object[] objectArray;
        Object[] objectArray2 = new OpdsLinkFeedNavigation[2];
        if (!page.isFirst()) {
            objectArray = new Object[]{page.getPageable().previousOrFirst().getPageNumber()};
            String string = uriBuilder.cloneBuilder().queryParam("page", objectArray).toUriString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUriString(...)");
            v1 = new OpdsLinkFeedNavigation("previous", string);
        } else {
            v1 = objectArray2[0] = null;
        }
        if (!page.isLast()) {
            objectArray = new Object[]{page.getPageable().next().getPageNumber()};
            String string = uriBuilder.cloneBuilder().queryParam("page", objectArray).toUriString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUriString(...)");
            opdsLinkFeedNavigation = new OpdsLinkFeedNavigation("next", string);
        } else {
            opdsLinkFeedNavigation = null;
        }
        objectArray2[1] = opdsLinkFeedNavigation;
        return CollectionsKt.listOfNotNull((Object[])objectArray2);
    }

    @GetMapping(value={"catalog"})
    @NotNull
    public OpdsFeed getCatalog() {
        ZonedDateTime zonedDateTime = ZonedDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"now(...)");
        Object[] objectArray = new OpdsLink[4];
        String string = this.uriBuilder("catalog").toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUriString(...)");
        objectArray[0] = new OpdsLinkFeedNavigation("self", string);
        objectArray[1] = this.linkStart();
        String string2 = this.uriBuilder("search").toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUriString(...)");
        objectArray[2] = new OpdsLinkSearch(string2);
        String[] stringArray = new String[]{"opds", "v2", "catalog"};
        String string3 = ServletUriComponentsBuilder.fromCurrentContextPath().pathSegment(stringArray).toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUriString(...)");
        objectArray[3] = new OpdsLink("application/opds+json", "alternate", string3);
        List list = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new OpdsEntryNavigation[9];
        ZonedDateTime zonedDateTime2 = ZonedDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"now(...)");
        String string4 = this.uriBuilder("keep-reading").toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUriString(...)");
        objectArray[0] = new OpdsEntryNavigation("Keep Reading", zonedDateTime2, "keepReading", "Continue reading your in progress books", (OpdsLink)new OpdsLinkFeedNavigation("subsection", string4));
        ZonedDateTime zonedDateTime3 = ZonedDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime3, (String)"now(...)");
        String string5 = this.uriBuilder("ondeck").toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUriString(...)");
        objectArray[1] = new OpdsEntryNavigation("On Deck", zonedDateTime3, "ondeck", "Browse what to read next", (OpdsLink)new OpdsLinkFeedNavigation("subsection", string5));
        ZonedDateTime zonedDateTime4 = ZonedDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime4, (String)"now(...)");
        String string6 = this.uriBuilder("series").toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toUriString(...)");
        objectArray[2] = new OpdsEntryNavigation("All series", zonedDateTime4, "allSeries", "Browse by series", (OpdsLink)new OpdsLinkFeedNavigation("subsection", string6));
        ZonedDateTime zonedDateTime5 = ZonedDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime5, (String)"now(...)");
        String string7 = this.uriBuilder("series/latest").toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toUriString(...)");
        objectArray[3] = new OpdsEntryNavigation("Latest series", zonedDateTime5, "latestSeries", "Browse latest series", (OpdsLink)new OpdsLinkFeedNavigation("subsection", string7));
        ZonedDateTime zonedDateTime6 = ZonedDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime6, (String)"now(...)");
        String string8 = this.uriBuilder("books/latest").toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toUriString(...)");
        objectArray[4] = new OpdsEntryNavigation("Latest books", zonedDateTime6, "latestBooks", "Browse latest books", (OpdsLink)new OpdsLinkFeedNavigation("subsection", string8));
        ZonedDateTime zonedDateTime7 = ZonedDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime7, (String)"now(...)");
        String string9 = this.uriBuilder("libraries").toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toUriString(...)");
        objectArray[5] = new OpdsEntryNavigation("All libraries", zonedDateTime7, "allLibraries", "Browse by library", (OpdsLink)new OpdsLinkFeedNavigation("subsection", string9));
        ZonedDateTime zonedDateTime8 = ZonedDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime8, (String)"now(...)");
        String string10 = this.uriBuilder("collections").toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"toUriString(...)");
        objectArray[6] = new OpdsEntryNavigation("All collections", zonedDateTime8, "allCollections", "Browse by collection", (OpdsLink)new OpdsLinkFeedNavigation("subsection", string10));
        ZonedDateTime zonedDateTime9 = ZonedDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime9, (String)"now(...)");
        String string11 = this.uriBuilder("readlists").toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"toUriString(...)");
        objectArray[7] = new OpdsEntryNavigation("All read lists", zonedDateTime9, "allReadLists", "Browse by read lists", (OpdsLink)new OpdsLinkFeedNavigation("subsection", string11));
        ZonedDateTime zonedDateTime10 = ZonedDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime10, (String)"now(...)");
        String string12 = this.uriBuilder("publishers").toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"toUriString(...)");
        objectArray[8] = new OpdsEntryNavigation("All publishers", zonedDateTime10, "allPublishers", "Browse by publishers", (OpdsLink)new OpdsLinkFeedNavigation("subsection", string12));
        return (OpdsFeed)new OpdsFeedNavigation("root", "Komga OPDS catalog", zonedDateTime, this.komgaAuthor, list, CollectionsKt.listOf((Object[])objectArray));
    }

    @GetMapping(value={"search"})
    @NotNull
    public OpenSearchDescription getSearch() {
        return new OpenSearchDescription("Search", "Search for series", null, null, new OpenSearchDescription.OpenSearchUrl(this.uriBuilder("series").toUriString() + "?search={searchTerms}"), 12, null);
    }

    @PageAsQueryParam
    @GetMapping(value={"ondeck"})
    @NotNull
    public OpdsFeed getOnDeck(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @Parameter(hidden=true) @NotNull Pageable page) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Page bookPage = this.bookDtoRepository.findAllOnDeck(principal.getUser().getId(), principal.getUser().getAuthorizedLibraryIds(null), page, principal.getUser().getRestrictions());
        UriComponentsBuilder builder = this.uriBuilder("ondeck");
        ZonedDateTime zonedDateTime = ZonedDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"now(...)");
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        String string = builder.toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUriString(...)");
        spreadBuilder.add((Object)new OpdsLinkFeedNavigation("self", string));
        spreadBuilder.add((Object)this.linkStart());
        Collection $this$toTypedArray$iv = this.linkPage(builder, bookPage);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new OpdsLink[0]));
        List list = CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new OpdsLink[spreadBuilder.size()]));
        List list2 = bookPage.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContent(...)");
        return (OpdsFeed)new OpdsFeedAcquisition("ondeck", "On Deck", zonedDateTime, this.komgaAuthor, list, this.getEntriesWithSeriesTitle(list2));
    }

    @PageAsQueryParam
    @GetMapping(value={"keep-reading"})
    @NotNull
    public OpdsFeed getKeepReading(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @Parameter(hidden=true) @NotNull Pageable page) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Object object = new Sort.Order[]{Sort.Order.desc((String)"readProgress.readDate")};
        PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)Sort.by((Sort.Order[])object));
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        PageRequest pageable = pageRequest;
        object = principal.getUser().getAuthorizedLibraryIds(null);
        Set set = SetsKt.setOf((Object)ReadStatus.IN_PROGRESS);
        Set set2 = SetsKt.setOf((Object)Media.Status.READY);
        BookSearchWithReadProgress bookSearch = new BookSearchWithReadProgress((Collection)object, null, null, (Collection)set2, null, Boolean.valueOf(false), null, null, (Collection)set, null, 726, null);
        Page bookPage = this.bookDtoRepository.findAll(bookSearch, principal.getUser().getId(), (Pageable)pageable, principal.getUser().getRestrictions());
        UriComponentsBuilder builder = this.uriBuilder("ondeck");
        ZonedDateTime zonedDateTime = ZonedDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"now(...)");
        set2 = new SpreadBuilder(3);
        String string = builder.toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUriString(...)");
        set2.add(new OpdsLinkFeedNavigation("self", string));
        set2.add(this.linkStart());
        Collection $this$toTypedArray$iv = this.linkPage(builder, bookPage);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        set2.addSpread(thisCollection$iv.toArray(new OpdsLink[0]));
        List list = CollectionsKt.listOf((Object[])set2.toArray(new OpdsLink[set2.size()]));
        List list2 = bookPage.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContent(...)");
        return (OpdsFeed)new OpdsFeedAcquisition("keepReading", "Keep Reading", zonedDateTime, this.komgaAuthor, list, this.getEntriesWithSeriesTitle(list2));
    }

    /*
     * WARNING - void declaration
     */
    @PageAsQueryParam
    @GetMapping(value={"series"})
    @NotNull
    public OpdsFeed getAllSeries(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="search", required=false) @Nullable String searchTerm, @RequestParam(name="publisher", required=false) @Nullable List<String> publishers, @Parameter(hidden=true) @NotNull Pageable page) {
        Collection<OpdsEntryNavigation> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Sort sort;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        String[] stringArray = (String[])searchTerm;
        if (!(stringArray == null || StringsKt.isBlank((CharSequence)stringArray))) {
            stringArray = new String[]{"relevance"};
            sort = Sort.by((String[])stringArray);
        } else {
            stringArray = new Sort.Order[]{Sort.Order.asc((String)"metadata.titleSort")};
            sort = Sort.by((Sort.Order[])stringArray);
        }
        Sort sort2 = sort;
        Intrinsics.checkNotNull((Object)sort2);
        Sort sort3 = sort2;
        PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)sort3);
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        PageRequest pageable = pageRequest;
        SeriesSearchWithReadProgress seriesSearch = new SeriesSearchWithReadProgress(principal.getUser().getAuthorizedLibraryIds(null), null, searchTerm, null, null, (Collection)publishers, Boolean.valueOf(false), null, null, null, null, null, null, null, null, null, null, 130970, null);
        Page seriesPage = this.seriesDtoRepository.findAll(seriesSearch, principal.getUser().getId(), (Pageable)pageable, principal.getUser().getRestrictions());
        UriComponentsBuilder uriComponentsBuilder = this.uriBuilder("series").queryParamIfPresent("search", Optional.ofNullable(searchTerm)).queryParamIfPresent("publisher", Optional.ofNullable(publishers));
        Intrinsics.checkNotNullExpressionValue((Object)uriComponentsBuilder, (String)"queryParamIfPresent(...)");
        UriComponentsBuilder builder = uriComponentsBuilder;
        Object object = searchTerm;
        Object object2 = !(object == null || StringsKt.isBlank((CharSequence)object)) ? "Series search for: " + searchTerm : "All series";
        ZonedDateTime zonedDateTime = ZonedDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"now(...)");
        object = new SpreadBuilder(3);
        String string = builder.toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUriString(...)");
        object.add((Object)new OpdsLinkFeedNavigation("self", string));
        object.add((Object)this.linkStart());
        Collection $this$toTypedArray$iv = this.linkPage(builder, seriesPage);
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        object.addSpread((Object)thisCollection$iv.toArray(new OpdsLink[0]));
        List list = CollectionsKt.listOf((Object[])object.toArray((Object[])new OpdsLink[object.size()]));
        List list2 = seriesPage.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContent(...)");
        object = list2;
        List list3 = list;
        OpdsAuthor opdsAuthor = this.komgaAuthor;
        ZonedDateTime zonedDateTime2 = zonedDateTime;
        Object object3 = object2;
        String string2 = "allSeries";
        boolean $i$f$map = false;
        void $i$f$toTypedArray22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SeriesDto seriesDto = (SeriesDto)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(OpdsController.toOpdsEntry$default((OpdsController)this, (SeriesDto)it, null, (int)1, null));
        }
        Collection<OpdsEntryNavigation> collection2 = collection = (List)destination$iv$iv;
        List list4 = list3;
        OpdsAuthor opdsAuthor2 = opdsAuthor;
        ZonedDateTime zonedDateTime3 = zonedDateTime2;
        Object object4 = object3;
        String string3 = string2;
        return (OpdsFeed)new OpdsFeedNavigation(string3, (String)object4, zonedDateTime3, opdsAuthor2, list4, collection2);
    }

    /*
     * WARNING - void declaration
     */
    @PageAsQueryParam
    @GetMapping(value={"series/latest"})
    @NotNull
    public OpdsFeed getLatestSeries(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @Parameter(hidden=true) @NotNull Pageable page) {
        Collection<OpdsEntryNavigation> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Sort.Order[] orderArray = new Sort.Order[]{Sort.Order.desc((String)"lastModified")};
        PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)Sort.by((Sort.Order[])orderArray));
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        PageRequest pageable = pageRequest;
        SeriesSearchWithReadProgress seriesSearch = new SeriesSearchWithReadProgress(principal.getUser().getAuthorizedLibraryIds(null), null, null, null, null, null, Boolean.valueOf(false), null, null, null, null, null, null, null, null, null, null, 131006, null);
        Page seriesPage = this.seriesDtoRepository.findAll(seriesSearch, principal.getUser().getId(), (Pageable)pageable, principal.getUser().getRestrictions());
        UriComponentsBuilder uriBuilder = this.uriBuilder("series/latest");
        ZonedDateTime zonedDateTime = ZonedDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"now(...)");
        Object object = new SpreadBuilder(3);
        String string = uriBuilder.toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUriString(...)");
        object.add((Object)new OpdsLinkFeedNavigation("self", string));
        object.add((Object)this.linkStart());
        Collection $this$toTypedArray$iv = this.linkPage(uriBuilder, seriesPage);
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        object.addSpread((Object)thisCollection$iv.toArray(new OpdsLink[0]));
        List list = CollectionsKt.listOf((Object[])object.toArray((Object[])new OpdsLink[object.size()]));
        List list2 = seriesPage.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContent(...)");
        object = list2;
        List list3 = list;
        OpdsAuthor opdsAuthor = this.komgaAuthor;
        ZonedDateTime zonedDateTime2 = zonedDateTime;
        String string2 = "Latest series";
        String string3 = "latestSeries";
        boolean $i$f$map = false;
        void $i$f$toTypedArray22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SeriesDto seriesDto = (SeriesDto)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(OpdsController.toOpdsEntry$default((OpdsController)this, (SeriesDto)it, null, (int)1, null));
        }
        Collection<OpdsEntryNavigation> collection2 = collection = (List)destination$iv$iv;
        List list4 = list3;
        OpdsAuthor opdsAuthor2 = opdsAuthor;
        ZonedDateTime zonedDateTime3 = zonedDateTime2;
        String string4 = string2;
        String string5 = string3;
        return (OpdsFeed)new OpdsFeedNavigation(string5, string4, zonedDateTime3, opdsAuthor2, list4, collection2);
    }

    @PageAsQueryParam
    @GetMapping(value={"books/latest"})
    @NotNull
    public OpdsFeed getLatestBooks(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @Parameter(hidden=true) @NotNull Pageable page) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        BookSearchWithReadProgress bookSearch = new BookSearchWithReadProgress(principal.getUser().getAuthorizedLibraryIds(null), null, null, (Collection)SetsKt.setOf((Object)Media.Status.READY), null, Boolean.valueOf(false), null, null, null, null, 982, null);
        Sort.Order[] orderArray = new Sort.Order[]{Sort.Order.desc((String)"createdDate")};
        PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)Sort.by((Sort.Order[])orderArray));
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        PageRequest pageable = pageRequest;
        Page bookPage = this.bookDtoRepository.findAll(bookSearch, principal.getUser().getId(), (Pageable)pageable, principal.getUser().getRestrictions());
        UriComponentsBuilder uriBuilder = this.uriBuilder("books/latest");
        ZonedDateTime zonedDateTime = ZonedDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"now(...)");
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        String string = uriBuilder.toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUriString(...)");
        spreadBuilder.add((Object)new OpdsLinkFeedNavigation("self", string));
        spreadBuilder.add((Object)this.linkStart());
        Collection $this$toTypedArray$iv = this.linkPage(uriBuilder, bookPage);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new OpdsLink[0]));
        List list = CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new OpdsLink[spreadBuilder.size()]));
        List list2 = bookPage.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContent(...)");
        return (OpdsFeed)new OpdsFeedAcquisition("latestBooks", "Latest books", zonedDateTime, this.komgaAuthor, list, this.getEntriesWithSeriesTitle(list2));
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"libraries"})
    @NotNull
    public OpdsFeed getLibraries(@AuthenticationPrincipal @NotNull KomgaPrincipal principal) {
        Collection<OpdsEntryNavigation> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Collection libraries = principal.getUser().canAccessAllLibraries() ? this.libraryRepository.findAll() : this.libraryRepository.findAllByIds((Collection)principal.getUser().getSharedLibrariesIds());
        ZonedDateTime zonedDateTime = ZonedDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"now(...)");
        Object object = new OpdsLinkFeedNavigation[2];
        String string = this.uriBuilder("libraries").toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUriString(...)");
        object[0] = new OpdsLinkFeedNavigation("self", string);
        object[1] = this.linkStart();
        List list = CollectionsKt.listOf((Object[])object);
        object = libraries;
        List list2 = list;
        OpdsAuthor opdsAuthor = this.komgaAuthor;
        ZonedDateTime zonedDateTime2 = zonedDateTime;
        String string2 = "All libraries";
        String string3 = "allLibraries";
        boolean $i$f$map = false;
        void var5_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Library library = (Library)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toOpdsEntry((Library)it));
        }
        Collection<OpdsEntryNavigation> collection2 = collection = (List)destination$iv$iv;
        List list3 = list2;
        OpdsAuthor opdsAuthor2 = opdsAuthor;
        ZonedDateTime zonedDateTime3 = zonedDateTime2;
        String string4 = string2;
        String string5 = string3;
        return (OpdsFeed)new OpdsFeedNavigation(string5, string4, zonedDateTime3, opdsAuthor2, list3, collection2);
    }

    /*
     * WARNING - void declaration
     */
    @PageAsQueryParam
    @GetMapping(value={"collections"})
    @NotNull
    public OpdsFeed getCollections(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @Parameter(hidden=true) @NotNull Pageable page) {
        Collection<OpdsEntryNavigation> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Sort.Order[] orderArray = new Sort.Order[]{Sort.Order.asc((String)"name")};
        PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)Sort.by((Sort.Order[])orderArray));
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        PageRequest pageable = pageRequest;
        Page collections = SeriesCollectionRepository.DefaultImpls.findAll$default((SeriesCollectionRepository)this.collectionRepository, (Collection)principal.getUser().getAuthorizedLibraryIds(null), (Collection)principal.getUser().getAuthorizedLibraryIds(null), null, (Pageable)((Pageable)pageable), null, (int)20, null);
        UriComponentsBuilder uriBuilder = this.uriBuilder("collections");
        ZonedDateTime zonedDateTime = ZonedDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"now(...)");
        Object object = new SpreadBuilder(3);
        String string = uriBuilder.toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUriString(...)");
        object.add((Object)new OpdsLinkFeedNavigation("self", string));
        object.add((Object)this.linkStart());
        Collection $this$toTypedArray$iv = this.linkPage(uriBuilder, collections);
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        object.addSpread((Object)thisCollection$iv.toArray(new OpdsLink[0]));
        List list = CollectionsKt.listOf((Object[])object.toArray((Object[])new OpdsLink[object.size()]));
        List list2 = collections.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContent(...)");
        object = list2;
        List list3 = list;
        OpdsAuthor opdsAuthor = this.komgaAuthor;
        ZonedDateTime zonedDateTime2 = zonedDateTime;
        String string2 = "All collections";
        String string3 = "allCollections";
        boolean $i$f$map = false;
        void $i$f$toTypedArray22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SeriesCollection seriesCollection = (SeriesCollection)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.toOpdsEntry((SeriesCollection)it));
        }
        Collection<OpdsEntryNavigation> collection2 = collection = (List)destination$iv$iv;
        List list4 = list3;
        OpdsAuthor opdsAuthor2 = opdsAuthor;
        ZonedDateTime zonedDateTime3 = zonedDateTime2;
        String string4 = string2;
        String string5 = string3;
        return (OpdsFeed)new OpdsFeedNavigation(string5, string4, zonedDateTime3, opdsAuthor2, list4, collection2);
    }

    /*
     * WARNING - void declaration
     */
    @PageAsQueryParam
    @GetMapping(value={"readlists"})
    @NotNull
    public OpdsFeed getReadLists(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @Parameter(hidden=true) @NotNull Pageable page) {
        Collection<OpdsEntryNavigation> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Sort.Order[] orderArray = new Sort.Order[]{Sort.Order.asc((String)"name")};
        PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)Sort.by((Sort.Order[])orderArray));
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        PageRequest pageable = pageRequest;
        Page readLists = ReadListRepository.DefaultImpls.findAll$default((ReadListRepository)this.readListRepository, (Collection)principal.getUser().getAuthorizedLibraryIds(null), (Collection)principal.getUser().getAuthorizedLibraryIds(null), null, (Pageable)((Pageable)pageable), null, (int)20, null);
        UriComponentsBuilder uriBuilder = this.uriBuilder("readlists");
        ZonedDateTime zonedDateTime = ZonedDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"now(...)");
        Object object = new SpreadBuilder(3);
        String string = uriBuilder.toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUriString(...)");
        object.add((Object)new OpdsLinkFeedNavigation("self", string));
        object.add((Object)this.linkStart());
        Collection $this$toTypedArray$iv = this.linkPage(uriBuilder, readLists);
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        object.addSpread((Object)thisCollection$iv.toArray(new OpdsLink[0]));
        List list = CollectionsKt.listOf((Object[])object.toArray((Object[])new OpdsLink[object.size()]));
        List list2 = readLists.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContent(...)");
        object = list2;
        List list3 = list;
        OpdsAuthor opdsAuthor = this.komgaAuthor;
        ZonedDateTime zonedDateTime2 = zonedDateTime;
        String string2 = "All read lists";
        String string3 = "allReadLists";
        boolean $i$f$map = false;
        void $i$f$toTypedArray22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ReadList readList = (ReadList)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.toOpdsEntry((ReadList)it));
        }
        Collection<OpdsEntryNavigation> collection2 = collection = (List)destination$iv$iv;
        List list4 = list3;
        OpdsAuthor opdsAuthor2 = opdsAuthor;
        ZonedDateTime zonedDateTime3 = zonedDateTime2;
        String string4 = string2;
        String string5 = string3;
        return (OpdsFeed)new OpdsFeedNavigation(string5, string4, zonedDateTime3, opdsAuthor2, list4, collection2);
    }

    /*
     * WARNING - void declaration
     */
    @PageAsQueryParam
    @GetMapping(value={"publishers"})
    @NotNull
    public OpdsFeed getPublishers(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @Parameter(hidden=true) @NotNull Pageable page) {
        Collection<OpdsEntryNavigation> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Page publishers = this.referentialRepository.findAllPublishers(principal.getUser().getAuthorizedLibraryIds(null), page);
        UriComponentsBuilder uriBuilder = this.uriBuilder("publishers");
        ZonedDateTime zonedDateTime = ZonedDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"now(...)");
        Object object = new SpreadBuilder(3);
        String string = uriBuilder.toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUriString(...)");
        object.add((Object)new OpdsLinkFeedNavigation("self", string));
        object.add((Object)this.linkStart());
        Collection $this$toTypedArray$iv = this.linkPage(uriBuilder, publishers);
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        object.addSpread((Object)thisCollection$iv.toArray(new OpdsLink[0]));
        List list = CollectionsKt.listOf((Object[])object.toArray((Object[])new OpdsLink[object.size()]));
        List list2 = publishers.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContent(...)");
        object = list2;
        List list3 = list;
        OpdsAuthor opdsAuthor = this.komgaAuthor;
        ZonedDateTime zonedDateTime2 = zonedDateTime;
        String string2 = "All publishers";
        String string3 = "allPublishers";
        boolean $i$f$map = false;
        void $i$f$toTypedArray22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void publisher;
            String string4 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)publisher);
            ZonedDateTime zonedDateTime3 = ZonedDateTime.now();
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime3, (String)"now(...)");
            String string5 = "publisher:" + UriUtils.encodeQueryParam((String)publisher, (Charset)StandardCharsets.UTF_8);
            Object[] objectArray = new Object[]{publisher};
            String string6 = this.uriBuilder("series").queryParam("publisher", objectArray).toUriString();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toUriString(...)");
            collection.add(new OpdsEntryNavigation((String)publisher, zonedDateTime3, string5, "", (OpdsLink)new OpdsLinkFeedNavigation("subsection", string6)));
        }
        Collection<OpdsEntryNavigation> collection2 = collection = (List)destination$iv$iv;
        List list4 = list3;
        OpdsAuthor opdsAuthor2 = opdsAuthor;
        ZonedDateTime zonedDateTime4 = zonedDateTime2;
        String string7 = string2;
        String string8 = string3;
        return (OpdsFeed)new OpdsFeedNavigation(string8, string7, zonedDateTime4, opdsAuthor2, list4, (List)collection2);
    }

    @PageAsQueryParam
    @GetMapping(value={"series/{id}"})
    @NotNull
    public OpdsFeed getOneSeries(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String id, @Parameter(hidden=true) @NotNull Pageable page) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        SeriesDto seriesDto = this.seriesDtoRepository.findByIdOrNull(id, principal.getUser().getId());
        if (seriesDto == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        SeriesDto series = seriesDto;
        boolean bl = false;
        this.contentRestrictionChecker.checkContentRestriction(principal.getUser(), series);
        BookSearchWithReadProgress bookSearch = new BookSearchWithReadProgress(null, (Collection)CollectionsKt.listOf((Object)id), null, (Collection)SetsKt.setOf((Object)Media.Status.READY), null, Boolean.valueOf(false), null, null, null, null, 981, null);
        Sort.Order[] orderArray = new Sort.Order[]{Sort.Order.asc((String)"metadata.numberSort")};
        PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)Sort.by((Sort.Order[])orderArray));
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        PageRequest pageable = pageRequest;
        Page page2 = this.bookDtoRepository.findAll(bookSearch, principal.getUser().getId(), (Pageable)pageable, principal.getUser().getRestrictions()).map(arg_0 -> OpdsController.getOneSeries$lambda$7$lambda$6((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        Page entries2 = page2;
        UriComponentsBuilder uriBuilder = this.uriBuilder("series/" + id);
        String string = series.getId();
        String string2 = series.getMetadata().getTitle();
        ZonedDateTime zonedDateTime = LanguageUtilsKt.toZonedDateTime((LocalDateTime)series.getLastModified());
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        String string3 = uriBuilder.toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUriString(...)");
        spreadBuilder.add((Object)new OpdsLinkFeedNavigation("self", string3));
        spreadBuilder.add((Object)this.linkStart());
        Collection $this$toTypedArray$iv = this.linkPage(uriBuilder, entries2);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new OpdsLink[0]));
        List list = CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new OpdsLink[spreadBuilder.size()]));
        List list2 = entries2.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContent(...)");
        return (OpdsFeed)new OpdsFeedAcquisition(string, string2, zonedDateTime, this.komgaAuthor, list, list2);
    }

    @PageAsQueryParam
    @GetMapping(value={"libraries/{id}"})
    @NotNull
    public OpdsFeed getOneLibrary(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String id, @Parameter(hidden=true) @NotNull Pageable page) {
        ZonedDateTime zonedDateTime;
        String string;
        String string2;
        UriComponentsBuilder uriBuilder;
        Page entries2;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Library library = this.libraryRepository.findByIdOrNull(id);
        if (library != null) {
            Library library2 = library;
            boolean bl = false;
            if (!principal.getUser().canAccessLibrary(library2)) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
            }
            SeriesSearchWithReadProgress seriesSearch = new SeriesSearchWithReadProgress((Collection)SetsKt.setOf((Object)library2.getId()), null, null, null, null, null, Boolean.valueOf(false), null, null, null, null, null, null, null, null, null, null, 131006, null);
            Sort.Order[] orderArray = new Sort.Order[]{Sort.Order.asc((String)"metadata.titleSort")};
            PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)Sort.by((Sort.Order[])orderArray));
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            PageRequest pageable = pageRequest;
            Page page2 = this.seriesDtoRepository.findAll(seriesSearch, principal.getUser().getId(), (Pageable)pageable, principal.getUser().getRestrictions()).map(arg_0 -> OpdsController.getOneLibrary$lambda$9$lambda$8((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
            entries2 = page2;
            uriBuilder = this.uriBuilder("libraries/" + id);
            string2 = library2.getId();
            string = library2.getName();
            zonedDateTime = library2.getLastModifiedDate().atZone(ZoneId.systemDefault());
            if (zonedDateTime == null) {
                zonedDateTime = ZonedDateTime.now();
            }
        } else {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        ZonedDateTime zonedDateTime2 = zonedDateTime;
        Intrinsics.checkNotNull((Object)zonedDateTime2);
        ZonedDateTime zonedDateTime3 = zonedDateTime2;
        zonedDateTime2 = new SpreadBuilder(3);
        String string3 = uriBuilder.toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUriString(...)");
        zonedDateTime2.add(new OpdsLinkFeedNavigation("self", string3));
        zonedDateTime2.add(this.linkStart());
        Collection $this$toTypedArray$iv = this.linkPage(uriBuilder, entries2);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        zonedDateTime2.addSpread(thisCollection$iv.toArray(new OpdsLink[0]));
        List list = CollectionsKt.listOf((Object[])zonedDateTime2.toArray(new OpdsLink[zonedDateTime2.size()]));
        List list2 = entries2.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContent(...)");
        return (OpdsFeed)new OpdsFeedNavigation(string2, string, zonedDateTime3, this.komgaAuthor, list, list2);
    }

    @PageAsQueryParam
    @GetMapping(value={"collections/{id}"})
    @NotNull
    public OpdsFeed getOneCollection(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String id, @Parameter(hidden=true) @NotNull Pageable page) {
        ZonedDateTime zonedDateTime;
        String string;
        String string2;
        UriComponentsBuilder uriBuilder;
        Page entries2;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        SeriesCollection seriesCollection = SeriesCollectionRepository.DefaultImpls.findByIdOrNull$default((SeriesCollectionRepository)this.collectionRepository, (String)id, (Collection)principal.getUser().getAuthorizedLibraryIds(null), null, (int)4, null);
        if (seriesCollection != null) {
            Sort sort;
            SeriesCollection collection = seriesCollection;
            boolean bl = false;
            if (collection.getOrdered()) {
                var6_6 = new Sort.Order[]{Sort.Order.asc((String)"collection.number")};
                sort = Sort.by((Sort.Order[])var6_6);
            } else {
                var6_6 = new Sort.Order[]{Sort.Order.asc((String)"metadata.titleSort")};
                sort = Sort.by((Sort.Order[])var6_6);
            }
            Sort sort2 = sort;
            Intrinsics.checkNotNull((Object)sort2);
            Sort sort3 = sort2;
            PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)sort3);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            PageRequest pageable = pageRequest;
            SeriesSearchWithReadProgress seriesSearch = new SeriesSearchWithReadProgress(principal.getUser().getAuthorizedLibraryIds(null), null, null, null, null, null, Boolean.valueOf(false), null, null, null, null, null, null, null, null, null, null, 131006, null);
            Page page2 = this.seriesDtoRepository.findAllByCollectionId(collection.getId(), seriesSearch, principal.getUser().getId(), (Pageable)pageable, principal.getUser().getRestrictions()).map(arg_0 -> OpdsController.getOneCollection$lambda$11$lambda$10((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
            entries2 = page2;
            uriBuilder = this.uriBuilder("collections/" + id);
            string2 = collection.getId();
            string = collection.getName();
            zonedDateTime = collection.getLastModifiedDate().atZone(ZoneId.systemDefault());
            if (zonedDateTime == null) {
                zonedDateTime = ZonedDateTime.now();
            }
        } else {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        ZonedDateTime zonedDateTime2 = zonedDateTime;
        Intrinsics.checkNotNull((Object)zonedDateTime2);
        ZonedDateTime zonedDateTime3 = zonedDateTime2;
        zonedDateTime2 = new SpreadBuilder(3);
        String string3 = uriBuilder.toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUriString(...)");
        zonedDateTime2.add(new OpdsLinkFeedNavigation("self", string3));
        zonedDateTime2.add(this.linkStart());
        Collection $this$toTypedArray$iv = this.linkPage(uriBuilder, entries2);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        zonedDateTime2.addSpread(thisCollection$iv.toArray(new OpdsLink[0]));
        List list = CollectionsKt.listOf((Object[])zonedDateTime2.toArray(new OpdsLink[zonedDateTime2.size()]));
        List list2 = entries2.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContent(...)");
        return (OpdsFeed)new OpdsFeedNavigation(string2, string, zonedDateTime3, this.komgaAuthor, list, list2);
    }

    @PageAsQueryParam
    @GetMapping(value={"readlists/{id}"})
    @NotNull
    public OpdsFeed getOneReadList(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String id, @Parameter(hidden=true) @NotNull Pageable page) {
        ZonedDateTime zonedDateTime;
        String string;
        String string2;
        UriComponentsBuilder uriBuilder;
        Page entries2;
        Page booksPage;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        ReadList readList = ReadListRepository.DefaultImpls.findByIdOrNull$default((ReadListRepository)this.readListRepository, (String)id, (Collection)principal.getUser().getAuthorizedLibraryIds(null), null, (int)4, null);
        if (readList != null) {
            Sort sort;
            ReadList readList2 = readList;
            boolean bl = false;
            if (readList2.getOrdered()) {
                var6_6 = new Sort.Order[]{Sort.Order.asc((String)"readList.number")};
                sort = Sort.by((Sort.Order[])var6_6);
            } else {
                var6_6 = new Sort.Order[]{Sort.Order.asc((String)"metadata.releaseDate")};
                sort = Sort.by((Sort.Order[])var6_6);
            }
            Sort sort2 = sort;
            Intrinsics.checkNotNull((Object)sort2);
            Sort sort3 = sort2;
            PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)sort3);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            PageRequest pageable = pageRequest;
            BookSearchWithReadProgress bookSearch = new BookSearchWithReadProgress(null, null, null, (Collection)SetsKt.setOf((Object)Media.Status.READY), null, Boolean.valueOf(false), null, null, null, null, 983, null);
            booksPage = this.bookDtoRepository.findAllByReadListId(readList2.getId(), principal.getUser().getId(), principal.getUser().getAuthorizedLibraryIds(null), bookSearch, (Pageable)pageable, principal.getUser().getRestrictions());
            Page page2 = booksPage.map(arg_0 -> OpdsController.getOneReadList$lambda$13$lambda$12((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
            entries2 = page2;
            uriBuilder = this.uriBuilder("readlists/" + id);
            string2 = readList2.getId();
            string = readList2.getName();
            zonedDateTime = readList2.getLastModifiedDate().atZone(ZoneId.systemDefault());
            if (zonedDateTime == null) {
                zonedDateTime = ZonedDateTime.now();
            }
        } else {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        ZonedDateTime zonedDateTime2 = zonedDateTime;
        Intrinsics.checkNotNull((Object)zonedDateTime2);
        ZonedDateTime zonedDateTime3 = zonedDateTime2;
        zonedDateTime2 = new SpreadBuilder(3);
        String string3 = uriBuilder.toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUriString(...)");
        zonedDateTime2.add(new OpdsLinkFeedNavigation("self", string3));
        zonedDateTime2.add(this.linkStart());
        Collection $this$toTypedArray$iv = this.linkPage(uriBuilder, booksPage);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        zonedDateTime2.addSpread(thisCollection$iv.toArray(new OpdsLink[0]));
        List list = CollectionsKt.listOf((Object[])zonedDateTime2.toArray(new OpdsLink[zonedDateTime2.size()]));
        List list2 = entries2.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContent(...)");
        return (OpdsFeed)new OpdsFeedAcquisition(string2, string, zonedDateTime3, this.komgaAuthor, list, list2);
    }

    @ApiResponse(content={@Content(schema=@Schema(format="binary", type="string"))})
    @GetMapping(value={"books/{bookId}/thumbnail/small"}, produces={"image/jpeg"})
    @NotNull
    public byte[] getBookThumbnailSmall(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String bookId) {
        Object object;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
                Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
                this.contentRestrictionChecker.checkContentRestriction(principal.getUser(), bookId);
                ThumbnailBook thumbnailBook = this.bookLifecycle.getThumbnail(bookId);
                if (thumbnailBook == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
                }
                ThumbnailBook thumbnail = thumbnailBook;
                object = this.bookLifecycle.getThumbnailBytes(bookId, thumbnail.getType() == ThumbnailBook.Type.GENERATED ? null : Integer.valueOf(this.komgaSettingsProvider.getThumbnailSize().getMaxEdge()));
                if (object == null) break block4;
                byte[] byArray = object.getBytes();
                object = byArray;
                if (byArray != null) break block5;
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return object;
    }

    @ApiResponse(content={@Content(mediaType="image/*", schema=@Schema(format="binary", type="string"))})
    @GetMapping(value={"books/{bookId}/pages/{pageNumber}"}, produces={"image/png", "image/gif", "image/jpeg"})
    @PreAuthorize(value="hasRole('PAGE_STREAMING')")
    @NotNull
    public ResponseEntity<byte[]> getBookPageOpds(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @NotNull ServletWebRequest request, @PathVariable @NotNull String bookId, @PathVariable int pageNumber, @Parameter(description="Convert the image to the provided format.", schema=@Schema(allowableValues={"jpeg", "png"})) @RequestParam(value="convert", required=false) @Nullable String convertTo) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        return this.commonBookController.getBookPageInternal(bookId, pageNumber + 1, convertTo, request, principal, null);
    }

    private OpdsEntryNavigation toOpdsEntry(SeriesDto $this$toOpdsEntry, Integer prepend) {
        Object object;
        block5: {
            block4: {
                object = prepend;
                if (object == null) break block4;
                int it = ((Number)object).intValue();
                boolean bl = false;
                String string = this.decimalFormat.format((Object)it) + " - ";
                object = string;
                if (string != null) break block5;
            }
            object = "";
        }
        Object pre = object;
        String string = (String)pre + $this$toOpdsEntry.getMetadata().getTitle();
        ZonedDateTime zonedDateTime = $this$toOpdsEntry.getLastModified().atZone(ZoneId.of("Z"));
        if (zonedDateTime == null) {
            zonedDateTime = ZonedDateTime.now();
        }
        ZonedDateTime zonedDateTime2 = zonedDateTime;
        Intrinsics.checkNotNull((Object)zonedDateTime2);
        String string2 = $this$toOpdsEntry.getId();
        String string3 = this.uriBuilder("series/" + $this$toOpdsEntry.getId()).toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUriString(...)");
        return new OpdsEntryNavigation(string, zonedDateTime2, string2, "", (OpdsLink)new OpdsLinkFeedNavigation("subsection", string3));
    }

    static /* synthetic */ OpdsEntryNavigation toOpdsEntry$default(OpdsController opdsController, SeriesDto seriesDto, Integer n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toOpdsEntry");
        }
        if ((n2 & 1) != 0) {
            n = null;
        }
        return opdsController.toOpdsEntry(seriesDto, n);
    }

    /*
     * WARNING - void declaration
     */
    private OpdsEntryAcquisition toOpdsEntry(BookDto $this$toOpdsEntry, Media media, Function1<? super BookDto, String> prepend) {
        Collection<OpdsAuthor> collection;
        void $this$mapTo$iv$iv;
        void $this$toOpdsEntry_u24lambda_u2417;
        OpdsLinkPageStreaming opdsLinkPageStreaming;
        BookPage it;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        Object $this$map$iv;
        MediaProfile mediaProfile2 = media.getProfile();
        List mediaTypes = switch (mediaProfile2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[mediaProfile2.ordinal()]) {
            case 1 -> {
                Collection var16_17;
                Iterable $this$mapTo$iv$iv;
                $this$map$iv = media.getPages();
                boolean $i$f$map = false;
                Iterable var9_8 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    BookPage var14_15 = (BookPage)item$iv$iv;
                    var16_17 = destination$iv$iv;
                    boolean $i$a$-map-OpdsController$toOpdsEntry$mediaTypes$1 = false;
                    var16_17.add(it.getMediaType());
                }
                yield CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            }
            case 2 -> CollectionsKt.listOf((Object)this.pdfImageType.getMediaType());
            case 3 -> {
                Collection var16_17;
                Iterable $this$mapTo$iv$iv;
                boolean $i$f$map;
                if (media.getEpubDivinaCompatible()) {
                    $this$map$iv = media.getPages();
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        it = (BookPage)item$iv$iv;
                        var16_17 = destination$iv$iv;
                        boolean $i$a$-map-OpdsController$toOpdsEntry$mediaTypes$2 = false;
                        var16_17.add(it.getMediaType());
                    }
                    yield CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                }
                yield CollectionsKt.emptyList();
            }
            case -1 -> CollectionsKt.emptyList();
            default -> throw new NoWhenBranchMatchedException();
        };
        if (mediaTypes.isEmpty()) {
            opdsLinkPageStreaming = null;
        } else if (mediaTypes.size() == 1 && this.opdsPseSupportedFormats.contains(CollectionsKt.first((List)mediaTypes))) {
            ReadProgressDto readProgressDto = $this$toOpdsEntry.getReadProgress();
            ReadProgressDto readProgressDto2 = $this$toOpdsEntry.getReadProgress();
            opdsLinkPageStreaming = new OpdsLinkPageStreaming((String)CollectionsKt.first((List)mediaTypes), this.uriBuilder("books/" + $this$toOpdsEntry.getId() + "/pages/").toUriString() + "{pageNumber}", media.getPageCount(), readProgressDto != null ? Integer.valueOf(readProgressDto.getPage()) : null, readProgressDto2 != null ? readProgressDto2.getReadDate() : null);
        } else {
            ReadProgressDto readProgressDto = $this$toOpdsEntry.getReadProgress();
            ReadProgressDto readProgressDto3 = $this$toOpdsEntry.getReadProgress();
            opdsLinkPageStreaming = new OpdsLinkPageStreaming("image/jpeg", this.uriBuilder("books/" + $this$toOpdsEntry.getId() + "/pages/").toUriString() + "{pageNumber}?convert=jpeg", media.getPageCount(), readProgressDto != null ? Integer.valueOf(readProgressDto.getPage()) : null, readProgressDto3 != null ? readProgressDto3.getReadDate() : null);
        }
        OpdsLinkPageStreaming opdsLinkPageStreaming2 = opdsLinkPageStreaming;
        MediaProfile mediaProfile3 = media.getProfile();
        String thumbnailMediaType = (mediaProfile3 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[mediaProfile3.ordinal()]) == 2 ? this.pdfImageType.getMediaType() : "image/jpeg";
        Object $i$f$map = $this$map$iv = new StringBuilder();
        String string = $this$toOpdsEntry.getId();
        ZonedDateTime zonedDateTime = LanguageUtilsKt.toZonedDateTime((LocalDateTime)$this$toOpdsEntry.getLastModified());
        String string2 = prepend.invoke((Object)$this$toOpdsEntry) + $this$toOpdsEntry.getMetadata().getTitle();
        boolean $i$a$-buildString-OpdsController$toOpdsEntry$32 = false;
        String string3 = FilenameUtils.getExtension((String)$this$toOpdsEntry.getUrl());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getExtension(...)");
        String string4 = string3.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        $this$toOpdsEntry_u24lambda_u2417.append(string4 + " - " + $this$toOpdsEntry.getSize());
        if (!StringsKt.isBlank((CharSequence)$this$toOpdsEntry.getMetadata().getSummary())) {
            $this$toOpdsEntry_u24lambda_u2417.append("\n\n" + $this$toOpdsEntry.getMetadata().getSummary());
        }
        Object object = Unit.INSTANCE;
        String string5 = ((StringBuilder)$this$map$iv).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
        $this$map$iv = $this$toOpdsEntry.getMetadata().getAuthors();
        object = string5;
        boolean $i$f$map2 = false;
        Object $i$a$-buildString-OpdsController$toOpdsEntry$32 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (AuthorDto)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new OpdsAuthor(it.getName(), null, 2, null));
        }
        collection = (List)destination$iv$iv;
        Object[] objectArray = new OpdsLink[4];
        String string6 = this.uriBuilder("books/" + $this$toOpdsEntry.getId() + "/thumbnail/small").toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toUriString(...)");
        objectArray[0] = new OpdsLinkImageThumbnail("image/jpeg", string6);
        String string7 = this.uriBuilder("books/" + $this$toOpdsEntry.getId() + "/thumbnail").toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toUriString(...)");
        objectArray[1] = new OpdsLinkImage(thumbnailMediaType, string7);
        String string8 = media.getMediaType();
        String string9 = $this$toOpdsEntry.getId();
        String string10 = FilenameUtils.getName((String)$this$toOpdsEntry.getUrl());
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"getName(...)");
        String string11 = this.uriBuilder("books/" + string9 + "/file/" + this.sanitize(string10)).toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"toUriString(...)");
        objectArray[2] = new OpdsLinkFileAcquisition(string8, string11);
        objectArray[3] = opdsLinkPageStreaming2;
        List list = CollectionsKt.listOfNotNull((Object[])objectArray);
        Collection<OpdsAuthor> collection2 = collection;
        Object object2 = object;
        String string12 = string;
        ZonedDateTime zonedDateTime2 = zonedDateTime;
        String string13 = string2;
        return new OpdsEntryAcquisition(string13, zonedDateTime2, string12, (String)object2, collection2, list);
    }

    static /* synthetic */ OpdsEntryAcquisition toOpdsEntry$default(OpdsController opdsController, BookDto bookDto, Media media, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toOpdsEntry");
        }
        if ((n & 2) != 0) {
            function1 = (Function1)toOpdsEntry.1.INSTANCE;
        }
        return opdsController.toOpdsEntry(bookDto, media, function1);
    }

    private OpdsEntryNavigation toOpdsEntry(Library $this$toOpdsEntry) {
        String string = $this$toOpdsEntry.getName();
        ZonedDateTime zonedDateTime = $this$toOpdsEntry.getLastModifiedDate().atZone(ZoneId.systemDefault());
        if (zonedDateTime == null) {
            zonedDateTime = ZonedDateTime.now();
        }
        ZonedDateTime zonedDateTime2 = zonedDateTime;
        Intrinsics.checkNotNull((Object)zonedDateTime2);
        String string2 = $this$toOpdsEntry.getId();
        String string3 = this.uriBuilder("libraries/" + $this$toOpdsEntry.getId()).toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUriString(...)");
        return new OpdsEntryNavigation(string, zonedDateTime2, string2, "", (OpdsLink)new OpdsLinkFeedNavigation("subsection", string3));
    }

    private OpdsEntryNavigation toOpdsEntry(SeriesCollection $this$toOpdsEntry) {
        String string = $this$toOpdsEntry.getName();
        ZonedDateTime zonedDateTime = $this$toOpdsEntry.getLastModifiedDate().atZone(ZoneId.systemDefault());
        if (zonedDateTime == null) {
            zonedDateTime = ZonedDateTime.now();
        }
        ZonedDateTime zonedDateTime2 = zonedDateTime;
        Intrinsics.checkNotNull((Object)zonedDateTime2);
        String string2 = $this$toOpdsEntry.getId();
        String string3 = this.uriBuilder("collections/" + $this$toOpdsEntry.getId()).toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUriString(...)");
        return new OpdsEntryNavigation(string, zonedDateTime2, string2, "", (OpdsLink)new OpdsLinkFeedNavigation("subsection", string3));
    }

    private OpdsEntryNavigation toOpdsEntry(ReadList $this$toOpdsEntry) {
        String string = $this$toOpdsEntry.getName();
        ZonedDateTime zonedDateTime = $this$toOpdsEntry.getLastModifiedDate().atZone(ZoneId.systemDefault());
        if (zonedDateTime == null) {
            zonedDateTime = ZonedDateTime.now();
        }
        ZonedDateTime zonedDateTime2 = zonedDateTime;
        Intrinsics.checkNotNull((Object)zonedDateTime2);
        String string2 = $this$toOpdsEntry.getId();
        String string3 = this.uriBuilder("readlists/" + $this$toOpdsEntry.getId()).toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUriString(...)");
        return new OpdsEntryNavigation(string, zonedDateTime2, string2, "", (OpdsLink)new OpdsLinkFeedNavigation("subsection", string3));
    }

    /*
     * WARNING - void declaration
     */
    private List<OpdsEntryAcquisition> getEntriesWithSeriesTitle(List<BookDto> $this$getEntriesWithSeriesTitle) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$getEntriesWithSeriesTitle;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void bookDto;
            BookDto bookDto2 = (BookDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toOpdsEntry((BookDto)bookDto, this.mediaRepository.findById(bookDto.getId()), (Function1)getEntriesWithSeriesTitle.1.1.INSTANCE));
        }
        return (List)destination$iv$iv;
    }

    private String sanitize(String fileName) {
        return StringsKt.replace$default((String)fileName, (String)";", (String)"", (boolean)false, (int)4, null);
    }

    private static final OpdsEntryAcquisition getOneSeries$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (OpdsEntryAcquisition)$tmp0.invoke(p0);
    }

    private static final OpdsEntryNavigation getOneLibrary$lambda$9$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (OpdsEntryNavigation)$tmp0.invoke(p0);
    }

    private static final OpdsEntryNavigation getOneCollection$lambda$11$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (OpdsEntryNavigation)$tmp0.invoke(p0);
    }

    private static final OpdsEntryAcquisition getOneReadList$lambda$13$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (OpdsEntryAcquisition)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ MediaRepository access$getMediaRepository$p(OpdsController $this) {
        return $this.mediaRepository;
    }

    public static final /* synthetic */ OpdsEntryAcquisition access$toOpdsEntry(OpdsController $this, BookDto $receiver, Media media, Function1 prepend) {
        return $this.toOpdsEntry($receiver, media, prepend);
    }
}

