/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.rest;

import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.NotBlank;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gotson.komga.domain.model.KomgaUser;
import org.gotson.komga.domain.service.KomgaUserLifecycle;
import org.gotson.komga.interfaces.api.rest.ClaimController;
import org.gotson.komga.interfaces.api.rest.dto.UserDto;
import org.gotson.komga.interfaces.api.rest.dto.UserDtoKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"api/v1/claim"}, produces={"application/json"})
@Validated
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\bH\u0017J\b\u0010\n\u001a\u00020\u000bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/gotson/komga/interfaces/api/rest/ClaimController;", "", "userDetailsLifecycle", "Lorg/gotson/komga/domain/service/KomgaUserLifecycle;", "(Lorg/gotson/komga/domain/service/KomgaUserLifecycle;)V", "claimAdmin", "Lorg/gotson/komga/interfaces/api/rest/dto/UserDto;", "email", "", "password", "getClaimStatus", "Lorg/gotson/komga/interfaces/api/rest/ClaimController$ClaimStatus;", "ClaimStatus", "komga"})
public class ClaimController {
    @NotNull
    private final KomgaUserLifecycle userDetailsLifecycle;

    public ClaimController(@NotNull KomgaUserLifecycle userDetailsLifecycle) {
        Intrinsics.checkNotNullParameter((Object)userDetailsLifecycle, (String)"userDetailsLifecycle");
        this.userDetailsLifecycle = userDetailsLifecycle;
    }

    @GetMapping
    @NotNull
    public ClaimStatus getClaimStatus() {
        return new ClaimStatus(this.userDetailsLifecycle.countUsers() > 0L);
    }

    @PostMapping
    @NotNull
    public UserDto claimAdmin(@Email(regexp=".+@.+\\..+") @RequestHeader(value="X-Komga-Email") @NotNull String email, @NotBlank @RequestHeader(value="X-Komga-Password") @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        if (this.userDetailsLifecycle.countUsers() > 0L) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "This server has already been claimed");
        }
        return UserDtoKt.toDto((KomgaUser)this.userDetailsLifecycle.createUser(new KomgaUser(email, password, true, true, true, true, null, false, null, null, null, null, 4032, null)));
    }
}

