/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.rest;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.application.tasks.TaskEmitter;
import org.gotson.komga.domain.model.BookPageNumbered;
import org.gotson.komga.domain.model.PageHashKnown;
import org.gotson.komga.domain.model.PageHashMatch;
import org.gotson.komga.domain.model.TypedBytes;
import org.gotson.komga.domain.persistence.PageHashRepository;
import org.gotson.komga.domain.service.PageHashLifecycle;
import org.gotson.komga.infrastructure.swagger.PageableAsQueryParam;
import org.gotson.komga.infrastructure.web.UtilsKt;
import org.gotson.komga.interfaces.api.rest.PageHashController;
import org.gotson.komga.interfaces.api.rest.dto.PageHashCreationDto;
import org.gotson.komga.interfaces.api.rest.dto.PageHashKnownDto;
import org.gotson.komga.interfaces.api.rest.dto.PageHashMatchDto;
import org.gotson.komga.interfaces.api.rest.dto.PageHashUnknownDto;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"api/v1/page-hashes"}, produces={"application/json"})
@PreAuthorize(value="hasRole('ADMIN')")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0017J\u001c\u0010\r\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0017J\u0012\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u000b\u001a\u00020\u000eH\u0017J*\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0010\b\u0001\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00172\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0017J\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\b\b\u0001\u0010\u000b\u001a\u00020\u000e2\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0017J)\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u001d2\b\b\u0001\u0010\u000b\u001a\u00020\u000e2\n\b\u0003\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0017\u00a2\u0006\u0002\u0010 J\u0018\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00142\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0017J\u0012\u0010#\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\u000eH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/gotson/komga/interfaces/api/rest/PageHashController;", "", "pageHashRepository", "Lorg/gotson/komga/domain/persistence/PageHashRepository;", "pageHashLifecycle", "Lorg/gotson/komga/domain/service/PageHashLifecycle;", "taskEmitter", "Lorg/gotson/komga/application/tasks/TaskEmitter;", "(Lorg/gotson/komga/domain/persistence/PageHashRepository;Lorg/gotson/komga/domain/service/PageHashLifecycle;Lorg/gotson/komga/application/tasks/TaskEmitter;)V", "createOrUpdateKnownPageHash", "", "pageHash", "Lorg/gotson/komga/interfaces/api/rest/dto/PageHashCreationDto;", "deleteSingleMatch", "", "matchDto", "Lorg/gotson/komga/interfaces/api/rest/dto/PageHashMatchDto;", "getKnownPageHashThumbnail", "", "getKnownPageHashes", "Lorg/springframework/data/domain/Page;", "Lorg/gotson/komga/interfaces/api/rest/dto/PageHashKnownDto;", "actions", "", "Lorg/gotson/komga/domain/model/PageHashKnown$Action;", "page", "Lorg/springframework/data/domain/Pageable;", "getPageHashMatches", "getUnknownPageHashThumbnail", "Lorg/springframework/http/ResponseEntity;", "resize", "", "(Ljava/lang/String;Ljava/lang/Integer;)Lorg/springframework/http/ResponseEntity;", "getUnknownPageHashes", "Lorg/gotson/komga/interfaces/api/rest/dto/PageHashUnknownDto;", "performDelete", "komga"})
@SourceDebugExtension(value={"SMAP\nPageHashController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PageHashController.kt\norg/gotson/komga/interfaces/api/rest/PageHashController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,157:1\n1490#2:158\n1520#2,3:159\n1523#2,3:169\n372#3,7:162\n*S KotlinDebug\n*F\n+ 1 PageHashController.kt\norg/gotson/komga/interfaces/api/rest/PageHashController\n*L\n118#1:158\n118#1:159,3\n118#1:169,3\n118#1:162,7\n*E\n"})
public class PageHashController {
    @NotNull
    private final PageHashRepository pageHashRepository;
    @NotNull
    private final PageHashLifecycle pageHashLifecycle;
    @NotNull
    private final TaskEmitter taskEmitter;

    public PageHashController(@NotNull PageHashRepository pageHashRepository, @NotNull PageHashLifecycle pageHashLifecycle, @NotNull TaskEmitter taskEmitter) {
        Intrinsics.checkNotNullParameter((Object)pageHashRepository, (String)"pageHashRepository");
        Intrinsics.checkNotNullParameter((Object)pageHashLifecycle, (String)"pageHashLifecycle");
        Intrinsics.checkNotNullParameter((Object)taskEmitter, (String)"taskEmitter");
        this.pageHashRepository = pageHashRepository;
        this.pageHashLifecycle = pageHashLifecycle;
        this.taskEmitter = taskEmitter;
    }

    @GetMapping
    @PageableAsQueryParam
    @NotNull
    public Page<PageHashKnownDto> getKnownPageHashes(@RequestParam(name="action", required=false) @Nullable List<? extends PageHashKnown.Action> actions, @Parameter(hidden=true) @NotNull Pageable page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Page page2 = this.pageHashRepository.findAllKnown(actions, page).map(arg_0 -> PageHashController.getKnownPageHashes$lambda$0((Function1)getKnownPageHashes.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    @GetMapping(value={"/{pageHash}/thumbnail"}, produces={"image/jpeg"})
    @ApiResponse(content={@Content(schema=@Schema(format="binary", type="string"))})
    @NotNull
    public byte[] getKnownPageHashThumbnail(@PathVariable @NotNull String pageHash) {
        Intrinsics.checkNotNullParameter((Object)pageHash, (String)"pageHash");
        byte[] byArray = this.pageHashRepository.getKnownThumbnail(pageHash);
        if (byArray == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return byArray;
    }

    @GetMapping(value={"/unknown"})
    @PageableAsQueryParam
    @NotNull
    public Page<PageHashUnknownDto> getUnknownPageHashes(@Parameter(hidden=true) @NotNull Pageable page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Page page2 = this.pageHashRepository.findAllUnknown(page).map(arg_0 -> PageHashController.getUnknownPageHashes$lambda$1((Function1)getUnknownPageHashes.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    @GetMapping(value={"{pageHash}"})
    @PageableAsQueryParam
    @NotNull
    public Page<PageHashMatchDto> getPageHashMatches(@PathVariable @NotNull String pageHash, @Parameter(hidden=true) @NotNull Pageable page) {
        Intrinsics.checkNotNullParameter((Object)pageHash, (String)"pageHash");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Page page2 = this.pageHashRepository.findMatchesByHash(pageHash, page).map(arg_0 -> PageHashController.getPageHashMatches$lambda$2((Function1)getPageHashMatches.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    @GetMapping(value={"unknown/{pageHash}/thumbnail"}, produces={"image/jpeg"})
    @ApiResponse(content={@Content(schema=@Schema(format="binary", type="string"))})
    @NotNull
    public ResponseEntity<byte[]> getUnknownPageHashThumbnail(@PathVariable @NotNull String pageHash, @RequestParam(value="resize") @Nullable Integer resize) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)pageHash, (String)"pageHash");
        TypedBytes typedBytes = this.pageHashLifecycle.getPage(pageHash, resize);
        if (typedBytes != null) {
            TypedBytes it = typedBytes;
            boolean bl = false;
            v1 = ResponseEntity.ok().contentType(UtilsKt.getMediaTypeOrDefault((String)it.getMediaType())).body((Object)it.getBytes());
        } else {
            v1 = responseEntity = null;
        }
        if (responseEntity == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return responseEntity;
    }

    public static /* synthetic */ ResponseEntity getUnknownPageHashThumbnail$default(PageHashController pageHashController, String string, Integer n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getUnknownPageHashThumbnail");
        }
        if ((n2 & 2) != 0) {
            n = null;
        }
        return pageHashController.getUnknownPageHashThumbnail(string, n);
    }

    @PutMapping
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void createOrUpdateKnownPageHash(@Valid @RequestBody @NotNull PageHashCreationDto pageHash) {
        Intrinsics.checkNotNullParameter((Object)pageHash, (String)"pageHash");
        try {
            this.pageHashLifecycle.createOrUpdate(new PageHashKnown(pageHash.getHash(), pageHash.getSize(), pageHash.getAction(), 0, 0, null, null, 120, null));
        }
        catch (IllegalArgumentException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"{pageHash}/delete-all"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void performDelete(@PathVariable @NotNull String pageHash) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)pageHash, (String)"pageHash");
        Pageable pageable = Pageable.unpaged();
        Intrinsics.checkNotNullExpressionValue((Object)pageable, (String)"unpaged(...)");
        Iterable $this$groupBy$iv = (Iterable)this.pageHashRepository.findMatchesByHash(pageHash, pageable);
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            PageHashMatch it = (PageHashMatch)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getBookId();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            it = (PageHashMatch)element$iv$iv;
            List list = list$iv$iv;
            boolean bl3 = false;
            list.add(new BookPageNumbered(it.getFileName(), it.getMediaType(), null, pageHash, Long.valueOf(it.getFileSize()), it.getPageNumber(), 4, null));
        }
        Map toRemove = destination$iv$iv;
        TaskEmitter.removeDuplicatePages$default((TaskEmitter)this.taskEmitter, (Map)toRemove, (int)0, (int)2, null);
    }

    @PostMapping(value={"{pageHash}/delete-match"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void deleteSingleMatch(@PathVariable @NotNull String pageHash, @RequestBody @NotNull PageHashMatchDto matchDto) {
        Intrinsics.checkNotNullParameter((Object)pageHash, (String)"pageHash");
        Intrinsics.checkNotNullParameter((Object)matchDto, (String)"matchDto");
        Pair toRemove = new Pair((Object)matchDto.getBookId(), (Object)CollectionsKt.listOf((Object)new BookPageNumbered(matchDto.getFileName(), matchDto.getMediaType(), null, pageHash, Long.valueOf(matchDto.getFileSize()), matchDto.getPageNumber(), 4, null)));
        TaskEmitter.removeDuplicatePages$default((TaskEmitter)this.taskEmitter, (String)((String)toRemove.getFirst()), (Collection)((Collection)toRemove.getSecond()), (int)0, (int)4, null);
    }

    private static final PageHashKnownDto getKnownPageHashes$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PageHashKnownDto)$tmp0.invoke(p0);
    }

    private static final PageHashUnknownDto getUnknownPageHashes$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PageHashUnknownDto)$tmp0.invoke(p0);
    }

    private static final PageHashMatchDto getPageHashMatches$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PageHashMatchDto)$tmp0.invoke(p0);
    }
}

