/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.rest;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.Valid;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.IOUtils;
import org.gotson.komga.domain.model.Author;
import org.gotson.komga.domain.model.Book;
import org.gotson.komga.domain.model.BookSearchWithReadProgress;
import org.gotson.komga.domain.model.CodedException;
import org.gotson.komga.domain.model.Dimension;
import org.gotson.komga.domain.model.DomainEvent;
import org.gotson.komga.domain.model.DuplicateNameException;
import org.gotson.komga.domain.model.Media;
import org.gotson.komga.domain.model.ReadList;
import org.gotson.komga.domain.model.ReadListRequestMatch;
import org.gotson.komga.domain.model.ReadStatus;
import org.gotson.komga.domain.model.ThumbnailReadList;
import org.gotson.komga.domain.persistence.BookRepository;
import org.gotson.komga.domain.persistence.ReadListRepository;
import org.gotson.komga.domain.persistence.ThumbnailReadListRepository;
import org.gotson.komga.domain.service.BookLifecycle;
import org.gotson.komga.domain.service.ReadListLifecycle;
import org.gotson.komga.infrastructure.image.ImageAnalyzer;
import org.gotson.komga.infrastructure.jooq.UnpagedSorted;
import org.gotson.komga.infrastructure.mediacontainer.ContentDetector;
import org.gotson.komga.infrastructure.security.KomgaPrincipal;
import org.gotson.komga.infrastructure.swagger.AuthorsAsQueryParam;
import org.gotson.komga.infrastructure.swagger.PageableWithoutSortAsQueryParam;
import org.gotson.komga.infrastructure.web.Authors;
import org.gotson.komga.interfaces.api.persistence.BookDtoRepository;
import org.gotson.komga.interfaces.api.persistence.ReadProgressDtoRepository;
import org.gotson.komga.interfaces.api.rest.ReadListController;
import org.gotson.komga.interfaces.api.rest.ReadListControllerKt;
import org.gotson.komga.interfaces.api.rest.dto.BookDto;
import org.gotson.komga.interfaces.api.rest.dto.BookDtoKt;
import org.gotson.komga.interfaces.api.rest.dto.ReadListCreationDto;
import org.gotson.komga.interfaces.api.rest.dto.ReadListDto;
import org.gotson.komga.interfaces.api.rest.dto.ReadListDtoKt;
import org.gotson.komga.interfaces.api.rest.dto.ReadListRequestMatchDto;
import org.gotson.komga.interfaces.api.rest.dto.ReadListRequestMatchDtoKt;
import org.gotson.komga.interfaces.api.rest.dto.ReadListUpdateDto;
import org.gotson.komga.interfaces.api.rest.dto.ReadProgressDto;
import org.gotson.komga.interfaces.api.rest.dto.TachiyomiReadProgressDto;
import org.gotson.komga.interfaces.api.rest.dto.TachiyomiReadProgressUpdateDto;
import org.gotson.komga.interfaces.api.rest.dto.ThumbnailReadListDto;
import org.gotson.komga.interfaces.api.rest.dto.ThumbnailReadListDtoKt;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.io.FileSystemResource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.CacheControl;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@RestController
@RequestMapping(value={"api/v1/readlists"}, produces={"application/json"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00e4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u0012\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0017J0\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\b\b\u0001\u0010\u001f\u001a\u00020 2\b\b\u0001\u0010!\u001a\u00020\"2\b\b\u0003\u0010#\u001a\u00020$H\u0017J\u0012\u0010%\u001a\u00020&2\b\b\u0001\u0010\u001f\u001a\u00020 H\u0017J&\u0010'\u001a\u00020&2\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\b\b\u0001\u0010\u001f\u001a\u00020 2\b\b\u0001\u0010(\u001a\u00020 H\u0017JJ\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00180*2\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\n\b\u0001\u0010+\u001a\u0004\u0018\u00010 2\u0010\b\u0001\u0010,\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010-2\b\b\u0003\u0010.\u001a\u00020$2\b\b\u0001\u0010/\u001a\u000200H\u0017J&\u00101\u001a\u0002022\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\b\b\u0001\u0010\u001f\u001a\u00020 2\b\b\u0001\u00103\u001a\u00020 H\u0017J&\u00104\u001a\u0002022\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\b\b\u0001\u0010\u001f\u001a\u00020 2\b\b\u0001\u00103\u001a\u00020 H\u0017J\u00a1\u0001\u00105\u001a\b\u0012\u0004\u0012\u0002020*2\b\b\u0001\u0010\u001f\u001a\u00020 2\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\u0010\b\u0001\u0010,\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010-2\u0010\b\u0001\u00106\u001a\n\u0012\u0004\u0012\u000207\u0018\u00010-2\u0010\b\u0001\u00108\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010-2\u0010\b\u0001\u00109\u001a\n\u0012\u0004\u0012\u00020:\u0018\u00010-2\n\b\u0001\u0010;\u001a\u0004\u0018\u00010$2\b\b\u0003\u0010.\u001a\u00020$2\u0010\b\u0001\u0010<\u001a\n\u0012\u0004\u0012\u00020=\u0018\u00010-2\b\b\u0001\u0010/\u001a\u000200H\u0017\u00a2\u0006\u0002\u0010>J\u001c\u0010?\u001a\u00020\u00182\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\b\b\u0001\u0010\u001f\u001a\u00020 H\u0017J\"\u0010@\u001a\b\u0012\u0004\u0012\u00020B0A2\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\b\b\u0001\u0010\u001f\u001a\u00020 H\u0017J\"\u0010C\u001a\b\u0012\u0004\u0012\u00020D0A2\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\b\b\u0001\u0010\u001f\u001a\u00020 H\u0017J&\u0010E\u001a\u00020D2\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\b\b\u0001\u0010\u001f\u001a\u00020 2\b\b\u0001\u0010(\u001a\u00020 H\u0017J\"\u0010F\u001a\b\u0012\u0004\u0012\u00020\u001c0G2\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\b\b\u0001\u0010\u001f\u001a\u00020 H\u0017J\u001c\u0010H\u001a\u00020I2\b\b\u0001\u0010\u001f\u001a\u00020 2\b\b\u0001\u0010\u001d\u001a\u00020\u001eH\u0017J&\u0010J\u001a\u00020&2\b\b\u0001\u0010\u001f\u001a\u00020 2\b\b\u0001\u0010K\u001a\u00020L2\b\b\u0001\u0010\u001d\u001a\u00020\u001eH\u0017J&\u0010M\u001a\u00020&2\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\b\b\u0001\u0010\u001f\u001a\u00020 2\b\b\u0001\u0010(\u001a\u00020 H\u0017J\u0012\u0010N\u001a\u00020O2\b\b\u0001\u0010!\u001a\u00020\"H\u0017J\u001c\u0010P\u001a\u00020&2\b\b\u0001\u0010\u001f\u001a\u00020 2\b\b\u0001\u0010\u0019\u001a\u00020QH\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lorg/gotson/komga/interfaces/api/rest/ReadListController;", "", "readListRepository", "Lorg/gotson/komga/domain/persistence/ReadListRepository;", "readListLifecycle", "Lorg/gotson/komga/domain/service/ReadListLifecycle;", "bookDtoRepository", "Lorg/gotson/komga/interfaces/api/persistence/BookDtoRepository;", "bookRepository", "Lorg/gotson/komga/domain/persistence/BookRepository;", "readProgressDtoRepository", "Lorg/gotson/komga/interfaces/api/persistence/ReadProgressDtoRepository;", "thumbnailReadListRepository", "Lorg/gotson/komga/domain/persistence/ThumbnailReadListRepository;", "contentDetector", "Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;", "imageAnalyzer", "Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;", "bookLifecycle", "Lorg/gotson/komga/domain/service/BookLifecycle;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lorg/gotson/komga/domain/persistence/ReadListRepository;Lorg/gotson/komga/domain/service/ReadListLifecycle;Lorg/gotson/komga/interfaces/api/persistence/BookDtoRepository;Lorg/gotson/komga/domain/persistence/BookRepository;Lorg/gotson/komga/interfaces/api/persistence/ReadProgressDtoRepository;Lorg/gotson/komga/domain/persistence/ThumbnailReadListRepository;Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;Lorg/gotson/komga/domain/service/BookLifecycle;Lorg/springframework/context/ApplicationEventPublisher;)V", "addOne", "Lorg/gotson/komga/interfaces/api/rest/dto/ReadListDto;", "readList", "Lorg/gotson/komga/interfaces/api/rest/dto/ReadListCreationDto;", "addUserUploadedReadListThumbnail", "Lorg/gotson/komga/interfaces/api/rest/dto/ThumbnailReadListDto;", "principal", "Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;", "id", "", "file", "Lorg/springframework/web/multipart/MultipartFile;", "selected", "", "deleteOne", "", "deleteUserUploadedReadListThumbnail", "thumbnailId", "getAll", "Lorg/springframework/data/domain/Page;", "searchTerm", "libraryIds", "", "unpaged", "page", "Lorg/springframework/data/domain/Pageable;", "getBookSiblingNext", "Lorg/gotson/komga/interfaces/api/rest/dto/BookDto;", "bookId", "getBookSiblingPrevious", "getBooksForReadList", "readStatus", "Lorg/gotson/komga/domain/model/ReadStatus;", "tags", "mediaStatus", "Lorg/gotson/komga/domain/model/Media$Status;", "deleted", "authors", "Lorg/gotson/komga/domain/model/Author;", "(Ljava/lang/String;Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/lang/Boolean;ZLjava/util/List;Lorg/springframework/data/domain/Pageable;)Lorg/springframework/data/domain/Page;", "getOne", "getReadListFile", "Lorg/springframework/http/ResponseEntity;", "Lorg/springframework/web/servlet/mvc/method/annotation/StreamingResponseBody;", "getReadListThumbnail", "", "getReadListThumbnailById", "getReadListThumbnails", "", "getReadProgress", "Lorg/gotson/komga/interfaces/api/rest/dto/TachiyomiReadProgressDto;", "markReadProgressTachiyomi", "readProgress", "Lorg/gotson/komga/interfaces/api/rest/dto/TachiyomiReadProgressUpdateDto;", "markSelectedReadListThumbnail", "matchFromComicRackList", "Lorg/gotson/komga/interfaces/api/rest/dto/ReadListRequestMatchDto;", "updateOne", "Lorg/gotson/komga/interfaces/api/rest/dto/ReadListUpdateDto;", "komga"})
@SourceDebugExtension(value={"SMAP\nReadListController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReadListController.kt\norg/gotson/komga/interfaces/api/rest/ReadListController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,469:1\n1549#2:470\n1620#2,3:471\n777#2:475\n788#2:476\n1864#2,2:477\n789#2,2:479\n1866#2:481\n791#2:482\n1855#2,2:483\n1#3:474\n1#3:495\n135#4,9:485\n215#4:494\n216#4:496\n144#4:497\n215#4,2:498\n*S KotlinDebug\n*F\n+ 1 ReadListController.kt\norg/gotson/komga/interfaces/api/rest/ReadListController\n*L\n171#1:470\n171#1:471,3\n411#1:475\n411#1:476\n411#1:477,2\n411#1:479,2\n411#1:481\n411#1:482\n412#1:483,2\n429#1:495\n429#1:485,9\n429#1:494\n429#1:496\n429#1:497\n438#1:498,2\n*E\n"})
public class ReadListController {
    @NotNull
    private final ReadListRepository readListRepository;
    @NotNull
    private final ReadListLifecycle readListLifecycle;
    @NotNull
    private final BookDtoRepository bookDtoRepository;
    @NotNull
    private final BookRepository bookRepository;
    @NotNull
    private final ReadProgressDtoRepository readProgressDtoRepository;
    @NotNull
    private final ThumbnailReadListRepository thumbnailReadListRepository;
    @NotNull
    private final ContentDetector contentDetector;
    @NotNull
    private final ImageAnalyzer imageAnalyzer;
    @NotNull
    private final BookLifecycle bookLifecycle;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;

    public ReadListController(@NotNull ReadListRepository readListRepository, @NotNull ReadListLifecycle readListLifecycle, @NotNull BookDtoRepository bookDtoRepository, @NotNull BookRepository bookRepository, @NotNull ReadProgressDtoRepository readProgressDtoRepository, @NotNull ThumbnailReadListRepository thumbnailReadListRepository, @NotNull ContentDetector contentDetector, @NotNull ImageAnalyzer imageAnalyzer, @NotNull BookLifecycle bookLifecycle, @NotNull ApplicationEventPublisher eventPublisher) {
        Intrinsics.checkNotNullParameter((Object)readListRepository, (String)"readListRepository");
        Intrinsics.checkNotNullParameter((Object)readListLifecycle, (String)"readListLifecycle");
        Intrinsics.checkNotNullParameter((Object)bookDtoRepository, (String)"bookDtoRepository");
        Intrinsics.checkNotNullParameter((Object)bookRepository, (String)"bookRepository");
        Intrinsics.checkNotNullParameter((Object)readProgressDtoRepository, (String)"readProgressDtoRepository");
        Intrinsics.checkNotNullParameter((Object)thumbnailReadListRepository, (String)"thumbnailReadListRepository");
        Intrinsics.checkNotNullParameter((Object)contentDetector, (String)"contentDetector");
        Intrinsics.checkNotNullParameter((Object)imageAnalyzer, (String)"imageAnalyzer");
        Intrinsics.checkNotNullParameter((Object)bookLifecycle, (String)"bookLifecycle");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        this.readListRepository = readListRepository;
        this.readListLifecycle = readListLifecycle;
        this.bookDtoRepository = bookDtoRepository;
        this.bookRepository = bookRepository;
        this.readProgressDtoRepository = readProgressDtoRepository;
        this.thumbnailReadListRepository = thumbnailReadListRepository;
        this.contentDetector = contentDetector;
        this.imageAnalyzer = imageAnalyzer;
        this.bookLifecycle = bookLifecycle;
        this.eventPublisher = eventPublisher;
    }

    @PageableWithoutSortAsQueryParam
    @GetMapping
    @NotNull
    public Page<ReadListDto> getAll(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="search", required=false) @Nullable String searchTerm, @RequestParam(name="library_id", required=false) @Nullable List<String> libraryIds, @RequestParam(name="unpaged", required=false) boolean unpaged, @Parameter(hidden=true) @NotNull Pageable page) {
        Pageable pageable;
        Sort sort;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        if (page.getSort().isSorted()) {
            sort = page.getSort();
        } else {
            String[] stringArray = (String[])searchTerm;
            if (!(stringArray == null || StringsKt.isBlank((CharSequence)stringArray))) {
                stringArray = new String[]{"relevance"};
                sort = Sort.by((String[])stringArray);
            } else {
                stringArray = new Sort.Order[]{Sort.Order.asc((String)"name")};
                sort = Sort.by((Sort.Order[])stringArray);
            }
        }
        Sort sort2 = sort;
        Intrinsics.checkNotNull((Object)sort2);
        Sort sort3 = sort2;
        if (unpaged) {
            pageable = (Pageable)new UnpagedSorted(sort3);
        } else {
            PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)sort3);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            pageable = (Pageable)pageRequest;
        }
        Pageable pageRequest = pageable;
        Page page2 = this.readListRepository.findAll(principal.getUser().getAuthorizedLibraryIds((Collection)libraryIds), principal.getUser().getAuthorizedLibraryIds(null), searchTerm, pageRequest, principal.getUser().getRestrictions()).map(arg_0 -> ReadListController.getAll$lambda$0((Function1)getAll.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    public static /* synthetic */ Page getAll$default(ReadListController readListController, KomgaPrincipal komgaPrincipal, String string, List list, boolean bl, Pageable pageable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getAll");
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return readListController.getAll(komgaPrincipal, string, list, bl, pageable);
    }

    @GetMapping(value={"{id}"})
    @NotNull
    public ReadListDto getOne(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String id) {
        ReadListDto readListDto;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ReadList readList = this.readListRepository.findByIdOrNull(id, principal.getUser().getAuthorizedLibraryIds(null), principal.getUser().getRestrictions());
        if (readList == null || (readListDto = ReadListDtoKt.toDto((ReadList)readList)) == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return readListDto;
    }

    @ApiResponse(content={@Content(schema=@Schema(format="binary", type="string"))})
    @GetMapping(value={"{id}/thumbnail"}, produces={"image/jpeg"})
    @NotNull
    public ResponseEntity<byte[]> getReadListThumbnail(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ReadList readList = this.readListRepository.findByIdOrNull(id, principal.getUser().getAuthorizedLibraryIds(null), principal.getUser().getRestrictions());
        if (readList != null) {
            ReadList it = readList;
            boolean bl = false;
            ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)1L, (TimeUnit)TimeUnit.HOURS).cachePrivate())).body((Object)this.readListLifecycle.getThumbnailBytes(it));
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @ApiResponse(content={@Content(schema=@Schema(format="binary", type="string"))})
    @GetMapping(value={"{id}/thumbnails/{thumbnailId}"}, produces={"image/jpeg"})
    @NotNull
    public byte[] getReadListThumbnailById(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="id") @NotNull String id, @PathVariable(name="thumbnailId") @NotNull String thumbnailId) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)thumbnailId, (String)"thumbnailId");
        ReadList readList = this.readListRepository.findByIdOrNull(id, principal.getUser().getAuthorizedLibraryIds(null), principal.getUser().getRestrictions());
        if (readList != null) {
            ReadList it = readList;
            boolean bl = false;
            byte[] byArray = this.readListLifecycle.getThumbnailBytes(thumbnailId);
            if (byArray == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            return byArray;
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"{id}/thumbnails"}, produces={"application/json"})
    @NotNull
    public Collection<ThumbnailReadListDto> getReadListThumbnails(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="id") @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ReadList readList = this.readListRepository.findByIdOrNull(id, principal.getUser().getAuthorizedLibraryIds(null), principal.getUser().getRestrictions());
        if (readList != null) {
            void $this$mapTo$iv$iv;
            ReadList it = readList;
            boolean bl = false;
            Iterable $this$map$iv = this.thumbnailReadListRepository.findAllByReadListId(id);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                ThumbnailReadList thumbnailReadList = (ThumbnailReadList)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(ThumbnailReadListDtoKt.toDto((ThumbnailReadList)it2));
            }
            return (List)destination$iv$iv;
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"{id}/thumbnails"}, consumes={"multipart/form-data"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @NotNull
    public ThumbnailReadListDto addUserUploadedReadListThumbnail(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="id") @NotNull String id, @RequestParam(value="file") @NotNull MultipartFile file, @RequestParam(value="selected") boolean selected) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ReadList readList = this.readListRepository.findByIdOrNull(id, principal.getUser().getAuthorizedLibraryIds(null), principal.getUser().getRestrictions());
        if (readList != null) {
            String string;
            ReadList readList2 = readList;
            boolean bl = false;
            InputStream inputStream = file.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            Object object = inputStream;
            int n = 8192;
            object = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
            Object object2 = null;
            try {
                BufferedInputStream it = (BufferedInputStream)object;
                boolean bl2 = false;
                string = this.contentDetector.detectMediaType((InputStream)it);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            String mediaType2 = string;
            if (!this.contentDetector.isImage(mediaType2)) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNSUPPORTED_MEDIA_TYPE);
            }
            object = readList2.getId();
            object2 = file.getBytes();
            string = ThumbnailReadList.Type.USER_UPLOADED;
            long l = file.getBytes().length;
            InputStream inputStream2 = file.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getInputStream(...)");
            InputStream inputStream3 = inputStream2;
            int n2 = 8192;
            Dimension dimension = this.imageAnalyzer.getDimension((InputStream)(inputStream3 instanceof BufferedInputStream ? (BufferedInputStream)inputStream3 : new BufferedInputStream(inputStream3, n2)));
            if (dimension == null) {
                dimension = new Dimension(0, 0);
            }
            Dimension dimension2 = dimension;
            Intrinsics.checkNotNull((Object)object2);
            return ThumbnailReadListDtoKt.toDto((ThumbnailReadList)this.readListLifecycle.addThumbnail(new ThumbnailReadList((byte[])object2, selected, (ThumbnailReadList.Type)string, mediaType2, l, dimension2, null, (String)object, null, null, 832, null)));
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    public static /* synthetic */ ThumbnailReadListDto addUserUploadedReadListThumbnail$default(ReadListController readListController, KomgaPrincipal komgaPrincipal, String string, MultipartFile multipartFile, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addUserUploadedReadListThumbnail");
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return readListController.addUserUploadedReadListThumbnail(komgaPrincipal, string, multipartFile, bl);
    }

    @PutMapping(value={"{id}/thumbnails/{thumbnailId}/selected"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void markSelectedReadListThumbnail(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="id") @NotNull String id, @PathVariable(name="thumbnailId") @NotNull String thumbnailId) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)thumbnailId, (String)"thumbnailId");
        ReadList readList = this.readListRepository.findByIdOrNull(id, principal.getUser().getAuthorizedLibraryIds(null), principal.getUser().getRestrictions());
        if (readList != null) {
            ReadList it = readList;
            boolean bl = false;
            ThumbnailReadList thumbnailReadList = this.thumbnailReadListRepository.findByIdOrNull(thumbnailId);
            if (thumbnailReadList != null) {
                ThumbnailReadList it2 = thumbnailReadList;
                boolean bl2 = false;
                this.readListLifecycle.markSelectedThumbnail(it2);
                this.eventPublisher.publishEvent((Object)new DomainEvent.ThumbnailReadListAdded(ThumbnailReadList.copy$default((ThumbnailReadList)it2, null, (boolean)true, null, null, (long)0L, null, null, null, null, null, (int)1021, null)));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @DeleteMapping(value={"{id}/thumbnails/{thumbnailId}"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void deleteUserUploadedReadListThumbnail(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="id") @NotNull String id, @PathVariable(name="thumbnailId") @NotNull String thumbnailId) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)thumbnailId, (String)"thumbnailId");
        ReadList readList = this.readListRepository.findByIdOrNull(id, principal.getUser().getAuthorizedLibraryIds(null), principal.getUser().getRestrictions());
        if (readList != null) {
            Unit unit2;
            ReadList it = readList;
            boolean bl = false;
            ThumbnailReadList thumbnailReadList = this.thumbnailReadListRepository.findByIdOrNull(thumbnailId);
            if (thumbnailReadList != null) {
                ThumbnailReadList it2 = thumbnailReadList;
                boolean bl2 = false;
                this.readListLifecycle.deleteThumbnail(it2);
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            if (unit2 == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @PostMapping
    @PreAuthorize(value="hasRole('ADMIN')")
    @NotNull
    public ReadListDto addOne(@Valid @RequestBody @NotNull ReadListCreationDto readList) {
        ReadListDto readListDto;
        Intrinsics.checkNotNullParameter((Object)readList, (String)"readList");
        try {
            readListDto = ReadListDtoKt.toDto((ReadList)this.readListLifecycle.addReadList(new ReadList(readList.getName(), readList.getSummary(), readList.getOrdered(), LanguageUtilsKt.toIndexedMap((List)readList.getBookIds()), null, null, null, false, 240, null)));
        }
        catch (DuplicateNameException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage());
        }
        return readListDto;
    }

    @PostMapping(value={"match/comicrack"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @NotNull
    public ReadListRequestMatchDto matchFromComicRackList(@RequestParam(value="file") @NotNull MultipartFile file) {
        ReadListRequestMatchDto readListRequestMatchDto;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            byte[] byArray = file.getBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            readListRequestMatchDto = ReadListRequestMatchDtoKt.toDto((ReadListRequestMatch)this.readListLifecycle.matchComicRackList(byArray));
        }
        catch (CodedException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getCode());
        }
        return readListRequestMatchDto;
    }

    @PatchMapping(value={"{id}"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateOne(@PathVariable @NotNull String id, @Valid @RequestBody @NotNull ReadListUpdateDto readList) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)readList, (String)"readList");
        ReadList readList2 = ReadListRepository.DefaultImpls.findByIdOrNull$default((ReadListRepository)this.readListRepository, (String)id, null, null, (int)6, null);
        if (readList2 != null) {
            String string;
            ReadList existing = readList2;
            boolean bl = false;
            String string2 = readList.getName();
            if (string2 == null) {
                string2 = existing.getName();
            }
            if ((string = readList.getSummary()) == null) {
                string = existing.getSummary();
            }
            Boolean bl2 = readList.getOrdered();
            boolean bl3 = bl2 != null ? bl2.booleanValue() : existing.getOrdered();
            Object object = readList.getBookIds();
            if (object == null || (object = LanguageUtilsKt.toIndexedMap((List)object)) == null) {
                object = existing.getBookIds();
            }
            ReadList updated = ReadList.copy$default((ReadList)existing, (String)string2, (String)string, (boolean)bl3, (SortedMap)object, null, null, null, (boolean)false, (int)240, null);
            try {
                this.readListLifecycle.updateReadList(updated);
            }
            catch (DuplicateNameException e) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage());
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @DeleteMapping(value={"{id}"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteOne(@PathVariable @NotNull String id) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ReadList readList = ReadListRepository.DefaultImpls.findByIdOrNull$default((ReadListRepository)this.readListRepository, (String)id, null, null, (int)6, null);
        if (readList != null) {
            ReadList it = readList;
            boolean bl = false;
            this.readListLifecycle.deleteReadList(it);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @PageableWithoutSortAsQueryParam
    @AuthorsAsQueryParam
    @GetMapping(value={"{id}/books"})
    @NotNull
    public Page<BookDto> getBooksForReadList(@PathVariable @NotNull String id, @AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="library_id", required=false) @Nullable List<String> libraryIds, @RequestParam(name="read_status", required=false) @Nullable List<? extends ReadStatus> readStatus, @RequestParam(name="tag", required=false) @Nullable List<String> tags, @RequestParam(name="media_status", required=false) @Nullable List<? extends Media.Status> mediaStatus, @RequestParam(name="deleted", required=false) @Nullable Boolean deleted, @RequestParam(name="unpaged", required=false) boolean unpaged, @Parameter(hidden=true) @Authors @Nullable List<Author> authors, @Parameter(hidden=true) @NotNull Pageable page) {
        Page page2;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        ReadList readList = ReadListRepository.DefaultImpls.findByIdOrNull$default((ReadListRepository)this.readListRepository, (String)id, (Collection)principal.getUser().getAuthorizedLibraryIds(null), null, (int)4, null);
        if (readList != null) {
            Pageable pageable;
            Sort sort;
            ReadList readList2 = readList;
            boolean bl = false;
            if (readList2.getOrdered()) {
                var14_13 = new Sort.Order[]{Sort.Order.asc((String)"readList.number")};
                sort = Sort.by((Sort.Order[])var14_13);
            } else {
                var14_13 = new Sort.Order[]{Sort.Order.asc((String)"metadata.releaseDate")};
                sort = Sort.by((Sort.Order[])var14_13);
            }
            Sort sort2 = sort;
            Intrinsics.checkNotNull((Object)sort2);
            Sort sort3 = sort2;
            if (unpaged) {
                pageable = (Pageable)new UnpagedSorted(sort3);
            } else {
                PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)sort3);
                Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
                pageable = (Pageable)pageRequest;
            }
            Pageable pageRequest = pageable;
            Collection collection = principal.getUser().getAuthorizedLibraryIds((Collection)libraryIds);
            BookSearchWithReadProgress bookSearch = new BookSearchWithReadProgress(collection, null, null, (Collection)mediaStatus, null, deleted, null, (Collection)tags, (Collection)readStatus, (Collection)authors, 86, null);
            v4 = this.bookDtoRepository.findAllByReadListId(readList2.getId(), principal.getUser().getId(), principal.getUser().getAuthorizedLibraryIds(null), bookSearch, pageRequest, principal.getUser().getRestrictions()).map(arg_0 -> ReadListController.getBooksForReadList$lambda$14$lambda$13((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        } else {
            v4 = page2 = null;
        }
        if (page2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return page2;
    }

    public static /* synthetic */ Page getBooksForReadList$default(ReadListController readListController, String string, KomgaPrincipal komgaPrincipal, List list, List list2, List list3, List list4, Boolean bl, boolean bl2, List list5, Pageable pageable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getBooksForReadList");
        }
        if ((n & 0x80) != 0) {
            bl2 = false;
        }
        return readListController.getBooksForReadList(string, komgaPrincipal, list, list2, list3, list4, bl, bl2, list5, pageable);
    }

    @GetMapping(value={"{id}/books/{bookId}/previous"})
    @NotNull
    public BookDto getBookSiblingPrevious(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String id, @PathVariable @NotNull String bookId) {
        ReadList readList;
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
                readList = ReadListRepository.DefaultImpls.findByIdOrNull$default((ReadListRepository)this.readListRepository, (String)id, (Collection)principal.getUser().getAuthorizedLibraryIds(null), null, (int)4, null);
                if (readList == null) break block3;
                ReadList it = readList;
                boolean bl = false;
                BookDto bookDto = this.bookDtoRepository.findPreviousInReadListOrNull(it, bookId, principal.getUser().getId(), principal.getUser().getAuthorizedLibraryIds(null), principal.getUser().getRestrictions());
                BookDto bookDto2 = bookDto != null ? BookDtoKt.restrictUrl((BookDto)bookDto, (!principal.getUser().getRoleAdmin() ? 1 : 0) != 0) : null;
                readList = bookDto2;
                if (bookDto2 != null) break block4;
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return readList;
    }

    @GetMapping(value={"{id}/books/{bookId}/next"})
    @NotNull
    public BookDto getBookSiblingNext(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String id, @PathVariable @NotNull String bookId) {
        ReadList readList;
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
                readList = ReadListRepository.DefaultImpls.findByIdOrNull$default((ReadListRepository)this.readListRepository, (String)id, (Collection)principal.getUser().getAuthorizedLibraryIds(null), null, (int)4, null);
                if (readList == null) break block3;
                ReadList it = readList;
                boolean bl = false;
                BookDto bookDto = this.bookDtoRepository.findNextInReadListOrNull(it, bookId, principal.getUser().getId(), principal.getUser().getAuthorizedLibraryIds(null), principal.getUser().getRestrictions());
                BookDto bookDto2 = bookDto != null ? BookDtoKt.restrictUrl((BookDto)bookDto, (!principal.getUser().getRoleAdmin() ? 1 : 0) != 0) : null;
                readList = bookDto2;
                if (bookDto2 != null) break block4;
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return readList;
    }

    @GetMapping(value={"{id}/read-progress/tachiyomi"})
    @NotNull
    public TachiyomiReadProgressDto getReadProgress(@PathVariable @NotNull String id, @AuthenticationPrincipal @NotNull KomgaPrincipal principal) {
        ReadList readList;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
                readList = ReadListRepository.DefaultImpls.findByIdOrNull$default((ReadListRepository)this.readListRepository, (String)id, (Collection)principal.getUser().getAuthorizedLibraryIds(null), null, (int)4, null);
                if (readList == null) break block2;
                ReadList readList2 = readList;
                boolean bl = false;
                TachiyomiReadProgressDto tachiyomiReadProgressDto = this.readProgressDtoRepository.findProgressByReadList(readList2.getId(), principal.getUser().getId());
                readList = tachiyomiReadProgressDto;
                if (tachiyomiReadProgressDto != null) break block3;
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return readList;
    }

    /*
     * WARNING - void declaration
     */
    @PutMapping(value={"{id}/read-progress/tachiyomi"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void markReadProgressTachiyomi(@PathVariable @NotNull String id, @Valid @RequestBody @NotNull TachiyomiReadProgressUpdateDto readProgress, @AuthenticationPrincipal @NotNull KomgaPrincipal principal) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)readProgress, (String)"readProgress");
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        ReadList readList = ReadListRepository.DefaultImpls.findByIdOrNull$default((ReadListRepository)this.readListRepository, (String)id, (Collection)principal.getUser().getAuthorizedLibraryIds(null), null, (int)4, null);
        if (readList != null) {
            void $this$forEach$iv;
            void $this$filterIndexedTo$iv$iv;
            Iterable $this$filterIndexed$iv;
            ReadList readList2 = readList;
            boolean bl = false;
            String string = readList2.getId();
            String string2 = principal.getUser().getId();
            Collection collection = principal.getUser().getAuthorizedLibraryIds(null);
            BookSearchWithReadProgress bookSearchWithReadProgress = new BookSearchWithReadProgress(null, null, null, null, null, null, null, null, null, null, 1023, null);
            Sort.Order[] orderArray = new Sort.Order[]{Sort.Order.asc((String)"readList.number")};
            Sort sort = Sort.by((Sort.Order[])orderArray);
            Intrinsics.checkNotNullExpressionValue((Object)sort, (String)"by(...)");
            Iterable iterable = (Iterable)this.bookDtoRepository.findAllByReadListId(string, string2, collection, bookSearchWithReadProgress, (Pageable)new UnpagedSorted(sort), principal.getUser().getRestrictions());
            boolean $i$f$filterIndexed = false;
            Iterator iterator = $this$filterIndexed$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIndexedTo = false;
            void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv = 0;
            for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                void element$iv$iv;
                int n;
                if ((n = index$iv$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv$iv;
                int index$iv$iv = n;
                boolean bl2 = false;
                BookDto cfr_ignored_0 = (BookDto)element$iv$iv;
                int index = index$iv$iv;
                boolean bl3 = false;
                if (!(index < readProgress.getLastBookRead())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIndexed$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BookDto book = (BookDto)element$iv;
                boolean bl4 = false;
                ReadProgressDto readProgressDto = book.getReadProgress();
                if (readProgressDto != null ? readProgressDto.getCompleted() : false) continue;
                this.bookLifecycle.markReadProgressCompleted(book.getId(), principal.getUser());
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"{id}/file"}, produces={"application/octet-stream"})
    @PreAuthorize(value="hasRole('FILE_DOWNLOAD')")
    @NotNull
    public ResponseEntity<StreamingResponseBody> getReadListFile(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ReadList readList = ReadListRepository.DefaultImpls.findByIdOrNull$default((ReadListRepository)this.readListRepository, (String)id, (Collection)principal.getUser().getAuthorizedLibraryIds(null), null, (int)4, null);
        if (readList != null) {
            void $this$getReadListFile_u24lambda_u2428_u24lambda_u2427;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            ReadList readList2 = readList;
            boolean bl = false;
            Map map = readList2.getBookIds();
            boolean $i$f$mapNotNull = false;
            HttpHeaders httpHeaders = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Pair pair;
                Map.Entry element$iv$iv$iv;
                Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                Map.Entry it = element$iv$iv;
                boolean bl3 = false;
                Object v = it.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                if (this.bookRepository.findByIdOrNull((String)v) != null) {
                    Book book;
                    boolean bl4 = false;
                    pair = TuplesKt.to(it.getKey(), (Object)book);
                } else {
                    pair = null;
                }
                if (pair == null) continue;
                Pair it$iv$iv = pair;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Map books = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            StreamingResponseBody streamingResponse2 = arg_0 -> ReadListController.getReadListFile$lambda$28$lambda$26(books, arg_0);
            httpHeaders = new HttpHeaders();
            destination$iv$iv = httpHeaders;
            ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.ok();
            boolean bl6 = false;
            $this$getReadListFile_u24lambda_u2428_u24lambda_u2427.setContentDisposition(ContentDisposition.builder((String)"attachment").filename(readList2.getName() + ".zip", StandardCharsets.UTF_8).build());
            ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)bodyBuilder.headers(httpHeaders)).contentType(MediaType.parseMediaType((String)org.gotson.komga.domain.model.MediaType.ZIP.getType())).body((Object)streamingResponse2);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    private static final ReadListDto getAll$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ReadListDto)$tmp0.invoke(p0);
    }

    private static final BookDto getBooksForReadList$lambda$14$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (BookDto)$tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void getReadListFile$lambda$28$lambda$26(Map $books, OutputStream responseStream) {
        Intrinsics.checkNotNullParameter((Object)$books, (String)"$books");
        Intrinsics.checkNotNullParameter((Object)responseStream, (String)"responseStream");
        Closeable closeable = (Closeable)new ZipArchiveOutputStream(responseStream);
        Throwable throwable = null;
        try {
            ZipArchiveOutputStream zipStream = (ZipArchiveOutputStream)closeable;
            boolean bl = false;
            zipStream.setMethod(8);
            zipStream.setLevel(0);
            zipStream.setUseZip64(Zip64Mode.Always);
            Map $this$forEach$iv = $books;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl2 = false;
                Integer index = (Integer)entry.getKey();
                Book book = (Book)entry.getValue();
                FileSystemResource file = new FileSystemResource(book.getPath());
                if (!file.exists()) {
                    ReadListControllerKt.access$getLogger$p().warn((Function0)new /* Unavailable Anonymous Inner Class!! */);
                    continue;
                }
                ReadListControllerKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
                Closeable closeable2 = file.getInputStream();
                Throwable throwable2 = null;
                try {
                    InputStream it = (InputStream)closeable2;
                    boolean bl3 = false;
                    zipStream.putArchiveEntry(new ZipArchiveEntry(index + 1 + " - " + file.getFilename()));
                    IOUtils.copyLarge((InputStream)it, (OutputStream)((OutputStream)zipStream), (byte[])new byte[8192]);
                    zipStream.closeArchiveEntry();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

