/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.rest;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.Valid;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gotson.komga.domain.model.Author;
import org.gotson.komga.domain.model.Dimension;
import org.gotson.komga.domain.model.DomainEvent;
import org.gotson.komga.domain.model.DuplicateNameException;
import org.gotson.komga.domain.model.ReadStatus;
import org.gotson.komga.domain.model.SeriesCollection;
import org.gotson.komga.domain.model.SeriesMetadata;
import org.gotson.komga.domain.model.SeriesSearchWithReadProgress;
import org.gotson.komga.domain.model.ThumbnailSeriesCollection;
import org.gotson.komga.domain.persistence.SeriesCollectionRepository;
import org.gotson.komga.domain.persistence.ThumbnailSeriesCollectionRepository;
import org.gotson.komga.domain.service.SeriesCollectionLifecycle;
import org.gotson.komga.infrastructure.image.ImageAnalyzer;
import org.gotson.komga.infrastructure.jooq.UnpagedSorted;
import org.gotson.komga.infrastructure.mediacontainer.ContentDetector;
import org.gotson.komga.infrastructure.security.KomgaPrincipal;
import org.gotson.komga.infrastructure.swagger.AuthorsAsQueryParam;
import org.gotson.komga.infrastructure.swagger.PageableWithoutSortAsQueryParam;
import org.gotson.komga.infrastructure.web.Authors;
import org.gotson.komga.interfaces.api.persistence.SeriesDtoRepository;
import org.gotson.komga.interfaces.api.rest.SeriesCollectionController;
import org.gotson.komga.interfaces.api.rest.dto.CollectionCreationDto;
import org.gotson.komga.interfaces.api.rest.dto.CollectionDto;
import org.gotson.komga.interfaces.api.rest.dto.CollectionDtoKt;
import org.gotson.komga.interfaces.api.rest.dto.CollectionUpdateDto;
import org.gotson.komga.interfaces.api.rest.dto.SeriesDto;
import org.gotson.komga.interfaces.api.rest.dto.ThumbnailSeriesCollectionDto;
import org.gotson.komga.interfaces.api.rest.dto.ThumbnailSeriesCollectionDtoKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"api/v1/collections"}, produces={"application/json"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0017J0\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u001b\u001a\u00020\u001c2\b\b\u0003\u0010\u001d\u001a\u00020\u001eH\u0017J\u0012\u0010\u001f\u001a\u00020 2\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0017J&\u0010!\u001a\u00020 2\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\"\u001a\u00020\u001aH\u0017JJ\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00120$2\b\b\u0001\u0010\u0017\u001a\u00020\u00182\n\b\u0001\u0010%\u001a\u0004\u0018\u00010\u001a2\u0010\b\u0001\u0010&\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010'2\b\b\u0003\u0010(\u001a\u00020\u001e2\b\b\u0001\u0010)\u001a\u00020*H\u0017J\"\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0017J&\u0010.\u001a\u00020-2\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\"\u001a\u00020\u001aH\u0017J\"\u0010/\u001a\b\u0012\u0004\u0012\u00020\u0016002\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0017J\u001c\u00101\u001a\u00020\u00122\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0017J\u0087\u0002\u00102\u001a\b\u0012\u0004\u0012\u0002030$2\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u0017\u001a\u00020\u00182\u0010\b\u0001\u0010&\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010'2\u0010\b\u0001\u00104\u001a\n\u0012\u0004\u0012\u000205\u0018\u00010'2\u0010\b\u0001\u00106\u001a\n\u0012\u0004\u0012\u000207\u0018\u00010'2\u0010\b\u0001\u00108\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010'2\u0010\b\u0001\u00109\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010'2\u0010\b\u0001\u0010:\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010'2\u0010\b\u0001\u0010;\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010'2\u0010\b\u0001\u0010<\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010'2\u0010\b\u0001\u0010=\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010'2\n\b\u0001\u0010>\u001a\u0004\u0018\u00010\u001e2\n\b\u0001\u0010?\u001a\u0004\u0018\u00010\u001e2\b\b\u0003\u0010(\u001a\u00020\u001e2\u0010\b\u0001\u0010@\u001a\n\u0012\u0004\u0012\u00020A\u0018\u00010'2\b\b\u0001\u0010)\u001a\u00020*H\u0017\u00a2\u0006\u0002\u0010BJ&\u0010C\u001a\u00020 2\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\"\u001a\u00020\u001aH\u0017J\u001c\u0010D\u001a\u00020 2\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u0013\u001a\u00020EH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lorg/gotson/komga/interfaces/api/rest/SeriesCollectionController;", "", "collectionRepository", "Lorg/gotson/komga/domain/persistence/SeriesCollectionRepository;", "collectionLifecycle", "Lorg/gotson/komga/domain/service/SeriesCollectionLifecycle;", "seriesDtoRepository", "Lorg/gotson/komga/interfaces/api/persistence/SeriesDtoRepository;", "contentDetector", "Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;", "imageAnalyzer", "Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;", "thumbnailSeriesCollectionRepository", "Lorg/gotson/komga/domain/persistence/ThumbnailSeriesCollectionRepository;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lorg/gotson/komga/domain/persistence/SeriesCollectionRepository;Lorg/gotson/komga/domain/service/SeriesCollectionLifecycle;Lorg/gotson/komga/interfaces/api/persistence/SeriesDtoRepository;Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;Lorg/gotson/komga/domain/persistence/ThumbnailSeriesCollectionRepository;Lorg/springframework/context/ApplicationEventPublisher;)V", "addOne", "Lorg/gotson/komga/interfaces/api/rest/dto/CollectionDto;", "collection", "Lorg/gotson/komga/interfaces/api/rest/dto/CollectionCreationDto;", "addUserUploadedCollectionThumbnail", "Lorg/gotson/komga/interfaces/api/rest/dto/ThumbnailSeriesCollectionDto;", "principal", "Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;", "id", "", "file", "Lorg/springframework/web/multipart/MultipartFile;", "selected", "", "deleteOne", "", "deleteUserUploadedCollectionThumbnail", "thumbnailId", "getAll", "Lorg/springframework/data/domain/Page;", "searchTerm", "libraryIds", "", "unpaged", "page", "Lorg/springframework/data/domain/Pageable;", "getCollectionThumbnail", "Lorg/springframework/http/ResponseEntity;", "", "getCollectionThumbnailById", "getCollectionThumbnails", "", "getOne", "getSeriesForCollection", "Lorg/gotson/komga/interfaces/api/rest/dto/SeriesDto;", "metadataStatus", "Lorg/gotson/komga/domain/model/SeriesMetadata$Status;", "readStatus", "Lorg/gotson/komga/domain/model/ReadStatus;", "publishers", "languages", "genres", "tags", "ageRatings", "releaseYears", "deleted", "complete", "authors", "Lorg/gotson/komga/domain/model/Author;", "(Ljava/lang/String;Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/lang/Boolean;Ljava/lang/Boolean;ZLjava/util/List;Lorg/springframework/data/domain/Pageable;)Lorg/springframework/data/domain/Page;", "markSelectedCollectionThumbnail", "updateOne", "Lorg/gotson/komga/interfaces/api/rest/dto/CollectionUpdateDto;", "komga"})
@SourceDebugExtension(value={"SMAP\nSeriesCollectionController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeriesCollectionController.kt\norg/gotson/komga/interfaces/api/rest/SeriesCollectionController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,319:1\n1549#2:320\n1620#2,3:321\n1549#2:325\n1620#2,3:326\n1#3:324\n*S KotlinDebug\n*F\n+ 1 SeriesCollectionController.kt\norg/gotson/komga/interfaces/api/rest/SeriesCollectionController\n*L\n146#1:320\n146#1:321,3\n309#1:325\n309#1:326,3\n*E\n"})
public class SeriesCollectionController {
    @NotNull
    private final SeriesCollectionRepository collectionRepository;
    @NotNull
    private final SeriesCollectionLifecycle collectionLifecycle;
    @NotNull
    private final SeriesDtoRepository seriesDtoRepository;
    @NotNull
    private final ContentDetector contentDetector;
    @NotNull
    private final ImageAnalyzer imageAnalyzer;
    @NotNull
    private final ThumbnailSeriesCollectionRepository thumbnailSeriesCollectionRepository;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;

    public SeriesCollectionController(@NotNull SeriesCollectionRepository collectionRepository, @NotNull SeriesCollectionLifecycle collectionLifecycle, @NotNull SeriesDtoRepository seriesDtoRepository, @NotNull ContentDetector contentDetector, @NotNull ImageAnalyzer imageAnalyzer, @NotNull ThumbnailSeriesCollectionRepository thumbnailSeriesCollectionRepository, @NotNull ApplicationEventPublisher eventPublisher) {
        Intrinsics.checkNotNullParameter((Object)collectionRepository, (String)"collectionRepository");
        Intrinsics.checkNotNullParameter((Object)collectionLifecycle, (String)"collectionLifecycle");
        Intrinsics.checkNotNullParameter((Object)seriesDtoRepository, (String)"seriesDtoRepository");
        Intrinsics.checkNotNullParameter((Object)contentDetector, (String)"contentDetector");
        Intrinsics.checkNotNullParameter((Object)imageAnalyzer, (String)"imageAnalyzer");
        Intrinsics.checkNotNullParameter((Object)thumbnailSeriesCollectionRepository, (String)"thumbnailSeriesCollectionRepository");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        this.collectionRepository = collectionRepository;
        this.collectionLifecycle = collectionLifecycle;
        this.seriesDtoRepository = seriesDtoRepository;
        this.contentDetector = contentDetector;
        this.imageAnalyzer = imageAnalyzer;
        this.thumbnailSeriesCollectionRepository = thumbnailSeriesCollectionRepository;
        this.eventPublisher = eventPublisher;
    }

    @PageableWithoutSortAsQueryParam
    @GetMapping
    @NotNull
    public Page<CollectionDto> getAll(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="search", required=false) @Nullable String searchTerm, @RequestParam(name="library_id", required=false) @Nullable List<String> libraryIds, @RequestParam(name="unpaged", required=false) boolean unpaged, @Parameter(hidden=true) @NotNull Pageable page) {
        Pageable pageable;
        Sort sort;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        String[] stringArray = (String[])searchTerm;
        if (!(stringArray == null || StringsKt.isBlank((CharSequence)stringArray))) {
            stringArray = new String[]{"relevance"};
            sort = Sort.by((String[])stringArray);
        } else {
            stringArray = new Sort.Order[]{Sort.Order.asc((String)"name")};
            sort = Sort.by((Sort.Order[])stringArray);
        }
        Sort sort2 = sort;
        Intrinsics.checkNotNull((Object)sort2);
        Sort sort3 = sort2;
        if (unpaged) {
            pageable = (Pageable)new UnpagedSorted(sort3);
        } else {
            PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)sort3);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            pageable = (Pageable)pageRequest;
        }
        Pageable pageRequest = pageable;
        Page page2 = this.collectionRepository.findAll(principal.getUser().getAuthorizedLibraryIds((Collection)libraryIds), principal.getUser().getAuthorizedLibraryIds(null), searchTerm, pageRequest, principal.getUser().getRestrictions()).map(arg_0 -> SeriesCollectionController.getAll$lambda$0((Function1)getAll.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    public static /* synthetic */ Page getAll$default(SeriesCollectionController seriesCollectionController, KomgaPrincipal komgaPrincipal, String string, List list, boolean bl, Pageable pageable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getAll");
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return seriesCollectionController.getAll(komgaPrincipal, string, list, bl, pageable);
    }

    @GetMapping(value={"{id}"})
    @NotNull
    public CollectionDto getOne(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String id) {
        CollectionDto collectionDto;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        SeriesCollection seriesCollection = this.collectionRepository.findByIdOrNull(id, principal.getUser().getAuthorizedLibraryIds(null), principal.getUser().getRestrictions());
        if (seriesCollection == null || (collectionDto = CollectionDtoKt.toDto((SeriesCollection)seriesCollection)) == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return collectionDto;
    }

    @ApiResponse(content={@Content(schema=@Schema(format="binary", type="string"))})
    @GetMapping(value={"{id}/thumbnail"}, produces={"image/jpeg"})
    @NotNull
    public ResponseEntity<byte[]> getCollectionThumbnail(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        SeriesCollection seriesCollection = this.collectionRepository.findByIdOrNull(id, principal.getUser().getAuthorizedLibraryIds(null), principal.getUser().getRestrictions());
        if (seriesCollection != null) {
            SeriesCollection it = seriesCollection;
            boolean bl = false;
            ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)1L, (TimeUnit)TimeUnit.HOURS).cachePrivate())).body((Object)this.collectionLifecycle.getThumbnailBytes(it, principal.getUser().getId()));
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @ApiResponse(content={@Content(schema=@Schema(format="binary", type="string"))})
    @GetMapping(value={"{id}/thumbnails/{thumbnailId}"}, produces={"image/jpeg"})
    @NotNull
    public byte[] getCollectionThumbnailById(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="id") @NotNull String id, @PathVariable(name="thumbnailId") @NotNull String thumbnailId) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)thumbnailId, (String)"thumbnailId");
        SeriesCollection seriesCollection = this.collectionRepository.findByIdOrNull(id, principal.getUser().getAuthorizedLibraryIds(null), principal.getUser().getRestrictions());
        if (seriesCollection != null) {
            SeriesCollection it = seriesCollection;
            boolean bl = false;
            byte[] byArray = this.collectionLifecycle.getThumbnailBytes(thumbnailId);
            if (byArray == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            return byArray;
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"{id}/thumbnails"}, produces={"application/json"})
    @NotNull
    public Collection<ThumbnailSeriesCollectionDto> getCollectionThumbnails(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="id") @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        SeriesCollection seriesCollection = this.collectionRepository.findByIdOrNull(id, principal.getUser().getAuthorizedLibraryIds(null), principal.getUser().getRestrictions());
        if (seriesCollection != null) {
            void $this$mapTo$iv$iv;
            SeriesCollection it = seriesCollection;
            boolean bl = false;
            Iterable $this$map$iv = this.thumbnailSeriesCollectionRepository.findAllByCollectionId(id);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                ThumbnailSeriesCollection thumbnailSeriesCollection = (ThumbnailSeriesCollection)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(ThumbnailSeriesCollectionDtoKt.toDto((ThumbnailSeriesCollection)it2));
            }
            return (List)destination$iv$iv;
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"{id}/thumbnails"}, consumes={"multipart/form-data"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @NotNull
    public ThumbnailSeriesCollectionDto addUserUploadedCollectionThumbnail(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="id") @NotNull String id, @RequestParam(value="file") @NotNull MultipartFile file, @RequestParam(value="selected") boolean selected) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        SeriesCollection seriesCollection = SeriesCollectionRepository.DefaultImpls.findByIdOrNull$default((SeriesCollectionRepository)this.collectionRepository, (String)id, (Collection)principal.getUser().getAuthorizedLibraryIds(null), null, (int)4, null);
        if (seriesCollection != null) {
            String string;
            SeriesCollection collection = seriesCollection;
            boolean bl = false;
            InputStream inputStream = file.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            Object object = inputStream;
            int n = 8192;
            object = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
            Object object2 = null;
            try {
                BufferedInputStream it = (BufferedInputStream)object;
                boolean bl2 = false;
                string = this.contentDetector.detectMediaType((InputStream)it);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            String mediaType2 = string;
            if (!this.contentDetector.isImage(mediaType2)) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNSUPPORTED_MEDIA_TYPE);
            }
            object = collection.getId();
            object2 = file.getBytes();
            string = ThumbnailSeriesCollection.Type.USER_UPLOADED;
            long l = file.getBytes().length;
            InputStream inputStream2 = file.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getInputStream(...)");
            InputStream inputStream3 = inputStream2;
            int n2 = 8192;
            Dimension dimension = this.imageAnalyzer.getDimension((InputStream)(inputStream3 instanceof BufferedInputStream ? (BufferedInputStream)inputStream3 : new BufferedInputStream(inputStream3, n2)));
            if (dimension == null) {
                dimension = new Dimension(0, 0);
            }
            Dimension dimension2 = dimension;
            Intrinsics.checkNotNull((Object)object2);
            return ThumbnailSeriesCollectionDtoKt.toDto((ThumbnailSeriesCollection)this.collectionLifecycle.addThumbnail(new ThumbnailSeriesCollection((byte[])object2, selected, (ThumbnailSeriesCollection.Type)string, mediaType2, l, dimension2, null, (String)object, null, null, 832, null)));
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    public static /* synthetic */ ThumbnailSeriesCollectionDto addUserUploadedCollectionThumbnail$default(SeriesCollectionController seriesCollectionController, KomgaPrincipal komgaPrincipal, String string, MultipartFile multipartFile, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addUserUploadedCollectionThumbnail");
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return seriesCollectionController.addUserUploadedCollectionThumbnail(komgaPrincipal, string, multipartFile, bl);
    }

    @PutMapping(value={"{id}/thumbnails/{thumbnailId}/selected"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void markSelectedCollectionThumbnail(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="id") @NotNull String id, @PathVariable(name="thumbnailId") @NotNull String thumbnailId) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)thumbnailId, (String)"thumbnailId");
        SeriesCollection seriesCollection = SeriesCollectionRepository.DefaultImpls.findByIdOrNull$default((SeriesCollectionRepository)this.collectionRepository, (String)id, (Collection)principal.getUser().getAuthorizedLibraryIds(null), null, (int)4, null);
        if (seriesCollection != null) {
            SeriesCollection it = seriesCollection;
            boolean bl = false;
            ThumbnailSeriesCollection thumbnailSeriesCollection = this.thumbnailSeriesCollectionRepository.findByIdOrNull(thumbnailId);
            if (thumbnailSeriesCollection != null) {
                ThumbnailSeriesCollection it2 = thumbnailSeriesCollection;
                boolean bl2 = false;
                this.collectionLifecycle.markSelectedThumbnail(it2);
                this.eventPublisher.publishEvent((Object)new DomainEvent.ThumbnailSeriesCollectionAdded(ThumbnailSeriesCollection.copy$default((ThumbnailSeriesCollection)it2, null, (boolean)true, null, null, (long)0L, null, null, null, null, null, (int)1021, null)));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @DeleteMapping(value={"{id}/thumbnails/{thumbnailId}"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void deleteUserUploadedCollectionThumbnail(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="id") @NotNull String id, @PathVariable(name="thumbnailId") @NotNull String thumbnailId) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)thumbnailId, (String)"thumbnailId");
        SeriesCollection seriesCollection = SeriesCollectionRepository.DefaultImpls.findByIdOrNull$default((SeriesCollectionRepository)this.collectionRepository, (String)id, (Collection)principal.getUser().getAuthorizedLibraryIds(null), null, (int)4, null);
        if (seriesCollection != null) {
            Unit unit2;
            SeriesCollection it = seriesCollection;
            boolean bl = false;
            ThumbnailSeriesCollection thumbnailSeriesCollection = this.thumbnailSeriesCollectionRepository.findByIdOrNull(thumbnailId);
            if (thumbnailSeriesCollection != null) {
                ThumbnailSeriesCollection it2 = thumbnailSeriesCollection;
                boolean bl2 = false;
                this.collectionLifecycle.deleteThumbnail(it2);
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            if (unit2 == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @PostMapping
    @PreAuthorize(value="hasRole('ADMIN')")
    @NotNull
    public CollectionDto addOne(@Valid @RequestBody @NotNull CollectionCreationDto collection) {
        CollectionDto collectionDto;
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        try {
            collectionDto = CollectionDtoKt.toDto((SeriesCollection)this.collectionLifecycle.addCollection(new SeriesCollection(collection.getName(), collection.getOrdered(), collection.getSeriesIds(), null, null, null, false, 120, null)));
        }
        catch (DuplicateNameException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage());
        }
        return collectionDto;
    }

    @PatchMapping(value={"{id}"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateOne(@PathVariable @NotNull String id, @Valid @RequestBody @NotNull CollectionUpdateDto collection) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        SeriesCollection seriesCollection = SeriesCollectionRepository.DefaultImpls.findByIdOrNull$default((SeriesCollectionRepository)this.collectionRepository, (String)id, null, null, (int)6, null);
        if (seriesCollection != null) {
            SeriesCollection existing = seriesCollection;
            boolean bl = false;
            String string = collection.getName();
            if (string == null) {
                string = existing.getName();
            }
            Boolean bl2 = collection.getOrdered();
            boolean bl3 = bl2 != null ? bl2.booleanValue() : existing.getOrdered();
            List list = collection.getSeriesIds();
            if (list == null) {
                list = existing.getSeriesIds();
            }
            SeriesCollection updated = SeriesCollection.copy$default((SeriesCollection)existing, (String)string, (boolean)bl3, (List)list, null, null, null, (boolean)false, (int)120, null);
            try {
                this.collectionLifecycle.updateCollection(updated);
            }
            catch (DuplicateNameException e) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage());
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @DeleteMapping(value={"{id}"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteOne(@PathVariable @NotNull String id) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        SeriesCollection seriesCollection = SeriesCollectionRepository.DefaultImpls.findByIdOrNull$default((SeriesCollectionRepository)this.collectionRepository, (String)id, null, null, (int)6, null);
        if (seriesCollection != null) {
            SeriesCollection it = seriesCollection;
            boolean bl = false;
            this.collectionLifecycle.deleteCollection(it);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PageableWithoutSortAsQueryParam
    @AuthorsAsQueryParam
    @GetMapping(value={"{id}/series"})
    @NotNull
    public Page<SeriesDto> getSeriesForCollection(@PathVariable @NotNull String id, @AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="library_id", required=false) @Nullable List<String> libraryIds, @RequestParam(name="status", required=false) @Nullable List<? extends SeriesMetadata.Status> metadataStatus, @RequestParam(name="read_status", required=false) @Nullable List<? extends ReadStatus> readStatus, @RequestParam(name="publisher", required=false) @Nullable List<String> publishers, @RequestParam(name="language", required=false) @Nullable List<String> languages2, @RequestParam(name="genre", required=false) @Nullable List<String> genres, @RequestParam(name="tag", required=false) @Nullable List<String> tags, @RequestParam(name="age_rating", required=false) @Nullable List<String> ageRatings, @RequestParam(name="release_year", required=false) @Nullable List<String> releaseYears, @RequestParam(name="deleted", required=false) @Nullable Boolean deleted, @RequestParam(name="complete", required=false) @Nullable Boolean complete, @RequestParam(name="unpaged", required=false) boolean unpaged, @Parameter(hidden=true) @Authors @Nullable List<Author> authors, @Parameter(hidden=true) @NotNull Pageable page) {
        Page page2;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        SeriesCollection seriesCollection = this.collectionRepository.findByIdOrNull(id, principal.getUser().getAuthorizedLibraryIds(null), principal.getUser().getRestrictions());
        if (seriesCollection != null) {
            Collection<Integer> collection;
            Pageable pageable;
            Sort sort;
            SeriesCollection collection2 = seriesCollection;
            boolean bl = false;
            if (collection2.getOrdered()) {
                var20_19 = new Sort.Order[]{Sort.Order.asc((String)"collection.number")};
                sort = Sort.by((Sort.Order[])var20_19);
            } else {
                var20_19 = new Sort.Order[]{Sort.Order.asc((String)"metadata.titleSort")};
                sort = Sort.by((Sort.Order[])var20_19);
            }
            Sort sort2 = sort;
            Intrinsics.checkNotNull((Object)sort2);
            Sort sort3 = sort2;
            if (unpaged) {
                pageable = (Pageable)new UnpagedSorted(sort3);
            } else {
                PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)sort3);
                Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
                pageable = (Pageable)pageRequest;
            }
            Pageable pageRequest = pageable;
            Collection collection3 = principal.getUser().getAuthorizedLibraryIds((Collection)libraryIds);
            Collection collection4 = null;
            String string = null;
            Pair pair = null;
            Collection collection5 = metadataStatus;
            Collection collection6 = publishers;
            Boolean bl2 = deleted;
            Boolean bl3 = complete;
            Boolean bl4 = null;
            Collection collection7 = languages2;
            Collection collection8 = genres;
            Collection collection9 = tags;
            List<String> list = ageRatings;
            if (list != null) {
                Collection<Integer> collection10;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = list;
                Collection collection11 = collection9;
                Collection collection12 = collection8;
                Collection collection13 = collection7;
                Boolean bl5 = bl4;
                Boolean bl6 = bl3;
                Boolean bl7 = bl2;
                Collection collection14 = collection6;
                Collection collection15 = collection5;
                Pair pair2 = pair;
                String string2 = string;
                Collection collection16 = collection4;
                Collection collection17 = collection3;
                boolean $i$f$map = false;
                void var37_36 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string3 = (String)item$iv$iv;
                    collection10 = destination$iv$iv;
                    boolean bl8 = false;
                    collection10.add(StringsKt.toIntOrNull((String)it));
                }
                collection10 = (List)destination$iv$iv;
                collection3 = collection17;
                collection4 = collection16;
                string = string2;
                pair = pair2;
                collection5 = collection15;
                collection6 = collection14;
                bl2 = bl7;
                bl3 = bl6;
                bl4 = bl5;
                collection7 = collection13;
                collection8 = collection12;
                collection9 = collection11;
                collection = collection10;
            } else {
                collection = null;
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 65806;
            Collection collection18 = null;
            Collection collection19 = authors;
            Collection collection20 = readStatus;
            Collection collection21 = releaseYears;
            Collection collection22 = collection;
            Collection collection23 = collection9;
            Collection collection24 = collection8;
            Collection collection25 = collection7;
            Boolean bl9 = bl4;
            Boolean bl10 = bl3;
            Boolean bl11 = bl2;
            Collection collection26 = collection6;
            Collection collection27 = collection5;
            Pair pair3 = pair;
            String string4 = string;
            Collection collection28 = collection4;
            Collection collection29 = collection3;
            SeriesSearchWithReadProgress seriesSearch = new SeriesSearchWithReadProgress(collection29, collection28, string4, pair3, collection27, collection26, bl11, bl10, bl9, collection25, collection24, collection23, collection22, collection21, collection20, collection19, collection18, n, defaultConstructorMarker);
            v18 = this.seriesDtoRepository.findAllByCollectionId(collection2.getId(), seriesSearch, principal.getUser().getId(), pageRequest, principal.getUser().getRestrictions()).map(arg_0 -> SeriesCollectionController.getSeriesForCollection$lambda$15$lambda$14((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        } else {
            v18 = page2 = null;
        }
        if (page2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return page2;
    }

    public static /* synthetic */ Page getSeriesForCollection$default(SeriesCollectionController seriesCollectionController, String string, KomgaPrincipal komgaPrincipal, List list, List list2, List list3, List list4, List list5, List list6, List list7, List list8, List list9, Boolean bl, Boolean bl2, boolean bl3, List list10, Pageable pageable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getSeriesForCollection");
        }
        if ((n & 0x2000) != 0) {
            bl3 = false;
        }
        return seriesCollectionController.getSeriesForCollection(string, komgaPrincipal, list, list2, list3, list4, list5, list6, list7, list8, list9, bl, bl2, bl3, list10, pageable);
    }

    private static final CollectionDto getAll$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CollectionDto)$tmp0.invoke(p0);
    }

    private static final SeriesDto getSeriesForCollection$lambda$15$lambda$14(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SeriesDto)$tmp0.invoke(p0);
    }
}

