/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.Valid;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.IOUtils;
import org.gotson.komga.application.tasks.TaskEmitter;
import org.gotson.komga.domain.model.AlternateTitle;
import org.gotson.komga.domain.model.Author;
import org.gotson.komga.domain.model.Book;
import org.gotson.komga.domain.model.BookSearchWithReadProgress;
import org.gotson.komga.domain.model.Dimension;
import org.gotson.komga.domain.model.DomainEvent;
import org.gotson.komga.domain.model.KomgaUser;
import org.gotson.komga.domain.model.MarkSelectedPreference;
import org.gotson.komga.domain.model.Media;
import org.gotson.komga.domain.model.ReadStatus;
import org.gotson.komga.domain.model.Series;
import org.gotson.komga.domain.model.SeriesCollection;
import org.gotson.komga.domain.model.SeriesMetadata;
import org.gotson.komga.domain.model.SeriesSearch;
import org.gotson.komga.domain.model.SeriesSearchWithReadProgress;
import org.gotson.komga.domain.model.ThumbnailSeries;
import org.gotson.komga.domain.model.WebLink;
import org.gotson.komga.domain.persistence.BookRepository;
import org.gotson.komga.domain.persistence.SeriesCollectionRepository;
import org.gotson.komga.domain.persistence.SeriesMetadataRepository;
import org.gotson.komga.domain.persistence.SeriesRepository;
import org.gotson.komga.domain.persistence.ThumbnailSeriesRepository;
import org.gotson.komga.domain.service.BookLifecycle;
import org.gotson.komga.domain.service.SeriesLifecycle;
import org.gotson.komga.infrastructure.image.ImageAnalyzer;
import org.gotson.komga.infrastructure.jooq.UnpagedSorted;
import org.gotson.komga.infrastructure.mediacontainer.ContentDetector;
import org.gotson.komga.infrastructure.security.KomgaPrincipal;
import org.gotson.komga.infrastructure.swagger.AuthorsAsQueryParam;
import org.gotson.komga.infrastructure.swagger.PageableAsQueryParam;
import org.gotson.komga.infrastructure.swagger.PageableWithoutSortAsQueryParam;
import org.gotson.komga.infrastructure.web.Authors;
import org.gotson.komga.infrastructure.web.DelimitedPair;
import org.gotson.komga.interfaces.api.ContentRestrictionChecker;
import org.gotson.komga.interfaces.api.persistence.BookDtoRepository;
import org.gotson.komga.interfaces.api.persistence.ReadProgressDtoRepository;
import org.gotson.komga.interfaces.api.persistence.SeriesDtoRepository;
import org.gotson.komga.interfaces.api.rest.SeriesControllerKt;
import org.gotson.komga.interfaces.api.rest.dto.AlternateTitleUpdateDto;
import org.gotson.komga.interfaces.api.rest.dto.BookDto;
import org.gotson.komga.interfaces.api.rest.dto.CollectionDto;
import org.gotson.komga.interfaces.api.rest.dto.CollectionDtoKt;
import org.gotson.komga.interfaces.api.rest.dto.GroupCountDto;
import org.gotson.komga.interfaces.api.rest.dto.ReadProgressDto;
import org.gotson.komga.interfaces.api.rest.dto.SeriesDto;
import org.gotson.komga.interfaces.api.rest.dto.SeriesDtoKt;
import org.gotson.komga.interfaces.api.rest.dto.SeriesMetadataUpdateDto;
import org.gotson.komga.interfaces.api.rest.dto.TachiyomiReadProgressUpdateV2Dto;
import org.gotson.komga.interfaces.api.rest.dto.TachiyomiReadProgressV2Dto;
import org.gotson.komga.interfaces.api.rest.dto.ThumbnailSeriesDto;
import org.gotson.komga.interfaces.api.rest.dto.ThumbnailSeriesDtoKt;
import org.gotson.komga.interfaces.api.rest.dto.WebLinkUpdateDto;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.io.FileSystemResource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@RestController
@RequestMapping(value={"api"}, produces={"application/json"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B}\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\u0002\u0010 J\u0012\u0010!\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020$H\u0017J\u0012\u0010%\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020$H\u0017J\u001c\u0010&\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020$2\b\b\u0001\u0010'\u001a\u00020$H\u0017J\u008f\u0001\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010#\u001a\u00020$2\u0010\b\u0003\u0010-\u001a\n\u0012\u0004\u0012\u00020/\u0018\u00010.2\u0010\b\u0003\u00100\u001a\n\u0012\u0004\u0012\u000201\u0018\u00010.2\u0010\b\u0003\u00102\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\n\b\u0003\u00103\u001a\u0004\u0018\u0001042\b\b\u0003\u00105\u001a\u0002042\u0010\b\u0003\u00106\u001a\n\u0012\u0004\u0012\u000207\u0018\u00010.2\b\b\u0001\u00108\u001a\u000209H\u0017\u00a2\u0006\u0002\u0010:J\"\u0010;\u001a\b\u0012\u0004\u0012\u00020<0.2\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010#\u001a\u00020$H\u0017J\u00d1\u0002\u0010=\u001a\b\u0012\u0004\u0012\u00020>0)2\b\b\u0001\u0010+\u001a\u00020,2\n\b\u0003\u0010?\u001a\u0004\u0018\u00010$2\u0016\b\u0003\u0010@\u001a\u0010\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020$\u0018\u00010A2\u0010\b\u0003\u0010B\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0003\u0010C\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0003\u0010D\u001a\n\u0012\u0004\u0012\u00020E\u0018\u00010.2\u0010\b\u0003\u00100\u001a\n\u0012\u0004\u0012\u000201\u0018\u00010.2\u0010\b\u0003\u0010F\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0003\u0010G\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0003\u0010H\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0003\u00102\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0003\u0010I\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0003\u0010J\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0003\u0010K\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\n\b\u0003\u00103\u001a\u0004\u0018\u0001042\n\b\u0003\u0010L\u001a\u0004\u0018\u0001042\n\b\u0003\u0010M\u001a\u0004\u0018\u0001042\b\b\u0003\u00105\u001a\u0002042\u0010\b\u0003\u00106\u001a\n\u0012\u0004\u0012\u000207\u0018\u00010.2\b\b\u0001\u00108\u001a\u000209H\u0017\u00a2\u0006\u0002\u0010NJ\u00c7\u0002\u0010O\u001a\b\u0012\u0004\u0012\u00020P0.2\b\b\u0001\u0010+\u001a\u00020,2\n\b\u0001\u0010?\u001a\u0004\u0018\u00010$2\u0016\b\u0001\u0010@\u001a\u0010\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020$\u0018\u00010A2\u0010\b\u0001\u0010B\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0001\u0010C\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0001\u0010D\u001a\n\u0012\u0004\u0012\u00020E\u0018\u00010.2\u0010\b\u0001\u00100\u001a\n\u0012\u0004\u0012\u000201\u0018\u00010.2\u0010\b\u0001\u0010F\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0001\u0010G\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0001\u0010H\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0001\u00102\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0001\u0010I\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0001\u0010J\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0003\u0010K\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\n\b\u0001\u00103\u001a\u0004\u0018\u0001042\n\b\u0001\u0010L\u001a\u0004\u0018\u0001042\n\b\u0003\u0010M\u001a\u0004\u0018\u0001042\u0010\b\u0001\u00106\u001a\n\u0012\u0004\u0012\u000207\u0018\u00010.2\b\b\u0001\u00108\u001a\u000209H\u0017\u00a2\u0006\u0002\u0010QJ[\u0010R\u001a\b\u0012\u0004\u0012\u00020>0)2\b\b\u0001\u0010+\u001a\u00020,2\u0010\b\u0001\u0010B\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\n\b\u0001\u00103\u001a\u0004\u0018\u0001042\n\b\u0003\u0010M\u001a\u0004\u0018\u0001042\b\b\u0003\u00105\u001a\u0002042\b\b\u0001\u00108\u001a\u000209H\u0017\u00a2\u0006\u0002\u0010SJ[\u0010T\u001a\b\u0012\u0004\u0012\u00020>0)2\b\b\u0001\u0010+\u001a\u00020,2\u0010\b\u0003\u0010B\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\n\b\u0003\u00103\u001a\u0004\u0018\u0001042\n\b\u0003\u0010M\u001a\u0004\u0018\u0001042\b\b\u0003\u00105\u001a\u0002042\b\b\u0001\u00108\u001a\u000209H\u0017\u00a2\u0006\u0002\u0010SJ\u001c\u0010U\u001a\u00020>2\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010V\u001a\u00020$H\u0017J\u001c\u0010W\u001a\u00020X2\b\b\u0001\u0010#\u001a\u00020$2\b\b\u0001\u0010+\u001a\u00020,H\u0017J\u001c\u0010Y\u001a\u00020Z2\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010#\u001a\u00020$H\u0017J\"\u0010[\u001a\b\u0012\u0004\u0012\u00020]0\\2\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010#\u001a\u00020$H\u0017J&\u0010^\u001a\u00020Z2\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010#\u001a\u00020$2\b\b\u0001\u0010'\u001a\u00020$H\u0017J\"\u0010_\u001a\b\u0012\u0004\u0012\u00020a0`2\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010#\u001a\u00020$H\u0017J[\u0010b\u001a\b\u0012\u0004\u0012\u00020>0)2\b\b\u0001\u0010+\u001a\u00020,2\u0010\b\u0003\u0010B\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\n\b\u0003\u00103\u001a\u0004\u0018\u0001042\n\b\u0003\u0010M\u001a\u0004\u0018\u0001042\b\b\u0003\u00105\u001a\u0002042\b\b\u0001\u00108\u001a\u000209H\u0017\u00a2\u0006\u0002\u0010SJ\u001c\u0010c\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020$2\b\b\u0001\u0010+\u001a\u00020,H\u0017J\u001c\u0010d\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020$2\b\b\u0001\u0010+\u001a\u00020,H\u0017J&\u0010e\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020$2\b\b\u0001\u0010f\u001a\u00020g2\b\b\u0001\u0010+\u001a\u00020,H\u0017J\u001c\u0010h\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020$2\b\b\u0001\u0010'\u001a\u00020$H\u0017J&\u0010i\u001a\u00020a2\b\b\u0001\u0010#\u001a\u00020$2\b\b\u0001\u0010j\u001a\u00020k2\b\b\u0003\u0010l\u001a\u000204H\u0017J\u0012\u0010m\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020$H\u0017J&\u0010n\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020$2\b\b\u0001\u0010o\u001a\u00020p2\b\b\u0001\u0010+\u001a\u00020,H\u0017J\u0014\u0010q\u001a\u00020\"*\u00020r2\u0006\u0010#\u001a\u00020$H\u0012R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006s"}, d2={"Lorg/gotson/komga/interfaces/api/rest/SeriesController;", "", "taskEmitter", "Lorg/gotson/komga/application/tasks/TaskEmitter;", "seriesRepository", "Lorg/gotson/komga/domain/persistence/SeriesRepository;", "seriesLifecycle", "Lorg/gotson/komga/domain/service/SeriesLifecycle;", "seriesMetadataRepository", "Lorg/gotson/komga/domain/persistence/SeriesMetadataRepository;", "seriesDtoRepository", "Lorg/gotson/komga/interfaces/api/persistence/SeriesDtoRepository;", "bookLifecycle", "Lorg/gotson/komga/domain/service/BookLifecycle;", "bookRepository", "Lorg/gotson/komga/domain/persistence/BookRepository;", "bookDtoRepository", "Lorg/gotson/komga/interfaces/api/persistence/BookDtoRepository;", "collectionRepository", "Lorg/gotson/komga/domain/persistence/SeriesCollectionRepository;", "readProgressDtoRepository", "Lorg/gotson/komga/interfaces/api/persistence/ReadProgressDtoRepository;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "contentDetector", "Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;", "imageAnalyzer", "Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;", "thumbnailsSeriesRepository", "Lorg/gotson/komga/domain/persistence/ThumbnailSeriesRepository;", "contentRestrictionChecker", "Lorg/gotson/komga/interfaces/api/ContentRestrictionChecker;", "(Lorg/gotson/komga/application/tasks/TaskEmitter;Lorg/gotson/komga/domain/persistence/SeriesRepository;Lorg/gotson/komga/domain/service/SeriesLifecycle;Lorg/gotson/komga/domain/persistence/SeriesMetadataRepository;Lorg/gotson/komga/interfaces/api/persistence/SeriesDtoRepository;Lorg/gotson/komga/domain/service/BookLifecycle;Lorg/gotson/komga/domain/persistence/BookRepository;Lorg/gotson/komga/interfaces/api/persistence/BookDtoRepository;Lorg/gotson/komga/domain/persistence/SeriesCollectionRepository;Lorg/gotson/komga/interfaces/api/persistence/ReadProgressDtoRepository;Lorg/springframework/context/ApplicationEventPublisher;Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;Lorg/gotson/komga/domain/persistence/ThumbnailSeriesRepository;Lorg/gotson/komga/interfaces/api/ContentRestrictionChecker;)V", "analyze", "", "seriesId", "", "deleteSeries", "deleteUserUploadedSeriesThumbnail", "thumbnailId", "getAllBooksBySeries", "Lorg/springframework/data/domain/Page;", "Lorg/gotson/komga/interfaces/api/rest/dto/BookDto;", "principal", "Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;", "mediaStatus", "", "Lorg/gotson/komga/domain/model/Media$Status;", "readStatus", "Lorg/gotson/komga/domain/model/ReadStatus;", "tags", "deleted", "", "unpaged", "authors", "Lorg/gotson/komga/domain/model/Author;", "page", "Lorg/springframework/data/domain/Pageable;", "(Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/lang/Boolean;ZLjava/util/List;Lorg/springframework/data/domain/Pageable;)Lorg/springframework/data/domain/Page;", "getAllCollectionsBySeries", "Lorg/gotson/komga/interfaces/api/rest/dto/CollectionDto;", "getAllSeries", "Lorg/gotson/komga/interfaces/api/rest/dto/SeriesDto;", "searchTerm", "searchRegex", "Lkotlin/Pair;", "libraryIds", "collectionIds", "metadataStatus", "Lorg/gotson/komga/domain/model/SeriesMetadata$Status;", "publishers", "languages", "genres", "ageRatings", "releaseYears", "sharingLabels", "complete", "oneshot", "(Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;Ljava/lang/String;Lkotlin/Pair;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;ZLjava/util/List;Lorg/springframework/data/domain/Pageable;)Lorg/springframework/data/domain/Page;", "getAlphabeticalGroups", "Lorg/gotson/komga/interfaces/api/rest/dto/GroupCountDto;", "(Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;Ljava/lang/String;Lkotlin/Pair;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/util/List;Lorg/springframework/data/domain/Pageable;)Ljava/util/List;", "getLatestSeries", "(Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;Ljava/util/List;Ljava/lang/Boolean;Ljava/lang/Boolean;ZLorg/springframework/data/domain/Pageable;)Lorg/springframework/data/domain/Page;", "getNewSeries", "getOneSeries", "id", "getReadProgressTachiyomiV2", "Lorg/gotson/komga/interfaces/api/rest/dto/TachiyomiReadProgressV2Dto;", "getSeriesDefaultThumbnail", "", "getSeriesFile", "Lorg/springframework/http/ResponseEntity;", "Lorg/springframework/web/servlet/mvc/method/annotation/StreamingResponseBody;", "getSeriesThumbnailById", "getSeriesThumbnails", "", "Lorg/gotson/komga/interfaces/api/rest/dto/ThumbnailSeriesDto;", "getUpdatedSeries", "markAsRead", "markAsUnread", "markReadProgressTachiyomiV2", "readProgress", "Lorg/gotson/komga/interfaces/api/rest/dto/TachiyomiReadProgressUpdateV2Dto;", "postMarkSelectedSeriesThumbnail", "postUserUploadedSeriesThumbnail", "file", "Lorg/springframework/web/multipart/MultipartFile;", "selected", "refreshMetadata", "updateMetadata", "newMetadata", "Lorg/gotson/komga/interfaces/api/rest/dto/SeriesMetadataUpdateDto;", "checkContentRestriction", "Lorg/gotson/komga/domain/model/KomgaUser;", "komga"})
@SourceDebugExtension(value={"SMAP\nSeriesController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeriesController.kt\norg/gotson/komga/interfaces/api/rest/SeriesController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,759:1\n1549#2:760\n1620#2,3:761\n1549#2:764\n1620#2,3:765\n1549#2:768\n1620#2,3:769\n1549#2:773\n1620#2,3:774\n1549#2:777\n1620#2,3:778\n1549#2:781\n1620#2,3:782\n766#2:785\n857#2,2:786\n1855#2,2:788\n1855#2,2:790\n1#3:772\n*S KotlinDebug\n*F\n+ 1 SeriesController.kt\norg/gotson/komga/interfaces/api/rest/SeriesController\n*L\n192#1:760\n192#1:761,3\n257#1:764\n257#1:765,3\n415#1:768\n415#1:769,3\n530#1:773\n530#1:774,3\n610#1:777\n610#1:778,3\n617#1:781\n617#1:782,3\n676#1:785\n676#1:786,2\n677#1:788,2\n699#1:790,2\n*E\n"})
public class SeriesController {
    @NotNull
    private final TaskEmitter taskEmitter;
    @NotNull
    private final SeriesRepository seriesRepository;
    @NotNull
    private final SeriesLifecycle seriesLifecycle;
    @NotNull
    private final SeriesMetadataRepository seriesMetadataRepository;
    @NotNull
    private final SeriesDtoRepository seriesDtoRepository;
    @NotNull
    private final BookLifecycle bookLifecycle;
    @NotNull
    private final BookRepository bookRepository;
    @NotNull
    private final BookDtoRepository bookDtoRepository;
    @NotNull
    private final SeriesCollectionRepository collectionRepository;
    @NotNull
    private final ReadProgressDtoRepository readProgressDtoRepository;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private final ContentDetector contentDetector;
    @NotNull
    private final ImageAnalyzer imageAnalyzer;
    @NotNull
    private final ThumbnailSeriesRepository thumbnailsSeriesRepository;
    @NotNull
    private final ContentRestrictionChecker contentRestrictionChecker;

    public SeriesController(@NotNull TaskEmitter taskEmitter, @NotNull SeriesRepository seriesRepository, @NotNull SeriesLifecycle seriesLifecycle, @NotNull SeriesMetadataRepository seriesMetadataRepository, @NotNull SeriesDtoRepository seriesDtoRepository, @NotNull BookLifecycle bookLifecycle, @NotNull BookRepository bookRepository, @NotNull BookDtoRepository bookDtoRepository, @NotNull SeriesCollectionRepository collectionRepository, @NotNull ReadProgressDtoRepository readProgressDtoRepository, @NotNull ApplicationEventPublisher eventPublisher, @NotNull ContentDetector contentDetector, @NotNull ImageAnalyzer imageAnalyzer, @NotNull ThumbnailSeriesRepository thumbnailsSeriesRepository, @NotNull ContentRestrictionChecker contentRestrictionChecker) {
        Intrinsics.checkNotNullParameter((Object)taskEmitter, (String)"taskEmitter");
        Intrinsics.checkNotNullParameter((Object)seriesRepository, (String)"seriesRepository");
        Intrinsics.checkNotNullParameter((Object)seriesLifecycle, (String)"seriesLifecycle");
        Intrinsics.checkNotNullParameter((Object)seriesMetadataRepository, (String)"seriesMetadataRepository");
        Intrinsics.checkNotNullParameter((Object)seriesDtoRepository, (String)"seriesDtoRepository");
        Intrinsics.checkNotNullParameter((Object)bookLifecycle, (String)"bookLifecycle");
        Intrinsics.checkNotNullParameter((Object)bookRepository, (String)"bookRepository");
        Intrinsics.checkNotNullParameter((Object)bookDtoRepository, (String)"bookDtoRepository");
        Intrinsics.checkNotNullParameter((Object)collectionRepository, (String)"collectionRepository");
        Intrinsics.checkNotNullParameter((Object)readProgressDtoRepository, (String)"readProgressDtoRepository");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)contentDetector, (String)"contentDetector");
        Intrinsics.checkNotNullParameter((Object)imageAnalyzer, (String)"imageAnalyzer");
        Intrinsics.checkNotNullParameter((Object)thumbnailsSeriesRepository, (String)"thumbnailsSeriesRepository");
        Intrinsics.checkNotNullParameter((Object)contentRestrictionChecker, (String)"contentRestrictionChecker");
        this.taskEmitter = taskEmitter;
        this.seriesRepository = seriesRepository;
        this.seriesLifecycle = seriesLifecycle;
        this.seriesMetadataRepository = seriesMetadataRepository;
        this.seriesDtoRepository = seriesDtoRepository;
        this.bookLifecycle = bookLifecycle;
        this.bookRepository = bookRepository;
        this.bookDtoRepository = bookDtoRepository;
        this.collectionRepository = collectionRepository;
        this.readProgressDtoRepository = readProgressDtoRepository;
        this.eventPublisher = eventPublisher;
        this.contentDetector = contentDetector;
        this.imageAnalyzer = imageAnalyzer;
        this.thumbnailsSeriesRepository = thumbnailsSeriesRepository;
        this.contentRestrictionChecker = contentRestrictionChecker;
    }

    /*
     * WARNING - void declaration
     */
    @PageableAsQueryParam
    @AuthorsAsQueryParam
    @Parameters(value={@Parameter(name="search_regex", in=ParameterIn.QUERY, description="Search by regex criteria, in the form: regex,field. Supported fields are TITLE and TITLE_SORT.", schema=@Schema(type="string"))})
    @GetMapping(value={"v1/series"})
    @NotNull
    public Page<SeriesDto> getAllSeries(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="search", required=false) @Nullable String searchTerm, @Parameter(hidden=true) @DelimitedPair(parameterName="search_regex") @Nullable Pair<String, String> searchRegex, @RequestParam(name="library_id", required=false) @Nullable List<String> libraryIds, @RequestParam(name="collection_id", required=false) @Nullable List<String> collectionIds, @RequestParam(name="status", required=false) @Nullable List<? extends SeriesMetadata.Status> metadataStatus, @RequestParam(name="read_status", required=false) @Nullable List<? extends ReadStatus> readStatus, @RequestParam(name="publisher", required=false) @Nullable List<String> publishers, @RequestParam(name="language", required=false) @Nullable List<String> languages2, @RequestParam(name="genre", required=false) @Nullable List<String> genres, @RequestParam(name="tag", required=false) @Nullable List<String> tags, @RequestParam(name="age_rating", required=false) @Nullable List<String> ageRatings, @RequestParam(name="release_year", required=false) @Nullable List<String> releaseYears, @RequestParam(name="sharing_label", required=false) @Nullable List<String> sharingLabels, @RequestParam(name="deleted", required=false) @Nullable Boolean deleted, @RequestParam(name="complete", required=false) @Nullable Boolean complete, @RequestParam(name="oneshot", required=false) @Nullable Boolean oneshot, @RequestParam(name="unpaged", required=false) boolean unpaged, @Parameter(hidden=true) @Authors @Nullable List<Author> authors, @Parameter(hidden=true) @NotNull Pageable page) {
        Collection<Integer> collection;
        Pair pair;
        Pair pair2;
        Collection collection2;
        Collection collection3;
        String string;
        Pageable pageable;
        Sort sort;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        if (page.getSort().isSorted()) {
            sort = page.getSort();
        } else {
            String[] stringArray = (String[])searchTerm;
            if (!(stringArray == null || StringsKt.isBlank((CharSequence)stringArray))) {
                stringArray = new String[]{"relevance"};
                sort = Sort.by((String[])stringArray);
            } else {
                sort = Sort.unsorted();
            }
        }
        Sort sort2 = sort;
        Intrinsics.checkNotNull((Object)sort2);
        Sort sort3 = sort2;
        if (unpaged) {
            pageable = (Pageable)new UnpagedSorted(sort3);
        } else {
            PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)sort3);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            pageable = (Pageable)pageRequest;
        }
        Pageable pageRequest = pageable;
        Collection collection4 = principal.getUser().getAuthorizedLibraryIds((Collection)libraryIds);
        Collection collection5 = collectionIds;
        String string2 = searchTerm;
        Pair<String, String> pair3 = searchRegex;
        if (pair3 != null) {
            void it;
            Pair<String, String> pair4 = pair3;
            string = string2;
            collection3 = collection5;
            collection2 = collection4;
            boolean bl7 = false;
            String string3 = ((String)it.getSecond()).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            String string4 = string3;
            pair2 = Intrinsics.areEqual((Object)string4, (Object)"title") ? new Pair(it.getFirst(), (Object)SeriesSearch.SearchField.TITLE) : (Intrinsics.areEqual((Object)string4, (Object)"title_sort") ? new Pair(it.getFirst(), (Object)SeriesSearch.SearchField.TITLE_SORT) : null);
            collection4 = collection2;
            collection5 = collection3;
            string2 = string;
            pair = pair2;
        } else {
            pair = null;
        }
        Collection collection6 = metadataStatus;
        Collection collection7 = publishers;
        Boolean bl = deleted;
        Boolean bl2 = complete;
        Boolean bl3 = oneshot;
        Collection collection8 = languages2;
        Collection collection9 = genres;
        Collection collection10 = tags;
        List<String> list = ageRatings;
        if (list != null) {
            Collection<Integer> collection11;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list;
            Collection collection12 = collection10;
            Collection collection13 = collection9;
            Collection collection14 = collection8;
            Boolean bl4 = bl3;
            Boolean bl5 = bl2;
            Boolean bl6 = bl;
            Collection collection15 = collection7;
            Collection collection16 = collection6;
            pair2 = pair;
            string = string2;
            collection3 = collection5;
            collection2 = collection4;
            boolean $i$f$map = false;
            void bl7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string5 = (String)item$iv$iv;
                collection11 = destination$iv$iv;
                boolean bl8 = false;
                collection11.add(StringsKt.toIntOrNull((String)it));
            }
            collection11 = (List)destination$iv$iv;
            collection4 = collection2;
            collection5 = collection3;
            string2 = string;
            pair = pair2;
            collection6 = collection16;
            collection7 = collection15;
            bl = bl6;
            bl2 = bl5;
            bl3 = bl4;
            collection8 = collection14;
            collection9 = collection13;
            collection10 = collection12;
            collection = collection11;
        } else {
            collection = null;
        }
        Collection collection17 = sharingLabels;
        Collection collection18 = authors;
        Collection collection19 = readStatus;
        Collection collection20 = releaseYears;
        Collection collection21 = collection;
        Collection collection22 = collection10;
        Collection collection23 = collection9;
        Collection collection24 = collection8;
        Boolean bl9 = bl3;
        Boolean bl10 = bl2;
        Boolean bl11 = bl;
        Collection collection25 = collection7;
        Collection collection26 = collection6;
        Pair pair5 = pair;
        String string6 = string2;
        Collection collection27 = collection5;
        Collection collection28 = collection4;
        SeriesSearchWithReadProgress seriesSearch = new SeriesSearchWithReadProgress(collection28, collection27, string6, pair5, collection26, collection25, bl11, bl10, bl9, collection24, collection23, collection22, collection21, collection20, collection19, collection18, collection17);
        Page page2 = this.seriesDtoRepository.findAll(seriesSearch, principal.getUser().getId(), pageRequest, principal.getUser().getRestrictions()).map(arg_0 -> SeriesController.getAllSeries$lambda$2((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    public static /* synthetic */ Page getAllSeries$default(SeriesController seriesController, KomgaPrincipal komgaPrincipal, String string, Pair pair, List list, List list2, List list3, List list4, List list5, List list6, List list7, List list8, List list9, List list10, List list11, Boolean bl, Boolean bl2, Boolean bl3, boolean bl4, List list12, Pageable pageable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getAllSeries");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            pair = null;
        }
        if ((n & 8) != 0) {
            list = null;
        }
        if ((n & 0x10) != 0) {
            list2 = null;
        }
        if ((n & 0x20) != 0) {
            list3 = null;
        }
        if ((n & 0x40) != 0) {
            list4 = null;
        }
        if ((n & 0x80) != 0) {
            list5 = null;
        }
        if ((n & 0x100) != 0) {
            list6 = null;
        }
        if ((n & 0x200) != 0) {
            list7 = null;
        }
        if ((n & 0x400) != 0) {
            list8 = null;
        }
        if ((n & 0x800) != 0) {
            list9 = null;
        }
        if ((n & 0x1000) != 0) {
            list10 = null;
        }
        if ((n & 0x2000) != 0) {
            list11 = null;
        }
        if ((n & 0x4000) != 0) {
            bl = null;
        }
        if ((n & 0x8000) != 0) {
            bl2 = null;
        }
        if ((n & 0x10000) != 0) {
            bl3 = null;
        }
        if ((n & 0x20000) != 0) {
            bl4 = false;
        }
        if ((n & 0x40000) != 0) {
            list12 = null;
        }
        return seriesController.getAllSeries(komgaPrincipal, string, pair, list, list2, list3, list4, list5, list6, list7, list8, list9, list10, list11, bl, bl2, bl3, bl4, list12, pageable);
    }

    /*
     * WARNING - void declaration
     */
    @AuthorsAsQueryParam
    @Parameters(value={@Parameter(name="search_regex", in=ParameterIn.QUERY, description="Search by regex criteria, in the form: regex,field. Supported fields are TITLE and TITLE_SORT.", schema=@Schema(type="string"))})
    @GetMapping(value={"v1/series/alphabetical-groups"})
    @NotNull
    public List<GroupCountDto> getAlphabeticalGroups(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="search", required=false) @Nullable String searchTerm, @Parameter(hidden=true) @DelimitedPair(parameterName="search_regex") @Nullable Pair<String, String> searchRegex, @RequestParam(name="library_id", required=false) @Nullable List<String> libraryIds, @RequestParam(name="collection_id", required=false) @Nullable List<String> collectionIds, @RequestParam(name="status", required=false) @Nullable List<? extends SeriesMetadata.Status> metadataStatus, @RequestParam(name="read_status", required=false) @Nullable List<? extends ReadStatus> readStatus, @RequestParam(name="publisher", required=false) @Nullable List<String> publishers, @RequestParam(name="language", required=false) @Nullable List<String> languages2, @RequestParam(name="genre", required=false) @Nullable List<String> genres, @RequestParam(name="tag", required=false) @Nullable List<String> tags, @RequestParam(name="age_rating", required=false) @Nullable List<String> ageRatings, @RequestParam(name="release_year", required=false) @Nullable List<String> releaseYears, @RequestParam(name="sharing_label", required=false) @Nullable List<String> sharingLabels, @RequestParam(name="deleted", required=false) @Nullable Boolean deleted, @RequestParam(name="complete", required=false) @Nullable Boolean complete, @RequestParam(name="oneshot", required=false) @Nullable Boolean oneshot, @Parameter(hidden=true) @Authors @Nullable List<Author> authors, @Parameter(hidden=true) @NotNull Pageable page) {
        Collection<Integer> collection;
        Pair pair;
        Pair pair2;
        Collection collection2;
        Collection collection3;
        String string;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Collection collection4 = principal.getUser().getAuthorizedLibraryIds((Collection)libraryIds);
        Collection collection5 = collectionIds;
        String string2 = searchTerm;
        Pair<String, String> pair3 = searchRegex;
        if (pair3 != null) {
            void it;
            Pair<String, String> pair4 = pair3;
            string = string2;
            collection3 = collection5;
            collection2 = collection4;
            boolean bl7 = false;
            String string3 = ((String)it.getSecond()).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            String string4 = string3;
            pair2 = Intrinsics.areEqual((Object)string4, (Object)"title") ? new Pair(it.getFirst(), (Object)SeriesSearch.SearchField.TITLE) : (Intrinsics.areEqual((Object)string4, (Object)"title_sort") ? new Pair(it.getFirst(), (Object)SeriesSearch.SearchField.TITLE_SORT) : null);
            collection4 = collection2;
            collection5 = collection3;
            string2 = string;
            pair = pair2;
        } else {
            pair = null;
        }
        Collection collection6 = metadataStatus;
        Collection collection7 = publishers;
        Boolean bl = deleted;
        Boolean bl2 = complete;
        Boolean bl3 = oneshot;
        Collection collection8 = languages2;
        Collection collection9 = genres;
        Collection collection10 = tags;
        List<String> list = ageRatings;
        if (list != null) {
            Collection<Integer> collection11;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list;
            Collection collection12 = collection10;
            Collection collection13 = collection9;
            Collection collection14 = collection8;
            Boolean bl4 = bl3;
            Boolean bl5 = bl2;
            Boolean bl6 = bl;
            Collection collection15 = collection7;
            Collection collection16 = collection6;
            pair2 = pair;
            string = string2;
            collection3 = collection5;
            collection2 = collection4;
            boolean $i$f$map = false;
            void bl7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string5 = (String)item$iv$iv;
                collection11 = destination$iv$iv;
                boolean bl8 = false;
                collection11.add(StringsKt.toIntOrNull((String)it));
            }
            collection11 = (List)destination$iv$iv;
            collection4 = collection2;
            collection5 = collection3;
            string2 = string;
            pair = pair2;
            collection6 = collection16;
            collection7 = collection15;
            bl = bl6;
            bl2 = bl5;
            bl3 = bl4;
            collection8 = collection14;
            collection9 = collection13;
            collection10 = collection12;
            collection = collection11;
        } else {
            collection = null;
        }
        Collection collection17 = sharingLabels;
        Collection collection18 = authors;
        Collection collection19 = readStatus;
        Collection collection20 = releaseYears;
        Collection collection21 = collection;
        Collection collection22 = collection10;
        Collection collection23 = collection9;
        Collection collection24 = collection8;
        Boolean bl9 = bl3;
        Boolean bl10 = bl2;
        Boolean bl11 = bl;
        Collection collection25 = collection7;
        Collection collection26 = collection6;
        Pair pair5 = pair;
        String string6 = string2;
        Collection collection27 = collection5;
        Collection collection28 = collection4;
        SeriesSearchWithReadProgress seriesSearch = new SeriesSearchWithReadProgress(collection28, collection27, string6, pair5, collection26, collection25, bl11, bl10, bl9, collection24, collection23, collection22, collection21, collection20, collection19, collection18, collection17);
        return this.seriesDtoRepository.countByFirstCharacter(seriesSearch, principal.getUser().getId(), principal.getUser().getRestrictions());
    }

    public static /* synthetic */ List getAlphabeticalGroups$default(SeriesController seriesController, KomgaPrincipal komgaPrincipal, String string, Pair pair, List list, List list2, List list3, List list4, List list5, List list6, List list7, List list8, List list9, List list10, List list11, Boolean bl, Boolean bl2, Boolean bl3, List list12, Pageable pageable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getAlphabeticalGroups");
        }
        if ((n & 0x2000) != 0) {
            list11 = null;
        }
        if ((n & 0x10000) != 0) {
            bl3 = null;
        }
        return seriesController.getAlphabeticalGroups(komgaPrincipal, string, pair, list, list2, list3, list4, list5, list6, list7, list8, list9, list10, list11, bl, bl2, bl3, list12, pageable);
    }

    @Operation(description="Return recently added or updated series.")
    @PageableWithoutSortAsQueryParam
    @GetMapping(value={"v1/series/latest"})
    @NotNull
    public Page<SeriesDto> getLatestSeries(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="library_id", required=false) @Nullable List<String> libraryIds, @RequestParam(name="deleted", required=false) @Nullable Boolean deleted, @RequestParam(name="oneshot", required=false) @Nullable Boolean oneshot, @RequestParam(name="unpaged", required=false) boolean unpaged, @Parameter(hidden=true) @NotNull Pageable page) {
        Pageable pageable;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Sort.Order[] orderArray = new Sort.Order[]{Sort.Order.desc((String)"lastModified")};
        Sort sort = Sort.by((Sort.Order[])orderArray);
        Intrinsics.checkNotNullExpressionValue((Object)sort, (String)"by(...)");
        Sort sort2 = sort;
        if (unpaged) {
            pageable = (Pageable)new UnpagedSorted(sort2);
        } else {
            PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)sort2);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            pageable = (Pageable)pageRequest;
        }
        Pageable pageRequest = pageable;
        Page page2 = this.seriesDtoRepository.findAll(new SeriesSearchWithReadProgress(principal.getUser().getAuthorizedLibraryIds((Collection)libraryIds), null, null, null, null, null, deleted, null, oneshot, null, null, null, null, null, null, null, null, 130750, null), principal.getUser().getId(), pageRequest, principal.getUser().getRestrictions()).map(arg_0 -> SeriesController.getLatestSeries$lambda$5((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    public static /* synthetic */ Page getLatestSeries$default(SeriesController seriesController, KomgaPrincipal komgaPrincipal, List list, Boolean bl, Boolean bl2, boolean bl3, Pageable pageable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getLatestSeries");
        }
        if ((n & 8) != 0) {
            bl2 = null;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        return seriesController.getLatestSeries(komgaPrincipal, list, bl, bl2, bl3, pageable);
    }

    @Operation(description="Return newly added series.")
    @PageableWithoutSortAsQueryParam
    @GetMapping(value={"v1/series/new"})
    @NotNull
    public Page<SeriesDto> getNewSeries(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="library_id", required=false) @Nullable List<String> libraryIds, @RequestParam(name="deleted", required=false) @Nullable Boolean deleted, @RequestParam(name="oneshot", required=false) @Nullable Boolean oneshot, @RequestParam(name="unpaged", required=false) boolean unpaged, @Parameter(hidden=true) @NotNull Pageable page) {
        Pageable pageable;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Sort.Order[] orderArray = new Sort.Order[]{Sort.Order.desc((String)"created")};
        Sort sort = Sort.by((Sort.Order[])orderArray);
        Intrinsics.checkNotNullExpressionValue((Object)sort, (String)"by(...)");
        Sort sort2 = sort;
        if (unpaged) {
            pageable = (Pageable)new UnpagedSorted(sort2);
        } else {
            PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)sort2);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            pageable = (Pageable)pageRequest;
        }
        Pageable pageRequest = pageable;
        Page page2 = this.seriesDtoRepository.findAll(new SeriesSearchWithReadProgress(principal.getUser().getAuthorizedLibraryIds((Collection)libraryIds), null, null, null, null, null, deleted, null, oneshot, null, null, null, null, null, null, null, null, 130750, null), principal.getUser().getId(), pageRequest, principal.getUser().getRestrictions()).map(arg_0 -> SeriesController.getNewSeries$lambda$6((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    public static /* synthetic */ Page getNewSeries$default(SeriesController seriesController, KomgaPrincipal komgaPrincipal, List list, Boolean bl, Boolean bl2, boolean bl3, Pageable pageable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getNewSeries");
        }
        if ((n & 2) != 0) {
            list = null;
        }
        if ((n & 4) != 0) {
            bl = null;
        }
        if ((n & 8) != 0) {
            bl2 = null;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        return seriesController.getNewSeries(komgaPrincipal, list, bl, bl2, bl3, pageable);
    }

    @Operation(description="Return recently updated series, but not newly added ones.")
    @PageableWithoutSortAsQueryParam
    @GetMapping(value={"v1/series/updated"})
    @NotNull
    public Page<SeriesDto> getUpdatedSeries(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="library_id", required=false) @Nullable List<String> libraryIds, @RequestParam(name="deleted", required=false) @Nullable Boolean deleted, @RequestParam(name="oneshot", required=false) @Nullable Boolean oneshot, @RequestParam(name="unpaged", required=false) boolean unpaged, @Parameter(hidden=true) @NotNull Pageable page) {
        Pageable pageable;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Sort.Order[] orderArray = new Sort.Order[]{Sort.Order.desc((String)"lastModified")};
        Sort sort = Sort.by((Sort.Order[])orderArray);
        Intrinsics.checkNotNullExpressionValue((Object)sort, (String)"by(...)");
        Sort sort2 = sort;
        if (unpaged) {
            pageable = (Pageable)new UnpagedSorted(sort2);
        } else {
            PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)sort2);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            pageable = (Pageable)pageRequest;
        }
        Pageable pageRequest = pageable;
        Page page2 = this.seriesDtoRepository.findAllRecentlyUpdated(new SeriesSearchWithReadProgress(principal.getUser().getAuthorizedLibraryIds((Collection)libraryIds), null, null, null, null, null, deleted, null, oneshot, null, null, null, null, null, null, null, null, 130750, null), principal.getUser().getId(), principal.getUser().getRestrictions(), pageRequest).map(arg_0 -> SeriesController.getUpdatedSeries$lambda$7((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    public static /* synthetic */ Page getUpdatedSeries$default(SeriesController seriesController, KomgaPrincipal komgaPrincipal, List list, Boolean bl, Boolean bl2, boolean bl3, Pageable pageable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getUpdatedSeries");
        }
        if ((n & 2) != 0) {
            list = null;
        }
        if ((n & 4) != 0) {
            bl = null;
        }
        if ((n & 8) != 0) {
            bl2 = null;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        return seriesController.getUpdatedSeries(komgaPrincipal, list, bl, bl2, bl3, pageable);
    }

    @GetMapping(value={"v1/series/{seriesId}"})
    @NotNull
    public SeriesDto getOneSeries(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="seriesId") @NotNull String id) {
        SeriesDto seriesDto;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                seriesDto = this.seriesDtoRepository.findByIdOrNull(id, principal.getUser().getId());
                if (seriesDto == null) break block2;
                SeriesDto it = seriesDto;
                boolean bl = false;
                this.contentRestrictionChecker.checkContentRestriction(principal.getUser(), it);
                SeriesDto seriesDto2 = SeriesDtoKt.restrictUrl((SeriesDto)it, (!principal.getUser().getRoleAdmin() ? 1 : 0) != 0);
                seriesDto = seriesDto2;
                if (seriesDto2 != null) break block3;
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return seriesDto;
    }

    @ApiResponse(content={@Content(schema=@Schema(format="binary", type="string"))})
    @GetMapping(value={"v1/series/{seriesId}/thumbnail"}, produces={"image/jpeg"})
    @NotNull
    public byte[] getSeriesDefaultThumbnail(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="seriesId") @NotNull String seriesId) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        this.checkContentRestriction(principal.getUser(), seriesId);
        byte[] byArray = this.seriesLifecycle.getThumbnailBytes(seriesId, principal.getUser().getId());
        if (byArray == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return byArray;
    }

    @ApiResponse(content={@Content(schema=@Schema(format="binary", type="string"))})
    @GetMapping(value={"v1/series/{seriesId}/thumbnails/{thumbnailId}"}, produces={"image/jpeg"})
    @NotNull
    public byte[] getSeriesThumbnailById(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="seriesId") @NotNull String seriesId, @PathVariable(name="thumbnailId") @NotNull String thumbnailId) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        Intrinsics.checkNotNullParameter((Object)thumbnailId, (String)"thumbnailId");
        this.checkContentRestriction(principal.getUser(), seriesId);
        byte[] byArray = this.seriesLifecycle.getThumbnailBytesByThumbnailId(thumbnailId);
        if (byArray == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"v1/series/{seriesId}/thumbnails"}, produces={"application/json"})
    @NotNull
    public Collection<ThumbnailSeriesDto> getSeriesThumbnails(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="seriesId") @NotNull String seriesId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        this.checkContentRestriction(principal.getUser(), seriesId);
        Iterable $this$map$iv = this.thumbnailsSeriesRepository.findAllBySeriesId(seriesId);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ThumbnailSeries thumbnailSeries = (ThumbnailSeries)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ThumbnailSeriesDtoKt.toDto((ThumbnailSeries)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"v1/series/{seriesId}/thumbnails"}, consumes={"multipart/form-data"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @NotNull
    public ThumbnailSeriesDto postUserUploadedSeriesThumbnail(@PathVariable(name="seriesId") @NotNull String seriesId, @RequestParam(value="file") @NotNull MultipartFile file, @RequestParam(value="selected") boolean selected) {
        String string;
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Series series = this.seriesRepository.findByIdOrNull(seriesId);
        if (series == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        Series series2 = series;
        if (series2.getOneshot()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        InputStream inputStream = file.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        Object object = inputStream;
        int n = 8192;
        object = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
        Object object2 = null;
        try {
            BufferedInputStream it = (BufferedInputStream)object;
            boolean bl = false;
            string = this.contentDetector.detectMediaType((InputStream)it);
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        String mediaType2 = string;
        if (!this.contentDetector.isImage(mediaType2)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNSUPPORTED_MEDIA_TYPE);
        }
        object = series2.getId();
        object2 = file.getBytes();
        string = ThumbnailSeries.Type.USER_UPLOADED;
        long l = file.getBytes().length;
        InputStream inputStream2 = file.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getInputStream(...)");
        InputStream inputStream3 = inputStream2;
        int n2 = 8192;
        Dimension dimension = this.imageAnalyzer.getDimension((InputStream)(inputStream3 instanceof BufferedInputStream ? (BufferedInputStream)inputStream3 : new BufferedInputStream(inputStream3, n2)));
        if (dimension == null) {
            dimension = new Dimension(0, 0);
        }
        Dimension dimension2 = dimension;
        return ThumbnailSeriesDtoKt.toDto((ThumbnailSeries)this.seriesLifecycle.addThumbnailForSeries(new ThumbnailSeries((byte[])object2, null, false, (ThumbnailSeries.Type)string, mediaType2, l, dimension2, null, (String)object, null, null, 1670, null), selected ? MarkSelectedPreference.YES : MarkSelectedPreference.NO));
    }

    public static /* synthetic */ ThumbnailSeriesDto postUserUploadedSeriesThumbnail$default(SeriesController seriesController, String string, MultipartFile multipartFile, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: postUserUploadedSeriesThumbnail");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return seriesController.postUserUploadedSeriesThumbnail(string, multipartFile, bl);
    }

    @PutMapping(value={"v1/series/{seriesId}/thumbnails/{thumbnailId}/selected"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void postMarkSelectedSeriesThumbnail(@PathVariable(name="seriesId") @NotNull String seriesId, @PathVariable(name="thumbnailId") @NotNull String thumbnailId) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        Intrinsics.checkNotNullParameter((Object)thumbnailId, (String)"thumbnailId");
        if (this.seriesRepository.findByIdOrNull(seriesId) == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        ThumbnailSeries thumbnailSeries = this.thumbnailsSeriesRepository.findByIdOrNull(thumbnailId);
        if (thumbnailSeries != null) {
            ThumbnailSeries it = thumbnailSeries;
            boolean bl = false;
            this.thumbnailsSeriesRepository.markSelected(it);
            this.eventPublisher.publishEvent((Object)new DomainEvent.ThumbnailSeriesAdded(ThumbnailSeries.copy$default((ThumbnailSeries)it, null, null, (boolean)true, null, null, (long)0L, null, null, null, null, null, (int)2043, null)));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @DeleteMapping(value={"v1/series/{seriesId}/thumbnails/{thumbnailId}"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void deleteUserUploadedSeriesThumbnail(@PathVariable(name="seriesId") @NotNull String seriesId, @PathVariable(name="thumbnailId") @NotNull String thumbnailId) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        Intrinsics.checkNotNullParameter((Object)thumbnailId, (String)"thumbnailId");
        if (this.seriesRepository.findByIdOrNull(seriesId) == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        ThumbnailSeries thumbnailSeries = this.thumbnailsSeriesRepository.findByIdOrNull(thumbnailId);
        if (thumbnailSeries != null) {
            ThumbnailSeries it = thumbnailSeries;
            boolean bl = false;
            try {
                this.seriesLifecycle.deleteThumbnailForSeries(it);
            }
            catch (IllegalArgumentException e) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage());
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @PageableAsQueryParam
    @AuthorsAsQueryParam
    @GetMapping(value={"v1/series/{seriesId}/books"})
    @NotNull
    public Page<BookDto> getAllBooksBySeries(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="seriesId") @NotNull String seriesId, @RequestParam(name="media_status", required=false) @Nullable List<? extends Media.Status> mediaStatus, @RequestParam(name="read_status", required=false) @Nullable List<? extends ReadStatus> readStatus, @RequestParam(name="tag", required=false) @Nullable List<String> tags, @RequestParam(name="deleted", required=false) @Nullable Boolean deleted, @RequestParam(name="unpaged", required=false) boolean unpaged, @Parameter(hidden=true) @Authors @Nullable List<Author> authors, @Parameter(hidden=true) @NotNull Pageable page) {
        Pageable pageable;
        Sort sort;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        this.checkContentRestriction(principal.getUser(), seriesId);
        if (page.getSort().isSorted()) {
            sort = page.getSort();
        } else {
            Sort.Order[] orderArray = new Sort.Order[]{Sort.Order.asc((String)"metadata.numberSort")};
            sort = Sort.by((Sort.Order[])orderArray);
        }
        Sort sort2 = sort;
        Intrinsics.checkNotNull((Object)sort2);
        Sort sort3 = sort2;
        if (unpaged) {
            pageable = (Pageable)new UnpagedSorted(sort3);
        } else {
            PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)sort3);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            pageable = (Pageable)pageRequest;
        }
        Pageable pageRequest = pageable;
        List list = CollectionsKt.listOf((Object)seriesId);
        Page page2 = BookDtoRepository.DefaultImpls.findAll$default((BookDtoRepository)this.bookDtoRepository, (BookSearchWithReadProgress)new BookSearchWithReadProgress(null, (Collection)list, null, (Collection)mediaStatus, null, deleted, null, (Collection)tags, (Collection)readStatus, (Collection)authors, 85, null), (String)principal.getUser().getId(), (Pageable)pageRequest, null, (int)8, null).map(arg_0 -> SeriesController.getAllBooksBySeries$lambda$13((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    public static /* synthetic */ Page getAllBooksBySeries$default(SeriesController seriesController, KomgaPrincipal komgaPrincipal, String string, List list, List list2, List list3, Boolean bl, boolean bl2, List list4, Pageable pageable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getAllBooksBySeries");
        }
        if ((n & 4) != 0) {
            list = null;
        }
        if ((n & 8) != 0) {
            list2 = null;
        }
        if ((n & 0x10) != 0) {
            list3 = null;
        }
        if ((n & 0x20) != 0) {
            bl = null;
        }
        if ((n & 0x40) != 0) {
            bl2 = false;
        }
        if ((n & 0x80) != 0) {
            list4 = null;
        }
        return seriesController.getAllBooksBySeries(komgaPrincipal, string, list, list2, list3, bl, bl2, list4, pageable);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"v1/series/{seriesId}/collections"})
    @NotNull
    public List<CollectionDto> getAllCollectionsBySeries(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="seriesId") @NotNull String seriesId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        this.checkContentRestriction(principal.getUser(), seriesId);
        Iterable $this$map$iv = this.collectionRepository.findAllContainingSeriesId(seriesId, principal.getUser().getAuthorizedLibraryIds(null), principal.getUser().getRestrictions());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SeriesCollection seriesCollection = (SeriesCollection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CollectionDtoKt.toDto((SeriesCollection)it));
        }
        return (List)destination$iv$iv;
    }

    @PostMapping(value={"v1/series/{seriesId}/analyze"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void analyze(@PathVariable @NotNull String seriesId) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        this.taskEmitter.analyzeBook(this.bookRepository.findAllBySeriesId(seriesId), 6);
    }

    @PostMapping(value={"v1/series/{seriesId}/metadata/refresh"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void refreshMetadata(@PathVariable @NotNull String seriesId) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        Collection books = this.bookRepository.findAllBySeriesId(seriesId);
        TaskEmitter.refreshBookMetadata$default((TaskEmitter)this.taskEmitter, (Collection)books, null, (int)6, (int)2, null);
        this.taskEmitter.refreshBookLocalArtwork(books, 6);
        this.taskEmitter.refreshSeriesLocalArtwork(seriesId, 6);
    }

    /*
     * WARNING - void declaration
     */
    @PatchMapping(value={"v1/series/{seriesId}/metadata"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateMetadata(@PathVariable @NotNull String seriesId, @Parameter(description="Metadata fields to update. Set a field to null to unset the metadata. You can omit fields you don't want to update.") @Valid @RequestBody @NotNull SeriesMetadataUpdateDto newMetadata, @AuthenticationPrincipal @NotNull KomgaPrincipal principal) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        Intrinsics.checkNotNullParameter((Object)newMetadata, (String)"newMetadata");
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        SeriesMetadata seriesMetadata = this.seriesMetadataRepository.findByIdOrNull(seriesId);
        if (seriesMetadata != null) {
            List list;
            boolean bl;
            List list2;
            Collection collection;
            boolean bl2;
            Set set;
            boolean bl3;
            Set set2;
            boolean bl4;
            Set set3;
            boolean bl5;
            SeriesMetadata existing = seriesMetadata;
            boolean bl6 = false;
            SeriesMetadataUpdateDto $this$updateMetadata_u24lambda_u2419_u24lambda_u2417 = newMetadata;
            boolean bl7 = false;
            SeriesMetadata.Status status = $this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getStatus();
            if (status == null) {
                status = existing.getStatus();
            }
            SeriesMetadata.Status status2 = status;
            Boolean bl8 = $this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getStatusLock();
            boolean bl9 = bl8 != null ? bl8.booleanValue() : existing.getStatusLock();
            String string = $this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getTitle();
            if (string == null) {
                string = existing.getTitle();
            }
            String string2 = string;
            Boolean bl10 = $this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getTitleLock();
            boolean bl11 = bl10 != null ? bl10.booleanValue() : existing.getTitleLock();
            String string3 = $this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getTitleSort();
            if (string3 == null) {
                string3 = existing.getTitleSort();
            }
            String string4 = string3;
            Boolean bl12 = $this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getTitleSortLock();
            boolean bl13 = bl12 != null ? bl12.booleanValue() : existing.getTitleSortLock();
            String string5 = $this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getSummary();
            if (string5 == null) {
                string5 = existing.getSummary();
            }
            String string6 = string5;
            Boolean bl14 = $this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getSummaryLock();
            boolean bl15 = bl14 != null ? bl14.booleanValue() : existing.getSummaryLock();
            String string7 = $this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getLanguage();
            if (string7 == null) {
                string7 = existing.getLanguage();
            }
            String string8 = string7;
            Boolean bl16 = $this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getLanguageLock();
            boolean bl17 = bl16 != null ? bl16.booleanValue() : existing.getLanguageLock();
            SeriesMetadata.ReadingDirection readingDirection = $this$updateMetadata_u24lambda_u2419_u24lambda_u2417.isSet("readingDirection") ? $this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getReadingDirection() : existing.getReadingDirection();
            Boolean bl18 = $this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getReadingDirectionLock();
            boolean bl19 = bl18 != null ? bl18.booleanValue() : existing.getReadingDirectionLock();
            String string9 = $this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getPublisher();
            if (string9 == null) {
                string9 = existing.getPublisher();
            }
            String string10 = string9;
            Boolean bl20 = $this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getPublisherLock();
            boolean bl21 = bl20 != null ? bl20.booleanValue() : existing.getPublisherLock();
            Integer n = $this$updateMetadata_u24lambda_u2419_u24lambda_u2417.isSet("ageRating") ? $this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getAgeRating() : existing.getAgeRating();
            Boolean bl22 = $this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getAgeRatingLock();
            boolean bl23 = bl5 = bl22 != null ? bl22.booleanValue() : existing.getAgeRatingLock();
            if ($this$updateMetadata_u24lambda_u2419_u24lambda_u2417.isSet("genres")) {
                if ($this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getGenres() != null) {
                    Set set4 = $this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getGenres();
                    set3 = set4;
                    Intrinsics.checkNotNull((Object)set4);
                } else {
                    set3 = SetsKt.emptySet();
                }
            } else {
                set3 = existing.getGenres();
            }
            Set set5 = set3;
            Boolean bl24 = $this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getGenresLock();
            boolean bl25 = bl4 = bl24 != null ? bl24.booleanValue() : existing.getGenresLock();
            if ($this$updateMetadata_u24lambda_u2419_u24lambda_u2417.isSet("tags")) {
                if ($this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getTags() != null) {
                    Set set6 = $this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getTags();
                    set2 = set6;
                    Intrinsics.checkNotNull((Object)set6);
                } else {
                    set2 = SetsKt.emptySet();
                }
            } else {
                set2 = existing.getTags();
            }
            Set set7 = set2;
            Boolean bl26 = $this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getTagsLock();
            boolean bl27 = bl26 != null ? bl26.booleanValue() : existing.getTagsLock();
            Integer n2 = $this$updateMetadata_u24lambda_u2419_u24lambda_u2417.isSet("totalBookCount") ? $this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getTotalBookCount() : existing.getTotalBookCount();
            Boolean bl28 = $this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getTotalBookCountLock();
            boolean bl29 = bl3 = bl28 != null ? bl28.booleanValue() : existing.getTotalBookCountLock();
            if ($this$updateMetadata_u24lambda_u2419_u24lambda_u2417.isSet("sharingLabels")) {
                if ($this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getSharingLabels() != null) {
                    Set set8 = $this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getSharingLabels();
                    set = set8;
                    Intrinsics.checkNotNull((Object)set8);
                } else {
                    set = SetsKt.emptySet();
                }
            } else {
                set = existing.getSharingLabels();
            }
            Set set9 = set;
            Boolean bl30 = $this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getSharingLabelsLock();
            boolean bl31 = bl2 = bl30 != null ? bl30.booleanValue() : existing.getSharingLabelsLock();
            if ($this$updateMetadata_u24lambda_u2419_u24lambda_u2417.isSet("links")) {
                if ($this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getLinks() != null) {
                    void $this$mapTo$iv$iv;
                    List list3 = $this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getLinks();
                    Intrinsics.checkNotNull((Object)list3);
                    Iterable $this$map$iv = list3;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        WebLinkUpdateDto webLinkUpdateDto = (WebLinkUpdateDto)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl32 = false;
                        String string11 = it.getLabel();
                        Intrinsics.checkNotNull((Object)string11);
                        String string12 = it.getUrl();
                        Intrinsics.checkNotNull((Object)string12);
                        collection.add(new WebLink(string11, new URI(string12)));
                    }
                    list2 = (List)destination$iv$iv;
                } else {
                    list2 = CollectionsKt.emptyList();
                }
            } else {
                list2 = existing.getLinks();
            }
            List list4 = list2;
            Boolean bl33 = $this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getLinksLock();
            boolean bl34 = bl = bl33 != null ? bl33.booleanValue() : existing.getLinksLock();
            if ($this$updateMetadata_u24lambda_u2419_u24lambda_u2417.isSet("alternateTitles")) {
                if ($this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getAlternateTitles() != null) {
                    void $this$mapTo$iv$iv;
                    List list5 = $this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getAlternateTitles();
                    Intrinsics.checkNotNull((Object)list5);
                    Iterable $this$map$iv = list5;
                    boolean $i$f$map = false;
                    Iterable $i$f$mapTo = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        AlternateTitleUpdateDto alternateTitleUpdateDto = (AlternateTitleUpdateDto)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl35 = false;
                        String string13 = it.getLabel();
                        Intrinsics.checkNotNull((Object)string13);
                        String string14 = it.getTitle();
                        Intrinsics.checkNotNull((Object)string14);
                        collection.add(new AlternateTitle(string13, string14));
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = CollectionsKt.emptyList();
                }
            } else {
                list = existing.getAlternateTitles();
            }
            List list6 = list;
            Boolean bl36 = $this$updateMetadata_u24lambda_u2419_u24lambda_u2417.getAlternateTitlesLock();
            boolean bl37 = bl36 != null ? bl36.booleanValue() : existing.getAlternateTitlesLock();
            SeriesMetadata updated = SeriesMetadata.copy$default((SeriesMetadata)existing, (SeriesMetadata.Status)status2, (String)string2, (String)string4, (String)string6, (SeriesMetadata.ReadingDirection)readingDirection, (String)string10, (Integer)n, (String)string8, (Set)set5, (Set)set7, (Integer)n2, (Set)set9, (List)list4, (List)list6, (boolean)bl9, (boolean)bl11, (boolean)bl13, (boolean)bl15, (boolean)bl19, (boolean)bl21, (boolean)bl5, (boolean)bl17, (boolean)bl4, (boolean)bl27, (boolean)bl3, (boolean)bl2, (boolean)bl, (boolean)bl37, null, null, null, (int)0x70000000, null);
            this.seriesMetadataRepository.update(updated);
            Series series = this.seriesRepository.findByIdOrNull(seriesId);
            if (series != null) {
                Series it = series;
                boolean bl38 = false;
                this.eventPublisher.publishEvent((Object)new DomainEvent.SeriesUpdated(it));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @Operation(description="Mark all book for series as read")
    @PostMapping(value={"v1/series/{seriesId}/read-progress"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void markAsRead(@PathVariable @NotNull String seriesId, @AuthenticationPrincipal @NotNull KomgaPrincipal principal) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        this.checkContentRestriction(principal.getUser(), seriesId);
        this.seriesLifecycle.markReadProgressCompleted(seriesId, principal.getUser());
    }

    @Operation(description="Mark all book for series as unread")
    @DeleteMapping(value={"v1/series/{seriesId}/read-progress"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void markAsUnread(@PathVariable @NotNull String seriesId, @AuthenticationPrincipal @NotNull KomgaPrincipal principal) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        this.checkContentRestriction(principal.getUser(), seriesId);
        this.seriesLifecycle.deleteReadProgress(seriesId, principal.getUser());
    }

    @GetMapping(value={"v2/series/{seriesId}/read-progress/tachiyomi"})
    @NotNull
    public TachiyomiReadProgressV2Dto getReadProgressTachiyomiV2(@PathVariable @NotNull String seriesId, @AuthenticationPrincipal @NotNull KomgaPrincipal principal) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        this.checkContentRestriction(principal.getUser(), seriesId);
        return this.readProgressDtoRepository.findProgressV2BySeries(seriesId, principal.getUser().getId());
    }

    /*
     * WARNING - void declaration
     */
    @PutMapping(value={"v2/series/{seriesId}/read-progress/tachiyomi"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void markReadProgressTachiyomiV2(@PathVariable @NotNull String seriesId, @RequestBody @NotNull TachiyomiReadProgressUpdateV2Dto readProgress, @AuthenticationPrincipal @NotNull KomgaPrincipal principal) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        Intrinsics.checkNotNullParameter((Object)readProgress, (String)"readProgress");
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        this.checkContentRestriction(principal.getUser(), seriesId);
        BookSearchWithReadProgress bookSearchWithReadProgress = new BookSearchWithReadProgress(null, (Collection)CollectionsKt.listOf((Object)seriesId), null, null, null, null, null, null, null, null, 1021, null);
        String string = principal.getUser().getId();
        Object object = new Sort.Order[]{Sort.Order.asc((String)"metadata.numberSort")};
        Sort sort = Sort.by((Sort.Order[])object);
        Intrinsics.checkNotNullExpressionValue((Object)sort, (String)"by(...)");
        Iterable iterable = BookDtoRepository.DefaultImpls.findAll$default((BookDtoRepository)this.bookDtoRepository, (BookSearchWithReadProgress)bookSearchWithReadProgress, (String)string, (Pageable)((Pageable)new UnpagedSorted(sort)), null, (int)8, null).toList();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"toList(...)");
        iterable = iterable;
        boolean $i$f$filter = false;
        object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BookDto book = (BookDto)element$iv$iv;
            boolean bl = false;
            if (!(book.getMetadata().getNumberSort() <= readProgress.getLastBookNumberSortRead())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BookDto book = (BookDto)element$iv;
            boolean bl = false;
            ReadProgressDto readProgressDto = book.getReadProgress();
            if (readProgressDto != null ? readProgressDto.getCompleted() : false) continue;
            this.bookLifecycle.markReadProgressCompleted(book.getId(), principal.getUser());
        }
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"v1/series/{seriesId}/file"}, produces={"application/octet-stream"})
    @PreAuthorize(value="hasRole('FILE_DOWNLOAD')")
    @NotNull
    public ResponseEntity<StreamingResponseBody> getSeriesFile(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String seriesId) {
        void $this$getSeriesFile_u24lambda_u2426;
        HttpHeaders httpHeaders;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        this.checkContentRestriction(principal.getUser(), seriesId);
        Collection books = this.bookRepository.findAllBySeriesId(seriesId);
        StreamingResponseBody streamingResponse2 = arg_0 -> SeriesController.getSeriesFile$lambda$25(books, arg_0);
        HttpHeaders httpHeaders2 = httpHeaders = new HttpHeaders();
        ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.ok();
        boolean bl = false;
        $this$getSeriesFile_u24lambda_u2426.setContentDisposition(ContentDisposition.builder((String)"attachment").filename(this.seriesMetadataRepository.findById(seriesId).getTitle() + ".zip", StandardCharsets.UTF_8).build());
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)bodyBuilder.headers(httpHeaders)).contentType(MediaType.parseMediaType((String)org.gotson.komga.domain.model.MediaType.ZIP.getType())).body((Object)streamingResponse2);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        return responseEntity;
    }

    @DeleteMapping(value={"v1/series/{seriesId}/file"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void deleteSeries(@PathVariable @NotNull String seriesId) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        this.taskEmitter.deleteSeries(seriesId, 8);
    }

    private void checkContentRestriction(KomgaUser $this$checkContentRestriction, String seriesId) {
        if (!$this$checkContentRestriction.canAccessAllLibraries()) {
            Unit unit;
            String string = this.seriesRepository.getLibraryId(seriesId);
            if (string != null) {
                String it = string;
                boolean bl = false;
                if (!$this$checkContentRestriction.canAccessLibrary(it)) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
        }
        if ($this$checkContentRestriction.getRestrictions().isRestricted()) {
            SeriesMetadata it = this.seriesMetadataRepository.findById(seriesId);
            boolean bl = false;
            if (!$this$checkContentRestriction.isContentAllowed(it.getAgeRating(), it.getSharingLabels())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
            }
        }
    }

    private static final SeriesDto getAllSeries$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SeriesDto)$tmp0.invoke(p0);
    }

    private static final SeriesDto getLatestSeries$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SeriesDto)$tmp0.invoke(p0);
    }

    private static final SeriesDto getNewSeries$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SeriesDto)$tmp0.invoke(p0);
    }

    private static final SeriesDto getUpdatedSeries$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SeriesDto)$tmp0.invoke(p0);
    }

    private static final BookDto getAllBooksBySeries$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (BookDto)$tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void getSeriesFile$lambda$25(Collection $books, OutputStream responseStream) {
        Intrinsics.checkNotNullParameter((Object)$books, (String)"$books");
        Intrinsics.checkNotNullParameter((Object)responseStream, (String)"responseStream");
        Closeable closeable = (Closeable)new ZipArchiveOutputStream(responseStream);
        Throwable throwable = null;
        try {
            ZipArchiveOutputStream zipStream = (ZipArchiveOutputStream)closeable;
            boolean bl = false;
            zipStream.setMethod(8);
            zipStream.setLevel(0);
            zipStream.setUseZip64(Zip64Mode.Always);
            Iterable $this$forEach$iv = $books;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Book book = (Book)element$iv;
                boolean bl2 = false;
                FileSystemResource file = new FileSystemResource(book.getPath());
                if (!file.exists()) {
                    SeriesControllerKt.access$getLogger$p().warn((Function0)new /* Unavailable Anonymous Inner Class!! */);
                    continue;
                }
                SeriesControllerKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
                Closeable closeable2 = file.getInputStream();
                Throwable throwable2 = null;
                try {
                    InputStream it = (InputStream)closeable2;
                    boolean bl3 = false;
                    zipStream.putArchiveEntry(new ZipArchiveEntry(file.getFilename()));
                    IOUtils.copyLarge((InputStream)it, (OutputStream)((OutputStream)zipStream), (byte[])new byte[8192]);
                    zipStream.closeArchiveEntry();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

