/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.net.protocol.jar;

final class Canonicalizer {
    private Canonicalizer() {
    }

    static String canonicalizeAfter(String path2, int pos) {
        boolean noDotSlash;
        int pathLength = path2.length();
        boolean bl = noDotSlash = path2.indexOf("./", pos) == -1;
        if (pos >= pathLength || noDotSlash && path2.charAt(pathLength - 1) != '.') {
            return path2;
        }
        String before = path2.substring(0, pos);
        String after = path2.substring(pos);
        return before + Canonicalizer.canonicalize(after);
    }

    static String canonicalize(String path2) {
        path2 = Canonicalizer.removeEmbeddedSlashDotDotSlash(path2);
        path2 = Canonicalizer.removeEmbeddedSlashDotSlash(path2);
        path2 = Canonicalizer.removeTrailingSlashDotDot(path2);
        path2 = Canonicalizer.removeTrailingSlashDot(path2);
        return path2;
    }

    private static String removeEmbeddedSlashDotDotSlash(String path2) {
        int index;
        while ((index = path2.indexOf("/../")) >= 0) {
            int priorSlash = path2.lastIndexOf(47, index - 1);
            String after = path2.substring(index + 3);
            path2 = priorSlash >= 0 ? path2.substring(0, priorSlash) + after : after;
        }
        return path2;
    }

    private static String removeEmbeddedSlashDotSlash(String path2) {
        int index;
        while ((index = ((String)path2).indexOf("/./")) >= 0) {
            String before = ((String)path2).substring(0, index);
            String after = ((String)path2).substring(index + 2);
            path2 = before + after;
        }
        return path2;
    }

    private static String removeTrailingSlashDot(String path2) {
        return !path2.endsWith("/.") ? path2 : path2.substring(0, path2.length() - 1);
    }

    private static String removeTrailingSlashDotDot(String path2) {
        while (path2.endsWith("/..")) {
            int index = path2.indexOf("/..");
            int priorSlash = path2.lastIndexOf(47, index - 1);
            path2 = priorSlash >= 0 ? path2.substring(0, priorSlash + 1) : path2.substring(0, index);
        }
        return path2;
    }
}

