/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.domain.service;

import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.application.scheduler.LibraryScanScheduler;
import org.gotson.komga.application.tasks.TaskEmitter;
import org.gotson.komga.domain.model.DirectoryNotFoundException;
import org.gotson.komga.domain.model.DomainEvent;
import org.gotson.komga.domain.model.DuplicateNameException;
import org.gotson.komga.domain.model.Library;
import org.gotson.komga.domain.model.PathContainedInPath;
import org.gotson.komga.domain.persistence.LibraryRepository;
import org.gotson.komga.domain.persistence.SeriesRepository;
import org.gotson.komga.domain.persistence.SidecarRepository;
import org.gotson.komga.domain.service.LibraryLifecycleKt;
import org.gotson.komga.domain.service.SeriesLifecycle;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionTemplate;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0014H\u0012J\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u001cH\u0012J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0014H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/gotson/komga/domain/service/LibraryLifecycle;", "", "libraryRepository", "Lorg/gotson/komga/domain/persistence/LibraryRepository;", "seriesLifecycle", "Lorg/gotson/komga/domain/service/SeriesLifecycle;", "seriesRepository", "Lorg/gotson/komga/domain/persistence/SeriesRepository;", "sidecarRepository", "Lorg/gotson/komga/domain/persistence/SidecarRepository;", "taskEmitter", "Lorg/gotson/komga/application/tasks/TaskEmitter;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "transactionTemplate", "Lorg/springframework/transaction/support/TransactionTemplate;", "libraryScanScheduler", "Lorg/gotson/komga/application/scheduler/LibraryScanScheduler;", "(Lorg/gotson/komga/domain/persistence/LibraryRepository;Lorg/gotson/komga/domain/service/SeriesLifecycle;Lorg/gotson/komga/domain/persistence/SeriesRepository;Lorg/gotson/komga/domain/persistence/SidecarRepository;Lorg/gotson/komga/application/tasks/TaskEmitter;Lorg/springframework/context/ApplicationEventPublisher;Lorg/springframework/transaction/support/TransactionTemplate;Lorg/gotson/komga/application/scheduler/LibraryScanScheduler;)V", "addLibrary", "Lorg/gotson/komga/domain/model/Library;", "library", "checkLibraryShouldRescan", "", "existing", "updated", "checkLibraryValidity", "", "", "deleteLibrary", "updateLibrary", "toUpdate", "komga"})
@SourceDebugExtension(value={"SMAP\nLibraryLifecycle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryLifecycle.kt\norg/gotson/komga/domain/service/LibraryLifecycle\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n766#2:122\n857#2,2:123\n223#2,2:125\n1549#2:127\n1620#2,3:128\n1855#2,2:131\n*S KotlinDebug\n*F\n+ 1 LibraryLifecycle.kt\norg/gotson/komga/domain/service/LibraryLifecycle\n*L\n57#1:122\n57#1:123,2\n58#1:125,2\n96#1:127\n96#1:128,3\n99#1:131,2\n*E\n"})
public class LibraryLifecycle {
    @NotNull
    private final LibraryRepository libraryRepository;
    @NotNull
    private final SeriesLifecycle seriesLifecycle;
    @NotNull
    private final SeriesRepository seriesRepository;
    @NotNull
    private final SidecarRepository sidecarRepository;
    @NotNull
    private final TaskEmitter taskEmitter;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private final TransactionTemplate transactionTemplate;
    @NotNull
    private final LibraryScanScheduler libraryScanScheduler;

    public LibraryLifecycle(@NotNull LibraryRepository libraryRepository, @NotNull SeriesLifecycle seriesLifecycle, @NotNull SeriesRepository seriesRepository, @NotNull SidecarRepository sidecarRepository, @NotNull TaskEmitter taskEmitter, @NotNull ApplicationEventPublisher eventPublisher, @NotNull TransactionTemplate transactionTemplate, @NotNull LibraryScanScheduler libraryScanScheduler) {
        Intrinsics.checkNotNullParameter((Object)libraryRepository, (String)"libraryRepository");
        Intrinsics.checkNotNullParameter((Object)seriesLifecycle, (String)"seriesLifecycle");
        Intrinsics.checkNotNullParameter((Object)seriesRepository, (String)"seriesRepository");
        Intrinsics.checkNotNullParameter((Object)sidecarRepository, (String)"sidecarRepository");
        Intrinsics.checkNotNullParameter((Object)taskEmitter, (String)"taskEmitter");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)transactionTemplate, (String)"transactionTemplate");
        Intrinsics.checkNotNullParameter((Object)libraryScanScheduler, (String)"libraryScanScheduler");
        this.libraryRepository = libraryRepository;
        this.seriesLifecycle = seriesLifecycle;
        this.seriesRepository = seriesRepository;
        this.sidecarRepository = sidecarRepository;
        this.taskEmitter = taskEmitter;
        this.eventPublisher = eventPublisher;
        this.transactionTemplate = transactionTemplate;
        this.libraryScanScheduler = libraryScanScheduler;
    }

    @NotNull
    public Library addLibrary(@NotNull Library library) throws FileNotFoundException, DirectoryNotFoundException, DuplicateNameException, PathContainedInPath {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        LibraryLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        Collection existing = this.libraryRepository.findAll();
        this.checkLibraryValidity(library, existing);
        this.libraryRepository.insert(library);
        TaskEmitter.scanLibrary$default((TaskEmitter)this.taskEmitter, (String)library.getId(), (boolean)false, (int)0, (int)6, null);
        this.eventPublisher.publishEvent((Object)new DomainEvent.LibraryAdded(library));
        return this.libraryRepository.findById(library.getId());
    }

    /*
     * WARNING - void declaration
     */
    public void updateLibrary(@NotNull Library toUpdate) {
        Object element$iv2;
        List otherLibraries;
        block4: {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)toUpdate, (String)"toUpdate");
            LibraryLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
            Collection libraries = this.libraryRepository.findAll();
            Iterable $this$filter$iv = libraries;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Library it = (Library)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it.getId(), (Object)toUpdate.getId()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            otherLibraries = (List)destination$iv$iv;
            Iterable $this$first$iv = libraries;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Library it = (Library)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)toUpdate.getId())) continue;
                break block4;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Library current = (Library)element$iv2;
        this.checkLibraryValidity(toUpdate, (Collection)otherLibraries);
        this.libraryRepository.update(toUpdate);
        if (current.getScanInterval() != toUpdate.getScanInterval()) {
            this.libraryScanScheduler.scheduleScan(toUpdate);
        }
        if (this.checkLibraryShouldRescan(current, toUpdate)) {
            TaskEmitter.scanLibrary$default((TaskEmitter)this.taskEmitter, (String)toUpdate.getId(), (boolean)false, (int)0, (int)6, null);
        }
        this.eventPublisher.publishEvent((Object)new DomainEvent.LibraryUpdated(toUpdate));
    }

    private boolean checkLibraryShouldRescan(Library existing, Library updated) {
        if (!Intrinsics.areEqual((Object)existing.getRoot(), (Object)updated.getRoot())) {
            return true;
        }
        if (!Intrinsics.areEqual((Object)existing.getOneshotsDirectory(), (Object)updated.getOneshotsDirectory())) {
            return true;
        }
        if (existing.getScanCbx() != updated.getScanCbx()) {
            return true;
        }
        if (existing.getScanPdf() != updated.getScanPdf()) {
            return true;
        }
        if (existing.getScanEpub() != updated.getScanEpub()) {
            return true;
        }
        if (existing.getScanForceModifiedTime() != updated.getScanForceModifiedTime()) {
            return true;
        }
        return !Intrinsics.areEqual((Object)existing.getScanDirectoryExclusions(), (Object)updated.getScanDirectoryExclusions());
    }

    /*
     * WARNING - void declaration
     */
    private void checkLibraryValidity(Library library, Collection<Library> existing) {
        void $this$mapTo$iv$iv;
        if (!Files.exists(library.getPath(), new LinkOption[0])) {
            throw new FileNotFoundException("Library root folder does not exist: " + library.getRoot());
        }
        if (!Files.isDirectory(library.getPath(), new LinkOption[0])) {
            throw new DirectoryNotFoundException("Library root folder is not a folder: " + library.getRoot(), null, 2, null);
        }
        Iterable $this$map$iv = existing;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Library library2 = (Library)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        if (((List)destination$iv$iv).contains(library.getName())) {
            throw new DuplicateNameException("Library name already exists", null, 2, null);
        }
        Iterable $this$forEach$iv = existing;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Library it = (Library)element$iv;
            boolean bl = false;
            if (library.getPath().startsWith(it.getPath())) {
                throw new PathContainedInPath("Library path " + library.getPath() + " is a child of existing library " + it.getName() + ": " + it.getPath(), null, 2, null);
            }
            if (!it.getPath().startsWith(library.getPath())) continue;
            throw new PathContainedInPath("Library path " + library.getPath() + " is a parent of existing library " + it.getName() + ": " + it.getPath(), null, 2, null);
        }
    }

    public void deleteLibrary(@NotNull Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        LibraryLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        Collection series = this.seriesRepository.findAllByLibraryId(library.getId());
        this.transactionTemplate.executeWithoutResult(arg_0 -> LibraryLifecycle.deleteLibrary$lambda$4(this, series, library, arg_0));
        this.eventPublisher.publishEvent((Object)new DomainEvent.LibraryDeleted(library));
    }

    private static final void deleteLibrary$lambda$4(LibraryLifecycle this$0, Collection $series, Library $library, TransactionStatus it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$series, (String)"$series");
        Intrinsics.checkNotNullParameter((Object)$library, (String)"$library");
        this$0.seriesLifecycle.deleteMany($series);
        this$0.sidecarRepository.deleteByLibraryId($library.getId());
        this$0.libraryRepository.delete($library.getId());
    }
}

