/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.jooq.main;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.model.KomgaUser;
import org.gotson.komga.domain.persistence.AuthenticationActivityRepository;
import org.gotson.komga.infrastructure.jooq.UtilsKt;
import org.gotson.komga.jooq.main.Tables;
import org.gotson.komga.jooq.main.tables.AuthenticationActivity;
import org.gotson.komga.jooq.main.tables.records.AuthenticationActivityRecord;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.RecordMapper;
import org.jooq.SelectConditionStep;
import org.jooq.SelectSeekStepN;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.True;
import org.jooq.impl.DSL;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0012J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u001c2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00170\u001c2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u001f\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u0017H\u0016J\f\u0010\"\u001a\u00020\u0017*\u00020\fH\u0012R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R^\u0010\b\u001aR\u0012\u0004\u0012\u00020\n\u0012H\u0012F\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0007*\u0004\u0018\u00010\r0\r \u0007*\"\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0007*\u0004\u0018\u00010\r0\r\u0018\u00010\u000b0\u000b0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/gotson/komga/infrastructure/jooq/main/AuthenticationActivityDao;", "Lorg/gotson/komga/domain/persistence/AuthenticationActivityRepository;", "dsl", "Lorg/jooq/DSLContext;", "(Lorg/jooq/DSLContext;)V", "aa", "Lorg/gotson/komga/jooq/main/tables/AuthenticationActivity;", "kotlin.jvm.PlatformType", "sorts", "", "", "Lorg/jooq/TableField;", "Lorg/gotson/komga/jooq/main/tables/records/AuthenticationActivityRecord;", "", "deleteByUser", "", "user", "Lorg/gotson/komga/domain/model/KomgaUser;", "deleteOlderThan", "dateTime", "Ljava/time/LocalDateTime;", "findAll", "Lorg/springframework/data/domain/PageImpl;", "Lorg/gotson/komga/domain/model/AuthenticationActivity;", "conditions", "Lorg/jooq/Condition;", "pageable", "Lorg/springframework/data/domain/Pageable;", "Lorg/springframework/data/domain/Page;", "findAllByUser", "findMostRecentByUser", "apiKeyId", "insert", "activity", "toDomain", "komga"})
@SourceDebugExtension(value={"SMAP\nAuthenticationActivityDao.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthenticationActivityDao.kt\norg/gotson/komga/infrastructure/jooq/main/AuthenticationActivityDao\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n1#2:130\n*E\n"})
public class AuthenticationActivityDao
implements AuthenticationActivityRepository {
    @NotNull
    private final DSLContext dsl;
    private final AuthenticationActivity aa;
    @NotNull
    private final Map<String, TableField<AuthenticationActivityRecord, ? extends Object>> sorts;

    public AuthenticationActivityDao(@NotNull DSLContext dsl) {
        Intrinsics.checkNotNullParameter((Object)dsl, (String)"dsl");
        this.dsl = dsl;
        this.aa = Tables.AUTHENTICATION_ACTIVITY;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"dateTime", (Object)this.aa.DATE_TIME), TuplesKt.to((Object)"email", (Object)this.aa.EMAIL), TuplesKt.to((Object)"success", (Object)this.aa.SUCCESS), TuplesKt.to((Object)"ip", (Object)this.aa.IP), TuplesKt.to((Object)"error", (Object)this.aa.ERROR), TuplesKt.to((Object)"userId", (Object)this.aa.USER_ID), TuplesKt.to((Object)"userAgent", (Object)this.aa.USER_AGENT)};
        this.sorts = MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public Page<org.gotson.komga.domain.model.AuthenticationActivity> findAll(@NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        True true_ = DSL.trueCondition();
        Intrinsics.checkNotNullExpressionValue((Object)true_, (String)"trueCondition(...)");
        Condition conditions = (Condition)true_;
        return (Page)this.findAll(conditions, pageable);
    }

    @NotNull
    public Page<org.gotson.komga.domain.model.AuthenticationActivity> findAllByUser(@NotNull KomgaUser user, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Condition condition = this.aa.USER_ID.eq((Object)user.getId()).or(this.aa.EMAIL.eq((Object)user.getEmail()));
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"or(...)");
        Condition conditions = condition;
        return (Page)this.findAll(conditions, pageable);
    }

    @Nullable
    public org.gotson.komga.domain.model.AuthenticationActivity findMostRecentByUser(@NotNull KomgaUser user, @Nullable String apiKeyId) {
        SelectConditionStep selectConditionStep;
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        SelectConditionStep $this$findMostRecentByUser_u24lambda_u241 = selectConditionStep = this.dsl.selectFrom((TableLike)this.aa).where(this.aa.USER_ID.eq((Object)user.getId())).or(this.aa.EMAIL.eq((Object)user.getEmail()));
        boolean bl = false;
        String string = apiKeyId;
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            $this$findMostRecentByUser_u24lambda_u241.and(this.aa.API_KEY_ID.eq((Object)it));
        }
        AuthenticationActivityRecord authenticationActivityRecord = (AuthenticationActivityRecord)selectConditionStep.orderBy((OrderField)this.aa.DATE_TIME.desc()).limit((Number)1).fetchOne();
        return authenticationActivityRecord != null ? this.toDomain(authenticationActivityRecord) : null;
    }

    private PageImpl<org.gotson.komga.domain.model.AuthenticationActivity> findAll(Condition conditions, Pageable pageable) {
        SelectSeekStepN selectSeekStepN;
        int count = this.dsl.fetchCount((Table)this.aa, conditions);
        Sort sort = pageable.getSort();
        Intrinsics.checkNotNullExpressionValue((Object)sort, (String)"getSort(...)");
        List orderBy = UtilsKt.toOrderBy((Sort)sort, (Map)this.sorts);
        SelectSeekStepN $this$findAll_u24lambda_u242 = selectSeekStepN = this.dsl.selectFrom((TableLike)this.aa).where(conditions).orderBy((Collection)orderBy);
        boolean bl = false;
        if (pageable.isPaged()) {
            $this$findAll_u24lambda_u242.limit((Number)pageable.getPageSize()).offset((Number)pageable.getOffset());
        }
        List list = selectSeekStepN.fetchInto((Table)this.aa).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        List items2 = list;
        selectSeekStepN = !((Collection)orderBy).isEmpty() ? pageable.getSort() : Sort.unsorted();
        Intrinsics.checkNotNull((Object)selectSeekStepN);
        SelectSeekStepN pageSort = selectSeekStepN;
        return new PageImpl(items2, (Pageable)(pageable.isPaged() ? PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)pageSort) : PageRequest.of((int)0, (int)Math.max(count, 20), (Sort)pageSort)), (long)count);
    }

    public void insert(@NotNull org.gotson.komga.domain.model.AuthenticationActivity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.dsl.insertInto((Table)this.aa, (Field)this.aa.USER_ID, (Field)this.aa.EMAIL, (Field)this.aa.API_KEY_ID, (Field)this.aa.API_KEY_COMMENT, (Field)this.aa.IP, (Field)this.aa.USER_AGENT, (Field)this.aa.SUCCESS, (Field)this.aa.ERROR, (Field)this.aa.SOURCE).values((Object)activity.getUserId(), (Object)activity.getEmail(), (Object)activity.getApiKeyId(), (Object)activity.getApiKeyComment(), (Object)activity.getIp(), (Object)activity.getUserAgent(), (Object)activity.getSuccess(), (Object)activity.getError(), (Object)activity.getSource()).execute();
    }

    public void deleteByUser(@NotNull KomgaUser user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        this.dsl.deleteFrom((Table)this.aa).where(this.aa.USER_ID.eq((Object)user.getId())).or(this.aa.EMAIL.eq((Object)user.getEmail())).execute();
    }

    public void deleteOlderThan(@NotNull LocalDateTime dateTime) {
        Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
        this.dsl.deleteFrom((Table)this.aa).where(this.aa.DATE_TIME.lt((Object)dateTime)).execute();
    }

    private org.gotson.komga.domain.model.AuthenticationActivity toDomain(AuthenticationActivityRecord $this$toDomain) {
        String string = $this$toDomain.getUserId();
        String string2 = $this$toDomain.getEmail();
        String string3 = $this$toDomain.getApiKeyId();
        String string4 = $this$toDomain.getApiKeyComment();
        String string5 = $this$toDomain.getIp();
        String string6 = $this$toDomain.getUserAgent();
        Boolean bl = $this$toDomain.getSuccess();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getSuccess(...)");
        boolean bl2 = bl;
        String string7 = $this$toDomain.getError();
        LocalDateTime localDateTime = $this$toDomain.getDateTime();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"getDateTime(...)");
        return new org.gotson.komga.domain.model.AuthenticationActivity(string, string2, string3, string4, string5, string6, bl2, string7, LanguageUtilsKt.toCurrentTimeZone((LocalDateTime)localDateTime), $this$toDomain.getSource());
    }

    public static final /* synthetic */ org.gotson.komga.domain.model.AuthenticationActivity access$toDomain(AuthenticationActivityDao $this, AuthenticationActivityRecord $receiver) {
        return $this.toDomain($receiver);
    }
}

