/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.mediacontainer.epub;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.gotson.komga.domain.model.EpubTocEntry;
import org.gotson.komga.infrastructure.mediacontainer.epub.Epub2Nav;
import org.gotson.komga.infrastructure.mediacontainer.epub.EpubPackage;
import org.gotson.komga.infrastructure.mediacontainer.epub.ManifestItem;
import org.gotson.komga.infrastructure.mediacontainer.epub.OpfKt;
import org.gotson.komga.infrastructure.mediacontainer.epub.ResourceContent;
import org.gotson.komga.infrastructure.util.ZipFileUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.web.util.UriUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002\u001a\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\r*\u00020\u000f\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"possibleNcxItemIds", "", "", "ncxElementToTocEntry", "Lorg/gotson/komga/domain/model/EpubTocEntry;", "navType", "Lorg/gotson/komga/infrastructure/mediacontainer/epub/Epub2Nav;", "element", "Lorg/jsoup/nodes/Element;", "ncxDir", "Ljava/nio/file/Path;", "processNcx", "document", "Lorg/gotson/komga/infrastructure/mediacontainer/epub/ResourceContent;", "getNcxResource", "Lorg/gotson/komga/infrastructure/mediacontainer/epub/EpubPackage;", "komga"})
@SourceDebugExtension(value={"SMAP\nNcx.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Ncx.kt\norg/gotson/komga/infrastructure/mediacontainer/epub/NcxKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,40:1\n288#2,2:41\n1603#2,9:43\n1855#2:52\n1856#2:54\n1612#2:55\n1603#2,9:57\n1855#2:66\n1856#2:68\n1612#2:69\n1#3:53\n1#3:56\n1#3:67\n*S KotlinDebug\n*F\n+ 1 Ncx.kt\norg/gotson/komga/infrastructure/mediacontainer/epub/NcxKt\n*L\n14#1:41,2\n27#1:43,9\n27#1:52\n27#1:54\n27#1:55\n36#1:57,9\n36#1:66\n36#1:68\n36#1:69\n27#1:53\n36#1:67\n*E\n"})
public final class NcxKt {
    @NotNull
    private static final List<String> possibleNcxItemIds;

    @Nullable
    public static final ResourceContent getNcxResource(@NotNull EpubPackage $this$getNcxResource) {
        ResourceContent resourceContent;
        ManifestItem manifestItem;
        Object v0;
        ManifestItem it;
        boolean $i$f$firstOrNull;
        Iterable $this$firstOrNull$iv;
        block5: {
            Intrinsics.checkNotNullParameter((Object)$this$getNcxResource, (String)"<this>");
            $this$firstOrNull$iv = $this$getNcxResource.getManifest().values();
            $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (ManifestItem)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getMediaType(), (Object)"application/x-dtbncx+xml")) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        if ((manifestItem = (ManifestItem)v0) == null) {
            Object v2;
            block6: {
                $this$firstOrNull$iv = $this$getNcxResource.getManifest().values();
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (ManifestItem)element$iv;
                    boolean bl = false;
                    if (!possibleNcxItemIds.contains(it.getId())) continue;
                    v2 = element$iv;
                    break block6;
                }
                v2 = null;
            }
            manifestItem = v2;
        }
        if (manifestItem != null) {
            ManifestItem ncx = manifestItem;
            boolean bl = false;
            String href = OpfKt.normalizeHref((Path)$this$getNcxResource.getOpfDir(), (String)ncx.getHref());
            Path path2 = Paths.get(href, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            resourceContent = new ResourceContent(path2, StringsKt.decodeToString((byte[])ZipFileUtilsKt.getEntryBytes((ZipFile)$this$getNcxResource.getZip(), (String)href)));
        } else {
            resourceContent = null;
        }
        return resourceContent;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<EpubTocEntry> processNcx(@NotNull ResourceContent document, @NotNull Epub2Nav navType) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)navType, (String)"navType");
        Elements elements = Jsoup.parse((String)document.getContent()).select(navType.getLevel1() + " > " + navType.getLevel2());
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
        Iterable $this$mapNotNull$iv = CollectionsKt.toList((Iterable)((Iterable)elements));
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            EpubTocEntry it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Element it = (Element)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if (NcxKt.ncxElementToTocEntry((Epub2Nav)navType, (Element)it, (Path)document.getPath().getParent()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final EpubTocEntry ncxElementToTocEntry(Epub2Nav navType, Element element, Path ncxDir) {
        void $this$mapNotNullTo$iv$iv;
        String string;
        Object it;
        Element element2 = element.selectFirst("navLabel > text");
        String title = element2 != null ? element2.text() : null;
        Object object = element.selectFirst("content");
        if (object != null && (object = object.attr("src")) != null) {
            it = object;
            boolean bl = false;
            string = UriUtils.decode((String)it, (Charset)Charsets.UTF_8);
        } else {
            string = null;
        }
        String href = string;
        Elements elements = element.select(":root > " + navType.getLevel2());
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
        Iterable $this$mapNotNull$iv = CollectionsKt.toList((Iterable)((Iterable)elements));
        boolean $i$f$mapNotNull2 = false;
        it = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            EpubTocEntry it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Element it2 = (Element)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it2);
            if (NcxKt.ncxElementToTocEntry((Epub2Nav)navType, (Element)it2, (Path)ncxDir) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List children = (List)destination$iv$iv;
        String string2 = title;
        if (string2 != null) {
            String string3;
            String string4 = href;
            if (string4 != null) {
                void it3;
                String $i$f$mapNotNull2 = string4;
                String string5 = string2;
                boolean bl = false;
                string3 = OpfKt.normalizeHref((Path)ncxDir, (String)it3);
                string2 = string5;
            } else {
                string3 = null;
            }
            List list = children;
            String string6 = string3;
            String string7 = string2;
            return new EpubTocEntry(string7, string6, list);
        }
        return null;
    }

    static {
        Object[] objectArray = new String[]{"toc", "ncx", "ncxtoc"};
        possibleNcxItemIds = CollectionsKt.listOf((Object[])objectArray);
    }
}

