/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.metadata.comicrack;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.net.URI;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.validator.routines.ISBNValidator;
import org.gotson.komga.domain.model.Author;
import org.gotson.komga.domain.model.BCP47TagValidator;
import org.gotson.komga.domain.model.BookMetadataPatch;
import org.gotson.komga.domain.model.BookMetadataPatchCapability;
import org.gotson.komga.domain.model.BookWithMedia;
import org.gotson.komga.domain.model.Library;
import org.gotson.komga.domain.model.MediaFile;
import org.gotson.komga.domain.model.MetadataPatchTarget;
import org.gotson.komga.domain.model.SeriesMetadata;
import org.gotson.komga.domain.model.SeriesMetadataPatch;
import org.gotson.komga.domain.model.WebLink;
import org.gotson.komga.domain.service.BookAnalyzer;
import org.gotson.komga.infrastructure.metadata.BookMetadataProvider;
import org.gotson.komga.infrastructure.metadata.SeriesMetadataFromBookProvider;
import org.gotson.komga.infrastructure.metadata.comicrack.ComicInfoProvider;
import org.gotson.komga.infrastructure.metadata.comicrack.ComicInfoProviderKt;
import org.gotson.komga.infrastructure.metadata.comicrack.dto.ComicInfo;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\b\b\u0003\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0012J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0010H\u0016J\u0018\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001c\u0010!\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\"*\u00020$2\u0006\u0010%\u001a\u00020$H\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006&"}, d2={"Lorg/gotson/komga/infrastructure/metadata/comicrack/ComicInfoProvider;", "Lorg/gotson/komga/infrastructure/metadata/BookMetadataProvider;", "Lorg/gotson/komga/infrastructure/metadata/SeriesMetadataFromBookProvider;", "mapper", "Lcom/fasterxml/jackson/dataformat/xml/XmlMapper;", "bookAnalyzer", "Lorg/gotson/komga/domain/service/BookAnalyzer;", "isbnValidator", "Lorg/apache/commons/validator/routines/ISBNValidator;", "(Lcom/fasterxml/jackson/dataformat/xml/XmlMapper;Lorg/gotson/komga/domain/service/BookAnalyzer;Lorg/apache/commons/validator/routines/ISBNValidator;)V", "capabilities", "", "Lorg/gotson/komga/domain/model/BookMetadataPatchCapability;", "getCapabilities", "()Ljava/util/Set;", "supportsAppendVolume", "", "getSupportsAppendVolume", "()Z", "getBookMetadataFromBook", "Lorg/gotson/komga/domain/model/BookMetadataPatch;", "book", "Lorg/gotson/komga/domain/model/BookWithMedia;", "getComicInfo", "Lorg/gotson/komga/infrastructure/metadata/comicrack/dto/ComicInfo;", "getSeriesMetadataFromBook", "Lorg/gotson/komga/domain/model/SeriesMetadataPatch;", "appendVolumeToTitle", "shouldLibraryHandlePatch", "library", "Lorg/gotson/komga/domain/model/Library;", "target", "Lorg/gotson/komga/domain/model/MetadataPatchTarget;", "splitWithRole", "", "Lorg/gotson/komga/domain/model/Author;", "", "role", "komga"})
@SourceDebugExtension(value={"SMAP\nComicInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComicInfoProvider.kt\norg/gotson/komga/infrastructure/metadata/comicrack/ComicInfoProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,203:1\n1#2:204\n1#2:232\n1#2:245\n1#2:258\n1#2:271\n1#2:287\n1549#3:205\n1620#3,3:206\n1549#3:209\n1620#3,3:210\n1855#3,2:213\n1549#3:215\n1620#3,3:216\n766#3:219\n857#3,2:220\n1603#3,9:222\n1855#3:231\n1856#3:233\n1612#3:234\n1603#3,9:235\n1855#3:244\n1856#3:246\n1612#3:247\n1603#3,9:248\n1855#3:257\n1856#3:259\n1612#3:260\n1603#3,9:261\n1855#3:270\n1856#3:272\n1612#3:273\n2624#3,3:274\n1603#3,9:277\n1855#3:286\n1856#3:288\n1612#3:289\n1549#3:290\n1620#3,3:291\n*S KotlinDebug\n*F\n+ 1 ComicInfoProvider.kt\norg/gotson/komga/infrastructure/metadata/comicrack/ComicInfoProvider\n*L\n97#1:232\n106#1:245\n140#1:258\n157#1:271\n191#1:287\n79#1:205\n79#1:206,3\n80#1:209\n80#1:210,3\n84#1:213,2\n89#1:215\n89#1:216,3\n96#1:219\n96#1:220,2\n97#1:222,9\n97#1:231\n97#1:233\n97#1:234\n106#1:235,9\n106#1:244\n106#1:246\n106#1:247\n140#1:248,9\n140#1:257\n140#1:259\n140#1:260\n157#1:261,9\n157#1:270\n157#1:272\n157#1:273\n177#1:274,3\n191#1:277,9\n191#1:286\n191#1:288\n191#1:289\n192#1:290\n192#1:291,3\n*E\n"})
public class ComicInfoProvider
implements BookMetadataProvider,
SeriesMetadataFromBookProvider {
    @NotNull
    private final XmlMapper mapper;
    @NotNull
    private final BookAnalyzer bookAnalyzer;
    @NotNull
    private final ISBNValidator isbnValidator;
    @NotNull
    private final Set<BookMetadataPatchCapability> capabilities;
    private final boolean supportsAppendVolume;

    public ComicInfoProvider(@Autowired(required=false) @NotNull XmlMapper mapper, @NotNull BookAnalyzer bookAnalyzer, @NotNull ISBNValidator isbnValidator) {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)bookAnalyzer, (String)"bookAnalyzer");
        Intrinsics.checkNotNullParameter((Object)isbnValidator, (String)"isbnValidator");
        this.mapper = mapper;
        this.bookAnalyzer = bookAnalyzer;
        this.isbnValidator = isbnValidator;
        Object[] objectArray = new BookMetadataPatchCapability[]{BookMetadataPatchCapability.TITLE, BookMetadataPatchCapability.SUMMARY, BookMetadataPatchCapability.NUMBER, BookMetadataPatchCapability.NUMBER_SORT, BookMetadataPatchCapability.RELEASE_DATE, BookMetadataPatchCapability.AUTHORS, BookMetadataPatchCapability.READ_LISTS, BookMetadataPatchCapability.LINKS};
        this.capabilities = SetsKt.setOf((Object[])objectArray);
        this.supportsAppendVolume = true;
    }

    public /* synthetic */ ComicInfoProvider(XmlMapper xmlMapper, BookAnalyzer bookAnalyzer, ISBNValidator iSBNValidator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            xmlMapper = new XmlMapper();
        }
        this(xmlMapper, bookAnalyzer, iSBNValidator);
    }

    @NotNull
    public Set<BookMetadataPatchCapability> getCapabilities() {
        return this.capabilities;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public BookMetadataPatch getBookMetadataFromBook(@NotNull BookWithMedia book) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        ComicInfo comicInfo = this.getComicInfo(book);
        if (comicInfo != null) {
            List list;
            Collection collection;
            String string;
            String string2;
            String string3;
            String string4;
            List list2;
            Object object;
            List links2;
            Object $this$mapNotNull$iv;
            String[] stringArray;
            Iterable numbers;
            Object destination$iv$iv;
            String[] stringArray2;
            Object value;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            Object it;
            LocalDate localDate;
            ComicInfo comicInfo2 = comicInfo;
            boolean bl = false;
            Integer n = comicInfo2.getYear();
            if (n != null) {
                int it2 = ((Number)n).intValue();
                boolean bl2 = false;
                Integer n2 = comicInfo2.getYear();
                Intrinsics.checkNotNull((Object)n2);
                Integer n3 = comicInfo2.getMonth();
                Integer n4 = comicInfo2.getDay();
                localDate = LocalDate.of((int)n2, n3 != null ? n3 : 1, n4 != null ? n4 : 1);
            } else {
                localDate = null;
            }
            LocalDate releaseDate = localDate;
            List authors = new ArrayList();
            Object object9 = comicInfo2.getWriter();
            if (object9 != null && (object9 = this.splitWithRole((String)object9, "writer")) != null) {
                it = object9;
                boolean bl3 = false;
                CollectionsKt.addAll((Collection)authors, (Iterable)((Iterable)it));
            }
            if ((object8 = comicInfo2.getPenciller()) != null && (object8 = this.splitWithRole((String)object8, "penciller")) != null) {
                it = object8;
                boolean bl4 = false;
                CollectionsKt.addAll((Collection)authors, (Iterable)((Iterable)it));
            }
            if ((object7 = comicInfo2.getInker()) != null && (object7 = this.splitWithRole((String)object7, "inker")) != null) {
                it = object7;
                boolean bl5 = false;
                CollectionsKt.addAll((Collection)authors, (Iterable)((Iterable)it));
            }
            if ((object6 = comicInfo2.getColorist()) != null && (object6 = this.splitWithRole((String)object6, "colorist")) != null) {
                it = object6;
                boolean bl6 = false;
                CollectionsKt.addAll((Collection)authors, (Iterable)((Iterable)it));
            }
            if ((object5 = comicInfo2.getLetterer()) != null && (object5 = this.splitWithRole((String)object5, "letterer")) != null) {
                it = object5;
                boolean bl7 = false;
                CollectionsKt.addAll((Collection)authors, (Iterable)((Iterable)it));
            }
            if ((object4 = comicInfo2.getCoverArtist()) != null && (object4 = this.splitWithRole((String)object4, "cover")) != null) {
                it = object4;
                boolean bl8 = false;
                CollectionsKt.addAll((Collection)authors, (Iterable)((Iterable)it));
            }
            if ((object3 = comicInfo2.getEditor()) != null && (object3 = this.splitWithRole((String)object3, "editor")) != null) {
                it = object3;
                boolean bl9 = false;
                CollectionsKt.addAll((Collection)authors, (Iterable)((Iterable)it));
            }
            if ((object2 = comicInfo2.getTranslator()) != null && (object2 = this.splitWithRole((String)object2, "translator")) != null) {
                it = object2;
                boolean bl10 = false;
                CollectionsKt.addAll((Collection)authors, (Iterable)((Iterable)it));
            }
            List readLists = new ArrayList();
            CharSequence it2 = comicInfo2.getAlternateSeries();
            if (!(it2 == null || StringsKt.isBlank((CharSequence)it2))) {
                String string5 = comicInfo2.getAlternateSeries();
                Intrinsics.checkNotNull((Object)string5);
                String string6 = comicInfo2.getAlternateNumber();
                readLists.add(new BookMetadataPatch.ReadListEntry(string5, string6 != null ? StringsKt.toIntOrNull((String)string6) : null));
            }
            String string7 = comicInfo2.getStoryArc();
            if (string7 != null) {
                List list3;
                Pair $this$mapTo$iv$iv;
                Object $this$map$iv;
                Object object10;
                void $this$mapTo$iv$iv2;
                value = string7;
                boolean bl11 = false;
                stringArray2 = new String[]{","};
                Iterable $this$map$iv2 = StringsKt.split$default((CharSequence)((CharSequence)value), (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$map22 = false;
                Iterable iterable = $this$map$iv2;
                destination$iv$iv = (String[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    CharSequence charSequence;
                    void it3;
                    String string8 = (String)item$iv$iv;
                    object10 = destination$iv$iv;
                    boolean bl12 = false;
                    CharSequence charSequence2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)it3))).toString();
                    if (StringsKt.isBlank((CharSequence)charSequence2)) {
                        boolean bl13 = false;
                        charSequence = null;
                    } else {
                        charSequence = charSequence2;
                    }
                    object10.add((String)charSequence);
                }
                List arcs = (List)destination$iv$iv;
                Object object11 = comicInfo2.getStoryArcNumber();
                if (object11 != null && (object11 = StringsKt.split$default((CharSequence)((CharSequence)object11), (String[])(destination$iv$iv = new String[]{","}), (boolean)false, (int)0, (int)6, null)) != null) {
                    $this$map$iv = (Iterable)object11;
                    boolean $i$f$map = false;
                    Object object12 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it4;
                        String bl13 = (String)item$iv$iv;
                        object10 = destination$iv$iv2;
                        boolean bl14 = false;
                        object10.add(StringsKt.toIntOrNull((String)((Object)StringsKt.trim((CharSequence)((CharSequence)it4))).toString()));
                    }
                    list3 = (List)destination$iv$iv2;
                } else {
                    list3 = null;
                }
                numbers = list3;
                Collection $i$f$map22 = (Collection)numbers;
                if (!($i$f$map22 == null || $i$f$map22.isEmpty())) {
                    $this$forEach$iv = CollectionsKt.zip((Iterable)arcs, (Iterable)numbers);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        $this$mapTo$iv$iv = (Pair)element$iv;
                        boolean bl15 = false;
                        String arc = (String)$this$mapTo$iv$iv.component1();
                        Integer number = (Integer)$this$mapTo$iv$iv.component2();
                        if (arc == null || number == null) continue;
                        readLists.add(new BookMetadataPatch.ReadListEntry(arc, number));
                    }
                } else {
                    void $this$mapTo$iv$iv3;
                    void $this$map$iv3;
                    $this$forEach$iv = CollectionsKt.filterNotNull((Iterable)arcs);
                    object10 = readLists;
                    boolean $i$f$map = false;
                    $this$map$iv = $this$map$iv3;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                    boolean $i$f$mapTo3 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                        void it5;
                        String number = (String)item$iv$iv;
                        Collection collection2 = destination$iv$iv3;
                        boolean bl16 = false;
                        collection2.add(new BookMetadataPatch.ReadListEntry((String)it5, null, 2, null));
                    }
                    object10.addAll((List)destination$iv$iv3);
                }
            }
            String bl2 = comicInfo2.getWeb();
            if (bl2 != null && (value = StringsKt.split$default((CharSequence)bl2, (String[])(stringArray = new String[]{" "}), (boolean)false, (int)0, (int)6, null)) != null) {
                void $this$mapNotNullTo$iv$iv;
                char[] $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                numbers = (Iterable)value;
                boolean $i$f$filter = false;
                void $i$f$map = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator $i$f$mapTo3 = $this$filterTo$iv$iv.iterator();
                while ($i$f$mapTo3.hasNext()) {
                    Object element$iv$iv = $i$f$mapTo3.next();
                    String it6 = (String)element$iv$iv;
                    boolean bl17 = false;
                    boolean bl18 = !StringsKt.isBlank((CharSequence)it6);
                    if (!bl18) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                $this$filterTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    WebLink it$iv$iv;
                    WebLink webLink;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl19 = false;
                    String it7 = (String)element$iv$iv;
                    boolean bl20 = false;
                    try {
                        URI uri = new URI(((Object)StringsKt.trim((CharSequence)it7)).toString());
                        boolean bl21 = false;
                        String string9 = uri.getHost();
                        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getHost(...)");
                        webLink = new WebLink(string9, uri);
                    }
                    catch (Exception e) {
                        ComicInfoProviderKt.access$getLogger$p().error((Throwable)e, (Function0)new /* Unavailable Anonymous Inner Class!! */);
                        webLink = null;
                    }
                    if (webLink == null) continue;
                    boolean bl22 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                v21 = (List)destination$iv$iv;
            } else {
                v21 = links2 = null;
            }
            if ((object = comicInfo2.getTags()) != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (char[])($this$mapNotNull$iv = (Object)new char[]{','}), (boolean)false, (int)0, (int)6, null)) != null) {
                $this$mapNotNull$iv = (Iterable)object;
                boolean $i$f$mapNotNull = false;
                char[] $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                char[] $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String it$iv$iv;
                    CharSequence charSequence;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl23 = false;
                    String it8 = (String)element$iv$iv;
                    boolean bl24 = false;
                    String string10 = ((Object)StringsKt.trim((CharSequence)it8)).toString().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"toLowerCase(...)");
                    CharSequence charSequence3 = string10;
                    if (StringsKt.isBlank((CharSequence)charSequence3)) {
                        boolean bl25 = false;
                        charSequence = null;
                    } else {
                        charSequence = charSequence3;
                    }
                    if ((String)charSequence == null) continue;
                    boolean bl26 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = null;
            }
            List tags = list2;
            String string11 = comicInfo2.getGtin();
            if (string11 != null) {
                String it9 = string11;
                boolean bl27 = false;
                string4 = this.isbnValidator.validate(it9);
            } else {
                string4 = null;
            }
            String isbn = string4;
            String string12 = comicInfo2.getTitle();
            if (string12 != null) {
                CharSequence charSequence;
                CharSequence charSequence4 = string12;
                if (StringsKt.isBlank((CharSequence)charSequence4)) {
                    boolean bl28 = false;
                    charSequence = null;
                } else {
                    charSequence = charSequence4;
                }
                string3 = (String)charSequence;
            } else {
                string3 = null;
            }
            String string13 = string3;
            String string14 = comicInfo2.getSummary();
            if (string14 != null) {
                CharSequence charSequence;
                CharSequence charSequence5 = string14;
                if (StringsKt.isBlank((CharSequence)charSequence5)) {
                    boolean bl29 = false;
                    charSequence = null;
                } else {
                    charSequence = charSequence5;
                }
                string2 = (String)charSequence;
            } else {
                string2 = null;
            }
            stringArray2 = string2;
            String string15 = comicInfo2.getNumber();
            if (string15 != null) {
                CharSequence charSequence;
                CharSequence charSequence6 = string15;
                if (StringsKt.isBlank((CharSequence)charSequence6)) {
                    boolean bl30 = false;
                    charSequence = null;
                } else {
                    charSequence = charSequence6;
                }
                string = (String)charSequence;
            } else {
                string = null;
            }
            String string16 = string;
            String string17 = comicInfo2.getNumber();
            Float f = string17 != null ? StringsKt.toFloatOrNull((String)string17) : null;
            Collection collection3 = authors;
            if (collection3.isEmpty()) {
                boolean bl31 = false;
                collection = null;
            } else {
                collection = collection3;
            }
            List list4 = (List)collection;
            List list5 = links2;
            if (list5 != null) {
                Collection collection4;
                Collection collection5 = list5;
                if (collection5.isEmpty()) {
                    boolean bl32 = false;
                    collection4 = null;
                } else {
                    collection4 = collection5;
                }
                list = (List)collection4;
            } else {
                list = null;
            }
            collection3 = list;
            Collection collection6 = tags;
            Set set = !(collection6 == null || collection6.isEmpty()) ? CollectionsKt.toSet((Iterable)tags) : null;
            return new BookMetadataPatch(string13, (String)stringArray2, string16, f, releaseDate, list4, isbn, (List)collection3, set, readLists);
        }
        return null;
    }

    public boolean getSupportsAppendVolume() {
        return this.supportsAppendVolume;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public SeriesMetadataPatch getSeriesMetadataFromBook(@NotNull BookWithMedia book, boolean appendVolumeToTitle) {
        block20: {
            Intrinsics.checkNotNullParameter((Object)book, (String)"book");
            var3_3 = this.getComicInfo(book);
            if (var3_3 == null) break block20;
            comicInfo = var3_3;
            $i$a$-let-ComicInfoProvider$getSeriesMetadataFromBook$1 = false;
            v0 = comicInfo.getManga();
            switch (v0 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
                case 1: {
                    v1 = SeriesMetadata.ReadingDirection.LEFT_TO_RIGHT;
                    break;
                }
                case 2: {
                    v1 = SeriesMetadata.ReadingDirection.RIGHT_TO_LEFT;
                    break;
                }
                default: {
                    v1 = readingDirection = null;
                }
            }
            if ((v2 = comicInfo.getGenre()) != null && (v2 = StringsKt.split$default((CharSequence)((CharSequence)v2), (char[])(var7_7 /* !! */  = new char[]{','}), (boolean)false, (int)0, (int)6, null)) != null) {
                $this$mapNotNull$iv = (Iterable)v2;
                $i$f$mapNotNull = false;
                var9_10 = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                var14_17 = $this$forEach$iv$iv$iv.iterator();
                while (var14_17.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = var14_17.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    it = (String)element$iv$iv;
                    $i$a$-mapNotNull-ComicInfoProvider$getSeriesMetadataFromBook$1$genres$1 = false;
                    var20_25 = StringsKt.trim((CharSequence)it).toString();
                    if (StringsKt.isBlank((CharSequence)var20_25)) {
                        $i$a$-ifBlank-ComicInfoProvider$getSeriesMetadataFromBook$1$genres$1$1 = false;
                        v3 = null;
                    } else {
                        v3 = var20_25;
                    }
                    if ((String)v3 == null) continue;
                    $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                v4 = (List)destination$iv$iv;
            } else {
                v4 = null;
            }
            genres = v4;
            v5 = series = appendVolumeToTitle != false ? ComicInfoProviderKt.computeSeriesFromSeriesAndVolume((String)comicInfo.getSeries(), (Integer)comicInfo.getVolume()) : comicInfo.getSeries();
            v6 = series;
            v7 = v6 != null ? LanguageUtilsKt.stripAccents((String)v6) : null;
            v8 = null;
            v9 = null;
            v10 = readingDirection;
            v11 = comicInfo.getPublisher();
            if (v11 != null) {
                var7_7 /* !! */  = (char[])v11;
                if (StringsKt.isBlank((CharSequence)var7_7 /* !! */ )) {
                    var26_31 = v10;
                    var27_32 = v9;
                    var28_33 = v8;
                    var29_34 = v7;
                    var30_35 = v5;
                    $i$a$-ifBlank-ComicInfoProvider$getSeriesMetadataFromBook$1$1 = false;
                    var31_36 = null;
                    v5 = var30_35;
                    v7 = var29_34;
                    v8 = var28_33;
                    v9 = var27_32;
                    v10 = var26_31;
                    v12 /* !! */  = var31_36;
                } else {
                    v12 /* !! */  = var7_7 /* !! */ ;
                }
                v13 = (String)v12 /* !! */ ;
            } else {
                v13 = null;
            }
            v14 = comicInfo.getAgeRating();
            v15 = v14 != null ? v14.getAgeRating() : null;
            if (comicInfo.getLanguageISO() == null) ** GOTO lbl-1000
            v16 = comicInfo.getLanguageISO();
            Intrinsics.checkNotNull((Object)v16);
            if (BCP47TagValidator.INSTANCE.isValid(v16)) {
                v17 = comicInfo.getLanguageISO();
                Intrinsics.checkNotNull((Object)v17);
                v18 = BCP47TagValidator.INSTANCE.normalize(v17);
            } else lbl-1000:
            // 2 sources

            {
                v18 = null;
            }
            var32_37 = genres;
            v19 = (var32_37 == null || var32_37.isEmpty() != false) == false ? CollectionsKt.toSet((Iterable)genres) : null;
            v20 = comicInfo.getCount();
            var32_37 = comicInfo.getSeriesGroup();
            if (var32_37 == null || (var7_7 /* !! */  = (char[])StringsKt.split$default((CharSequence)((CharSequence)var32_37), (char[])(var8_9 = new char[]{','}), (boolean)false, (int)0, (int)6, null)) == null) ** GOTO lbl-1000
            $this$mapNotNullTo$iv$iv = (Iterable)var7_7 /* !! */ ;
            var33_38 = v20;
            var34_39 = v19;
            var35_40 = v18;
            var36_41 = v15;
            var31_36 = v13;
            var26_31 = v10;
            var27_32 = v9;
            var28_33 = v8;
            var29_34 = v7;
            var30_35 = v5;
            $i$f$mapNotNull = false;
            $i$f$mapNotNullTo = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            var16_20 = $this$forEach$iv$iv$iv.iterator();
            while (var16_20.hasNext()) {
                element$iv$iv = element$iv$iv$iv = var16_20.next();
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                it = (String)element$iv$iv;
                $i$a$-mapNotNull-ComicInfoProvider$getSeriesMetadataFromBook$1$2 = false;
                var22_27 = StringsKt.trim((CharSequence)it).toString();
                if (StringsKt.isBlank((CharSequence)var22_27)) {
                    $i$a$-ifBlank-ComicInfoProvider$getSeriesMetadataFromBook$1$2$1 = false;
                    v21 = null;
                } else {
                    v21 = var22_27;
                }
                if ((String)v21 == null) continue;
                $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            var39_44 = (List)destination$iv$iv;
            v5 = var30_35;
            v7 = var29_34;
            v8 = var28_33;
            v9 = var27_32;
            v10 = var26_31;
            v13 = var31_36;
            v15 = var36_41;
            v18 = var35_40;
            v19 = var34_39;
            v20 = var33_38;
            var9_10 = CollectionsKt.toSet((Iterable)var39_44);
            if (var9_10 != null) {
                v22 /* !! */  = var9_10;
            } else lbl-1000:
            // 2 sources

            {
                v22 /* !! */  = SetsKt.emptySet();
            }
            var40_45 = v22 /* !! */ ;
            var41_46 = v20;
            var42_47 = v19;
            var43_48 = v18;
            var44_49 = v15;
            var45_50 = v13;
            var46_51 = v10;
            var47_52 = v9;
            var48_53 = v8;
            var49_54 = v7;
            var50_55 = v5;
            return new SeriesMetadataPatch(var50_55, var49_54, var48_53, var47_52, var46_51, var45_50, var44_49, var43_48, var42_47, var41_46, var40_45);
        }
        return null;
    }

    public boolean shouldLibraryHandlePatch(@NotNull Library library, @NotNull MetadataPatchTarget target) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return switch (WhenMappings.$EnumSwitchMapping$1[target.ordinal()]) {
            case 1 -> library.getImportComicInfoBook();
            case 2 -> library.getImportComicInfoSeries();
            case 3 -> library.getImportComicInfoReadList();
            case 4 -> library.getImportComicInfoCollection();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private ComicInfo getComicInfo(BookWithMedia book) {
        try {
            boolean bl;
            block6: {
                Iterable $this$none$iv = book.getMedia().getFiles();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        MediaFile it = (MediaFile)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getFileName(), (Object)"ComicInfo.xml")) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (bl) {
                ComicInfoProviderKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
                return null;
            }
            byte[] fileContent = this.bookAnalyzer.getFileContent(book, "ComicInfo.xml");
            return (ComicInfo)this.mapper.readValue(fileContent, ComicInfo.class);
        }
        catch (Exception e) {
            ComicInfoProviderKt.access$getLogger$p().error((Throwable)e, (Function0)getComicInfo.3.INSTANCE);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<Author> splitWithRole(String $this$splitWithRole, String role) {
        List list;
        void $this$mapNotNullTo$iv$iv;
        char[] cArray = new char[]{','};
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)$this$splitWithRole, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            CharSequence charSequence;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl5 = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            CharSequence charSequence2 = ((Object)StringsKt.trim((CharSequence)it)).toString();
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                boolean bl3 = false;
                charSequence = null;
            } else {
                charSequence = charSequence2;
            }
            if ((String)charSequence == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        boolean bl = false;
        if (!((Collection)list2).isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            $this$forEach$iv$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String bl5 = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl6 = false;
                collection.add(new Author((String)it, role));
            }
            list = (List)destination$iv$iv2;
        } else {
            list = null;
        }
        return list;
    }
}

