/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.metadata.epub;

import java.nio.file.Path;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.commons.validator.routines.ISBNValidator;
import org.gotson.komga.domain.model.Author;
import org.gotson.komga.domain.model.BCP47TagValidator;
import org.gotson.komga.domain.model.BookMetadataPatch;
import org.gotson.komga.domain.model.BookMetadataPatchCapability;
import org.gotson.komga.domain.model.BookWithMedia;
import org.gotson.komga.domain.model.Library;
import org.gotson.komga.domain.model.MediaType;
import org.gotson.komga.domain.model.MetadataPatchTarget;
import org.gotson.komga.domain.model.SeriesMetadata;
import org.gotson.komga.domain.model.SeriesMetadataPatch;
import org.gotson.komga.infrastructure.mediacontainer.epub.EpubKt;
import org.gotson.komga.infrastructure.metadata.BookMetadataProvider;
import org.gotson.komga.infrastructure.metadata.SeriesMetadataFromBookProvider;
import org.gotson.komga.infrastructure.metadata.epub.EpubMetadataProvider;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.safety.Safelist;
import org.jsoup.select.Elements;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u000fH\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\rH\u0012J\u0018\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Lorg/gotson/komga/infrastructure/metadata/epub/EpubMetadataProvider;", "Lorg/gotson/komga/infrastructure/metadata/BookMetadataProvider;", "Lorg/gotson/komga/infrastructure/metadata/SeriesMetadataFromBookProvider;", "isbnValidator", "Lorg/apache/commons/validator/routines/ISBNValidator;", "(Lorg/apache/commons/validator/routines/ISBNValidator;)V", "capabilities", "", "Lorg/gotson/komga/domain/model/BookMetadataPatchCapability;", "getCapabilities", "()Ljava/util/Set;", "relators", "", "", "supportsAppendVolume", "", "getSupportsAppendVolume", "()Z", "getBookMetadataFromBook", "Lorg/gotson/komga/domain/model/BookMetadataPatch;", "book", "Lorg/gotson/komga/domain/model/BookWithMedia;", "getSeriesMetadataFromBook", "Lorg/gotson/komga/domain/model/SeriesMetadataPatch;", "appendVolumeToTitle", "parseDate", "Ljava/time/LocalDate;", "date", "shouldLibraryHandlePatch", "library", "Lorg/gotson/komga/domain/model/Library;", "target", "Lorg/gotson/komga/domain/model/MetadataPatchTarget;", "komga"})
@SourceDebugExtension(value={"SMAP\nEpubMetadataProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EpubMetadataProvider.kt\norg/gotson/komga/infrastructure/metadata/epub/EpubMetadataProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,181:1\n1#2:182\n1#2:199\n1#2:216\n1179#3,2:183\n1253#3,4:185\n1603#3,9:189\n1855#3:198\n1856#3:200\n1612#3:201\n1549#3:202\n1620#3,3:203\n1603#3,9:206\n1855#3:215\n1856#3:217\n1612#3:218\n*S KotlinDebug\n*F\n+ 1 EpubMetadataProvider.kt\norg/gotson/komga/infrastructure/metadata/epub/EpubMetadataProvider\n*L\n71#1:199\n126#1:216\n67#1:183,2\n67#1:185,4\n71#1:189,9\n71#1:198\n71#1:200\n71#1:201\n86#1:202\n86#1:203,3\n126#1:206,9\n126#1:215\n126#1:217\n126#1:218\n*E\n"})
public class EpubMetadataProvider
implements BookMetadataProvider,
SeriesMetadataFromBookProvider {
    @NotNull
    private final ISBNValidator isbnValidator;
    @NotNull
    private final Map<String, String> relators;
    @NotNull
    private final Set<BookMetadataPatchCapability> capabilities;
    private final boolean supportsAppendVolume;

    public EpubMetadataProvider(@NotNull ISBNValidator isbnValidator) {
        Intrinsics.checkNotNullParameter((Object)isbnValidator, (String)"isbnValidator");
        this.isbnValidator = isbnValidator;
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"aut", (Object)"writer"), TuplesKt.to((Object)"clr", (Object)"colorist"), TuplesKt.to((Object)"cov", (Object)"cover"), TuplesKt.to((Object)"edt", (Object)"editor"), TuplesKt.to((Object)"art", (Object)"penciller"), TuplesKt.to((Object)"ill", (Object)"penciller"), TuplesKt.to((Object)"trl", (Object)"translator")};
        this.relators = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new BookMetadataPatchCapability[]{BookMetadataPatchCapability.TITLE, BookMetadataPatchCapability.SUMMARY, BookMetadataPatchCapability.RELEASE_DATE, BookMetadataPatchCapability.AUTHORS, BookMetadataPatchCapability.ISBN};
        this.capabilities = SetsKt.setOf((Object[])objectArray);
    }

    @NotNull
    public Set<BookMetadataPatchCapability> getCapabilities() {
        return this.capabilities;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public BookMetadataPatch getBookMetadataFromBook(@NotNull BookWithMedia book) {
        block36: {
            block35: {
                Intrinsics.checkNotNullParameter((Object)book, (String)"book");
                if (!Intrinsics.areEqual((Object)book.getMedia().getMediaType(), (Object)MediaType.EPUB.getType())) {
                    return null;
                }
                var2_2 = EpubKt.getPackageFileContent((Path)book.getBook().getPath());
                if (var2_2 == null) break block36;
                packageFile = var2_2;
                $i$a$-let-EpubMetadataProvider$getBookMetadataFromBook$1 = false;
                opf = Jsoup.parse((String)packageFile, (String)"", (Parser)Parser.xmlParser());
                v0 /* !! */  = opf.selectFirst("metadata > dc|title");
                if (v0 /* !! */  != null && (v0 /* !! */  = (var6_6 = v0 /* !! */ .text())) != null) {
                    Intrinsics.checkNotNull((Object)v0 /* !! */ );
                    var7_7 = var6_6;
                    if (StringsKt.isBlank((CharSequence)var7_7)) {
                        $i$a$-ifBlank-EpubMetadataProvider$getBookMetadataFromBook$1$title$1 = false;
                        v1 = null;
                    } else {
                        v1 = var7_7;
                    }
                    v2 = (String)v1;
                } else {
                    v2 = null;
                }
                title = v2;
                var6_6 = opf.selectFirst("metadata > dc|description");
                if (var6_6 == null || (var7_7 = var6_6.text()) == null) ** GOTO lbl-1000
                it = var7_7;
                $i$a$-let-EpubMetadataProvider$getBookMetadataFromBook$1$description$1 = false;
                $i$a$-ifBlank-EpubMetadataProvider$getBookMetadataFromBook$1$title$1 = Jsoup.clean((String)it, (Safelist)Safelist.none());
                if ($i$a$-ifBlank-EpubMetadataProvider$getBookMetadataFromBook$1$title$1 != null) {
                    var12_22 = $i$a$-ifBlank-EpubMetadataProvider$getBookMetadataFromBook$1$title$1;
                    if (StringsKt.isBlank((CharSequence)var12_22)) {
                        $i$a$-ifBlank-EpubMetadataProvider$getBookMetadataFromBook$1$description$2 = false;
                        v3 = null;
                    } else {
                        v3 = var12_22;
                    }
                    v4 = (String)v3;
                } else lbl-1000:
                // 2 sources

                {
                    v4 = description = null;
                }
                if ((v5 /* !! */  = opf.selectFirst("metadata > dc|date")) != null && (v5 /* !! */  = ($i$a$-ifBlank-EpubMetadataProvider$getBookMetadataFromBook$1$title$1 = v5 /* !! */ .text())) != null) {
                    Intrinsics.checkNotNull((Object)v5 /* !! */ );
                    it = $i$a$-ifBlank-EpubMetadataProvider$getBookMetadataFromBook$1$title$1;
                    $i$a$-let-EpubMetadataProvider$getBookMetadataFromBook$1$date$1 = false;
                    v6 = this.parseDate(it);
                } else {
                    v6 = null;
                }
                date = v6;
                v7 = opf.select("metadata > *|meta[property=role][scheme=marc:relators]");
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"select(...)");
                $i$a$-ifBlank-EpubMetadataProvider$getBookMetadataFromBook$1$title$1 = (Iterable)v7;
                $i$f$associate = false;
                capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                $i$a$-let-EpubMetadataProvider$getBookMetadataFromBook$1$date$1 = $this$associate$iv;
                destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                $i$f$associateTo = false;
                for (T element$iv$iv : $this$associateTo$iv$iv) {
                    var18_37 = destination$iv$iv;
                    it = (Element)element$iv$iv;
                    $i$a$-associate-EpubMetadataProvider$getBookMetadataFromBook$1$authorRoles$1 = false;
                    v8 = it.attr("refines");
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"attr(...)");
                    it = TuplesKt.to((Object)StringsKt.removePrefix((String)v8, (CharSequence)"#"), (Object)it.text());
                    var18_37.put(it.getFirst(), it.getSecond());
                }
                authorRoles = destination$iv$iv;
                v9 = opf.select("metadata > dc|creator");
                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"select(...)");
                $i$f$associate = (Iterable)v9;
                $i$f$mapNotNull = false;
                $this$associateTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                var18_37 = $this$forEach$iv$iv$iv.iterator();
                while (var18_37.hasNext()) {
                    element$iv$iv = element$iv$iv$iv /* !! */  = var18_37.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    el = (Element)element$iv$iv;
                    $i$a$-mapNotNull-EpubMetadataProvider$getBookMetadataFromBook$1$authors$1 = false;
                    v10 = el.text();
                    Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"text(...)");
                    name = StringsKt.trim((CharSequence)v10).toString();
                    if (StringsKt.isBlank((CharSequence)name)) {
                        v11 = null;
                    } else {
                        var25_47 = el.attr("opf:role");
                        if (StringsKt.isBlank((CharSequence)var25_47)) {
                            $i$a$-ifBlank-EpubMetadataProvider$getBookMetadataFromBook$1$authors$1$opfRole$1 = false;
                            v12 = null;
                        } else {
                            v12 = var25_47;
                        }
                        opfRole = (String)v12;
                        $i$a$-ifBlank-EpubMetadataProvider$getBookMetadataFromBook$1$authors$1$opfRole$1 = el.attr("id");
                        if (StringsKt.isBlank((CharSequence)$i$a$-ifBlank-EpubMetadataProvider$getBookMetadataFromBook$1$authors$1$opfRole$1)) {
                            $i$a$-ifBlank-EpubMetadataProvider$getBookMetadataFromBook$1$authors$1$id$1 = false;
                            v13 = null;
                        } else {
                            v13 = $i$a$-ifBlank-EpubMetadataProvider$getBookMetadataFromBook$1$authors$1$opfRole$1;
                        }
                        id = (String)v13;
                        v14 = (String)authorRoles.get(id);
                        if (v14 != null) {
                            var29_52 = v14;
                            if (StringsKt.isBlank((CharSequence)var29_52)) {
                                $i$a$-ifBlank-EpubMetadataProvider$getBookMetadataFromBook$1$authors$1$refineRole$1 = false;
                                v15 = null;
                            } else {
                                v15 = var29_52;
                            }
                            v16 = (String)v15;
                        } else {
                            v16 = refineRole = null;
                        }
                        if ((v17 = opfRole) == null) {
                            v17 = refineRole;
                        }
                        if ((v18 = (String)this.relators.get(v17)) == null) {
                            v18 = "writer";
                        }
                        v11 = new Author(name, v18);
                    }
                    if (v11 == null) continue;
                    it$iv$iv = v11;
                    $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                if ($this$mapNotNull$iv.isEmpty()) {
                    $i$a$-ifEmpty-EpubMetadataProvider$getBookMetadataFromBook$1$authors$2 = false;
                    v19 = null;
                } else {
                    v19 = $this$mapNotNull$iv;
                }
                authors = (List)v19;
                v20 = opf.select("metadata > dc|identifier");
                Intrinsics.checkNotNullExpressionValue((Object)v20, (String)"select(...)");
                $i$a$-ifEmpty-EpubMetadataProvider$getBookMetadataFromBook$1$authors$2 = (Iterable)v20;
                $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    element$iv$iv$iv /* !! */  = (Element)item$iv$iv;
                    var33_56 = destination$iv$iv;
                    $i$a$-map-EpubMetadataProvider$getBookMetadataFromBook$1$isbn$1 = false;
                    v21 = it.text();
                    Intrinsics.checkNotNullExpressionValue((Object)v21, (String)"text(...)");
                    v22 = v21.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)v22, (String)"toLowerCase(...)");
                    var33_56.add(StringsKt.removePrefix((String)v22, (CharSequence)"isbn:"));
                }
                for (String it : (Iterable)((List)destination$iv$iv)) {
                    $i$a$-firstNotNullOfOrNull-EpubMetadataProvider$getBookMetadataFromBook$1$isbn$2 = false;
                    var14_26 = this.isbnValidator.validate(it);
                    if (var14_26 == null) continue;
                    v23 = var14_26;
                    break block35;
                }
                v23 = null;
            }
            isbn = v23;
            var11_21 = opf.selectFirst("metadata > *|meta[property=belongs-to-collection]");
            if (var11_21 == null || (var14_26 = var11_21.attr("id")) == null) ** GOTO lbl-1000
            id = var14_26;
            $i$a$-let-EpubMetadataProvider$getBookMetadataFromBook$1$seriesIndex$1 = false;
            $i$a$-firstNotNullOfOrNull-EpubMetadataProvider$getBookMetadataFromBook$1$isbn$2 = opf.selectFirst("metadata > *|meta[refines=#" + id + "][property=group-position]");
            if ($i$a$-firstNotNullOfOrNull-EpubMetadataProvider$getBookMetadataFromBook$1$isbn$2 != null) {
                v24 = $i$a$-firstNotNullOfOrNull-EpubMetadataProvider$getBookMetadataFromBook$1$isbn$2.text();
            } else lbl-1000:
            // 2 sources

            {
                v24 = null;
            }
            v25 = seriesIndex = v24;
            if (v25 != null) {
                var14_26 = v25;
                if (StringsKt.isBlank((CharSequence)var14_26)) {
                    $i$a$-ifBlank-EpubMetadataProvider$getBookMetadataFromBook$1$1 = false;
                    v26 /* !! */  = null;
                } else {
                    v26 /* !! */  = var14_26;
                }
                v27 /* !! */  = v26 /* !! */ ;
            } else {
                v27 /* !! */  = null;
            }
            var11_21 = v27 /* !! */ ;
            v28 = seriesIndex;
            var14_26 = v28 != null ? StringsKt.toFloatOrNull(v28) : null;
            return new BookMetadataPatch(title, description, (String)var11_21, (Float)var14_26, date, authors, isbn, null, null, null, 896, null);
        }
        return null;
    }

    public boolean getSupportsAppendVolume() {
        return this.supportsAppendVolume;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public SeriesMetadataPatch getSeriesMetadataFromBook(@NotNull BookWithMedia book, boolean appendVolumeToTitle) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        if (!Intrinsics.areEqual((Object)book.getMedia().getMediaType(), (Object)MediaType.EPUB.getType())) {
            return null;
        }
        String string = EpubKt.getPackageFileContent((Path)book.getBook().getPath());
        if (string != null) {
            Object object;
            String string2;
            Collection collection;
            void $this$mapNotNullTo$iv$iv;
            Collection $this$mapNotNull$iv;
            String string3;
            String string42;
            Object object2;
            String publisher;
            Object object3;
            String series;
            CharSequence charSequence;
            String string5;
            String packageFile = string;
            boolean bl = false;
            Document opf = Jsoup.parse((String)packageFile, (String)"", (Parser)Parser.xmlParser());
            Object object4 = opf.selectFirst("metadata > *|meta[property=belongs-to-collection]");
            if (object4 != null && (object4 = (string5 = object4.text())) != null) {
                CharSequence charSequence2;
                Intrinsics.checkNotNull((Object)object4);
                charSequence = string5;
                if (StringsKt.isBlank((CharSequence)charSequence)) {
                    boolean string42 = false;
                    charSequence2 = null;
                } else {
                    charSequence2 = charSequence;
                }
                v2 = (String)charSequence2;
            } else {
                v2 = series = null;
            }
            if ((object3 = opf.selectFirst("metadata > dc|publisher")) != null && (object3 = (charSequence = object3.text())) != null) {
                CharSequence charSequence3;
                Intrinsics.checkNotNull((Object)object3);
                CharSequence string42 = charSequence;
                if (StringsKt.isBlank((CharSequence)string42)) {
                    boolean bl2 = false;
                    charSequence3 = null;
                } else {
                    charSequence3 = string42;
                }
                v5 = (String)charSequence3;
            } else {
                v5 = publisher = null;
            }
            if ((object2 = opf.selectFirst("metadata > dc|language")) != null && (object2 = (string42 = object2.text())) != null) {
                CharSequence charSequence4;
                Intrinsics.checkNotNull((Object)object2);
                CharSequence bl2 = string42;
                if (StringsKt.isBlank((CharSequence)bl2)) {
                    boolean bl3 = false;
                    charSequence4 = null;
                } else {
                    charSequence4 = bl2;
                }
                string3 = (String)charSequence4;
            } else {
                string3 = null;
            }
            String language = string3;
            Elements elements = opf.select("metadata > dc|subject");
            Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
            Iterable string42 = (Iterable)elements;
            boolean $i$f$mapNotNull = false;
            void bl3 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                CharSequence charSequence5;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl4 = false;
                Element it = (Element)element$iv$iv;
                boolean bl5 = false;
                String string6 = it.text();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"text(...)");
                CharSequence charSequence6 = ((Object)StringsKt.trim((CharSequence)string6)).toString();
                if (StringsKt.isBlank((CharSequence)charSequence6)) {
                    boolean bl6 = false;
                    charSequence5 = null;
                } else {
                    charSequence5 = charSequence6;
                }
                if ((String)charSequence5 == null) continue;
                boolean bl7 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            if ($this$mapNotNull$iv.isEmpty()) {
                boolean bl8 = false;
                collection = null;
            } else {
                collection = $this$mapNotNull$iv;
            }
            Set genres = (Set)collection;
            Object object5 = opf.getElementsByTag("spine").first();
            if (object5 != null && (object5 = (string2 = object5.attr("page-progression-direction"))) != null) {
                Intrinsics.checkNotNull((Object)object5);
                String it = string2;
                boolean bl9 = false;
                String string7 = it;
                object = Intrinsics.areEqual((Object)string7, (Object)"rtl") ? SeriesMetadata.ReadingDirection.RIGHT_TO_LEFT : (Intrinsics.areEqual((Object)string7, (Object)"ltr") ? SeriesMetadata.ReadingDirection.LEFT_TO_RIGHT : null);
            } else {
                object = null;
            }
            SeriesMetadata.ReadingDirection direction = object;
            String string8 = series;
            String string9 = string8 != null ? LanguageUtilsKt.stripAccents((String)string8) : null;
            string2 = language != null && BCP47TagValidator.INSTANCE.isValid(language) ? BCP47TagValidator.INSTANCE.normalize(language) : null;
            Set set = SetsKt.emptySet();
            return new SeriesMetadataPatch(series, string9, null, null, direction, publisher, null, string2, genres, null, set);
        }
        return null;
    }

    public boolean shouldLibraryHandlePatch(@NotNull Library library, @NotNull MetadataPatchTarget target) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return switch (WhenMappings.$EnumSwitchMapping$0[target.ordinal()]) {
            case 1 -> library.getImportEpubBook();
            case 2 -> library.getImportEpubSeries();
            default -> false;
        };
    }

    private LocalDate parseDate(String date) {
        LocalDate localDate;
        try {
            localDate = LocalDate.parse(date, DateTimeFormatter.ISO_DATE);
        }
        catch (Exception e) {
            LocalDate localDate2;
            try {
                localDate2 = LocalDate.parse(date, DateTimeFormatter.ISO_LOCAL_DATE);
            }
            catch (Exception e2) {
                LocalDate localDate3;
                try {
                    localDate3 = LocalDate.parse(date, DateTimeFormatter.ISO_DATE_TIME);
                }
                catch (Exception e3) {
                    localDate3 = null;
                }
                localDate2 = localDate3;
            }
            localDate = localDate2;
        }
        return localDate;
    }
}

