/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.security;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gotson.komga.infrastructure.security.TokenEncoder;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.token.Sha512DigestUtils;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

@Configuration
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J\b\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\u0007"}, d2={"Lorg/gotson/komga/infrastructure/security/PasswordEncoderConfiguration;", "", "()V", "getPasswordEncoder", "Lorg/springframework/security/crypto/password/PasswordEncoder;", "getTokenEncoder", "Lorg/gotson/komga/infrastructure/security/TokenEncoder;", "komga"})
public class PasswordEncoderConfiguration {
    @Bean
    @NotNull
    public PasswordEncoder getPasswordEncoder() {
        return (PasswordEncoder)new BCryptPasswordEncoder();
    }

    @Bean
    @NotNull
    public TokenEncoder getTokenEncoder() {
        return PasswordEncoderConfiguration::getTokenEncoder$lambda$0;
    }

    private static final String getTokenEncoder$lambda$0(String rawPassword) {
        Intrinsics.checkNotNullParameter((Object)rawPassword, (String)"rawPassword");
        String string = Sha512DigestUtils.shaHex((String)rawPassword);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shaHex(...)");
        return string;
    }
}

