/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.security;

import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.time.Duration;
import org.gotson.komga.infrastructure.configuration.KomgaSettingsProvider;
import org.gotson.komga.infrastructure.security.OpdsAuthenticationEntryPoint;
import org.gotson.komga.infrastructure.security.TokenEncoder;
import org.gotson.komga.infrastructure.security.apikey.ApiKeyAuthenticationFilter;
import org.gotson.komga.infrastructure.security.apikey.ApiKeyAuthenticationProvider;
import org.gotson.komga.infrastructure.security.apikey.UriRegexApiKeyAuthenticationConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.actuate.autoconfigure.security.servlet.EndpointRequest;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationEventPublisher;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.HttpSecurityDslKt;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.CorsConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.annotation.web.configurers.HttpBasicConfigurer;
import org.springframework.security.config.annotation.web.configurers.LogoutConfigurer;
import org.springframework.security.config.annotation.web.configurers.RememberMeConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2LoginConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.security.web.authentication.rememberme.TokenBasedRememberMeServices;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
@EnableMethodSecurity(prePostEnabled=true)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u007f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\t\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u0006\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0017J\b\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010(\u001a\u00020)H\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/gotson/komga/infrastructure/security/SecurityConfiguration;", "", "komgaSettingsProvider", "Lorg/gotson/komga/infrastructure/configuration/KomgaSettingsProvider;", "komgaUserDetailsService", "Lorg/springframework/security/core/userdetails/UserDetailsService;", "apiKeyAuthenticationProvider", "Lorg/gotson/komga/infrastructure/security/apikey/ApiKeyAuthenticationProvider;", "oauth2UserService", "Lorg/springframework/security/oauth2/client/userinfo/OAuth2UserService;", "Lorg/springframework/security/oauth2/client/userinfo/OAuth2UserRequest;", "Lorg/springframework/security/oauth2/core/user/OAuth2User;", "oidcUserService", "Lorg/springframework/security/oauth2/client/oidc/userinfo/OidcUserRequest;", "Lorg/springframework/security/oauth2/core/oidc/user/OidcUser;", "sessionCookieName", "", "userAgentWebAuthenticationDetailsSource", "Lorg/springframework/security/web/authentication/WebAuthenticationDetailsSource;", "theSessionRegistry", "Lorg/springframework/security/core/session/SessionRegistry;", "opdsAuthenticationEntryPoint", "Lorg/gotson/komga/infrastructure/security/OpdsAuthenticationEntryPoint;", "authenticationEventPublisher", "Lorg/springframework/security/authentication/AuthenticationEventPublisher;", "tokenEncoder", "Lorg/gotson/komga/infrastructure/security/TokenEncoder;", "clientRegistrationRepository", "Lorg/springframework/security/oauth2/client/registration/InMemoryClientRegistrationRepository;", "(Lorg/gotson/komga/infrastructure/configuration/KomgaSettingsProvider;Lorg/springframework/security/core/userdetails/UserDetailsService;Lorg/gotson/komga/infrastructure/security/apikey/ApiKeyAuthenticationProvider;Lorg/springframework/security/oauth2/client/userinfo/OAuth2UserService;Lorg/springframework/security/oauth2/client/userinfo/OAuth2UserService;Ljava/lang/String;Lorg/springframework/security/web/authentication/WebAuthenticationDetailsSource;Lorg/springframework/security/core/session/SessionRegistry;Lorg/gotson/komga/infrastructure/security/OpdsAuthenticationEntryPoint;Lorg/springframework/security/authentication/AuthenticationEventPublisher;Lorg/gotson/komga/infrastructure/security/TokenEncoder;Lorg/springframework/security/oauth2/client/registration/InMemoryClientRegistrationRepository;)V", "oauth2Enabled", "", "Lorg/springframework/security/authentication/AuthenticationManager;", "filterChain", "Lorg/springframework/security/web/SecurityFilterChain;", "http", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "koboAuthenticationFilter", "Ljakarta/servlet/Filter;", "koboFilterChain", "encoder", "Lorg/springframework/security/crypto/password/PasswordEncoder;", "komga"})
public class SecurityConfiguration {
    @NotNull
    private final KomgaSettingsProvider komgaSettingsProvider;
    @NotNull
    private final UserDetailsService komgaUserDetailsService;
    @NotNull
    private final ApiKeyAuthenticationProvider apiKeyAuthenticationProvider;
    @NotNull
    private final OAuth2UserService<OAuth2UserRequest, OAuth2User> oauth2UserService;
    @NotNull
    private final OAuth2UserService<OidcUserRequest, OidcUser> oidcUserService;
    @NotNull
    private final String sessionCookieName;
    @NotNull
    private final WebAuthenticationDetailsSource userAgentWebAuthenticationDetailsSource;
    @NotNull
    private final SessionRegistry theSessionRegistry;
    @NotNull
    private final OpdsAuthenticationEntryPoint opdsAuthenticationEntryPoint;
    @NotNull
    private final AuthenticationEventPublisher authenticationEventPublisher;
    @NotNull
    private final TokenEncoder tokenEncoder;
    private final boolean oauth2Enabled;

    public SecurityConfiguration(@NotNull KomgaSettingsProvider komgaSettingsProvider, @NotNull UserDetailsService komgaUserDetailsService, @NotNull ApiKeyAuthenticationProvider apiKeyAuthenticationProvider, @NotNull OAuth2UserService<OAuth2UserRequest, OAuth2User> oauth2UserService, @NotNull OAuth2UserService<OidcUserRequest, OidcUser> oidcUserService, @NotNull String sessionCookieName, @NotNull WebAuthenticationDetailsSource userAgentWebAuthenticationDetailsSource, @NotNull SessionRegistry theSessionRegistry, @NotNull OpdsAuthenticationEntryPoint opdsAuthenticationEntryPoint, @NotNull AuthenticationEventPublisher authenticationEventPublisher, @NotNull TokenEncoder tokenEncoder, @Nullable InMemoryClientRegistrationRepository clientRegistrationRepository) {
        Intrinsics.checkNotNullParameter((Object)komgaSettingsProvider, (String)"komgaSettingsProvider");
        Intrinsics.checkNotNullParameter((Object)komgaUserDetailsService, (String)"komgaUserDetailsService");
        Intrinsics.checkNotNullParameter((Object)apiKeyAuthenticationProvider, (String)"apiKeyAuthenticationProvider");
        Intrinsics.checkNotNullParameter(oauth2UserService, (String)"oauth2UserService");
        Intrinsics.checkNotNullParameter(oidcUserService, (String)"oidcUserService");
        Intrinsics.checkNotNullParameter((Object)sessionCookieName, (String)"sessionCookieName");
        Intrinsics.checkNotNullParameter((Object)userAgentWebAuthenticationDetailsSource, (String)"userAgentWebAuthenticationDetailsSource");
        Intrinsics.checkNotNullParameter((Object)theSessionRegistry, (String)"theSessionRegistry");
        Intrinsics.checkNotNullParameter((Object)opdsAuthenticationEntryPoint, (String)"opdsAuthenticationEntryPoint");
        Intrinsics.checkNotNullParameter((Object)authenticationEventPublisher, (String)"authenticationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)tokenEncoder, (String)"tokenEncoder");
        this.komgaSettingsProvider = komgaSettingsProvider;
        this.komgaUserDetailsService = komgaUserDetailsService;
        this.apiKeyAuthenticationProvider = apiKeyAuthenticationProvider;
        this.oauth2UserService = oauth2UserService;
        this.oidcUserService = oidcUserService;
        this.sessionCookieName = sessionCookieName;
        this.userAgentWebAuthenticationDetailsSource = userAgentWebAuthenticationDetailsSource;
        this.theSessionRegistry = theSessionRegistry;
        this.opdsAuthenticationEntryPoint = opdsAuthenticationEntryPoint;
        this.authenticationEventPublisher = authenticationEventPublisher;
        this.tokenEncoder = tokenEncoder;
        this.oauth2Enabled = clientRegistrationRepository != null;
    }

    @Order(value=1)
    @Bean
    @NotNull
    public SecurityFilterChain filterChain(@NotNull HttpSecurity http) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        http.cors(SecurityConfiguration::filterChain$lambda$0).csrf(SecurityConfiguration::filterChain$lambda$1).securityMatchers(SecurityConfiguration::filterChain$lambda$2).authorizeHttpRequests(SecurityConfiguration::filterChain$lambda$3).headers(SecurityConfiguration::filterChain$lambda$6).userDetailsService(this.komgaUserDetailsService).httpBasic(arg_0 -> SecurityConfiguration.filterChain$lambda$7(this, arg_0)).logout(arg_0 -> SecurityConfiguration.filterChain$lambda$8(this, arg_0)).sessionManagement(arg_0 -> SecurityConfiguration.filterChain$lambda$10(this, arg_0)).exceptionHandling(arg_0 -> SecurityConfiguration.filterChain$lambda$11(this, arg_0));
        if (this.oauth2Enabled) {
            http.oauth2Login(arg_0 -> SecurityConfiguration.filterChain$lambda$15(this, arg_0));
        }
        http.rememberMe(arg_0 -> SecurityConfiguration.filterChain$lambda$17(this, arg_0));
        Object object = http.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (SecurityFilterChain)object;
    }

    @Bean
    @NotNull
    public SecurityFilterChain koboFilterChain(@NotNull HttpSecurity http, @NotNull PasswordEncoder encoder) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        HttpSecurityDslKt.invoke((HttpSecurity)http, (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */));
        Object object = http.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (SecurityFilterChain)object;
    }

    @NotNull
    public Filter koboAuthenticationFilter() {
        return (Filter)new ApiKeyAuthenticationFilter(this.apiKeyAuthenticationProvider(), (AuthenticationConverter)new UriRegexApiKeyAuthenticationConverter(new Regex("\\/kobo\\/([\\w-]+)"), this.tokenEncoder, (AuthenticationDetailsSource)this.userAgentWebAuthenticationDetailsSource));
    }

    @NotNull
    public AuthenticationManager apiKeyAuthenticationProvider() {
        ProviderManager providerManager = new ProviderManager[]{this.apiKeyAuthenticationProvider};
        ProviderManager $this$apiKeyAuthenticationProvider_u24lambda_u2418 = providerManager = new ProviderManager((AuthenticationProvider[])providerManager);
        boolean bl = false;
        $this$apiKeyAuthenticationProvider_u24lambda_u2418.setAuthenticationEventPublisher(this.authenticationEventPublisher);
        return (AuthenticationManager)providerManager;
    }

    private static final void filterChain$lambda$0(CorsConfigurer it) {
    }

    private static final void filterChain$lambda$1(CsrfConfigurer it) {
        it.disable();
    }

    private static final void filterChain$lambda$2(HttpSecurity.RequestMatcherConfigurer it) {
        String[] stringArray = new String[]{"/api/**", "/opds/**", "/sse/**", "/oauth2/authorization/**", "/login/oauth2/code/**"};
        it.requestMatchers(stringArray);
        stringArray = new RequestMatcher[]{EndpointRequest.toAnyEndpoint()};
        it.requestMatchers((RequestMatcher[])stringArray);
    }

    private static final void filterChain$lambda$3(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry it) {
        Object[] objectArray = new RequestMatcher[1];
        Class[] classArray = new Class[]{HealthEndpoint.class};
        objectArray[0] = EndpointRequest.to((Class[])classArray);
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers(objectArray)).permitAll();
        objectArray = new RequestMatcher[]{EndpointRequest.toAnyEndpoint()};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers(objectArray)).hasRole("ADMIN");
        objectArray = new String[]{"/api/v1/claim", "/api/v1/oauth2/providers", "/api/v1/books/{bookId}/resource/**", "/opds/v2/auth"};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers((String[])objectArray)).permitAll();
        objectArray = new String[]{"/api/**", "/opds/**", "/sse/**"};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers((String[])objectArray)).hasRole("USER");
    }

    private static final void filterChain$lambda$6$lambda$4(HeadersConfigurer.CacheControlConfig it) {
        it.disable();
    }

    private static final void filterChain$lambda$6$lambda$5(HeadersConfigurer.FrameOptionsConfig it) {
        it.sameOrigin();
    }

    private static final void filterChain$lambda$6(HeadersConfigurer headersConfigurer) {
        headersConfigurer.cacheControl(SecurityConfiguration::filterChain$lambda$6$lambda$4);
        headersConfigurer.frameOptions(SecurityConfiguration::filterChain$lambda$6$lambda$5);
    }

    private static final void filterChain$lambda$7(SecurityConfiguration this$0, HttpBasicConfigurer it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.authenticationDetailsSource((AuthenticationDetailsSource)this$0.userAgentWebAuthenticationDetailsSource);
    }

    private static final void filterChain$lambda$8(SecurityConfiguration this$0, LogoutConfigurer it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.logoutUrl("/api/logout");
        String[] stringArray = new String[]{this$0.sessionCookieName};
        it.deleteCookies(stringArray);
        it.invalidateHttpSession(true);
    }

    private static final void filterChain$lambda$10$lambda$9(SecurityConfiguration this$0, SessionManagementConfigurer.ConcurrencyControlConfigurer it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.sessionRegistry(this$0.theSessionRegistry);
        it.maximumSessions(-1);
    }

    private static final void filterChain$lambda$10(SecurityConfiguration this$0, SessionManagementConfigurer session) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        session.sessionCreationPolicy(SessionCreationPolicy.IF_REQUIRED);
        session.sessionConcurrency(arg_0 -> SecurityConfiguration.filterChain$lambda$10$lambda$9(this$0, arg_0));
    }

    private static final void filterChain$lambda$11(SecurityConfiguration this$0, ExceptionHandlingConfigurer it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)this$0.opdsAuthenticationEntryPoint, (RequestMatcher)new AntPathRequestMatcher("/opds/v2/**"));
    }

    private static final void filterChain$lambda$15$lambda$12(SecurityConfiguration this$0, OAuth2LoginConfigurer.UserInfoEndpointConfig it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.userService(this$0.oauth2UserService);
        it.oidcUserService(this$0.oidcUserService);
    }

    private static final void filterChain$lambda$15$lambda$13(HttpServletRequest request, HttpServletResponse response2, AuthenticationException exception) {
        String errorMessage = exception instanceof OAuth2AuthenticationException ? ((OAuth2AuthenticationException)exception).getError().getErrorCode() : exception.getMessage();
        String url = "/login?server_redirect=Y&error=" + errorMessage;
        new SimpleUrlAuthenticationFailureHandler(url).onAuthenticationFailure(request, response2, exception);
    }

    private static final void filterChain$lambda$15$lambda$14(OAuth2LoginConfigurer.RedirectionEndpointConfig it) {
    }

    private static final void filterChain$lambda$15(SecurityConfiguration this$0, OAuth2LoginConfigurer oauth2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        oauth2.userInfoEndpoint(arg_0 -> SecurityConfiguration.filterChain$lambda$15$lambda$12(this$0, arg_0));
        oauth2.authenticationDetailsSource((AuthenticationDetailsSource)this$0.userAgentWebAuthenticationDetailsSource);
        ((OAuth2LoginConfigurer)oauth2.loginPage("/login").defaultSuccessUrl("/?server_redirect=Y", true)).failureHandler(SecurityConfiguration::filterChain$lambda$15$lambda$13);
        oauth2.redirectionEndpoint(SecurityConfiguration::filterChain$lambda$15$lambda$14);
    }

    /*
     * WARNING - void declaration
     */
    private static final void filterChain$lambda$17(SecurityConfiguration this$0, RememberMeConfigurer it) {
        void $this$filterChain_u24lambda_u2417_u24lambda_u2416;
        TokenBasedRememberMeServices tokenBasedRememberMeServices;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        TokenBasedRememberMeServices tokenBasedRememberMeServices2 = tokenBasedRememberMeServices = new TokenBasedRememberMeServices(this$0.komgaSettingsProvider.getRememberMeKey(), this$0.komgaUserDetailsService);
        RememberMeConfigurer rememberMeConfigurer = it;
        boolean bl = false;
        $this$filterChain_u24lambda_u2417_u24lambda_u2416.setTokenValiditySeconds((int)Duration.getInWholeSeconds-impl((long)this$0.komgaSettingsProvider.getRememberMeDuration-UwyO8pc()));
        $this$filterChain_u24lambda_u2417_u24lambda_u2416.setAuthenticationDetailsSource((AuthenticationDetailsSource)this$0.userAgentWebAuthenticationDetailsSource);
        rememberMeConfigurer.rememberMeServices((RememberMeServices)tokenBasedRememberMeServices);
    }
}

