/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.rest;

import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.gotson.komga.interfaces.api.rest.DirectoryListingDto;
import org.gotson.komga.interfaces.api.rest.DirectoryRequestDto;
import org.gotson.komga.interfaces.api.rest.FileSystemController;
import org.gotson.komga.interfaces.api.rest.FileSystemControllerKt;
import org.gotson.komga.interfaces.api.rest.PathDto;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"api/v1/filesystem"}, produces={"application/json"})
@PreAuthorize(value="hasRole('ADMIN')")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u00020\u00072\b\b\u0003\u0010\b\u001a\u00020\tH\u0017R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/gotson/komga/interfaces/api/rest/FileSystemController;", "", "()V", "fs", "Ljava/nio/file/FileSystem;", "kotlin.jvm.PlatformType", "getDirectoryListing", "Lorg/gotson/komga/interfaces/api/rest/DirectoryListingDto;", "request", "Lorg/gotson/komga/interfaces/api/rest/DirectoryRequestDto;", "komga"})
@SourceDebugExtension(value={"SMAP\nFileSystemController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileSystemController.kt\norg/gotson/komga/interfaces/api/rest/FileSystemController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1549#2:84\n1620#2,3:85\n3190#2,10:88\n*S KotlinDebug\n*F\n+ 1 FileSystemController.kt\norg/gotson/komga/interfaces/api/rest/FileSystemController\n*L\n30#1:84\n30#1:85,3\n46#1:88,10\n*E\n"})
public class FileSystemController {
    private final FileSystem fs = FileSystems.getDefault();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @PostMapping
    @NotNull
    public DirectoryListingDto getDirectoryListing(@RequestBody(required=false) @NotNull DirectoryRequestDto request) {
        DirectoryListingDto directoryListingDto;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (((CharSequence)request.getPath()).length() == 0) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable<Path> iterable = this.fs.getRootDirectories();
            Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
            Iterable<Path> iterable2 = iterable;
            String string = null;
            boolean $i$f$map = false;
            void var4_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Path path2 = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(FileSystemControllerKt.toDto((Path)it));
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 1;
            List list = CollectionsKt.emptyList();
            List list2 = (List)destination$iv$iv;
            String string2 = string;
            directoryListingDto = new DirectoryListingDto(string2, list2, list, n, defaultConstructorMarker);
        } else {
            Pair pair;
            Path path3 = this.fs.getPath(request.getPath(), new String[0]);
            if (!path3.isAbsolute()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Path must be absolute");
            }
            Intrinsics.checkNotNull((Object)path3);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            Path directory = Files.isDirectory(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? path3 : path3.getParent();
            try {
                Pair pair2;
                AutoCloseable destination$iv$iv = Files.list(directory);
                Throwable $i$f$mapTo = null;
                try {
                    void $this$partition$iv;
                    Stream dirStream = (Stream)destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)dirStream);
                    Object it = StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE);
                    it = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)SequencesKt.filter((Sequence)StreamsKt.asSequence((Stream)dirStream), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */)), (Comparator)((Comparator)new /* Unavailable Anonymous Inner Class!! */)), (Function1)((Function1)getDirectoryListing.2.3.INSTANCE)));
                    boolean $i$f$partition = false;
                    ArrayList first$iv = new ArrayList();
                    ArrayList second$iv = new ArrayList();
                    for (Object element$iv : $this$partition$iv) {
                        PathDto it2 = (PathDto)element$iv;
                        boolean bl2 = false;
                        if (Intrinsics.areEqual((Object)it2.getType(), (Object)"directory")) {
                            first$iv.add(element$iv);
                            continue;
                        }
                        second$iv.add(element$iv);
                    }
                    pair2 = new Pair(first$iv, second$iv);
                }
                catch (Throwable throwable) {
                    $i$f$mapTo = throwable;
                    throw throwable;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)destination$iv$iv, (Throwable)$i$f$mapTo);
                }
                pair = pair2;
                List directories = (List)pair.component1();
                List files = (List)pair.component2();
                Path path4 = path3.getParent();
                pair = new DirectoryListingDto((path4 != null ? (Comparable)path4 : (Comparable)((Object)"")).toString(), directories, files);
            }
            catch (Exception e) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Path does not exist");
            }
            directoryListingDto = pair;
        }
        return directoryListingDto;
    }

    public static /* synthetic */ DirectoryListingDto getDirectoryListing$default(FileSystemController fileSystemController, DirectoryRequestDto directoryRequestDto, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getDirectoryListing");
        }
        if ((n & 1) != 0) {
            directoryRequestDto = new DirectoryRequestDto(null, false, 3, null);
        }
        return fileSystemController.getDirectoryListing(directoryRequestDto);
    }
}

