/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.rest;

import io.swagger.v3.oas.annotations.Parameter;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.model.Author;
import org.gotson.komga.domain.persistence.ReferentialRepository;
import org.gotson.komga.infrastructure.security.KomgaPrincipal;
import org.gotson.komga.infrastructure.swagger.PageableWithoutSortAsQueryParam;
import org.gotson.komga.interfaces.api.rest.ReferentialController;
import org.gotson.komga.interfaces.api.rest.dto.AuthorDto;
import org.gotson.komga.interfaces.api.rest.dto.AuthorDtoKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api"}, produces={"application/json"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u000b\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0001\u0010\b\u001a\u00020\t2\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u00072\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0017Jt\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0001\u0010\b\u001a\u00020\t2\n\b\u0001\u0010\u000f\u001a\u0004\u0018\u00010\u00072\n\b\u0001\u0010\u0010\u001a\u0004\u0018\u00010\u00072\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u00072\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\u00072\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u00072\n\b\u0001\u0010\u0012\u001a\u0004\u0018\u00010\u00072\b\b\u0003\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0017J\"\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00182\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\u000f\u001a\u00020\u0007H\u0017J\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u00182\b\b\u0001\u0010\b\u001a\u00020\tH\u0017JF\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00182\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\u000f\u001a\u00020\u00072\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u00072\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\u00072\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u0017J0\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0001\u0010\b\u001a\u00020\t2\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u00072\n\b\u0001\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u0017J0\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0001\u0010\b\u001a\u00020\t2\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u00072\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0017J0\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0001\u0010\b\u001a\u00020\t2\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u00072\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0017J0\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0001\u0010\b\u001a\u00020\t2\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u00072\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0017J0\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0001\u0010\b\u001a\u00020\t2\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u00072\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0017J0\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0001\u0010\b\u001a\u00020\t2\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u00072\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0017J0\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0001\u0010\b\u001a\u00020\t2\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u00072\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0017J0\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0001\u0010\b\u001a\u00020\t2\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u00072\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/gotson/komga/interfaces/api/rest/ReferentialController;", "", "referentialRepository", "Lorg/gotson/komga/domain/persistence/ReferentialRepository;", "(Lorg/gotson/komga/domain/persistence/ReferentialRepository;)V", "getAgeRatings", "", "", "principal", "Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;", "libraryId", "collectionId", "getAuthors", "Lorg/springframework/data/domain/Page;", "Lorg/gotson/komga/interfaces/api/rest/dto/AuthorDto;", "search", "role", "seriesId", "readListId", "unpaged", "", "page", "Lorg/springframework/data/domain/Pageable;", "getAuthorsNames", "", "getAuthorsRoles", "getAuthorsV1", "getBookTags", "getGenres", "getLanguages", "getPublishers", "getSeriesReleaseDates", "getSeriesTags", "getSharingLabels", "getTags", "komga"})
@SourceDebugExtension(value={"SMAP\nReferentialController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReferentialController.kt\norg/gotson/komga/interfaces/api/rest/ReferentialController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,190:1\n1549#2:191\n1620#2,3:192\n1549#2:195\n1620#2,3:196\n1549#2:199\n1620#2,3:200\n*S KotlinDebug\n*F\n+ 1 ReferentialController.kt\norg/gotson/komga/interfaces/api/rest/ReferentialController\n*L\n38#1:191\n38#1:192,3\n176#1:195\n176#1:196,3\n188#1:199\n188#1:200,3\n*E\n"})
public class ReferentialController {
    @NotNull
    private final ReferentialRepository referentialRepository;

    public ReferentialController(@NotNull ReferentialRepository referentialRepository) {
        Intrinsics.checkNotNullParameter((Object)referentialRepository, (String)"referentialRepository");
        this.referentialRepository = referentialRepository;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"v1/authors"})
    @NotNull
    public List<AuthorDto> getAuthorsV1(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="search", defaultValue="") @NotNull String search, @RequestParam(name="library_id", required=false) @Nullable String libraryId, @RequestParam(name="collection_id", required=false) @Nullable String collectionId, @RequestParam(name="series_id", required=false) @Nullable String seriesId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)search, (String)"search");
        Iterable iterable = libraryId != null ? this.referentialRepository.findAllAuthorsByNameAndLibrary(search, libraryId, principal.getUser().getAuthorizedLibraryIds(null)) : (collectionId != null ? this.referentialRepository.findAllAuthorsByNameAndCollection(search, collectionId, principal.getUser().getAuthorizedLibraryIds(null)) : (seriesId != null ? this.referentialRepository.findAllAuthorsByNameAndSeries(search, seriesId, principal.getUser().getAuthorizedLibraryIds(null)) : this.referentialRepository.findAllAuthorsByName(search, principal.getUser().getAuthorizedLibraryIds(null))));
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Author author = (Author)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(AuthorDtoKt.toDto((Author)it));
        }
        return (List)destination$iv$iv;
    }

    @PageableWithoutSortAsQueryParam
    @GetMapping(value={"v2/authors"})
    @NotNull
    public Page<AuthorDto> getAuthors(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="search", required=false) @Nullable String search, @RequestParam(name="role", required=false) @Nullable String role, @RequestParam(name="library_id", required=false) @Nullable String libraryId, @RequestParam(name="collection_id", required=false) @Nullable String collectionId, @RequestParam(name="series_id", required=false) @Nullable String seriesId, @RequestParam(name="readlist_id", required=false) @Nullable String readListId, @RequestParam(name="unpaged", required=false) boolean unpaged, @Parameter(hidden=true) @NotNull Pageable page) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Pageable pageable = unpaged ? Pageable.unpaged() : (Pageable)PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize());
        Intrinsics.checkNotNull((Object)pageable);
        Pageable pageRequest = pageable;
        Page page2 = (libraryId != null ? this.referentialRepository.findAllAuthorsByNameAndLibrary(search, role, libraryId, principal.getUser().getAuthorizedLibraryIds(null), pageRequest) : (collectionId != null ? this.referentialRepository.findAllAuthorsByNameAndCollection(search, role, collectionId, principal.getUser().getAuthorizedLibraryIds(null), pageRequest) : (seriesId != null ? this.referentialRepository.findAllAuthorsByNameAndSeries(search, role, seriesId, principal.getUser().getAuthorizedLibraryIds(null), pageRequest) : (readListId != null ? this.referentialRepository.findAllAuthorsByNameAndReadList(search, role, readListId, principal.getUser().getAuthorizedLibraryIds(null), pageRequest) : this.referentialRepository.findAllAuthorsByName(search, role, principal.getUser().getAuthorizedLibraryIds(null), pageRequest))))).map(arg_0 -> ReferentialController.getAuthors$lambda$1((Function1)getAuthors.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    public static /* synthetic */ Page getAuthors$default(ReferentialController referentialController, KomgaPrincipal komgaPrincipal, String string, String string2, String string3, String string4, String string5, String string6, boolean bl, Pageable pageable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getAuthors");
        }
        if ((n & 0x80) != 0) {
            bl = false;
        }
        return referentialController.getAuthors(komgaPrincipal, string, string2, string3, string4, string5, string6, bl, pageable);
    }

    @GetMapping(value={"v1/authors/names"})
    @NotNull
    public List<String> getAuthorsNames(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="search", defaultValue="") @NotNull String search) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)search, (String)"search");
        return this.referentialRepository.findAllAuthorsNamesByName(search, principal.getUser().getAuthorizedLibraryIds(null));
    }

    @GetMapping(value={"v1/authors/roles"})
    @NotNull
    public List<String> getAuthorsRoles(@AuthenticationPrincipal @NotNull KomgaPrincipal principal) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        return this.referentialRepository.findAllAuthorsRoles(principal.getUser().getAuthorizedLibraryIds(null));
    }

    @GetMapping(value={"v1/genres"})
    @NotNull
    public Set<String> getGenres(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="library_id", required=false) @Nullable String libraryId, @RequestParam(name="collection_id", required=false) @Nullable String collectionId) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        return libraryId != null ? this.referentialRepository.findAllGenresByLibrary(libraryId, principal.getUser().getAuthorizedLibraryIds(null)) : (collectionId != null ? this.referentialRepository.findAllGenresByCollection(collectionId, principal.getUser().getAuthorizedLibraryIds(null)) : this.referentialRepository.findAllGenres(principal.getUser().getAuthorizedLibraryIds(null)));
    }

    @GetMapping(value={"v1/sharing-labels"})
    @NotNull
    public Set<String> getSharingLabels(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="library_id", required=false) @Nullable String libraryId, @RequestParam(name="collection_id", required=false) @Nullable String collectionId) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        return libraryId != null ? this.referentialRepository.findAllSharingLabelsByLibrary(libraryId, principal.getUser().getAuthorizedLibraryIds(null)) : (collectionId != null ? this.referentialRepository.findAllSharingLabelsByCollection(collectionId, principal.getUser().getAuthorizedLibraryIds(null)) : this.referentialRepository.findAllSharingLabels(principal.getUser().getAuthorizedLibraryIds(null)));
    }

    @GetMapping(value={"v1/tags"})
    @NotNull
    public Set<String> getTags(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="library_id", required=false) @Nullable String libraryId, @RequestParam(name="collection_id", required=false) @Nullable String collectionId) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        return libraryId != null ? this.referentialRepository.findAllSeriesAndBookTagsByLibrary(libraryId, principal.getUser().getAuthorizedLibraryIds(null)) : (collectionId != null ? this.referentialRepository.findAllSeriesAndBookTagsByCollection(collectionId, principal.getUser().getAuthorizedLibraryIds(null)) : this.referentialRepository.findAllSeriesAndBookTags(principal.getUser().getAuthorizedLibraryIds(null)));
    }

    @GetMapping(value={"v1/tags/book"})
    @NotNull
    public Set<String> getBookTags(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="series_id", required=false) @Nullable String seriesId, @RequestParam(name="readlist_id", required=false) @Nullable String readListId) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        return seriesId != null ? this.referentialRepository.findAllBookTagsBySeries(seriesId, principal.getUser().getAuthorizedLibraryIds(null)) : (readListId != null ? this.referentialRepository.findAllBookTagsByReadList(readListId, principal.getUser().getAuthorizedLibraryIds(null)) : this.referentialRepository.findAllBookTags(principal.getUser().getAuthorizedLibraryIds(null)));
    }

    @GetMapping(value={"v1/tags/series"})
    @NotNull
    public Set<String> getSeriesTags(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="library_id", required=false) @Nullable String libraryId, @RequestParam(name="collection_id", required=false) @Nullable String collectionId) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        return libraryId != null ? this.referentialRepository.findAllSeriesTagsByLibrary(libraryId, principal.getUser().getAuthorizedLibraryIds(null)) : (collectionId != null ? this.referentialRepository.findAllSeriesTagsByCollection(collectionId, principal.getUser().getAuthorizedLibraryIds(null)) : this.referentialRepository.findAllSeriesTags(principal.getUser().getAuthorizedLibraryIds(null)));
    }

    @GetMapping(value={"v1/languages"})
    @NotNull
    public Set<String> getLanguages(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="library_id", required=false) @Nullable String libraryId, @RequestParam(name="collection_id", required=false) @Nullable String collectionId) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        return libraryId != null ? this.referentialRepository.findAllLanguagesByLibrary(libraryId, principal.getUser().getAuthorizedLibraryIds(null)) : (collectionId != null ? this.referentialRepository.findAllLanguagesByCollection(collectionId, principal.getUser().getAuthorizedLibraryIds(null)) : this.referentialRepository.findAllLanguages(principal.getUser().getAuthorizedLibraryIds(null)));
    }

    @GetMapping(value={"v1/publishers"})
    @NotNull
    public Set<String> getPublishers(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="library_id", required=false) @Nullable String libraryId, @RequestParam(name="collection_id", required=false) @Nullable String collectionId) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        return libraryId != null ? this.referentialRepository.findAllPublishersByLibrary(libraryId, principal.getUser().getAuthorizedLibraryIds(null)) : (collectionId != null ? this.referentialRepository.findAllPublishersByCollection(collectionId, principal.getUser().getAuthorizedLibraryIds(null)) : this.referentialRepository.findAllPublishers(principal.getUser().getAuthorizedLibraryIds(null)));
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"v1/age-ratings"})
    @NotNull
    public Set<String> getAgeRatings(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="library_id", required=false) @Nullable String libraryId, @RequestParam(name="collection_id", required=false) @Nullable String collectionId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Iterable iterable = libraryId != null ? this.referentialRepository.findAllAgeRatingsByLibrary(libraryId, principal.getUser().getAuthorizedLibraryIds(null)) : (collectionId != null ? this.referentialRepository.findAllAgeRatingsByCollection(collectionId, principal.getUser().getAuthorizedLibraryIds(null)) : this.referentialRepository.findAllAgeRatings(principal.getUser().getAuthorizedLibraryIds(null)));
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Integer n = (Integer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it;
            if (string == null || (string = ((Integer)((Object)string)).toString()) == null) {
                string = "None";
            }
            collection.add(string);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"v1/series/release-dates"})
    @NotNull
    public Set<String> getSeriesReleaseDates(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="library_id", required=false) @Nullable String libraryId, @RequestParam(name="collection_id", required=false) @Nullable String collectionId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Iterable iterable = libraryId != null ? this.referentialRepository.findAllSeriesReleaseDatesByLibrary(libraryId, principal.getUser().getAuthorizedLibraryIds(null)) : (collectionId != null ? this.referentialRepository.findAllSeriesReleaseDatesByCollection(collectionId, principal.getUser().getAuthorizedLibraryIds(null)) : this.referentialRepository.findAllSeriesReleaseDates(principal.getUser().getAuthorizedLibraryIds(null)));
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LocalDate localDate = (LocalDate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(String.valueOf(it.getYear()));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private static final AuthorDto getAuthors$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (AuthorDto)$tmp0.invoke(p0);
    }
}

