/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.rest;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.infrastructure.security.KomgaPrincipal;
import org.gotson.komga.interfaces.api.rest.dto.GithubReleaseDto;
import org.gotson.komga.interfaces.api.rest.dto.ReleaseDto;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.util.UriBuilder;

@RestController
@PreAuthorize(value="hasRole('ADMIN')")
@RequestMapping(value={"api/v1/releases"}, produces={"application/json"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u0016J\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\t2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017Rf\u0010\u0005\u001aZ\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\n \b*\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\t \b*,\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\n \b*\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\t\u0018\u00010\u00060\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/gotson/komga/interfaces/api/rest/ReleaseController;", "", "webClientBuilder", "Lorg/springframework/web/reactive/function/client/WebClient$Builder;", "(Lorg/springframework/web/reactive/function/client/WebClient$Builder;)V", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "kotlin.jvm.PlatformType", "", "Lorg/gotson/komga/interfaces/api/rest/dto/GithubReleaseDto;", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "fetchGitHubReleases", "getAnnouncements", "Lorg/gotson/komga/interfaces/api/rest/dto/ReleaseDto;", "principal", "Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;", "komga"})
@SourceDebugExtension(value={"SMAP\nReleaseController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReleaseController.kt\norg/gotson/komga/interfaces/api/rest/ReleaseController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1559#2:70\n1590#2,4:71\n*S KotlinDebug\n*F\n+ 1 ReleaseController.kt\norg/gotson/komga/interfaces/api/rest/ReleaseController\n*L\n44#1:70\n44#1:71,4\n*E\n"})
public class ReleaseController {
    @NotNull
    private final WebClient webClient;
    private final Cache<String, List<GithubReleaseDto>> cache;

    public ReleaseController(@NotNull WebClient.Builder webClientBuilder) {
        Intrinsics.checkNotNullParameter((Object)webClientBuilder, (String)"webClientBuilder");
        WebClient webClient = webClientBuilder.baseUrl("https://api.github.com/repos/gotson/komga/releases").build();
        Intrinsics.checkNotNullExpressionValue((Object)webClient, (String)"build(...)");
        this.webClient = webClient;
        this.cache = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.DAYS).build();
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping
    @PreAuthorize(value="hasRole('ADMIN')")
    @NotNull
    public List<ReleaseDto> getAnnouncements(@AuthenticationPrincipal @NotNull KomgaPrincipal principal) {
        Collection destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        List list = (List)this.cache.get((Object)"releases", arg_0 -> ReleaseController.getAnnouncements$lambda$0((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        if (list != null) {
            void $this$mapIndexedTo$iv$iv;
            List releases = list;
            boolean bl = false;
            Iterable $this$mapIndexed$iv = releases;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index;
                void ghRel;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                GithubReleaseDto githubReleaseDto = (GithubReleaseDto)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new ReleaseDto(ghRel.getTagName(), ghRel.getPublishedAt(), ghRel.getHtmlUrl(), index == false, ghRel.getPrerelease(), ghRel.getBody()));
            }
        } else {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public List<GithubReleaseDto> fetchGitHubReleases() {
        ResponseEntity response2;
        ResponseEntity responseEntity = response2 = (ResponseEntity)this.webClient.get().uri(ReleaseController::fetchGitHubReleases$lambda$3).retrieve().toEntity((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).block();
        return responseEntity != null ? (List)responseEntity.getBody() : null;
    }

    private static final List getAnnouncements$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    private static final URI fetchGitHubReleases$lambda$3(UriBuilder it) {
        Object[] objectArray = new Object[]{20};
        return it.queryParam("per_page", objectArray).build(new Object[0]);
    }
}

