/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.Valid;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.IOUtils;
import org.gotson.komga.application.tasks.TaskEmitter;
import org.gotson.komga.domain.model.AlternateTitle;
import org.gotson.komga.domain.model.Author;
import org.gotson.komga.domain.model.Book;
import org.gotson.komga.domain.model.BookSearch;
import org.gotson.komga.domain.model.Dimension;
import org.gotson.komga.domain.model.DomainEvent;
import org.gotson.komga.domain.model.KomgaUser;
import org.gotson.komga.domain.model.MarkSelectedPreference;
import org.gotson.komga.domain.model.Media;
import org.gotson.komga.domain.model.ReadStatus;
import org.gotson.komga.domain.model.SearchCondition;
import org.gotson.komga.domain.model.SearchContext;
import org.gotson.komga.domain.model.SearchField;
import org.gotson.komga.domain.model.SearchOperator;
import org.gotson.komga.domain.model.Series;
import org.gotson.komga.domain.model.SeriesCollection;
import org.gotson.komga.domain.model.SeriesMetadata;
import org.gotson.komga.domain.model.SeriesSearch;
import org.gotson.komga.domain.model.ThumbnailSeries;
import org.gotson.komga.domain.model.WebLink;
import org.gotson.komga.domain.persistence.BookRepository;
import org.gotson.komga.domain.persistence.SeriesCollectionRepository;
import org.gotson.komga.domain.persistence.SeriesMetadataRepository;
import org.gotson.komga.domain.persistence.SeriesRepository;
import org.gotson.komga.domain.persistence.ThumbnailSeriesRepository;
import org.gotson.komga.domain.service.BookLifecycle;
import org.gotson.komga.domain.service.SeriesLifecycle;
import org.gotson.komga.infrastructure.image.ImageAnalyzer;
import org.gotson.komga.infrastructure.jooq.UnpagedSorted;
import org.gotson.komga.infrastructure.mediacontainer.ContentDetector;
import org.gotson.komga.infrastructure.security.KomgaPrincipal;
import org.gotson.komga.infrastructure.swagger.AuthorsAsQueryParam;
import org.gotson.komga.infrastructure.swagger.PageableAsQueryParam;
import org.gotson.komga.infrastructure.swagger.PageableWithoutSortAsQueryParam;
import org.gotson.komga.infrastructure.web.Authors;
import org.gotson.komga.infrastructure.web.DelimitedPair;
import org.gotson.komga.interfaces.api.ContentRestrictionChecker;
import org.gotson.komga.interfaces.api.persistence.BookDtoRepository;
import org.gotson.komga.interfaces.api.persistence.ReadProgressDtoRepository;
import org.gotson.komga.interfaces.api.persistence.SeriesDtoRepository;
import org.gotson.komga.interfaces.api.rest.SeriesControllerKt;
import org.gotson.komga.interfaces.api.rest.dto.AlternateTitleUpdateDto;
import org.gotson.komga.interfaces.api.rest.dto.BookDto;
import org.gotson.komga.interfaces.api.rest.dto.CollectionDto;
import org.gotson.komga.interfaces.api.rest.dto.CollectionDtoKt;
import org.gotson.komga.interfaces.api.rest.dto.GroupCountDto;
import org.gotson.komga.interfaces.api.rest.dto.ReadProgressDto;
import org.gotson.komga.interfaces.api.rest.dto.SeriesDto;
import org.gotson.komga.interfaces.api.rest.dto.SeriesDtoKt;
import org.gotson.komga.interfaces.api.rest.dto.SeriesMetadataUpdateDto;
import org.gotson.komga.interfaces.api.rest.dto.TachiyomiReadProgressUpdateV2Dto;
import org.gotson.komga.interfaces.api.rest.dto.TachiyomiReadProgressV2Dto;
import org.gotson.komga.interfaces.api.rest.dto.ThumbnailSeriesDto;
import org.gotson.komga.interfaces.api.rest.dto.ThumbnailSeriesDtoKt;
import org.gotson.komga.interfaces.api.rest.dto.WebLinkUpdateDto;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.io.FileSystemResource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@RestController
@RequestMapping(value={"api"}, produces={"application/json"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B}\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\u0002\u0010 J\u0012\u0010!\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020$H\u0017J\u0012\u0010%\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020$H\u0017J\u001c\u0010&\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020$2\b\b\u0001\u0010'\u001a\u00020$H\u0017J\u008f\u0001\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010#\u001a\u00020$2\u0010\b\u0003\u0010-\u001a\n\u0012\u0004\u0012\u00020/\u0018\u00010.2\u0010\b\u0003\u00100\u001a\n\u0012\u0004\u0012\u000201\u0018\u00010.2\u0010\b\u0003\u00102\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\n\b\u0003\u00103\u001a\u0004\u0018\u0001042\b\b\u0003\u00105\u001a\u0002042\u0010\b\u0003\u00106\u001a\n\u0012\u0004\u0012\u000207\u0018\u00010.2\b\b\u0001\u00108\u001a\u000209H\u0017\u00a2\u0006\u0002\u0010:J\"\u0010;\u001a\b\u0012\u0004\u0012\u00020<0.2\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010#\u001a\u00020$H\u0017J\u00d1\u0002\u0010=\u001a\b\u0012\u0004\u0012\u00020>0)2\b\b\u0001\u0010+\u001a\u00020,2\n\b\u0003\u0010?\u001a\u0004\u0018\u00010$2\u0016\b\u0003\u0010@\u001a\u0010\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020$\u0018\u00010A2\u0010\b\u0003\u0010B\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0003\u0010C\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0003\u0010D\u001a\n\u0012\u0004\u0012\u00020E\u0018\u00010.2\u0010\b\u0003\u00100\u001a\n\u0012\u0004\u0012\u000201\u0018\u00010.2\u0010\b\u0003\u0010F\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0003\u0010G\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0003\u0010H\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0003\u00102\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0003\u0010I\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0003\u0010J\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0003\u0010K\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\n\b\u0003\u00103\u001a\u0004\u0018\u0001042\n\b\u0003\u0010L\u001a\u0004\u0018\u0001042\n\b\u0003\u0010M\u001a\u0004\u0018\u0001042\b\b\u0003\u00105\u001a\u0002042\u0010\b\u0003\u00106\u001a\n\u0012\u0004\u0012\u000207\u0018\u00010.2\b\b\u0001\u00108\u001a\u000209H\u0017\u00a2\u0006\u0002\u0010NJ\u00c7\u0002\u0010O\u001a\b\u0012\u0004\u0012\u00020P0.2\b\b\u0001\u0010+\u001a\u00020,2\n\b\u0001\u0010?\u001a\u0004\u0018\u00010$2\u0016\b\u0001\u0010@\u001a\u0010\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020$\u0018\u00010A2\u0010\b\u0001\u0010B\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0001\u0010C\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0001\u0010D\u001a\n\u0012\u0004\u0012\u00020E\u0018\u00010.2\u0010\b\u0001\u00100\u001a\n\u0012\u0004\u0012\u000201\u0018\u00010.2\u0010\b\u0001\u0010F\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0001\u0010G\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0001\u0010H\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0001\u00102\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0001\u0010I\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0001\u0010J\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\u0010\b\u0003\u0010K\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\n\b\u0001\u00103\u001a\u0004\u0018\u0001042\n\b\u0001\u0010L\u001a\u0004\u0018\u0001042\n\b\u0003\u0010M\u001a\u0004\u0018\u0001042\u0010\b\u0001\u00106\u001a\n\u0012\u0004\u0012\u000207\u0018\u00010.2\b\b\u0001\u00108\u001a\u000209H\u0017\u00a2\u0006\u0002\u0010QJ[\u0010R\u001a\b\u0012\u0004\u0012\u00020>0)2\b\b\u0001\u0010+\u001a\u00020,2\u0010\b\u0001\u0010B\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\n\b\u0001\u00103\u001a\u0004\u0018\u0001042\n\b\u0003\u0010M\u001a\u0004\u0018\u0001042\b\b\u0003\u00105\u001a\u0002042\b\b\u0001\u00108\u001a\u000209H\u0017\u00a2\u0006\u0002\u0010SJ[\u0010T\u001a\b\u0012\u0004\u0012\u00020>0)2\b\b\u0001\u0010+\u001a\u00020,2\u0010\b\u0003\u0010B\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\n\b\u0003\u00103\u001a\u0004\u0018\u0001042\n\b\u0003\u0010M\u001a\u0004\u0018\u0001042\b\b\u0003\u00105\u001a\u0002042\b\b\u0001\u00108\u001a\u000209H\u0017\u00a2\u0006\u0002\u0010SJ\u001c\u0010U\u001a\u00020>2\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010V\u001a\u00020$H\u0017J\u001c\u0010W\u001a\u00020X2\b\b\u0001\u0010#\u001a\u00020$2\b\b\u0001\u0010+\u001a\u00020,H\u0017J\u001c\u0010Y\u001a\u00020Z2\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010#\u001a\u00020$H\u0017J\"\u0010[\u001a\b\u0012\u0004\u0012\u00020]0\\2\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010#\u001a\u00020$H\u0017J6\u0010^\u001a\b\u0012\u0004\u0012\u00020>0)2\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010_\u001a\u00020`2\b\b\u0003\u00105\u001a\u0002042\b\b\u0001\u00108\u001a\u000209H\u0017J\"\u0010a\u001a\b\u0012\u0004\u0012\u00020P0.2\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010_\u001a\u00020`H\u0017J&\u0010b\u001a\u00020Z2\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010#\u001a\u00020$2\b\b\u0001\u0010'\u001a\u00020$H\u0017J\"\u0010c\u001a\b\u0012\u0004\u0012\u00020e0d2\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010#\u001a\u00020$H\u0017J[\u0010f\u001a\b\u0012\u0004\u0012\u00020>0)2\b\b\u0001\u0010+\u001a\u00020,2\u0010\b\u0003\u0010B\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010.2\n\b\u0003\u00103\u001a\u0004\u0018\u0001042\n\b\u0003\u0010M\u001a\u0004\u0018\u0001042\b\b\u0003\u00105\u001a\u0002042\b\b\u0001\u00108\u001a\u000209H\u0017\u00a2\u0006\u0002\u0010SJ\u001c\u0010g\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020$2\b\b\u0001\u0010+\u001a\u00020,H\u0017J\u001c\u0010h\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020$2\b\b\u0001\u0010+\u001a\u00020,H\u0017J&\u0010i\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020$2\b\b\u0001\u0010j\u001a\u00020k2\b\b\u0001\u0010+\u001a\u00020,H\u0017J\u001c\u0010l\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020$2\b\b\u0001\u0010'\u001a\u00020$H\u0017J&\u0010m\u001a\u00020e2\b\b\u0001\u0010#\u001a\u00020$2\b\b\u0001\u0010n\u001a\u00020o2\b\b\u0003\u0010p\u001a\u000204H\u0017J\u0012\u0010q\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020$H\u0017J&\u0010r\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020$2\b\b\u0001\u0010s\u001a\u00020t2\b\b\u0001\u0010+\u001a\u00020,H\u0017J\u0014\u0010u\u001a\u00020\"*\u00020v2\u0006\u0010#\u001a\u00020$H\u0012R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006w"}, d2={"Lorg/gotson/komga/interfaces/api/rest/SeriesController;", "", "taskEmitter", "Lorg/gotson/komga/application/tasks/TaskEmitter;", "seriesRepository", "Lorg/gotson/komga/domain/persistence/SeriesRepository;", "seriesLifecycle", "Lorg/gotson/komga/domain/service/SeriesLifecycle;", "seriesMetadataRepository", "Lorg/gotson/komga/domain/persistence/SeriesMetadataRepository;", "seriesDtoRepository", "Lorg/gotson/komga/interfaces/api/persistence/SeriesDtoRepository;", "bookLifecycle", "Lorg/gotson/komga/domain/service/BookLifecycle;", "bookRepository", "Lorg/gotson/komga/domain/persistence/BookRepository;", "bookDtoRepository", "Lorg/gotson/komga/interfaces/api/persistence/BookDtoRepository;", "collectionRepository", "Lorg/gotson/komga/domain/persistence/SeriesCollectionRepository;", "readProgressDtoRepository", "Lorg/gotson/komga/interfaces/api/persistence/ReadProgressDtoRepository;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "contentDetector", "Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;", "imageAnalyzer", "Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;", "thumbnailsSeriesRepository", "Lorg/gotson/komga/domain/persistence/ThumbnailSeriesRepository;", "contentRestrictionChecker", "Lorg/gotson/komga/interfaces/api/ContentRestrictionChecker;", "(Lorg/gotson/komga/application/tasks/TaskEmitter;Lorg/gotson/komga/domain/persistence/SeriesRepository;Lorg/gotson/komga/domain/service/SeriesLifecycle;Lorg/gotson/komga/domain/persistence/SeriesMetadataRepository;Lorg/gotson/komga/interfaces/api/persistence/SeriesDtoRepository;Lorg/gotson/komga/domain/service/BookLifecycle;Lorg/gotson/komga/domain/persistence/BookRepository;Lorg/gotson/komga/interfaces/api/persistence/BookDtoRepository;Lorg/gotson/komga/domain/persistence/SeriesCollectionRepository;Lorg/gotson/komga/interfaces/api/persistence/ReadProgressDtoRepository;Lorg/springframework/context/ApplicationEventPublisher;Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;Lorg/gotson/komga/domain/persistence/ThumbnailSeriesRepository;Lorg/gotson/komga/interfaces/api/ContentRestrictionChecker;)V", "analyze", "", "seriesId", "", "deleteSeries", "deleteUserUploadedSeriesThumbnail", "thumbnailId", "getAllBooksBySeries", "Lorg/springframework/data/domain/Page;", "Lorg/gotson/komga/interfaces/api/rest/dto/BookDto;", "principal", "Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;", "mediaStatus", "", "Lorg/gotson/komga/domain/model/Media$Status;", "readStatus", "Lorg/gotson/komga/domain/model/ReadStatus;", "tags", "deleted", "", "unpaged", "authors", "Lorg/gotson/komga/domain/model/Author;", "page", "Lorg/springframework/data/domain/Pageable;", "(Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/lang/Boolean;ZLjava/util/List;Lorg/springframework/data/domain/Pageable;)Lorg/springframework/data/domain/Page;", "getAllCollectionsBySeries", "Lorg/gotson/komga/interfaces/api/rest/dto/CollectionDto;", "getAllSeries", "Lorg/gotson/komga/interfaces/api/rest/dto/SeriesDto;", "searchTerm", "searchRegex", "Lkotlin/Pair;", "libraryIds", "collectionIds", "metadataStatus", "Lorg/gotson/komga/domain/model/SeriesMetadata$Status;", "publishers", "languages", "genres", "ageRatings", "releaseYears", "sharingLabels", "complete", "oneshot", "(Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;Ljava/lang/String;Lkotlin/Pair;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;ZLjava/util/List;Lorg/springframework/data/domain/Pageable;)Lorg/springframework/data/domain/Page;", "getAlphabeticalGroups", "Lorg/gotson/komga/interfaces/api/rest/dto/GroupCountDto;", "(Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;Ljava/lang/String;Lkotlin/Pair;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/util/List;Lorg/springframework/data/domain/Pageable;)Ljava/util/List;", "getLatestSeries", "(Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;Ljava/util/List;Ljava/lang/Boolean;Ljava/lang/Boolean;ZLorg/springframework/data/domain/Pageable;)Lorg/springframework/data/domain/Page;", "getNewSeries", "getOneSeries", "id", "getReadProgressTachiyomiV2", "Lorg/gotson/komga/interfaces/api/rest/dto/TachiyomiReadProgressV2Dto;", "getSeriesDefaultThumbnail", "", "getSeriesFile", "Lorg/springframework/http/ResponseEntity;", "Lorg/springframework/web/servlet/mvc/method/annotation/StreamingResponseBody;", "getSeriesList", "search", "Lorg/gotson/komga/domain/model/SeriesSearch;", "getSeriesListByAlphabeticalGroups", "getSeriesThumbnailById", "getSeriesThumbnails", "", "Lorg/gotson/komga/interfaces/api/rest/dto/ThumbnailSeriesDto;", "getUpdatedSeries", "markAsRead", "markAsUnread", "markReadProgressTachiyomiV2", "readProgress", "Lorg/gotson/komga/interfaces/api/rest/dto/TachiyomiReadProgressUpdateV2Dto;", "postMarkSelectedSeriesThumbnail", "postUserUploadedSeriesThumbnail", "file", "Lorg/springframework/web/multipart/MultipartFile;", "selected", "refreshMetadata", "updateMetadata", "newMetadata", "Lorg/gotson/komga/interfaces/api/rest/dto/SeriesMetadataUpdateDto;", "checkContentRestriction", "Lorg/gotson/komga/domain/model/KomgaUser;", "komga"})
@SourceDebugExtension(value={"SMAP\nSeriesController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeriesController.kt\norg/gotson/komga/interfaces/api/rest/SeriesController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,859:1\n1549#2:860\n1620#2,3:861\n1549#2:864\n1620#2,3:865\n1549#2:868\n1620#2,3:869\n1549#2:872\n1620#2,3:873\n1549#2:876\n1620#2,3:877\n1549#2:880\n1620#2,3:881\n1549#2:884\n1620#2,3:885\n1549#2:888\n1620#2,3:889\n1549#2:892\n1620#2,3:893\n1549#2:896\n1620#2,2:897\n1622#2:900\n1603#2,9:901\n1855#2:910\n1856#2:912\n1612#2:913\n1549#2:914\n1620#2,3:915\n1549#2:918\n1620#2,3:919\n1549#2:922\n1620#2,3:923\n1549#2:926\n1620#2,3:927\n1549#2:930\n1620#2,3:931\n1549#2:934\n1620#2,3:935\n1549#2:938\n1620#2,3:939\n1549#2:942\n1620#2,3:943\n1549#2:946\n1620#2,3:947\n1549#2:950\n1620#2,3:951\n1549#2:954\n1620#2,3:955\n1549#2:958\n1620#2,3:959\n1603#2,9:962\n1855#2:971\n1856#2:973\n1612#2:974\n1549#2:975\n1620#2,3:976\n1549#2:979\n1620#2,3:980\n1549#2:983\n1620#2,3:984\n1549#2:987\n1620#2,3:988\n1549#2:991\n1620#2,3:992\n1549#2:995\n1620#2,3:996\n1549#2:999\n1620#2,3:1000\n1549#2:1003\n1620#2,3:1004\n1549#2:1007\n1620#2,3:1008\n1549#2:1011\n1620#2,3:1012\n1549#2:1015\n1620#2,3:1016\n1549#2:1019\n1620#2,3:1020\n1549#2:1023\n1620#2,3:1024\n766#2:1027\n857#2,2:1028\n1855#2,2:1030\n1855#2,2:1032\n1#3:899\n1#3:911\n1#3:972\n*S KotlinDebug\n*F\n+ 1 SeriesController.kt\norg/gotson/komga/interfaces/api/rest/SeriesController\n*L\n182#1:860\n182#1:861,3\n183#1:864\n183#1:865,3\n184#1:868\n184#1:869,3\n185#1:872\n185#1:873,3\n186#1:876\n186#1:877,3\n187#1:880\n187#1:881,3\n188#1:884\n188#1:885,3\n189#1:888\n189#1:889,3\n190#1:892\n190#1:893,3\n191#1:896\n191#1:897,2\n191#1:900\n195#1:901,9\n195#1:910\n195#1:912\n195#1:913\n195#1:914\n195#1:915,3\n204#1:918\n204#1:919,3\n295#1:922\n295#1:923,3\n296#1:926\n296#1:927,3\n297#1:930\n297#1:931,3\n298#1:934\n298#1:935,3\n299#1:938\n299#1:939,3\n300#1:942\n300#1:943,3\n301#1:946\n301#1:947,3\n302#1:950\n302#1:951,3\n303#1:954\n303#1:955,3\n304#1:958\n304#1:959,3\n308#1:962,9\n308#1:971\n308#1:973\n308#1:974\n308#1:975\n308#1:976,3\n317#1:979\n317#1:980,3\n371#1:983\n371#1:984,3\n410#1:987\n410#1:988,3\n449#1:991\n449#1:992,3\n504#1:995\n504#1:996,3\n603#1:999\n603#1:1000,3\n604#1:1003\n604#1:1004,3\n605#1:1007\n605#1:1008,3\n606#1:1011\n606#1:1012,3\n628#1:1015\n628#1:1016,3\n707#1:1019\n707#1:1020,3\n714#1:1023\n714#1:1024,3\n775#1:1027\n775#1:1028,2\n776#1:1030,2\n798#1:1032,2\n195#1:911\n308#1:972\n*E\n"})
public class SeriesController {
    @NotNull
    private final TaskEmitter taskEmitter;
    @NotNull
    private final SeriesRepository seriesRepository;
    @NotNull
    private final SeriesLifecycle seriesLifecycle;
    @NotNull
    private final SeriesMetadataRepository seriesMetadataRepository;
    @NotNull
    private final SeriesDtoRepository seriesDtoRepository;
    @NotNull
    private final BookLifecycle bookLifecycle;
    @NotNull
    private final BookRepository bookRepository;
    @NotNull
    private final BookDtoRepository bookDtoRepository;
    @NotNull
    private final SeriesCollectionRepository collectionRepository;
    @NotNull
    private final ReadProgressDtoRepository readProgressDtoRepository;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private final ContentDetector contentDetector;
    @NotNull
    private final ImageAnalyzer imageAnalyzer;
    @NotNull
    private final ThumbnailSeriesRepository thumbnailsSeriesRepository;
    @NotNull
    private final ContentRestrictionChecker contentRestrictionChecker;

    public SeriesController(@NotNull TaskEmitter taskEmitter, @NotNull SeriesRepository seriesRepository, @NotNull SeriesLifecycle seriesLifecycle, @NotNull SeriesMetadataRepository seriesMetadataRepository, @NotNull SeriesDtoRepository seriesDtoRepository, @NotNull BookLifecycle bookLifecycle, @NotNull BookRepository bookRepository, @NotNull BookDtoRepository bookDtoRepository, @NotNull SeriesCollectionRepository collectionRepository, @NotNull ReadProgressDtoRepository readProgressDtoRepository, @NotNull ApplicationEventPublisher eventPublisher, @NotNull ContentDetector contentDetector, @NotNull ImageAnalyzer imageAnalyzer, @NotNull ThumbnailSeriesRepository thumbnailsSeriesRepository, @NotNull ContentRestrictionChecker contentRestrictionChecker) {
        Intrinsics.checkNotNullParameter((Object)taskEmitter, (String)"taskEmitter");
        Intrinsics.checkNotNullParameter((Object)seriesRepository, (String)"seriesRepository");
        Intrinsics.checkNotNullParameter((Object)seriesLifecycle, (String)"seriesLifecycle");
        Intrinsics.checkNotNullParameter((Object)seriesMetadataRepository, (String)"seriesMetadataRepository");
        Intrinsics.checkNotNullParameter((Object)seriesDtoRepository, (String)"seriesDtoRepository");
        Intrinsics.checkNotNullParameter((Object)bookLifecycle, (String)"bookLifecycle");
        Intrinsics.checkNotNullParameter((Object)bookRepository, (String)"bookRepository");
        Intrinsics.checkNotNullParameter((Object)bookDtoRepository, (String)"bookDtoRepository");
        Intrinsics.checkNotNullParameter((Object)collectionRepository, (String)"collectionRepository");
        Intrinsics.checkNotNullParameter((Object)readProgressDtoRepository, (String)"readProgressDtoRepository");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)contentDetector, (String)"contentDetector");
        Intrinsics.checkNotNullParameter((Object)imageAnalyzer, (String)"imageAnalyzer");
        Intrinsics.checkNotNullParameter((Object)thumbnailsSeriesRepository, (String)"thumbnailsSeriesRepository");
        Intrinsics.checkNotNullParameter((Object)contentRestrictionChecker, (String)"contentRestrictionChecker");
        this.taskEmitter = taskEmitter;
        this.seriesRepository = seriesRepository;
        this.seriesLifecycle = seriesLifecycle;
        this.seriesMetadataRepository = seriesMetadataRepository;
        this.seriesDtoRepository = seriesDtoRepository;
        this.bookLifecycle = bookLifecycle;
        this.bookRepository = bookRepository;
        this.bookDtoRepository = bookDtoRepository;
        this.collectionRepository = collectionRepository;
        this.readProgressDtoRepository = readProgressDtoRepository;
        this.eventPublisher = eventPublisher;
        this.contentDetector = contentDetector;
        this.imageAnalyzer = imageAnalyzer;
        this.thumbnailsSeriesRepository = thumbnailsSeriesRepository;
        this.contentRestrictionChecker = contentRestrictionChecker;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="use /v1/series/list instead")
    @PageableAsQueryParam
    @AuthorsAsQueryParam
    @Parameters(value={@Parameter(name="search_regex", in=ParameterIn.QUERY, description="Search by regex criteria, in the form: regex,field. Supported fields are TITLE and TITLE_SORT.", schema=@Schema(type="string"))})
    @GetMapping(value={"v1/series"})
    @NotNull
    public Page<SeriesDto> getAllSeries(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="search", required=false) @Nullable String searchTerm, @Parameter(hidden=true) @DelimitedPair(parameterName="search_regex") @Nullable Pair<String, String> searchRegex, @RequestParam(name="library_id", required=false) @Nullable List<String> libraryIds, @RequestParam(name="collection_id", required=false) @Nullable List<String> collectionIds, @RequestParam(name="status", required=false) @Nullable List<? extends SeriesMetadata.Status> metadataStatus, @RequestParam(name="read_status", required=false) @Nullable List<? extends ReadStatus> readStatus, @RequestParam(name="publisher", required=false) @Nullable List<String> publishers, @RequestParam(name="language", required=false) @Nullable List<String> languages2, @RequestParam(name="genre", required=false) @Nullable List<String> genres, @RequestParam(name="tag", required=false) @Nullable List<String> tags, @RequestParam(name="age_rating", required=false) @Nullable List<String> ageRatings, @RequestParam(name="release_year", required=false) @Nullable List<String> releaseYears, @RequestParam(name="sharing_label", required=false) @Nullable List<String> sharingLabels, @RequestParam(name="deleted", required=false) @Nullable Boolean deleted, @RequestParam(name="complete", required=false) @Nullable Boolean complete, @RequestParam(name="oneshot", required=false) @Nullable Boolean oneshot, @RequestParam(name="unpaged", required=false) boolean unpaged, @Parameter(hidden=true) @Authors @Nullable List<Author> authors, @Parameter(hidden=true) @NotNull Pageable page) {
        Pair pair;
        boolean it;
        Object it2;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        Iterable $this$map$iv;
        boolean $i$f$map;
        Pair<String, String> pair2;
        Pair<String, String> pair3;
        Pageable pageable;
        Sort sort;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        if (page.getSort().isSorted()) {
            sort = page.getSort();
        } else {
            String[] stringArray = (String[])searchTerm;
            if (!(stringArray == null || StringsKt.isBlank((CharSequence)stringArray))) {
                stringArray = new String[]{"relevance"};
                sort = Sort.by((String[])stringArray);
            } else {
                sort = Sort.unsorted();
            }
        }
        Sort sort2 = sort;
        Intrinsics.checkNotNull((Object)sort2);
        Sort sort3 = sort2;
        if (unpaged) {
            pageable = (Pageable)new UnpagedSorted(sort3);
        } else {
            PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)sort3);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            pageable = (Pageable)pageRequest;
        }
        Pageable pageRequest = pageable;
        Pair<String, String> $this$getAllSeries_u24lambda_u2417 = pair3 = CollectionsKt.createListBuilder();
        boolean bl = false;
        Object object = libraryIds;
        if (!(object == null || object.isEmpty())) {
            object = libraryIds;
            pair2 = $this$getAllSeries_u24lambda_u2417;
            $i$f$map = false;
            Collection collection2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new SearchCondition.LibraryId((SearchOperator.Equality)new SearchOperator.Is(it2)));
            }
            List list = (List)destination$iv$iv;
            pair2.add(new SearchCondition.AnyOfSeries(list));
        }
        if (!(($this$map$iv = (Collection)collectionIds) == null || $this$map$iv.isEmpty())) {
            $this$map$iv = collectionIds;
            pair2 = $this$getAllSeries_u24lambda_u2417;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(new SearchCondition.CollectionId((SearchOperator.Equality)new SearchOperator.Is(it2)));
            }
            List list = (List)destination$iv$iv;
            pair2.add(new SearchCondition.AnyOfSeries(list));
        }
        if (!(($this$map$iv = (Collection)metadataStatus) == null || $this$map$iv.isEmpty())) {
            $this$map$iv = metadataStatus;
            pair2 = $this$getAllSeries_u24lambda_u2417;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (SeriesMetadata.Status)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(new SearchCondition.SeriesStatus((SearchOperator.Equality)new SearchOperator.Is(it2)));
            }
            List list = (List)destination$iv$iv;
            pair2.add(new SearchCondition.AnyOfSeries(list));
        }
        if (!(($this$map$iv = (Collection)publishers) == null || $this$map$iv.isEmpty())) {
            $this$map$iv = publishers;
            pair2 = $this$getAllSeries_u24lambda_u2417;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl5 = false;
                collection.add(new SearchCondition.Publisher((SearchOperator.Equality)new SearchOperator.Is(it2)));
            }
            List list = (List)destination$iv$iv;
            pair2.add(new SearchCondition.AnyOfSeries(list));
        }
        if (!(($this$map$iv = (Collection)languages2) == null || $this$map$iv.isEmpty())) {
            $this$map$iv = languages2;
            pair2 = $this$getAllSeries_u24lambda_u2417;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl6 = false;
                collection.add(new SearchCondition.Language((SearchOperator.Equality)new SearchOperator.Is(it2)));
            }
            List list = (List)destination$iv$iv;
            pair2.add(new SearchCondition.AnyOfSeries(list));
        }
        if (!(($this$map$iv = (Collection)genres) == null || $this$map$iv.isEmpty())) {
            $this$map$iv = genres;
            pair2 = $this$getAllSeries_u24lambda_u2417;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl7 = false;
                collection.add(new SearchCondition.Genre((SearchOperator.Equality)new SearchOperator.Is(it2)));
            }
            List list = (List)destination$iv$iv;
            pair2.add(new SearchCondition.AnyOfSeries(list));
        }
        if (!(($this$map$iv = (Collection)tags) == null || $this$map$iv.isEmpty())) {
            $this$map$iv = tags;
            pair2 = $this$getAllSeries_u24lambda_u2417;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl8 = false;
                collection.add(new SearchCondition.Tag((SearchOperator.Equality)new SearchOperator.Is(it2)));
            }
            List list = (List)destination$iv$iv;
            pair2.add(new SearchCondition.AnyOfSeries(list));
        }
        if (!(($this$map$iv = (Collection)readStatus) == null || $this$map$iv.isEmpty())) {
            $this$map$iv = readStatus;
            pair2 = $this$getAllSeries_u24lambda_u2417;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (ReadStatus)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl9 = false;
                collection.add(new SearchCondition.ReadStatus((SearchOperator.Equality)new SearchOperator.Is(it2)));
            }
            List list = (List)destination$iv$iv;
            pair2.add(new SearchCondition.AnyOfSeries(list));
        }
        if (!(($this$map$iv = (Collection)authors) == null || $this$map$iv.isEmpty())) {
            $this$map$iv = authors;
            pair2 = $this$getAllSeries_u24lambda_u2417;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (Author)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl10 = false;
                collection.add(new SearchCondition.Author((SearchOperator.Equality)new SearchOperator.Is((Object)new SearchCondition.AuthorMatch(it2.getName(), it2.getRole()))));
            }
            List list = (List)destination$iv$iv;
            pair2.add(new SearchCondition.AnyOfSeries(list));
        }
        if (!(($this$map$iv = (Collection)ageRatings) == null || $this$map$iv.isEmpty())) {
            $this$map$iv = ageRatings;
            pair2 = $this$getAllSeries_u24lambda_u2417;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                SearchCondition.AgeRating ageRating;
                it2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl11 = false;
                Integer n = StringsKt.toIntOrNull((String)it2);
                if (n != null) {
                    int ageRating2 = ((Number)n).intValue();
                    boolean bl12 = false;
                    ageRating = new SearchCondition.AgeRating((SearchOperator.NumericNullable)new SearchOperator.Is((Object)ageRating2));
                } else {
                    ageRating = new SearchCondition.AgeRating((SearchOperator.NumericNullable)new SearchOperator.IsNullT());
                }
                collection.add(ageRating);
            }
            List list = (List)destination$iv$iv;
            pair2.add(new SearchCondition.AnyOfSeries(list));
        }
        if (!(($this$map$iv = (Collection)releaseYears) == null || $this$map$iv.isEmpty())) {
            Iterable $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            $this$map$iv = releaseYears;
            pair2 = $this$getAllSeries_u24lambda_u2417;
            boolean $i$f$mapNotNull = false;
            $this$mapTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            it2 = $this$forEach$iv$iv$iv.iterator();
            while (it2.hasNext()) {
                Integer it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = it2.next();
                boolean bl13 = false;
                String it3 = (String)element$iv$iv;
                boolean bl14 = false;
                if (StringsKt.toIntOrNull((String)it3) == null) continue;
                boolean bl15 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void releaseYear;
                int it4 = ((Number)item$iv$iv).intValue();
                collection = destination$iv$iv;
                boolean bl16 = false;
                SearchCondition.Series[] seriesArray = new SearchCondition.Series[2];
                ZonedDateTime zonedDateTime = ZonedDateTime.of((int)(releaseYear - true), 12, 31, 12, 0, 0, 0, ZoneOffset.UTC);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"of(...)");
                seriesArray[0] = new SearchCondition.ReleaseDate((SearchOperator.Date)new SearchOperator.After(zonedDateTime));
                ZonedDateTime zonedDateTime2 = ZonedDateTime.of((int)(releaseYear + true), 1, 1, 12, 0, 0, 0, ZoneOffset.UTC);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"of(...)");
                seriesArray[1] = new SearchCondition.ReleaseDate((SearchOperator.Date)new SearchOperator.Before(zonedDateTime2));
                collection.add(new SearchCondition.AllOfSeries(seriesArray));
            }
            List list = (List)destination$iv$iv;
            pair2.add(new SearchCondition.AnyOfSeries(list));
        }
        if (!(($this$map$iv = (Collection)sharingLabels) == null || $this$map$iv.isEmpty())) {
            $this$map$iv = sharingLabels;
            pair2 = $this$getAllSeries_u24lambda_u2417;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it5;
                String releaseYear = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl17 = false;
                collection.add(new SearchCondition.SharingLabel((SearchOperator.Equality)new SearchOperator.Is((Object)it5)));
            }
            List list = (List)destination$iv$iv;
            pair2.add(new SearchCondition.AnyOfSeries(list));
        }
        Boolean bl18 = oneshot;
        if (bl18 != null) {
            it = bl18;
            boolean bl19 = false;
            v8 = $this$getAllSeries_u24lambda_u2417.add(new SearchCondition.OneShot(it ? (SearchOperator.Boolean)SearchOperator.IsTrue.INSTANCE : (SearchOperator.Boolean)SearchOperator.IsFalse.INSTANCE));
        } else {
            v8 = null;
        }
        Boolean bl20 = complete;
        if (bl20 != null) {
            it = bl20;
            boolean bl21 = false;
            v10 = $this$getAllSeries_u24lambda_u2417.add(new SearchCondition.Complete(it ? (SearchOperator.Boolean)SearchOperator.IsTrue.INSTANCE : (SearchOperator.Boolean)SearchOperator.IsFalse.INSTANCE));
        } else {
            v10 = null;
        }
        Boolean bl22 = deleted;
        if (bl22 != null) {
            it = bl22;
            boolean bl23 = false;
            $this$getAllSeries_u24lambda_u2417.add(new SearchCondition.Deleted(it ? (SearchOperator.Boolean)SearchOperator.IsTrue.INSTANCE : (SearchOperator.Boolean)SearchOperator.IsFalse.INSTANCE));
            v12 = Unit.INSTANCE;
        } else {
            v12 = null;
        }
        List list = CollectionsKt.build((List)pair3);
        SearchCondition.Series series = (SearchCondition.Series)new SearchCondition.AllOfSeries(list);
        String string = searchTerm;
        Pair<String, String> pair4 = searchRegex;
        if (pair4 != null) {
            void it6;
            $this$getAllSeries_u24lambda_u2417 = pair4;
            String string2 = string;
            SearchCondition.Series series2 = series;
            boolean bl24 = false;
            String string3 = ((String)it6.getSecond()).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            object = string3;
            Pair pair5 = Intrinsics.areEqual((Object)object, (Object)"title") ? new Pair(it6.getFirst(), (Object)SearchField.TITLE) : (Intrinsics.areEqual((Object)object, (Object)"title_sort") ? new Pair(it6.getFirst(), (Object)SearchField.TITLE_SORT) : null);
            series = series2;
            string = string2;
            pair = pair5;
        } else {
            pair = null;
        }
        Pair pair6 = pair;
        String string4 = string;
        SearchCondition.Series series3 = series;
        SeriesSearch seriesSearch = new SeriesSearch(series3, string4, pair6);
        Page page2 = this.seriesDtoRepository.findAll(seriesSearch, new SearchContext(principal.getUser()), pageRequest).map(arg_0 -> SeriesController.getAllSeries$lambda$19((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    public static /* synthetic */ Page getAllSeries$default(SeriesController seriesController, KomgaPrincipal komgaPrincipal, String string, Pair pair, List list, List list2, List list3, List list4, List list5, List list6, List list7, List list8, List list9, List list10, List list11, Boolean bl, Boolean bl2, Boolean bl3, boolean bl4, List list12, Pageable pageable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getAllSeries");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            pair = null;
        }
        if ((n & 8) != 0) {
            list = null;
        }
        if ((n & 0x10) != 0) {
            list2 = null;
        }
        if ((n & 0x20) != 0) {
            list3 = null;
        }
        if ((n & 0x40) != 0) {
            list4 = null;
        }
        if ((n & 0x80) != 0) {
            list5 = null;
        }
        if ((n & 0x100) != 0) {
            list6 = null;
        }
        if ((n & 0x200) != 0) {
            list7 = null;
        }
        if ((n & 0x400) != 0) {
            list8 = null;
        }
        if ((n & 0x800) != 0) {
            list9 = null;
        }
        if ((n & 0x1000) != 0) {
            list10 = null;
        }
        if ((n & 0x2000) != 0) {
            list11 = null;
        }
        if ((n & 0x4000) != 0) {
            bl = null;
        }
        if ((n & 0x8000) != 0) {
            bl2 = null;
        }
        if ((n & 0x10000) != 0) {
            bl3 = null;
        }
        if ((n & 0x20000) != 0) {
            bl4 = false;
        }
        if ((n & 0x40000) != 0) {
            list12 = null;
        }
        return seriesController.getAllSeries(komgaPrincipal, string, pair, list, list2, list3, list4, list5, list6, list7, list8, list9, list10, list11, bl, bl2, bl3, bl4, list12, pageable);
    }

    @PageableAsQueryParam
    @PostMapping(value={"v1/series/list"})
    @NotNull
    public Page<SeriesDto> getSeriesList(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestBody @NotNull SeriesSearch search, @RequestParam(name="unpaged", required=false) boolean unpaged, @Parameter(hidden=true) @NotNull Pageable page) {
        Pageable pageable;
        Sort sort;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)search, (String)"search");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        if (page.getSort().isSorted()) {
            sort = page.getSort();
        } else {
            String[] stringArray = (String[])search.getFullTextSearch();
            if (!(stringArray == null || StringsKt.isBlank((CharSequence)stringArray))) {
                stringArray = new String[]{"relevance"};
                sort = Sort.by((String[])stringArray);
            } else {
                sort = Sort.unsorted();
            }
        }
        Sort sort2 = sort;
        Intrinsics.checkNotNull((Object)sort2);
        Sort sort3 = sort2;
        if (unpaged) {
            pageable = (Pageable)new UnpagedSorted(sort3);
        } else {
            PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)sort3);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            pageable = (Pageable)pageRequest;
        }
        Pageable pageRequest = pageable;
        Page page2 = this.seriesDtoRepository.findAll(search, new SearchContext(principal.getUser()), pageRequest).map(arg_0 -> SeriesController.getSeriesList$lambda$20((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    public static /* synthetic */ Page getSeriesList$default(SeriesController seriesController, KomgaPrincipal komgaPrincipal, SeriesSearch seriesSearch, boolean bl, Pageable pageable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getSeriesList");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return seriesController.getSeriesList(komgaPrincipal, seriesSearch, bl, pageable);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="use /v1/series/list/alphabetical-groups instead")
    @AuthorsAsQueryParam
    @Parameters(value={@Parameter(name="search_regex", in=ParameterIn.QUERY, description="Search by regex criteria, in the form: regex,field. Supported fields are TITLE and TITLE_SORT.", schema=@Schema(type="string"))})
    @GetMapping(value={"v1/series/alphabetical-groups"})
    @NotNull
    public List<GroupCountDto> getAlphabeticalGroups(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="search", required=false) @Nullable String searchTerm, @Parameter(hidden=true) @DelimitedPair(parameterName="search_regex") @Nullable Pair<String, String> searchRegex, @RequestParam(name="library_id", required=false) @Nullable List<String> libraryIds, @RequestParam(name="collection_id", required=false) @Nullable List<String> collectionIds, @RequestParam(name="status", required=false) @Nullable List<? extends SeriesMetadata.Status> metadataStatus, @RequestParam(name="read_status", required=false) @Nullable List<? extends ReadStatus> readStatus, @RequestParam(name="publisher", required=false) @Nullable List<String> publishers, @RequestParam(name="language", required=false) @Nullable List<String> languages2, @RequestParam(name="genre", required=false) @Nullable List<String> genres, @RequestParam(name="tag", required=false) @Nullable List<String> tags, @RequestParam(name="age_rating", required=false) @Nullable List<String> ageRatings, @RequestParam(name="release_year", required=false) @Nullable List<String> releaseYears, @RequestParam(name="sharing_label", required=false) @Nullable List<String> sharingLabels, @RequestParam(name="deleted", required=false) @Nullable Boolean deleted, @RequestParam(name="complete", required=false) @Nullable Boolean complete, @RequestParam(name="oneshot", required=false) @Nullable Boolean oneshot, @Parameter(hidden=true) @Authors @Nullable List<Author> authors, @Parameter(hidden=true) @NotNull Pageable page) {
        Pair pair;
        boolean it;
        Object it2;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        Iterable $this$map$iv;
        boolean $i$f$map;
        Pair<String, String> pair2;
        Pair<String, String> pair3;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Pair<String, String> $this$getAlphabeticalGroups_u24lambda_u2438 = pair3 = CollectionsKt.createListBuilder();
        boolean bl = false;
        Object object = libraryIds;
        if (!(object == null || object.isEmpty())) {
            object = libraryIds;
            pair2 = $this$getAlphabeticalGroups_u24lambda_u2438;
            $i$f$map = false;
            Collection collection2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new SearchCondition.LibraryId((SearchOperator.Equality)new SearchOperator.Is(it2)));
            }
            List list = (List)destination$iv$iv;
            pair2.add(new SearchCondition.AnyOfSeries(list));
        }
        if (!(($this$map$iv = (Collection)collectionIds) == null || $this$map$iv.isEmpty())) {
            $this$map$iv = collectionIds;
            pair2 = $this$getAlphabeticalGroups_u24lambda_u2438;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(new SearchCondition.CollectionId((SearchOperator.Equality)new SearchOperator.Is(it2)));
            }
            List list = (List)destination$iv$iv;
            pair2.add(new SearchCondition.AnyOfSeries(list));
        }
        if (!(($this$map$iv = (Collection)metadataStatus) == null || $this$map$iv.isEmpty())) {
            $this$map$iv = metadataStatus;
            pair2 = $this$getAlphabeticalGroups_u24lambda_u2438;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (SeriesMetadata.Status)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(new SearchCondition.SeriesStatus((SearchOperator.Equality)new SearchOperator.Is(it2)));
            }
            List list = (List)destination$iv$iv;
            pair2.add(new SearchCondition.AnyOfSeries(list));
        }
        if (!(($this$map$iv = (Collection)publishers) == null || $this$map$iv.isEmpty())) {
            $this$map$iv = publishers;
            pair2 = $this$getAlphabeticalGroups_u24lambda_u2438;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl5 = false;
                collection.add(new SearchCondition.Publisher((SearchOperator.Equality)new SearchOperator.Is(it2)));
            }
            List list = (List)destination$iv$iv;
            pair2.add(new SearchCondition.AnyOfSeries(list));
        }
        if (!(($this$map$iv = (Collection)languages2) == null || $this$map$iv.isEmpty())) {
            $this$map$iv = languages2;
            pair2 = $this$getAlphabeticalGroups_u24lambda_u2438;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl6 = false;
                collection.add(new SearchCondition.Language((SearchOperator.Equality)new SearchOperator.Is(it2)));
            }
            List list = (List)destination$iv$iv;
            pair2.add(new SearchCondition.AnyOfSeries(list));
        }
        if (!(($this$map$iv = (Collection)genres) == null || $this$map$iv.isEmpty())) {
            $this$map$iv = genres;
            pair2 = $this$getAlphabeticalGroups_u24lambda_u2438;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl7 = false;
                collection.add(new SearchCondition.Genre((SearchOperator.Equality)new SearchOperator.Is(it2)));
            }
            List list = (List)destination$iv$iv;
            pair2.add(new SearchCondition.AnyOfSeries(list));
        }
        if (!(($this$map$iv = (Collection)tags) == null || $this$map$iv.isEmpty())) {
            $this$map$iv = tags;
            pair2 = $this$getAlphabeticalGroups_u24lambda_u2438;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl8 = false;
                collection.add(new SearchCondition.Tag((SearchOperator.Equality)new SearchOperator.Is(it2)));
            }
            List list = (List)destination$iv$iv;
            pair2.add(new SearchCondition.AnyOfSeries(list));
        }
        if (!(($this$map$iv = (Collection)readStatus) == null || $this$map$iv.isEmpty())) {
            $this$map$iv = readStatus;
            pair2 = $this$getAlphabeticalGroups_u24lambda_u2438;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (ReadStatus)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl9 = false;
                collection.add(new SearchCondition.ReadStatus((SearchOperator.Equality)new SearchOperator.Is(it2)));
            }
            List list = (List)destination$iv$iv;
            pair2.add(new SearchCondition.AnyOfSeries(list));
        }
        if (!(($this$map$iv = (Collection)authors) == null || $this$map$iv.isEmpty())) {
            $this$map$iv = authors;
            pair2 = $this$getAlphabeticalGroups_u24lambda_u2438;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (Author)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl10 = false;
                collection.add(new SearchCondition.Author((SearchOperator.Equality)new SearchOperator.Is((Object)new SearchCondition.AuthorMatch(it2.getName(), it2.getRole()))));
            }
            List list = (List)destination$iv$iv;
            pair2.add(new SearchCondition.AnyOfSeries(list));
        }
        if (!(($this$map$iv = (Collection)ageRatings) == null || $this$map$iv.isEmpty())) {
            $this$map$iv = ageRatings;
            pair2 = $this$getAlphabeticalGroups_u24lambda_u2438;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                SearchCondition.AgeRating ageRating;
                it2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl11 = false;
                Integer n = StringsKt.toIntOrNull((String)it2);
                if (n != null) {
                    int ageRating2 = ((Number)n).intValue();
                    boolean bl12 = false;
                    ageRating = new SearchCondition.AgeRating((SearchOperator.NumericNullable)new SearchOperator.Is((Object)ageRating2));
                } else {
                    ageRating = new SearchCondition.AgeRating((SearchOperator.NumericNullable)new SearchOperator.IsNullT());
                }
                collection.add(ageRating);
            }
            List list = (List)destination$iv$iv;
            pair2.add(new SearchCondition.AnyOfSeries(list));
        }
        if (!(($this$map$iv = (Collection)releaseYears) == null || $this$map$iv.isEmpty())) {
            Iterable $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            $this$map$iv = releaseYears;
            pair2 = $this$getAlphabeticalGroups_u24lambda_u2438;
            boolean $i$f$mapNotNull = false;
            $this$mapTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            it2 = $this$forEach$iv$iv$iv.iterator();
            while (it2.hasNext()) {
                Integer it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = it2.next();
                boolean bl13 = false;
                String it3 = (String)element$iv$iv;
                boolean bl14 = false;
                if (StringsKt.toIntOrNull((String)it3) == null) continue;
                boolean bl15 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void releaseYear;
                int it4 = ((Number)item$iv$iv).intValue();
                collection = destination$iv$iv;
                boolean bl16 = false;
                SearchCondition.Series[] seriesArray = new SearchCondition.Series[2];
                ZonedDateTime zonedDateTime = ZonedDateTime.of((int)(releaseYear - true), 12, 31, 12, 0, 0, 0, ZoneOffset.UTC);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"of(...)");
                seriesArray[0] = new SearchCondition.ReleaseDate((SearchOperator.Date)new SearchOperator.After(zonedDateTime));
                ZonedDateTime zonedDateTime2 = ZonedDateTime.of((int)(releaseYear + true), 1, 1, 12, 0, 0, 0, ZoneOffset.UTC);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"of(...)");
                seriesArray[1] = new SearchCondition.ReleaseDate((SearchOperator.Date)new SearchOperator.Before(zonedDateTime2));
                collection.add(new SearchCondition.AllOfSeries(seriesArray));
            }
            List list = (List)destination$iv$iv;
            pair2.add(new SearchCondition.AnyOfSeries(list));
        }
        if (!(($this$map$iv = (Collection)sharingLabels) == null || $this$map$iv.isEmpty())) {
            $this$map$iv = sharingLabels;
            pair2 = $this$getAlphabeticalGroups_u24lambda_u2438;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it5;
                String releaseYear = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl17 = false;
                collection.add(new SearchCondition.SharingLabel((SearchOperator.Equality)new SearchOperator.Is((Object)it5)));
            }
            List list = (List)destination$iv$iv;
            pair2.add(new SearchCondition.AnyOfSeries(list));
        }
        Boolean bl18 = oneshot;
        if (bl18 != null) {
            it = bl18;
            boolean bl19 = false;
            v5 = $this$getAlphabeticalGroups_u24lambda_u2438.add(new SearchCondition.OneShot(it ? (SearchOperator.Boolean)SearchOperator.IsTrue.INSTANCE : (SearchOperator.Boolean)SearchOperator.IsFalse.INSTANCE));
        } else {
            v5 = null;
        }
        Boolean bl20 = complete;
        if (bl20 != null) {
            it = bl20;
            boolean bl21 = false;
            v7 = $this$getAlphabeticalGroups_u24lambda_u2438.add(new SearchCondition.Complete(it ? (SearchOperator.Boolean)SearchOperator.IsTrue.INSTANCE : (SearchOperator.Boolean)SearchOperator.IsFalse.INSTANCE));
        } else {
            v7 = null;
        }
        Boolean bl22 = deleted;
        if (bl22 != null) {
            it = bl22;
            boolean bl23 = false;
            $this$getAlphabeticalGroups_u24lambda_u2438.add(new SearchCondition.Deleted(it ? (SearchOperator.Boolean)SearchOperator.IsTrue.INSTANCE : (SearchOperator.Boolean)SearchOperator.IsFalse.INSTANCE));
            v9 = Unit.INSTANCE;
        } else {
            v9 = null;
        }
        List list = CollectionsKt.build((List)pair3);
        SearchCondition.Series series = (SearchCondition.Series)new SearchCondition.AllOfSeries(list);
        String string = searchTerm;
        Pair<String, String> pair4 = searchRegex;
        if (pair4 != null) {
            void it6;
            $this$getAlphabeticalGroups_u24lambda_u2438 = pair4;
            String string2 = string;
            SearchCondition.Series series2 = series;
            boolean bl24 = false;
            String string3 = ((String)it6.getSecond()).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            object = string3;
            Pair pair5 = Intrinsics.areEqual((Object)object, (Object)"title") ? new Pair(it6.getFirst(), (Object)SearchField.TITLE) : (Intrinsics.areEqual((Object)object, (Object)"title_sort") ? new Pair(it6.getFirst(), (Object)SearchField.TITLE_SORT) : null);
            series = series2;
            string = string2;
            pair = pair5;
        } else {
            pair = null;
        }
        Pair pair6 = pair;
        String string4 = string;
        SearchCondition.Series series3 = series;
        SeriesSearch seriesSearch = new SeriesSearch(series3, string4, pair6);
        return this.seriesDtoRepository.countByFirstCharacter(seriesSearch, new SearchContext(principal.getUser()));
    }

    public static /* synthetic */ List getAlphabeticalGroups$default(SeriesController seriesController, KomgaPrincipal komgaPrincipal, String string, Pair pair, List list, List list2, List list3, List list4, List list5, List list6, List list7, List list8, List list9, List list10, List list11, Boolean bl, Boolean bl2, Boolean bl3, List list12, Pageable pageable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getAlphabeticalGroups");
        }
        if ((n & 0x2000) != 0) {
            list11 = null;
        }
        if ((n & 0x10000) != 0) {
            bl3 = null;
        }
        return seriesController.getAlphabeticalGroups(komgaPrincipal, string, pair, list, list2, list3, list4, list5, list6, list7, list8, list9, list10, list11, bl, bl2, bl3, list12, pageable);
    }

    @PostMapping(value={"v1/series/list/alphabetical-groups"})
    @NotNull
    public List<GroupCountDto> getSeriesListByAlphabeticalGroups(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestBody @NotNull SeriesSearch search) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)search, (String)"search");
        return this.seriesDtoRepository.countByFirstCharacter(search, new SearchContext(principal.getUser()));
    }

    /*
     * WARNING - void declaration
     */
    @Operation(description="Return recently added or updated series.")
    @PageableWithoutSortAsQueryParam
    @GetMapping(value={"v1/series/latest"})
    @NotNull
    public Page<SeriesDto> getLatestSeries(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="library_id", required=false) @Nullable List<String> libraryIds, @RequestParam(name="deleted", required=false) @Nullable Boolean deleted, @RequestParam(name="oneshot", required=false) @Nullable Boolean oneshot, @RequestParam(name="unpaged", required=false) boolean unpaged, @Parameter(hidden=true) @NotNull Pageable page) {
        boolean it;
        void $this$getLatestSeries_u24lambda_u2443;
        List list;
        Pageable pageable;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Sort.Order[] orderArray = new Sort.Order[]{Sort.Order.desc((String)"lastModified")};
        Sort sort = Sort.by((Sort.Order[])orderArray);
        Intrinsics.checkNotNullExpressionValue((Object)sort, (String)"by(...)");
        Sort sort2 = sort;
        if (unpaged) {
            pageable = (Pageable)new UnpagedSorted(sort2);
        } else {
            PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)sort2);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            pageable = (Pageable)pageRequest;
        }
        Pageable pageRequest = pageable;
        List list2 = list = CollectionsKt.createListBuilder();
        SeriesDtoRepository seriesDtoRepository = this.seriesDtoRepository;
        boolean bl = false;
        Iterable iterable = libraryIds;
        if (!(iterable == null || iterable.isEmpty())) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            iterable = libraryIds;
            void var14_15 = $this$getLatestSeries_u24lambda_u2443;
            boolean $i$f$map = false;
            void var16_17 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new SearchCondition.LibraryId((SearchOperator.Equality)new SearchOperator.Is((Object)it2)));
            }
            List list3 = (List)destination$iv$iv;
            var14_15.add(new SearchCondition.AnyOfSeries(list3));
        }
        Boolean bl3 = deleted;
        if (bl3 != null) {
            it = bl3;
            boolean bl4 = false;
            $this$getLatestSeries_u24lambda_u2443.add(new SearchCondition.Deleted(it ? (SearchOperator.Boolean)SearchOperator.IsTrue.INSTANCE : (SearchOperator.Boolean)SearchOperator.IsFalse.INSTANCE));
        }
        Boolean bl5 = oneshot;
        if (bl5 != null) {
            it = bl5;
            boolean bl6 = false;
            $this$getLatestSeries_u24lambda_u2443.add(new SearchCondition.OneShot(it ? (SearchOperator.Boolean)SearchOperator.IsTrue.INSTANCE : (SearchOperator.Boolean)SearchOperator.IsFalse.INSTANCE));
        }
        List list4 = CollectionsKt.build((List)list);
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 6;
        Pair pair = null;
        String string = null;
        SearchCondition.Series series = (SearchCondition.Series)new SearchCondition.AllOfSeries(list4);
        Page page2 = seriesDtoRepository.findAll(new SeriesSearch(series, string, pair, n, defaultConstructorMarker), new SearchContext(principal.getUser()), pageRequest).map(arg_0 -> SeriesController.getLatestSeries$lambda$44((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    public static /* synthetic */ Page getLatestSeries$default(SeriesController seriesController, KomgaPrincipal komgaPrincipal, List list, Boolean bl, Boolean bl2, boolean bl3, Pageable pageable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getLatestSeries");
        }
        if ((n & 8) != 0) {
            bl2 = null;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        return seriesController.getLatestSeries(komgaPrincipal, list, bl, bl2, bl3, pageable);
    }

    /*
     * WARNING - void declaration
     */
    @Operation(description="Return newly added series.")
    @PageableWithoutSortAsQueryParam
    @GetMapping(value={"v1/series/new"})
    @NotNull
    public Page<SeriesDto> getNewSeries(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="library_id", required=false) @Nullable List<String> libraryIds, @RequestParam(name="deleted", required=false) @Nullable Boolean deleted, @RequestParam(name="oneshot", required=false) @Nullable Boolean oneshot, @RequestParam(name="unpaged", required=false) boolean unpaged, @Parameter(hidden=true) @NotNull Pageable page) {
        boolean it;
        void $this$getNewSeries_u24lambda_u2448;
        List list;
        Pageable pageable;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Sort.Order[] orderArray = new Sort.Order[]{Sort.Order.desc((String)"created")};
        Sort sort = Sort.by((Sort.Order[])orderArray);
        Intrinsics.checkNotNullExpressionValue((Object)sort, (String)"by(...)");
        Sort sort2 = sort;
        if (unpaged) {
            pageable = (Pageable)new UnpagedSorted(sort2);
        } else {
            PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)sort2);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            pageable = (Pageable)pageRequest;
        }
        Pageable pageRequest = pageable;
        List list2 = list = CollectionsKt.createListBuilder();
        SeriesDtoRepository seriesDtoRepository = this.seriesDtoRepository;
        boolean bl = false;
        Iterable iterable = libraryIds;
        if (!(iterable == null || iterable.isEmpty())) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            iterable = libraryIds;
            void var14_15 = $this$getNewSeries_u24lambda_u2448;
            boolean $i$f$map = false;
            void var16_17 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new SearchCondition.LibraryId((SearchOperator.Equality)new SearchOperator.Is((Object)it2)));
            }
            List list3 = (List)destination$iv$iv;
            var14_15.add(new SearchCondition.AnyOfSeries(list3));
        }
        Boolean bl3 = deleted;
        if (bl3 != null) {
            it = bl3;
            boolean bl4 = false;
            $this$getNewSeries_u24lambda_u2448.add(new SearchCondition.Deleted(it ? (SearchOperator.Boolean)SearchOperator.IsTrue.INSTANCE : (SearchOperator.Boolean)SearchOperator.IsFalse.INSTANCE));
        }
        Boolean bl5 = oneshot;
        if (bl5 != null) {
            it = bl5;
            boolean bl6 = false;
            $this$getNewSeries_u24lambda_u2448.add(new SearchCondition.OneShot(it ? (SearchOperator.Boolean)SearchOperator.IsTrue.INSTANCE : (SearchOperator.Boolean)SearchOperator.IsFalse.INSTANCE));
        }
        List list4 = CollectionsKt.build((List)list);
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 6;
        Pair pair = null;
        String string = null;
        SearchCondition.Series series = (SearchCondition.Series)new SearchCondition.AllOfSeries(list4);
        Page page2 = seriesDtoRepository.findAll(new SeriesSearch(series, string, pair, n, defaultConstructorMarker), new SearchContext(principal.getUser()), pageRequest).map(arg_0 -> SeriesController.getNewSeries$lambda$49((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    public static /* synthetic */ Page getNewSeries$default(SeriesController seriesController, KomgaPrincipal komgaPrincipal, List list, Boolean bl, Boolean bl2, boolean bl3, Pageable pageable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getNewSeries");
        }
        if ((n & 2) != 0) {
            list = null;
        }
        if ((n & 4) != 0) {
            bl = null;
        }
        if ((n & 8) != 0) {
            bl2 = null;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        return seriesController.getNewSeries(komgaPrincipal, list, bl, bl2, bl3, pageable);
    }

    /*
     * WARNING - void declaration
     */
    @Operation(description="Return recently updated series, but not newly added ones.")
    @PageableWithoutSortAsQueryParam
    @GetMapping(value={"v1/series/updated"})
    @NotNull
    public Page<SeriesDto> getUpdatedSeries(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="library_id", required=false) @Nullable List<String> libraryIds, @RequestParam(name="deleted", required=false) @Nullable Boolean deleted, @RequestParam(name="oneshot", required=false) @Nullable Boolean oneshot, @RequestParam(name="unpaged", required=false) boolean unpaged, @Parameter(hidden=true) @NotNull Pageable page) {
        boolean it;
        void $this$getUpdatedSeries_u24lambda_u2453;
        List list;
        Pageable pageable;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Sort.Order[] orderArray = new Sort.Order[]{Sort.Order.desc((String)"lastModified")};
        Sort sort = Sort.by((Sort.Order[])orderArray);
        Intrinsics.checkNotNullExpressionValue((Object)sort, (String)"by(...)");
        Sort sort2 = sort;
        if (unpaged) {
            pageable = (Pageable)new UnpagedSorted(sort2);
        } else {
            PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)sort2);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            pageable = (Pageable)pageRequest;
        }
        Pageable pageRequest = pageable;
        List list2 = list = CollectionsKt.createListBuilder();
        SeriesDtoRepository seriesDtoRepository = this.seriesDtoRepository;
        boolean bl = false;
        Iterable iterable = libraryIds;
        if (!(iterable == null || iterable.isEmpty())) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            iterable = libraryIds;
            void var14_15 = $this$getUpdatedSeries_u24lambda_u2453;
            boolean $i$f$map = false;
            void var16_17 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new SearchCondition.LibraryId((SearchOperator.Equality)new SearchOperator.Is((Object)it2)));
            }
            List list3 = (List)destination$iv$iv;
            var14_15.add(new SearchCondition.AnyOfSeries(list3));
        }
        Boolean bl3 = deleted;
        if (bl3 != null) {
            it = bl3;
            boolean bl4 = false;
            $this$getUpdatedSeries_u24lambda_u2453.add(new SearchCondition.Deleted(it ? (SearchOperator.Boolean)SearchOperator.IsTrue.INSTANCE : (SearchOperator.Boolean)SearchOperator.IsFalse.INSTANCE));
        }
        Boolean bl5 = oneshot;
        if (bl5 != null) {
            it = bl5;
            boolean bl6 = false;
            $this$getUpdatedSeries_u24lambda_u2453.add(new SearchCondition.OneShot(it ? (SearchOperator.Boolean)SearchOperator.IsTrue.INSTANCE : (SearchOperator.Boolean)SearchOperator.IsFalse.INSTANCE));
        }
        List list4 = CollectionsKt.build((List)list);
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 6;
        Pair pair = null;
        String string = null;
        SearchCondition.Series series = (SearchCondition.Series)new SearchCondition.AllOfSeries(list4);
        Page page2 = seriesDtoRepository.findAllRecentlyUpdated(new SeriesSearch(series, string, pair, n, defaultConstructorMarker), new SearchContext(principal.getUser()), pageRequest).map(arg_0 -> SeriesController.getUpdatedSeries$lambda$54((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    public static /* synthetic */ Page getUpdatedSeries$default(SeriesController seriesController, KomgaPrincipal komgaPrincipal, List list, Boolean bl, Boolean bl2, boolean bl3, Pageable pageable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getUpdatedSeries");
        }
        if ((n & 2) != 0) {
            list = null;
        }
        if ((n & 4) != 0) {
            bl = null;
        }
        if ((n & 8) != 0) {
            bl2 = null;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        return seriesController.getUpdatedSeries(komgaPrincipal, list, bl, bl2, bl3, pageable);
    }

    @GetMapping(value={"v1/series/{seriesId}"})
    @NotNull
    public SeriesDto getOneSeries(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="seriesId") @NotNull String id) {
        SeriesDto seriesDto;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                seriesDto = this.seriesDtoRepository.findByIdOrNull(id, principal.getUser().getId());
                if (seriesDto == null) break block2;
                SeriesDto it = seriesDto;
                boolean bl = false;
                this.contentRestrictionChecker.checkContentRestriction(principal.getUser(), it);
                SeriesDto seriesDto2 = SeriesDtoKt.restrictUrl((SeriesDto)it, (!principal.getUser().getRoleAdmin() ? 1 : 0) != 0);
                seriesDto = seriesDto2;
                if (seriesDto2 != null) break block3;
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return seriesDto;
    }

    @ApiResponse(content={@Content(schema=@Schema(format="binary", type="string"))})
    @GetMapping(value={"v1/series/{seriesId}/thumbnail"}, produces={"image/jpeg"})
    @NotNull
    public byte[] getSeriesDefaultThumbnail(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="seriesId") @NotNull String seriesId) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        this.checkContentRestriction(principal.getUser(), seriesId);
        byte[] byArray = this.seriesLifecycle.getThumbnailBytes(seriesId, principal.getUser().getId());
        if (byArray == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return byArray;
    }

    @ApiResponse(content={@Content(schema=@Schema(format="binary", type="string"))})
    @GetMapping(value={"v1/series/{seriesId}/thumbnails/{thumbnailId}"}, produces={"image/jpeg"})
    @NotNull
    public byte[] getSeriesThumbnailById(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="seriesId") @NotNull String seriesId, @PathVariable(name="thumbnailId") @NotNull String thumbnailId) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        Intrinsics.checkNotNullParameter((Object)thumbnailId, (String)"thumbnailId");
        this.checkContentRestriction(principal.getUser(), seriesId);
        byte[] byArray = this.seriesLifecycle.getThumbnailBytesByThumbnailId(thumbnailId);
        if (byArray == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"v1/series/{seriesId}/thumbnails"}, produces={"application/json"})
    @NotNull
    public Collection<ThumbnailSeriesDto> getSeriesThumbnails(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="seriesId") @NotNull String seriesId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        this.checkContentRestriction(principal.getUser(), seriesId);
        Iterable $this$map$iv = this.thumbnailsSeriesRepository.findAllBySeriesId(seriesId);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ThumbnailSeries thumbnailSeries = (ThumbnailSeries)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ThumbnailSeriesDtoKt.toDto((ThumbnailSeries)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"v1/series/{seriesId}/thumbnails"}, consumes={"multipart/form-data"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @NotNull
    public ThumbnailSeriesDto postUserUploadedSeriesThumbnail(@PathVariable(name="seriesId") @NotNull String seriesId, @RequestParam(value="file") @NotNull MultipartFile file, @RequestParam(value="selected") boolean selected) {
        String string;
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Series series = this.seriesRepository.findByIdOrNull(seriesId);
        if (series == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        Series series2 = series;
        if (series2.getOneshot()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        InputStream inputStream = file.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        Object object = inputStream;
        int n = 8192;
        object = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
        Object object2 = null;
        try {
            BufferedInputStream it = (BufferedInputStream)object;
            boolean bl = false;
            string = this.contentDetector.detectMediaType((InputStream)it);
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        String mediaType2 = string;
        if (!this.contentDetector.isImage(mediaType2)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNSUPPORTED_MEDIA_TYPE);
        }
        object = series2.getId();
        object2 = file.getBytes();
        string = ThumbnailSeries.Type.USER_UPLOADED;
        long l = file.getBytes().length;
        InputStream inputStream2 = file.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getInputStream(...)");
        InputStream inputStream3 = inputStream2;
        int n2 = 8192;
        Dimension dimension = this.imageAnalyzer.getDimension((InputStream)(inputStream3 instanceof BufferedInputStream ? (BufferedInputStream)inputStream3 : new BufferedInputStream(inputStream3, n2)));
        if (dimension == null) {
            dimension = new Dimension(0, 0);
        }
        Dimension dimension2 = dimension;
        return ThumbnailSeriesDtoKt.toDto((ThumbnailSeries)this.seriesLifecycle.addThumbnailForSeries(new ThumbnailSeries((byte[])object2, null, false, (ThumbnailSeries.Type)string, mediaType2, l, dimension2, null, (String)object, null, null, 1670, null), selected ? MarkSelectedPreference.YES : MarkSelectedPreference.NO));
    }

    public static /* synthetic */ ThumbnailSeriesDto postUserUploadedSeriesThumbnail$default(SeriesController seriesController, String string, MultipartFile multipartFile, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: postUserUploadedSeriesThumbnail");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return seriesController.postUserUploadedSeriesThumbnail(string, multipartFile, bl);
    }

    @PutMapping(value={"v1/series/{seriesId}/thumbnails/{thumbnailId}/selected"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void postMarkSelectedSeriesThumbnail(@PathVariable(name="seriesId") @NotNull String seriesId, @PathVariable(name="thumbnailId") @NotNull String thumbnailId) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        Intrinsics.checkNotNullParameter((Object)thumbnailId, (String)"thumbnailId");
        if (this.seriesRepository.findByIdOrNull(seriesId) == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        ThumbnailSeries thumbnailSeries = this.thumbnailsSeriesRepository.findByIdOrNull(thumbnailId);
        if (thumbnailSeries != null) {
            ThumbnailSeries it = thumbnailSeries;
            boolean bl = false;
            this.thumbnailsSeriesRepository.markSelected(it);
            this.eventPublisher.publishEvent((Object)new DomainEvent.ThumbnailSeriesAdded(ThumbnailSeries.copy$default((ThumbnailSeries)it, null, null, (boolean)true, null, null, (long)0L, null, null, null, null, null, (int)2043, null)));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @DeleteMapping(value={"v1/series/{seriesId}/thumbnails/{thumbnailId}"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void deleteUserUploadedSeriesThumbnail(@PathVariable(name="seriesId") @NotNull String seriesId, @PathVariable(name="thumbnailId") @NotNull String thumbnailId) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        Intrinsics.checkNotNullParameter((Object)thumbnailId, (String)"thumbnailId");
        if (this.seriesRepository.findByIdOrNull(seriesId) == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        ThumbnailSeries thumbnailSeries = this.thumbnailsSeriesRepository.findByIdOrNull(thumbnailId);
        if (thumbnailSeries != null) {
            ThumbnailSeries it = thumbnailSeries;
            boolean bl = false;
            try {
                this.seriesLifecycle.deleteThumbnailForSeries(it);
            }
            catch (IllegalArgumentException e) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage());
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @PageableAsQueryParam
    @AuthorsAsQueryParam
    @GetMapping(value={"v1/series/{seriesId}/books"})
    @NotNull
    public Page<BookDto> getAllBooksBySeries(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="seriesId") @NotNull String seriesId, @RequestParam(name="media_status", required=false) @Nullable List<? extends Media.Status> mediaStatus, @RequestParam(name="read_status", required=false) @Nullable List<? extends ReadStatus> readStatus, @RequestParam(name="tag", required=false) @Nullable List<String> tags, @RequestParam(name="deleted", required=false) @Nullable Boolean deleted, @RequestParam(name="unpaged", required=false) boolean unpaged, @Parameter(hidden=true) @Authors @Nullable List<Author> authors, @Parameter(hidden=true) @NotNull Pageable page) {
        Object it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        Iterable $this$map$iv;
        boolean $i$f$map;
        List list;
        List list2;
        Pageable pageable;
        Sort sort;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        this.checkContentRestriction(principal.getUser(), seriesId);
        if (page.getSort().isSorted()) {
            sort = page.getSort();
        } else {
            Sort.Order[] orderArray = new Sort.Order[]{Sort.Order.asc((String)"metadata.numberSort")};
            sort = Sort.by((Sort.Order[])orderArray);
        }
        Sort sort2 = sort;
        Intrinsics.checkNotNull((Object)sort2);
        Sort sort3 = sort2;
        if (unpaged) {
            pageable = (Pageable)new UnpagedSorted(sort3);
        } else {
            PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)sort3);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            pageable = (Pageable)pageRequest;
        }
        Pageable pageRequest = pageable;
        List $this$getAllBooksBySeries_u24lambda_u2465 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$getAllBooksBySeries_u24lambda_u2465.add(new SearchCondition.SeriesId((SearchOperator.Equality)new SearchOperator.Is((Object)seriesId)));
        Iterable iterable = mediaStatus;
        if (!(iterable == null || iterable.isEmpty())) {
            iterable = mediaStatus;
            list = $this$getAllBooksBySeries_u24lambda_u2465;
            $i$f$map = false;
            Collection collection2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Media.Status status = (Media.Status)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new SearchCondition.MediaStatus((SearchOperator.Equality)new SearchOperator.Is(it)));
            }
            List list3 = (List)destination$iv$iv;
            list.add(new SearchCondition.AnyOfBook(list3));
        }
        if (!(($this$map$iv = (Collection)readStatus) == null || $this$map$iv.isEmpty())) {
            $this$map$iv = readStatus;
            list = $this$getAllBooksBySeries_u24lambda_u2465;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (ReadStatus)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(new SearchCondition.ReadStatus((SearchOperator.Equality)new SearchOperator.Is(it)));
            }
            List list4 = (List)destination$iv$iv;
            list.add(new SearchCondition.AnyOfBook(list4));
        }
        if (!(($this$map$iv = (Collection)tags) == null || $this$map$iv.isEmpty())) {
            $this$map$iv = tags;
            list = $this$getAllBooksBySeries_u24lambda_u2465;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(new SearchCondition.Tag((SearchOperator.Equality)new SearchOperator.Is(it)));
            }
            List list5 = (List)destination$iv$iv;
            list.add(new SearchCondition.AnyOfBook(list5));
        }
        if (!(($this$map$iv = (Collection)authors) == null || $this$map$iv.isEmpty())) {
            $this$map$iv = authors;
            list = $this$getAllBooksBySeries_u24lambda_u2465;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Author)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl5 = false;
                collection.add(new SearchCondition.Author((SearchOperator.Equality)new SearchOperator.Is((Object)new SearchCondition.AuthorMatch(it.getName(), it.getRole()))));
            }
            List list6 = (List)destination$iv$iv;
            list.add(new SearchCondition.AnyOfBook(list6));
        }
        Boolean bl6 = deleted;
        if (bl6 != null) {
            boolean it2 = bl6;
            boolean bl7 = false;
            $this$getAllBooksBySeries_u24lambda_u2465.add(new SearchCondition.Deleted(it2 ? (SearchOperator.Boolean)SearchOperator.IsTrue.INSTANCE : (SearchOperator.Boolean)SearchOperator.IsFalse.INSTANCE));
        }
        List list7 = CollectionsKt.build((List)list2);
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 2;
        String string = null;
        SearchCondition.Book book = (SearchCondition.Book)new SearchCondition.AllOfBook(list7);
        BookSearch search = new BookSearch(book, string, n, defaultConstructorMarker);
        Page page2 = this.bookDtoRepository.findAll(search, new SearchContext(principal.getUser()), pageRequest).map(arg_0 -> SeriesController.getAllBooksBySeries$lambda$66((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    public static /* synthetic */ Page getAllBooksBySeries$default(SeriesController seriesController, KomgaPrincipal komgaPrincipal, String string, List list, List list2, List list3, Boolean bl, boolean bl2, List list4, Pageable pageable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getAllBooksBySeries");
        }
        if ((n & 4) != 0) {
            list = null;
        }
        if ((n & 8) != 0) {
            list2 = null;
        }
        if ((n & 0x10) != 0) {
            list3 = null;
        }
        if ((n & 0x20) != 0) {
            bl = null;
        }
        if ((n & 0x40) != 0) {
            bl2 = false;
        }
        if ((n & 0x80) != 0) {
            list4 = null;
        }
        return seriesController.getAllBooksBySeries(komgaPrincipal, string, list, list2, list3, bl, bl2, list4, pageable);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"v1/series/{seriesId}/collections"})
    @NotNull
    public List<CollectionDto> getAllCollectionsBySeries(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable(name="seriesId") @NotNull String seriesId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        this.checkContentRestriction(principal.getUser(), seriesId);
        Iterable $this$map$iv = this.collectionRepository.findAllContainingSeriesId(seriesId, principal.getUser().getAuthorizedLibraryIds(null), principal.getUser().getRestrictions());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SeriesCollection seriesCollection = (SeriesCollection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CollectionDtoKt.toDto((SeriesCollection)it));
        }
        return (List)destination$iv$iv;
    }

    @PostMapping(value={"v1/series/{seriesId}/analyze"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void analyze(@PathVariable @NotNull String seriesId) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        this.taskEmitter.analyzeBook(this.bookRepository.findAllBySeriesId(seriesId), 6);
    }

    @PostMapping(value={"v1/series/{seriesId}/metadata/refresh"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void refreshMetadata(@PathVariable @NotNull String seriesId) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        Collection books = this.bookRepository.findAllBySeriesId(seriesId);
        TaskEmitter.refreshBookMetadata$default((TaskEmitter)this.taskEmitter, (Collection)books, null, (int)6, (int)2, null);
        this.taskEmitter.refreshBookLocalArtwork(books, 6);
        this.taskEmitter.refreshSeriesLocalArtwork(seriesId, 6);
    }

    /*
     * WARNING - void declaration
     */
    @PatchMapping(value={"v1/series/{seriesId}/metadata"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateMetadata(@PathVariable @NotNull String seriesId, @Parameter(description="Metadata fields to update. Set a field to null to unset the metadata. You can omit fields you don't want to update.") @Valid @RequestBody @NotNull SeriesMetadataUpdateDto newMetadata, @AuthenticationPrincipal @NotNull KomgaPrincipal principal) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        Intrinsics.checkNotNullParameter((Object)newMetadata, (String)"newMetadata");
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        SeriesMetadata seriesMetadata = this.seriesMetadataRepository.findByIdOrNull(seriesId);
        if (seriesMetadata != null) {
            List list;
            boolean bl;
            List list2;
            Collection collection;
            boolean bl2;
            Set set;
            boolean bl3;
            Set set2;
            boolean bl4;
            Set set3;
            boolean bl5;
            SeriesMetadata existing = seriesMetadata;
            boolean bl6 = false;
            SeriesMetadataUpdateDto $this$updateMetadata_u24lambda_u2472_u24lambda_u2470 = newMetadata;
            boolean bl7 = false;
            SeriesMetadata.Status status = $this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getStatus();
            if (status == null) {
                status = existing.getStatus();
            }
            SeriesMetadata.Status status2 = status;
            Boolean bl8 = $this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getStatusLock();
            boolean bl9 = bl8 != null ? bl8.booleanValue() : existing.getStatusLock();
            String string = $this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getTitle();
            if (string == null) {
                string = existing.getTitle();
            }
            String string2 = string;
            Boolean bl10 = $this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getTitleLock();
            boolean bl11 = bl10 != null ? bl10.booleanValue() : existing.getTitleLock();
            String string3 = $this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getTitleSort();
            if (string3 == null) {
                string3 = existing.getTitleSort();
            }
            String string4 = string3;
            Boolean bl12 = $this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getTitleSortLock();
            boolean bl13 = bl12 != null ? bl12.booleanValue() : existing.getTitleSortLock();
            String string5 = $this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getSummary();
            if (string5 == null) {
                string5 = existing.getSummary();
            }
            String string6 = string5;
            Boolean bl14 = $this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getSummaryLock();
            boolean bl15 = bl14 != null ? bl14.booleanValue() : existing.getSummaryLock();
            String string7 = $this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getLanguage();
            if (string7 == null) {
                string7 = existing.getLanguage();
            }
            String string8 = string7;
            Boolean bl16 = $this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getLanguageLock();
            boolean bl17 = bl16 != null ? bl16.booleanValue() : existing.getLanguageLock();
            SeriesMetadata.ReadingDirection readingDirection = $this$updateMetadata_u24lambda_u2472_u24lambda_u2470.isSet("readingDirection") ? $this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getReadingDirection() : existing.getReadingDirection();
            Boolean bl18 = $this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getReadingDirectionLock();
            boolean bl19 = bl18 != null ? bl18.booleanValue() : existing.getReadingDirectionLock();
            String string9 = $this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getPublisher();
            if (string9 == null) {
                string9 = existing.getPublisher();
            }
            String string10 = string9;
            Boolean bl20 = $this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getPublisherLock();
            boolean bl21 = bl20 != null ? bl20.booleanValue() : existing.getPublisherLock();
            Integer n = $this$updateMetadata_u24lambda_u2472_u24lambda_u2470.isSet("ageRating") ? $this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getAgeRating() : existing.getAgeRating();
            Boolean bl22 = $this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getAgeRatingLock();
            boolean bl23 = bl5 = bl22 != null ? bl22.booleanValue() : existing.getAgeRatingLock();
            if ($this$updateMetadata_u24lambda_u2472_u24lambda_u2470.isSet("genres")) {
                if ($this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getGenres() != null) {
                    Set set4 = $this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getGenres();
                    set3 = set4;
                    Intrinsics.checkNotNull((Object)set4);
                } else {
                    set3 = SetsKt.emptySet();
                }
            } else {
                set3 = existing.getGenres();
            }
            Set set5 = set3;
            Boolean bl24 = $this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getGenresLock();
            boolean bl25 = bl4 = bl24 != null ? bl24.booleanValue() : existing.getGenresLock();
            if ($this$updateMetadata_u24lambda_u2472_u24lambda_u2470.isSet("tags")) {
                if ($this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getTags() != null) {
                    Set set6 = $this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getTags();
                    set2 = set6;
                    Intrinsics.checkNotNull((Object)set6);
                } else {
                    set2 = SetsKt.emptySet();
                }
            } else {
                set2 = existing.getTags();
            }
            Set set7 = set2;
            Boolean bl26 = $this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getTagsLock();
            boolean bl27 = bl26 != null ? bl26.booleanValue() : existing.getTagsLock();
            Integer n2 = $this$updateMetadata_u24lambda_u2472_u24lambda_u2470.isSet("totalBookCount") ? $this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getTotalBookCount() : existing.getTotalBookCount();
            Boolean bl28 = $this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getTotalBookCountLock();
            boolean bl29 = bl3 = bl28 != null ? bl28.booleanValue() : existing.getTotalBookCountLock();
            if ($this$updateMetadata_u24lambda_u2472_u24lambda_u2470.isSet("sharingLabels")) {
                if ($this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getSharingLabels() != null) {
                    Set set8 = $this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getSharingLabels();
                    set = set8;
                    Intrinsics.checkNotNull((Object)set8);
                } else {
                    set = SetsKt.emptySet();
                }
            } else {
                set = existing.getSharingLabels();
            }
            Set set9 = set;
            Boolean bl30 = $this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getSharingLabelsLock();
            boolean bl31 = bl2 = bl30 != null ? bl30.booleanValue() : existing.getSharingLabelsLock();
            if ($this$updateMetadata_u24lambda_u2472_u24lambda_u2470.isSet("links")) {
                if ($this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getLinks() != null) {
                    void $this$mapTo$iv$iv;
                    List list3 = $this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getLinks();
                    Intrinsics.checkNotNull((Object)list3);
                    Iterable $this$map$iv = list3;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        WebLinkUpdateDto webLinkUpdateDto = (WebLinkUpdateDto)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl32 = false;
                        String string11 = it.getLabel();
                        Intrinsics.checkNotNull((Object)string11);
                        String string12 = it.getUrl();
                        Intrinsics.checkNotNull((Object)string12);
                        collection.add(new WebLink(string11, new URI(string12)));
                    }
                    list2 = (List)destination$iv$iv;
                } else {
                    list2 = CollectionsKt.emptyList();
                }
            } else {
                list2 = existing.getLinks();
            }
            List list4 = list2;
            Boolean bl33 = $this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getLinksLock();
            boolean bl34 = bl = bl33 != null ? bl33.booleanValue() : existing.getLinksLock();
            if ($this$updateMetadata_u24lambda_u2472_u24lambda_u2470.isSet("alternateTitles")) {
                if ($this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getAlternateTitles() != null) {
                    void $this$mapTo$iv$iv;
                    List list5 = $this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getAlternateTitles();
                    Intrinsics.checkNotNull((Object)list5);
                    Iterable $this$map$iv = list5;
                    boolean $i$f$map = false;
                    Iterable $i$f$mapTo = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        AlternateTitleUpdateDto alternateTitleUpdateDto = (AlternateTitleUpdateDto)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl35 = false;
                        String string13 = it.getLabel();
                        Intrinsics.checkNotNull((Object)string13);
                        String string14 = it.getTitle();
                        Intrinsics.checkNotNull((Object)string14);
                        collection.add(new AlternateTitle(string13, string14));
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = CollectionsKt.emptyList();
                }
            } else {
                list = existing.getAlternateTitles();
            }
            List list6 = list;
            Boolean bl36 = $this$updateMetadata_u24lambda_u2472_u24lambda_u2470.getAlternateTitlesLock();
            boolean bl37 = bl36 != null ? bl36.booleanValue() : existing.getAlternateTitlesLock();
            SeriesMetadata updated = SeriesMetadata.copy$default((SeriesMetadata)existing, (SeriesMetadata.Status)status2, (String)string2, (String)string4, (String)string6, (SeriesMetadata.ReadingDirection)readingDirection, (String)string10, (Integer)n, (String)string8, (Set)set5, (Set)set7, (Integer)n2, (Set)set9, (List)list4, (List)list6, (boolean)bl9, (boolean)bl11, (boolean)bl13, (boolean)bl15, (boolean)bl19, (boolean)bl21, (boolean)bl5, (boolean)bl17, (boolean)bl4, (boolean)bl27, (boolean)bl3, (boolean)bl2, (boolean)bl, (boolean)bl37, null, null, null, (int)0x70000000, null);
            this.seriesMetadataRepository.update(updated);
            Series series = this.seriesRepository.findByIdOrNull(seriesId);
            if (series != null) {
                Series it = series;
                boolean bl38 = false;
                this.eventPublisher.publishEvent((Object)new DomainEvent.SeriesUpdated(it));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @Operation(description="Mark all book for series as read")
    @PostMapping(value={"v1/series/{seriesId}/read-progress"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void markAsRead(@PathVariable @NotNull String seriesId, @AuthenticationPrincipal @NotNull KomgaPrincipal principal) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        this.checkContentRestriction(principal.getUser(), seriesId);
        this.seriesLifecycle.markReadProgressCompleted(seriesId, principal.getUser());
    }

    @Operation(description="Mark all book for series as unread")
    @DeleteMapping(value={"v1/series/{seriesId}/read-progress"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void markAsUnread(@PathVariable @NotNull String seriesId, @AuthenticationPrincipal @NotNull KomgaPrincipal principal) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        this.checkContentRestriction(principal.getUser(), seriesId);
        this.seriesLifecycle.deleteReadProgress(seriesId, principal.getUser());
    }

    @GetMapping(value={"v2/series/{seriesId}/read-progress/tachiyomi"})
    @NotNull
    public TachiyomiReadProgressV2Dto getReadProgressTachiyomiV2(@PathVariable @NotNull String seriesId, @AuthenticationPrincipal @NotNull KomgaPrincipal principal) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        this.checkContentRestriction(principal.getUser(), seriesId);
        return this.readProgressDtoRepository.findProgressV2BySeries(seriesId, principal.getUser().getId());
    }

    /*
     * WARNING - void declaration
     */
    @PutMapping(value={"v2/series/{seriesId}/read-progress/tachiyomi"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void markReadProgressTachiyomiV2(@PathVariable @NotNull String seriesId, @RequestBody @NotNull TachiyomiReadProgressUpdateV2Dto readProgress, @AuthenticationPrincipal @NotNull KomgaPrincipal principal) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        Intrinsics.checkNotNullParameter((Object)readProgress, (String)"readProgress");
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        this.checkContentRestriction(principal.getUser(), seriesId);
        BookSearch bookSearch = new BookSearch((SearchCondition.Book)new SearchCondition.SeriesId((SearchOperator.Equality)new SearchOperator.Is((Object)seriesId)), null, 2, null);
        SearchContext searchContext = new SearchContext(principal.getUser());
        Object object = new Sort.Order[]{Sort.Order.asc((String)"metadata.numberSort")};
        Sort sort = Sort.by((Sort.Order[])object);
        Intrinsics.checkNotNullExpressionValue((Object)sort, (String)"by(...)");
        Iterable iterable = this.bookDtoRepository.findAll(bookSearch, searchContext, (Pageable)new UnpagedSorted(sort)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"toList(...)");
        iterable = iterable;
        boolean $i$f$filter = false;
        object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BookDto book = (BookDto)element$iv$iv;
            boolean bl = false;
            if (!(book.getMetadata().getNumberSort() <= readProgress.getLastBookNumberSortRead())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BookDto book = (BookDto)element$iv;
            boolean bl = false;
            ReadProgressDto readProgressDto = book.getReadProgress();
            if (readProgressDto != null ? readProgressDto.getCompleted() : false) continue;
            this.bookLifecycle.markReadProgressCompleted(book.getId(), principal.getUser());
        }
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"v1/series/{seriesId}/file"}, produces={"application/octet-stream"})
    @PreAuthorize(value="hasRole('FILE_DOWNLOAD')")
    @NotNull
    public ResponseEntity<StreamingResponseBody> getSeriesFile(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String seriesId) {
        void $this$getSeriesFile_u24lambda_u2479;
        HttpHeaders httpHeaders;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        this.checkContentRestriction(principal.getUser(), seriesId);
        Collection books = this.bookRepository.findAllBySeriesId(seriesId);
        StreamingResponseBody streamingResponse2 = arg_0 -> SeriesController.getSeriesFile$lambda$78(books, arg_0);
        HttpHeaders httpHeaders2 = httpHeaders = new HttpHeaders();
        ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.ok();
        boolean bl = false;
        $this$getSeriesFile_u24lambda_u2479.setContentDisposition(ContentDisposition.builder((String)"attachment").filename(this.seriesMetadataRepository.findById(seriesId).getTitle() + ".zip", StandardCharsets.UTF_8).build());
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)bodyBuilder.headers(httpHeaders)).contentType(MediaType.parseMediaType((String)org.gotson.komga.domain.model.MediaType.ZIP.getType())).body((Object)streamingResponse2);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        return responseEntity;
    }

    @DeleteMapping(value={"v1/series/{seriesId}/file"})
    @PreAuthorize(value="hasRole('ADMIN')")
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void deleteSeries(@PathVariable @NotNull String seriesId) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        this.taskEmitter.deleteSeries(seriesId, 8);
    }

    private void checkContentRestriction(KomgaUser $this$checkContentRestriction, String seriesId) {
        if (!$this$checkContentRestriction.canAccessAllLibraries()) {
            Unit unit;
            String string = this.seriesRepository.getLibraryId(seriesId);
            if (string != null) {
                String it = string;
                boolean bl = false;
                if (!$this$checkContentRestriction.canAccessLibrary(it)) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
        }
        if ($this$checkContentRestriction.getRestrictions().isRestricted()) {
            SeriesMetadata it = this.seriesMetadataRepository.findById(seriesId);
            boolean bl = false;
            if (!$this$checkContentRestriction.isContentAllowed(it.getAgeRating(), it.getSharingLabels())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
            }
        }
    }

    private static final SeriesDto getAllSeries$lambda$19(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SeriesDto)$tmp0.invoke(p0);
    }

    private static final SeriesDto getSeriesList$lambda$20(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SeriesDto)$tmp0.invoke(p0);
    }

    private static final SeriesDto getLatestSeries$lambda$44(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SeriesDto)$tmp0.invoke(p0);
    }

    private static final SeriesDto getNewSeries$lambda$49(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SeriesDto)$tmp0.invoke(p0);
    }

    private static final SeriesDto getUpdatedSeries$lambda$54(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SeriesDto)$tmp0.invoke(p0);
    }

    private static final BookDto getAllBooksBySeries$lambda$66(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (BookDto)$tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void getSeriesFile$lambda$78(Collection $books, OutputStream responseStream) {
        Intrinsics.checkNotNullParameter((Object)$books, (String)"$books");
        Intrinsics.checkNotNullParameter((Object)responseStream, (String)"responseStream");
        Closeable closeable = (Closeable)new ZipArchiveOutputStream(responseStream);
        Throwable throwable = null;
        try {
            ZipArchiveOutputStream zipStream = (ZipArchiveOutputStream)closeable;
            boolean bl = false;
            zipStream.setMethod(8);
            zipStream.setLevel(0);
            zipStream.setUseZip64(Zip64Mode.Always);
            Iterable $this$forEach$iv = $books;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Book book = (Book)element$iv;
                boolean bl2 = false;
                FileSystemResource file = new FileSystemResource(book.getPath());
                if (!file.exists()) {
                    SeriesControllerKt.access$getLogger$p().warn((Function0)new /* Unavailable Anonymous Inner Class!! */);
                    continue;
                }
                SeriesControllerKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
                Closeable closeable2 = file.getInputStream();
                Throwable throwable2 = null;
                try {
                    InputStream it = (InputStream)closeable2;
                    boolean bl3 = false;
                    zipStream.putArchiveEntry(new ZipArchiveEntry(file.getFilename()));
                    IOUtils.copyLarge((InputStream)it, (OutputStream)((OutputStream)zipStream), (byte[])new byte[8192]);
                    zipStream.closeArchiveEntry();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

