/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.domain.service;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.model.Book;
import org.gotson.komga.domain.model.BookMetadata;
import org.gotson.komga.domain.model.BookMetadataPatch;
import org.gotson.komga.domain.model.BookMetadataPatchCapability;
import org.gotson.komga.domain.model.BookWithMedia;
import org.gotson.komga.domain.model.DomainEvent;
import org.gotson.komga.domain.model.Library;
import org.gotson.komga.domain.model.Media;
import org.gotson.komga.domain.model.MetadataPatchTarget;
import org.gotson.komga.domain.persistence.BookMetadataRepository;
import org.gotson.komga.domain.persistence.LibraryRepository;
import org.gotson.komga.domain.persistence.MediaRepository;
import org.gotson.komga.domain.service.BookMetadataLifecycleKt;
import org.gotson.komga.domain.service.MetadataApplier;
import org.gotson.komga.domain.service.ReadListLifecycle;
import org.gotson.komga.infrastructure.metadata.BookMetadataProvider;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001BC\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u001a\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0012J\u001e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/gotson/komga/domain/service/BookMetadataLifecycle;", "", "bookMetadataProviders", "", "Lorg/gotson/komga/infrastructure/metadata/BookMetadataProvider;", "metadataApplier", "Lorg/gotson/komga/domain/service/MetadataApplier;", "mediaRepository", "Lorg/gotson/komga/domain/persistence/MediaRepository;", "bookMetadataRepository", "Lorg/gotson/komga/domain/persistence/BookMetadataRepository;", "libraryRepository", "Lorg/gotson/komga/domain/persistence/LibraryRepository;", "readListLifecycle", "Lorg/gotson/komga/domain/service/ReadListLifecycle;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Ljava/util/List;Lorg/gotson/komga/domain/service/MetadataApplier;Lorg/gotson/komga/domain/persistence/MediaRepository;Lorg/gotson/komga/domain/persistence/BookMetadataRepository;Lorg/gotson/komga/domain/persistence/LibraryRepository;Lorg/gotson/komga/domain/service/ReadListLifecycle;Lorg/springframework/context/ApplicationEventPublisher;)V", "handlePatchForBookMetadata", "", "patch", "Lorg/gotson/komga/domain/model/BookMetadataPatch;", "book", "Lorg/gotson/komga/domain/model/Book;", "refreshMetadata", "capabilities", "", "Lorg/gotson/komga/domain/model/BookMetadataPatchCapability;", "komga"})
@SourceDebugExtension(value={"SMAP\nBookMetadataLifecycle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookMetadataLifecycle.kt\norg/gotson/komga/domain/service/BookMetadataLifecycle\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1855#2:93\n1855#2,2:94\n1856#2:96\n*S KotlinDebug\n*F\n+ 1 BookMetadataLifecycle.kt\norg/gotson/komga/domain/service/BookMetadataLifecycle\n*L\n39#1:93\n63#1:94,2\n39#1:96\n*E\n"})
public class BookMetadataLifecycle {
    @NotNull
    private final List<BookMetadataProvider> bookMetadataProviders;
    @NotNull
    private final MetadataApplier metadataApplier;
    @NotNull
    private final MediaRepository mediaRepository;
    @NotNull
    private final BookMetadataRepository bookMetadataRepository;
    @NotNull
    private final LibraryRepository libraryRepository;
    @NotNull
    private final ReadListLifecycle readListLifecycle;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;

    public BookMetadataLifecycle(@NotNull List<? extends BookMetadataProvider> bookMetadataProviders, @NotNull MetadataApplier metadataApplier, @NotNull MediaRepository mediaRepository, @NotNull BookMetadataRepository bookMetadataRepository, @NotNull LibraryRepository libraryRepository, @NotNull ReadListLifecycle readListLifecycle, @NotNull ApplicationEventPublisher eventPublisher) {
        Intrinsics.checkNotNullParameter(bookMetadataProviders, (String)"bookMetadataProviders");
        Intrinsics.checkNotNullParameter((Object)metadataApplier, (String)"metadataApplier");
        Intrinsics.checkNotNullParameter((Object)mediaRepository, (String)"mediaRepository");
        Intrinsics.checkNotNullParameter((Object)bookMetadataRepository, (String)"bookMetadataRepository");
        Intrinsics.checkNotNullParameter((Object)libraryRepository, (String)"libraryRepository");
        Intrinsics.checkNotNullParameter((Object)readListLifecycle, (String)"readListLifecycle");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        this.bookMetadataProviders = bookMetadataProviders;
        this.metadataApplier = metadataApplier;
        this.mediaRepository = mediaRepository;
        this.bookMetadataRepository = bookMetadataRepository;
        this.libraryRepository = libraryRepository;
        this.readListLifecycle = readListLifecycle;
        this.eventPublisher = eventPublisher;
    }

    public void refreshMetadata(@NotNull Book book, @NotNull Set<? extends BookMetadataPatchCapability> capabilities) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        Intrinsics.checkNotNullParameter(capabilities, (String)"capabilities");
        BookMetadataLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        Media media = this.mediaRepository.findById(book.getId());
        Library library = this.libraryRepository.findById(book.getLibraryId());
        boolean changed = false;
        Iterable $this$forEach$iv = this.bookMetadataProviders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BookMetadataPatch bookMetadataPatch;
            BookMetadataProvider provider = (BookMetadataProvider)element$iv;
            boolean bl = false;
            if (CollectionsKt.intersect((Iterable)capabilities, (Iterable)provider.getCapabilities()).isEmpty()) {
                BookMetadataLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
                continue;
            }
            if (!provider.shouldLibraryHandlePatch(library, MetadataPatchTarget.BOOK) && !provider.shouldLibraryHandlePatch(library, MetadataPatchTarget.READLIST)) {
                BookMetadataLifecycleKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
                continue;
            }
            BookMetadataLifecycleKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
            try {
                bookMetadataPatch = provider.getBookMetadataFromBook(new BookWithMedia(book, media));
            }
            catch (Exception e) {
                BookMetadataLifecycleKt.access$getLogger$p().error((Throwable)e, (Function0)new /* Unavailable Anonymous Inner Class!! */);
                bookMetadataPatch = null;
            }
            BookMetadataPatch patch2 = bookMetadataPatch;
            if (provider.shouldLibraryHandlePatch(library, MetadataPatchTarget.BOOK)) {
                this.handlePatchForBookMetadata(patch2, book);
                changed = true;
            }
            if (!provider.shouldLibraryHandlePatch(library, MetadataPatchTarget.READLIST)) continue;
            Object object = patch2;
            if (object == null || (object = object.getReadLists()) == null) continue;
            Iterable $this$forEach$iv2 = (Iterable)object;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                BookMetadataPatch.ReadListEntry readList = (BookMetadataPatch.ReadListEntry)element$iv2;
                boolean bl2 = false;
                this.readListLifecycle.addBookToReadList(readList.getName(), book, readList.getNumber());
            }
        }
        if (changed) {
            this.eventPublisher.publishEvent((Object)new DomainEvent.BookUpdated(book));
        }
    }

    private void handlePatchForBookMetadata(BookMetadataPatch patch2, Book book) {
        block0: {
            BookMetadataPatch bookMetadataPatch = patch2;
            if (bookMetadataPatch == null) break block0;
            BookMetadataPatch bPatch = bookMetadataPatch;
            boolean bl = false;
            BookMetadata it = this.bookMetadataRepository.findById(book.getId());
            boolean bl2 = false;
            BookMetadataLifecycleKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
            BookMetadataLifecycleKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
            BookMetadataLifecycleKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
            BookMetadata patched = this.metadataApplier.apply(bPatch, it);
            BookMetadataLifecycleKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
            this.bookMetadataRepository.update(patched);
        }
    }
}

