/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.domain.service;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.gotson.komga.domain.model.Book;
import org.gotson.komga.domain.model.BookAction;
import org.gotson.komga.domain.model.BookConversionException;
import org.gotson.komga.domain.model.BookPage;
import org.gotson.komga.domain.model.BookPageKt;
import org.gotson.komga.domain.model.BookPageNumbered;
import org.gotson.komga.domain.model.BookWithMedia;
import org.gotson.komga.domain.model.DomainEvent;
import org.gotson.komga.domain.model.HistoricalEvent;
import org.gotson.komga.domain.model.Media;
import org.gotson.komga.domain.model.MediaFile;
import org.gotson.komga.domain.model.MediaNotReadyException;
import org.gotson.komga.domain.model.MediaType;
import org.gotson.komga.domain.model.MediaUnsupportedException;
import org.gotson.komga.domain.model.PageHashKnown;
import org.gotson.komga.domain.persistence.BookRepository;
import org.gotson.komga.domain.persistence.HistoricalEventRepository;
import org.gotson.komga.domain.persistence.LibraryRepository;
import org.gotson.komga.domain.persistence.MediaRepository;
import org.gotson.komga.domain.persistence.PageHashRepository;
import org.gotson.komga.domain.service.BookAnalyzer;
import org.gotson.komga.domain.service.BookPageEditor;
import org.gotson.komga.domain.service.BookPageEditorKt;
import org.gotson.komga.domain.service.FileSystemScanner;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionTemplate;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J \u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0019X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/gotson/komga/domain/service/BookPageEditor;", "", "bookAnalyzer", "Lorg/gotson/komga/domain/service/BookAnalyzer;", "fileSystemScanner", "Lorg/gotson/komga/domain/service/FileSystemScanner;", "bookRepository", "Lorg/gotson/komga/domain/persistence/BookRepository;", "mediaRepository", "Lorg/gotson/komga/domain/persistence/MediaRepository;", "libraryRepository", "Lorg/gotson/komga/domain/persistence/LibraryRepository;", "pageHashRepository", "Lorg/gotson/komga/domain/persistence/PageHashRepository;", "transactionTemplate", "Lorg/springframework/transaction/support/TransactionTemplate;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "historicalEventRepository", "Lorg/gotson/komga/domain/persistence/HistoricalEventRepository;", "(Lorg/gotson/komga/domain/service/BookAnalyzer;Lorg/gotson/komga/domain/service/FileSystemScanner;Lorg/gotson/komga/domain/persistence/BookRepository;Lorg/gotson/komga/domain/persistence/MediaRepository;Lorg/gotson/komga/domain/persistence/LibraryRepository;Lorg/gotson/komga/domain/persistence/PageHashRepository;Lorg/springframework/transaction/support/TransactionTemplate;Lorg/springframework/context/ApplicationEventPublisher;Lorg/gotson/komga/domain/persistence/HistoricalEventRepository;)V", "convertibleTypes", "", "", "failedPageRemoval", "", "removeHashedPages", "Lorg/gotson/komga/domain/model/BookAction;", "book", "Lorg/gotson/komga/domain/model/Book;", "pagesToDelete", "", "Lorg/gotson/komga/domain/model/BookPageNumbered;", "komga"})
@SourceDebugExtension(value={"SMAP\nBookPageEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookPageEditor.kt\norg/gotson/komga/domain/service/BookPageEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,180:1\n777#2:181\n788#2:182\n1864#2,2:183\n789#2,2:185\n1866#2:187\n791#2:188\n1549#2:189\n1620#2,3:190\n1549#2:193\n1620#2,3:194\n1855#2,2:197\n1549#2:199\n1620#2,3:200\n1549#2:203\n1620#2,3:204\n1549#2:207\n1620#2,3:208\n1549#2:211\n1620#2,3:212\n1855#2,2:215\n1747#2,3:217\n1603#2,9:220\n1855#2:229\n1856#2:231\n1612#2:232\n1855#2,2:233\n1#3:230\n*S KotlinDebug\n*F\n+ 1 BookPageEditor.kt\norg/gotson/komga/domain/service/BookPageEditor\n*L\n82#1:181\n82#1:182\n82#1:183,2\n82#1:185,2\n82#1:187\n82#1:188\n107#1:189\n107#1:190,3\n108#1:193\n108#1:194,3\n109#1:197,2\n138#1:199\n138#1:200,3\n139#1:203\n139#1:204,3\n143#1:207\n143#1:208,3\n144#1:211\n144#1:212,3\n174#1:215,2\n177#1:217,3\n170#1:220,9\n170#1:229\n170#1:231\n170#1:232\n171#1:233,2\n170#1:230\n*E\n"})
public class BookPageEditor {
    @NotNull
    private final BookAnalyzer bookAnalyzer;
    @NotNull
    private final FileSystemScanner fileSystemScanner;
    @NotNull
    private final BookRepository bookRepository;
    @NotNull
    private final MediaRepository mediaRepository;
    @NotNull
    private final LibraryRepository libraryRepository;
    @NotNull
    private final PageHashRepository pageHashRepository;
    @NotNull
    private final TransactionTemplate transactionTemplate;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private final HistoricalEventRepository historicalEventRepository;
    @NotNull
    private final List<String> convertibleTypes;
    @NotNull
    private final List<String> failedPageRemoval;

    public BookPageEditor(@NotNull BookAnalyzer bookAnalyzer, @NotNull FileSystemScanner fileSystemScanner, @NotNull BookRepository bookRepository, @NotNull MediaRepository mediaRepository, @NotNull LibraryRepository libraryRepository, @NotNull PageHashRepository pageHashRepository, @NotNull TransactionTemplate transactionTemplate, @NotNull ApplicationEventPublisher eventPublisher, @NotNull HistoricalEventRepository historicalEventRepository) {
        Intrinsics.checkNotNullParameter((Object)bookAnalyzer, (String)"bookAnalyzer");
        Intrinsics.checkNotNullParameter((Object)fileSystemScanner, (String)"fileSystemScanner");
        Intrinsics.checkNotNullParameter((Object)bookRepository, (String)"bookRepository");
        Intrinsics.checkNotNullParameter((Object)mediaRepository, (String)"mediaRepository");
        Intrinsics.checkNotNullParameter((Object)libraryRepository, (String)"libraryRepository");
        Intrinsics.checkNotNullParameter((Object)pageHashRepository, (String)"pageHashRepository");
        Intrinsics.checkNotNullParameter((Object)transactionTemplate, (String)"transactionTemplate");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)historicalEventRepository, (String)"historicalEventRepository");
        this.bookAnalyzer = bookAnalyzer;
        this.fileSystemScanner = fileSystemScanner;
        this.bookRepository = bookRepository;
        this.mediaRepository = mediaRepository;
        this.libraryRepository = libraryRepository;
        this.pageHashRepository = pageHashRepository;
        this.transactionTemplate = transactionTemplate;
        this.eventPublisher = eventPublisher;
        this.historicalEventRepository = historicalEventRepository;
        this.convertibleTypes = CollectionsKt.listOf((Object)MediaType.ZIP.getType());
        this.failedPageRemoval = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public BookAction removeHashedPages(@NotNull Book book, @NotNull Collection<BookPageNumbered> pagesToDelete) {
        boolean bl;
        block37: {
            Iterable $this$mapTo$iv$iv;
            CopyOption[] destination$iv$iv;
            Iterable $this$forEach$iv;
            Object zipStream2;
            Throwable $this$filterIndexedTo$iv$iv;
            Unit unit;
            Intrinsics.checkNotNullParameter((Object)book, (String)"book");
            Intrinsics.checkNotNullParameter(pagesToDelete, (String)"pagesToDelete");
            if (this.failedPageRemoval.contains(book.getId())) {
                BookPageEditorKt.access$getLogger$p().info((Function0)removeHashedPages.1.INSTANCE);
                return null;
            }
            Book book2 = this.fileSystemScanner.scanFile(book.getPath());
            if (book2 != null) {
                Book scannedBook = book2;
                boolean bl2 = false;
                if (LanguageUtilsKt.notEquals$default((LocalDateTime)scannedBook.getFileLastModified(), (LocalDateTime)book.getFileLastModified(), null, (int)2, null)) {
                    BookPageEditorKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
                    return null;
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                throw new FileNotFoundException("File not found: " + book.getPath());
            }
            Media media = this.mediaRepository.findById(book.getId());
            if (!CollectionsKt.contains((Iterable)this.convertibleTypes, (Object)media.getMediaType())) {
                throw new MediaUnsupportedException(media.getMediaType() + " cannot be converted. Must be one of " + this.convertibleTypes, null, 2, null);
            }
            if (media.getStatus() != Media.Status.READY) {
                throw new MediaNotReadyException();
            }
            Iterable $this$filterIndexed$iv = media.getPages();
            boolean $i$f$filterIndexed22 = false;
            Iterable bl2 = $this$filterIndexed$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIndexedTo = false;
            Iterable $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv2 = 0;
            for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                Object v3;
                void element$iv$iv;
                block35: {
                    int n;
                    if ((n = index$iv$iv$iv2++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Object t = item$iv$iv$iv;
                    int index$iv$iv = n;
                    boolean bl3 = false;
                    BookPage bookPage = (BookPage)element$iv$iv;
                    int index = index$iv$iv;
                    boolean bl4 = false;
                    Iterable iterable = pagesToDelete;
                    for (Object t2 : iterable) {
                        void page;
                        BookPageNumbered candidate = (BookPageNumbered)t2;
                        boolean bl5 = false;
                        boolean bl6 = Intrinsics.areEqual((Object)candidate.getFileHash(), (Object)page.getFileHash()) && Intrinsics.areEqual((Object)candidate.getMediaType(), (Object)page.getMediaType()) && Intrinsics.areEqual((Object)candidate.getFileName(), (Object)page.getFileName()) && candidate.getPageNumber() == index + 1;
                        if (!bl6) continue;
                        v3 = t2;
                        break block35;
                    }
                    v3 = null;
                }
                boolean bl7 = v3 == null;
                if (!bl7) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List pagesToKeep = (List)destination$iv$iv2;
            if (media.getPages().size() != pagesToKeep.size() + pagesToDelete.size()) {
                BookPageEditorKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
                return null;
            }
            BookPageEditorKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
            BookPageEditorKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
            BookPageEditorKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
            BookPageEditorKt.access$getLogger$p().debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
            Path tempFile = File.createTempFile("komga_page_removal_", ".tmp", book.getPath().getParent().toFile()).toPath();
            BookPageEditorKt.access$getLogger$p().info((Function0)new /* Unavailable Anonymous Inner Class!! */);
            Intrinsics.checkNotNull((Object)tempFile);
            OpenOption[] openOptionArray = new OpenOption[]{};
            OutputStream outputStream = Files.newOutputStream(tempFile, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            Closeable $i$f$filterIndexed22 = (Closeable)new ZipArchiveOutputStream(outputStream);
            $this$filterIndexedTo$iv$iv = null;
            try {
                Object item$iv$iv;
                Iterable $this$mapTo$iv$iv2;
                Iterable $this$map$iv;
                zipStream2 = (ZipArchiveOutputStream)$i$f$filterIndexed22;
                boolean bl8 = false;
                zipStream2.setMethod(8);
                zipStream2.setLevel(0);
                $this$forEachIndexed$iv$iv$iv = pagesToKeep;
                boolean $i$f$map = false;
                void index$iv$iv$iv2 = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv2.iterator();
                while (iterator.hasNext()) {
                    void it;
                    item$iv$iv = iterator.next();
                    BookPage index$iv$iv = (BookPage)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl9 = false;
                    collection.add(it.getFileName());
                }
                $this$map$iv = media.getFiles();
                Iterable iterable = (List)destination$iv$iv3;
                $i$f$map = false;
                $this$mapTo$iv$iv2 = $this$map$iv;
                destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv2.iterator();
                while (iterator.hasNext()) {
                    item$iv$iv = iterator.next();
                    MediaFile it = (MediaFile)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl10 = false;
                    collection.add(it.getFileName());
                }
                $this$map$iv = CollectionsKt.union((Iterable)iterable, (Iterable)((List)destination$iv$iv3));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String entry = (String)element$iv;
                    boolean bl11 = false;
                    zipStream2.putArchiveEntry(new ZipArchiveEntry(entry));
                    zipStream2.write(this.bookAnalyzer.getFileContent(new BookWithMedia(book, media), entry));
                    zipStream2.closeArchiveEntry();
                }
                zipStream2 = Unit.INSTANCE;
            }
            catch (Throwable zipStream2) {
                $this$filterIndexedTo$iv$iv = zipStream2;
                throw zipStream2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$i$f$filterIndexed22, (Throwable)$this$filterIndexedTo$iv$iv);
            }
            $this$filterIndexedTo$iv$iv = this.fileSystemScanner.scanFile(tempFile);
            if ($this$filterIndexedTo$iv$iv == null || (zipStream2 = Book.copy$default((Book)$this$filterIndexedTo$iv$iv, null, null, null, (long)0L, null, (int)0, (String)book.getId(), (String)book.getSeriesId(), (String)book.getLibraryId(), null, (boolean)false, null, null, (int)7743, null)) == null) {
                throw new IllegalStateException("Newly created book could not be scanned: " + tempFile);
            }
            ZipArchiveOutputStream createdBook = zipStream2;
            Media createdMedia = this.bookAnalyzer.analyze((Book)createdBook, this.libraryRepository.findById(book.getLibraryId()).getAnalyzeDimensions());
            try {
                CopyOption[] copyOptionArray;
                Collection<String> collection;
                Iterable $this$map$iv;
                if (createdMedia.getStatus() != Media.Status.READY) {
                    throw new BookConversionException("Created file could not be analyzed, aborting page removal");
                }
                if (!Intrinsics.areEqual((Object)createdMedia.getMediaType(), (Object)MediaType.ZIP.getType())) {
                    throw new BookConversionException("Created file is not a zip file, aborting page removal");
                }
                zipStream2 = createdMedia.getPages();
                boolean $i$f$map = false;
                $this$forEach$iv = $this$map$iv;
                destination$iv$iv = (CopyOption[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    BookPage bl11 = (BookPage)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl12 = false;
                    collection.add((String)TuplesKt.to((Object)FilenameUtils.getName((String)it.getFileName()), (Object)it.getMediaType()));
                }
                $this$map$iv = pagesToKeep;
                collection = (List)destination$iv$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    BookPage it = (BookPage)item$iv$iv;
                    copyOptionArray = destination$iv$iv;
                    boolean bl13 = false;
                    copyOptionArray.add(TuplesKt.to((Object)FilenameUtils.getName((String)it.getFileName()), (Object)it.getMediaType()));
                }
                if (!collection.containsAll((List)destination$iv$iv)) {
                    throw new BookConversionException("Created file does not contain all pages to keep from existing file, aborting conversion");
                }
                $this$map$iv = createdMedia.getFiles();
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    MediaFile it = (MediaFile)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl14 = false;
                    collection.add(FilenameUtils.getName((String)it.getFileName()));
                }
                $this$map$iv = media.getFiles();
                collection = (List)destination$iv$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    MediaFile it = (MediaFile)item$iv$iv;
                    copyOptionArray = destination$iv$iv;
                    boolean bl15 = false;
                    copyOptionArray.add(FilenameUtils.getName((String)it.getFileName()));
                }
                if (!collection.containsAll((List)destination$iv$iv)) {
                    throw new BookConversionException("Created file does not contain all files from existing file, aborting page removal");
                }
            }
            catch (BookConversionException e) {
                Files.deleteIfExists(tempFile);
                ((Collection)this.failedPageRemoval).add(book.getId());
                throw e;
            }
            Path e = tempFile;
            Path $i$f$map = book.getPath();
            destination$iv$iv = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            CopyOption[] copyOptionArray = destination$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)Files.move(e, $i$f$map, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"move(...)");
            $i$f$map = this.fileSystemScanner.scanFile(book.getPath());
            if ($i$f$map == null || ($this$mapTo$iv$iv = Book.copy$default((Book)$i$f$map, null, null, null, (long)0L, null, (int)0, (String)book.getId(), (String)book.getSeriesId(), (String)book.getLibraryId(), null, (boolean)false, null, null, (int)7743, null)) == null) {
                throw new IllegalStateException("Newly created book could not be scanned after replacing existing one: " + book.getPath());
            }
            Iterable newBook = $this$mapTo$iv$iv;
            Media mediaWithHashes = Media.copy$default((Media)createdMedia, null, null, (List)BookPageKt.restoreHashFrom((Collection)createdMedia.getPages(), (Collection)media.getPages()), (int)0, null, null, null, null, (boolean)false, (boolean)false, null, null, (int)4091, null);
            this.transactionTemplate.executeWithoutResult(arg_0 -> BookPageEditor.removeHashedPages$lambda$13(this, (Book)newBook, mediaWithHashes, pagesToDelete, arg_0));
            $this$forEach$iv = pagesToDelete;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BookPageNumbered it = (BookPageNumbered)element$iv;
                boolean bl16 = false;
                this.historicalEventRepository.insert((HistoricalEvent)new HistoricalEvent.DuplicatePageDeleted(book, it));
            }
            this.eventPublisher.publishEvent((Object)new DomainEvent.BookUpdated((Book)newBook));
            Iterable $this$any$iv = pagesToDelete;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BookPageNumbered it = (BookPageNumbered)element$iv;
                    boolean bl17 = false;
                    if (!(it.getPageNumber() == 1)) continue;
                    bl = true;
                    break block37;
                }
                bl = false;
            }
        }
        return bl ? BookAction.GENERATE_THUMBNAIL : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final void removeHashedPages$lambda$13(BookPageEditor this$0, Book $newBook, Media $mediaWithHashes, Collection $pagesToDelete, TransactionStatus it) {
        void $this$forEach$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$newBook, (String)"$newBook");
        Intrinsics.checkNotNullParameter((Object)$mediaWithHashes, (String)"$mediaWithHashes");
        Intrinsics.checkNotNullParameter((Object)$pagesToDelete, (String)"$pagesToDelete");
        this$0.bookRepository.update($newBook);
        this$0.mediaRepository.update($mediaWithHashes);
        Iterable iterable = $pagesToDelete;
        boolean $i$f$mapNotNull = false;
        Iterator iterator = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PageHashKnown it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            BookPageNumbered it2 = (BookPageNumbered)element$iv$iv;
            boolean bl2 = false;
            if (this$0.pageHashRepository.findKnown(it2.getFileHash()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            PageHashKnown it3 = (PageHashKnown)element$iv;
            boolean bl = false;
            this$0.pageHashRepository.update(PageHashKnown.copy$default((PageHashKnown)it3, null, null, null, (int)(it3.getDeleteCount() + 1), (int)0, (int)23, null));
        }
    }
}

